/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

/* globals AboutCompatBroker, AVAILABLE_SHIMS, CUSTOM_FUNCTIONS,
           listenForRemoteSettingsUpdates,
           Interventions, Shims */

var interventions, shims;

const AVAILABLE_INTERVENTIONS =
{
  "1287715": {
    "label": "littlealchemy2.com",
    "bugs": {
      "1287715": {
        "issue": "broken-audio",
        "matches": ["https://littlealchemy2.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1287715-littlealchemy2.com-fix-audio-race-condition.js"]
        }
      }
    ]
  },
  "1385206": {
    "label": "rakuten.co.jp",
    "bugs": {
      "1385206": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://*.rakuten.co.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["change_Firefox_to_FireFox"]
      }
    ]
  },
  "1448747": {
    "label": "FastClick breakage",
    "bugs": {
      "1829947": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.arcsivr.com/*"]
      },
      "1901449": {
        "issue": "broken-interactive-elements",
        "matches": ["*://teikiyoyaku.tokyu.co.jp/*"]
      },
      "1906654": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.dublinexpress.ie/*"]
      },
      "1913099": {
        "issue": "broken-interactive-elements",
        "matches": ["*://whooshmotorsports.com/*"]
      },
      "1944007": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.discountcoffee.co.uk/*"]
      },
      "1944008": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.franmar.com/*"]
      },
      "1944009": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.iledefrance-mobilites.fr/*"]
      },
      "1944010": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.lafoodbank.org/*"]
      },
      "1944015": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.lawnmowerpartsworld.com/*"]
      },
      "1944018": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.oregonfoodbank.org/*"]
      },
      "1944019": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.themusiclab.org/*"]
      },
      "1944020": {
        "issue": "broken-interactive-elements",
        "matches": ["*://bathpublishing.com/*"]
      },
      "1944022": {
        "issue": "broken-interactive-elements",
        "matches": ["*://drafthouse.com/*"]
      },
      "1944024": {
        "issue": "broken-interactive-elements",
        "matches": ["*://dylantalkstone.com/*"]
      },
      "1916407": {
        "issue": "broken-interactive-elements",
        "matches": ["*://give.umrelief.org/give/*"]
      },
      "1944026": {
        "issue": "broken-interactive-elements",
        "matches": ["*://renewd.com.au/*"]
      },
      "1944027": {
        "issue": "broken-interactive-elements",
        "matches": ["*://rutamayacoffee.com/*"]
      },
      "1944029": {
        "issue": "broken-interactive-elements",
        "matches": ["*://weaversofireland.com/*"]
      },
      "1968640": {
        "issue": "broken-interactive-elements",
        "matches": ["*://shop.ticket-center-hohenschwangau.de/*"]
      },
      "1982550": {
        "issue": "broken-interactive-elements",
        "matches": ["*://www.passline.com/*"]
      },
      "1982801": {
        "issue": "broken-interactive-elements",
        "matches": ["*://www.linguee.de/*"]
      },
      "1986875": {
        "issue": "broken-interactive-elements",
        "matches": ["*://www.electrosport.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "js": ["bug1448747-fastclick-shim.js"]
        }
      }
    ]
  },
  "1458885": {
    "label": "ipstack.com",
    "bugs": {
      "1458885": {
        "issue": "broken-layout",
        "matches": ["*://ipstack.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1458885-ipstack.com-fix-line-break-on-button.css"]
        }
      }
    ]
  },
  "1457335": {
    "label": "histography.io",
    "bugs": {
      "1457335": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://histography.io/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "js": ["bug1457335-histography.io-ua-change.js"]
        }
      }
    ]
  },
  "1472075": {
    "label": "bankofamerica.com",
    "bugs": {
      "1280834": {
        "issue": "unsupported-warning",
        "matches": ["*://*.bankofamerica.com/*"]
      },
      "1899933": {
        "issue": "unsupported-warning",
        "matches": ["*://*.ml.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["mac", "linux"],
        "content_scripts": {
          "js": ["bug1472075-bankofamerica.com-ua-change.js"]
        }
      }
    ]
  },
  "1509873": {
    "label": "zmags.com",
    "bugs": {
      "1509873": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.viewer.zmags.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1570108": {
    "label": "steamcommunity.com",
    "bugs": {
      "1904412": {
        "issue": "blocked-content",
        "matches": ["*://steamcommunity.com/chat*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1574522": {
    "label": "enuri.com",
    "bugs": {
      "1574522": {
        "issue": "incorrect-viewport-dimensions",
        "matches": ["*://enuri.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1574564": {
    "label": "ceskatelevize.cz",
    "bugs": {
      "1574564": {
        "issue": "broken-videos",
        "matches": ["*://*.ceskatelevize.cz/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1575000": {
    "label": "apply.lloydsbank.co.uk",
    "bugs": {
      "1575000": {
        "issue": "broken-interactive-elements",
        "matches": ["*://apply.lloydsbank.co.uk/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1575000-apply.lloydsbank.co.uk-radio-buttons-fix.css"]
        }
      }
    ]
  },
  "1577519": {
    "label": "directv.com",
    "bugs": {
      "1728450": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.directv.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1579159": {
    "label": "m.tailieu.vn",
    "bugs": {
      "1579159": {
        "issue": "page-fails-to-load",
        "matches": ["*://m.tailieu.vn/*", "*://m.elib.vn/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "all_frames": true,
          "js": ["bug1579159-m.tailieu.vn-pdfjs-worker-disable.js"]
        }
      }
    ]
  },
  "1582582": {
    "label": "watch.sling.com",
    "bugs": {
      "1904417": {
        "issue": "firefox-blocked-completely",
        "matches": ["https://watch.sling.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1598198": {
    "label": "galaxy.store",
    "bugs": {
      "1598198": {
        "issue": "broken-redirect",
        "matches": [
          "*://galaxy.store/*",
          "*://dev.galaxy.store/*",
          "*://stg.galaxy.store/*"
        ]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Samsung_for_Samsung_devices"]
      }
    ]
  },
  "1610026": {
    "label": "www.mobilesuica.com",
    "bugs": {
      "1610026": {
        "issue": "firefox-blocked-completely",
        "matches": ["https://www.mobilesuica.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1610344": {
    "label": "directv.com.co",
    "bugs": {
      "1610344": {
        "issue": "unsupported-warning",
        "matches": ["https://*.directv.com.co/*"]
      },
      "1827706": {
        "issue": "unsupported-warning",
        "matches": ["https://*.directv.com.ec/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1610344-directv.com.co-hide-unsupported-message.css"]
        }
      }
    ]
  },
  "1622063": {
    "label": "wp1-ext.usps.gov",
    "bugs": {
      "1622063": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://wp1-ext.usps.gov/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1644830": {
    "label": "usps.com",
    "bugs": {
      "1891016": {
        "issue": "broken-interactive-elements",
        "matches": ["https://*.usps.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1644830-missingmail.usps.com-checkboxes-not-visible.css"]
        }
      }
    ]
  },
  "1646791": {
    "label": "santanderbank.com",
    "bugs": {
      "1646791": {
        "issue": "page-fails-to-load",
        "matches": [
          "*://*.bancosantander.es/*",
          "*://*.gruposantander.es/*",
          "*://*.santander.co.uk/*"
        ]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["cap_Version_to_99", "change_Gecko_to_like_Gecko"]
      }
    ]
  },
  "1651292": {
    "label": "www.jp.square-enix.com",
    "bugs": {
      "1651292": {
        "issue": "page-fails-to-load",
        "matches": ["*://www.jp.square-enix.com/music/sem/page/FF7R/ost/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1666754": {
    "label": "lffl.org",
    "bugs": {
      "1665720": {
        "issue": "slow-performance",
        "matches": ["*://*.lffl.org/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1704673": {
    "label": "app.xiaomi.com",
    "bugs": {
      "1704673": {
        "issue": "broken-redirect",
        "matches": ["*://app.xiaomi.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1712807": {
    "label": "www.dealnews.com",
    "bugs": {
      "1712807": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://www.dealnews.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1719859": {
    "label": "saxoinvestor.fr",
    "bugs": {
      "1719859": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.saxoinvestor.fr/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1724868": {
    "label": "news.yahoo.co.jp",
    "bugs": {
      "1724868": {
        "issue": "broken-videos",
        "matches": ["*://news.yahoo.co.jp/articles/*", "*://s.yimg.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["linux", "android"],
        "content_scripts": {
          "all_frames": true,
          "js": [
            "lib/ua_helpers.js",
            "bug1724868-news.yahoo.co.jp-ua-override.js"
          ]
        }
      }
    ]
  },
  "1739489": {
    "label": "Sites using draft.js",
    "bugs": {
      "1739489": {
        "issue": "broken-editor",
        "matches": ["*://draftjs.org/*", "*://www.facebook.com/*"]
      },
      "1776229": {
        "issue": "broken-editor",
        "matches": [
          "*://mobile.twitter.com/*",
          "*://mobile.x.com/*",
          "*://twitter.com/*",
          "*://x.com/*"
        ]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "skip_if": ["text_event_supported"],
        "content_scripts": {
          "js": ["bug1739489-draftjs-beforeinput.js"]
        }
      }
    ]
  },
  "1741234": {
    "label": "patient.alphalabs.ca",
    "bugs": {
      "1741234": {
        "issue": "broken-layout",
        "matches": ["*://patient.alphalabs.ca/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1741234-patient.alphalabs.ca-height-fix.css"]
        }
      }
    ]
  },
  "1743429": {
    "label": "Sites with issues with Firefox versions over 99",
    "bugs": {
      "1944356": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://411.ca/"]
      },
      "1800241": {
        "issue": "broken-layout",
        "matches": ["*://*.mms.telekom.de/*"]
      },
      "1944355": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://ubank.com.au/*"]
      },
      "1944352": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://wifi.sncf/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["cap_Version_to_99"]
      }
    ]
  },
  "1743627": {
    "label": "renaud-bray.com",
    "bugs": {
      "1743627": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.renaud-bray.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Version_segment"]
      }
    ]
  },
  "1743751": {
    "label": "slrclub.com",
    "bugs": {
      "1743751": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://*.slrclub.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1743754": {
    "label": "workflow.base.vn",
    "bugs": {
      "1743754": {
        "issue": "broken-login",
        "matches": ["*://workflow.base.vn/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1769762": {
    "label": "tiktok.com (broken comments)",
    "bugs": {
      "1769762": {
        "issue": "broken-comments",
        "matches": ["https://www.tiktok.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1769762-tiktok.com-plugins-shim.js"]
        }
      }
    ]
  },
  "1770962": {
    "label": "coldwellbankerhomes.com",
    "bugs": {
      "1770962": {
        "issue": "broken-images",
        "matches": ["*://*.coldwellbankerhomes.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1770962-coldwellbankerhomes.com-image-height.css"]
        }
      }
    ]
  },
  "1771200": {
    "label": "animalplanet.com",
    "bugs": {
      "1771200": {
        "issue": "broken-videos",
        "matches": ["*://*.animalplanet.com/video/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1774005": {
    "label": "Sites relying on window.InstallTrigger",
    "bugs": {
      "1793761": {
        "issue": "broken-layout",
        "matches": ["*://www.schoolnutritionandfitness.com/*"]
      },
      "1806340": {
        "issue": "broken-videos",
        "matches": ["*://ifcinema.institutfrancais.com/*"]
      },
      "1821439": {
        "issue": "broken-login",
        "matches": ["*://islamionline.islamicbank.ps/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "skip_if": ["InstallTrigger_defined"],
        "content_scripts": {
          "all_frames": true,
          "js": ["bug1774005-installtrigger-shim.js"]
        }
      }
    ]
  },
  "1779059": {
    "label": "lazada.co.id",
    "bugs": {
      "1779059": {
        "issue": "broken-map",
        "matches": ["*://member-m.lazada.co.id/address/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1779908": {
    "label": "play.google.com",
    "bugs": {
      "1779908": {
        "issue": "extra-scrollbars",
        "matches": ["*://play.google.com/store/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1779908-play.google.com-scrollbar-fix.css"]
        }
      }
    ]
  },
  "1784361": {
    "label": "coldwellbankerhomes.com",
    "bugs": {
      "1784361": {
        "issue": "broken-images",
        "matches": ["*://*.coldwellbankerhomes.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1793475": {
    "label": "www.unitedwifi.com",
    "bugs": {
      "1793475": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.unitedwifi.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1799968": {
    "label": "www.samsung.com (scrolling fix)",
    "bugs": {
      "1799968": {
        "issue": "broken-scrolling",
        "matches": ["*://www.samsung.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["linux"],
        "content_scripts": {
          "js": ["bug1799968-www.samsung.com-appVersion-linux-fix.js"]
        }
      }
    ]
  },
  "1799980": {
    "label": "healow.com",
    "bugs": {
      "1799980": {
        "issue": "frozen-tab",
        "matches": ["*://healow.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1799980-healow.com-infinite-loop-fix.js"]
        }
      }
    ]
  },
  "1800880": {
    "label": "clipchamp.com",
    "bugs": {
      "1800880": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.clipchamp.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1813177": {
    "label": "rbi.org",
    "bugs": {
      "1813177": {
        "issue": "broken-redirect",
        "matches": ["*://m.rbi.org.in/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1815733": {
    "label": "Office 365 Outlook locations",
    "bugs": {
      "1815733": {
        "issue": "broken-editor",
        "matches": [
          "*://outlook.live.com/*",
          "*://outlook.office.com/*",
          "*://outlook.office365.com/*",
          "*://outlook.office365.us/*",
          "*://*.outlook.cn/*",
          "*://*.outlook.com/*"
        ]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "all_frames": true,
          "js": ["bug1815733-outlook365-clipboard-read-noop.js"]
        }
      }
    ]
  },
  "1818818": {
    "label": "FastClick breakage (legacy)",
    "bugs": {
      "1944004": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.chatiw.com/*"]
      },
      "1818818": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.wellcare.com/*"]
      },
      "1953730": {
        "issue": "broken-interactive-elements",
        "matches": ["*://jobs.jobvite.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "js": ["bug1818818-fastclick-legacy-shim.js"]
        }
      }
    ]
  },
  "1819450": {
    "label": "cmbchina.com",
    "bugs": {
      "1081239": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://www.cmbchina.com/*", "*://cmbchina.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "js": ["bug1819450-cmbchina.com-ua-change.js"]
        }
      }
    ]
  },
  "1819476": {
    "label": "axisbank.com",
    "bugs": {
      "1819476": {
        "issue": "page-fails-to-load",
        "matches": ["*://*.axisbank.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1819476-axisbank.com-webkitSpeechRecognition-shim.js"]
        }
      }
    ]
  },
  "1823966": {
    "label": "elearning.dmv.ca.gov",
    "bugs": {
      "1823785": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.elearning.dmv.ca.gov/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1827678_65753": {
    "label": "admissions.nid.edu",
    "bugs": {
      "1899061": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.admissions.nid.edu/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1827678_68007": {
    "label": "frankfred.com",
    "bugs": {
      "1904411": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://*.frankfred.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1827678_68520": {
    "label": "onvue.com",
    "bugs": {
      "1899057": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.onvue.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1827678_68635": {
    "label": "avizia.com",
    "bugs": {
      "1889520": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.avizia.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1827678_76785": {
    "label": "www.yourtexasbenefits.com",
    "bugs": {
      "1899055": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://www.yourtexasbenefits.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1827678_77727": {
    "label": "www.free4talk.com",
    "bugs": {
      "1899053": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://www.free4talk.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "js": ["bug1819678-free4talk.com-window-chrome-shim.js"]
        },
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1827678_77912": {
    "label": "watch.indee.tv",
    "bugs": {
      "1899052": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://watch.indee.tv/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1827678_80180": {
    "label": "viewer-ebook.books.com.tw",
    "bugs": {
      "1904371": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://viewer-ebook.books.com.tw/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1827678_83269": {
    "label": "jelly.jd.com",
    "bugs": {
      "1899051": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://jelly.jd.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1827678_119012": {
    "label": "kt.com",
    "bugs": {
      "1944036": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.kt.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1827678_119402": {
    "label": "oirsa.org",
    "bugs": {
      "1898953": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.oirsa.org/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1827678_120450": {
    "label": "onp.cloud.waterloo.ca",
    "bugs": {
      "1898947": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://onp.cloud.waterloo.ca/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1830739": {
    "label": "Casino sites",
    "bugs": {
      "1902446": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.casinobrango.com/*"]
      },
      "1902452": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.eternalslots.com/*"]
      },
      "1902453": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.palaceofchance.com/*"]
      },
      "1902471": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.springbokcasino.co.za/*"]
      },
      "1902475": {
        "issue": "firefox-blocked-completely",
        "matches": [
          "*://cdk.fairgocasinowins.com/*",
          "*://cdk.fairgo-pokies.com/*"
        ]
      },
      "1902493": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.ozwincasino.com/*"]
      },
      "1904935": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.rubyslots.com/*"]
      },
      "1944317": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.captainjackcasino.com/*"]
      },
      "1944319": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.casinoextreme.eu/*"]
      },
      "1944320": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.cryptoloko.com/*"]
      },
      "1944324": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.123lobbygames.com/*"]
      },
      "1944321": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.planet7casino.com/*"]
      },
      "1944322": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.yebocasino.co.za/*"]
      },
      "1944323": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.yabbycasino.com/*"]
      },
      "1947963": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.slotmadness.com/*"]
      },
      "1964350": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.bonusblitz.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1830796": {
    "label": "copyleaks.com",
    "bugs": {
      "1898944": {
        "issue": "unsupported-warning",
        "matches": ["*://*.copyleaks.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "all_frames": true,
          "css": ["bug1830796-copyleaks.com-hide-unsupported.css"]
        }
      }
    ]
  },
  "1830821_90981": {
    "label": "enjoy.point.auone.jp",
    "bugs": {
      "1899047": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://enjoy.point.auone.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1830821_113663": {
    "label": "webcartop.jp",
    "bugs": {
      "1944039": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://*.webcartop.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1831007": {
    "label": "All international Nintendo domains",
    "bugs": {
      "1815836": {
        "issue": "broken-login",
        "matches": [
          "*://*.mojenintendo.cz/*",
          "*://*.nintendo-europe.com/*",
          "*://*.nintendo.at/*",
          "*://*.nintendo.be/*",
          "*://*.nintendo.ch/*",
          "*://*.nintendo.co.il/*",
          "*://*.nintendo.co.jp/*",
          "*://*.nintendo.co.kr/*",
          "*://*.nintendo.co.nz/*",
          "*://*.nintendo.co.uk/*",
          "*://*.nintendo.co.za/*",
          "*://*.nintendo.com.au/*",
          "*://*.nintendo.com.hk/*",
          "*://*.nintendo.com/*",
          "*://*.nintendo.de/*",
          "*://*.nintendo.dk/*",
          "*://*.nintendo.es/*",
          "*://*.nintendo.fi/*",
          "*://*.nintendo.fr/*",
          "*://*.nintendo.gr/*",
          "*://*.nintendo.hu/*",
          "*://*.nintendo.it/*",
          "*://*.nintendo.nl/*",
          "*://*.nintendo.no/*",
          "*://*.nintendo.pt/*",
          "*://*.nintendo.ru/*",
          "*://*.nintendo.se/*",
          "*://*.nintendo.sk/*",
          "*://*.nintendo.tw/*",
          "*://*.nintendoswitch.com.cn/*"
        ]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1831007-nintendo-window-OnetrustActiveGroups.js"]
        }
      }
    ]
  },
  "1836103": {
    "label": "autostar-novoross.ru",
    "bugs": {
      "1891078": {
        "issue": "broken-layout",
        "matches": ["*://autostar-novoross.ru/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1836103-autostar-novoross.ru-make-map-taller.css"]
        }
      }
    ]
  },
  "1836105": {
    "label": "cnn.com",
    "bugs": {
      "1830307": {
        "issue": "broken-printing",
        "matches": ["*://*.cnn.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1836105-cnn.com-fix-blank-pages-when-printing.css"]
        }
      }
    ]
  },
  "1836109": {
    "label": "watch.tonton.com.my",
    "bugs": {
      "1898970": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://watch.tonton.com.my/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1836135": {
    "label": "gts-pro.sdimedia.com",
    "bugs": {
      "1898978": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://gts-pro.sdimedia.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1836178": {
    "label": "atracker.pro",
    "bugs": {
      "1905235": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://atracker.pro/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1836872": {
    "label": "docs.google.com",
    "bugs": {
      "1836872": {
        "issue": "broken-layout",
        "matches": ["*://docs.google.com/document/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1836872-docs.google.com-font-submenus-inaccessible.css"]
        }
      }
    ]
  },
  "1841730": {
    "label": "www.korg.com",
    "bugs": {
      "1841730": {
        "issue": "page-fails-to-load",
        "matches": ["*://www.korg.com/*/support/download/product/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["windows"],
        "pref_check": { "timer.auto_increase_timer_resolution": false },
        "content_scripts": {
          "js": ["bug1841730-www.korg.com-fix-broken-page-loads.js"]
        }
      }
    ]
  },
  "1842437": {
    "label": "YouTube back/forward fix",
    "bugs": {
      "1842437": {
        "issue": "user-interface-frustration",
        "matches": ["*://www.youtube.com/*"]
      },
      "1964603": {
        "issue": "user-interface-frustration",
        "matches": ["*://m.youtube.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1842437-www.youtube.com-performance-now-precision.js"]
        }
      }
    ]
  },
  "1842767": {
    "label": "passport.bilibili.com",
    "bugs": {
      "1842767": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://*.passport.bilibili.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1845299": {
    "label": "Google Slides",
    "bugs": {
      "1845299": {
        "issue": "extra-scrollbars",
        "matches": ["*://docs.google.com/presentation/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": [
            "bug1845299-docs.google.com-hide-extra-scrollbar-on-speaker-notes.css"
          ]
        }
      }
    ]
  },
  "1846742": {
    "label": "microsoft.com",
    "bugs": {
      "1846742": {
        "issue": "broken-interactive-elements",
        "matches": ["*://www.microsoft.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "js": ["bug1846742-microsoft.com-search-key-fix.js"]
        }
      }
    ]
  },
  "1847971": {
    "label": "ebay.com",
    "bugs": {
      "1847971": {
        "issue": "blocked-content",
        "matches": ["*://www.ebay.com/sl/prelist/suggest*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "js": ["bug1847971-ebay.com-barcode-scanner.js"]
        }
      }
    ]
  },
  "1848713": {
    "label": "cleanrider.com",
    "bugs": {
      "1848713": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.cleanrider.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1848713-cleanrider.com-slider.css"]
        }
      }
    ]
  },
  "1848849": {
    "label": "theaa.com",
    "bugs": {
      "1848849": {
        "issue": "broken-printing",
        "matches": ["*://*.theaa.com/route-planner/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1848849-theaa.com-printing-mode-fix.css"]
        }
      }
    ]
  },
  "1850998": {
    "label": "chaturbate.com",
    "bugs": {
      "1850998": {
        "issue": "user-interface-frustration",
        "matches": ["*://*.chaturbate.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "js": ["bug1850998-chaturbate.com.js"]
        }
      }
    ]
  },
  "1855014": {
    "label": "eksiseyler.com",
    "bugs": {
      "1855014": {
        "issue": "broken-images",
        "matches": ["*://eksiseyler.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "js": ["bug1855014-eksiseyler.com.js"]
        }
      }
    ]
  },
  "1855088": {
    "label": "hrmis2.eghrmis.gov.my",
    "bugs": {
      "1898930": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://hrmis2.eghrmis.gov.my/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["change_Firefox_to_FireFox"]
      }
    ]
  },
  "1855102": {
    "label": "my.southerncross.co.nz",
    "bugs": {
      "1898940": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://my.southerncross.co.nz/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1856915": {
    "label": "login.yahoo.com",
    "bugs": {
      "1856915": {
        "issue": "broken-layout",
        "matches": ["*://login.yahoo.com/account/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "css": ["bug1856915-login.yahoo.com-unhide-password-button-fix.css"]
        }
      }
    ]
  },
  "1859617": {
    "label": "Sites relying on there being no window.InstallTrigger",
    "bugs": {
      "1854165": {
        "issue": "broken-printing",
        "matches": ["*://*.stallionexpress.ca/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "skip_if": ["InstallTrigger_undefined"],
        "content_scripts": {
          "all_frames": true,
          "js": ["bug1859617-installtrigger-removal-shim.js"]
        }
      }
    ]
  },
  "1860417": {
    "label": "www.samsung.com (images fix)",
    "bugs": {
      "1860417": {
        "issue": "broken-images",
        "matches": ["*://www.samsung.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "js": ["bug1799968-www.samsung.com-appVersion-linux-fix.js"]
        }
      }
    ]
  },
  "1864999": {
    "label": "autotrader.ca",
    "bugs": {
      "1864999": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.autotrader.ca/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1865000": {
    "label": "bmo.com",
    "bugs": {
      "1898919": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.bmo.com/main/personal/*/getting-started/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1865004": {
    "label": "digimart.net",
    "bugs": {
      "1865004": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://*.digimart.net/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1865007": {
    "label": "portal.circle.ms",
    "bugs": {
      "1865007": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://*.circle.ms/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1873166": {
    "label": "nsandi.com",
    "bugs": {
      "1873166": {
        "issue": "unsupported-warning",
        "matches": ["*://*.nsandi.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "css": ["bug1873166-nsandi.com-hide-unsupported-message.css"]
        }
      }
    ]
  },
  "1878024": {
    "label": "g1.globo.com",
    "bugs": {
      "1878024": {
        "issue": "broken-layout",
        "matches": ["*://g1.globo.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "js": ["bug1878024-g1.globo.com-fix-account-icon.js"]
        }
      }
    ]
  },
  "1884779": {
    "label": "memurlar.net",
    "bugs": {
      "1884779": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://*.memurlar.net/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1886293": {
    "label": "Future PLC websites",
    "bugs": {
      "1886293": {
        "issue": "extra-scrollbars",
        "matches": [
          "*://*.androidcentral.com/*",
          "*://*.creativebloq.com/*",
          "*://*.cyclingnews.com/*",
          "*://*.gamesradar.com/*",
          "*://*.imore.com/*",
          "*://*.itpro.com/*",
          "*://*.laptopmag.com/*",
          "*://*.livescience.com/*",
          "*://*.loudersound.com/*",
          "*://*.musicradar.com/*",
          "*://*.pcgamer.com/*",
          "*://*.space.com/*",
          "*://*.techradar.com/*",
          "*://*.tomshardware.com/*",
          "*://*.windowscentral.com/*"
        ]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1886293-futurePLC-sites-trending_scrollbars.css"]
        }
      }
    ]
  },
  "1886566": {
    "label": "quezoncity.gov.ph",
    "bugs": {
      "1886566": {
        "issue": "broken-layout",
        "matches": ["*://qceservices.quezoncity.gov.ph/qcvaxeasy*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1886566-quezoncity.gov.ph-iframe-height.css"]
        }
      }
    ]
  },
  "1886616": {
    "label": "www.six-group.com",
    "bugs": {
      "1886616": {
        "issue": "broken-interactive-elements",
        "matches": [
          "*://www.six-group.com/*/market-data/etf/etf-explorer.html*"
        ]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "max_version": 142,
        "content_scripts": {
          "css": ["bug1886616-www.six-group.com-select-fix.css"]
        }
      }
    ]
  },
  "1889326": {
    "label": "Office 365 email handling prompt",
    "bugs": {
      "1709653": {
        "issue": "user-interface-frustration",
        "matches": [
          "*://*.live.com/*",
          "*://*.office.com/*",
          "*://*.office365.com/*",
          "*://*.office365.us/*",
          "*://*.outlook.cn/*",
          "*://*.outlook.com/*",
          "*://*.sharepoint.com/*"
        ]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "all_frames": true,
          "js": ["bug1889326-office365-email-handling-prompt-autohide.js"]
        }
      }
    ]
  },
  "1889505": {
    "label": "bankmandiri.co.id",
    "bugs": {
      "1899059": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.bankmandiri.co.id/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      },
      {
        "platforms": ["android"],
        "content_scripts": {
          "js": ["bug1889505-bankmandiri.co.id-window.chrome.js"]
        }
      }
    ]
  },
  "1892073": {
    "label": "snapchat.com",
    "bugs": {
      "1892073": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.snapchat.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "only_channels": ["nightly"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1899048": {
    "label": "datanyze.com",
    "bugs": {
      "1899048": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://www.datanyze.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1894308": {
    "label": "dingtalk.com",
    "bugs": {
      "1894308": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.dingtalk.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1895051": {
    "label": "www.zhihu.com",
    "bugs": {
      "1895051": {
        "issue": "broken-interactive-elements",
        "matches": ["*://www.zhihu.com/question/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1895051-www.zhihu.com-broken-button-fix.css"]
        }
      }
    ]
  },
  "1895997": {
    "label": "e.seb.lt",
    "bugs": {
      "1895997": {
        "issue": "unsupported-warning",
        "matches": ["*://e.seb.lt/ib/login*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1895997-e.seb.lt-prevent-unsupported-warning.js"]
        }
      }
    ]
  },
  "1896349": {
    "label": "vivaldi.com",
    "bugs": {
      "1896349": {
        "issue": "broken-interactive-elements",
        "matches": ["*://vivaldi.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1896349-vivaldi.com-selected-text-fix.css"]
        }
      }
    ]
  },
  "1896354": {
    "label": "my.rhinoshield.fr",
    "bugs": {
      "1896354": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://my.rhinoshield.fr/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1896571": {
    "label": "gracobaby.ca",
    "bugs": {
      "1896571": {
        "issue": "broken-scrolling",
        "matches": ["*://www.gracobaby.ca/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "pref_check": { "layout.css.webkit-fill-available.enabled": false },
        "content_scripts": {
          "css": ["bug1896571-gracobaby.ca-unlock-scrolling.css"]
        }
      }
    ]
  },
  "1897724": {
    "label": "app.homewyse.com",
    "bugs": {
      "1897724": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://app.homewyse.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1897941": {
    "label": "biodiscover.com",
    "bugs": {
      "1897941": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://biodiscover.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1898895": {
    "label": "eslatam.trygalaxy.com",
    "bugs": {
      "1898895": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://eslatam.trygalaxy.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1898904": {
    "label": "indigo.shireburn.com",
    "bugs": {
      "1898904": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://indigo.shireburn.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1898909": {
    "label": "remotasks.com",
    "bugs": {
      "1898909": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.remotasks.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1898911": {
    "label": "forms.ontariodrugbenefit.ca",
    "bugs": {
      "1898911": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://forms.ontariodrugbenefit.ca/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1898915": {
    "label": "africanews.com",
    "bugs": {
      "1898915": {
        "issue": "unsupported-warning",
        "matches": ["*://locator.dhl.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1898915-locator.dhl.com-hide-unsupported.css"]
        }
      }
    ]
  },
  "1898917": {
    "label": "sekowf.wns.com",
    "bugs": {
      "1898917": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://sekowf.wns.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1898923": {
    "label": "trade-in.vodafone.com",
    "bugs": {
      "1898923": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://trade-in.vodafone.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1898926": {
    "label": "dgslms.aduacademy.in",
    "bugs": {
      "1898926": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://dgslms.aduacademy.in/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1898928": {
    "label": "cleanfeed.net",
    "bugs": {
      "1898928": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://cleanfeed.net/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1898929": {
    "label": "app.sessionlinkpro.com",
    "bugs": {
      "1898929": {
        "issue": "unsupported-warning",
        "matches": ["*://app.sessionlinkpro.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": [
            "lib/ua_helpers.js",
            "bug1898929-app.sessionlinkpro.com-spoof-user-agent.js"
          ]
        }
      }
    ]
  },
  "1898931": {
    "label": "facturador.afip.gob.ar",
    "bugs": {
      "1898931": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://facturador.afip.gob.ar/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1898932": {
    "label": "account.gov.il",
    "bugs": {
      "1898932": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://account.gov.il/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1898934": {
    "label": "tza.red",
    "bugs": {
      "1898934": {
        "issue": "unsupported-warning",
        "matches": ["*://tza.red/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["change_Firefox_to_FireFox"]
      }
    ]
  },
  "1898935": {
    "label": "mysunlife.sunlife.com.hk",
    "bugs": {
      "1898935": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://mysunlife.sunlife.com.hk/ClientAppWeb/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1898937": {
    "label": "goodyearfiaetrc.com",
    "bugs": {
      "1898937": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://www.goodyearfiaetrc.com/standings*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1898938": {
    "label": "conference.amwell.com",
    "bugs": {
      "1898938": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://conference.amwell.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1898939": {
    "label": "smartgpseco.com",
    "bugs": {
      "1898939": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://www.smartgpseco.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1898941": {
    "label": "events.webinar.ru",
    "bugs": {
      "1898941": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://events.webinar.ru/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1898943": {
    "label": "carelink.minimed.eu",
    "bugs": {
      "1898943": {
        "issue": "unsupported-warning",
        "matches": ["*://carelink.minimed.eu/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["Safari_with_FxQuantum"]
      }
    ]
  },
  "1898946": {
    "label": "transcrib.io",
    "bugs": {
      "1898946": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://transcrib.io/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1898946-transcrib.io-chrome-shim.js"]
        }
      }
    ]
  },
  "1898949": {
    "label": "my.murj.com",
    "bugs": {
      "1898949": {
        "issue": "unsupported-warning",
        "matches": ["*://my.murj.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1898952": {
    "label": "digits.t-mobile.com",
    "bugs": {
      "1898952": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://digits.t-mobile.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "js": ["bug1898952-digits.t-mobile.com.js"]
        }
      }
    ]
  },
  "1898960": {
    "label": "hrm.online.comarch.pl",
    "bugs": {
      "1898960": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://hrm.online.comarch.pl/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1898963": {
    "label": "england.nhs.attendanywhere.com",
    "bugs": {
      "1898963": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://england.nhs.attendanywhere.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1898988": {
    "label": "prudential.com.hk",
    "bugs": {
      "1898988": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.prudential.com.hk/*"]
      }
    },
    "interventions": [
      {
        "not_platforms": ["linux"],
        "ua_string": ["add_Chrome"]
      },
      {
        "platforms": ["linux"],
        "ua_string": ["add_Chrome", "change_OS_to_MacOSX"]
      }
    ]
  },
  "1898989": {
    "label": "mymsc.com",
    "bugs": {
      "1898989": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.mymsc.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1898994": {
    "label": "eportal.uestc.edu.cn",
    "bugs": {
      "1898994": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://eportal.uestc.edu.cn/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1898996": {
    "label": "oculus.com and meta.com",
    "bugs": {
      "1898996": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.oculus.com/cast*", "*://horizon.meta.com/casting*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "js": ["bug1898996-oculus.com-chrome-shims.js"]
        },
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1899049": {
    "label": "bcbs.pinpointglobal.com",
    "bugs": {
      "1899049": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://bcbs.pinpointglobal.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1899054": {
    "label": "icorrectproof.com",
    "bugs": {
      "1899054": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://www.icorrectproof.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "skip_if": ["InstallTrigger_undefined"],
        "content_scripts": {
          "js": ["bug1859617-installtrigger-removal-shim.js"]
        }
      }
    ]
  },
  "1899060": {
    "label": "wbte.drcedirect.com",
    "bugs": {
      "1899060": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://wbte.drcedirect.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1899063": {
    "label": "onlinestep.pgc.edu",
    "bugs": {
      "1899063": {
        "issue": "unsupported-warning",
        "matches": ["*://onlinestep.pgc.edu/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1899063-onlinestep.pgc.edu-hide-unsupported-message.css"]
        }
      }
    ]
  },
  "1899065": {
    "label": "CenterParcs UK and Ireland",
    "bugs": {
      "1899065": {
        "issue": "unsupported-warning",
        "matches": ["*://*.centerparcs.co.uk/*"]
      },
      "1902410": {
        "issue": "unsupported-warning",
        "matches": ["*://*.centerparcs.ie/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1899065-centerparcs-hide-unsupported-warning.css"]
        }
      }
    ]
  },
  "1899066": {
    "label": "bookcreator.com",
    "bugs": {
      "1899066": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://app.bookcreator.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1899067": {
    "label": "game.granbluefantasy.jp",
    "bugs": {
      "1899067": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://game.granbluefantasy.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1899072": {
    "label": "passpoint.boingo.com",
    "bugs": {
      "1899072": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://passpoint.boingo.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome_with_FxQuantum", "mimic_Android_Hotspot2_device"]
      },
      {
        "platforms": ["linux", "mac"],
        "ua_string": ["add_Safari"]
      }
    ]
  },
  "1899829": {
    "label": "animeflv.net",
    "bugs": {
      "1899829": {
        "issue": "broken-images",
        "matches": ["*://www3.animeflv.net/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1899829-animeflv.net-fix-premiere-labels.css"]
        }
      }
    ]
  },
  "1899923": {
    "label": "findmy.tokyo",
    "bugs": {
      "1899923": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://findmy.tokyo/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1899929": {
    "label": "selecionases.saude.pe.gov.br",
    "bugs": {
      "1899929": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://selecionases.saude.pe.gov.br/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1899930": {
    "label": "africanews.com",
    "bugs": {
      "1899930": {
        "issue": "unsupported-warning",
        "matches": ["*://www.africanews.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "css": ["bug1899930-africanews.com-hide-unsupported.css"]
        }
      }
    ]
  },
  "1899932": {
    "label": "ct-tc.apps.cic.gc.ca",
    "bugs": {
      "1899932": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://ct-tc.apps.cic.gc.ca/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1899945": {
    "label": "nytimes.com Modern Love Questions",
    "bugs": {
      "1899945": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://www.nytimes.com/interactive/projects/modern-love/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1899948": {
    "label": "tv.partner.co.il",
    "bugs": {
      "1899948": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://tv.partner.co.il/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1901000": {
    "label": "eyebuydirect.ca",
    "bugs": {
      "1901000": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.eyebuydirect.ca/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "max_version": 134,
        "content_scripts": {
          "css": ["bug1901000-eyebuydirect.ca-fix-paypal-button.css"]
        }
      }
    ]
  },
  "1901780": {
    "label": "vanbreda-health.be",
    "bugs": {
      "1901780": {
        "issue": "frozen-tab",
        "matches": ["*://www.vanbreda-health.be/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1901780-disable-legacy-mutation-events.js"]
        }
      }
    ]
  },
  "1902367": {
    "label": "seller.kuajingmaihuo.com",
    "bugs": {
      "1902367": {
        "issue": "unsupported-warning",
        "matches": ["*://seller.kuajingmaihuo.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1902378": {
    "label": "acesso.processo.rio",
    "bugs": {
      "1902378": {
        "issue": "unsupported-warning",
        "matches": ["*://acesso.processo.rio/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1902379": {
    "label": "adl.edu.tw",
    "bugs": {
      "1902379": {
        "issue": "unsupported-warning",
        "matches": ["*://adl.edu.tw/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": [
            "lib/ua_helpers.js",
            "bug1902379-adl.edu.tw-hide-unsupported-popup.js"
          ]
        }
      }
    ]
  },
  "1902382": {
    "label": "flash.puffin.com",
    "bugs": {
      "1902382": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://flash.puffin.com/store/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1902383": {
    "label": "wpartner.wemakeprice.com",
    "bugs": {
      "1902383": {
        "issue": "unsupported-warning",
        "matches": ["*://wpartner.wemakeprice.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1902383-wpartner.wemakeprice.com-hide-recommendation.css"]
        }
      }
    ]
  },
  "1902385": {
    "label": "bithumb.com",
    "bugs": {
      "1902385": {
        "issue": "unsupported-warning",
        "matches": ["*://www.bithumb.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1902385-www.bithumb.com-hide-unsupported.css"]
        }
      }
    ]
  },
  "1902388": {
    "label": "clinic.platomedical.com",
    "bugs": {
      "1902388": {
        "issue": "unsupported-warning",
        "matches": ["*://clinic.platomedical.com/login*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1902388-clinic.platomedical.com-hide-recommendation.css"]
        }
      }
    ]
  },
  "1902389": {
    "label": "store.91app.com",
    "bugs": {
      "1902389": {
        "issue": "unsupported-warning",
        "matches": ["*://store.91app.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1902390": {
    "label": "app.rnova.org",
    "bugs": {
      "1902390": {
        "issue": "unsupported-warning",
        "matches": ["*://app.rnova.org/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1902395": {
    "label": "bancoentrerios.com.ar",
    "bugs": {
      "1902395": {
        "issue": "unsupported-warning",
        "matches": ["*://www.bancoentrerios.com.ar/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": [
            "bug1902395-www.bancoentrerios.com.ar-hide-browser-warning.css"
          ]
        }
      }
    ]
  },
  "1902396": {
    "label": "clinicaonline.co.il",
    "bugs": {
      "1902396": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://www.clinicaonline.co.il/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1902397": {
    "label": "e-src.net",
    "bugs": {
      "1902397": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://www.e-src.net/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1902398": {
    "label": "cloud-login.sigmacare.com",
    "bugs": {
      "1902398": {
        "issue": "unsupported-warning",
        "matches": ["*://cloud-login.sigmacare.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": [
            "bug1902398-cloud-login.sigmacare.com-hide-unsupported-message.css"
          ]
        }
      }
    ]
  },
  "1902399": {
    "label": "recochoku.jp",
    "bugs": {
      "1902399": {
        "issue": "unsupported-warning",
        "matches": ["*://recochoku.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1902399-recochoku.jp-hide-unsupported-browser-warning.js"]
        }
      }
    ]
  },
  "1902400": {
    "label": "sales-crowd.jp",
    "bugs": {
      "1902400": {
        "issue": "unsupported-warning",
        "matches": ["*://sales-crowd.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1902403": {
    "label": "musicstore.auone.jp",
    "bugs": {
      "1385206": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://musicstore.auone.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1902404": {
    "label": "pss.perodua.com.my",
    "bugs": {
      "1902404": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://pss.perodua.com.my/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1902405": {
    "label": "soffice.11st.co.kr",
    "bugs": {
      "1902405": {
        "issue": "unsupported-warning",
        "matches": ["*://soffice.11st.co.kr/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1902405-soffice.11st.co.kr-hide-browser-warning.css"]
        }
      }
    ]
  },
  "1902406": {
    "label": "sp.hi.co.kr",
    "bugs": {
      "1902406": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://sp.hi.co.kr/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1902406-sp.hi.co.kr-window-chrome-shim.js"]
        }
      }
    ]
  },
  "1902407": {
    "label": "www.sigadoc.mt.gov.br",
    "bugs": {
      "1902407": {
        "issue": "unsupported-warning",
        "matches": ["*://www.sigadoc.mt.gov.br/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": [
            "lib/ua_helpers.js",
            "bug1902407-www.sigadoc.mt.gov.br-user-agent-spoof.js"
          ]
        }
      }
    ]
  },
  "1902408": {
    "label": "mgr.knowbe.jp",
    "bugs": {
      "1902408": {
        "issue": "unsupported-warning",
        "matches": ["*://mgr.knowbe.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1902411": {
    "label": "agent.foundi.info",
    "bugs": {
      "1902411": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://agent.foundi.info/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1902412": {
    "label": "esampark.wondercement.com",
    "bugs": {
      "1902412": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://esampark.wondercement.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1902413": {
    "label": "ibanka.seb.lv",
    "bugs": {
      "1902413": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://ibanka.seb.lv/*login*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1902414": {
    "label": "e.seb.ee",
    "bugs": {
      "1902414": {
        "issue": "unsupported-warning",
        "matches": ["*://e.seb.ee/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1902415": {
    "label": "kaigetsu.staysee.jp",
    "bugs": {
      "1902415": {
        "issue": "unsupported-warning",
        "matches": ["*://kaigetsu.staysee.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1902415-kaigetsu.staysee.jp-hide-unsupported.css"]
        }
      }
    ]
  },
  "1902416": {
    "label": "acionafacil.com.br",
    "bugs": {
      "1902416": {
        "issue": "unsupported-warning",
        "matches": ["*://www.acionafacil.com.br/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": [
            "bug1902416-www.acionafacil.com.br-prevent-unsupported-alert.js"
          ]
        }
      }
    ]
  },
  "1902419": {
    "label": "jamsune.com",
    "bugs": {
      "1902419": {
        "issue": "unsupported-warning",
        "matches": ["*://www.jamsune.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "all_frames": true,
          "js": ["bug1902419-www.jamsune.com-prevent-unsupported-alert.js"]
        }
      }
    ]
  },
  "1902459": {
    "label": "coupangplay.com",
    "bugs": {
      "1902459": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.coupangplay.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1902464": {
    "label": "workhub.transcribeme.com",
    "bugs": {
      "1902464": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://workhub.transcribeme.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1902474": {
    "label": "lg.jio.com",
    "bugs": {
      "1902474": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://lg.jio.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["desktop_not_mobile"]
      }
    ]
  },
  "1902478": {
    "label": "La Personnelle and Desjardins General insurance",
    "bugs": {
      "1902477": {
        "issue": "blocked-content",
        "matches": ["*://*.thepersonal.com/*"]
      },
      "1902478": {
        "issue": "blocked-content",
        "matches": ["*://*.lapersonnelle.com/*"]
      },
      "1902483": {
        "issue": "blocked-content",
        "matches": ["*://*.desjardinsgeneralinsurance.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1902501": {
    "label": "ads.tiktok.com",
    "bugs": {
      "1902501": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://ads.tiktok.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1902506": {
    "label": "mp3cut.net",
    "bugs": {
      "1909448": {
        "issue": "blocked-content",
        "matches": ["*://mp3cut.net/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1902527": {
    "label": "app.gather.town",
    "bugs": {
      "1902527": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://app.gather.town/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1902596": {
    "label": "kuzefukuandsons.com",
    "bugs": {
      "1902596": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://kuzefukuandsons.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1960294": {
    "label": "firstenergycorp.com",
    "bugs": {
      "1960294": {
        "issue": "unsupported-warning",
        "matches": ["*://www.firstenergycorp.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "css": ["bug1960294-firstenergycorp.com-hide-unsupported.css"]
        }
      }
    ]
  },
  "1903480": {
    "label": "ace7.acecombat.jp",
    "bugs": {
      "1903480": {
        "issue": "broken-scrolling",
        "matches": ["*://ace7.acecombat.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "js": ["bug1903480-ace7.acecombat.jp-slow-down-scrolling.js"]
        }
      }
    ]
  },
  "1904952": {
    "label": "idserver.servizicie.interno.gov.it",
    "bugs": {
      "1904952": {
        "issue": "blocked-content",
        "matches": ["*://*.idserver.servizicie.interno.gov.it/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "js": [
            "lib/ua_helpers.js",
            "bug1904952-idserver.servizicie.interno.gov.it-spoof-as-chrome.js"
          ]
        }
      }
    ]
  },
  "1905069": {
    "label": "one.geekie.com.br",
    "bugs": {
      "1905069": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://one.geekie.com.br/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "js": ["bug1905069-one.geekie.com.br-chrome-shims.js"]
        }
      }
    ]
  },
  "1905607": {
    "label": "10play.com.au",
    "bugs": {
      "1905607": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://10play.com.au/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1905885": {
    "label": "playlist-manager.com",
    "bugs": {
      "1905885": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://playlist-manager.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1906630": {
    "label": "watch.foxtel.com.au",
    "bugs": {
      "1906630": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://watch.foxtel.com.au/app/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1907062": {
    "label": "upload-images.jianshu.io",
    "bugs": {
      "1907062": {
        "issue": "broken-images",
        "matches": ["*://upload-images.jianshu.io/upload_images/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1908636": {
    "label": "xmgl.ccccltd.cn",
    "bugs": {
      "1908636": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://xmgl.ccccltd.cn/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1911243": {
    "label": "tsu-results.rf.gd",
    "bugs": {
      "1911243": {
        "issue": "broken-layout",
        "matches": ["*://tsu-results.rf.gd/tsu_results/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1911243-tsu-results.rf.gd-fix-table-headers.css"]
        }
      }
    ]
  },
  "1911253": {
    "label": "qq.com",
    "bugs": {
      "1911253": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.qq.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "all_frames": true,
          "css": ["bug1911253-qq.com-unhide-checkboxes.css"]
        }
      }
    ]
  },
  "1912923": {
    "label": "class.com",
    "bugs": {
      "1951358": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.class.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1913720": {
    "label": "CitrusLab",
    "bugs": {
      "1913720": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://cotota.app/*", "https://is-sets.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1913744": {
    "label": "confetti.buzz",
    "bugs": {
      "1913744": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://confetti.buzz/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1913759": {
    "label": "playblackdesert.com",
    "bugs": {
      "1913759": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://eu-trade.naeu.playblackdesert.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1914565": {
    "label": "myassurity.com",
    "bugs": {
      "1914565": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://myassurity.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1914327": {
    "label": "media.qdnd.vn",
    "bugs": {
      "1914327": {
        "issue": "broken-videos",
        "matches": ["*://media.qdnd.vn/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1915541": {
    "label": "app.sunroom.so",
    "bugs": {
      "1915541": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://app.sunroom.so/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1916900": {
    "label": "vuemotion.santacasaba.org.br",
    "bugs": {
      "1916900": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://vuemotion.santacasaba.org.br/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1918604": {
    "label": "g1.globo.com Ca??a Palavras",
    "bugs": {
      "1918604": {
        "issue": "broken-layout",
        "matches": ["*://g1.globo.com/jogos/caca-palavras/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1918604-g1.globo.com-fix-clipped-buttons.css"]
        }
      }
    ]
  },
  "1918995": {
    "label": "calculator.net",
    "bugs": {
      "1918995": {
        "issue": "user-interface-frustration",
        "matches": ["*://www.calculator.net/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "css": ["bug1918995-calculator.net-hide-copypaste-ui-for-buttons.css"]
        }
      }
    ]
  },
  "1919004": {
    "label": "www.editoracontexto.com.br",
    "bugs": {
      "1919004": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://www.editoracontexto.com.br/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1919263": {
    "label": "www.nbcsports.com",
    "bugs": {
      "1919263": {
        "issue": "broken-layout",
        "matches": ["*://www.nbcsports.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1919263-nbcsports.com-getCurrentUser-script-error-fix.js"]
        }
      }
    ]
  },
  "1922498": {
    "label": "ilgeniodellapizza.com",
    "bugs": {
      "1922498": {
        "issue": "broken-scrolling",
        "matches": ["*://www.ilgeniodellapizza.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "js": ["bug1922498-www.ilgeniodellapizza.com-fix-broken-scrolling.js"]
        }
      }
    ]
  },
  "1923656": {
    "label": "ipmph.com",
    "bugs": {
      "1923656": {
        "issue": "page-fails-to-load",
        "matches": ["*://*.ipmph.com/#/bookPreview*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1924334": {
    "label": "netpets.com",
    "bugs": {
      "1924334": {
        "issue": "broken-layout",
        "matches": ["*://www.neopets.com/explore.phtml*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "css": ["bug1924334-neopets.com-fix-content-width.css"]
        }
      }
    ]
  },
  "1925276": {
    "label": "xtralife.com",
    "bugs": {
      "1925276": {
        "issue": "broken-layout",
        "matches": ["*://www.xtralife.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1925276-xtralife.com-fix-search-results.css"]
        }
      }
    ]
  },
  "1924441": {
    "label": "contractorinduction.colesgroup.com.au",
    "bugs": {
      "1924441": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://contractorinduction.colesgroup.com.au/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1925508": {
    "label": "developer.apple.com",
    "bugs": {
      "1925508": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://developer.apple.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "pref_check": { "layout.css.prefixes.transforms": true },
        "content_scripts": {
          "css": ["bug1925508-developer-apple.com-transform-scale.css"]
        }
      }
    ]
  },
  "1925937": {
    "label": "gazetasp.com.br",
    "bugs": {
      "1925937": {
        "issue": "extra-scrollbars",
        "matches": ["*://www.gazetasp.com.br/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1925937-gazetasp.com.br-hide-extra-scrollbars.css"]
        }
      }
    ]
  },
  "1926501": {
    "label": "iwebv2.thebankersbank.com",
    "bugs": {
      "1926501": {
        "issue": "unsupported-warning",
        "matches": ["*://iwebv2.thebankersbank.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1926564": {
    "label": "app.phase.com",
    "bugs": {
      "1926564": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://app.phase.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1927984": {
    "label": "modules.sms-timing.com",
    "bugs": {
      "1927984": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://modules.sms-timing.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1927984-modules.sms-timing.com-chrome-shim.js"]
        },
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1928605": {
    "label": "votermaps.org",
    "bugs": {
      "1928605": {
        "issue": "broken-map",
        "matches": ["*://votermaps.org/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1928605-votermaps.org-center-map-icons.css"]
        }
      }
    ]
  },
  "1928941": {
    "label": "oasis.decart.ai",
    "bugs": {
      "1928941": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://oasis.decart.ai/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "js": ["bug1928941-oasis.decart.ai-window-chrome-shim.js"]
        },
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1928954": {
    "label": "publix.com",
    "bugs": {
      "1928954": {
        "issue": "broken-interactive-elements",
        "matches": ["*://*.publix.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "max_version": 139,
        "content_scripts": {
          "js": ["bug1928954-publix.com-prevent-nav-on-javascript-url-click.js"]
        }
      }
    ]
  },
  "1930440": {
    "label": "online.singaporepools.com",
    "bugs": {
      "1930440": {
        "issue": "unsupported-warning",
        "matches": ["*://online.singaporepools.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": [
            "bug1930440-online.singaporepools.com-prevent-unsupported-alert.js"
          ]
        }
      }
    ]
  },
  "1931538": {
    "label": "buzzfeed.com",
    "bugs": {
      "1931538": {
        "issue": "broken-interactive-elements",
        "matches": [
          "*://www.buzzfeed.com/trendyelephant793/thanksgiving-foods-showdown-quiz*"
        ]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "max_version": 140,
        "content_scripts": {
          "css": ["bug1931538-buzzfeed.com-card-game-fix.css"]
        }
      }
    ]
  },
  "1933169": {
    "label": "next.goalplan.com",
    "bugs": {
      "1933169": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://next.goalplan.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1933811": {
    "label": "indices.circana.com",
    "bugs": {
      "1898959": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://indices.circana.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1933910": {
    "label": "www.tiktok.com/tiktokstudio",
    "bugs": {
      "1933910": {
        "issue": "unsupported-warning",
        "matches": ["*://www.tiktok.com/tiktokstudio*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1933929": {
    "label": "toei-anim.co.jp",
    "bugs": {
      "1933929": {
        "issue": "page-fails-to-load",
        "matches": ["*://toei-anim.co.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "replace_string_in_request": [
          {
            "find": "Date\\.parse\\(e\\.newsInfoDetail\\.date\\)",
            "replace": "Date.parse(s.newsInfoDetail.date)",
            "urls": [
              "https://www.toei-anim.co.jp/_next/static/chunks/585-f8188c5d925661df.js"
            ]
          }
        ]
      }
    ]
  },
  "1934189": {
    "label": "fdj.fr",
    "bugs": {
      "1934189": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.fdj.fr/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1934518": {
    "label": "app.fullcodemedical.com",
    "bugs": {
      "1934518": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://app.fullcodemedical.com/Player/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1934567": {
    "label": "port8.fi",
    "bugs": {
      "1934567": {
        "issue": "broken-scrolling",
        "matches": ["*://www.port8.fi/bokning/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "css": ["bug1934567-www.port8.fi-scrolling-fix.css"]
        }
      }
    ]
  },
  "1935598": {
    "label": "testbook.com",
    "bugs": {
      "1935598": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://testbook.com/*/lesson/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1936429": {
    "label": "diadora.com",
    "bugs": {
      "1936429": {
        "issue": "extra-scrollbars",
        "matches": ["*://www.diadora.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1936429-diadora.com-fix-doubled-scrollbars.css"]
        }
      }
    ]
  },
  "1939248": {
    "label": "rosasthai.com",
    "bugs": {
      "1939248": {
        "issue": "broken-interactive-elements",
        "matches": ["*://rosasthai.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1939248-rosasthai.com-load-event-helper.js"]
        }
      }
    ]
  },
  "1939697": {
    "label": "paypal.com",
    "bugs": {
      "1939697": {
        "issue": "broken-captcha",
        "matches": ["*://www.paypal.com/myaccount/security/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1943987": {
    "label": "andisearch.com",
    "bugs": {
      "1943987": {
        "issue": "broken-layout",
        "matches": ["*://andisearch.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "css": ["bug1943987-andisearch.com-fix-offscreen-elements.css"]
        }
      }
    ]
  },
  "1943920": {
    "label": "add.org",
    "bugs": {
      "1943920": {
        "issue": "broken-layout",
        "matches": ["*://add.org/adhd-facts*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "css": ["bug1943920-add.org-fix-overlapping-menu.css"]
        }
      }
    ]
  },
  "1941530": {
    "label": "climate.rutgers.edu",
    "bugs": {
      "1941530": {
        "issue": "broken-images",
        "matches": ["*://climate.rutgers.edu/snowcover/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1941530-climate.rutgers.edu-fix-broken-images.css"]
        }
      }
    ]
  },
  "1942292": {
    "label": "beterbed.nl",
    "bugs": {
      "1942292": {
        "issue": "extra-scrollbars",
        "matches": ["*://www.beterbed.nl/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1942292-beterbed.nl-scrollbar-fix.css"]
        }
      }
    ]
  },
  "1943898": {
    "label": "www.capital.gr",
    "bugs": {
      "1943898": {
        "issue": "broken-redirect",
        "matches": ["*://www.capital.gr/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "js": ["bug1943898-www.capital.gr-suppress-constant-reloading.js"]
        }
      }
    ]
  },
  "1943993": {
    "label": "arenti.net",
    "bugs": {
      "1943993": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.arenti.net/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1944518": {
    "label": "app.powerbi.com",
    "bugs": {
      "1944518": {
        "issue": "broken-scrolling",
        "matches": ["*://app.powerbi.com/view*"]
      },
      "1911423": {
        "issue": "broken-zooming",
        "matches": ["*://app.powerbi.com/view*"]
      }
    },
    "interventions": [
      {
        "platforms": ["mac"],
        "ua_string": ["add_Chrome"],
        "content_scripts": {
          "all_frames": true,
          "css": ["bug1944518-app.powerbi.com-webkit-scrollbar-css-fixes.css"]
        }
      },
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "all_frames": true,
          "js": ["bug1911423-app.powerbi.com-emulate-mousewheel-events.js"]
        }
      }
    ]
  },
  "1944727": {
    "label": "linkedin.com",
    "bugs": {
      "1944727": {
        "issue": "broken-layout",
        "matches": ["*://*.linkedin.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "pref_check": { "layout.css.webkit-fill-available.enabled": false },
        "content_scripts": {
          "css": ["bug1944727-www.linkedin.com-fix-dark-overlay.css"]
        }
      }
    ]
  },
  "1945019": {
    "label": "order.mealkeyway.com",
    "bugs": {
      "1945019": {
        "issue": "unsupported-warning",
        "matches": ["https://order.mealkeyway.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": [
            "bug1945019-order.mealkeyway.com-prevent-unsupported-message.js"
          ]
        }
      }
    ]
  },
  "1945438": {
    "label": "tiktok.com (extra scrollbars)",
    "bugs": {
      "1945438": {
        "issue": "extra-scrollbars",
        "matches": ["*://www.tiktok.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1945438-www.tiktok.com-hide-extra-scrollbars.css"]
        }
      }
    ]
  },
  "1945561": {
    "label": "webex.com",
    "bugs": {
      "1945561": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.webex.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1946409": {
    "label": "www.lush.com",
    "bugs": {
      "1946409": {
        "issue": "broken-layout",
        "matches": ["*://www.lush.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "css": ["bug1946409-www.lush.com-fix-cookie-banner.css"]
        }
      }
    ]
  },
  "1946443": {
    "label": "aliexpress.com bundle deals pages",
    "bugs": {
      "1946443": {
        "issue": "broken-layout",
        "matches": ["*://www.aliexpress.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1947105": {
    "label": "pexels.com",
    "bugs": {
      "1947105": {
        "issue": "broken-layout",
        "matches": ["*://*.pexels.com/photo/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1947105-pexels.com-nudge-thanks-popup-onscreen.css"]
        }
      }
    ]
  },
  "1947407": {
    "label": "y.qq.com",
    "bugs": {
      "1947407": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://y.qq.com/artists*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1947682": {
    "label": "boostapp.io",
    "bugs": {
      "1947682": {
        "issue": "unsupported-warning",
        "matches": ["*://www.boostapp.io/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1947979": {
    "label": "www.shazam.com",
    "bugs": {
      "1947979": {
        "issue": "extra-scrollbars",
        "matches": ["*://www.shazam.com/song/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1947979-shazam.com-hide-extra-scrollbars.css"]
        }
      }
    ]
  },
  "1948723": {
    "label": "babel.com",
    "bugs": {
      "1948723": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://chat.babel.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1949466": {
    "label": "lapalabradeldia.com",
    "bugs": {
      "1949466": {
        "issue": "broken-interactive-elements",
        "matches": ["*://lapalabradeldia.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1949466-lapalabradeldia.com-fix-vanishing-letters.css"]
        }
      }
    ]
  },
  "1950100": {
    "label": "aylak.com",
    "bugs": {
      "1950100": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.aylak.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1950053": {
    "label": "omegleapp.me",
    "bugs": {
      "1950053": {
        "issue": "extra-scrollbars",
        "matches": ["*://omegleapp.me/chat*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1950053-omegleapp.me-fix-scrollbars.css"]
        }
      }
    ]
  },
  "1950282": {
    "label": "f1tv.formula1.com",
    "bugs": {
      "1950282": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.formula1.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      },
      {
        "platforms": ["linux"],
        "content_scripts": {
          "js": ["bug1950282-formula1.com-platform-linux-fix.js"]
        }
      }
    ]
  },
  "1950807": {
    "label": "sus.softadmin.se",
    "bugs": {
      "1950807": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://sus.softadmin.se/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1951055": {
    "label": "calcoastcu.org",
    "bugs": {
      "1951055": {
        "issue": "unsupported-warning",
        "matches": ["*://*.calcoastcu.org/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["linux"],
        "content_scripts": {
          "css": ["bug1951055-calcoastcu.org-hide-browser-warning.css"]
        }
      }
    ]
  },
  "1951675": {
    "label": "byod.airindia.com",
    "bugs": {
      "1951675": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://byod.airindia.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1953077": {
    "label": "Nintendo movie guidebook",
    "bugs": {
      "1953077": {
        "issue": "broken-layout",
        "matches": ["*://*.nintendo.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1953077-nintendo.com-fix-blank-movie-guidebook.css"]
        }
      }
    ]
  },
  "1953091": {
    "label": "slc-ut-us.avolvecloud.com",
    "bugs": {
      "1953091": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://slc-ut-us.avolvecloud.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1954002": {
    "label": "advancedmd.com",
    "bugs": {
      "1954002": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.advancedmd.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1898952-digits.t-mobile.com.js"]
        },
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1954144": {
    "label": "td.com",
    "bugs": {
      "1954144": {
        "issue": "extra-scrollbars",
        "matches": ["*://*.td.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "css": ["bug1954144-td.com-scrollbar-fix.css"]
        }
      }
    ]
  },
  "1954427": {
    "label": "eolno.nokas.com",
    "bugs": {
      "1954427": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://eolno.nokas.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1955529": {
    "label": "kancelaria.kros.sk",
    "bugs": {
      "1955529": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://kancelaria.kros.sk/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1954533": {
    "label": "copaair.com",
    "bugs": {
      "1954533": {
        "issue": "page-fails-to-load",
        "matches": ["*://*.copaair.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "min_version": 141,
        "alter_request_headers": [
          {
            "headers": ["TE"],
            "replacement": "moz_no_te_trailers"
          }
        ]
      }
    ]
  },
  "1955932": {
    "label": "coopvoce.it",
    "bugs": {
      "1955932": {
        "issue": "broken-scrolling",
        "matches": ["*://www.coopvoce.it/portale/ricarica.html*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1955932-coopvoce.it-fix-broken-radiobuttons.css"]
        }
      }
    ]
  },
  "1956165": {
    "label": "m.youtube.com picture-in-picture fix",
    "bugs": {
      "1956165": {
        "issue": "broken-videos",
        "matches": ["*://m.youtube.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "js": ["bug1956165-www.youtube.com-picture-in-picture-fix.js"]
        }
      }
    ]
  },
  "1959046": {
    "label": "angeljackets.com",
    "bugs": {
      "1959046": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://www.angeljackets.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1959117": {
    "label": "cesupils.lv",
    "bugs": {
      "1959117": {
        "issue": "page-fails-to-load",
        "matches": ["*://cesupils.lv/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1959132": {
    "label": "www.samsung.com (columns fix)",
    "bugs": {
      "1959132": {
        "issue": "broken-layout",
        "matches": ["*://www.samsung.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "css": ["bug1959132-www.samsung.com-column-size-fix.css"]
        }
      }
    ]
  },
  "1959444": {
    "label": "m.modanisa.com",
    "bugs": {
      "1959444": {
        "issue": "incorrect-viewport-dimensions",
        "matches": ["*://m.modanisa.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["change_Firefox_to_FireFox"]
      }
    ]
  },
  "1960316": {
    "label": "wms.sso.biglobe.ne.jp",
    "bugs": {
      "1960316": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://wms.sso.biglobe.ne.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1962587": {
    "label": "virtualvisit.telushealth.com",
    "bugs": {
      "1962587": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://virtualvisit.telushealth.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1962642": {
    "label": "hoanghamobile.com",
    "bugs": {
      "1962642": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://hoanghamobile.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1962654": {
    "label": "go.idnow.de",
    "bugs": {
      "1962654": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://go.idnow.de/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["linux"],
        "ua_string": ["change_OS_to_Windows"]
      }
    ]
  },
  "1963270": {
    "label": "app.kosmi.io",
    "bugs": {
      "1963270": {
        "issue": "blocked-content",
        "matches": ["*://app.kosmi.io/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1963270-app.kosmi.io-unprefix-mozCaptureStream.js"]
        }
      }
    ]
  },
  "1964947": {
    "label": "dotnetfiddle.net",
    "bugs": {
      "1964947": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://dotnetfiddle.net/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1966330": {
    "label": "salling.dk",
    "bugs": {
      "1966330": {
        "issue": "broken-scrolling",
        "matches": ["*://salling.dk/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1966330-salling.dk-fix-mobile-filter-scrolling.css"]
        }
      }
    ]
  },
  "1966377": {
    "label": "nvidia.com",
    "bugs": {
      "1966377": {
        "issue": "broken-layout",
        "matches": ["*://*.nvidia.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "css": ["bug1966377-nvidia.com-fix-overflowing-layout.css"]
        }
      }
    ]
  },
  "1966389": {
    "label": "boots.com",
    "bugs": {
      "1966389": {
        "issue": "broken-layout",
        "matches": ["*://appointments.boots.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "pref_check": { "layout.css.webkit-fill-available.enabled": false },
        "content_scripts": {
          "all_frames": true,
          "css": ["bug1966389-boots.com-align-element-widths.css"]
        }
      }
    ]
  },
  "1966585": {
    "label": "hiskin.care",
    "bugs": {
      "1966585": {
        "issue": "broken-interactive-elements",
        "matches": ["*://hiskin.care/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1966585-hiskin.care-reveal-missing-content.css"]
        }
      }
    ]
  },
  "1967510": {
    "label": "gemini.google.com",
    "bugs": {
      "1967510": {
        "issue": "broken-editor",
        "matches": ["*://gemini.google.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["desktop"],
        "content_scripts": {
          "js": [
            "bug1967510-gemini.google.com-fix-copy-pasting-between-inputs.js"
          ]
        }
      }
    ]
  },
  "1967694": {
    "label": "onlyfaucet.com",
    "bugs": {
      "1967694": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.onlyfaucet.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1968187": {
    "label": "authface.liquid-auth.com",
    "bugs": {
      "1968187": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://authface.liquid-auth.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1968198": {
    "label": "www.metacritic.com",
    "bugs": {
      "1968198": {
        "issue": "broken-interactive-elements",
        "matches": ["*://www.metacritic.com/browse/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1968198-metacritic.com-fix-release-year-filter.css"]
        }
      }
    ]
  },
  "1969165": {
    "label": "appointments.mpi.mb.ca",
    "bugs": {
      "1969165": {
        "issue": "page-fails-to-load",
        "matches": ["*://appointments.mpi.mb.ca/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "skip_if": ["getWeekInfo_defined"],
        "content_scripts": {
          "js": ["bug196916-mpi.mb.ca-polyfill-getWeekInfo.js"]
        }
      }
    ]
  },
  "1969245": {
    "label": "www.wills-vegan-store.com",
    "bugs": {
      "1969245": {
        "issue": "broken-images",
        "matches": ["*://www.wills-vegan-store.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": [
            "bug1969245-www.wills-vegan-store.com-unhide-product-images.css"
          ]
        }
      }
    ]
  },
  "1972511": {
    "label": "cmyportal.tkc.co.jp",
    "bugs": {
      "1972511": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://cmyportal.tkc.co.jp/auth/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["change_Firefox_to_FireFox"]
      }
    ]
  },
  "1975651": {
    "label": "comic.k-manga.jp",
    "bugs": {
      "1975651": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://comic.k-manga.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "js": [
            "lib/ua_helpers.js",
            "bug1975651-comic.k-manga.jp-ua-override.js"
          ]
        }
      }
    ]
  },
  "1975652": {
    "label": "gree.jp",
    "bugs": {
      "1975652": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://gree.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1975926": {
    "label": "kuruma-news.jp",
    "bugs": {
      "1975926": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://kuruma-news.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1975951": {
    "label": "www.dell.com",
    "bugs": {
      "1975951": {
        "issue": "broken-images",
        "matches": ["*://www.dell.com/*"]
      }
    },
    "interventions": [
      {
        "not_platforms": ["mac"],
        "content_scripts": {
          "css": ["bug1975951-www.dell.com-reveal-product-images.css"]
        }
      }
    ]
  },
  "1975953": {
    "label": "envios.mercadolibre.com.ar",
    "bugs": {
      "1975953": {
        "issue": "broken-layout",
        "matches": [
          "*://envios.mercadolibre.com.ar/shipping/agencies-map/pick-up*"
        ]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "css": ["bug1975953-envios.mercadolibre.com.ar-reveal-content.css"]
        }
      }
    ]
  },
  "1975927": {
    "label": "trafficnews.jp",
    "bugs": {
      "1975927": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://trafficnews.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1976200": {
    "label": "unak.medlemssidor.org",
    "bugs": {
      "1976200": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://unak.medlemssidor.org/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1977195": {
    "label": "wattpad.com",
    "bugs": {
      "1977195": {
        "issue": "broken-images",
        "matches": ["*://www.wattpad.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1934908": {
    "label": "www.cbsnews.com",
    "bugs": {
      "1934908": {
        "issue": "broken-videos",
        "matches": ["*://www.cbsnews.com/live/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "all_frames": true,
          "js": [
            "lib/ua_helpers.js",
            "bug1934908-www.cbsnews.com-ua-override.js"
          ]
        }
      }
    ]
  },
  "1938533": {
    "label": "chatgpt.com",
    "bugs": {
      "1938533": {
        "issue": "broken-interactive-elements",
        "matches": ["https://chatgpt.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "only_channels": ["nightly"],
        "content_scripts": {
          "js": ["bug1938533-chatgpt.com-fix-voice-mode.js"]
        }
      }
    ]
  },
  "1973019": {
    "label": "mitsukoshi.mistore.jp",
    "bugs": {
      "1973019": {
        "issue": "broken-redirect",
        "matches": ["*://mitsukoshi.mistore.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1973976": {
    "label": "iweather.gov.vn",
    "bugs": {
      "1973976": {
        "issue": "broken-layout",
        "matches": ["*://iweather.gov.vn/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "pref_check": { "layout.css.webkit-fill-available.enabled": false },
        "content_scripts": {
          "css": ["bug1973976-iweather.gov.vn-fix-narrow-interface.css"]
        }
      }
    ]
  },
  "1974686": {
    "label": "hermes.admin.ch",
    "bugs": {
      "1974686": {
        "issue": "broken-layout",
        "matches": [
          "*://www.hermes.admin.ch/de/projektmanagement/szenarien/it-entwicklung/szenariouebersicht.html*"
        ]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1974686-hermes_admin_ch.css"]
        }
      }
    ]
  },
  "1976402": {
    "label": "dieseldispatch.com",
    "bugs": {
      "1976402": {
        "issue": "broken-scrolling",
        "matches": ["*://dieseldispatch.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1976402-dieseldispatch.com-emulate-mousewheel-events.js"]
        }
      }
    ]
  },
  "1979612": {
    "label": "scrolller.com",
    "bugs": {
      "1979612": {
        "issue": "page-fails-to-load",
        "matches": ["*://scrolller.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1979612-scroller.com-shim-mozappearance.js"]
        }
      }
    ]
  },
  "1980382": {
    "label": "www.fidrec.com.sg",
    "bugs": {
      "1980382": {
        "issue": "broken-interactive-elements",
        "matches": ["*://www.fidrec.com.sg/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1980382-www.fidrec.com.sg-fix-radio-buttons.css"]
        }
      }
    ]
  },
  "1980629": {
    "label": "truepicvision.com",
    "bugs": {
      "1980629": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.truepicvision.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome"]
      }
    ]
  },
  "1982295": {
    "label": "hall.ssjj.cn",
    "bugs": {
      "1982295": {
        "issue": "broken-layout",
        "matches": ["*://hall.ssjj.cn/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "css": ["bug1982295-hall.ssjj.cn-fix-layout.css"]
        }
      }
    ]
  },
  "1982626": {
    "label": "store.sony.jp",
    "bugs": {
      "1982626": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.store.sony.jp/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1983538": {
    "label": "incontrol.landrover.com",
    "bugs": {
      "1983538": {
        "issue": "broken-interactive-elements",
        "matches": ["*://incontrol.landrover.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": [
            "bug1983538-incontrol.landrover.com-alias-WebKitMutationObserver.js"
          ]
        }
      }
    ]
  },
  "1984434": {
    "label": "fxnetworkspressroom.com",
    "bugs": {
      "1984434": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://www.fxnetworkspressroom.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1987351": {
    "label": "mirage.decart.ai",
    "bugs": {
      "1987351": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://mirage.decart.ai/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "content_scripts": {
          "js": ["bug1928941-oasis.decart.ai-window-chrome-shim.js"]
        },
        "ua_string": ["Chrome", "add_Firefox_as_Gecko"]
      }
    ]
  },
  "1989241": {
    "label": "useinsider.com",
    "bugs": {
      "1984434": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.useinsider.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1989975": {
    "label": "idp.infocert.it",
    "bugs": {
      "1989975": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://idp.infocert.it/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1990193": {
    "label": "zeit.werkheim.de",
    "bugs": {
      "1990193": {
        "issue": "page-fails-to-load",
        "matches": ["*://zeit.werkheim.de/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1991388": {
    "label": "gismeteo.ru",
    "bugs": {
      "1991388": {
        "issue": "desktop-layout-not-mobile",
        "matches": ["*://gismeteo.ru/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1992121": {
    "label": "tutor-uksouth.classroom.cloud",
    "bugs": {
      "1992121": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://tutor-uksouth.classroom.cloud/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["Chrome_with_FxQuantum"]
      }
    ]
  },
  "1992402": {
    "label": "ehssrisk.sai360.net",
    "bugs": {
      "1992402": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://*.ehssrisk.com/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1993201": {
    "label": "portal.pilot.ly",
    "bugs": {
      "1993201": {
        "issue": "firefox-blocked-completely",
        "matches": ["*://portal.pilot.ly/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "ua_string": ["add_Chrome"]
      }
    ]
  },
  "1996823": {
    "label": "rogers.com",
    "bugs": {
      "1996823": {
        "issue": "page-fails-to-load",
        "matches": ["*://www.rogers.com/bbapp/bbapi.js*"]
      }
    },
    "interventions": [
      {
        "platforms": ["all"],
        "replace_string_in_request": [
          {
            "find": "window\\.location\\.href = link;",
            "replace": "let url = new URL(window.location.href); url.hash = link; window.location.href = url.href;",
            "urls": ["*://www.rogers.com/bbapp/bbapi.js*"]
          }
        ]
      }
    ]
  },
  "1997575": {
    "label": "perplexity.ai",
    "bugs": {
      "1997575": {
        "issue": "user-interface-frustration",
        "matches": ["*://www.perplexity.ai/*"]
      }
    },
    "interventions": [
      {
        "platforms": ["android"],
        "content_scripts": {
          "all_frames": true,
          "js": ["1997575-perplexity.ai-covered-fixed-element.js"]
        }
      }
    ]
  }
}

try {
  interventions = new Interventions(AVAILABLE_INTERVENTIONS, CUSTOM_FUNCTIONS);
  interventions.bootup();
} catch (e) {
  console.error("Interventions failed to start", e);
  interventions = undefined;
}

try {
  shims = new Shims(AVAILABLE_SHIMS);
} catch (e) {
  console.error("Shims failed to start", e);
  shims = undefined;
}

try {
  const aboutCompatBroker = new AboutCompatBroker({
    interventions,
    shims,
  });
  aboutCompatBroker.bootup();
} catch (e) {
  console.error("about:compat broker failed to start", e);
}

listenForRemoteSettingsUpdates(interventions, shims);
