;;; emacspeak-sql.el --- Speech enable supercite
raman ;;; $Id: emacspeak-supercite.el,v 9.0 1998/10/24 05:17:28 raman Exp $
;;; $Author: raman $ 
;;; Description:  Emacspeak extension to speech enable supercite
;;; Keywords: Emacspeak, supercite, mail
;;{{{  LCD Archive entry: 

;;; LCD Archive Entry:
;;; emacspeak| T. V. Raman |raman@adobe.com 
;;; A speech interface to Emacs |
;;; $Date: 1998/10/24 05:17:28 $ |
;;;  $Revision: 9.0 $ | 
;;; Location undetermined
;;;

;;}}}
;;{{{  Copyright:
;;;Copyright (C) 1995, 1996, 1997, 1998   T. V. Raman  Adobe Systems Incorporated
;;; Copyright (c) 1994, 1995 by Digital Equipment Corporation.
;;; All Rights Reserved. 
;;;
;;; This file is not part of GNU Emacs, but the same permissions apply.
;;;
;;; GNU Emacs is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; GNU Emacs is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to
;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;}}}
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(require 'cl)
(declaim  (optimize  (safety 0) (speed 3)))
(require 'advice)
(require 'emacspeak-speak)
(require 'voice-lock)
(require 'emacspeak-fix-interactive)
(require 'emacspeak-sounds)
;;{{{  Introduction:

;;; Commentary:

;;; Speech-enable supercite.

;;; Code:

;;}}}
;;{{{ Advice
(defadvice sc-cite-region (after emacspeak pre act comp)
  "Provide auditory feedback"
  (when (interactive-p)
    (emacspeak-auditory-icon 'mark-object)
    (message "Cited region containing %s lines"
             (count-lines (ad-get-arg 0)
                          (ad-get-arg 1)))))

(defadvice sc-recite-region (after emacspeak pre act comp)
  "Provide auditory feedback"
  (when (interactive-p)
    (emacspeak-auditory-icon 'mark-object)
    (message "Re-cited region containing %s lines"
             (count-lines (ad-get-arg 0)
                          (ad-get-arg 1)))))

(defadvice sc-uncite-region (after emacspeak pre act comp)
  "Provide auditory feedback"
  (when (interactive-p)
    (emacspeak-auditory-icon 'mark-object)
    (message "Uncited region containing %s lines"
             (count-lines (ad-get-arg 0)
                          (ad-get-arg 1)))))

(defadvice sc-insert-reference (around emacspeak pre act
                                       comp)
  "Speak what we inserted"
  (cond
   ((interactive-p)
    (let ((opoint (point)))
      ad-do-it
      (emacspeak-speak-region opoint (point))
      (emacspeak-auditory-icon 'yank-object)))
   (t ad-do-it))
  ad-return-value)
(defadvice sc-insert-citation (after emacspeak pre act
                                       comp)
  "Speak what we inserted"
  (when (interactive-p)
    (emacspeak-speak-line)
    (emacspeak-auditory-icon 'yank-object)))
  
(defadvice sc-open-line (after emacspeak pre act comp)
  "Provide auditory feedback"
  (when (interactive-p)
    (emacspeak-auditory-icon 'open-object)
    (dtk-speak "Opened a blank line")))

;;}}}

(provide 'emacspeak-supercite)

;;{{{ end of file 

;;; local variables:
;;; folded-file: t
;;; byte-compile-dynamic: t
;;; end: 

;;}}}
