/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Font;
import java.awt.FontMetrics;
import java.io.CharConversionException;
import java.util.Hashtable;
import sun.awt.CharsetString;
import sun.awt.FontDescriptor;
import sun.awt.PlatformFont;

class WFontMetrics
extends FontMetrics {
    int[] widths;
    int ascent;
    int descent;
    int leading;
    int height;
    int maxAscent;
    int maxDescent;
    int maxHeight;
    int maxAdvance;
    static Hashtable table = new Hashtable();

    public WFontMetrics(Font font) {
        super(font);
        this.init();
    }

    public int getLeading() {
        return this.leading;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxAscent() {
        return this.maxAscent;
    }

    public int getMaxDescent() {
        return this.maxDescent;
    }

    public int getMaxAdvance() {
        return this.maxAdvance;
    }

    public int stringWidth(String string) {
        return this.charsWidth(string.toCharArray(), 0, string.length());
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        Font font = this.getFont();
        PlatformFont platformFont = (PlatformFont)font.getPeer();
        if (platformFont.mightHaveMultiFontMetrics()) {
            return this.getMFStringWidth(cArray, n, n2, font, platformFont);
        }
        if (this.widths != null) {
            int n3 = 0;
            int n4 = n;
            while (n4 < n + n2) {
                char c = cArray[n4];
                n3 = c < '\u0000' || c >= this.widths.length ? (n3 += this.maxAdvance) : (n3 += this.widths[c]);
                ++n4;
            }
            return n3;
        }
        return this.maxAdvance * n2;
    }

    private int getMFStringWidth(char[] cArray, int n, int n2, Font font, PlatformFont platformFont) {
        if (n2 == 0) {
            return 0;
        }
        CharsetString[] charsetStringArray = platformFont.makeMultiCharsetString(cArray, n, n2);
        byte[] byArray = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < charsetStringArray.length) {
            CharsetString charsetString = charsetStringArray[n5];
            if (WFontMetrics.needsConversion(font, charsetString.fontDescriptor)) {
                try {
                    int n6 = charsetString.fontDescriptor.fontCharset.getMaxBytesPerChar() * charsetString.length;
                    if (n6 > n3) {
                        n3 = n6;
                        byArray = new byte[n3];
                    }
                    int n7 = charsetString.fontDescriptor.fontCharset.convert(charsetString.charsetChars, charsetString.offset, charsetString.offset + charsetString.length, byArray, 0, byArray.length);
                    n4 += this.getMFCharSegmentWidth(font, charsetString.fontDescriptor, true, null, 0, 0, byArray, n7);
                }
                catch (CharConversionException charConversionException) {}
            } else {
                n4 += this.getMFCharSegmentWidth(font, charsetString.fontDescriptor, false, charsetString.charsetChars, charsetString.offset, charsetString.length, null, 0);
            }
            ++n5;
        }
        return n4;
    }

    static native boolean needsConversion(Font var0, FontDescriptor var1);

    private native int getMFCharSegmentWidth(Font var1, FontDescriptor var2, boolean var3, char[] var4, int var5, int var6, byte[] var7, int var8);

    public native int bytesWidth(byte[] var1, int var2, int var3);

    public int[] getWidths() {
        return this.widths;
    }

    native void init();

    static FontMetrics getFontMetrics(Font font) {
        FontMetrics fontMetrics = (FontMetrics)table.get(font);
        if (fontMetrics == null) {
            fontMetrics = new WFontMetrics(font);
            table.put(font, fontMetrics);
        }
        return fontMetrics;
    }
}

