/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.PipedReader;
import java.io.Writer;

public class PipedWriter
extends Writer {
    PipedOutputStream byteSource = new PipedOutputStream();
    private byte[] buf;

    public PipedWriter() {
    }

    public PipedWriter(PipedReader pipedReader) throws IOException {
        this();
        this.connect(pipedReader);
    }

    private void ensureOpen() throws IOException {
        if (this.byteSource == null) {
            throw new IOException("Stream closed");
        }
    }

    public void connect(PipedReader pipedReader) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.byteSource.connect(pipedReader.byteSink);
            return;
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int n3 = n2 * 2;
            if (this.buf == null || this.buf.length < n3) {
                this.buf = new byte[n3];
            }
            int n4 = 0;
            while (n4 < n3) {
                char c = cArray[n + (n4 >> 1)];
                this.buf[n4] = (byte)(c >> 8);
                this.buf[n4 + 1] = (byte)c;
                n4 += 2;
            }
            this.byteSource.write(this.buf, 0, n3);
            return;
        }
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.byteSource.flush();
            return;
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.byteSource == null) {
                Object var2_2 = null;
                return;
            }
            this.byteSource.close();
            this.byteSource = null;
            return;
        }
    }
}

