/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.IOException;
import java.io.OutputStream;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.MultiplexConnectionInfo;

final class MultiplexOutputStream
extends OutputStream {
    private ConnectionMultiplexer manager;
    private MultiplexConnectionInfo info;
    private byte[] buffer;
    private int pos;
    private int requested;
    private boolean disconnected = false;
    private Object lock = new Object();

    MultiplexOutputStream(ConnectionMultiplexer connectionMultiplexer, MultiplexConnectionInfo multiplexConnectionInfo, int n) {
        this.manager = connectionMultiplexer;
        this.info = multiplexConnectionInfo;
        this.buffer = new byte[n];
        this.pos = 0;
    }

    public synchronized void write(int n) throws IOException {
        while (this.pos >= this.buffer.length) {
            this.push();
        }
        this.buffer[this.pos++] = (byte)n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        Object object;
        if (n2 <= 0) {
            return;
        }
        int n3 = this.buffer.length - this.pos;
        if (n2 <= n3) {
            System.arraycopy(byArray, n, this.buffer, this.pos, n2);
            this.pos += n2;
            return;
        }
        this.flush();
        while (true) {
            int n4;
            object = this.lock;
            synchronized (object) {
                while (true) {
                    if ((n4 = this.requested) >= 1 || this.disconnected) {
                        if (!this.disconnected) break;
                        throw new IOException("Connection closed");
                    }
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (n4 >= n2) break;
            this.manager.sendTransmit(this.info, byArray, n, n4);
            n += n4;
            n2 -= n4;
            object = this.lock;
            synchronized (object) {
                this.requested -= n4;
            }
        }
        this.manager.sendTransmit(this.info, byArray, n, n2);
        object = this.lock;
        synchronized (object) {
            this.requested -= n2;
            return;
        }
    }

    public synchronized void flush() throws IOException {
        while (this.pos > 0) {
            this.push();
        }
    }

    public void close() throws IOException {
        this.manager.sendClose(this.info);
    }

    void request(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.requested += n;
            this.lock.notifyAll();
            return;
        }
    }

    void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            this.disconnected = true;
            this.lock.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void push() throws IOException {
        int n;
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if ((n = this.requested) >= 1 || this.disconnected) {
                    if (!this.disconnected) break;
                    throw new IOException("Connection closed");
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (n < this.pos) {
            this.manager.sendTransmit(this.info, this.buffer, 0, n);
            System.arraycopy(this.buffer, n, this.buffer, 0, this.pos - n);
            this.pos -= n;
            object = this.lock;
            synchronized (object) {
                this.requested -= n;
                return;
            }
        }
        this.manager.sendTransmit(this.info, this.buffer, 0, this.pos);
        object = this.lock;
        synchronized (object) {
            this.requested -= this.pos;
        }
        this.pos = 0;
    }
}

