#!/bin/sh -xe
## -----------------------------------------------------------------------
##   
##   Copyright 2000-2001 H. Peter Anvin - All Rights Reserved
##
##   This program is free software; you can redistribute it and/or modify
##   it under the terms of the GNU General Public License as published by
##   the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,
##   USA; either version 2 of the License, or (at your option) any later
##   version; incorporated herein by reference.
##
## -----------------------------------------------------------------------
## $Id: makeinit.sh,v 1.3 2001/04/15 02:43:24 hpa Exp $

##
## initrd make script for SuperRescue CD
##

rm -f initrd initrd.gz
rm -rf im ir
mkdir -p ir
find irtree -type f -name \*~ -print0 | xargs -0r rm -f

dd if=/dev/zero of=initrd bs=1024 count=4096
mke2fs -F initrd
mount -t ext2 -o loop initrd ir
cp -a irtree/. ir/.
umount ir
sync
gzip -9 initrd
