#!/bin/bash

KLIB='/lib/modules/'
KMODDIR='updates'
DESTDIR=''

echo ""
echo "Remove old Wireless drivers..."

rm -Rf $KLIB/3.5.0-54-generic/$KMODDIR/compat;
rm -Rf $KLIB/3.5.0-54-generic/$KMODDIR/drivers;
rm -Rf $KLIB/3.5.0-54-generic/$KMODDIR/net;

/sbin/depmod -a 3.5.0-54-generic;

/usr/share/tcc/compat-wireless/scripts/update-initramfs

echo ""
echo "Install new Wireless drivers..."

cp -Rf /usr/share/tcc/compat-wireless/$KMODDIR $KLIB/3.5.0-54-generic;

/usr/share/tcc/compat-wireless/scripts/update-initramfs

echo ""
echo "Settings new Wireless drivers..."
mkdir -p $DESTDIR/usr/lib/compat-wireless/
install /usr/share/tcc/compat-wireless/scripts/modlib.sh $DESTDIR/usr/lib/compat-wireless/
install /usr/share/tcc/compat-wireless/scripts/madwifi-unload $DESTDIR/usr/sbin/
install /usr/share/tcc/compat-wireless/scripts/athenable $DESTDIR/usr/sbin/
install /usr/share/tcc/compat-wireless/scripts/b43enable $DESTDIR/usr/sbin/
install /usr/share/tcc/compat-wireless/scripts/iwl-enable $DESTDIR/usr/sbin/
install /usr/share/tcc/compat-wireless/scripts/athload $DESTDIR/usr/sbin/
install /usr/share/tcc/compat-wireless/scripts/b43load $DESTDIR/usr/sbin/
install /usr/share/tcc/compat-wireless/scripts/iwl-load $DESTDIR/usr/sbin/

if [ $(modinfo ath_pci > /dev/null 2>&1 && echo 1) ]; then \
    echo -n "Note: madwifi detected, we're going to disable it. "  ;\
    echo "If you would like to enable it later you can run:"  ;\
    echo "    sudo athenable madwifi"  ;\
    echo ;\
    echo Running athenable ath5k...;\
    $DESTDIR/usr/sbin/athenable ath5k ;\
fi

if [ $(modinfo iwl4965 > /dev/null 2>&1 && echo 1) ]; then \
    echo ;\
    echo -n "Note: iwl4965 detected, we're going to disable it. "  ;\
    echo "If you would like to enable it later you can run:"  ;\
    echo "    sudo iwl-load iwl4965"  ;\
    echo ;\
    echo Running iwl-enable iwlagn...;\
    $DESTDIR/usr/sbin/iwl-enable iwlagn ;\
fi

if [ $(modinfo iwlagn > /dev/null 2>&1 && echo 1) ] \
         && [ $(modinfo iwlwifi > /dev/null 2>&1 && echo 1) ]; then \
    echo ;\
    echo -n "Note: iwlagn detected, we're going to disable it. " ;\
    echo "If you would like to enable it later you can run:"  ;\
    echo "    sudo iwl-load iwlagn"  ;\
    echo ;\
    echo Running iwl-enable iwlwifi...;\
    $DESTDIR/usr/sbin/iwl-enable iwlwifi ;\
fi

/usr/share/tcc/compat-wireless/scripts/compress_modules
/usr/share/tcc/compat-wireless/scripts/check_depmod
/usr/share/tcc/compat-wireless/compat/scripts/compat_firmware_install

/sbin/depmod -a 3.5.0-54-generic;

echo 
echo Now run:
echo 
echo sudo make unload to unload all: wireless, bluetooth and ethernet modules
echo sudo make wlunload to unload wireless modules
echo sudo make btunload to unload bluetooth modules
echo
echo Run sudo modprobe 'driver-name' to load your desired driver. 
echo If unsure reboot.
echo
