#ifndef __IWL_INTA_PROG_H__
#define __IWL_INTA_PROG_H__

#include <linux/interrupt.h>
#include "iwl-trans.h"

/* Temp:allow compilation without the according iwlwifi-stack-dev patch */
#ifndef IWL_IDI_LLS_INT
#define IWL_IDI_LLS_INT 0x1
#define IWL_IDI_HW_ERR_INT 0x2
#define IWL_IDI_SW_ERR_INT 0X4
#define IWL_IDI_FH_TX_INT 0x8
#endif

/* idi_trans_iwl is the task specific. return the pcie incorporated in it */
#define IWL_IDI_GET_PCIE(_idi_trans_iwl) \
	(IWL_TRANS_GET_PCIE_TRANS(_idi_trans_iwl->trans_pcie))

/**
 * _trans_iwl is the outer iwl_trans, return the pcie incorporated
 * in it's idi trans specific
 */
#define IWL_TRANS_GET_INTERNAL_PCIE(_trans_iwl) \
	IWL_IDI_GET_PCIE(IWL_TRANS_GET_IDI_TRANS(_trans_iwl))

struct iwl_inta_em_t;

/************************************************
 * Init and close
 ************************************************/

void iwl_inta_em_init(struct iwl_trans *trans);

int iwl_inta_em_stop(void);

void iwl_inta_em_start(struct iwl_trans *trans,
		       irqreturn_t (*idi_irq_handler)(unsigned long),
		       irqreturn_t (*idi_irq_thread)(unsigned long));

void iwl_inta_em_free(void);

/************************************************
 * Set and get irq data
 ************************************************/

/* return the mask for current pending irq */
u32 iwl_inta_em_read_called(struct iwl_trans *trans);

/* return the current iwl_trans, that was set in init */
struct iwl_trans *iwl_inta_em_get_trans(void);

/* updates the called_irq's according to "Called" */
void iwl_inta_em_set_irq_called(u32 called, struct iwl_trans *trans);

/* updates the called_irq's according to "Called" - set "called" bits off */
void iwl_inta_em_set_irq_handled(u32 handled, struct iwl_trans *trans);

/* updates the called_irq's according to "Called" - set "called" bits on */
void iwl_inta_em_add_irq_called(u32 called);

void iwl_inta_em_clean_irq_called(struct iwl_trans *trans);

/************************************************
 * helpers
 ************************************************/

/* tasklet to handle the irq */
void iwl_inta_em_tasklet(struct iwl_trans *trans);

/**
 * handle pcie dependent irq - same way as in pcie/rx.c -> isl_irq_tasklet
 * keep record of idi dependent irq and return them.
 */
u32 iwl_inta_em_handle_pcie(struct iwl_trans *trans);

/* test idi mechanism by periodicaly turning on lls_int. */
void iwl_idi_test_lls(void);

#endif /* __IWL_INTA_PROG_H__*/
