/*****************************************************************************
 *
 * Copyright(c) 2013 Intel Corporation. All rights reserved.
 * Intel Corporation does NOT grant any right to use this file in any way.
 *
 ****************************************************************************/

#ifndef __iwl_mvm_dbgm_h__
#define __iwl_mvm_dbgm_h__

#include "iwl-trans.h"

struct iwl_mvm_priv;
struct iwl_rx_cmd_buffer;
struct iwl_device_cmd;
struct iwl_dbgm;

/*
 * struct iwl_dbgm_ops: Callbacks to the op mode
 *
 * The structure defines the callbacks that the op_mode should handle
 * inorder to handle logic that is out of the scope of iwl_dbgm.
 *
 * @send_cmd: used by the dbgm object to request the op_mode to send
 *  a command to the fw
 */
struct iwl_dbgm_ops {

	int (*send_cmd)(struct iwl_op_mode *om, struct iwl_host_cmd *cmd);
};

/**
 * Initializes DBGM module in the driver (not the device).
 * On success, returns a new created and initliazed dbgm context, otherwise
 * returns NULL
 *
 * @trans: pointer to driver's transport context
 * @ops: dbgm callbacks
 */
struct iwl_dbgm *iwl_dbgm_init(struct iwl_trans *trans,
			       struct iwl_dbgm_ops *ops);

/**
 * Frees DBGM module in the driver (stops device if needed).
 *
 * @dbgm: pointer to dbgm context
 */
void iwl_dbgm_free(struct iwl_dbgm *dbgm);

/**
 * Sets whether or not the device is ready to collect debug logs.
 * Should be called inside system flows when the uCode is loaded/stopped.
 *
 * @dbgm: pointer to dbgm context
 * @available: true when uCode is ready, false when it is stopped
 */
void iwl_dbgm_set_available(struct iwl_dbgm *dbgm, bool available);

#ifdef CPTCFG_IWLWIFI_DEBUGFS
int iwl_dbgm_debugfs_register(struct iwl_dbgm *dbgm, struct dentry *dir);
#endif /* CPTCFG_IWLWIFI_DEBUGFS */

int iwl_dbgm_log_rx_debug_msg(struct iwl_dbgm *dbgm,
		 struct iwl_rx_cmd_buffer *rxb,
		 struct iwl_device_cmd *cmd);

#endif /* __iwl_mvm_dbgm_h__ */
