/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.libvorbis;

import org.xiph.libogg.ogg_packet;
import org.xiph.libvorbis.alloc_chain;
import org.xiph.libvorbis.bitrate_manager_info;
import org.xiph.libvorbis.bitrate_manager_state;
import org.xiph.libvorbis.codebook;
import org.xiph.libvorbis.codec_setup_info;
import org.xiph.libvorbis.encode_aux_threshmatch;
import org.xiph.libvorbis.lsfit_acc;
import org.xiph.libvorbis.oggpack_buffer;
import org.xiph.libvorbis.private_state;
import org.xiph.libvorbis.static_codebook;
import org.xiph.libvorbis.vorbis_block_internal;
import org.xiph.libvorbis.vorbis_constants.integer_constants;
import org.xiph.libvorbis.vorbis_dsp_state;
import org.xiph.libvorbis.vorbis_info;
import org.xiph.libvorbis.vorbis_info_floor1;
import org.xiph.libvorbis.vorbis_info_mapping0;
import org.xiph.libvorbis.vorbis_info_psy;
import org.xiph.libvorbis.vorbis_info_psy_global;
import org.xiph.libvorbis.vorbis_info_residue0;
import org.xiph.libvorbis.vorbis_look_floor1;
import org.xiph.libvorbis.vorbis_look_psy;
import org.xiph.libvorbis.vorbis_look_psy_global;
import org.xiph.libvorbis.vorbis_look_residue0;
import org.xiph.libvorbis.vorbis_window;

public class vorbis_block {
    float[][] pcm;
    int pcm_offset;
    oggpack_buffer opb;
    int lW;
    int W;
    int nW;
    int pcmend;
    int mode;
    int eofflag;
    int granulepos;
    int sequence;
    vorbis_dsp_state vd;
    Object[] localstore;
    int localtop;
    int localalloc;
    int totaluse;
    alloc_chain reap;
    int glue_bits;
    int time_bits;
    int floor_bits;
    int res_bits;
    vorbis_block_internal internal;
    vorbis_window window;
    static float[] hypot_lookup = new float[]{-0.009935f, -0.011245f, -0.012726f, -0.014397f, -0.016282f, -0.018407f, -0.0208f, -0.023494f, -0.026522f, -0.029923f, -0.033737f, -0.03801f, -0.042787f, -0.048121f, -0.054064f, -0.060671f, -0.068f, -0.076109f, -0.085054f, -0.094892f, -0.105675f, -0.117451f, -0.13026f, -0.144134f, -0.159093f, -0.175146f, -0.192286f, -0.21049f, -0.229718f, -0.249913f, -0.271001f, -0.292893f};

    public vorbis_block(vorbis_dsp_state v) {
        this.vd = v;
        this.localalloc = 0;
        this.opb = new oggpack_buffer();
        if (v.analysisp > 0) {
            this.internal = new vorbis_block_internal();
            this.internal.ampmax = -9999.0f;
            int i = 0;
            while (i < 15) {
                this.internal.packetblob[i] = i == 7 ? this.opb : new oggpack_buffer();
                ++i;
            }
        }
        this.window = new vorbis_window();
    }

    public int _vorbis_block_alloc(int bytes) {
        if ((bytes = bytes + 7 & 0xFFFFFFF8) + this.localtop > this.localalloc) {
            if (this.localstore != null) {
                alloc_chain link = new alloc_chain();
                this.totaluse += this.localtop;
                link.next = this.reap;
                link.ptr = new Object[this.localtop];
                System.arraycopy(this.localstore, 0, link.ptr, 0, this.localtop);
                this.reap = link;
            }
            this.localalloc = bytes;
            this.localstore = new Object[this.localalloc];
            this.localtop = 0;
        }
        int ret = this.localtop;
        this.localtop += bytes;
        return ret;
    }

    public void _vorbis_block_ripcord() {
        while (this.reap != null) {
            alloc_chain next = this.reap.next;
            this.reap = null;
            this.reap = next;
        }
        if (this.totaluse > 0) {
            Object[] temp = new Object[this.totaluse + this.localalloc];
            System.arraycopy(this.localstore, 0, temp, 0, this.localalloc);
            this.localstore = temp;
            this.localalloc += this.totaluse;
            this.totaluse = 0;
        }
        this.localtop = 0;
        this.reap = null;
    }

    public boolean vorbis_analysis_blockout(vorbis_dsp_state v) {
        codec_setup_info ci = v.vi.codec_setup;
        private_state b = v.backend_state;
        vorbis_look_psy_global g = b.psy_g_look;
        int beginW = v.centerW - ci.blocksizes[v.W] / 2;
        vorbis_block_internal vbi = this.internal;
        if (v.preextrapolate <= 0) {
            return false;
        }
        if (v.eofflag == -1) {
            return false;
        }
        int bp = v._ve_envelope_search();
        if (bp == -1) {
            if (v.eofflag == 0) {
                return false;
            }
            v.nW = 0;
        } else {
            v.nW = ci.blocksizes[0] == ci.blocksizes[1] ? 0 : bp;
        }
        int centerNext = v.centerW + ci.blocksizes[v.W] / 4 + ci.blocksizes[v.nW] / 4;
        int blockbound = centerNext + ci.blocksizes[v.nW] / 2;
        if (v.pcm_current < blockbound) {
            return false;
        }
        this._vorbis_block_ripcord();
        this.lW = v.lW;
        this.W = v.W;
        this.nW = v.nW;
        vbi.blocktype = v.W > 0 ? (v.lW <= 0 || v.nW <= 0 ? 0 : 1) : (v._ve_envelope_mark() ? 0 : 1);
        this.vd = v;
        this.sequence = v.sequence++;
        this.granulepos = v.granulepos;
        this.pcmend = ci.blocksizes[v.W];
        if (vbi.ampmax > g.ampmax) {
            g.ampmax = vbi.ampmax;
        }
        vbi.ampmax = g.ampmax = v._vp_ampmax_decay(g.ampmax);
        this.pcm = new float[v.vi.channels][];
        vbi.pcmdelay = new float[v.vi.channels][];
        int i = 0;
        while (i < v.vi.channels) {
            vbi.pcmdelay[i] = new float[this.pcmend + beginW];
            System.arraycopy(v.pcm[i], 0, vbi.pcmdelay[i], 0, this.pcmend + beginW);
            this.pcm[i] = new float[vbi.pcmdelay[i].length - beginW];
            System.arraycopy(vbi.pcmdelay[i], beginW, this.pcm[i], 0, vbi.pcmdelay[i].length - beginW);
            ++i;
        }
        if (v.eofflag > 0 && v.centerW >= v.eofflag) {
            v.eofflag = -1;
            this.eofflag = 1;
            return true;
        }
        int new_centerNext = ci.blocksizes[1] / 2;
        int movementW = centerNext - new_centerNext;
        if (movementW > 0) {
            b.ve._ve_envelope_shift(movementW);
            v.pcm_current -= movementW;
            i = 0;
            while (i < v.vi.channels) {
                System.arraycopy(v.pcm[i], movementW, v.pcm[i], 0, v.pcm_current);
                ++i;
            }
            v.lW = v.W;
            v.W = v.nW;
            v.centerW = new_centerNext;
            if (v.eofflag > 0) {
                v.eofflag -= movementW;
                if (v.eofflag <= 0) {
                    v.eofflag = -1;
                }
                v.granulepos = v.centerW >= v.eofflag ? (v.granulepos += movementW - (v.centerW - v.eofflag)) : (v.granulepos += movementW);
            } else {
                v.granulepos += movementW;
            }
        }
        return true;
    }

    public boolean vorbis_bitrate_managed() {
        return this.vd.backend_state.bms.managed > 0;
    }

    public boolean vorbis_analysis(ogg_packet op) {
        this.glue_bits = 0;
        this.time_bits = 0;
        this.floor_bits = 0;
        this.res_bits = 0;
        int i = 0;
        while (i < 15) {
            this.internal.packetblob[i].oggpack_reset();
            ++i;
        }
        this.mapping0_forward();
        if (op != null) {
            if (this.vorbis_bitrate_managed()) {
                return false;
            }
            op.packet = this.opb.buffer;
            op.bytes = this.opb.oggpack_bytes();
            op.b_o_s = 0;
            op.e_o_s = this.eofflag;
            op.granulepos = this.granulepos;
            op.packetno = this.sequence;
        }
        return true;
    }

    static int accumulate_fit(float[] flr, int mdct, int x0, int x1, lsfit_acc a, int n, vorbis_info_floor1 info) {
        int xa = 0;
        int ya = 0;
        int x2a = 0;
        int y2a = 0;
        int xya = 0;
        int na = 0;
        int xb = 0;
        int yb = 0;
        int x2b = 0;
        int y2b = 0;
        int xyb = 0;
        int nb = 0;
        a.x0 = x0;
        a.x1 = x1;
        if (x1 >= n) {
            x1 = n - 1;
        }
        int i = x0;
        while (i <= x1) {
            int quantized = integer_constants.vorbis_dBquant(flr[i]);
            if (quantized > 0) {
                if (flr[mdct + i] + info.twofitatten >= flr[i]) {
                    xa += i;
                    ya += quantized;
                    x2a += i * i;
                    y2a += quantized * quantized;
                    xya += i * quantized;
                    ++na;
                } else {
                    xb += i;
                    yb += quantized;
                    x2b += i * i;
                    y2b += quantized * quantized;
                    xyb += i * quantized;
                    ++nb;
                }
            }
            ++i;
        }
        xb += xa;
        yb += ya;
        x2b += x2a;
        y2b += y2a;
        xyb += xya;
        int weight = new Float((float)(nb += na) * info.twofitweight / (float)(na + 1)).intValue();
        a.xa = xa * weight + xb;
        a.ya = ya * weight + yb;
        a.x2a = x2a * weight + x2b;
        a.y2a = y2a * weight + y2b;
        a.xya = xya * weight + xyb;
        a.an = na * weight + nb;
        return na;
    }

    static int[] fit_line(lsfit_acc[] a, int offset, int fits, int y0, int y1) {
        int x = 0;
        int y = 0;
        int x2 = 0;
        int y2 = 0;
        int xy = 0;
        int an = 0;
        int x0 = a[offset].x0;
        int x1 = a[offset + fits - 1].x1;
        int i = 0;
        while (i < fits) {
            x += a[offset + i].xa;
            y += a[offset + i].ya;
            x2 += a[offset + i].x2a;
            y2 += a[offset + i].y2a;
            xy += a[offset + i].xya;
            an += a[offset + i].an;
            ++i;
        }
        if (y0 >= 0) {
            x += x0;
            y += y0;
            x2 += x0 * x0;
            y2 += y0 * y0;
            xy += y0 * x0;
            ++an;
        }
        if (y1 >= 0) {
            x += x1;
            y += y1;
            x2 += x1 * x1;
            y2 += y1 * y1;
            xy += y1 * x1;
            ++an;
        }
        if (an > 0) {
            double fx = x;
            double fy = y;
            double fx2 = x2;
            double fxy = xy;
            double denom = 1.0 / ((double)an * fx2 - fx * fx);
            double a_local = (fy * fx2 - fxy * fx) * denom;
            double b = ((double)an * fxy - fx * fy) * denom;
            y0 = (int)Math.rint(a_local + b * (double)x0);
            y1 = (int)Math.rint(a_local + b * (double)x1);
            if (y0 > 1023) {
                y0 = 1023;
            }
            if (y1 > 1023) {
                y1 = 1023;
            }
            if (y0 < 0) {
                y0 = 0;
            }
            if (y1 < 0) {
                y1 = 0;
            }
        } else {
            y0 = 0;
            y1 = 0;
        }
        int[] return_buffer = new int[]{y0, y1};
        return return_buffer;
    }

    /*
     * Unable to fully structure code
     */
    static int inspect_error(int x0, int x1, int y0, int y1, float[] mask, int mdct, vorbis_info_floor1 info) {
        dy = y1 - y0;
        adx = x1 - x0;
        ady = Math.abs(dy);
        base = dy / adx;
        sy = dy < 0 ? base - 1 : base + 1;
        x = x0;
        y = y0;
        err = 0;
        val = integer_constants.vorbis_dBquant(mask[x]);
        mse = 0;
        n = 0;
        ady -= Math.abs(base * adx);
        mse = y - val;
        mse *= mse;
        ++n;
        if (!(mask[mdct + x] + info.twofitatten >= mask[x])) ** GOTO lbl34
        if ((float)y + info.maxover < (float)val) {
            return 1;
        }
        if (!((float)y - info.maxunder > (float)val)) ** GOTO lbl34
        return 1;
lbl-1000:
        // 1 sources

        {
            if ((err += ady) >= adx) {
                err -= adx;
                y += sy;
            } else {
                y += base;
            }
            val = integer_constants.vorbis_dBquant(mask[x]);
            mse += (y - val) * (y - val);
            ++n;
            if (!(mask[mdct + x] + info.twofitatten >= mask[x]) || val <= 0) continue;
            if ((float)y + info.maxover < (float)val) {
                return 1;
            }
            if (!((float)y - info.maxunder > (float)val)) continue;
            return 1;
lbl34:
            // 4 sources

            ** while (++x < x1)
        }
lbl35:
        // 1 sources

        if (info.maxover * info.maxover / (float)n > info.maxerr) {
            return 0;
        }
        if (info.maxunder * info.maxunder / (float)n > info.maxerr) {
            return 0;
        }
        if ((float)(mse / n) > info.maxerr) {
            return 1;
        }
        return 0;
    }

    static int post_Y(int[] A, int[] B, int pos) {
        if (A[pos] < 0) {
            return B[pos];
        }
        if (B[pos] < 0) {
            return A[pos];
        }
        return A[pos] + B[pos] >>> 1;
    }

    public int[] floor1_fit(vorbis_look_floor1 look, int logmdct, float[] logmask) {
        vorbis_info_floor1 info = look.vi;
        int n = look.n;
        int posts = look.posts;
        int nonzero = 0;
        lsfit_acc[] fits = new lsfit_acc[64];
        int i = 0;
        while (i < 64) {
            fits[i] = new lsfit_acc();
            ++i;
        }
        int[] fit_valueA = new int[65];
        int[] fit_valueB = new int[65];
        int[] loneighbor = new int[65];
        int[] hineighbor = new int[65];
        int[] output = null;
        int[] memo = new int[65];
        int[] return_buffer = new int[2];
        i = 0;
        while (i < posts) {
            fit_valueA[i] = -200;
            ++i;
        }
        i = 0;
        while (i < posts) {
            fit_valueB[i] = -200;
            ++i;
        }
        i = 0;
        while (i < posts) {
            loneighbor[i] = 0;
            ++i;
        }
        i = 0;
        while (i < posts) {
            hineighbor[i] = 1;
            ++i;
        }
        i = 0;
        while (i < posts) {
            memo[i] = -1;
            ++i;
        }
        if (posts == 0) {
            nonzero += vorbis_block.accumulate_fit(logmask, logmdct, 0, n, fits[0], n, info);
        } else {
            i = 0;
            while (i < posts - 1) {
                nonzero += vorbis_block.accumulate_fit(logmask, logmdct, look.sorted_index[i], look.sorted_index[i + 1], fits[i], n, info);
                ++i;
            }
        }
        if (nonzero > 0) {
            int y0 = -200;
            int y1 = -200;
            return_buffer = vorbis_block.fit_line(fits, 0, posts - 1, y0, y1);
            y0 = return_buffer[0];
            y1 = return_buffer[1];
            fit_valueA[0] = y0;
            fit_valueB[0] = y0;
            fit_valueB[1] = y1;
            fit_valueA[1] = y1;
            i = 2;
            while (i < posts) {
                int sortpos = look.reverse_index[i];
                int ln = loneighbor[sortpos];
                int hn = hineighbor[sortpos];
                if (memo[ln] != hn) {
                    int lsortpos = look.reverse_index[ln];
                    int hsortpos = look.reverse_index[hn];
                    memo[ln] = hn;
                    int lx = info.postlist[ln];
                    int hx = info.postlist[hn];
                    int ly = vorbis_block.post_Y(fit_valueA, fit_valueB, ln);
                    int hy = vorbis_block.post_Y(fit_valueA, fit_valueB, hn);
                    if (ly == -1 || hy == -1) {
                        System.out.println("ERROR: We want to bound/minimize *local*, not global");
                        System.exit(1);
                    }
                    if (vorbis_block.inspect_error(lx, hx, ly, hy, logmask, logmdct, info) > 0) {
                        int ly0 = -200;
                        int ly1 = -200;
                        int hy0 = -200;
                        int hy1 = -200;
                        return_buffer = vorbis_block.fit_line(fits, lsortpos, sortpos - lsortpos, ly0, ly1);
                        ly0 = return_buffer[0];
                        ly1 = return_buffer[1];
                        return_buffer = vorbis_block.fit_line(fits, sortpos, hsortpos - sortpos, hy0, hy1);
                        hy0 = return_buffer[0];
                        hy1 = return_buffer[1];
                        fit_valueB[ln] = ly0;
                        if (ln == 0) {
                            fit_valueA[ln] = ly0;
                        }
                        fit_valueA[i] = ly1;
                        fit_valueB[i] = hy0;
                        fit_valueA[hn] = hy1;
                        if (hn == 1) {
                            fit_valueB[hn] = hy1;
                        }
                        if (ly1 >= 0 || hy0 >= 0) {
                            int j = sortpos - 1;
                            while (j >= 0) {
                                if (hineighbor[j] != hn) break;
                                hineighbor[j] = i;
                                --j;
                            }
                            j = sortpos + 1;
                            while (j < posts) {
                                if (loneighbor[j] == ln) {
                                    loneighbor[j] = i;
                                    ++j;
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        fit_valueA[i] = -200;
                        fit_valueB[i] = -200;
                    }
                }
                ++i;
            }
            output = new int[posts];
            output[0] = vorbis_block.post_Y(fit_valueA, fit_valueB, 0);
            output[1] = vorbis_block.post_Y(fit_valueA, fit_valueB, 1);
            i = 2;
            while (i < posts) {
                int ln = look.loneighbor[i - 2];
                int hn = look.hineighbor[i - 2];
                int x0 = info.postlist[ln];
                int x1 = info.postlist[hn];
                y0 = output[ln];
                y1 = output[hn];
                int predicted = integer_constants.render_point(x0, x1, y0, y1, info.postlist[i]);
                int vx = vorbis_block.post_Y(fit_valueA, fit_valueB, i);
                output[i] = vx >= 0 && predicted != vx ? vx : predicted | 0x8000;
                ++i;
            }
        }
        return output;
    }

    static int[] floor1_interpolate_fit(vorbis_look_floor1 look, int[] A, int[] B, int del) {
        int posts = look.posts;
        int[] output = null;
        if (A != null && B != null) {
            output = new int[posts];
            int i = 0;
            while (i < posts) {
                boolean bTrue;
                output[i] = (65536 - del) * (A[i] & Short.MAX_VALUE) + del * (B[i] & Short.MAX_VALUE) + 32768 >> 16;
                boolean aTrue = (A[i] & 0x8000) > 0;
                boolean bl = bTrue = (B[i] & 0x8000) > 0;
                if (aTrue && bTrue) {
                    int n = i;
                    output[n] = output[n] | 0x8000;
                }
                ++i;
            }
        }
        return output;
    }

    static float dipole_hypot(float a, float b) {
        if ((double)a > 0.0) {
            if ((double)b > 0.0) {
                return new Double(Math.sqrt(a * a + b * b)).floatValue();
            }
            if (a > -b) {
                return new Double(Math.sqrt(a * a - b * b)).floatValue();
            }
            return new Double(-Math.sqrt(b * b - a * a)).floatValue();
        }
        if ((double)b < 0.0) {
            return new Double(-Math.sqrt(a * a + b * b)).floatValue();
        }
        if (-a > b) {
            return new Double(-Math.sqrt(a * a - b * b)).floatValue();
        }
        return new Double(Math.sqrt(b * b - a * a)).floatValue();
    }

    static float round_hypot(float a, float b) {
        if ((double)a > 0.0) {
            if ((double)b > 0.0) {
                return new Double(Math.sqrt(a * a + b * b)).floatValue();
            }
            if (a > -b) {
                return new Double(Math.sqrt(a * a + b * b)).floatValue();
            }
            return new Double(-Math.sqrt(b * b + a * a)).floatValue();
        }
        if ((double)b < 0.0) {
            return new Double(-Math.sqrt(a * a + b * b)).floatValue();
        }
        if (-a > b) {
            return new Double(-Math.sqrt(a * a + b * b)).floatValue();
        }
        return new Double(Math.sqrt(b * b + a * a)).floatValue();
    }

    private float[][] _vp_quantize_couple_memo(vorbis_info_psy_global g, vorbis_look_psy p, vorbis_info_mapping0 vi, float[][] mdct) {
        int n = p.n;
        float[][] ret = new float[vi.coupling_steps][n];
        int limit = g.coupling_pointlimit[p.vi.blockflag][7];
        int i = 0;
        while (i < vi.coupling_steps) {
            float[] mdctM = mdct[vi.coupling_mag[i]];
            float[] mdctA = mdct[vi.coupling_ang[i]];
            int j = 0;
            while (j < limit) {
                ret[i][j] = vorbis_block.dipole_hypot(mdctM[j], mdctA[j]);
                ++j;
            }
            while (j < n) {
                ret[i][j] = vorbis_block.round_hypot(mdctM[j], mdctA[j]);
                ++j;
            }
            ++i;
        }
        return ret;
    }

    private static void SORT4(int o, float[] data, int offset, int[] n) {
        if (Math.abs(data[offset + o + 2]) >= Math.abs(data[offset + o + 3])) {
            if (Math.abs(data[offset + o + 0]) >= Math.abs(data[offset + o + 1])) {
                if (Math.abs(data[offset + o + 0]) >= Math.abs(data[offset + o + 2])) {
                    if (Math.abs(data[offset + o + 1]) >= Math.abs(data[offset + o + 2])) {
                        n[o] = o + 0;
                        n[o + 1] = o + 1;
                        n[o + 2] = o + 2;
                        n[o + 3] = o + 3;
                    } else if (Math.abs(data[offset + o + 1]) >= Math.abs(data[offset + o + 3])) {
                        n[o] = o + 0;
                        n[o + 1] = o + 2;
                        n[o + 2] = o + 1;
                        n[o + 3] = o + 3;
                    } else {
                        n[o] = o + 0;
                        n[o + 1] = o + 2;
                        n[o + 2] = o + 3;
                        n[o + 3] = o + 1;
                    }
                } else if (Math.abs(data[offset + o + 0]) >= Math.abs(data[offset + o + 3])) {
                    if (Math.abs(data[offset + o + 1]) >= Math.abs(data[offset + o + 3])) {
                        n[o] = o + 2;
                        n[o + 1] = o + 0;
                        n[o + 2] = o + 1;
                        n[o + 3] = o + 3;
                    } else {
                        n[o] = o + 2;
                        n[o + 1] = o + 0;
                        n[o + 2] = o + 3;
                        n[o + 3] = o + 1;
                    }
                } else {
                    n[o] = o + 2;
                    n[o + 1] = o + 3;
                    n[o + 2] = o + 0;
                    n[o + 3] = o + 1;
                }
            } else if (Math.abs(data[offset + o + 1]) >= Math.abs(data[offset + o + 2])) {
                if (Math.abs(data[offset + o + 0]) >= Math.abs(data[offset + o + 2])) {
                    n[o] = o + 1;
                    n[o + 1] = o + 0;
                    n[o + 2] = o + 2;
                    n[o + 3] = o + 3;
                } else if (Math.abs(data[offset + o + 0]) >= Math.abs(data[offset + o + 3])) {
                    n[o] = o + 1;
                    n[o + 1] = o + 2;
                    n[o + 2] = o + 0;
                    n[o + 3] = o + 3;
                } else {
                    n[o] = o + 1;
                    n[o + 1] = o + 2;
                    n[o + 2] = o + 3;
                    n[o + 3] = o + 0;
                }
            } else if (Math.abs(data[offset + o + 1]) >= Math.abs(data[offset + o + 3])) {
                if (Math.abs(data[offset + o + 0]) >= Math.abs(data[offset + o + 3])) {
                    n[o] = o + 2;
                    n[o + 1] = o + 1;
                    n[o + 2] = o + 0;
                    n[o + 3] = o + 3;
                } else {
                    n[o] = o + 2;
                    n[o + 1] = o + 1;
                    n[o + 2] = o + 3;
                    n[o + 3] = o + 0;
                }
            } else {
                n[o] = o + 2;
                n[o + 1] = o + 3;
                n[o + 2] = o + 1;
                n[o + 3] = o + 0;
            }
        } else if (Math.abs(data[offset + o + 0]) >= Math.abs(data[offset + o + 1])) {
            if (Math.abs(data[offset + o + 0]) >= Math.abs(data[offset + o + 3])) {
                if (Math.abs(data[offset + o + 1]) >= Math.abs(data[offset + o + 3])) {
                    n[o] = o + 0;
                    n[o + 1] = o + 1;
                    n[o + 2] = o + 3;
                    n[o + 3] = o + 2;
                } else if (Math.abs(data[offset + o + 1]) >= Math.abs(data[offset + o + 2])) {
                    n[o] = o + 0;
                    n[o + 1] = o + 3;
                    n[o + 2] = o + 1;
                    n[o + 3] = o + 2;
                } else {
                    n[o] = o + 0;
                    n[o + 1] = o + 3;
                    n[o + 2] = o + 2;
                    n[o + 3] = o + 1;
                }
            } else if (Math.abs(data[offset + o + 0]) >= Math.abs(data[offset + o + 2])) {
                if (Math.abs(data[offset + o + 1]) >= Math.abs(data[offset + o + 2])) {
                    n[o] = o + 3;
                    n[o + 1] = o + 0;
                    n[o + 2] = o + 1;
                    n[o + 3] = o + 2;
                } else {
                    n[o] = o + 3;
                    n[o + 1] = o + 0;
                    n[o + 2] = o + 2;
                    n[o + 3] = o + 1;
                }
            } else {
                n[o] = o + 3;
                n[o + 1] = o + 2;
                n[o + 2] = o + 0;
                n[o + 3] = o + 1;
            }
        } else if (Math.abs(data[offset + o + 1]) >= Math.abs(data[offset + o + 3])) {
            if (Math.abs(data[offset + o + 0]) >= Math.abs(data[offset + o + 3])) {
                n[o] = o + 1;
                n[o + 1] = o + 0;
                n[o + 2] = o + 3;
                n[o + 3] = o + 2;
            } else if (Math.abs(data[offset + o + 0]) >= Math.abs(data[offset + o + 2])) {
                n[o] = o + 1;
                n[o + 1] = o + 3;
                n[o + 2] = o + 0;
                n[o + 3] = o + 2;
            } else {
                n[o] = o + 1;
                n[o + 1] = o + 3;
                n[o + 2] = o + 2;
                n[o + 3] = o + 0;
            }
        } else if (Math.abs(data[offset + o + 1]) >= Math.abs(data[offset + o + 2])) {
            if (Math.abs(data[offset + o + 0]) >= Math.abs(data[offset + o + 2])) {
                n[o] = o + 3;
                n[o + 1] = o + 1;
                n[o + 2] = o + 0;
                n[o + 3] = o + 2;
            } else {
                n[o] = o + 3;
                n[o + 1] = o + 1;
                n[o + 2] = o + 2;
                n[o + 3] = o + 0;
            }
        } else {
            n[o] = o + 3;
            n[o + 1] = o + 2;
            n[o + 2] = o + 1;
            n[o + 3] = o + 0;
        }
    }

    static void sortindex_fix8(int[] index, int ioff, float[] data, int offset) {
        int[] n = new int[8];
        vorbis_block.SORT4(0, data, offset, n);
        vorbis_block.SORT4(4, data, offset, n);
        int j = 0;
        int k = 4;
        int i = 0;
        while (i < 8) {
            index[ioff + offset + i] = n[k >= 8 || j < 4 && Math.abs(data[offset + 0 + n[j]]) >= Math.abs(data[offset + 0 + n[k]]) ? j++ : k++] + offset;
            ++i;
        }
    }

    static void sortindex_fix32(int[] index, int ioff, float[] data, int offset) {
        int[] n = new int[32];
        int i = 0;
        while (i < 32) {
            vorbis_block.sortindex_fix8(index, ioff, data, offset + i);
            i += 8;
        }
        ioff += offset;
        int j = 0;
        i = 0;
        int k = 8;
        while (i < 16) {
            n[i] = index[ioff + (k >= 16 || j < 8 && Math.abs(data[0 + index[ioff + j]]) >= Math.abs(data[0 + index[ioff + k]]) ? j++ : k++)];
            ++i;
        }
        j = 16;
        i = 16;
        k = 24;
        while (i < 32) {
            n[i] = index[ioff + (k >= 32 || j < 24 && Math.abs(data[0 + index[ioff + j]]) >= Math.abs(data[0 + index[ioff + k]]) ? j++ : k++)];
            ++i;
        }
        j = 0;
        i = 0;
        k = 16;
        while (i < 32) {
            index[ioff + i] = n[k >= 32 || j < 16 && Math.abs(data[0 + n[j]]) >= Math.abs(data[0 + n[k]]) ? j++ : k++];
            ++i;
        }
    }

    static void sortindex_shellsort(int[] index, int ioff, float[] data, int offset, int count) {
        ioff += offset;
        int i = 0;
        while (i < count) {
            index[ioff + i] = i + offset;
            ++i;
        }
        int gap = 1;
        while (gap <= count) {
            gap = gap * 3 + 1;
        }
        if ((gap /= 3) >= 4) {
            gap /= 3;
        }
        while (gap > 0) {
            int pos = gap;
            while (pos < count) {
                int left = pos - gap;
                while (left >= 0) {
                    i = index[ioff + left];
                    int j = index[ioff + left + gap];
                    if (Math.abs(data[0 + i]) >= Math.abs(data[0 + j])) break;
                    index[ioff + left] = j;
                    index[ioff + left + gap] = i;
                    left -= gap;
                }
                ++pos;
            }
            gap /= 3;
        }
    }

    static void sortindex(int[] index, int ioff, float[] data, int offset, int count) {
        if (count == 8) {
            vorbis_block.sortindex_fix8(index, ioff, data, offset);
        } else if (count == 32) {
            vorbis_block.sortindex_fix32(index, ioff, data, offset);
        } else {
            vorbis_block.sortindex_shellsort(index, ioff, data, offset, count);
        }
    }

    private int[][] _vp_quantize_couple_sort(vorbis_look_psy p, vorbis_info_mapping0 vi, float[][] mags) {
        if (p.vi.normal_point_p > 0) {
            int n = p.n;
            int[][] ret = new int[vi.coupling_steps][n];
            int partition = p.vi.normal_partition;
            int i = 0;
            while (i < vi.coupling_steps) {
                int j = 0;
                while (j < n) {
                    vorbis_block.sortindex(ret[i], 0, mags[i], j, partition);
                    j += partition;
                }
                ++i;
            }
            return ret;
        }
        return null;
    }

    private void _vp_noise_normalize_sort(vorbis_look_psy p, float[] magnitudes, int[] sortedindex) {
        int start;
        int n = p.n;
        vorbis_info_psy vi = p.vi;
        int partition = vi.normal_partition;
        int j = start = vi.normal_start;
        while (j < n) {
            if (j + partition > n) {
                partition = n - j;
            }
            vorbis_block.sortindex(sortedindex, -start, magnitudes, j, partition);
            j += partition;
        }
    }

    private void hf_reduction(vorbis_info_psy_global g, vorbis_look_psy p, vorbis_info_mapping0 vi, float[][] mdct) {
        int n = p.n;
        int de = (int)(0.3 * (double)p.m_val);
        int limit = g.coupling_pointlimit[p.vi.blockflag][7];
        int i = 0;
        while (i < vi.coupling_steps) {
            int j = limit;
            while (j < n) {
                float[] fArray = mdct[i];
                int n2 = j;
                fArray[n2] = (float)((double)fArray[n2] * (1.0 - (double)((float)de * ((float)(j - limit) / (float)(n - limit)))));
                ++j;
            }
            ++i;
        }
    }

    private void _vp_remove_floor(vorbis_look_psy p, float[] mdct, int[] codedflr, float[] residue, int sliding_lowpass) {
        int n = p.n;
        if (sliding_lowpass > n) {
            sliding_lowpass = n;
        }
        int i = 0;
        while (i < sliding_lowpass) {
            residue[i] = mdct[i] * integer_constants.FLOOR1_fromdB_INV_LOOKUP[codedflr[i]];
            ++i;
        }
        while (i < n) {
            residue[i] = 0.0f;
            ++i;
        }
    }

    private void _vp_noise_normalize(vorbis_look_psy p, float[] in, int out, int[] sortedindex) {
        int j = 0;
        int n = p.n;
        vorbis_info_psy vi = p.vi;
        int partition = vi.normal_partition;
        int start = vi.normal_start;
        if (start > n) {
            start = n;
        }
        if (vi.normal_channel_p > 0) {
            while (j < start) {
                in[out + j] = (float)Math.rint(in[j]);
                ++j;
            }
            while (j + partition <= n) {
                int k;
                float acc = 0.0f;
                int i = j;
                while (i < j + partition) {
                    acc += in[i] * in[i];
                    ++i;
                }
                i = 0;
                while (i < partition) {
                    k = sortedindex[i + j - start];
                    if (in[k] * in[k] >= 0.25f) {
                        in[out + k] = (float)Math.rint(in[k]);
                        acc -= in[k] * in[k];
                    } else {
                        if (acc < vi.normal_thresh) break;
                        in[out + k] = integer_constants.unitnorm(in[k]);
                        acc = (float)((double)acc - 1.0);
                    }
                    ++i;
                }
                while (i < partition) {
                    k = sortedindex[i + j - start];
                    in[out + k] = 0.0f;
                    ++i;
                }
                j += partition;
            }
        }
        while (j < n) {
            in[out + j] = (float)Math.rint(in[j]);
            ++j;
        }
    }

    static float[] couple_lossless(float A, float B, float qA, float qB) {
        int test1 = Math.abs(qA) > Math.abs(qB) ? 1 : 0;
        if ((test1 -= Math.abs(qA) < Math.abs(qB) ? 1 : 0) <= 0) {
            test1 = ((Math.abs(A) > Math.abs(B) ? 1 : 0) << 1) - 1;
        }
        if (test1 == 1) {
            qB = qA > 0.0f ? qA - qB : qB - qA;
        } else {
            float temp = qB;
            qB = qB > 0.0f ? qA - qB : qB - qA;
            qA = temp;
        }
        if (qB > Math.abs(qA) * 1.9999f) {
            qB = -Math.abs(qA) * 2.0f;
            qA = -qA;
        }
        float[] ret = new float[]{qA, qB};
        return ret;
    }

    static float[] precomputed_couple_point(float premag, int floorA, int floorB, float mag, float ang) {
        int test = (floorA > floorB ? 1 : 0) - 1;
        int offset = 31 - Math.abs(floorA - floorB);
        float floormag = hypot_lookup[(offset < 0 ? 1 : 0) - 1 & offset] + 1.0f;
        mag = premag * (floormag *= integer_constants.FLOOR1_fromdB_INV_LOOKUP[floorB & test | floorA & ~test]);
        ang = 0.0f;
        float[] ret = new float[]{mag, ang};
        return ret;
    }

    private void _vp_couple(int blobno, vorbis_info_psy_global g, vorbis_look_psy p, vorbis_info_mapping0 vi, float[][] res, float[][] mag_memo, int[][] mag_sort, int[][] ifloor, int[] nonzero, int sliding_lowpass) {
        int n = p.n;
        int i = 0;
        while (i < vi.coupling_steps) {
            if (nonzero[vi.coupling_mag[i]] > 0 || nonzero[vi.coupling_ang[i]] > 0) {
                int limit;
                float[] rM = res[vi.coupling_mag[i]];
                float[] rA = res[vi.coupling_ang[i]];
                int qM = n;
                int qA = n;
                int[] floorM = ifloor[vi.coupling_mag[i]];
                int[] floorA = ifloor[vi.coupling_ang[i]];
                float prepoint = integer_constants.stereo_threshholds[g.coupling_prepointamp[blobno]];
                float postpoint = integer_constants.stereo_threshholds[g.coupling_postpointamp[blobno]];
                int partition = p.vi.normal_point_p > 0 ? p.vi.normal_partition : p.n;
                int pointlimit = limit = g.coupling_pointlimit[p.vi.blockflag][blobno];
                nonzero[vi.coupling_mag[i]] = 1;
                nonzero[vi.coupling_ang[i]] = 1;
                if (n > 1000) {
                    postpoint = integer_constants.stereo_threshholds_limited[g.coupling_postpointamp[blobno]];
                }
                int j = 0;
                while (j < p.n) {
                    int l;
                    float acc = 0.0f;
                    int k = 0;
                    while (k < partition) {
                        l = k + j;
                        if (l < sliding_lowpass) {
                            float[] return_buffer;
                            if (l >= limit && Math.abs(rM[l]) < postpoint && Math.abs(rA[l]) < postpoint || Math.abs(rM[l]) < prepoint && Math.abs(rA[l]) < prepoint) {
                                return_buffer = vorbis_block.precomputed_couple_point(mag_memo[i][l], floorM[l], floorA[l], rM[qM + l], rA[qA + l]);
                                rM[qM + l] = return_buffer[0];
                                rA[qA + l] = return_buffer[1];
                                if (Math.rint(rM[qM + l]) == 0.0) {
                                    acc += rM[qM + l] * rM[qM + l];
                                }
                            } else {
                                return_buffer = vorbis_block.couple_lossless(rM[l], rA[l], rM[qM + l], rA[qA + l]);
                                rM[qM + l] = return_buffer[0];
                                rA[qA + l] = return_buffer[1];
                            }
                        } else {
                            rM[qM + l] = 0.0f;
                            rA[qA + l] = 0.0f;
                        }
                        ++k;
                    }
                    if (p.vi.normal_point_p > 0) {
                        k = 0;
                        while (k < partition && acc >= p.vi.normal_thresh) {
                            l = mag_sort[i][j + k];
                            if (l < sliding_lowpass && l >= pointlimit && Math.rint(rM[qM + l]) == 0.0) {
                                rM[qM + l] = integer_constants.unitnorm(rM[qM + l]);
                                acc -= 1.0f;
                            }
                            ++k;
                        }
                    }
                    j += partition;
                }
            }
            ++i;
        }
    }

    private int[][] _2class(vorbis_look_residue0 look, float[][] in, int in_offset, int ch) {
        vorbis_info_residue0 info = look.info;
        int samples_per_partition = info.grouping;
        int possible_partitions = info.partitions;
        int n = info.end - info.begin;
        int partvals = n / samples_per_partition;
        int[][] partword = new int[1][n * ch / samples_per_partition];
        int i = 0;
        int l = info.begin / ch;
        while (i < partvals) {
            float magmax = 0.0f;
            float angmax = 0.0f;
            int j = 0;
            while (j < samples_per_partition) {
                if (Math.abs(in[0][l + in_offset]) > magmax) {
                    magmax = Math.abs(in[0][l + in_offset]);
                }
                int k = 1;
                while (k < ch) {
                    if (Math.abs(in[k][l + in_offset]) > angmax) {
                        angmax = Math.abs(in[k][l + in_offset]);
                    }
                    ++k;
                }
                ++l;
                j += ch;
            }
            j = 0;
            while (j < possible_partitions - 1) {
                if (magmax <= info.classmetric1[j] && angmax <= info.classmetric2[j]) break;
                ++j;
            }
            partword[0][i] = j;
            ++i;
        }
        ++look.frames;
        return partword;
    }

    private int[][] res2_class(vorbis_look_residue0 vl, float[][] in, int in_offset, int[] nonzero, int ch) {
        int used = 0;
        int i = 0;
        while (i < ch) {
            if (nonzero[i] > 0) {
                ++used;
            }
            ++i;
        }
        if (used > 0) {
            return this._2class(vl, in, in_offset, ch);
        }
        return new int[][]{new int[1]};
    }

    private int local_book_besterror(codebook book, float[] a, int a_off) {
        int i;
        int dim = book.dim;
        int best = 0;
        encode_aux_threshmatch tt = book.c.thresh_tree;
        int k = 0;
        int o = dim;
        while (k < dim) {
            float val;
            i = tt.threshvals >> 1;
            if ((val = a[a_off + --o]) < tt.quantthresh[i]) {
                if (val < tt.quantthresh[i - 1]) {
                    --i;
                    while (i > 0) {
                        if (!(val >= tt.quantthresh[i - 1])) {
                            --i;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                ++i;
                while (i < tt.threshvals - 1) {
                    if (!(val < tt.quantthresh[i])) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            best = best * tt.quantvals + tt.quantmap[i];
            ++k;
        }
        if (book.c.lengthlist[best] <= 0) {
            static_codebook c = book.c;
            float bestf = 0.0f;
            int e_off = 0;
            best = -1;
            int index = 0;
            while (index < book.entries) {
                if (c.lengthlist[index] > 0) {
                    float this_local = 0.0f;
                    int j = 0;
                    while (j < dim) {
                        float val = book.valuelist[e_off + j] - a[a_off + j];
                        this_local += val * val;
                        ++j;
                    }
                    if (best == -1 || this_local < bestf) {
                        bestf = this_local;
                        best = index;
                    }
                }
                e_off += dim;
                ++index;
            }
        }
        int ptr = best * dim;
        i = 0;
        while (i < dim) {
            int n = a_off++;
            a[n] = a[n] - book.valuelist[ptr++];
            ++i;
        }
        return best;
    }

    private int _encodepart(oggpack_buffer opb_local, float[] vec, int vec_off, int n, codebook book, int[] acc) {
        int bits = 0;
        int dim = book.dim;
        int step = n / dim;
        int i = 0;
        while (i < step) {
            int entry = this.local_book_besterror(book, vec, vec_off + i * dim);
            bits += opb_local.vorbis_book_encode(book, entry);
            ++i;
        }
        return bits;
    }

    private boolean _01forward(oggpack_buffer opb_local, vorbis_look_residue0 look, float[] in, int ch, int[][] partword) {
        vorbis_info_residue0 info = look.info;
        int samples_per_partition = info.grouping;
        int possible_partitions = info.partitions;
        int partitions_per_word = look.phrasebook.dim;
        int n = info.end - info.begin;
        int partvals = n / samples_per_partition;
        int[] resbits = new int[128];
        int[] resvals = new int[128];
        int s = 0;
        while (s < look.stages) {
            int i = 0;
            while (i < partvals) {
                int k;
                int j;
                if (s == 0) {
                    j = 0;
                    while (j < ch) {
                        int val = partword[j][i];
                        k = 1;
                        while (k < partitions_per_word) {
                            val *= possible_partitions;
                            if (i + k < partvals) {
                                val += partword[j][i + k];
                            }
                            ++k;
                        }
                        if (val < look.phrasebook.entries) {
                            look.phrasebits += opb_local.vorbis_book_encode(look.phrasebook, val);
                        } else {
                            System.out.println("! - val < look.phrasebook.entries - !");
                        }
                        ++j;
                    }
                }
                k = 0;
                while (k < partitions_per_word && i < partvals) {
                    int offset = i * samples_per_partition + info.begin;
                    j = 0;
                    while (j < ch) {
                        codebook statebook;
                        if (s == 0) {
                            int n2 = partword[j][i];
                            resvals[n2] = resvals[n2] + samples_per_partition;
                        }
                        if ((info.secondstages[partword[j][i]] & 1 << s) > 0 && (statebook = look.partbooks[partword[j][i]][s]) != null) {
                            int[] accumulator = null;
                            int ret = this._encodepart(opb_local, in, j + offset, samples_per_partition, statebook, accumulator);
                            look.postbits += ret;
                            int n3 = partword[j][i];
                            resbits[n3] = resbits[n3] + ret;
                        }
                        ++j;
                    }
                    ++k;
                    ++i;
                }
            }
            ++s;
        }
        return true;
    }

    private boolean res2_forward(oggpack_buffer opb_local, vorbis_look_residue0 vl, float[][] in, int in_offset, float[][] out, int[] nonzero, int ch, int[][] partword) {
        int k;
        int j;
        int n = this.pcmend / 2;
        int used = 0;
        float[] work = new float[ch * n];
        int i = 0;
        while (i < ch) {
            if (nonzero[i] > 0) {
                ++used;
            }
            j = 0;
            k = i;
            while (j < n) {
                work[k] = in[i][j + in_offset];
                ++j;
                k += ch;
            }
            ++i;
        }
        if (used > 0) {
            boolean ret = this._01forward(opb_local, vl, work, 1, partword);
            if (out != null) {
                i = 0;
                while (i < ch) {
                    float[] sofar = out[i];
                    j = 0;
                    k = i;
                    while (j < n) {
                        int n2 = j;
                        sofar[n2] = sofar[n2] + (in[i][j + in_offset] - work[k]);
                        ++j;
                        k += ch;
                    }
                    ++i;
                }
            }
            return ret;
        }
        return false;
    }

    public void mapping0_forward() {
        int k;
        int j;
        vorbis_info vi = this.vd.vi;
        codec_setup_info ci = vi.codec_setup;
        private_state b = this.vd.backend_state;
        vorbis_block_internal vbi = this.internal;
        int n = this.pcmend;
        int[] nonzero = new int[vi.channels];
        float[][] gmdct = new float[vi.channels][];
        int[][] ilogmaskch = new int[vi.channels][];
        int[][][] floor_posts = new int[vi.channels][][];
        float global_ampmax = vbi.ampmax;
        float[] local_ampmax = new float[vi.channels];
        int blocktype = vbi.blocktype;
        int modenumber = this.W;
        vorbis_info_mapping0 info = ci.map_param[modenumber];
        int psy_look_offset = this.W > 0 ? blocktype + 2 : blocktype;
        this.mode = modenumber;
        int i = 0;
        while (i < vi.channels) {
            float scale = 4.0f / (float)n;
            float[] logfft = this.pcm[i];
            gmdct[i] = new float[n / 2];
            float scale_dB = integer_constants.todB(scale) + 0.345f;
            this.window._vorbis_apply_window(this.pcm[i], b.window, ci.blocksizes, this.lW, this.W, this.nW);
            b.transform[this.W][0].mdct_forward(this.pcm[i], gmdct[i]);
            b.fft_look[this.W].drft_forward(this.pcm[i]);
            logfft[0] = scale_dB + integer_constants.todB(this.pcm[i][0]) + 0.345f;
            local_ampmax[i] = logfft[0];
            j = 1;
            while (j < n - 1) {
                float temp = this.pcm[i][j] * this.pcm[i][j] + this.pcm[i][j + 1] * this.pcm[i][j + 1];
                float f = logfft[j + 1 >> 1] = scale_dB + 0.5f * integer_constants.todB(temp) + 0.345f;
                temp = f;
                if (temp > local_ampmax[i]) {
                    local_ampmax[i] = temp;
                }
                j += 2;
            }
            if (local_ampmax[i] > 0.0f) {
                local_ampmax[i] = 0.0f;
            }
            if (local_ampmax[i] > global_ampmax) {
                global_ampmax = local_ampmax[i];
            }
            ++i;
        }
        float[] noise = new float[n / 2];
        float[] tone = new float[n / 2];
        i = 0;
        while (i < vi.channels) {
            int submap = info.chmuxlist[i];
            float[] mdct = gmdct[i];
            float[] logfft = this.pcm[i];
            int logmdct = n / 2;
            this.mode = modenumber;
            floor_posts[i] = new int[15][];
            j = 0;
            while (j < n / 2) {
                logfft[logmdct + j] = integer_constants.todB(mdct[j]) + 0.345f;
                ++j;
            }
            b.psy[psy_look_offset]._vp_noisemask(logfft, logmdct, noise);
            b.psy[psy_look_offset]._vp_tonemask(logfft, tone, global_ampmax, local_ampmax[i]);
            b.psy[psy_look_offset]._vp_offset_and_mix(noise, tone, 1, logfft, mdct, logmdct);
            if (ci.floor_type[info.floorsubmap[submap]] != 1) {
                System.out.println("Error vorbis_block::mapping0_forward() - floor_type != floor1");
                return;
            }
            floor_posts[i][7] = this.floor1_fit(b.flr[info.floorsubmap[submap]], logmdct, logfft);
            if (this.vorbis_bitrate_managed() && floor_posts[i][7] != null) {
                b.psy[psy_look_offset]._vp_offset_and_mix(noise, tone, 2, logfft, mdct, logmdct);
                floor_posts[i][14] = this.floor1_fit(b.flr[info.floorsubmap[submap]], logmdct, logfft);
                b.psy[psy_look_offset]._vp_offset_and_mix(noise, tone, 0, logfft, mdct, logmdct);
                floor_posts[i][0] = this.floor1_fit(b.flr[info.floorsubmap[submap]], logmdct, logfft);
                k = 1;
                while (k < 7) {
                    floor_posts[i][k] = vorbis_block.floor1_interpolate_fit(b.flr[info.floorsubmap[submap]], floor_posts[i][0], floor_posts[i][7], k * 65536 / 7);
                    ++k;
                }
                k = 8;
                while (k < 14) {
                    floor_posts[i][k] = vorbis_block.floor1_interpolate_fit(b.flr[info.floorsubmap[submap]], floor_posts[i][7], floor_posts[i][14], (k - 7) * 65536 / 7);
                    ++k;
                }
            }
            ++i;
        }
        vbi.ampmax = global_ampmax;
        float[][] res_bundle = new float[vi.channels][];
        float[][] couple_bundle = new float[vi.channels][];
        int couple_bundle_offset = 0;
        int[] zerobundle = new int[vi.channels];
        int[][] sortindex = new int[vi.channels][];
        float[][] mag_memo = null;
        int[][] mag_sort = null;
        if (info.coupling_steps > 0) {
            mag_memo = this._vp_quantize_couple_memo(ci.psy_g_param, b.psy[psy_look_offset], info, gmdct);
            mag_sort = this._vp_quantize_couple_sort(b.psy[psy_look_offset], info, mag_memo);
            this.hf_reduction(ci.psy_g_param, b.psy[psy_look_offset], info, mag_memo);
        }
        if (b.psy[psy_look_offset].vi.normal_channel_p > 0) {
            i = 0;
            while (i < vi.channels) {
                float[] mdct = gmdct[i];
                sortindex[i] = new int[n / 2];
                this._vp_noise_normalize_sort(b.psy[psy_look_offset], mdct, sortindex[i]);
                ++i;
            }
        }
        k = this.vorbis_bitrate_managed() ? 0 : 7;
        while (k <= (this.vorbis_bitrate_managed() ? 14 : 7)) {
            oggpack_buffer opb_local = vbi.packetblob[k];
            opb_local.oggpack_write(0, 1);
            opb_local.oggpack_write(modenumber, b.modebits);
            if (this.W > 0) {
                opb_local.oggpack_write(this.lW, 1);
                opb_local.oggpack_write(this.nW, 1);
            }
            i = 0;
            while (i < vi.channels) {
                int submap = info.chmuxlist[i];
                float[] mdct = gmdct[i];
                float[] res = this.pcm[i];
                ilogmaskch[i] = new int[n / 2];
                int[] ilogmask = ilogmaskch[i];
                nonzero[i] = opb_local.floor1_encode(this, b.flr[info.floorsubmap[submap]], floor_posts[i][k], ilogmask);
                this._vp_remove_floor(b.psy[psy_look_offset], mdct, ilogmask, res, ci.psy_g_param.sliding_lowpass[this.W][k]);
                this._vp_noise_normalize(b.psy[psy_look_offset], res, n / 2, sortindex[i]);
                ++i;
            }
            if (info.coupling_steps > 0) {
                this._vp_couple(k, ci.psy_g_param, b.psy[psy_look_offset], info, this.pcm, mag_memo, mag_sort, ilogmaskch, nonzero, ci.psy_g_param.sliding_lowpass[this.W][k]);
            }
            i = 0;
            while (i < info.submaps) {
                int ch_in_bundle = 0;
                int resnum = info.residuesubmap[i];
                j = 0;
                while (j < vi.channels) {
                    if (info.chmuxlist[j] == i) {
                        zerobundle[ch_in_bundle] = 0;
                        if (nonzero[j] > 0) {
                            zerobundle[ch_in_bundle] = 1;
                        }
                        res_bundle[ch_in_bundle] = this.pcm[j];
                        couple_bundle[ch_in_bundle++] = this.pcm[j];
                        couple_bundle_offset = n / 2;
                    }
                    ++j;
                }
                int[][] classifications = this.res2_class(b.residue[resnum], couple_bundle, couple_bundle_offset, zerobundle, ch_in_bundle);
                this.res2_forward(opb_local, b.residue[resnum], couple_bundle, couple_bundle_offset, null, zerobundle, ch_in_bundle, classifications);
                ++i;
            }
            ++k;
        }
    }

    public boolean vorbis_bitrate_addblock() {
        int avg_target_bits;
        int max_target_bits;
        int min_target_bits;
        vorbis_block_internal vbi = this.internal;
        private_state b = this.vd.backend_state;
        bitrate_manager_state bm = b.bms;
        vorbis_info vi = this.vd.vi;
        codec_setup_info ci = vi.codec_setup;
        bitrate_manager_info bi = ci.bi;
        int choice = new Double(Math.rint(bm.avgfloat)).intValue();
        int this_bits = vbi.packetblob[choice].oggpack_bytes() * 8;
        if (this.W > 0) {
            min_target_bits = bm.min_bitsper * bm.short_per_long;
            max_target_bits = bm.max_bitsper * bm.short_per_long;
            avg_target_bits = bm.avg_bitsper * bm.short_per_long;
        } else {
            min_target_bits = bm.min_bitsper;
            max_target_bits = bm.max_bitsper;
            avg_target_bits = bm.avg_bitsper;
        }
        int samples = ci.blocksizes[this.W] >> 1;
        int desired_fill = new Float((float)bi.reservoir_bits * bi.reservoir_bias).intValue();
        if (bm.managed <= 0) {
            if (bm.vb != null) {
                return false;
            }
            bm.vb = this;
            return true;
        }
        bm.vb = this;
        if (bm.avg_bitsper > 0) {
            float slew = 0.0f;
            float slewlimit = 15.0f / bi.slew_damp;
            if (bm.avg_reservoir + (this_bits - avg_target_bits) > desired_fill) {
                while (choice > 0 && this_bits > avg_target_bits && bm.avg_reservoir + (this_bits - avg_target_bits) > desired_fill) {
                    this_bits = vbi.packetblob[--choice].oggpack_bytes() * 8;
                }
            } else if (bm.avg_reservoir + (this_bits - avg_target_bits) < desired_fill) {
                while (choice + 1 < 15 && this_bits < avg_target_bits && bm.avg_reservoir + (this_bits - avg_target_bits) < desired_fill) {
                    this_bits = vbi.packetblob[++choice].oggpack_bytes() * 8;
                }
            }
            if ((slew = new Double(Math.rint((float)choice - bm.avgfloat) / (double)samples * (double)vi.rate).floatValue()) < -slewlimit) {
                slew = -slewlimit;
            }
            if (slew > slewlimit) {
                slew = slewlimit;
            }
            choice = new Float(Math.rint(bm.avgfloat += slew / (float)vi.rate * (float)samples)).intValue();
            this_bits = vbi.packetblob[choice].oggpack_bytes() * 8;
        }
        if (bm.min_bitsper > 0 && this_bits < min_target_bits) {
            while (bm.minmax_reservoir - (min_target_bits - this_bits) < 0) {
                if (++choice >= 15) break;
                this_bits = vbi.packetblob[choice].oggpack_bytes() * 8;
            }
        }
        if (bm.max_bitsper > 0 && this_bits > max_target_bits) {
            while (bm.minmax_reservoir + (this_bits - max_target_bits) > bi.reservoir_bits) {
                if (--choice < 0) break;
                this_bits = vbi.packetblob[choice].oggpack_bytes() * 8;
            }
        }
        if (choice < 0) {
            int maxsize = (max_target_bits + (bi.reservoir_bits - bm.minmax_reservoir)) / 8;
            choice = 0;
            bm.choice = 0;
            if (vbi.packetblob[choice].oggpack_bytes() > maxsize) {
                vbi.packetblob[choice].oggpack_writetrunc(maxsize * 8);
                this_bits = vbi.packetblob[choice].oggpack_bytes() * 8;
            }
        } else {
            int minsize = (min_target_bits - bm.minmax_reservoir + 7) / 8;
            if (choice >= 15) {
                choice = 14;
            }
            bm.choice = choice;
            minsize -= vbi.packetblob[choice].oggpack_bytes();
            while (minsize-- > 0) {
                vbi.packetblob[choice].oggpack_write(0, 8);
            }
            this_bits = vbi.packetblob[choice].oggpack_bytes() * 8;
        }
        if (bm.min_bitsper > 0 || bm.max_bitsper > 0) {
            if (max_target_bits > 0 && this_bits > max_target_bits) {
                bm.minmax_reservoir += this_bits - max_target_bits;
            } else if (min_target_bits > 0 && this_bits < min_target_bits) {
                bm.minmax_reservoir += this_bits - min_target_bits;
            } else if (bm.minmax_reservoir > desired_fill) {
                if (max_target_bits > 0) {
                    bm.minmax_reservoir += this_bits - max_target_bits;
                    if (bm.minmax_reservoir < desired_fill) {
                        bm.minmax_reservoir = desired_fill;
                    }
                } else {
                    bm.minmax_reservoir = desired_fill;
                }
            } else if (min_target_bits > 0) {
                bm.minmax_reservoir += this_bits - min_target_bits;
                if (bm.minmax_reservoir > desired_fill) {
                    bm.minmax_reservoir = desired_fill;
                }
            } else {
                bm.minmax_reservoir = desired_fill;
            }
        }
        if (bm.avg_bitsper > 0) {
            avg_target_bits = this.W > 0 ? bm.avg_bitsper * bm.short_per_long : bm.avg_bitsper;
            bm.avg_reservoir += this_bits - avg_target_bits;
        }
        return true;
    }
}

