/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.libogg;

public class ogg_page {
    public byte[] header;
    public int header_len;
    public byte[] body;
    public int body_len;
    private static int[] crc_lookup = new int[256];

    static {
        int i = 0;
        while (i < crc_lookup.length) {
            ogg_page.crc_lookup[i] = ogg_page.crc_entry(i);
            ++i;
        }
    }

    private static int crc_entry(int index) {
        int r = index << 24;
        int i = 0;
        while (i < 8) {
            r = (r & Integer.MIN_VALUE) != 0 ? r << 1 ^ 0x4C11DB7 : (r <<= 1);
            ++i;
        }
        return r & 0xFFFFFFFF;
    }

    public int ogg_page_eos() {
        return this.header[5] & 4;
    }

    public void ogg_page_checksum_set() {
        int crc_reg = 0;
        this.header[22] = 0;
        this.header[23] = 0;
        this.header[24] = 0;
        this.header[25] = 0;
        int i = 0;
        while (i < this.header_len) {
            crc_reg = crc_reg << 8 ^ crc_lookup[crc_reg >>> 24 & 0xFF ^ this.header[i] & 0xFF];
            ++i;
        }
        i = 0;
        while (i < this.body_len) {
            crc_reg = crc_reg << 8 ^ crc_lookup[crc_reg >>> 24 & 0xFF ^ this.body[i] & 0xFF];
            ++i;
        }
        this.header[22] = (byte)crc_reg;
        this.header[23] = (byte)(crc_reg >>> 8);
        this.header[24] = (byte)(crc_reg >>> 16);
        this.header[25] = (byte)(crc_reg >>> 24);
    }
}

