<?php
if ( ! empty($cat_ID) ) {
	$heading = __('Edit Category');
	$submit_text = __('Edit Category &raquo;');
	$form = '<form name="editcat" id="editcat" method="post" action="categories.php">';
	$action = 'editedcat';
	$nonce_action = 'update-category_' . $cat_ID;
} else {
	$heading = __('Add Category');
	$submit_text = __('Add Category &raquo;');
	$form = '<form name="addcat" id="addcat" method="post" action="categories.php">';
	$action = 'addcat';
	$nonce_action = 'add-category';
}
?>

<div class="wrap">
<h2><?php echo $heading ?></h2>
<?php echo $form ?>
<input type="hidden" name="action" value="<?php echo $action ?>" />
<input type="hidden" name="cat_ID" value="<?php echo $category->cat_ID ?>" />
<?php wp_nonce_field($nonce_action); ?>
<?php autocomplete_css(); ?>
	<table class="editform" width="100%" cellspacing="2" cellpadding="5">
		<tr>
		  <th width="33%" scope="row" valign="top"><label for="cat_name"><?php _e('Category name:') ?></label></th>
		  <td width="67%"><input type="text" id="cat_name" name="cat_name" value="<?php echo wp_specialchars($category->cat_name); ?>" size="40" /><div id="searchresults" class="autocomplete"></div></td>
		</tr>
		<tr>
			<th scope="row" valign="top"><label for="category_parent"><?php _e('Category parent:') ?></label></th>
			<td>        
	  			<?php wp_dropdown_categories('hide_empty=0&name=category_parent&selected=' . $category->category_parent . '&hierarchical=1&show_option_none=' . __('None')); ?>
	  		</td>
		</tr>
		<tr>
			<th scope="row" valign="top"><label for="category_description"><?php _e('Description: (optional)') ?></label></th>
			<td><textarea name="category_description" id="category_description" rows="5" cols="50" style="width: 97%;"><?php echo wp_specialchars($category->category_description, 1); ?></textarea></td>
		</tr>
	</table>
<?php autocomplete_textbox( "wpmu-edit.php?action=searchcategories&search=", "cat_name", "searchresults" ); ?>
<p class="submit"><input type="submit" name="submit" value="<?php echo $submit_text ?>" /></p>
<div id="ajax-response"></div>
</form>
</div>
