/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 4306:
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	autosize 4.0.4
	license: MIT
	http://www.jacklmoore.com/autosize
*/
(function (global, factory) {
	if (true) {
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else { var mod; }
})(this, function (module, exports) {
	'use strict';

	var map = typeof Map === "function" ? new Map() : function () {
		var keys = [];
		var values = [];

		return {
			has: function has(key) {
				return keys.indexOf(key) > -1;
			},
			get: function get(key) {
				return values[keys.indexOf(key)];
			},
			set: function set(key, value) {
				if (keys.indexOf(key) === -1) {
					keys.push(key);
					values.push(value);
				}
			},
			delete: function _delete(key) {
				var index = keys.indexOf(key);
				if (index > -1) {
					keys.splice(index, 1);
					values.splice(index, 1);
				}
			}
		};
	}();

	var createEvent = function createEvent(name) {
		return new Event(name, { bubbles: true });
	};
	try {
		new Event('test');
	} catch (e) {
		// IE does not support `new Event()`
		createEvent = function createEvent(name) {
			var evt = document.createEvent('Event');
			evt.initEvent(name, true, false);
			return evt;
		};
	}

	function assign(ta) {
		if (!ta || !ta.nodeName || ta.nodeName !== 'TEXTAREA' || map.has(ta)) return;

		var heightOffset = null;
		var clientWidth = null;
		var cachedHeight = null;

		function init() {
			var style = window.getComputedStyle(ta, null);

			if (style.resize === 'vertical') {
				ta.style.resize = 'none';
			} else if (style.resize === 'both') {
				ta.style.resize = 'horizontal';
			}

			if (style.boxSizing === 'content-box') {
				heightOffset = -(parseFloat(style.paddingTop) + parseFloat(style.paddingBottom));
			} else {
				heightOffset = parseFloat(style.borderTopWidth) + parseFloat(style.borderBottomWidth);
			}
			// Fix when a textarea is not on document body and heightOffset is Not a Number
			if (isNaN(heightOffset)) {
				heightOffset = 0;
			}

			update();
		}

		function changeOverflow(value) {
			{
				// Chrome/Safari-specific fix:
				// When the textarea y-overflow is hidden, Chrome/Safari do not reflow the text to account for the space
				// made available by removing the scrollbar. The following forces the necessary text reflow.
				var width = ta.style.width;
				ta.style.width = '0px';
				// Force reflow:
				/* jshint ignore:start */
				ta.offsetWidth;
				/* jshint ignore:end */
				ta.style.width = width;
			}

			ta.style.overflowY = value;
		}

		function getParentOverflows(el) {
			var arr = [];

			while (el && el.parentNode && el.parentNode instanceof Element) {
				if (el.parentNode.scrollTop) {
					arr.push({
						node: el.parentNode,
						scrollTop: el.parentNode.scrollTop
					});
				}
				el = el.parentNode;
			}

			return arr;
		}

		function resize() {
			if (ta.scrollHeight === 0) {
				// If the scrollHeight is 0, then the element probably has display:none or is detached from the DOM.
				return;
			}

			var overflows = getParentOverflows(ta);
			var docTop = document.documentElement && document.documentElement.scrollTop; // Needed for Mobile IE (ticket #240)

			ta.style.height = '';
			ta.style.height = ta.scrollHeight + heightOffset + 'px';

			// used to check if an update is actually necessary on window.resize
			clientWidth = ta.clientWidth;

			// prevents scroll-position jumping
			overflows.forEach(function (el) {
				el.node.scrollTop = el.scrollTop;
			});

			if (docTop) {
				document.documentElement.scrollTop = docTop;
			}
		}

		function update() {
			resize();

			var styleHeight = Math.round(parseFloat(ta.style.height));
			var computed = window.getComputedStyle(ta, null);

			// Using offsetHeight as a replacement for computed.height in IE, because IE does not account use of border-box
			var actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(computed.height)) : ta.offsetHeight;

			// The actual height not matching the style height (set via the resize method) indicates that 
			// the max-height has been exceeded, in which case the overflow should be allowed.
			if (actualHeight < styleHeight) {
				if (computed.overflowY === 'hidden') {
					changeOverflow('scroll');
					resize();
					actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(window.getComputedStyle(ta, null).height)) : ta.offsetHeight;
				}
			} else {
				// Normally keep overflow set to hidden, to avoid flash of scrollbar as the textarea expands.
				if (computed.overflowY !== 'hidden') {
					changeOverflow('hidden');
					resize();
					actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(window.getComputedStyle(ta, null).height)) : ta.offsetHeight;
				}
			}

			if (cachedHeight !== actualHeight) {
				cachedHeight = actualHeight;
				var evt = createEvent('autosize:resized');
				try {
					ta.dispatchEvent(evt);
				} catch (err) {
					// Firefox will throw an error on dispatchEvent for a detached element
					// https://bugzilla.mozilla.org/show_bug.cgi?id=889376
				}
			}
		}

		var pageResize = function pageResize() {
			if (ta.clientWidth !== clientWidth) {
				update();
			}
		};

		var destroy = function (style) {
			window.removeEventListener('resize', pageResize, false);
			ta.removeEventListener('input', update, false);
			ta.removeEventListener('keyup', update, false);
			ta.removeEventListener('autosize:destroy', destroy, false);
			ta.removeEventListener('autosize:update', update, false);

			Object.keys(style).forEach(function (key) {
				ta.style[key] = style[key];
			});

			map.delete(ta);
		}.bind(ta, {
			height: ta.style.height,
			resize: ta.style.resize,
			overflowY: ta.style.overflowY,
			overflowX: ta.style.overflowX,
			wordWrap: ta.style.wordWrap
		});

		ta.addEventListener('autosize:destroy', destroy, false);

		// IE9 does not fire onpropertychange or oninput for deletions,
		// so binding to onkeyup to catch most of those events.
		// There is no way that I know of to detect something like 'cut' in IE9.
		if ('onpropertychange' in ta && 'oninput' in ta) {
			ta.addEventListener('keyup', update, false);
		}

		window.addEventListener('resize', pageResize, false);
		ta.addEventListener('input', update, false);
		ta.addEventListener('autosize:update', update, false);
		ta.style.overflowX = 'hidden';
		ta.style.wordWrap = 'break-word';

		map.set(ta, {
			destroy: destroy,
			update: update
		});

		init();
	}

	function destroy(ta) {
		var methods = map.get(ta);
		if (methods) {
			methods.destroy();
		}
	}

	function update(ta) {
		var methods = map.get(ta);
		if (methods) {
			methods.update();
		}
	}

	var autosize = null;

	// Do nothing in Node.js environment and IE8 (or lower)
	if (typeof window === 'undefined' || typeof window.getComputedStyle !== 'function') {
		autosize = function autosize(el) {
			return el;
		};
		autosize.destroy = function (el) {
			return el;
		};
		autosize.update = function (el) {
			return el;
		};
	} else {
		autosize = function autosize(el, options) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], function (x) {
					return assign(x, options);
				});
			}
			return el;
		};
		autosize.destroy = function (el) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], destroy);
			}
			return el;
		};
		autosize.update = function (el) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], update);
			}
			return el;
		};
	}

	exports.default = autosize;
	module.exports = exports['default'];
});

/***/ }),

/***/ 6109:
/***/ ((module) => {

// This code has been refactored for 140 bytes
// You can see the original here: https://github.com/twolfson/computedStyle/blob/04cd1da2e30fa45844f95f5cb1ac898e9b9ef050/lib/computedStyle.js
var computedStyle = function (el, prop, getComputedStyle) {
  getComputedStyle = window.getComputedStyle;

  // In one fell swoop
  return (
    // If we have getComputedStyle
    getComputedStyle ?
      // Query it
      // TODO: From CSS-Query notes, we might need (node, null) for FF
      getComputedStyle(el) :

    // Otherwise, we are in IE and use currentStyle
      el.currentStyle
  )[
    // Switch to camelCase for CSSOM
    // DEV: Grabbed from jQuery
    // https://github.com/jquery/jquery/blob/1.9-stable/src/css.js#L191-L194
    // https://github.com/jquery/jquery/blob/1.9-stable/src/core.js#L593-L597
    prop.replace(/-(\w)/gi, function (word, letter) {
      return letter.toUpperCase();
    })
  ];
};

module.exports = computedStyle;


/***/ }),

/***/ 5417:
/***/ ((__unused_webpack_module, exports) => {

"use strict";
/*istanbul ignore start*/


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = Diff;

/*istanbul ignore end*/
function Diff() {}

Diff.prototype = {
  /*istanbul ignore start*/

  /*istanbul ignore end*/
  diff: function diff(oldString, newString) {
    /*istanbul ignore start*/
    var
    /*istanbul ignore end*/
    options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var callback = options.callback;

    if (typeof options === 'function') {
      callback = options;
      options = {};
    }

    this.options = options;
    var self = this;

    function done(value) {
      if (callback) {
        setTimeout(function () {
          callback(undefined, value);
        }, 0);
        return true;
      } else {
        return value;
      }
    } // Allow subclasses to massage the input prior to running


    oldString = this.castInput(oldString);
    newString = this.castInput(newString);
    oldString = this.removeEmpty(this.tokenize(oldString));
    newString = this.removeEmpty(this.tokenize(newString));
    var newLen = newString.length,
        oldLen = oldString.length;
    var editLength = 1;
    var maxEditLength = newLen + oldLen;
    var bestPath = [{
      newPos: -1,
      components: []
    }]; // Seed editLength = 0, i.e. the content starts with the same values

    var oldPos = this.extractCommon(bestPath[0], newString, oldString, 0);

    if (bestPath[0].newPos + 1 >= newLen && oldPos + 1 >= oldLen) {
      // Identity per the equality and tokenizer
      return done([{
        value: this.join(newString),
        count: newString.length
      }]);
    } // Main worker method. checks all permutations of a given edit length for acceptance.


    function execEditLength() {
      for (var diagonalPath = -1 * editLength; diagonalPath <= editLength; diagonalPath += 2) {
        var basePath =
        /*istanbul ignore start*/
        void 0
        /*istanbul ignore end*/
        ;

        var addPath = bestPath[diagonalPath - 1],
            removePath = bestPath[diagonalPath + 1],
            _oldPos = (removePath ? removePath.newPos : 0) - diagonalPath;

        if (addPath) {
          // No one else is going to attempt to use this value, clear it
          bestPath[diagonalPath - 1] = undefined;
        }

        var canAdd = addPath && addPath.newPos + 1 < newLen,
            canRemove = removePath && 0 <= _oldPos && _oldPos < oldLen;

        if (!canAdd && !canRemove) {
          // If this path is a terminal then prune
          bestPath[diagonalPath] = undefined;
          continue;
        } // Select the diagonal that we want to branch from. We select the prior
        // path whose position in the new string is the farthest from the origin
        // and does not pass the bounds of the diff graph


        if (!canAdd || canRemove && addPath.newPos < removePath.newPos) {
          basePath = clonePath(removePath);
          self.pushComponent(basePath.components, undefined, true);
        } else {
          basePath = addPath; // No need to clone, we've pulled it from the list

          basePath.newPos++;
          self.pushComponent(basePath.components, true, undefined);
        }

        _oldPos = self.extractCommon(basePath, newString, oldString, diagonalPath); // If we have hit the end of both strings, then we are done

        if (basePath.newPos + 1 >= newLen && _oldPos + 1 >= oldLen) {
          return done(buildValues(self, basePath.components, newString, oldString, self.useLongestToken));
        } else {
          // Otherwise track this path as a potential candidate and continue.
          bestPath[diagonalPath] = basePath;
        }
      }

      editLength++;
    } // Performs the length of edit iteration. Is a bit fugly as this has to support the
    // sync and async mode which is never fun. Loops over execEditLength until a value
    // is produced.


    if (callback) {
      (function exec() {
        setTimeout(function () {
          // This should not happen, but we want to be safe.

          /* istanbul ignore next */
          if (editLength > maxEditLength) {
            return callback();
          }

          if (!execEditLength()) {
            exec();
          }
        }, 0);
      })();
    } else {
      while (editLength <= maxEditLength) {
        var ret = execEditLength();

        if (ret) {
          return ret;
        }
      }
    }
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  pushComponent: function pushComponent(components, added, removed) {
    var last = components[components.length - 1];

    if (last && last.added === added && last.removed === removed) {
      // We need to clone here as the component clone operation is just
      // as shallow array clone
      components[components.length - 1] = {
        count: last.count + 1,
        added: added,
        removed: removed
      };
    } else {
      components.push({
        count: 1,
        added: added,
        removed: removed
      });
    }
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  extractCommon: function extractCommon(basePath, newString, oldString, diagonalPath) {
    var newLen = newString.length,
        oldLen = oldString.length,
        newPos = basePath.newPos,
        oldPos = newPos - diagonalPath,
        commonCount = 0;

    while (newPos + 1 < newLen && oldPos + 1 < oldLen && this.equals(newString[newPos + 1], oldString[oldPos + 1])) {
      newPos++;
      oldPos++;
      commonCount++;
    }

    if (commonCount) {
      basePath.components.push({
        count: commonCount
      });
    }

    basePath.newPos = newPos;
    return oldPos;
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  equals: function equals(left, right) {
    if (this.options.comparator) {
      return this.options.comparator(left, right);
    } else {
      return left === right || this.options.ignoreCase && left.toLowerCase() === right.toLowerCase();
    }
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  removeEmpty: function removeEmpty(array) {
    var ret = [];

    for (var i = 0; i < array.length; i++) {
      if (array[i]) {
        ret.push(array[i]);
      }
    }

    return ret;
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  castInput: function castInput(value) {
    return value;
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  tokenize: function tokenize(value) {
    return value.split('');
  },

  /*istanbul ignore start*/

  /*istanbul ignore end*/
  join: function join(chars) {
    return chars.join('');
  }
};

function buildValues(diff, components, newString, oldString, useLongestToken) {
  var componentPos = 0,
      componentLen = components.length,
      newPos = 0,
      oldPos = 0;

  for (; componentPos < componentLen; componentPos++) {
    var component = components[componentPos];

    if (!component.removed) {
      if (!component.added && useLongestToken) {
        var value = newString.slice(newPos, newPos + component.count);
        value = value.map(function (value, i) {
          var oldValue = oldString[oldPos + i];
          return oldValue.length > value.length ? oldValue : value;
        });
        component.value = diff.join(value);
      } else {
        component.value = diff.join(newString.slice(newPos, newPos + component.count));
      }

      newPos += component.count; // Common case

      if (!component.added) {
        oldPos += component.count;
      }
    } else {
      component.value = diff.join(oldString.slice(oldPos, oldPos + component.count));
      oldPos += component.count; // Reverse add and remove so removes are output first to match common convention
      // The diffing algorithm is tied to add then remove output and this is the simplest
      // route to get the desired output with minimal overhead.

      if (componentPos && components[componentPos - 1].added) {
        var tmp = components[componentPos - 1];
        components[componentPos - 1] = components[componentPos];
        components[componentPos] = tmp;
      }
    }
  } // Special case handle for when one terminal is ignored (i.e. whitespace).
  // For this case we merge the terminal into the prior string and drop the change.
  // This is only available for string mode.


  var lastComponent = components[componentLen - 1];

  if (componentLen > 1 && typeof lastComponent.value === 'string' && (lastComponent.added || lastComponent.removed) && diff.equals('', lastComponent.value)) {
    components[componentLen - 2].value += lastComponent.value;
    components.pop();
  }

  return components;
}

function clonePath(path) {
  return {
    newPos: path.newPos,
    components: path.components.slice(0)
  };
}


/***/ }),

/***/ 8021:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
var __webpack_unused_export__;
/*istanbul ignore start*/


__webpack_unused_export__ = ({
  value: true
});
exports.JJ = diffChars;
__webpack_unused_export__ = void 0;

/*istanbul ignore end*/
var
/*istanbul ignore start*/
_base = _interopRequireDefault(__webpack_require__(5417))
/*istanbul ignore end*/
;

/*istanbul ignore start*/ function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*istanbul ignore end*/
var characterDiff = new
/*istanbul ignore start*/
_base
/*istanbul ignore end*/
.
/*istanbul ignore start*/
default
/*istanbul ignore end*/
();

/*istanbul ignore start*/
__webpack_unused_export__ = characterDiff;

/*istanbul ignore end*/
function diffChars(oldStr, newStr, options) {
  return characterDiff.diff(oldStr, newStr, options);
}


/***/ }),

/***/ 7734:
/***/ ((module) => {

"use strict";


// do not edit .js files directly - edit src/index.jst


  var envHasBigInt64Array = typeof BigInt64Array !== 'undefined';


module.exports = function equal(a, b) {
  if (a === b) return true;

  if (a && b && typeof a == 'object' && typeof b == 'object') {
    if (a.constructor !== b.constructor) return false;

    var length, i, keys;
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (!equal(a[i], b[i])) return false;
      return true;
    }


    if ((a instanceof Map) && (b instanceof Map)) {
      if (a.size !== b.size) return false;
      for (i of a.entries())
        if (!b.has(i[0])) return false;
      for (i of a.entries())
        if (!equal(i[1], b.get(i[0]))) return false;
      return true;
    }

    if ((a instanceof Set) && (b instanceof Set)) {
      if (a.size !== b.size) return false;
      for (i of a.entries())
        if (!b.has(i[0])) return false;
      return true;
    }

    if (ArrayBuffer.isView(a) && ArrayBuffer.isView(b)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (a[i] !== b[i]) return false;
      return true;
    }


    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();

    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) return false;

    for (i = length; i-- !== 0;)
      if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;

    for (i = length; i-- !== 0;) {
      var key = keys[i];

      if (!equal(a[key], b[key])) return false;
    }

    return true;
  }

  // true if both NaN, false otherwise
  return a!==a && b!==b;
};


/***/ }),

/***/ 5215:
/***/ ((module) => {

"use strict";


// do not edit .js files directly - edit src/index.jst



module.exports = function equal(a, b) {
  if (a === b) return true;

  if (a && b && typeof a == 'object' && typeof b == 'object') {
    if (a.constructor !== b.constructor) return false;

    var length, i, keys;
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (!equal(a[i], b[i])) return false;
      return true;
    }



    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();

    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) return false;

    for (i = length; i-- !== 0;)
      if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;

    for (i = length; i-- !== 0;) {
      var key = keys[i];

      if (!equal(a[key], b[key])) return false;
    }

    return true;
  }

  // true if both NaN, false otherwise
  return a!==a && b!==b;
};


/***/ }),

/***/ 461:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Load in dependencies
var computedStyle = __webpack_require__(6109);

/**
 * Calculate the `line-height` of a given node
 * @param {HTMLElement} node Element to calculate line height of. Must be in the DOM.
 * @returns {Number} `line-height` of the element in pixels
 */
function lineHeight(node) {
  // Grab the line-height via style
  var lnHeightStr = computedStyle(node, 'line-height');
  var lnHeight = parseFloat(lnHeightStr, 10);

  // If the lineHeight did not contain a unit (i.e. it was numeric), convert it to ems (e.g. '2.3' === '2.3em')
  if (lnHeightStr === lnHeight + '') {
    // Save the old lineHeight style and update the em unit to the element
    var _lnHeightStyle = node.style.lineHeight;
    node.style.lineHeight = lnHeightStr + 'em';

    // Calculate the em based height
    lnHeightStr = computedStyle(node, 'line-height');
    lnHeight = parseFloat(lnHeightStr, 10);

    // Revert the lineHeight style
    if (_lnHeightStyle) {
      node.style.lineHeight = _lnHeightStyle;
    } else {
      delete node.style.lineHeight;
    }
  }

  // If the lineHeight is in `pt`, convert it to pixels (4px for 3pt)
  // DEV: `em` units are converted to `pt` in IE6
  // Conversion ratio from https://developer.mozilla.org/en-US/docs/Web/CSS/length
  if (lnHeightStr.indexOf('pt') !== -1) {
    lnHeight *= 4;
    lnHeight /= 3;
  // Otherwise, if the lineHeight is in `mm`, convert it to pixels (96px for 25.4mm)
  } else if (lnHeightStr.indexOf('mm') !== -1) {
    lnHeight *= 96;
    lnHeight /= 25.4;
  // Otherwise, if the lineHeight is in `cm`, convert it to pixels (96px for 2.54cm)
  } else if (lnHeightStr.indexOf('cm') !== -1) {
    lnHeight *= 96;
    lnHeight /= 2.54;
  // Otherwise, if the lineHeight is in `in`, convert it to pixels (96px for 1in)
  } else if (lnHeightStr.indexOf('in') !== -1) {
    lnHeight *= 96;
  // Otherwise, if the lineHeight is in `pc`, convert it to pixels (12pt for 1pc)
  } else if (lnHeightStr.indexOf('pc') !== -1) {
    lnHeight *= 16;
  }

  // Continue our computation
  lnHeight = Math.round(lnHeight);

  // If the line-height is "normal", calculate by font-size
  if (lnHeightStr === 'normal') {
    // Create a temporary node
    var nodeName = node.nodeName;
    var _node = document.createElement(nodeName);
    _node.innerHTML = '&nbsp;';

    // If we have a text area, reset it to only 1 row
    // https://github.com/twolfson/line-height/issues/4
    if (nodeName.toUpperCase() === 'TEXTAREA') {
      _node.setAttribute('rows', '1');
    }

    // Set the font-size of the element
    var fontSizeStr = computedStyle(node, 'font-size');
    _node.style.fontSize = fontSizeStr;

    // Remove default padding/border which can affect offset height
    // https://github.com/twolfson/line-height/issues/4
    // https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/offsetHeight
    _node.style.padding = '0px';
    _node.style.border = '0px';

    // Append it to the body
    var body = document.body;
    body.appendChild(_node);

    // Assume the line height of the element is the height
    var height = _node.offsetHeight;
    lnHeight = height;

    // Remove our child from the DOM
    body.removeChild(_node);
  }

  // Return the calculated height
  return lnHeight;
}

// Export lineHeight
module.exports = lineHeight;


/***/ }),

/***/ 7520:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(7191);


/***/ }),

/***/ 8202:
/***/ ((module) => {

"use strict";
/**
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule ExecutionEnvironment
 */

/*jslint evil: true */



var canUseDOM = !!(
  typeof window !== 'undefined' &&
  window.document &&
  window.document.createElement
);

/**
 * Simple, lightweight module assisting with the detection and context of
 * Worker. Helps avoid circular dependencies and allows code to reason about
 * whether or not they are in a Worker, even if they never include the main
 * `ReactWorker` dependency.
 */
var ExecutionEnvironment = {

  canUseDOM: canUseDOM,

  canUseWorkers: typeof Worker !== 'undefined',

  canUseEventListeners:
    canUseDOM && !!(window.addEventListener || window.attachEvent),

  canUseViewport: canUseDOM && !!window.screen,

  isInWorker: !canUseDOM // For now, this is true - might change in the future.

};

module.exports = ExecutionEnvironment;


/***/ }),

/***/ 2213:
/***/ ((module) => {

/**
 * Copyright 2004-present Facebook. All Rights Reserved.
 *
 * @providesModule UserAgent_DEPRECATED
 */

/**
 *  Provides entirely client-side User Agent and OS detection. You should prefer
 *  the non-deprecated UserAgent module when possible, which exposes our
 *  authoritative server-side PHP-based detection to the client.
 *
 *  Usage is straightforward:
 *
 *    if (UserAgent_DEPRECATED.ie()) {
 *      //  IE
 *    }
 *
 *  You can also do version checks:
 *
 *    if (UserAgent_DEPRECATED.ie() >= 7) {
 *      //  IE7 or better
 *    }
 *
 *  The browser functions will return NaN if the browser does not match, so
 *  you can also do version compares the other way:
 *
 *    if (UserAgent_DEPRECATED.ie() < 7) {
 *      //  IE6 or worse
 *    }
 *
 *  Note that the version is a float and may include a minor version number,
 *  so you should always use range operators to perform comparisons, not
 *  strict equality.
 *
 *  **Note:** You should **strongly** prefer capability detection to browser
 *  version detection where it's reasonable:
 *
 *    http://www.quirksmode.org/js/support.html
 *
 *  Further, we have a large number of mature wrapper functions and classes
 *  which abstract away many browser irregularities. Check the documentation,
 *  grep for things, or ask on javascript@lists.facebook.com before writing yet
 *  another copy of "event || window.event".
 *
 */

var _populated = false;

// Browsers
var _ie, _firefox, _opera, _webkit, _chrome;

// Actual IE browser for compatibility mode
var _ie_real_version;

// Platforms
var _osx, _windows, _linux, _android;

// Architectures
var _win64;

// Devices
var _iphone, _ipad, _native;

var _mobile;

function _populate() {
  if (_populated) {
    return;
  }

  _populated = true;

  // To work around buggy JS libraries that can't handle multi-digit
  // version numbers, Opera 10's user agent string claims it's Opera
  // 9, then later includes a Version/X.Y field:
  //
  // Opera/9.80 (foo) Presto/2.2.15 Version/10.10
  var uas = navigator.userAgent;
  var agent = /(?:MSIE.(\d+\.\d+))|(?:(?:Firefox|GranParadiso|Iceweasel).(\d+\.\d+))|(?:Opera(?:.+Version.|.)(\d+\.\d+))|(?:AppleWebKit.(\d+(?:\.\d+)?))|(?:Trident\/\d+\.\d+.*rv:(\d+\.\d+))/.exec(uas);
  var os    = /(Mac OS X)|(Windows)|(Linux)/.exec(uas);

  _iphone = /\b(iPhone|iP[ao]d)/.exec(uas);
  _ipad = /\b(iP[ao]d)/.exec(uas);
  _android = /Android/i.exec(uas);
  _native = /FBAN\/\w+;/i.exec(uas);
  _mobile = /Mobile/i.exec(uas);

  // Note that the IE team blog would have you believe you should be checking
  // for 'Win64; x64'.  But MSDN then reveals that you can actually be coming
  // from either x64 or ia64;  so ultimately, you should just check for Win64
  // as in indicator of whether you're in 64-bit IE.  32-bit IE on 64-bit
  // Windows will send 'WOW64' instead.
  _win64 = !!(/Win64/.exec(uas));

  if (agent) {
    _ie = agent[1] ? parseFloat(agent[1]) : (
          agent[5] ? parseFloat(agent[5]) : NaN);
    // IE compatibility mode
    if (_ie && document && document.documentMode) {
      _ie = document.documentMode;
    }
    // grab the "true" ie version from the trident token if available
    var trident = /(?:Trident\/(\d+.\d+))/.exec(uas);
    _ie_real_version = trident ? parseFloat(trident[1]) + 4 : _ie;

    _firefox = agent[2] ? parseFloat(agent[2]) : NaN;
    _opera   = agent[3] ? parseFloat(agent[3]) : NaN;
    _webkit  = agent[4] ? parseFloat(agent[4]) : NaN;
    if (_webkit) {
      // We do not add the regexp to the above test, because it will always
      // match 'safari' only since 'AppleWebKit' appears before 'Chrome' in
      // the userAgent string.
      agent = /(?:Chrome\/(\d+\.\d+))/.exec(uas);
      _chrome = agent && agent[1] ? parseFloat(agent[1]) : NaN;
    } else {
      _chrome = NaN;
    }
  } else {
    _ie = _firefox = _opera = _chrome = _webkit = NaN;
  }

  if (os) {
    if (os[1]) {
      // Detect OS X version.  If no version number matches, set _osx to true.
      // Version examples:  10, 10_6_1, 10.7
      // Parses version number as a float, taking only first two sets of
      // digits.  If only one set of digits is found, returns just the major
      // version number.
      var ver = /(?:Mac OS X (\d+(?:[._]\d+)?))/.exec(uas);

      _osx = ver ? parseFloat(ver[1].replace('_', '.')) : true;
    } else {
      _osx = false;
    }
    _windows = !!os[2];
    _linux   = !!os[3];
  } else {
    _osx = _windows = _linux = false;
  }
}

var UserAgent_DEPRECATED = {

  /**
   *  Check if the UA is Internet Explorer.
   *
   *
   *  @return float|NaN Version number (if match) or NaN.
   */
  ie: function() {
    return _populate() || _ie;
  },

  /**
   * Check if we're in Internet Explorer compatibility mode.
   *
   * @return bool true if in compatibility mode, false if
   * not compatibility mode or not ie
   */
  ieCompatibilityMode: function() {
    return _populate() || (_ie_real_version > _ie);
  },


  /**
   * Whether the browser is 64-bit IE.  Really, this is kind of weak sauce;  we
   * only need this because Skype can't handle 64-bit IE yet.  We need to remove
   * this when we don't need it -- tracked by #601957.
   */
  ie64: function() {
    return UserAgent_DEPRECATED.ie() && _win64;
  },

  /**
   *  Check if the UA is Firefox.
   *
   *
   *  @return float|NaN Version number (if match) or NaN.
   */
  firefox: function() {
    return _populate() || _firefox;
  },


  /**
   *  Check if the UA is Opera.
   *
   *
   *  @return float|NaN Version number (if match) or NaN.
   */
  opera: function() {
    return _populate() || _opera;
  },


  /**
   *  Check if the UA is WebKit.
   *
   *
   *  @return float|NaN Version number (if match) or NaN.
   */
  webkit: function() {
    return _populate() || _webkit;
  },

  /**
   *  For Push
   *  WILL BE REMOVED VERY SOON. Use UserAgent_DEPRECATED.webkit
   */
  safari: function() {
    return UserAgent_DEPRECATED.webkit();
  },

  /**
   *  Check if the UA is a Chrome browser.
   *
   *
   *  @return float|NaN Version number (if match) or NaN.
   */
  chrome : function() {
    return _populate() || _chrome;
  },


  /**
   *  Check if the user is running Windows.
   *
   *  @return bool `true' if the user's OS is Windows.
   */
  windows: function() {
    return _populate() || _windows;
  },


  /**
   *  Check if the user is running Mac OS X.
   *
   *  @return float|bool   Returns a float if a version number is detected,
   *                       otherwise true/false.
   */
  osx: function() {
    return _populate() || _osx;
  },

  /**
   * Check if the user is running Linux.
   *
   * @return bool `true' if the user's OS is some flavor of Linux.
   */
  linux: function() {
    return _populate() || _linux;
  },

  /**
   * Check if the user is running on an iPhone or iPod platform.
   *
   * @return bool `true' if the user is running some flavor of the
   *    iPhone OS.
   */
  iphone: function() {
    return _populate() || _iphone;
  },

  mobile: function() {
    return _populate() || (_iphone || _ipad || _android || _mobile);
  },

  nativeApp: function() {
    // webviews inside of the native apps
    return _populate() || _native;
  },

  android: function() {
    return _populate() || _android;
  },

  ipad: function() {
    return _populate() || _ipad;
  }
};

module.exports = UserAgent_DEPRECATED;


/***/ }),

/***/ 1087:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule isEventSupported
 */



var ExecutionEnvironment = __webpack_require__(8202);

var useHasFeature;
if (ExecutionEnvironment.canUseDOM) {
  useHasFeature =
    document.implementation &&
    document.implementation.hasFeature &&
    // always returns true in newer browsers as per the standard.
    // @see http://dom.spec.whatwg.org/#dom-domimplementation-hasfeature
    document.implementation.hasFeature('', '') !== true;
}

/**
 * Checks if an event is supported in the current execution environment.
 *
 * NOTE: This will not work correctly for non-generic events such as `change`,
 * `reset`, `load`, `error`, and `select`.
 *
 * Borrows from Modernizr.
 *
 * @param {string} eventNameSuffix Event name, e.g. "click".
 * @param {?boolean} capture Check if the capture phase is supported.
 * @return {boolean} True if the event is supported.
 * @internal
 * @license Modernizr 3.0.0pre (Custom Build) | MIT
 */
function isEventSupported(eventNameSuffix, capture) {
  if (!ExecutionEnvironment.canUseDOM ||
      capture && !('addEventListener' in document)) {
    return false;
  }

  var eventName = 'on' + eventNameSuffix;
  var isSupported = eventName in document;

  if (!isSupported) {
    var element = document.createElement('div');
    element.setAttribute(eventName, 'return;');
    isSupported = typeof element[eventName] === 'function';
  }

  if (!isSupported && useHasFeature && eventNameSuffix === 'wheel') {
    // This is the only way to test support for the `wheel` event in IE9+.
    isSupported = document.implementation.hasFeature('Events.wheel', '3.0');
  }

  return isSupported;
}

module.exports = isEventSupported;


/***/ }),

/***/ 7191:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule normalizeWheel
 * @typechecks
 */



var UserAgent_DEPRECATED = __webpack_require__(2213);

var isEventSupported = __webpack_require__(1087);


// Reasonable defaults
var PIXEL_STEP  = 10;
var LINE_HEIGHT = 40;
var PAGE_HEIGHT = 800;

/**
 * Mouse wheel (and 2-finger trackpad) support on the web sucks.  It is
 * complicated, thus this doc is long and (hopefully) detailed enough to answer
 * your questions.
 *
 * If you need to react to the mouse wheel in a predictable way, this code is
 * like your bestest friend. * hugs *
 *
 * As of today, there are 4 DOM event types you can listen to:
 *
 *   'wheel'                -- Chrome(31+), FF(17+), IE(9+)
 *   'mousewheel'           -- Chrome, IE(6+), Opera, Safari
 *   'MozMousePixelScroll'  -- FF(3.5 only!) (2010-2013) -- don't bother!
 *   'DOMMouseScroll'       -- FF(0.9.7+) since 2003
 *
 * So what to do?  The is the best:
 *
 *   normalizeWheel.getEventType();
 *
 * In your event callback, use this code to get sane interpretation of the
 * deltas.  This code will return an object with properties:
 *
 *   spinX   -- normalized spin speed (use for zoom) - x plane
 *   spinY   -- " - y plane
 *   pixelX  -- normalized distance (to pixels) - x plane
 *   pixelY  -- " - y plane
 *
 * Wheel values are provided by the browser assuming you are using the wheel to
 * scroll a web page by a number of lines or pixels (or pages).  Values can vary
 * significantly on different platforms and browsers, forgetting that you can
 * scroll at different speeds.  Some devices (like trackpads) emit more events
 * at smaller increments with fine granularity, and some emit massive jumps with
 * linear speed or acceleration.
 *
 * This code does its best to normalize the deltas for you:
 *
 *   - spin is trying to normalize how far the wheel was spun (or trackpad
 *     dragged).  This is super useful for zoom support where you want to
 *     throw away the chunky scroll steps on the PC and make those equal to
 *     the slow and smooth tiny steps on the Mac. Key data: This code tries to
 *     resolve a single slow step on a wheel to 1.
 *
 *   - pixel is normalizing the desired scroll delta in pixel units.  You'll
 *     get the crazy differences between browsers, but at least it'll be in
 *     pixels!
 *
 *   - positive value indicates scrolling DOWN/RIGHT, negative UP/LEFT.  This
 *     should translate to positive value zooming IN, negative zooming OUT.
 *     This matches the newer 'wheel' event.
 *
 * Why are there spinX, spinY (or pixels)?
 *
 *   - spinX is a 2-finger side drag on the trackpad, and a shift + wheel turn
 *     with a mouse.  It results in side-scrolling in the browser by default.
 *
 *   - spinY is what you expect -- it's the classic axis of a mouse wheel.
 *
 *   - I dropped spinZ/pixelZ.  It is supported by the DOM 3 'wheel' event and
 *     probably is by browsers in conjunction with fancy 3D controllers .. but
 *     you know.
 *
 * Implementation info:
 *
 * Examples of 'wheel' event if you scroll slowly (down) by one step with an
 * average mouse:
 *
 *   OS X + Chrome  (mouse)     -    4   pixel delta  (wheelDelta -120)
 *   OS X + Safari  (mouse)     -  N/A   pixel delta  (wheelDelta  -12)
 *   OS X + Firefox (mouse)     -    0.1 line  delta  (wheelDelta  N/A)
 *   Win8 + Chrome  (mouse)     -  100   pixel delta  (wheelDelta -120)
 *   Win8 + Firefox (mouse)     -    3   line  delta  (wheelDelta -120)
 *
 * On the trackpad:
 *
 *   OS X + Chrome  (trackpad)  -    2   pixel delta  (wheelDelta   -6)
 *   OS X + Firefox (trackpad)  -    1   pixel delta  (wheelDelta  N/A)
 *
 * On other/older browsers.. it's more complicated as there can be multiple and
 * also missing delta values.
 *
 * The 'wheel' event is more standard:
 *
 * http://www.w3.org/TR/DOM-Level-3-Events/#events-wheelevents
 *
 * The basics is that it includes a unit, deltaMode (pixels, lines, pages), and
 * deltaX, deltaY and deltaZ.  Some browsers provide other values to maintain
 * backward compatibility with older events.  Those other values help us
 * better normalize spin speed.  Example of what the browsers provide:
 *
 *                          | event.wheelDelta | event.detail
 *        ------------------+------------------+--------------
 *          Safari v5/OS X  |       -120       |       0
 *          Safari v5/Win7  |       -120       |       0
 *         Chrome v17/OS X  |       -120       |       0
 *         Chrome v17/Win7  |       -120       |       0
 *                IE9/Win7  |       -120       |   undefined
 *         Firefox v4/OS X  |     undefined    |       1
 *         Firefox v4/Win7  |     undefined    |       3
 *
 */
function normalizeWheel(/*object*/ event) /*object*/ {
  var sX = 0, sY = 0,       // spinX, spinY
      pX = 0, pY = 0;       // pixelX, pixelY

  // Legacy
  if ('detail'      in event) { sY = event.detail; }
  if ('wheelDelta'  in event) { sY = -event.wheelDelta / 120; }
  if ('wheelDeltaY' in event) { sY = -event.wheelDeltaY / 120; }
  if ('wheelDeltaX' in event) { sX = -event.wheelDeltaX / 120; }

  // side scrolling on FF with DOMMouseScroll
  if ( 'axis' in event && event.axis === event.HORIZONTAL_AXIS ) {
    sX = sY;
    sY = 0;
  }

  pX = sX * PIXEL_STEP;
  pY = sY * PIXEL_STEP;

  if ('deltaY' in event) { pY = event.deltaY; }
  if ('deltaX' in event) { pX = event.deltaX; }

  if ((pX || pY) && event.deltaMode) {
    if (event.deltaMode == 1) {          // delta in LINE units
      pX *= LINE_HEIGHT;
      pY *= LINE_HEIGHT;
    } else {                             // delta in PAGE units
      pX *= PAGE_HEIGHT;
      pY *= PAGE_HEIGHT;
    }
  }

  // Fall-back if spin cannot be determined
  if (pX && !sX) { sX = (pX < 1) ? -1 : 1; }
  if (pY && !sY) { sY = (pY < 1) ? -1 : 1; }

  return { spinX  : sX,
           spinY  : sY,
           pixelX : pX,
           pixelY : pY };
}


/**
 * The best combination if you prefer spinX + spinY normalization.  It favors
 * the older DOMMouseScroll for Firefox, as FF does not include wheelDelta with
 * 'wheel' event, making spin speed determination impossible.
 */
normalizeWheel.getEventType = function() /*string*/ {
  return (UserAgent_DEPRECATED.firefox())
           ? 'DOMMouseScroll'
           : (isEventSupported('wheel'))
               ? 'wheel'
               : 'mousewheel';
};

module.exports = normalizeWheel;


/***/ }),

/***/ 2775:
/***/ ((module) => {

var x=String;
var create=function() {return {isColorSupported:false,reset:x,bold:x,dim:x,italic:x,underline:x,inverse:x,hidden:x,strikethrough:x,black:x,red:x,green:x,yellow:x,blue:x,magenta:x,cyan:x,white:x,gray:x,bgBlack:x,bgRed:x,bgGreen:x,bgYellow:x,bgBlue:x,bgMagenta:x,bgCyan:x,bgWhite:x}};
module.exports=create();
module.exports.createColors = create;


/***/ }),

/***/ 4465:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),

/***/ 8036:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
__webpack_require__(4465);
const postcss_1 = __importDefault(__webpack_require__(4529));
const PostCSSPlugin_1 = __importDefault(__webpack_require__(3576));
module.exports = (0, PostCSSPlugin_1.default)(postcss_1.default);


/***/ }),

/***/ 5525:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.prefixWrapCSSSelector = exports.prefixWrapCSSRule = void 0;
const CSSSelector_1 = __webpack_require__(3467);
const prefixWrapCSSRule = (cssRule, nested, ignoredSelectors, prefixSelector, prefixRootTags) => {
    // Check each rule to see if it exactly matches our prefix selector, when
    // this happens, don't try to prefix that selector.
    const rules = cssRule.selector
        .split(",")
        .filter((selector) => !(0, CSSSelector_1.cssRuleMatchesPrefixSelector)({ selector: selector }, prefixSelector));
    if (rules.length === 0) {
        return;
    }
    cssRule.selector = rules
        .map((cssSelector) => (0, exports.prefixWrapCSSSelector)(cssSelector, cssRule, nested, ignoredSelectors, prefixSelector, prefixRootTags))
        .filter(CSSSelector_1.isValidCSSSelector)
        .join(", ");
};
exports.prefixWrapCSSRule = prefixWrapCSSRule;
const prefixWrapCSSSelector = (cssSelector, cssRule, nested, ignoredSelectors, prefixSelector, prefixRootTags) => {
    const cleanedSelector = (0, CSSSelector_1.cleanSelector)(cssSelector);
    if (cleanedSelector === "") {
        return null;
    }
    // Don't prefix nested selected.
    if (nested !== null && cleanedSelector.startsWith(nested, 0)) {
        return cleanedSelector;
    }
    // Do not prefix keyframes rules.
    if ((0, CSSSelector_1.isKeyframes)(cssRule)) {
        return cleanedSelector;
    }
    // Check for matching ignored selectors
    if (ignoredSelectors.some((currentValue) => cleanedSelector.match(currentValue))) {
        return cleanedSelector;
    }
    // Anything other than a root tag is always prefixed.
    if ((0, CSSSelector_1.isNotRootTag)(cleanedSelector)) {
        return prefixSelector + " " + cleanedSelector;
    }
    // Handle special case where root tags should be converted into classes
    // rather than being replaced.
    if (prefixRootTags) {
        return prefixSelector + " ." + cleanedSelector;
    }
    // HTML and Body elements cannot be contained within our container so lets
    // extract their styles.
    return cleanedSelector.replace(/^(body|html|:root)/, prefixSelector);
};
exports.prefixWrapCSSSelector = prefixWrapCSSSelector;


/***/ }),

/***/ 3467:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.cssRuleMatchesPrefixSelector = exports.isNotRootTag = exports.isKeyframes = exports.cleanSelector = exports.isValidCSSSelector = void 0;
const ANY_WHITESPACE_AT_BEGINNING_OR_END = /(^\s*|\s*$)/g;
const IS_ROOT_TAG = /^(body|html|:root).*$/;
const isValidCSSSelector = (cssSelector) => {
    return cssSelector !== null;
};
exports.isValidCSSSelector = isValidCSSSelector;
const cleanSelector = (cssSelector) => {
    return cssSelector.replace(ANY_WHITESPACE_AT_BEGINNING_OR_END, "");
};
exports.cleanSelector = cleanSelector;
const isKeyframes = (cssRule) => {
    const { parent } = cssRule;
    const parentReal = parent;
    // @see https://developer.mozilla.org/en-US/docs/Web/CSS/At-rule
    return (parent !== undefined &&
        parentReal.type === "atrule" &&
        parentReal.name !== undefined &&
        parentReal.name.match(/keyframes$/) !== null);
};
exports.isKeyframes = isKeyframes;
const isNotRootTag = (cleanSelector) => {
    return !cleanSelector.match(IS_ROOT_TAG);
};
exports.isNotRootTag = isNotRootTag;
const cssRuleMatchesPrefixSelector = (cssRule, prefixSelector) => {
    const escapedPrefixSelector = prefixSelector.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
    // eslint-disable-next-line security-node/non-literal-reg-expr
    const isPrefixSelector = new RegExp(`^${escapedPrefixSelector}$`);
    return isPrefixSelector.test(cssRule.selector);
};
exports.cssRuleMatchesPrefixSelector = cssRuleMatchesPrefixSelector;


/***/ }),

/***/ 9411:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.shouldIncludeFilePath = void 0;
const shouldIncludeFilePath = (filePath, whitelist, blacklist) => {
    // If whitelist exists, check if rule is contained within it.
    if (whitelist.length > 0) {
        return (filePath != undefined &&
            whitelist.some((currentValue) => filePath.match(currentValue)));
    }
    // If blacklist exists, check if rule is not contained within it.
    if (blacklist.length > 0) {
        return !(filePath != undefined &&
            blacklist.some((currentValue) => filePath.match(currentValue)));
    }
    // In all other cases, presume rule should be prefixed.
    return true;
};
exports.shouldIncludeFilePath = shouldIncludeFilePath;


/***/ }),

/***/ 8061:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.asPostCSSv7PluginGenerator = void 0;
const PostCSSPrefixWrap_1 = __importStar(__webpack_require__(1311));
const asPostCSSv7PluginGenerator = (postcss) => {
    return postcss.plugin(PostCSSPrefixWrap_1.PLUGIN_NAME, (prefixSelector, options) => {
        return new PostCSSPrefixWrap_1.default(prefixSelector, options).prefix();
    });
};
exports.asPostCSSv7PluginGenerator = asPostCSSv7PluginGenerator;


/***/ }),

/***/ 2888:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.asPostCSSv8PluginGenerator = exports.isPostCSSv8 = void 0;
const PostCSSPrefixWrap_1 = __importStar(__webpack_require__(1311));
const isPostCSSv8 = (postcss) => postcss.Root !== undefined;
exports.isPostCSSv8 = isPostCSSv8;
const asPostCSSv8PluginGenerator = () => {
    return (prefixSelector, options) => {
        const plugin = new PostCSSPrefixWrap_1.default(prefixSelector, options);
        return {
            postcssPlugin: PostCSSPrefixWrap_1.PLUGIN_NAME,
            Once(root) {
                plugin.prefixRoot(root);
            },
        };
    };
};
exports.asPostCSSv8PluginGenerator = asPostCSSv8PluginGenerator;


/***/ }),

/***/ 3576:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const PostCSS8Plugin_1 = __webpack_require__(2888);
const PostCSS7Plugin_1 = __webpack_require__(8061);
module.exports = (postcss) => {
    if ((0, PostCSS8Plugin_1.isPostCSSv8)(postcss)) {
        return (0, PostCSS8Plugin_1.asPostCSSv8PluginGenerator)();
    }
    else {
        return (0, PostCSS7Plugin_1.asPostCSSv7PluginGenerator)(postcss);
    }
};


/***/ }),

/***/ 1311:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PLUGIN_NAME = void 0;
const CSSRuleWrapper_1 = __webpack_require__(5525);
const FileIncludeList_1 = __webpack_require__(9411);
exports.PLUGIN_NAME = "postcss-prefixwrap";
class PostCSSPrefixWrap {
    blacklist;
    ignoredSelectors;
    isPrefixSelector;
    prefixRootTags;
    prefixSelector;
    whitelist;
    nested;
    constructor(prefixSelector, options = {}) {
        this.blacklist = options.blacklist ?? [];
        this.ignoredSelectors = options.ignoredSelectors ?? [];
        this.isPrefixSelector = new RegExp(
        // eslint-disable-next-line security-node/non-literal-reg-expr
        `^${prefixSelector.replace(/[.*+?^${}()|[\]\\]/g, "\\$&")}$`);
        this.prefixRootTags = options.prefixRootTags ?? false;
        this.prefixSelector = prefixSelector;
        this.whitelist = options.whitelist ?? [];
        this.nested = options.nested ?? null;
    }
    prefixRoot(css) {
        if ((0, FileIncludeList_1.shouldIncludeFilePath)(css.source?.input?.file, this.whitelist, this.blacklist)) {
            css.walkRules((cssRule) => {
                (0, CSSRuleWrapper_1.prefixWrapCSSRule)(cssRule, this.nested, this.ignoredSelectors, this.prefixSelector, this.prefixRootTags);
            });
        }
    }
    prefix() {
        return (css) => {
            this.prefixRoot(css);
        };
    }
}
exports["default"] = PostCSSPrefixWrap;


/***/ }),

/***/ 5404:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const CSSValueParser = __webpack_require__(1544)

/**
 * @type {import('postcss').PluginCreator}
 */
module.exports = (opts) => {

  const DEFAULTS = {
    skipHostRelativeUrls: true,
  }
  const config = Object.assign(DEFAULTS, opts)

  return {
    postcssPlugin: 'rebaseUrl',

    Declaration(decl) {
      // The faster way to find Declaration node
      const parsedValue = CSSValueParser(decl.value)

      let valueChanged = false
      parsedValue.walk(node => {
        if (node.type !== 'function' || node.value !== 'url') {
          return
        }

        const urlVal = node.nodes[0].value

        // bases relative URLs with rootUrl
        const basedUrl = new URL(urlVal, opts.rootUrl)

        // skip host-relative, already normalized URLs (e.g. `/images/image.jpg`, without `..`s)
        if ((basedUrl.pathname === urlVal) && config.skipHostRelativeUrls) {
          return false // skip this value
        }

        node.nodes[0].value = basedUrl.toString()
        valueChanged = true

        return false // do not walk deeper
      })

      if (valueChanged) {
        decl.value = CSSValueParser.stringify(parsedValue)
      }

    }
  }
}

module.exports.postcss = true


/***/ }),

/***/ 1544:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parse = __webpack_require__(8491);
var walk = __webpack_require__(3815);
var stringify = __webpack_require__(4725);

function ValueParser(value) {
  if (this instanceof ValueParser) {
    this.nodes = parse(value);
    return this;
  }
  return new ValueParser(value);
}

ValueParser.prototype.toString = function() {
  return Array.isArray(this.nodes) ? stringify(this.nodes) : "";
};

ValueParser.prototype.walk = function(cb, bubble) {
  walk(this.nodes, cb, bubble);
  return this;
};

ValueParser.unit = __webpack_require__(1524);

ValueParser.walk = walk;

ValueParser.stringify = stringify;

module.exports = ValueParser;


/***/ }),

/***/ 8491:
/***/ ((module) => {

var openParentheses = "(".charCodeAt(0);
var closeParentheses = ")".charCodeAt(0);
var singleQuote = "'".charCodeAt(0);
var doubleQuote = '"'.charCodeAt(0);
var backslash = "\\".charCodeAt(0);
var slash = "/".charCodeAt(0);
var comma = ",".charCodeAt(0);
var colon = ":".charCodeAt(0);
var star = "*".charCodeAt(0);
var uLower = "u".charCodeAt(0);
var uUpper = "U".charCodeAt(0);
var plus = "+".charCodeAt(0);
var isUnicodeRange = /^[a-f0-9?-]+$/i;

module.exports = function(input) {
  var tokens = [];
  var value = input;

  var next,
    quote,
    prev,
    token,
    escape,
    escapePos,
    whitespacePos,
    parenthesesOpenPos;
  var pos = 0;
  var code = value.charCodeAt(pos);
  var max = value.length;
  var stack = [{ nodes: tokens }];
  var balanced = 0;
  var parent;

  var name = "";
  var before = "";
  var after = "";

  while (pos < max) {
    // Whitespaces
    if (code <= 32) {
      next = pos;
      do {
        next += 1;
        code = value.charCodeAt(next);
      } while (code <= 32);
      token = value.slice(pos, next);

      prev = tokens[tokens.length - 1];
      if (code === closeParentheses && balanced) {
        after = token;
      } else if (prev && prev.type === "div") {
        prev.after = token;
        prev.sourceEndIndex += token.length;
      } else if (
        code === comma ||
        code === colon ||
        (code === slash &&
          value.charCodeAt(next + 1) !== star &&
          (!parent ||
            (parent && parent.type === "function" && parent.value !== "calc")))
      ) {
        before = token;
      } else {
        tokens.push({
          type: "space",
          sourceIndex: pos,
          sourceEndIndex: next,
          value: token
        });
      }

      pos = next;

      // Quotes
    } else if (code === singleQuote || code === doubleQuote) {
      next = pos;
      quote = code === singleQuote ? "'" : '"';
      token = {
        type: "string",
        sourceIndex: pos,
        quote: quote
      };
      do {
        escape = false;
        next = value.indexOf(quote, next + 1);
        if (~next) {
          escapePos = next;
          while (value.charCodeAt(escapePos - 1) === backslash) {
            escapePos -= 1;
            escape = !escape;
          }
        } else {
          value += quote;
          next = value.length - 1;
          token.unclosed = true;
        }
      } while (escape);
      token.value = value.slice(pos + 1, next);
      token.sourceEndIndex = token.unclosed ? next : next + 1;
      tokens.push(token);
      pos = next + 1;
      code = value.charCodeAt(pos);

      // Comments
    } else if (code === slash && value.charCodeAt(pos + 1) === star) {
      next = value.indexOf("*/", pos);

      token = {
        type: "comment",
        sourceIndex: pos,
        sourceEndIndex: next + 2
      };

      if (next === -1) {
        token.unclosed = true;
        next = value.length;
        token.sourceEndIndex = next;
      }

      token.value = value.slice(pos + 2, next);
      tokens.push(token);

      pos = next + 2;
      code = value.charCodeAt(pos);

      // Operation within calc
    } else if (
      (code === slash || code === star) &&
      parent &&
      parent.type === "function" &&
      parent.value === "calc"
    ) {
      token = value[pos];
      tokens.push({
        type: "word",
        sourceIndex: pos - before.length,
        sourceEndIndex: pos + token.length,
        value: token
      });
      pos += 1;
      code = value.charCodeAt(pos);

      // Dividers
    } else if (code === slash || code === comma || code === colon) {
      token = value[pos];

      tokens.push({
        type: "div",
        sourceIndex: pos - before.length,
        sourceEndIndex: pos + token.length,
        value: token,
        before: before,
        after: ""
      });
      before = "";

      pos += 1;
      code = value.charCodeAt(pos);

      // Open parentheses
    } else if (openParentheses === code) {
      // Whitespaces after open parentheses
      next = pos;
      do {
        next += 1;
        code = value.charCodeAt(next);
      } while (code <= 32);
      parenthesesOpenPos = pos;
      token = {
        type: "function",
        sourceIndex: pos - name.length,
        value: name,
        before: value.slice(parenthesesOpenPos + 1, next)
      };
      pos = next;

      if (name === "url" && code !== singleQuote && code !== doubleQuote) {
        next -= 1;
        do {
          escape = false;
          next = value.indexOf(")", next + 1);
          if (~next) {
            escapePos = next;
            while (value.charCodeAt(escapePos - 1) === backslash) {
              escapePos -= 1;
              escape = !escape;
            }
          } else {
            value += ")";
            next = value.length - 1;
            token.unclosed = true;
          }
        } while (escape);
        // Whitespaces before closed
        whitespacePos = next;
        do {
          whitespacePos -= 1;
          code = value.charCodeAt(whitespacePos);
        } while (code <= 32);
        if (parenthesesOpenPos < whitespacePos) {
          if (pos !== whitespacePos + 1) {
            token.nodes = [
              {
                type: "word",
                sourceIndex: pos,
                sourceEndIndex: whitespacePos + 1,
                value: value.slice(pos, whitespacePos + 1)
              }
            ];
          } else {
            token.nodes = [];
          }
          if (token.unclosed && whitespacePos + 1 !== next) {
            token.after = "";
            token.nodes.push({
              type: "space",
              sourceIndex: whitespacePos + 1,
              sourceEndIndex: next,
              value: value.slice(whitespacePos + 1, next)
            });
          } else {
            token.after = value.slice(whitespacePos + 1, next);
            token.sourceEndIndex = next;
          }
        } else {
          token.after = "";
          token.nodes = [];
        }
        pos = next + 1;
        token.sourceEndIndex = token.unclosed ? next : pos;
        code = value.charCodeAt(pos);
        tokens.push(token);
      } else {
        balanced += 1;
        token.after = "";
        token.sourceEndIndex = pos + 1;
        tokens.push(token);
        stack.push(token);
        tokens = token.nodes = [];
        parent = token;
      }
      name = "";

      // Close parentheses
    } else if (closeParentheses === code && balanced) {
      pos += 1;
      code = value.charCodeAt(pos);

      parent.after = after;
      parent.sourceEndIndex += after.length;
      after = "";
      balanced -= 1;
      stack[stack.length - 1].sourceEndIndex = pos;
      stack.pop();
      parent = stack[balanced];
      tokens = parent.nodes;

      // Words
    } else {
      next = pos;
      do {
        if (code === backslash) {
          next += 1;
        }
        next += 1;
        code = value.charCodeAt(next);
      } while (
        next < max &&
        !(
          code <= 32 ||
          code === singleQuote ||
          code === doubleQuote ||
          code === comma ||
          code === colon ||
          code === slash ||
          code === openParentheses ||
          (code === star &&
            parent &&
            parent.type === "function" &&
            parent.value === "calc") ||
          (code === slash &&
            parent.type === "function" &&
            parent.value === "calc") ||
          (code === closeParentheses && balanced)
        )
      );
      token = value.slice(pos, next);

      if (openParentheses === code) {
        name = token;
      } else if (
        (uLower === token.charCodeAt(0) || uUpper === token.charCodeAt(0)) &&
        plus === token.charCodeAt(1) &&
        isUnicodeRange.test(token.slice(2))
      ) {
        tokens.push({
          type: "unicode-range",
          sourceIndex: pos,
          sourceEndIndex: next,
          value: token
        });
      } else {
        tokens.push({
          type: "word",
          sourceIndex: pos,
          sourceEndIndex: next,
          value: token
        });
      }

      pos = next;
    }
  }

  for (pos = stack.length - 1; pos; pos -= 1) {
    stack[pos].unclosed = true;
    stack[pos].sourceEndIndex = value.length;
  }

  return stack[0].nodes;
};


/***/ }),

/***/ 4725:
/***/ ((module) => {

function stringifyNode(node, custom) {
  var type = node.type;
  var value = node.value;
  var buf;
  var customResult;

  if (custom && (customResult = custom(node)) !== undefined) {
    return customResult;
  } else if (type === "word" || type === "space") {
    return value;
  } else if (type === "string") {
    buf = node.quote || "";
    return buf + value + (node.unclosed ? "" : buf);
  } else if (type === "comment") {
    return "/*" + value + (node.unclosed ? "" : "*/");
  } else if (type === "div") {
    return (node.before || "") + value + (node.after || "");
  } else if (Array.isArray(node.nodes)) {
    buf = stringify(node.nodes, custom);
    if (type !== "function") {
      return buf;
    }
    return (
      value +
      "(" +
      (node.before || "") +
      buf +
      (node.after || "") +
      (node.unclosed ? "" : ")")
    );
  }
  return value;
}

function stringify(nodes, custom) {
  var result, i;

  if (Array.isArray(nodes)) {
    result = "";
    for (i = nodes.length - 1; ~i; i -= 1) {
      result = stringifyNode(nodes[i], custom) + result;
    }
    return result;
  }
  return stringifyNode(nodes, custom);
}

module.exports = stringify;


/***/ }),

/***/ 1524:
/***/ ((module) => {

var minus = "-".charCodeAt(0);
var plus = "+".charCodeAt(0);
var dot = ".".charCodeAt(0);
var exp = "e".charCodeAt(0);
var EXP = "E".charCodeAt(0);

// Check if three code points would start a number
// https://www.w3.org/TR/css-syntax-3/#starts-with-a-number
function likeNumber(value) {
  var code = value.charCodeAt(0);
  var nextCode;

  if (code === plus || code === minus) {
    nextCode = value.charCodeAt(1);

    if (nextCode >= 48 && nextCode <= 57) {
      return true;
    }

    var nextNextCode = value.charCodeAt(2);

    if (nextCode === dot && nextNextCode >= 48 && nextNextCode <= 57) {
      return true;
    }

    return false;
  }

  if (code === dot) {
    nextCode = value.charCodeAt(1);

    if (nextCode >= 48 && nextCode <= 57) {
      return true;
    }

    return false;
  }

  if (code >= 48 && code <= 57) {
    return true;
  }

  return false;
}

// Consume a number
// https://www.w3.org/TR/css-syntax-3/#consume-number
module.exports = function(value) {
  var pos = 0;
  var length = value.length;
  var code;
  var nextCode;
  var nextNextCode;

  if (length === 0 || !likeNumber(value)) {
    return false;
  }

  code = value.charCodeAt(pos);

  if (code === plus || code === minus) {
    pos++;
  }

  while (pos < length) {
    code = value.charCodeAt(pos);

    if (code < 48 || code > 57) {
      break;
    }

    pos += 1;
  }

  code = value.charCodeAt(pos);
  nextCode = value.charCodeAt(pos + 1);

  if (code === dot && nextCode >= 48 && nextCode <= 57) {
    pos += 2;

    while (pos < length) {
      code = value.charCodeAt(pos);

      if (code < 48 || code > 57) {
        break;
      }

      pos += 1;
    }
  }

  code = value.charCodeAt(pos);
  nextCode = value.charCodeAt(pos + 1);
  nextNextCode = value.charCodeAt(pos + 2);

  if (
    (code === exp || code === EXP) &&
    ((nextCode >= 48 && nextCode <= 57) ||
      ((nextCode === plus || nextCode === minus) &&
        nextNextCode >= 48 &&
        nextNextCode <= 57))
  ) {
    pos += nextCode === plus || nextCode === minus ? 3 : 2;

    while (pos < length) {
      code = value.charCodeAt(pos);

      if (code < 48 || code > 57) {
        break;
      }

      pos += 1;
    }
  }

  return {
    number: value.slice(0, pos),
    unit: value.slice(pos)
  };
};


/***/ }),

/***/ 3815:
/***/ ((module) => {

module.exports = function walk(nodes, cb, bubble) {
  var i, max, node, result;

  for (i = 0, max = nodes.length; i < max; i += 1) {
    node = nodes[i];
    if (!bubble) {
      result = cb(node, i, nodes);
    }

    if (
      result !== false &&
      node.type === "function" &&
      Array.isArray(node.nodes)
    ) {
      walk(node.nodes, cb, bubble);
    }

    if (bubble) {
      cb(node, i, nodes);
    }
  }
};


/***/ }),

/***/ 1326:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Container = __webpack_require__(683)

class AtRule extends Container {
  constructor(defaults) {
    super(defaults)
    this.type = 'atrule'
  }

  append(...children) {
    if (!this.proxyOf.nodes) this.nodes = []
    return super.append(...children)
  }

  prepend(...children) {
    if (!this.proxyOf.nodes) this.nodes = []
    return super.prepend(...children)
  }
}

module.exports = AtRule
AtRule.default = AtRule

Container.registerAtRule(AtRule)


/***/ }),

/***/ 6589:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Node = __webpack_require__(7490)

class Comment extends Node {
  constructor(defaults) {
    super(defaults)
    this.type = 'comment'
  }
}

module.exports = Comment
Comment.default = Comment


/***/ }),

/***/ 683:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let { isClean, my } = __webpack_require__(1381)
let Declaration = __webpack_require__(1516)
let Comment = __webpack_require__(6589)
let Node = __webpack_require__(7490)

let parse, Rule, AtRule, Root

function cleanSource(nodes) {
  return nodes.map(i => {
    if (i.nodes) i.nodes = cleanSource(i.nodes)
    delete i.source
    return i
  })
}

function markDirtyUp(node) {
  node[isClean] = false
  if (node.proxyOf.nodes) {
    for (let i of node.proxyOf.nodes) {
      markDirtyUp(i)
    }
  }
}

class Container extends Node {
  append(...children) {
    for (let child of children) {
      let nodes = this.normalize(child, this.last)
      for (let node of nodes) this.proxyOf.nodes.push(node)
    }

    this.markDirty()

    return this
  }

  cleanRaws(keepBetween) {
    super.cleanRaws(keepBetween)
    if (this.nodes) {
      for (let node of this.nodes) node.cleanRaws(keepBetween)
    }
  }

  each(callback) {
    if (!this.proxyOf.nodes) return undefined
    let iterator = this.getIterator()

    let index, result
    while (this.indexes[iterator] < this.proxyOf.nodes.length) {
      index = this.indexes[iterator]
      result = callback(this.proxyOf.nodes[index], index)
      if (result === false) break

      this.indexes[iterator] += 1
    }

    delete this.indexes[iterator]
    return result
  }

  every(condition) {
    return this.nodes.every(condition)
  }

  getIterator() {
    if (!this.lastEach) this.lastEach = 0
    if (!this.indexes) this.indexes = {}

    this.lastEach += 1
    let iterator = this.lastEach
    this.indexes[iterator] = 0

    return iterator
  }

  getProxyProcessor() {
    return {
      get(node, prop) {
        if (prop === 'proxyOf') {
          return node
        } else if (!node[prop]) {
          return node[prop]
        } else if (
          prop === 'each' ||
          (typeof prop === 'string' && prop.startsWith('walk'))
        ) {
          return (...args) => {
            return node[prop](
              ...args.map(i => {
                if (typeof i === 'function') {
                  return (child, index) => i(child.toProxy(), index)
                } else {
                  return i
                }
              })
            )
          }
        } else if (prop === 'every' || prop === 'some') {
          return cb => {
            return node[prop]((child, ...other) =>
              cb(child.toProxy(), ...other)
            )
          }
        } else if (prop === 'root') {
          return () => node.root().toProxy()
        } else if (prop === 'nodes') {
          return node.nodes.map(i => i.toProxy())
        } else if (prop === 'first' || prop === 'last') {
          return node[prop].toProxy()
        } else {
          return node[prop]
        }
      },

      set(node, prop, value) {
        if (node[prop] === value) return true
        node[prop] = value
        if (prop === 'name' || prop === 'params' || prop === 'selector') {
          node.markDirty()
        }
        return true
      }
    }
  }

  index(child) {
    if (typeof child === 'number') return child
    if (child.proxyOf) child = child.proxyOf
    return this.proxyOf.nodes.indexOf(child)
  }

  insertAfter(exist, add) {
    let existIndex = this.index(exist)
    let nodes = this.normalize(add, this.proxyOf.nodes[existIndex]).reverse()
    existIndex = this.index(exist)
    for (let node of nodes) this.proxyOf.nodes.splice(existIndex + 1, 0, node)

    let index
    for (let id in this.indexes) {
      index = this.indexes[id]
      if (existIndex < index) {
        this.indexes[id] = index + nodes.length
      }
    }

    this.markDirty()

    return this
  }

  insertBefore(exist, add) {
    let existIndex = this.index(exist)
    let type = existIndex === 0 ? 'prepend' : false
    let nodes = this.normalize(add, this.proxyOf.nodes[existIndex], type).reverse()
    existIndex = this.index(exist)
    for (let node of nodes) this.proxyOf.nodes.splice(existIndex, 0, node)

    let index
    for (let id in this.indexes) {
      index = this.indexes[id]
      if (existIndex <= index) {
        this.indexes[id] = index + nodes.length
      }
    }

    this.markDirty()

    return this
  }

  normalize(nodes, sample) {
    if (typeof nodes === 'string') {
      nodes = cleanSource(parse(nodes).nodes)
    } else if (typeof nodes === 'undefined') {
      nodes = []
    } else if (Array.isArray(nodes)) {
      nodes = nodes.slice(0)
      for (let i of nodes) {
        if (i.parent) i.parent.removeChild(i, 'ignore')
      }
    } else if (nodes.type === 'root' && this.type !== 'document') {
      nodes = nodes.nodes.slice(0)
      for (let i of nodes) {
        if (i.parent) i.parent.removeChild(i, 'ignore')
      }
    } else if (nodes.type) {
      nodes = [nodes]
    } else if (nodes.prop) {
      if (typeof nodes.value === 'undefined') {
        throw new Error('Value field is missed in node creation')
      } else if (typeof nodes.value !== 'string') {
        nodes.value = String(nodes.value)
      }
      nodes = [new Declaration(nodes)]
    } else if (nodes.selector) {
      nodes = [new Rule(nodes)]
    } else if (nodes.name) {
      nodes = [new AtRule(nodes)]
    } else if (nodes.text) {
      nodes = [new Comment(nodes)]
    } else {
      throw new Error('Unknown node type in node creation')
    }

    let processed = nodes.map(i => {
      /* c8 ignore next */
      if (!i[my]) Container.rebuild(i)
      i = i.proxyOf
      if (i.parent) i.parent.removeChild(i)
      if (i[isClean]) markDirtyUp(i)
      if (typeof i.raws.before === 'undefined') {
        if (sample && typeof sample.raws.before !== 'undefined') {
          i.raws.before = sample.raws.before.replace(/\S/g, '')
        }
      }
      i.parent = this.proxyOf
      return i
    })

    return processed
  }

  prepend(...children) {
    children = children.reverse()
    for (let child of children) {
      let nodes = this.normalize(child, this.first, 'prepend').reverse()
      for (let node of nodes) this.proxyOf.nodes.unshift(node)
      for (let id in this.indexes) {
        this.indexes[id] = this.indexes[id] + nodes.length
      }
    }

    this.markDirty()

    return this
  }

  push(child) {
    child.parent = this
    this.proxyOf.nodes.push(child)
    return this
  }

  removeAll() {
    for (let node of this.proxyOf.nodes) node.parent = undefined
    this.proxyOf.nodes = []

    this.markDirty()

    return this
  }

  removeChild(child) {
    child = this.index(child)
    this.proxyOf.nodes[child].parent = undefined
    this.proxyOf.nodes.splice(child, 1)

    let index
    for (let id in this.indexes) {
      index = this.indexes[id]
      if (index >= child) {
        this.indexes[id] = index - 1
      }
    }

    this.markDirty()

    return this
  }

  replaceValues(pattern, opts, callback) {
    if (!callback) {
      callback = opts
      opts = {}
    }

    this.walkDecls(decl => {
      if (opts.props && !opts.props.includes(decl.prop)) return
      if (opts.fast && !decl.value.includes(opts.fast)) return

      decl.value = decl.value.replace(pattern, callback)
    })

    this.markDirty()

    return this
  }

  some(condition) {
    return this.nodes.some(condition)
  }

  walk(callback) {
    return this.each((child, i) => {
      let result
      try {
        result = callback(child, i)
      } catch (e) {
        throw child.addToError(e)
      }
      if (result !== false && child.walk) {
        result = child.walk(callback)
      }

      return result
    })
  }

  walkAtRules(name, callback) {
    if (!callback) {
      callback = name
      return this.walk((child, i) => {
        if (child.type === 'atrule') {
          return callback(child, i)
        }
      })
    }
    if (name instanceof RegExp) {
      return this.walk((child, i) => {
        if (child.type === 'atrule' && name.test(child.name)) {
          return callback(child, i)
        }
      })
    }
    return this.walk((child, i) => {
      if (child.type === 'atrule' && child.name === name) {
        return callback(child, i)
      }
    })
  }

  walkComments(callback) {
    return this.walk((child, i) => {
      if (child.type === 'comment') {
        return callback(child, i)
      }
    })
  }

  walkDecls(prop, callback) {
    if (!callback) {
      callback = prop
      return this.walk((child, i) => {
        if (child.type === 'decl') {
          return callback(child, i)
        }
      })
    }
    if (prop instanceof RegExp) {
      return this.walk((child, i) => {
        if (child.type === 'decl' && prop.test(child.prop)) {
          return callback(child, i)
        }
      })
    }
    return this.walk((child, i) => {
      if (child.type === 'decl' && child.prop === prop) {
        return callback(child, i)
      }
    })
  }

  walkRules(selector, callback) {
    if (!callback) {
      callback = selector

      return this.walk((child, i) => {
        if (child.type === 'rule') {
          return callback(child, i)
        }
      })
    }
    if (selector instanceof RegExp) {
      return this.walk((child, i) => {
        if (child.type === 'rule' && selector.test(child.selector)) {
          return callback(child, i)
        }
      })
    }
    return this.walk((child, i) => {
      if (child.type === 'rule' && child.selector === selector) {
        return callback(child, i)
      }
    })
  }

  get first() {
    if (!this.proxyOf.nodes) return undefined
    return this.proxyOf.nodes[0]
  }

  get last() {
    if (!this.proxyOf.nodes) return undefined
    return this.proxyOf.nodes[this.proxyOf.nodes.length - 1]
  }
}

Container.registerParse = dependant => {
  parse = dependant
}

Container.registerRule = dependant => {
  Rule = dependant
}

Container.registerAtRule = dependant => {
  AtRule = dependant
}

Container.registerRoot = dependant => {
  Root = dependant
}

module.exports = Container
Container.default = Container

/* c8 ignore start */
Container.rebuild = node => {
  if (node.type === 'atrule') {
    Object.setPrototypeOf(node, AtRule.prototype)
  } else if (node.type === 'rule') {
    Object.setPrototypeOf(node, Rule.prototype)
  } else if (node.type === 'decl') {
    Object.setPrototypeOf(node, Declaration.prototype)
  } else if (node.type === 'comment') {
    Object.setPrototypeOf(node, Comment.prototype)
  } else if (node.type === 'root') {
    Object.setPrototypeOf(node, Root.prototype)
  }

  node[my] = true

  if (node.nodes) {
    node.nodes.forEach(child => {
      Container.rebuild(child)
    })
  }
}
/* c8 ignore stop */


/***/ }),

/***/ 356:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let pico = __webpack_require__(2775)

let terminalHighlight = __webpack_require__(9746)

class CssSyntaxError extends Error {
  constructor(message, line, column, source, file, plugin) {
    super(message)
    this.name = 'CssSyntaxError'
    this.reason = message

    if (file) {
      this.file = file
    }
    if (source) {
      this.source = source
    }
    if (plugin) {
      this.plugin = plugin
    }
    if (typeof line !== 'undefined' && typeof column !== 'undefined') {
      if (typeof line === 'number') {
        this.line = line
        this.column = column
      } else {
        this.line = line.line
        this.column = line.column
        this.endLine = column.line
        this.endColumn = column.column
      }
    }

    this.setMessage()

    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, CssSyntaxError)
    }
  }

  setMessage() {
    this.message = this.plugin ? this.plugin + ': ' : ''
    this.message += this.file ? this.file : '<css input>'
    if (typeof this.line !== 'undefined') {
      this.message += ':' + this.line + ':' + this.column
    }
    this.message += ': ' + this.reason
  }

  showSourceCode(color) {
    if (!this.source) return ''

    let css = this.source
    if (color == null) color = pico.isColorSupported
    if (terminalHighlight) {
      if (color) css = terminalHighlight(css)
    }

    let lines = css.split(/\r?\n/)
    let start = Math.max(this.line - 3, 0)
    let end = Math.min(this.line + 2, lines.length)

    let maxWidth = String(end).length

    let mark, aside
    if (color) {
      let { bold, gray, red } = pico.createColors(true)
      mark = text => bold(red(text))
      aside = text => gray(text)
    } else {
      mark = aside = str => str
    }

    return lines
      .slice(start, end)
      .map((line, index) => {
        let number = start + 1 + index
        let gutter = ' ' + (' ' + number).slice(-maxWidth) + ' | '
        if (number === this.line) {
          let spacing =
            aside(gutter.replace(/\d/g, ' ')) +
            line.slice(0, this.column - 1).replace(/[^\t]/g, ' ')
          return mark('>') + aside(gutter) + line + '\n ' + spacing + mark('^')
        }
        return ' ' + aside(gutter) + line
      })
      .join('\n')
  }

  toString() {
    let code = this.showSourceCode()
    if (code) {
      code = '\n\n' + code + '\n'
    }
    return this.name + ': ' + this.message + code
  }
}

module.exports = CssSyntaxError
CssSyntaxError.default = CssSyntaxError


/***/ }),

/***/ 1516:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Node = __webpack_require__(7490)

class Declaration extends Node {
  constructor(defaults) {
    if (
      defaults &&
      typeof defaults.value !== 'undefined' &&
      typeof defaults.value !== 'string'
    ) {
      defaults = { ...defaults, value: String(defaults.value) }
    }
    super(defaults)
    this.type = 'decl'
  }

  get variable() {
    return this.prop.startsWith('--') || this.prop[0] === '$'
  }
}

module.exports = Declaration
Declaration.default = Declaration


/***/ }),

/***/ 271:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Container = __webpack_require__(683)

let LazyResult, Processor

class Document extends Container {
  constructor(defaults) {
    // type needs to be passed to super, otherwise child roots won't be normalized correctly
    super({ type: 'document', ...defaults })

    if (!this.nodes) {
      this.nodes = []
    }
  }

  toResult(opts = {}) {
    let lazy = new LazyResult(new Processor(), this, opts)

    return lazy.stringify()
  }
}

Document.registerLazyResult = dependant => {
  LazyResult = dependant
}

Document.registerProcessor = dependant => {
  Processor = dependant
}

module.exports = Document
Document.default = Document


/***/ }),

/***/ 8940:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Declaration = __webpack_require__(1516)
let PreviousMap = __webpack_require__(5696)
let Comment = __webpack_require__(6589)
let AtRule = __webpack_require__(1326)
let Input = __webpack_require__(5380)
let Root = __webpack_require__(9434)
let Rule = __webpack_require__(4092)

function fromJSON(json, inputs) {
  if (Array.isArray(json)) return json.map(n => fromJSON(n))

  let { inputs: ownInputs, ...defaults } = json
  if (ownInputs) {
    inputs = []
    for (let input of ownInputs) {
      let inputHydrated = { ...input, __proto__: Input.prototype }
      if (inputHydrated.map) {
        inputHydrated.map = {
          ...inputHydrated.map,
          __proto__: PreviousMap.prototype
        }
      }
      inputs.push(inputHydrated)
    }
  }
  if (defaults.nodes) {
    defaults.nodes = json.nodes.map(n => fromJSON(n, inputs))
  }
  if (defaults.source) {
    let { inputId, ...source } = defaults.source
    defaults.source = source
    if (inputId != null) {
      defaults.source.input = inputs[inputId]
    }
  }
  if (defaults.type === 'root') {
    return new Root(defaults)
  } else if (defaults.type === 'decl') {
    return new Declaration(defaults)
  } else if (defaults.type === 'rule') {
    return new Rule(defaults)
  } else if (defaults.type === 'comment') {
    return new Comment(defaults)
  } else if (defaults.type === 'atrule') {
    return new AtRule(defaults)
  } else {
    throw new Error('Unknown node type: ' + json.type)
  }
}

module.exports = fromJSON
fromJSON.default = fromJSON


/***/ }),

/***/ 5380:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let { SourceMapConsumer, SourceMapGenerator } = __webpack_require__(1866)
let { fileURLToPath, pathToFileURL } = __webpack_require__(2739)
let { isAbsolute, resolve } = __webpack_require__(197)
let { nanoid } = __webpack_require__(5042)

let terminalHighlight = __webpack_require__(9746)
let CssSyntaxError = __webpack_require__(356)
let PreviousMap = __webpack_require__(5696)

let fromOffsetCache = Symbol('fromOffsetCache')

let sourceMapAvailable = Boolean(SourceMapConsumer && SourceMapGenerator)
let pathAvailable = Boolean(resolve && isAbsolute)

class Input {
  constructor(css, opts = {}) {
    if (
      css === null ||
      typeof css === 'undefined' ||
      (typeof css === 'object' && !css.toString)
    ) {
      throw new Error(`PostCSS received ${css} instead of CSS string`)
    }

    this.css = css.toString()

    if (this.css[0] === '\uFEFF' || this.css[0] === '\uFFFE') {
      this.hasBOM = true
      this.css = this.css.slice(1)
    } else {
      this.hasBOM = false
    }

    if (opts.from) {
      if (
        !pathAvailable ||
        /^\w+:\/\//.test(opts.from) ||
        isAbsolute(opts.from)
      ) {
        this.file = opts.from
      } else {
        this.file = resolve(opts.from)
      }
    }

    if (pathAvailable && sourceMapAvailable) {
      let map = new PreviousMap(this.css, opts)
      if (map.text) {
        this.map = map
        let file = map.consumer().file
        if (!this.file && file) this.file = this.mapResolve(file)
      }
    }

    if (!this.file) {
      this.id = '<input css ' + nanoid(6) + '>'
    }
    if (this.map) this.map.file = this.from
  }

  error(message, line, column, opts = {}) {
    let result, endLine, endColumn

    if (line && typeof line === 'object') {
      let start = line
      let end = column
      if (typeof start.offset === 'number') {
        let pos = this.fromOffset(start.offset)
        line = pos.line
        column = pos.col
      } else {
        line = start.line
        column = start.column
      }
      if (typeof end.offset === 'number') {
        let pos = this.fromOffset(end.offset)
        endLine = pos.line
        endColumn = pos.col
      } else {
        endLine = end.line
        endColumn = end.column
      }
    } else if (!column) {
      let pos = this.fromOffset(line)
      line = pos.line
      column = pos.col
    }

    let origin = this.origin(line, column, endLine, endColumn)
    if (origin) {
      result = new CssSyntaxError(
        message,
        origin.endLine === undefined
          ? origin.line
          : { column: origin.column, line: origin.line },
        origin.endLine === undefined
          ? origin.column
          : { column: origin.endColumn, line: origin.endLine },
        origin.source,
        origin.file,
        opts.plugin
      )
    } else {
      result = new CssSyntaxError(
        message,
        endLine === undefined ? line : { column, line },
        endLine === undefined ? column : { column: endColumn, line: endLine },
        this.css,
        this.file,
        opts.plugin
      )
    }

    result.input = { column, endColumn, endLine, line, source: this.css }
    if (this.file) {
      if (pathToFileURL) {
        result.input.url = pathToFileURL(this.file).toString()
      }
      result.input.file = this.file
    }

    return result
  }

  fromOffset(offset) {
    let lastLine, lineToIndex
    if (!this[fromOffsetCache]) {
      let lines = this.css.split('\n')
      lineToIndex = new Array(lines.length)
      let prevIndex = 0

      for (let i = 0, l = lines.length; i < l; i++) {
        lineToIndex[i] = prevIndex
        prevIndex += lines[i].length + 1
      }

      this[fromOffsetCache] = lineToIndex
    } else {
      lineToIndex = this[fromOffsetCache]
    }
    lastLine = lineToIndex[lineToIndex.length - 1]

    let min = 0
    if (offset >= lastLine) {
      min = lineToIndex.length - 1
    } else {
      let max = lineToIndex.length - 2
      let mid
      while (min < max) {
        mid = min + ((max - min) >> 1)
        if (offset < lineToIndex[mid]) {
          max = mid - 1
        } else if (offset >= lineToIndex[mid + 1]) {
          min = mid + 1
        } else {
          min = mid
          break
        }
      }
    }
    return {
      col: offset - lineToIndex[min] + 1,
      line: min + 1
    }
  }

  mapResolve(file) {
    if (/^\w+:\/\//.test(file)) {
      return file
    }
    return resolve(this.map.consumer().sourceRoot || this.map.root || '.', file)
  }

  origin(line, column, endLine, endColumn) {
    if (!this.map) return false
    let consumer = this.map.consumer()

    let from = consumer.originalPositionFor({ column, line })
    if (!from.source) return false

    let to
    if (typeof endLine === 'number') {
      to = consumer.originalPositionFor({ column: endColumn, line: endLine })
    }

    let fromUrl

    if (isAbsolute(from.source)) {
      fromUrl = pathToFileURL(from.source)
    } else {
      fromUrl = new URL(
        from.source,
        this.map.consumer().sourceRoot || pathToFileURL(this.map.mapFile)
      )
    }

    let result = {
      column: from.column,
      endColumn: to && to.column,
      endLine: to && to.line,
      line: from.line,
      url: fromUrl.toString()
    }

    if (fromUrl.protocol === 'file:') {
      if (fileURLToPath) {
        result.file = fileURLToPath(fromUrl)
      } else {
        /* c8 ignore next 2 */
        throw new Error(`file: protocol is not available in this PostCSS build`)
      }
    }

    let source = consumer.sourceContentFor(from.source)
    if (source) result.source = source

    return result
  }

  toJSON() {
    let json = {}
    for (let name of ['hasBOM', 'css', 'file', 'id']) {
      if (this[name] != null) {
        json[name] = this[name]
      }
    }
    if (this.map) {
      json.map = { ...this.map }
      if (json.map.consumerCache) {
        json.map.consumerCache = undefined
      }
    }
    return json
  }

  get from() {
    return this.file || this.id
  }
}

module.exports = Input
Input.default = Input

if (terminalHighlight && terminalHighlight.registerInput) {
  terminalHighlight.registerInput(Input)
}


/***/ }),

/***/ 448:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let { isClean, my } = __webpack_require__(1381)
let MapGenerator = __webpack_require__(1670)
let stringify = __webpack_require__(633)
let Container = __webpack_require__(683)
let Document = __webpack_require__(271)
let warnOnce = __webpack_require__(3122)
let Result = __webpack_require__(9055)
let parse = __webpack_require__(4295)
let Root = __webpack_require__(9434)

const TYPE_TO_CLASS_NAME = {
  atrule: 'AtRule',
  comment: 'Comment',
  decl: 'Declaration',
  document: 'Document',
  root: 'Root',
  rule: 'Rule'
}

const PLUGIN_PROPS = {
  AtRule: true,
  AtRuleExit: true,
  Comment: true,
  CommentExit: true,
  Declaration: true,
  DeclarationExit: true,
  Document: true,
  DocumentExit: true,
  Once: true,
  OnceExit: true,
  postcssPlugin: true,
  prepare: true,
  Root: true,
  RootExit: true,
  Rule: true,
  RuleExit: true
}

const NOT_VISITORS = {
  Once: true,
  postcssPlugin: true,
  prepare: true
}

const CHILDREN = 0

function isPromise(obj) {
  return typeof obj === 'object' && typeof obj.then === 'function'
}

function getEvents(node) {
  let key = false
  let type = TYPE_TO_CLASS_NAME[node.type]
  if (node.type === 'decl') {
    key = node.prop.toLowerCase()
  } else if (node.type === 'atrule') {
    key = node.name.toLowerCase()
  }

  if (key && node.append) {
    return [
      type,
      type + '-' + key,
      CHILDREN,
      type + 'Exit',
      type + 'Exit-' + key
    ]
  } else if (key) {
    return [type, type + '-' + key, type + 'Exit', type + 'Exit-' + key]
  } else if (node.append) {
    return [type, CHILDREN, type + 'Exit']
  } else {
    return [type, type + 'Exit']
  }
}

function toStack(node) {
  let events
  if (node.type === 'document') {
    events = ['Document', CHILDREN, 'DocumentExit']
  } else if (node.type === 'root') {
    events = ['Root', CHILDREN, 'RootExit']
  } else {
    events = getEvents(node)
  }

  return {
    eventIndex: 0,
    events,
    iterator: 0,
    node,
    visitorIndex: 0,
    visitors: []
  }
}

function cleanMarks(node) {
  node[isClean] = false
  if (node.nodes) node.nodes.forEach(i => cleanMarks(i))
  return node
}

let postcss = {}

class LazyResult {
  constructor(processor, css, opts) {
    this.stringified = false
    this.processed = false

    let root
    if (
      typeof css === 'object' &&
      css !== null &&
      (css.type === 'root' || css.type === 'document')
    ) {
      root = cleanMarks(css)
    } else if (css instanceof LazyResult || css instanceof Result) {
      root = cleanMarks(css.root)
      if (css.map) {
        if (typeof opts.map === 'undefined') opts.map = {}
        if (!opts.map.inline) opts.map.inline = false
        opts.map.prev = css.map
      }
    } else {
      let parser = parse
      if (opts.syntax) parser = opts.syntax.parse
      if (opts.parser) parser = opts.parser
      if (parser.parse) parser = parser.parse

      try {
        root = parser(css, opts)
      } catch (error) {
        this.processed = true
        this.error = error
      }

      if (root && !root[my]) {
        /* c8 ignore next 2 */
        Container.rebuild(root)
      }
    }

    this.result = new Result(processor, root, opts)
    this.helpers = { ...postcss, postcss, result: this.result }
    this.plugins = this.processor.plugins.map(plugin => {
      if (typeof plugin === 'object' && plugin.prepare) {
        return { ...plugin, ...plugin.prepare(this.result) }
      } else {
        return plugin
      }
    })
  }

  async() {
    if (this.error) return Promise.reject(this.error)
    if (this.processed) return Promise.resolve(this.result)
    if (!this.processing) {
      this.processing = this.runAsync()
    }
    return this.processing
  }

  catch(onRejected) {
    return this.async().catch(onRejected)
  }

  finally(onFinally) {
    return this.async().then(onFinally, onFinally)
  }

  getAsyncError() {
    throw new Error('Use process(css).then(cb) to work with async plugins')
  }

  handleError(error, node) {
    let plugin = this.result.lastPlugin
    try {
      if (node) node.addToError(error)
      this.error = error
      if (error.name === 'CssSyntaxError' && !error.plugin) {
        error.plugin = plugin.postcssPlugin
        error.setMessage()
      } else if (plugin.postcssVersion) {
        if (false) {}
      }
    } catch (err) {
      /* c8 ignore next 3 */
      // eslint-disable-next-line no-console
      if (console && console.error) console.error(err)
    }
    return error
  }

  prepareVisitors() {
    this.listeners = {}
    let add = (plugin, type, cb) => {
      if (!this.listeners[type]) this.listeners[type] = []
      this.listeners[type].push([plugin, cb])
    }
    for (let plugin of this.plugins) {
      if (typeof plugin === 'object') {
        for (let event in plugin) {
          if (!PLUGIN_PROPS[event] && /^[A-Z]/.test(event)) {
            throw new Error(
              `Unknown event ${event} in ${plugin.postcssPlugin}. ` +
                `Try to update PostCSS (${this.processor.version} now).`
            )
          }
          if (!NOT_VISITORS[event]) {
            if (typeof plugin[event] === 'object') {
              for (let filter in plugin[event]) {
                if (filter === '*') {
                  add(plugin, event, plugin[event][filter])
                } else {
                  add(
                    plugin,
                    event + '-' + filter.toLowerCase(),
                    plugin[event][filter]
                  )
                }
              }
            } else if (typeof plugin[event] === 'function') {
              add(plugin, event, plugin[event])
            }
          }
        }
      }
    }
    this.hasListener = Object.keys(this.listeners).length > 0
  }

  async runAsync() {
    this.plugin = 0
    for (let i = 0; i < this.plugins.length; i++) {
      let plugin = this.plugins[i]
      let promise = this.runOnRoot(plugin)
      if (isPromise(promise)) {
        try {
          await promise
        } catch (error) {
          throw this.handleError(error)
        }
      }
    }

    this.prepareVisitors()
    if (this.hasListener) {
      let root = this.result.root
      while (!root[isClean]) {
        root[isClean] = true
        let stack = [toStack(root)]
        while (stack.length > 0) {
          let promise = this.visitTick(stack)
          if (isPromise(promise)) {
            try {
              await promise
            } catch (e) {
              let node = stack[stack.length - 1].node
              throw this.handleError(e, node)
            }
          }
        }
      }

      if (this.listeners.OnceExit) {
        for (let [plugin, visitor] of this.listeners.OnceExit) {
          this.result.lastPlugin = plugin
          try {
            if (root.type === 'document') {
              let roots = root.nodes.map(subRoot =>
                visitor(subRoot, this.helpers)
              )

              await Promise.all(roots)
            } else {
              await visitor(root, this.helpers)
            }
          } catch (e) {
            throw this.handleError(e)
          }
        }
      }
    }

    this.processed = true
    return this.stringify()
  }

  runOnRoot(plugin) {
    this.result.lastPlugin = plugin
    try {
      if (typeof plugin === 'object' && plugin.Once) {
        if (this.result.root.type === 'document') {
          let roots = this.result.root.nodes.map(root =>
            plugin.Once(root, this.helpers)
          )

          if (isPromise(roots[0])) {
            return Promise.all(roots)
          }

          return roots
        }

        return plugin.Once(this.result.root, this.helpers)
      } else if (typeof plugin === 'function') {
        return plugin(this.result.root, this.result)
      }
    } catch (error) {
      throw this.handleError(error)
    }
  }

  stringify() {
    if (this.error) throw this.error
    if (this.stringified) return this.result
    this.stringified = true

    this.sync()

    let opts = this.result.opts
    let str = stringify
    if (opts.syntax) str = opts.syntax.stringify
    if (opts.stringifier) str = opts.stringifier
    if (str.stringify) str = str.stringify

    let map = new MapGenerator(str, this.result.root, this.result.opts)
    let data = map.generate()
    this.result.css = data[0]
    this.result.map = data[1]

    return this.result
  }

  sync() {
    if (this.error) throw this.error
    if (this.processed) return this.result
    this.processed = true

    if (this.processing) {
      throw this.getAsyncError()
    }

    for (let plugin of this.plugins) {
      let promise = this.runOnRoot(plugin)
      if (isPromise(promise)) {
        throw this.getAsyncError()
      }
    }

    this.prepareVisitors()
    if (this.hasListener) {
      let root = this.result.root
      while (!root[isClean]) {
        root[isClean] = true
        this.walkSync(root)
      }
      if (this.listeners.OnceExit) {
        if (root.type === 'document') {
          for (let subRoot of root.nodes) {
            this.visitSync(this.listeners.OnceExit, subRoot)
          }
        } else {
          this.visitSync(this.listeners.OnceExit, root)
        }
      }
    }

    return this.result
  }

  then(onFulfilled, onRejected) {
    if (false) {}
    return this.async().then(onFulfilled, onRejected)
  }

  toString() {
    return this.css
  }

  visitSync(visitors, node) {
    for (let [plugin, visitor] of visitors) {
      this.result.lastPlugin = plugin
      let promise
      try {
        promise = visitor(node, this.helpers)
      } catch (e) {
        throw this.handleError(e, node.proxyOf)
      }
      if (node.type !== 'root' && node.type !== 'document' && !node.parent) {
        return true
      }
      if (isPromise(promise)) {
        throw this.getAsyncError()
      }
    }
  }

  visitTick(stack) {
    let visit = stack[stack.length - 1]
    let { node, visitors } = visit

    if (node.type !== 'root' && node.type !== 'document' && !node.parent) {
      stack.pop()
      return
    }

    if (visitors.length > 0 && visit.visitorIndex < visitors.length) {
      let [plugin, visitor] = visitors[visit.visitorIndex]
      visit.visitorIndex += 1
      if (visit.visitorIndex === visitors.length) {
        visit.visitors = []
        visit.visitorIndex = 0
      }
      this.result.lastPlugin = plugin
      try {
        return visitor(node.toProxy(), this.helpers)
      } catch (e) {
        throw this.handleError(e, node)
      }
    }

    if (visit.iterator !== 0) {
      let iterator = visit.iterator
      let child
      while ((child = node.nodes[node.indexes[iterator]])) {
        node.indexes[iterator] += 1
        if (!child[isClean]) {
          child[isClean] = true
          stack.push(toStack(child))
          return
        }
      }
      visit.iterator = 0
      delete node.indexes[iterator]
    }

    let events = visit.events
    while (visit.eventIndex < events.length) {
      let event = events[visit.eventIndex]
      visit.eventIndex += 1
      if (event === CHILDREN) {
        if (node.nodes && node.nodes.length) {
          node[isClean] = true
          visit.iterator = node.getIterator()
        }
        return
      } else if (this.listeners[event]) {
        visit.visitors = this.listeners[event]
        return
      }
    }
    stack.pop()
  }

  walkSync(node) {
    node[isClean] = true
    let events = getEvents(node)
    for (let event of events) {
      if (event === CHILDREN) {
        if (node.nodes) {
          node.each(child => {
            if (!child[isClean]) this.walkSync(child)
          })
        }
      } else {
        let visitors = this.listeners[event]
        if (visitors) {
          if (this.visitSync(visitors, node.toProxy())) return
        }
      }
    }
  }

  warnings() {
    return this.sync().warnings()
  }

  get content() {
    return this.stringify().content
  }

  get css() {
    return this.stringify().css
  }

  get map() {
    return this.stringify().map
  }

  get messages() {
    return this.sync().messages
  }

  get opts() {
    return this.result.opts
  }

  get processor() {
    return this.result.processor
  }

  get root() {
    return this.sync().root
  }

  get [Symbol.toStringTag]() {
    return 'LazyResult'
  }
}

LazyResult.registerPostcss = dependant => {
  postcss = dependant
}

module.exports = LazyResult
LazyResult.default = LazyResult

Root.registerLazyResult(LazyResult)
Document.registerLazyResult(LazyResult)


/***/ }),

/***/ 7374:
/***/ ((module) => {

"use strict";


let list = {
  comma(string) {
    return list.split(string, [','], true)
  },

  space(string) {
    let spaces = [' ', '\n', '\t']
    return list.split(string, spaces)
  },

  split(string, separators, last) {
    let array = []
    let current = ''
    let split = false

    let func = 0
    let inQuote = false
    let prevQuote = ''
    let escape = false

    for (let letter of string) {
      if (escape) {
        escape = false
      } else if (letter === '\\') {
        escape = true
      } else if (inQuote) {
        if (letter === prevQuote) {
          inQuote = false
        }
      } else if (letter === '"' || letter === "'") {
        inQuote = true
        prevQuote = letter
      } else if (letter === '(') {
        func += 1
      } else if (letter === ')') {
        if (func > 0) func -= 1
      } else if (func === 0) {
        if (separators.includes(letter)) split = true
      }

      if (split) {
        if (current !== '') array.push(current.trim())
        current = ''
        split = false
      } else {
        current += letter
      }
    }

    if (last || current !== '') array.push(current.trim())
    return array
  }
}

module.exports = list
list.default = list


/***/ }),

/***/ 1670:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let { SourceMapConsumer, SourceMapGenerator } = __webpack_require__(1866)
let { dirname, relative, resolve, sep } = __webpack_require__(197)
let { pathToFileURL } = __webpack_require__(2739)

let Input = __webpack_require__(5380)

let sourceMapAvailable = Boolean(SourceMapConsumer && SourceMapGenerator)
let pathAvailable = Boolean(dirname && resolve && relative && sep)

class MapGenerator {
  constructor(stringify, root, opts, cssString) {
    this.stringify = stringify
    this.mapOpts = opts.map || {}
    this.root = root
    this.opts = opts
    this.css = cssString
    this.originalCSS = cssString
    this.usesFileUrls = !this.mapOpts.from && this.mapOpts.absolute

    this.memoizedFileURLs = new Map()
    this.memoizedPaths = new Map()
    this.memoizedURLs = new Map()
  }

  addAnnotation() {
    let content

    if (this.isInline()) {
      content =
        'data:application/json;base64,' + this.toBase64(this.map.toString())
    } else if (typeof this.mapOpts.annotation === 'string') {
      content = this.mapOpts.annotation
    } else if (typeof this.mapOpts.annotation === 'function') {
      content = this.mapOpts.annotation(this.opts.to, this.root)
    } else {
      content = this.outputFile() + '.map'
    }
    let eol = '\n'
    if (this.css.includes('\r\n')) eol = '\r\n'

    this.css += eol + '/*# sourceMappingURL=' + content + ' */'
  }

  applyPrevMaps() {
    for (let prev of this.previous()) {
      let from = this.toUrl(this.path(prev.file))
      let root = prev.root || dirname(prev.file)
      let map

      if (this.mapOpts.sourcesContent === false) {
        map = new SourceMapConsumer(prev.text)
        if (map.sourcesContent) {
          map.sourcesContent = null
        }
      } else {
        map = prev.consumer()
      }

      this.map.applySourceMap(map, from, this.toUrl(this.path(root)))
    }
  }

  clearAnnotation() {
    if (this.mapOpts.annotation === false) return

    if (this.root) {
      let node
      for (let i = this.root.nodes.length - 1; i >= 0; i--) {
        node = this.root.nodes[i]
        if (node.type !== 'comment') continue
        if (node.text.indexOf('# sourceMappingURL=') === 0) {
          this.root.removeChild(i)
        }
      }
    } else if (this.css) {
      this.css = this.css.replace(/\n*?\/\*#[\S\s]*?\*\/$/gm, '')
    }
  }

  generate() {
    this.clearAnnotation()
    if (pathAvailable && sourceMapAvailable && this.isMap()) {
      return this.generateMap()
    } else {
      let result = ''
      this.stringify(this.root, i => {
        result += i
      })
      return [result]
    }
  }

  generateMap() {
    if (this.root) {
      this.generateString()
    } else if (this.previous().length === 1) {
      let prev = this.previous()[0].consumer()
      prev.file = this.outputFile()
      this.map = SourceMapGenerator.fromSourceMap(prev)
    } else {
      this.map = new SourceMapGenerator({ file: this.outputFile() })
      this.map.addMapping({
        generated: { column: 0, line: 1 },
        original: { column: 0, line: 1 },
        source: this.opts.from
          ? this.toUrl(this.path(this.opts.from))
          : '<no source>'
      })
    }

    if (this.isSourcesContent()) this.setSourcesContent()
    if (this.root && this.previous().length > 0) this.applyPrevMaps()
    if (this.isAnnotation()) this.addAnnotation()

    if (this.isInline()) {
      return [this.css]
    } else {
      return [this.css, this.map]
    }
  }

  generateString() {
    this.css = ''
    this.map = new SourceMapGenerator({ file: this.outputFile() })

    let line = 1
    let column = 1

    let noSource = '<no source>'
    let mapping = {
      generated: { column: 0, line: 0 },
      original: { column: 0, line: 0 },
      source: ''
    }

    let lines, last
    this.stringify(this.root, (str, node, type) => {
      this.css += str

      if (node && type !== 'end') {
        mapping.generated.line = line
        mapping.generated.column = column - 1
        if (node.source && node.source.start) {
          mapping.source = this.sourcePath(node)
          mapping.original.line = node.source.start.line
          mapping.original.column = node.source.start.column - 1
          this.map.addMapping(mapping)
        } else {
          mapping.source = noSource
          mapping.original.line = 1
          mapping.original.column = 0
          this.map.addMapping(mapping)
        }
      }

      lines = str.match(/\n/g)
      if (lines) {
        line += lines.length
        last = str.lastIndexOf('\n')
        column = str.length - last
      } else {
        column += str.length
      }

      if (node && type !== 'start') {
        let p = node.parent || { raws: {} }
        let childless =
          node.type === 'decl' || (node.type === 'atrule' && !node.nodes)
        if (!childless || node !== p.last || p.raws.semicolon) {
          if (node.source && node.source.end) {
            mapping.source = this.sourcePath(node)
            mapping.original.line = node.source.end.line
            mapping.original.column = node.source.end.column - 1
            mapping.generated.line = line
            mapping.generated.column = column - 2
            this.map.addMapping(mapping)
          } else {
            mapping.source = noSource
            mapping.original.line = 1
            mapping.original.column = 0
            mapping.generated.line = line
            mapping.generated.column = column - 1
            this.map.addMapping(mapping)
          }
        }
      }
    })
  }

  isAnnotation() {
    if (this.isInline()) {
      return true
    }
    if (typeof this.mapOpts.annotation !== 'undefined') {
      return this.mapOpts.annotation
    }
    if (this.previous().length) {
      return this.previous().some(i => i.annotation)
    }
    return true
  }

  isInline() {
    if (typeof this.mapOpts.inline !== 'undefined') {
      return this.mapOpts.inline
    }

    let annotation = this.mapOpts.annotation
    if (typeof annotation !== 'undefined' && annotation !== true) {
      return false
    }

    if (this.previous().length) {
      return this.previous().some(i => i.inline)
    }
    return true
  }

  isMap() {
    if (typeof this.opts.map !== 'undefined') {
      return !!this.opts.map
    }
    return this.previous().length > 0
  }

  isSourcesContent() {
    if (typeof this.mapOpts.sourcesContent !== 'undefined') {
      return this.mapOpts.sourcesContent
    }
    if (this.previous().length) {
      return this.previous().some(i => i.withContent())
    }
    return true
  }

  outputFile() {
    if (this.opts.to) {
      return this.path(this.opts.to)
    } else if (this.opts.from) {
      return this.path(this.opts.from)
    } else {
      return 'to.css'
    }
  }

  path(file) {
    if (this.mapOpts.absolute) return file
    if (file.charCodeAt(0) === 60 /* `<` */) return file
    if (/^\w+:\/\//.test(file)) return file
    let cached = this.memoizedPaths.get(file)
    if (cached) return cached

    let from = this.opts.to ? dirname(this.opts.to) : '.'

    if (typeof this.mapOpts.annotation === 'string') {
      from = dirname(resolve(from, this.mapOpts.annotation))
    }

    let path = relative(from, file)
    this.memoizedPaths.set(file, path)

    return path
  }

  previous() {
    if (!this.previousMaps) {
      this.previousMaps = []
      if (this.root) {
        this.root.walk(node => {
          if (node.source && node.source.input.map) {
            let map = node.source.input.map
            if (!this.previousMaps.includes(map)) {
              this.previousMaps.push(map)
            }
          }
        })
      } else {
        let input = new Input(this.originalCSS, this.opts)
        if (input.map) this.previousMaps.push(input.map)
      }
    }

    return this.previousMaps
  }

  setSourcesContent() {
    let already = {}
    if (this.root) {
      this.root.walk(node => {
        if (node.source) {
          let from = node.source.input.from
          if (from && !already[from]) {
            already[from] = true
            let fromUrl = this.usesFileUrls
              ? this.toFileUrl(from)
              : this.toUrl(this.path(from))
            this.map.setSourceContent(fromUrl, node.source.input.css)
          }
        }
      })
    } else if (this.css) {
      let from = this.opts.from
        ? this.toUrl(this.path(this.opts.from))
        : '<no source>'
      this.map.setSourceContent(from, this.css)
    }
  }

  sourcePath(node) {
    if (this.mapOpts.from) {
      return this.toUrl(this.mapOpts.from)
    } else if (this.usesFileUrls) {
      return this.toFileUrl(node.source.input.from)
    } else {
      return this.toUrl(this.path(node.source.input.from))
    }
  }

  toBase64(str) {
    if (Buffer) {
      return Buffer.from(str).toString('base64')
    } else {
      return window.btoa(unescape(encodeURIComponent(str)))
    }
  }

  toFileUrl(path) {
    let cached = this.memoizedFileURLs.get(path)
    if (cached) return cached

    if (pathToFileURL) {
      let fileURL = pathToFileURL(path).toString()
      this.memoizedFileURLs.set(path, fileURL)

      return fileURL
    } else {
      throw new Error(
        '`map.absolute` option is not available in this PostCSS build'
      )
    }
  }

  toUrl(path) {
    let cached = this.memoizedURLs.get(path)
    if (cached) return cached

    if (sep === '\\') {
      path = path.replace(/\\/g, '/')
    }

    let url = encodeURI(path).replace(/[#?]/g, encodeURIComponent)
    this.memoizedURLs.set(path, url)

    return url
  }
}

module.exports = MapGenerator


/***/ }),

/***/ 7661:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let MapGenerator = __webpack_require__(1670)
let stringify = __webpack_require__(633)
let warnOnce = __webpack_require__(3122)
let parse = __webpack_require__(4295)
const Result = __webpack_require__(9055)

class NoWorkResult {
  constructor(processor, css, opts) {
    css = css.toString()
    this.stringified = false

    this._processor = processor
    this._css = css
    this._opts = opts
    this._map = undefined
    let root

    let str = stringify
    this.result = new Result(this._processor, root, this._opts)
    this.result.css = css

    let self = this
    Object.defineProperty(this.result, 'root', {
      get() {
        return self.root
      }
    })

    let map = new MapGenerator(str, root, this._opts, css)
    if (map.isMap()) {
      let [generatedCSS, generatedMap] = map.generate()
      if (generatedCSS) {
        this.result.css = generatedCSS
      }
      if (generatedMap) {
        this.result.map = generatedMap
      }
    } else {
      map.clearAnnotation()
      this.result.css = map.css
    }
  }

  async() {
    if (this.error) return Promise.reject(this.error)
    return Promise.resolve(this.result)
  }

  catch(onRejected) {
    return this.async().catch(onRejected)
  }

  finally(onFinally) {
    return this.async().then(onFinally, onFinally)
  }

  sync() {
    if (this.error) throw this.error
    return this.result
  }

  then(onFulfilled, onRejected) {
    if (false) {}

    return this.async().then(onFulfilled, onRejected)
  }

  toString() {
    return this._css
  }

  warnings() {
    return []
  }

  get content() {
    return this.result.css
  }

  get css() {
    return this.result.css
  }

  get map() {
    return this.result.map
  }

  get messages() {
    return []
  }

  get opts() {
    return this.result.opts
  }

  get processor() {
    return this.result.processor
  }

  get root() {
    if (this._root) {
      return this._root
    }

    let root
    let parser = parse

    try {
      root = parser(this._css, this._opts)
    } catch (error) {
      this.error = error
    }

    if (this.error) {
      throw this.error
    } else {
      this._root = root
      return root
    }
  }

  get [Symbol.toStringTag]() {
    return 'NoWorkResult'
  }
}

module.exports = NoWorkResult
NoWorkResult.default = NoWorkResult


/***/ }),

/***/ 7490:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let { isClean, my } = __webpack_require__(1381)
let CssSyntaxError = __webpack_require__(356)
let Stringifier = __webpack_require__(346)
let stringify = __webpack_require__(633)

function cloneNode(obj, parent) {
  let cloned = new obj.constructor()

  for (let i in obj) {
    if (!Object.prototype.hasOwnProperty.call(obj, i)) {
      /* c8 ignore next 2 */
      continue
    }
    if (i === 'proxyCache') continue
    let value = obj[i]
    let type = typeof value

    if (i === 'parent' && type === 'object') {
      if (parent) cloned[i] = parent
    } else if (i === 'source') {
      cloned[i] = value
    } else if (Array.isArray(value)) {
      cloned[i] = value.map(j => cloneNode(j, cloned))
    } else {
      if (type === 'object' && value !== null) value = cloneNode(value)
      cloned[i] = value
    }
  }

  return cloned
}

class Node {
  constructor(defaults = {}) {
    this.raws = {}
    this[isClean] = false
    this[my] = true

    for (let name in defaults) {
      if (name === 'nodes') {
        this.nodes = []
        for (let node of defaults[name]) {
          if (typeof node.clone === 'function') {
            this.append(node.clone())
          } else {
            this.append(node)
          }
        }
      } else {
        this[name] = defaults[name]
      }
    }
  }

  addToError(error) {
    error.postcssNode = this
    if (error.stack && this.source && /\n\s{4}at /.test(error.stack)) {
      let s = this.source
      error.stack = error.stack.replace(
        /\n\s{4}at /,
        `$&${s.input.from}:${s.start.line}:${s.start.column}$&`
      )
    }
    return error
  }

  after(add) {
    this.parent.insertAfter(this, add)
    return this
  }

  assign(overrides = {}) {
    for (let name in overrides) {
      this[name] = overrides[name]
    }
    return this
  }

  before(add) {
    this.parent.insertBefore(this, add)
    return this
  }

  cleanRaws(keepBetween) {
    delete this.raws.before
    delete this.raws.after
    if (!keepBetween) delete this.raws.between
  }

  clone(overrides = {}) {
    let cloned = cloneNode(this)
    for (let name in overrides) {
      cloned[name] = overrides[name]
    }
    return cloned
  }

  cloneAfter(overrides = {}) {
    let cloned = this.clone(overrides)
    this.parent.insertAfter(this, cloned)
    return cloned
  }

  cloneBefore(overrides = {}) {
    let cloned = this.clone(overrides)
    this.parent.insertBefore(this, cloned)
    return cloned
  }

  error(message, opts = {}) {
    if (this.source) {
      let { end, start } = this.rangeBy(opts)
      return this.source.input.error(
        message,
        { column: start.column, line: start.line },
        { column: end.column, line: end.line },
        opts
      )
    }
    return new CssSyntaxError(message)
  }

  getProxyProcessor() {
    return {
      get(node, prop) {
        if (prop === 'proxyOf') {
          return node
        } else if (prop === 'root') {
          return () => node.root().toProxy()
        } else {
          return node[prop]
        }
      },

      set(node, prop, value) {
        if (node[prop] === value) return true
        node[prop] = value
        if (
          prop === 'prop' ||
          prop === 'value' ||
          prop === 'name' ||
          prop === 'params' ||
          prop === 'important' ||
          /* c8 ignore next */
          prop === 'text'
        ) {
          node.markDirty()
        }
        return true
      }
    }
  }

  markDirty() {
    if (this[isClean]) {
      this[isClean] = false
      let next = this
      while ((next = next.parent)) {
        next[isClean] = false
      }
    }
  }

  next() {
    if (!this.parent) return undefined
    let index = this.parent.index(this)
    return this.parent.nodes[index + 1]
  }

  positionBy(opts, stringRepresentation) {
    let pos = this.source.start
    if (opts.index) {
      pos = this.positionInside(opts.index, stringRepresentation)
    } else if (opts.word) {
      stringRepresentation = this.toString()
      let index = stringRepresentation.indexOf(opts.word)
      if (index !== -1) pos = this.positionInside(index, stringRepresentation)
    }
    return pos
  }

  positionInside(index, stringRepresentation) {
    let string = stringRepresentation || this.toString()
    let column = this.source.start.column
    let line = this.source.start.line

    for (let i = 0; i < index; i++) {
      if (string[i] === '\n') {
        column = 1
        line += 1
      } else {
        column += 1
      }
    }

    return { column, line }
  }

  prev() {
    if (!this.parent) return undefined
    let index = this.parent.index(this)
    return this.parent.nodes[index - 1]
  }

  rangeBy(opts) {
    let start = {
      column: this.source.start.column,
      line: this.source.start.line
    }
    let end = this.source.end
      ? {
        column: this.source.end.column + 1,
        line: this.source.end.line
      }
      : {
        column: start.column + 1,
        line: start.line
      }

    if (opts.word) {
      let stringRepresentation = this.toString()
      let index = stringRepresentation.indexOf(opts.word)
      if (index !== -1) {
        start = this.positionInside(index, stringRepresentation)
        end = this.positionInside(index + opts.word.length, stringRepresentation)
      }
    } else {
      if (opts.start) {
        start = {
          column: opts.start.column,
          line: opts.start.line
        }
      } else if (opts.index) {
        start = this.positionInside(opts.index)
      }

      if (opts.end) {
        end = {
          column: opts.end.column,
          line: opts.end.line
        }
      } else if (opts.endIndex) {
        end = this.positionInside(opts.endIndex)
      } else if (opts.index) {
        end = this.positionInside(opts.index + 1)
      }
    }

    if (
      end.line < start.line ||
      (end.line === start.line && end.column <= start.column)
    ) {
      end = { column: start.column + 1, line: start.line }
    }

    return { end, start }
  }

  raw(prop, defaultType) {
    let str = new Stringifier()
    return str.raw(this, prop, defaultType)
  }

  remove() {
    if (this.parent) {
      this.parent.removeChild(this)
    }
    this.parent = undefined
    return this
  }

  replaceWith(...nodes) {
    if (this.parent) {
      let bookmark = this
      let foundSelf = false
      for (let node of nodes) {
        if (node === this) {
          foundSelf = true
        } else if (foundSelf) {
          this.parent.insertAfter(bookmark, node)
          bookmark = node
        } else {
          this.parent.insertBefore(bookmark, node)
        }
      }

      if (!foundSelf) {
        this.remove()
      }
    }

    return this
  }

  root() {
    let result = this
    while (result.parent && result.parent.type !== 'document') {
      result = result.parent
    }
    return result
  }

  toJSON(_, inputs) {
    let fixed = {}
    let emitInputs = inputs == null
    inputs = inputs || new Map()
    let inputsNextIndex = 0

    for (let name in this) {
      if (!Object.prototype.hasOwnProperty.call(this, name)) {
        /* c8 ignore next 2 */
        continue
      }
      if (name === 'parent' || name === 'proxyCache') continue
      let value = this[name]

      if (Array.isArray(value)) {
        fixed[name] = value.map(i => {
          if (typeof i === 'object' && i.toJSON) {
            return i.toJSON(null, inputs)
          } else {
            return i
          }
        })
      } else if (typeof value === 'object' && value.toJSON) {
        fixed[name] = value.toJSON(null, inputs)
      } else if (name === 'source') {
        let inputId = inputs.get(value.input)
        if (inputId == null) {
          inputId = inputsNextIndex
          inputs.set(value.input, inputsNextIndex)
          inputsNextIndex++
        }
        fixed[name] = {
          end: value.end,
          inputId,
          start: value.start
        }
      } else {
        fixed[name] = value
      }
    }

    if (emitInputs) {
      fixed.inputs = [...inputs.keys()].map(input => input.toJSON())
    }

    return fixed
  }

  toProxy() {
    if (!this.proxyCache) {
      this.proxyCache = new Proxy(this, this.getProxyProcessor())
    }
    return this.proxyCache
  }

  toString(stringifier = stringify) {
    if (stringifier.stringify) stringifier = stringifier.stringify
    let result = ''
    stringifier(this, i => {
      result += i
    })
    return result
  }

  warn(result, text, opts) {
    let data = { node: this }
    for (let i in opts) data[i] = opts[i]
    return result.warn(text, data)
  }

  get proxyOf() {
    return this
  }
}

module.exports = Node
Node.default = Node


/***/ }),

/***/ 4295:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Container = __webpack_require__(683)
let Parser = __webpack_require__(3937)
let Input = __webpack_require__(5380)

function parse(css, opts) {
  let input = new Input(css, opts)
  let parser = new Parser(input)
  try {
    parser.parse()
  } catch (e) {
    if (false) {}
    throw e
  }

  return parser.root
}

module.exports = parse
parse.default = parse

Container.registerParse(parse)


/***/ }),

/***/ 3937:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Declaration = __webpack_require__(1516)
let tokenizer = __webpack_require__(2327)
let Comment = __webpack_require__(6589)
let AtRule = __webpack_require__(1326)
let Root = __webpack_require__(9434)
let Rule = __webpack_require__(4092)

const SAFE_COMMENT_NEIGHBOR = {
  empty: true,
  space: true
}

function findLastWithPosition(tokens) {
  for (let i = tokens.length - 1; i >= 0; i--) {
    let token = tokens[i]
    let pos = token[3] || token[2]
    if (pos) return pos
  }
}

class Parser {
  constructor(input) {
    this.input = input

    this.root = new Root()
    this.current = this.root
    this.spaces = ''
    this.semicolon = false

    this.createTokenizer()
    this.root.source = { input, start: { column: 1, line: 1, offset: 0 } }
  }

  atrule(token) {
    let node = new AtRule()
    node.name = token[1].slice(1)
    if (node.name === '') {
      this.unnamedAtrule(node, token)
    }
    this.init(node, token[2])

    let type
    let prev
    let shift
    let last = false
    let open = false
    let params = []
    let brackets = []

    while (!this.tokenizer.endOfFile()) {
      token = this.tokenizer.nextToken()
      type = token[0]

      if (type === '(' || type === '[') {
        brackets.push(type === '(' ? ')' : ']')
      } else if (type === '{' && brackets.length > 0) {
        brackets.push('}')
      } else if (type === brackets[brackets.length - 1]) {
        brackets.pop()
      }

      if (brackets.length === 0) {
        if (type === ';') {
          node.source.end = this.getPosition(token[2])
          node.source.end.offset++
          this.semicolon = true
          break
        } else if (type === '{') {
          open = true
          break
        } else if (type === '}') {
          if (params.length > 0) {
            shift = params.length - 1
            prev = params[shift]
            while (prev && prev[0] === 'space') {
              prev = params[--shift]
            }
            if (prev) {
              node.source.end = this.getPosition(prev[3] || prev[2])
              node.source.end.offset++
            }
          }
          this.end(token)
          break
        } else {
          params.push(token)
        }
      } else {
        params.push(token)
      }

      if (this.tokenizer.endOfFile()) {
        last = true
        break
      }
    }

    node.raws.between = this.spacesAndCommentsFromEnd(params)
    if (params.length) {
      node.raws.afterName = this.spacesAndCommentsFromStart(params)
      this.raw(node, 'params', params)
      if (last) {
        token = params[params.length - 1]
        node.source.end = this.getPosition(token[3] || token[2])
        node.source.end.offset++
        this.spaces = node.raws.between
        node.raws.between = ''
      }
    } else {
      node.raws.afterName = ''
      node.params = ''
    }

    if (open) {
      node.nodes = []
      this.current = node
    }
  }

  checkMissedSemicolon(tokens) {
    let colon = this.colon(tokens)
    if (colon === false) return

    let founded = 0
    let token
    for (let j = colon - 1; j >= 0; j--) {
      token = tokens[j]
      if (token[0] !== 'space') {
        founded += 1
        if (founded === 2) break
      }
    }
    // If the token is a word, e.g. `!important`, `red` or any other valid property's value.
    // Then we need to return the colon after that word token. [3] is the "end" colon of that word.
    // And because we need it after that one we do +1 to get the next one.
    throw this.input.error(
      'Missed semicolon',
      token[0] === 'word' ? token[3] + 1 : token[2]
    )
  }

  colon(tokens) {
    let brackets = 0
    let token, type, prev
    for (let [i, element] of tokens.entries()) {
      token = element
      type = token[0]

      if (type === '(') {
        brackets += 1
      }
      if (type === ')') {
        brackets -= 1
      }
      if (brackets === 0 && type === ':') {
        if (!prev) {
          this.doubleColon(token)
        } else if (prev[0] === 'word' && prev[1] === 'progid') {
          continue
        } else {
          return i
        }
      }

      prev = token
    }
    return false
  }

  comment(token) {
    let node = new Comment()
    this.init(node, token[2])
    node.source.end = this.getPosition(token[3] || token[2])
    node.source.end.offset++

    let text = token[1].slice(2, -2)
    if (/^\s*$/.test(text)) {
      node.text = ''
      node.raws.left = text
      node.raws.right = ''
    } else {
      let match = text.match(/^(\s*)([^]*\S)(\s*)$/)
      node.text = match[2]
      node.raws.left = match[1]
      node.raws.right = match[3]
    }
  }

  createTokenizer() {
    this.tokenizer = tokenizer(this.input)
  }

  decl(tokens, customProperty) {
    let node = new Declaration()
    this.init(node, tokens[0][2])

    let last = tokens[tokens.length - 1]
    if (last[0] === ';') {
      this.semicolon = true
      tokens.pop()
    }

    node.source.end = this.getPosition(
      last[3] || last[2] || findLastWithPosition(tokens)
    )
    node.source.end.offset++

    while (tokens[0][0] !== 'word') {
      if (tokens.length === 1) this.unknownWord(tokens)
      node.raws.before += tokens.shift()[1]
    }
    node.source.start = this.getPosition(tokens[0][2])

    node.prop = ''
    while (tokens.length) {
      let type = tokens[0][0]
      if (type === ':' || type === 'space' || type === 'comment') {
        break
      }
      node.prop += tokens.shift()[1]
    }

    node.raws.between = ''

    let token
    while (tokens.length) {
      token = tokens.shift()

      if (token[0] === ':') {
        node.raws.between += token[1]
        break
      } else {
        if (token[0] === 'word' && /\w/.test(token[1])) {
          this.unknownWord([token])
        }
        node.raws.between += token[1]
      }
    }

    if (node.prop[0] === '_' || node.prop[0] === '*') {
      node.raws.before += node.prop[0]
      node.prop = node.prop.slice(1)
    }

    let firstSpaces = []
    let next
    while (tokens.length) {
      next = tokens[0][0]
      if (next !== 'space' && next !== 'comment') break
      firstSpaces.push(tokens.shift())
    }

    this.precheckMissedSemicolon(tokens)

    for (let i = tokens.length - 1; i >= 0; i--) {
      token = tokens[i]
      if (token[1].toLowerCase() === '!important') {
        node.important = true
        let string = this.stringFrom(tokens, i)
        string = this.spacesFromEnd(tokens) + string
        if (string !== ' !important') node.raws.important = string
        break
      } else if (token[1].toLowerCase() === 'important') {
        let cache = tokens.slice(0)
        let str = ''
        for (let j = i; j > 0; j--) {
          let type = cache[j][0]
          if (str.trim().indexOf('!') === 0 && type !== 'space') {
            break
          }
          str = cache.pop()[1] + str
        }
        if (str.trim().indexOf('!') === 0) {
          node.important = true
          node.raws.important = str
          tokens = cache
        }
      }

      if (token[0] !== 'space' && token[0] !== 'comment') {
        break
      }
    }

    let hasWord = tokens.some(i => i[0] !== 'space' && i[0] !== 'comment')

    if (hasWord) {
      node.raws.between += firstSpaces.map(i => i[1]).join('')
      firstSpaces = []
    }
    this.raw(node, 'value', firstSpaces.concat(tokens), customProperty)

    if (node.value.includes(':') && !customProperty) {
      this.checkMissedSemicolon(tokens)
    }
  }

  doubleColon(token) {
    throw this.input.error(
      'Double colon',
      { offset: token[2] },
      { offset: token[2] + token[1].length }
    )
  }

  emptyRule(token) {
    let node = new Rule()
    this.init(node, token[2])
    node.selector = ''
    node.raws.between = ''
    this.current = node
  }

  end(token) {
    if (this.current.nodes && this.current.nodes.length) {
      this.current.raws.semicolon = this.semicolon
    }
    this.semicolon = false

    this.current.raws.after = (this.current.raws.after || '') + this.spaces
    this.spaces = ''

    if (this.current.parent) {
      this.current.source.end = this.getPosition(token[2])
      this.current.source.end.offset++
      this.current = this.current.parent
    } else {
      this.unexpectedClose(token)
    }
  }

  endFile() {
    if (this.current.parent) this.unclosedBlock()
    if (this.current.nodes && this.current.nodes.length) {
      this.current.raws.semicolon = this.semicolon
    }
    this.current.raws.after = (this.current.raws.after || '') + this.spaces
    this.root.source.end = this.getPosition(this.tokenizer.position())
  }

  freeSemicolon(token) {
    this.spaces += token[1]
    if (this.current.nodes) {
      let prev = this.current.nodes[this.current.nodes.length - 1]
      if (prev && prev.type === 'rule' && !prev.raws.ownSemicolon) {
        prev.raws.ownSemicolon = this.spaces
        this.spaces = ''
      }
    }
  }

  // Helpers

  getPosition(offset) {
    let pos = this.input.fromOffset(offset)
    return {
      column: pos.col,
      line: pos.line,
      offset
    }
  }

  init(node, offset) {
    this.current.push(node)
    node.source = {
      input: this.input,
      start: this.getPosition(offset)
    }
    node.raws.before = this.spaces
    this.spaces = ''
    if (node.type !== 'comment') this.semicolon = false
  }

  other(start) {
    let end = false
    let type = null
    let colon = false
    let bracket = null
    let brackets = []
    let customProperty = start[1].startsWith('--')

    let tokens = []
    let token = start
    while (token) {
      type = token[0]
      tokens.push(token)

      if (type === '(' || type === '[') {
        if (!bracket) bracket = token
        brackets.push(type === '(' ? ')' : ']')
      } else if (customProperty && colon && type === '{') {
        if (!bracket) bracket = token
        brackets.push('}')
      } else if (brackets.length === 0) {
        if (type === ';') {
          if (colon) {
            this.decl(tokens, customProperty)
            return
          } else {
            break
          }
        } else if (type === '{') {
          this.rule(tokens)
          return
        } else if (type === '}') {
          this.tokenizer.back(tokens.pop())
          end = true
          break
        } else if (type === ':') {
          colon = true
        }
      } else if (type === brackets[brackets.length - 1]) {
        brackets.pop()
        if (brackets.length === 0) bracket = null
      }

      token = this.tokenizer.nextToken()
    }

    if (this.tokenizer.endOfFile()) end = true
    if (brackets.length > 0) this.unclosedBracket(bracket)

    if (end && colon) {
      if (!customProperty) {
        while (tokens.length) {
          token = tokens[tokens.length - 1][0]
          if (token !== 'space' && token !== 'comment') break
          this.tokenizer.back(tokens.pop())
        }
      }
      this.decl(tokens, customProperty)
    } else {
      this.unknownWord(tokens)
    }
  }

  parse() {
    let token
    while (!this.tokenizer.endOfFile()) {
      token = this.tokenizer.nextToken()

      switch (token[0]) {
        case 'space':
          this.spaces += token[1]
          break

        case ';':
          this.freeSemicolon(token)
          break

        case '}':
          this.end(token)
          break

        case 'comment':
          this.comment(token)
          break

        case 'at-word':
          this.atrule(token)
          break

        case '{':
          this.emptyRule(token)
          break

        default:
          this.other(token)
          break
      }
    }
    this.endFile()
  }

  precheckMissedSemicolon(/* tokens */) {
    // Hook for Safe Parser
  }

  raw(node, prop, tokens, customProperty) {
    let token, type
    let length = tokens.length
    let value = ''
    let clean = true
    let next, prev

    for (let i = 0; i < length; i += 1) {
      token = tokens[i]
      type = token[0]
      if (type === 'space' && i === length - 1 && !customProperty) {
        clean = false
      } else if (type === 'comment') {
        prev = tokens[i - 1] ? tokens[i - 1][0] : 'empty'
        next = tokens[i + 1] ? tokens[i + 1][0] : 'empty'
        if (!SAFE_COMMENT_NEIGHBOR[prev] && !SAFE_COMMENT_NEIGHBOR[next]) {
          if (value.slice(-1) === ',') {
            clean = false
          } else {
            value += token[1]
          }
        } else {
          clean = false
        }
      } else {
        value += token[1]
      }
    }
    if (!clean) {
      let raw = tokens.reduce((all, i) => all + i[1], '')
      node.raws[prop] = { raw, value }
    }
    node[prop] = value
  }

  rule(tokens) {
    tokens.pop()

    let node = new Rule()
    this.init(node, tokens[0][2])

    node.raws.between = this.spacesAndCommentsFromEnd(tokens)
    this.raw(node, 'selector', tokens)
    this.current = node
  }

  spacesAndCommentsFromEnd(tokens) {
    let lastTokenType
    let spaces = ''
    while (tokens.length) {
      lastTokenType = tokens[tokens.length - 1][0]
      if (lastTokenType !== 'space' && lastTokenType !== 'comment') break
      spaces = tokens.pop()[1] + spaces
    }
    return spaces
  }

  // Errors

  spacesAndCommentsFromStart(tokens) {
    let next
    let spaces = ''
    while (tokens.length) {
      next = tokens[0][0]
      if (next !== 'space' && next !== 'comment') break
      spaces += tokens.shift()[1]
    }
    return spaces
  }

  spacesFromEnd(tokens) {
    let lastTokenType
    let spaces = ''
    while (tokens.length) {
      lastTokenType = tokens[tokens.length - 1][0]
      if (lastTokenType !== 'space') break
      spaces = tokens.pop()[1] + spaces
    }
    return spaces
  }

  stringFrom(tokens, from) {
    let result = ''
    for (let i = from; i < tokens.length; i++) {
      result += tokens[i][1]
    }
    tokens.splice(from, tokens.length - from)
    return result
  }

  unclosedBlock() {
    let pos = this.current.source.start
    throw this.input.error('Unclosed block', pos.line, pos.column)
  }

  unclosedBracket(bracket) {
    throw this.input.error(
      'Unclosed bracket',
      { offset: bracket[2] },
      { offset: bracket[2] + 1 }
    )
  }

  unexpectedClose(token) {
    throw this.input.error(
      'Unexpected }',
      { offset: token[2] },
      { offset: token[2] + 1 }
    )
  }

  unknownWord(tokens) {
    throw this.input.error(
      'Unknown word',
      { offset: tokens[0][2] },
      { offset: tokens[0][2] + tokens[0][1].length }
    )
  }

  unnamedAtrule(node, token) {
    throw this.input.error(
      'At-rule without name',
      { offset: token[2] },
      { offset: token[2] + token[1].length }
    )
  }
}

module.exports = Parser


/***/ }),

/***/ 4529:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let CssSyntaxError = __webpack_require__(356)
let Declaration = __webpack_require__(1516)
let LazyResult = __webpack_require__(448)
let Container = __webpack_require__(683)
let Processor = __webpack_require__(9656)
let stringify = __webpack_require__(633)
let fromJSON = __webpack_require__(8940)
let Document = __webpack_require__(271)
let Warning = __webpack_require__(5776)
let Comment = __webpack_require__(6589)
let AtRule = __webpack_require__(1326)
let Result = __webpack_require__(9055)
let Input = __webpack_require__(5380)
let parse = __webpack_require__(4295)
let list = __webpack_require__(7374)
let Rule = __webpack_require__(4092)
let Root = __webpack_require__(9434)
let Node = __webpack_require__(7490)

function postcss(...plugins) {
  if (plugins.length === 1 && Array.isArray(plugins[0])) {
    plugins = plugins[0]
  }
  return new Processor(plugins)
}

postcss.plugin = function plugin(name, initializer) {
  let warningPrinted = false
  function creator(...args) {
    // eslint-disable-next-line no-console
    if (console && console.warn && !warningPrinted) {
      warningPrinted = true
      // eslint-disable-next-line no-console
      console.warn(
        name +
          ': postcss.plugin was deprecated. Migration guide:\n' +
          'https://evilmartians.com/chronicles/postcss-8-plugin-migration'
      )
      if (process.env.LANG && process.env.LANG.startsWith('cn')) {
        /* c8 ignore next 7 */
        // eslint-disable-next-line no-console
        console.warn(
          name +
            ': 里面 postcss.plugin 被弃用. 迁移指南:\n' +
            'https://www.w3ctech.com/topic/2226'
        )
      }
    }
    let transformer = initializer(...args)
    transformer.postcssPlugin = name
    transformer.postcssVersion = new Processor().version
    return transformer
  }

  let cache
  Object.defineProperty(creator, 'postcss', {
    get() {
      if (!cache) cache = creator()
      return cache
    }
  })

  creator.process = function (css, processOpts, pluginOpts) {
    return postcss([creator(pluginOpts)]).process(css, processOpts)
  }

  return creator
}

postcss.stringify = stringify
postcss.parse = parse
postcss.fromJSON = fromJSON
postcss.list = list

postcss.comment = defaults => new Comment(defaults)
postcss.atRule = defaults => new AtRule(defaults)
postcss.decl = defaults => new Declaration(defaults)
postcss.rule = defaults => new Rule(defaults)
postcss.root = defaults => new Root(defaults)
postcss.document = defaults => new Document(defaults)

postcss.CssSyntaxError = CssSyntaxError
postcss.Declaration = Declaration
postcss.Container = Container
postcss.Processor = Processor
postcss.Document = Document
postcss.Comment = Comment
postcss.Warning = Warning
postcss.AtRule = AtRule
postcss.Result = Result
postcss.Input = Input
postcss.Rule = Rule
postcss.Root = Root
postcss.Node = Node

LazyResult.registerPostcss(postcss)

module.exports = postcss
postcss.default = postcss


/***/ }),

/***/ 5696:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let { SourceMapConsumer, SourceMapGenerator } = __webpack_require__(1866)
let { existsSync, readFileSync } = __webpack_require__(9977)
let { dirname, join } = __webpack_require__(197)

function fromBase64(str) {
  if (Buffer) {
    return Buffer.from(str, 'base64').toString()
  } else {
    /* c8 ignore next 2 */
    return window.atob(str)
  }
}

class PreviousMap {
  constructor(css, opts) {
    if (opts.map === false) return
    this.loadAnnotation(css)
    this.inline = this.startWith(this.annotation, 'data:')

    let prev = opts.map ? opts.map.prev : undefined
    let text = this.loadMap(opts.from, prev)
    if (!this.mapFile && opts.from) {
      this.mapFile = opts.from
    }
    if (this.mapFile) this.root = dirname(this.mapFile)
    if (text) this.text = text
  }

  consumer() {
    if (!this.consumerCache) {
      this.consumerCache = new SourceMapConsumer(this.text)
    }
    return this.consumerCache
  }

  decodeInline(text) {
    let baseCharsetUri = /^data:application\/json;charset=utf-?8;base64,/
    let baseUri = /^data:application\/json;base64,/
    let charsetUri = /^data:application\/json;charset=utf-?8,/
    let uri = /^data:application\/json,/

    if (charsetUri.test(text) || uri.test(text)) {
      return decodeURIComponent(text.substr(RegExp.lastMatch.length))
    }

    if (baseCharsetUri.test(text) || baseUri.test(text)) {
      return fromBase64(text.substr(RegExp.lastMatch.length))
    }

    let encoding = text.match(/data:application\/json;([^,]+),/)[1]
    throw new Error('Unsupported source map encoding ' + encoding)
  }

  getAnnotationURL(sourceMapString) {
    return sourceMapString.replace(/^\/\*\s*# sourceMappingURL=/, '').trim()
  }

  isMap(map) {
    if (typeof map !== 'object') return false
    return (
      typeof map.mappings === 'string' ||
      typeof map._mappings === 'string' ||
      Array.isArray(map.sections)
    )
  }

  loadAnnotation(css) {
    let comments = css.match(/\/\*\s*# sourceMappingURL=/gm)
    if (!comments) return

    // sourceMappingURLs from comments, strings, etc.
    let start = css.lastIndexOf(comments.pop())
    let end = css.indexOf('*/', start)

    if (start > -1 && end > -1) {
      // Locate the last sourceMappingURL to avoid pickin
      this.annotation = this.getAnnotationURL(css.substring(start, end))
    }
  }

  loadFile(path) {
    this.root = dirname(path)
    if (existsSync(path)) {
      this.mapFile = path
      return readFileSync(path, 'utf-8').toString().trim()
    }
  }

  loadMap(file, prev) {
    if (prev === false) return false

    if (prev) {
      if (typeof prev === 'string') {
        return prev
      } else if (typeof prev === 'function') {
        let prevPath = prev(file)
        if (prevPath) {
          let map = this.loadFile(prevPath)
          if (!map) {
            throw new Error(
              'Unable to load previous source map: ' + prevPath.toString()
            )
          }
          return map
        }
      } else if (prev instanceof SourceMapConsumer) {
        return SourceMapGenerator.fromSourceMap(prev).toString()
      } else if (prev instanceof SourceMapGenerator) {
        return prev.toString()
      } else if (this.isMap(prev)) {
        return JSON.stringify(prev)
      } else {
        throw new Error(
          'Unsupported previous source map format: ' + prev.toString()
        )
      }
    } else if (this.inline) {
      return this.decodeInline(this.annotation)
    } else if (this.annotation) {
      let map = this.annotation
      if (file) map = join(dirname(file), map)
      return this.loadFile(map)
    }
  }

  startWith(string, start) {
    if (!string) return false
    return string.substr(0, start.length) === start
  }

  withContent() {
    return !!(
      this.consumer().sourcesContent &&
      this.consumer().sourcesContent.length > 0
    )
  }
}

module.exports = PreviousMap
PreviousMap.default = PreviousMap


/***/ }),

/***/ 9656:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let NoWorkResult = __webpack_require__(7661)
let LazyResult = __webpack_require__(448)
let Document = __webpack_require__(271)
let Root = __webpack_require__(9434)

class Processor {
  constructor(plugins = []) {
    this.version = '8.4.35'
    this.plugins = this.normalize(plugins)
  }

  normalize(plugins) {
    let normalized = []
    for (let i of plugins) {
      if (i.postcss === true) {
        i = i()
      } else if (i.postcss) {
        i = i.postcss
      }

      if (typeof i === 'object' && Array.isArray(i.plugins)) {
        normalized = normalized.concat(i.plugins)
      } else if (typeof i === 'object' && i.postcssPlugin) {
        normalized.push(i)
      } else if (typeof i === 'function') {
        normalized.push(i)
      } else if (typeof i === 'object' && (i.parse || i.stringify)) {
        if (false) {}
      } else {
        throw new Error(i + ' is not a PostCSS plugin')
      }
    }
    return normalized
  }

  process(css, opts = {}) {
    if (
      !this.plugins.length &&
      !opts.parser &&
      !opts.stringifier &&
      !opts.syntax
    ) {
      return new NoWorkResult(this, css, opts)
    } else {
      return new LazyResult(this, css, opts)
    }
  }

  use(plugin) {
    this.plugins = this.plugins.concat(this.normalize([plugin]))
    return this
  }
}

module.exports = Processor
Processor.default = Processor

Root.registerProcessor(Processor)
Document.registerProcessor(Processor)


/***/ }),

/***/ 9055:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Warning = __webpack_require__(5776)

class Result {
  constructor(processor, root, opts) {
    this.processor = processor
    this.messages = []
    this.root = root
    this.opts = opts
    this.css = undefined
    this.map = undefined
  }

  toString() {
    return this.css
  }

  warn(text, opts = {}) {
    if (!opts.plugin) {
      if (this.lastPlugin && this.lastPlugin.postcssPlugin) {
        opts.plugin = this.lastPlugin.postcssPlugin
      }
    }

    let warning = new Warning(text, opts)
    this.messages.push(warning)

    return warning
  }

  warnings() {
    return this.messages.filter(i => i.type === 'warning')
  }

  get content() {
    return this.css
  }
}

module.exports = Result
Result.default = Result


/***/ }),

/***/ 9434:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Container = __webpack_require__(683)

let LazyResult, Processor

class Root extends Container {
  constructor(defaults) {
    super(defaults)
    this.type = 'root'
    if (!this.nodes) this.nodes = []
  }

  normalize(child, sample, type) {
    let nodes = super.normalize(child)

    if (sample) {
      if (type === 'prepend') {
        if (this.nodes.length > 1) {
          sample.raws.before = this.nodes[1].raws.before
        } else {
          delete sample.raws.before
        }
      } else if (this.first !== sample) {
        for (let node of nodes) {
          node.raws.before = sample.raws.before
        }
      }
    }

    return nodes
  }

  removeChild(child, ignore) {
    let index = this.index(child)

    if (!ignore && index === 0 && this.nodes.length > 1) {
      this.nodes[1].raws.before = this.nodes[index].raws.before
    }

    return super.removeChild(child)
  }

  toResult(opts = {}) {
    let lazy = new LazyResult(new Processor(), this, opts)
    return lazy.stringify()
  }
}

Root.registerLazyResult = dependant => {
  LazyResult = dependant
}

Root.registerProcessor = dependant => {
  Processor = dependant
}

module.exports = Root
Root.default = Root

Container.registerRoot(Root)


/***/ }),

/***/ 4092:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Container = __webpack_require__(683)
let list = __webpack_require__(7374)

class Rule extends Container {
  constructor(defaults) {
    super(defaults)
    this.type = 'rule'
    if (!this.nodes) this.nodes = []
  }

  get selectors() {
    return list.comma(this.selector)
  }

  set selectors(values) {
    let match = this.selector ? this.selector.match(/,\s*/) : null
    let sep = match ? match[0] : ',' + this.raw('between', 'beforeOpen')
    this.selector = values.join(sep)
  }
}

module.exports = Rule
Rule.default = Rule

Container.registerRule(Rule)


/***/ }),

/***/ 346:
/***/ ((module) => {

"use strict";


const DEFAULT_RAW = {
  after: '\n',
  beforeClose: '\n',
  beforeComment: '\n',
  beforeDecl: '\n',
  beforeOpen: ' ',
  beforeRule: '\n',
  colon: ': ',
  commentLeft: ' ',
  commentRight: ' ',
  emptyBody: '',
  indent: '    ',
  semicolon: false
}

function capitalize(str) {
  return str[0].toUpperCase() + str.slice(1)
}

class Stringifier {
  constructor(builder) {
    this.builder = builder
  }

  atrule(node, semicolon) {
    let name = '@' + node.name
    let params = node.params ? this.rawValue(node, 'params') : ''

    if (typeof node.raws.afterName !== 'undefined') {
      name += node.raws.afterName
    } else if (params) {
      name += ' '
    }

    if (node.nodes) {
      this.block(node, name + params)
    } else {
      let end = (node.raws.between || '') + (semicolon ? ';' : '')
      this.builder(name + params + end, node)
    }
  }

  beforeAfter(node, detect) {
    let value
    if (node.type === 'decl') {
      value = this.raw(node, null, 'beforeDecl')
    } else if (node.type === 'comment') {
      value = this.raw(node, null, 'beforeComment')
    } else if (detect === 'before') {
      value = this.raw(node, null, 'beforeRule')
    } else {
      value = this.raw(node, null, 'beforeClose')
    }

    let buf = node.parent
    let depth = 0
    while (buf && buf.type !== 'root') {
      depth += 1
      buf = buf.parent
    }

    if (value.includes('\n')) {
      let indent = this.raw(node, null, 'indent')
      if (indent.length) {
        for (let step = 0; step < depth; step++) value += indent
      }
    }

    return value
  }

  block(node, start) {
    let between = this.raw(node, 'between', 'beforeOpen')
    this.builder(start + between + '{', node, 'start')

    let after
    if (node.nodes && node.nodes.length) {
      this.body(node)
      after = this.raw(node, 'after')
    } else {
      after = this.raw(node, 'after', 'emptyBody')
    }

    if (after) this.builder(after)
    this.builder('}', node, 'end')
  }

  body(node) {
    let last = node.nodes.length - 1
    while (last > 0) {
      if (node.nodes[last].type !== 'comment') break
      last -= 1
    }

    let semicolon = this.raw(node, 'semicolon')
    for (let i = 0; i < node.nodes.length; i++) {
      let child = node.nodes[i]
      let before = this.raw(child, 'before')
      if (before) this.builder(before)
      this.stringify(child, last !== i || semicolon)
    }
  }

  comment(node) {
    let left = this.raw(node, 'left', 'commentLeft')
    let right = this.raw(node, 'right', 'commentRight')
    this.builder('/*' + left + node.text + right + '*/', node)
  }

  decl(node, semicolon) {
    let between = this.raw(node, 'between', 'colon')
    let string = node.prop + between + this.rawValue(node, 'value')

    if (node.important) {
      string += node.raws.important || ' !important'
    }

    if (semicolon) string += ';'
    this.builder(string, node)
  }

  document(node) {
    this.body(node)
  }

  raw(node, own, detect) {
    let value
    if (!detect) detect = own

    // Already had
    if (own) {
      value = node.raws[own]
      if (typeof value !== 'undefined') return value
    }

    let parent = node.parent

    if (detect === 'before') {
      // Hack for first rule in CSS
      if (!parent || (parent.type === 'root' && parent.first === node)) {
        return ''
      }

      // `root` nodes in `document` should use only their own raws
      if (parent && parent.type === 'document') {
        return ''
      }
    }

    // Floating child without parent
    if (!parent) return DEFAULT_RAW[detect]

    // Detect style by other nodes
    let root = node.root()
    if (!root.rawCache) root.rawCache = {}
    if (typeof root.rawCache[detect] !== 'undefined') {
      return root.rawCache[detect]
    }

    if (detect === 'before' || detect === 'after') {
      return this.beforeAfter(node, detect)
    } else {
      let method = 'raw' + capitalize(detect)
      if (this[method]) {
        value = this[method](root, node)
      } else {
        root.walk(i => {
          value = i.raws[own]
          if (typeof value !== 'undefined') return false
        })
      }
    }

    if (typeof value === 'undefined') value = DEFAULT_RAW[detect]

    root.rawCache[detect] = value
    return value
  }

  rawBeforeClose(root) {
    let value
    root.walk(i => {
      if (i.nodes && i.nodes.length > 0) {
        if (typeof i.raws.after !== 'undefined') {
          value = i.raws.after
          if (value.includes('\n')) {
            value = value.replace(/[^\n]+$/, '')
          }
          return false
        }
      }
    })
    if (value) value = value.replace(/\S/g, '')
    return value
  }

  rawBeforeComment(root, node) {
    let value
    root.walkComments(i => {
      if (typeof i.raws.before !== 'undefined') {
        value = i.raws.before
        if (value.includes('\n')) {
          value = value.replace(/[^\n]+$/, '')
        }
        return false
      }
    })
    if (typeof value === 'undefined') {
      value = this.raw(node, null, 'beforeDecl')
    } else if (value) {
      value = value.replace(/\S/g, '')
    }
    return value
  }

  rawBeforeDecl(root, node) {
    let value
    root.walkDecls(i => {
      if (typeof i.raws.before !== 'undefined') {
        value = i.raws.before
        if (value.includes('\n')) {
          value = value.replace(/[^\n]+$/, '')
        }
        return false
      }
    })
    if (typeof value === 'undefined') {
      value = this.raw(node, null, 'beforeRule')
    } else if (value) {
      value = value.replace(/\S/g, '')
    }
    return value
  }

  rawBeforeOpen(root) {
    let value
    root.walk(i => {
      if (i.type !== 'decl') {
        value = i.raws.between
        if (typeof value !== 'undefined') return false
      }
    })
    return value
  }

  rawBeforeRule(root) {
    let value
    root.walk(i => {
      if (i.nodes && (i.parent !== root || root.first !== i)) {
        if (typeof i.raws.before !== 'undefined') {
          value = i.raws.before
          if (value.includes('\n')) {
            value = value.replace(/[^\n]+$/, '')
          }
          return false
        }
      }
    })
    if (value) value = value.replace(/\S/g, '')
    return value
  }

  rawColon(root) {
    let value
    root.walkDecls(i => {
      if (typeof i.raws.between !== 'undefined') {
        value = i.raws.between.replace(/[^\s:]/g, '')
        return false
      }
    })
    return value
  }

  rawEmptyBody(root) {
    let value
    root.walk(i => {
      if (i.nodes && i.nodes.length === 0) {
        value = i.raws.after
        if (typeof value !== 'undefined') return false
      }
    })
    return value
  }

  rawIndent(root) {
    if (root.raws.indent) return root.raws.indent
    let value
    root.walk(i => {
      let p = i.parent
      if (p && p !== root && p.parent && p.parent === root) {
        if (typeof i.raws.before !== 'undefined') {
          let parts = i.raws.before.split('\n')
          value = parts[parts.length - 1]
          value = value.replace(/\S/g, '')
          return false
        }
      }
    })
    return value
  }

  rawSemicolon(root) {
    let value
    root.walk(i => {
      if (i.nodes && i.nodes.length && i.last.type === 'decl') {
        value = i.raws.semicolon
        if (typeof value !== 'undefined') return false
      }
    })
    return value
  }

  rawValue(node, prop) {
    let value = node[prop]
    let raw = node.raws[prop]
    if (raw && raw.value === value) {
      return raw.raw
    }

    return value
  }

  root(node) {
    this.body(node)
    if (node.raws.after) this.builder(node.raws.after)
  }

  rule(node) {
    this.block(node, this.rawValue(node, 'selector'))
    if (node.raws.ownSemicolon) {
      this.builder(node.raws.ownSemicolon, node, 'end')
    }
  }

  stringify(node, semicolon) {
    /* c8 ignore start */
    if (!this[node.type]) {
      throw new Error(
        'Unknown AST node type ' +
          node.type +
          '. ' +
          'Maybe you need to change PostCSS stringifier.'
      )
    }
    /* c8 ignore stop */
    this[node.type](node, semicolon)
  }
}

module.exports = Stringifier
Stringifier.default = Stringifier


/***/ }),

/***/ 633:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


let Stringifier = __webpack_require__(346)

function stringify(node, builder) {
  let str = new Stringifier(builder)
  str.stringify(node)
}

module.exports = stringify
stringify.default = stringify


/***/ }),

/***/ 1381:
/***/ ((module) => {

"use strict";


module.exports.isClean = Symbol('isClean')

module.exports.my = Symbol('my')


/***/ }),

/***/ 2327:
/***/ ((module) => {

"use strict";


const SINGLE_QUOTE = "'".charCodeAt(0)
const DOUBLE_QUOTE = '"'.charCodeAt(0)
const BACKSLASH = '\\'.charCodeAt(0)
const SLASH = '/'.charCodeAt(0)
const NEWLINE = '\n'.charCodeAt(0)
const SPACE = ' '.charCodeAt(0)
const FEED = '\f'.charCodeAt(0)
const TAB = '\t'.charCodeAt(0)
const CR = '\r'.charCodeAt(0)
const OPEN_SQUARE = '['.charCodeAt(0)
const CLOSE_SQUARE = ']'.charCodeAt(0)
const OPEN_PARENTHESES = '('.charCodeAt(0)
const CLOSE_PARENTHESES = ')'.charCodeAt(0)
const OPEN_CURLY = '{'.charCodeAt(0)
const CLOSE_CURLY = '}'.charCodeAt(0)
const SEMICOLON = ';'.charCodeAt(0)
const ASTERISK = '*'.charCodeAt(0)
const COLON = ':'.charCodeAt(0)
const AT = '@'.charCodeAt(0)

const RE_AT_END = /[\t\n\f\r "#'()/;[\\\]{}]/g
const RE_WORD_END = /[\t\n\f\r !"#'():;@[\\\]{}]|\/(?=\*)/g
const RE_BAD_BRACKET = /.[\r\n"'(/\\]/
const RE_HEX_ESCAPE = /[\da-f]/i

module.exports = function tokenizer(input, options = {}) {
  let css = input.css.valueOf()
  let ignore = options.ignoreErrors

  let code, next, quote, content, escape
  let escaped, escapePos, prev, n, currentToken

  let length = css.length
  let pos = 0
  let buffer = []
  let returned = []

  function position() {
    return pos
  }

  function unclosed(what) {
    throw input.error('Unclosed ' + what, pos)
  }

  function endOfFile() {
    return returned.length === 0 && pos >= length
  }

  function nextToken(opts) {
    if (returned.length) return returned.pop()
    if (pos >= length) return

    let ignoreUnclosed = opts ? opts.ignoreUnclosed : false

    code = css.charCodeAt(pos)

    switch (code) {
      case NEWLINE:
      case SPACE:
      case TAB:
      case CR:
      case FEED: {
        next = pos
        do {
          next += 1
          code = css.charCodeAt(next)
        } while (
          code === SPACE ||
          code === NEWLINE ||
          code === TAB ||
          code === CR ||
          code === FEED
        )

        currentToken = ['space', css.slice(pos, next)]
        pos = next - 1
        break
      }

      case OPEN_SQUARE:
      case CLOSE_SQUARE:
      case OPEN_CURLY:
      case CLOSE_CURLY:
      case COLON:
      case SEMICOLON:
      case CLOSE_PARENTHESES: {
        let controlChar = String.fromCharCode(code)
        currentToken = [controlChar, controlChar, pos]
        break
      }

      case OPEN_PARENTHESES: {
        prev = buffer.length ? buffer.pop()[1] : ''
        n = css.charCodeAt(pos + 1)
        if (
          prev === 'url' &&
          n !== SINGLE_QUOTE &&
          n !== DOUBLE_QUOTE &&
          n !== SPACE &&
          n !== NEWLINE &&
          n !== TAB &&
          n !== FEED &&
          n !== CR
        ) {
          next = pos
          do {
            escaped = false
            next = css.indexOf(')', next + 1)
            if (next === -1) {
              if (ignore || ignoreUnclosed) {
                next = pos
                break
              } else {
                unclosed('bracket')
              }
            }
            escapePos = next
            while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
              escapePos -= 1
              escaped = !escaped
            }
          } while (escaped)

          currentToken = ['brackets', css.slice(pos, next + 1), pos, next]

          pos = next
        } else {
          next = css.indexOf(')', pos + 1)
          content = css.slice(pos, next + 1)

          if (next === -1 || RE_BAD_BRACKET.test(content)) {
            currentToken = ['(', '(', pos]
          } else {
            currentToken = ['brackets', content, pos, next]
            pos = next
          }
        }

        break
      }

      case SINGLE_QUOTE:
      case DOUBLE_QUOTE: {
        quote = code === SINGLE_QUOTE ? "'" : '"'
        next = pos
        do {
          escaped = false
          next = css.indexOf(quote, next + 1)
          if (next === -1) {
            if (ignore || ignoreUnclosed) {
              next = pos + 1
              break
            } else {
              unclosed('string')
            }
          }
          escapePos = next
          while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
            escapePos -= 1
            escaped = !escaped
          }
        } while (escaped)

        currentToken = ['string', css.slice(pos, next + 1), pos, next]
        pos = next
        break
      }

      case AT: {
        RE_AT_END.lastIndex = pos + 1
        RE_AT_END.test(css)
        if (RE_AT_END.lastIndex === 0) {
          next = css.length - 1
        } else {
          next = RE_AT_END.lastIndex - 2
        }

        currentToken = ['at-word', css.slice(pos, next + 1), pos, next]

        pos = next
        break
      }

      case BACKSLASH: {
        next = pos
        escape = true
        while (css.charCodeAt(next + 1) === BACKSLASH) {
          next += 1
          escape = !escape
        }
        code = css.charCodeAt(next + 1)
        if (
          escape &&
          code !== SLASH &&
          code !== SPACE &&
          code !== NEWLINE &&
          code !== TAB &&
          code !== CR &&
          code !== FEED
        ) {
          next += 1
          if (RE_HEX_ESCAPE.test(css.charAt(next))) {
            while (RE_HEX_ESCAPE.test(css.charAt(next + 1))) {
              next += 1
            }
            if (css.charCodeAt(next + 1) === SPACE) {
              next += 1
            }
          }
        }

        currentToken = ['word', css.slice(pos, next + 1), pos, next]

        pos = next
        break
      }

      default: {
        if (code === SLASH && css.charCodeAt(pos + 1) === ASTERISK) {
          next = css.indexOf('*/', pos + 2) + 1
          if (next === 0) {
            if (ignore || ignoreUnclosed) {
              next = css.length
            } else {
              unclosed('comment')
            }
          }

          currentToken = ['comment', css.slice(pos, next + 1), pos, next]
          pos = next
        } else {
          RE_WORD_END.lastIndex = pos + 1
          RE_WORD_END.test(css)
          if (RE_WORD_END.lastIndex === 0) {
            next = css.length - 1
          } else {
            next = RE_WORD_END.lastIndex - 2
          }

          currentToken = ['word', css.slice(pos, next + 1), pos, next]
          buffer.push(currentToken)
          pos = next
        }

        break
      }
    }

    pos++
    return currentToken
  }

  function back(token) {
    returned.push(token)
  }

  return {
    back,
    endOfFile,
    nextToken,
    position
  }
}


/***/ }),

/***/ 3122:
/***/ ((module) => {

"use strict";
/* eslint-disable no-console */


let printed = {}

module.exports = function warnOnce(message) {
  if (printed[message]) return
  printed[message] = true

  if (typeof console !== 'undefined' && console.warn) {
    console.warn(message)
  }
}


/***/ }),

/***/ 5776:
/***/ ((module) => {

"use strict";


class Warning {
  constructor(text, opts = {}) {
    this.type = 'warning'
    this.text = text

    if (opts.node && opts.node.source) {
      let range = opts.node.rangeBy(opts)
      this.line = range.start.line
      this.column = range.start.column
      this.endLine = range.end.line
      this.endColumn = range.end.column
    }

    for (let opt in opts) this[opt] = opts[opt]
  }

  toString() {
    if (this.node) {
      return this.node.error(this.text, {
        index: this.index,
        plugin: this.plugin,
        word: this.word
      }).message
    }

    if (this.plugin) {
      return this.plugin + ': ' + this.text
    }

    return this.text
  }
}

module.exports = Warning
Warning.default = Warning


/***/ }),

/***/ 628:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = __webpack_require__(4067);

function emptyFunction() {}
function emptyFunctionWithReset() {}
emptyFunctionWithReset.resetWarningCache = emptyFunction;

module.exports = function() {
  function shim(props, propName, componentName, location, propFullName, secret) {
    if (secret === ReactPropTypesSecret) {
      // It is still safe when called from React.
      return;
    }
    var err = new Error(
      'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
      'Use PropTypes.checkPropTypes() to call them. ' +
      'Read more at http://fb.me/use-check-prop-types'
    );
    err.name = 'Invariant Violation';
    throw err;
  };
  shim.isRequired = shim;
  function getShim() {
    return shim;
  };
  // Important!
  // Keep this list in sync with production version in `./factoryWithTypeCheckers.js`.
  var ReactPropTypes = {
    array: shim,
    bigint: shim,
    bool: shim,
    func: shim,
    number: shim,
    object: shim,
    string: shim,
    symbol: shim,

    any: shim,
    arrayOf: getShim,
    element: shim,
    elementType: shim,
    instanceOf: getShim,
    node: shim,
    objectOf: getShim,
    oneOf: getShim,
    oneOfType: getShim,
    shape: getShim,
    exact: getShim,

    checkPropTypes: emptyFunctionWithReset,
    resetWarningCache: emptyFunction
  };

  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};


/***/ }),

/***/ 5826:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

if (false) { var throwOnDirectAccess, ReactIs; } else {
  // By explicitly using `prop-types` you are opting into new production behavior.
  // http://fb.me/prop-types-in-prod
  module.exports = __webpack_require__(628)();
}


/***/ }),

/***/ 4067:
/***/ ((module) => {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

module.exports = ReactPropTypesSecret;


/***/ }),

/***/ 4462:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
exports.__esModule = true;
var React = __webpack_require__(1609);
var PropTypes = __webpack_require__(5826);
var autosize = __webpack_require__(4306);
var _getLineHeight = __webpack_require__(461);
var getLineHeight = _getLineHeight;
var RESIZED = "autosize:resized";
/**
 * A light replacement for built-in textarea component
 * which automaticaly adjusts its height to match the content
 */
var TextareaAutosizeClass = /** @class */ (function (_super) {
    __extends(TextareaAutosizeClass, _super);
    function TextareaAutosizeClass() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            lineHeight: null
        };
        _this.textarea = null;
        _this.onResize = function (e) {
            if (_this.props.onResize) {
                _this.props.onResize(e);
            }
        };
        _this.updateLineHeight = function () {
            if (_this.textarea) {
                _this.setState({
                    lineHeight: getLineHeight(_this.textarea)
                });
            }
        };
        _this.onChange = function (e) {
            var onChange = _this.props.onChange;
            _this.currentValue = e.currentTarget.value;
            onChange && onChange(e);
        };
        return _this;
    }
    TextareaAutosizeClass.prototype.componentDidMount = function () {
        var _this = this;
        var _a = this.props, maxRows = _a.maxRows, async = _a.async;
        if (typeof maxRows === "number") {
            this.updateLineHeight();
        }
        if (typeof maxRows === "number" || async) {
            /*
              the defer is needed to:
                - force "autosize" to activate the scrollbar when this.props.maxRows is passed
                - support StyledComponents (see #71)
            */
            setTimeout(function () { return _this.textarea && autosize(_this.textarea); });
        }
        else {
            this.textarea && autosize(this.textarea);
        }
        if (this.textarea) {
            this.textarea.addEventListener(RESIZED, this.onResize);
        }
    };
    TextareaAutosizeClass.prototype.componentWillUnmount = function () {
        if (this.textarea) {
            this.textarea.removeEventListener(RESIZED, this.onResize);
            autosize.destroy(this.textarea);
        }
    };
    TextareaAutosizeClass.prototype.render = function () {
        var _this = this;
        var _a = this, _b = _a.props, onResize = _b.onResize, maxRows = _b.maxRows, onChange = _b.onChange, style = _b.style, innerRef = _b.innerRef, children = _b.children, props = __rest(_b, ["onResize", "maxRows", "onChange", "style", "innerRef", "children"]), lineHeight = _a.state.lineHeight;
        var maxHeight = maxRows && lineHeight ? lineHeight * maxRows : null;
        return (React.createElement("textarea", __assign({}, props, { onChange: this.onChange, style: maxHeight ? __assign({}, style, { maxHeight: maxHeight }) : style, ref: function (element) {
                _this.textarea = element;
                if (typeof _this.props.innerRef === 'function') {
                    _this.props.innerRef(element);
                }
                else if (_this.props.innerRef) {
                    _this.props.innerRef.current = element;
                }
            } }), children));
    };
    TextareaAutosizeClass.prototype.componentDidUpdate = function () {
        this.textarea && autosize.update(this.textarea);
    };
    TextareaAutosizeClass.defaultProps = {
        rows: 1,
        async: false
    };
    TextareaAutosizeClass.propTypes = {
        rows: PropTypes.number,
        maxRows: PropTypes.number,
        onResize: PropTypes.func,
        innerRef: PropTypes.any,
        async: PropTypes.bool
    };
    return TextareaAutosizeClass;
}(React.Component));
exports.TextareaAutosize = React.forwardRef(function (props, ref) {
    return React.createElement(TextareaAutosizeClass, __assign({}, props, { innerRef: ref }));
});


/***/ }),

/***/ 4132:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
var __webpack_unused_export__;

__webpack_unused_export__ = true;
var TextareaAutosize_1 = __webpack_require__(4462);
exports.A = TextareaAutosize_1.TextareaAutosize;


/***/ }),

/***/ 9681:
/***/ ((module) => {

var characterMap = {
	"À": "A",
	"Á": "A",
	"Â": "A",
	"Ã": "A",
	"Ä": "A",
	"Å": "A",
	"Ấ": "A",
	"Ắ": "A",
	"Ẳ": "A",
	"Ẵ": "A",
	"Ặ": "A",
	"Æ": "AE",
	"Ầ": "A",
	"Ằ": "A",
	"Ȃ": "A",
	"Ả": "A",
	"Ạ": "A",
	"Ẩ": "A",
	"Ẫ": "A",
	"Ậ": "A",
	"Ç": "C",
	"Ḉ": "C",
	"È": "E",
	"É": "E",
	"Ê": "E",
	"Ë": "E",
	"Ế": "E",
	"Ḗ": "E",
	"Ề": "E",
	"Ḕ": "E",
	"Ḝ": "E",
	"Ȇ": "E",
	"Ẻ": "E",
	"Ẽ": "E",
	"Ẹ": "E",
	"Ể": "E",
	"Ễ": "E",
	"Ệ": "E",
	"Ì": "I",
	"Í": "I",
	"Î": "I",
	"Ï": "I",
	"Ḯ": "I",
	"Ȋ": "I",
	"Ỉ": "I",
	"Ị": "I",
	"Ð": "D",
	"Ñ": "N",
	"Ò": "O",
	"Ó": "O",
	"Ô": "O",
	"Õ": "O",
	"Ö": "O",
	"Ø": "O",
	"Ố": "O",
	"Ṍ": "O",
	"Ṓ": "O",
	"Ȏ": "O",
	"Ỏ": "O",
	"Ọ": "O",
	"Ổ": "O",
	"Ỗ": "O",
	"Ộ": "O",
	"Ờ": "O",
	"Ở": "O",
	"Ỡ": "O",
	"Ớ": "O",
	"Ợ": "O",
	"Ù": "U",
	"Ú": "U",
	"Û": "U",
	"Ü": "U",
	"Ủ": "U",
	"Ụ": "U",
	"Ử": "U",
	"Ữ": "U",
	"Ự": "U",
	"Ý": "Y",
	"à": "a",
	"á": "a",
	"â": "a",
	"ã": "a",
	"ä": "a",
	"å": "a",
	"ấ": "a",
	"ắ": "a",
	"ẳ": "a",
	"ẵ": "a",
	"ặ": "a",
	"æ": "ae",
	"ầ": "a",
	"ằ": "a",
	"ȃ": "a",
	"ả": "a",
	"ạ": "a",
	"ẩ": "a",
	"ẫ": "a",
	"ậ": "a",
	"ç": "c",
	"ḉ": "c",
	"è": "e",
	"é": "e",
	"ê": "e",
	"ë": "e",
	"ế": "e",
	"ḗ": "e",
	"ề": "e",
	"ḕ": "e",
	"ḝ": "e",
	"ȇ": "e",
	"ẻ": "e",
	"ẽ": "e",
	"ẹ": "e",
	"ể": "e",
	"ễ": "e",
	"ệ": "e",
	"ì": "i",
	"í": "i",
	"î": "i",
	"ï": "i",
	"ḯ": "i",
	"ȋ": "i",
	"ỉ": "i",
	"ị": "i",
	"ð": "d",
	"ñ": "n",
	"ò": "o",
	"ó": "o",
	"ô": "o",
	"õ": "o",
	"ö": "o",
	"ø": "o",
	"ố": "o",
	"ṍ": "o",
	"ṓ": "o",
	"ȏ": "o",
	"ỏ": "o",
	"ọ": "o",
	"ổ": "o",
	"ỗ": "o",
	"ộ": "o",
	"ờ": "o",
	"ở": "o",
	"ỡ": "o",
	"ớ": "o",
	"ợ": "o",
	"ù": "u",
	"ú": "u",
	"û": "u",
	"ü": "u",
	"ủ": "u",
	"ụ": "u",
	"ử": "u",
	"ữ": "u",
	"ự": "u",
	"ý": "y",
	"ÿ": "y",
	"Ā": "A",
	"ā": "a",
	"Ă": "A",
	"ă": "a",
	"Ą": "A",
	"ą": "a",
	"Ć": "C",
	"ć": "c",
	"Ĉ": "C",
	"ĉ": "c",
	"Ċ": "C",
	"ċ": "c",
	"Č": "C",
	"č": "c",
	"C̆": "C",
	"c̆": "c",
	"Ď": "D",
	"ď": "d",
	"Đ": "D",
	"đ": "d",
	"Ē": "E",
	"ē": "e",
	"Ĕ": "E",
	"ĕ": "e",
	"Ė": "E",
	"ė": "e",
	"Ę": "E",
	"ę": "e",
	"Ě": "E",
	"ě": "e",
	"Ĝ": "G",
	"Ǵ": "G",
	"ĝ": "g",
	"ǵ": "g",
	"Ğ": "G",
	"ğ": "g",
	"Ġ": "G",
	"ġ": "g",
	"Ģ": "G",
	"ģ": "g",
	"Ĥ": "H",
	"ĥ": "h",
	"Ħ": "H",
	"ħ": "h",
	"Ḫ": "H",
	"ḫ": "h",
	"Ĩ": "I",
	"ĩ": "i",
	"Ī": "I",
	"ī": "i",
	"Ĭ": "I",
	"ĭ": "i",
	"Į": "I",
	"į": "i",
	"İ": "I",
	"ı": "i",
	"Ĳ": "IJ",
	"ĳ": "ij",
	"Ĵ": "J",
	"ĵ": "j",
	"Ķ": "K",
	"ķ": "k",
	"Ḱ": "K",
	"ḱ": "k",
	"K̆": "K",
	"k̆": "k",
	"Ĺ": "L",
	"ĺ": "l",
	"Ļ": "L",
	"ļ": "l",
	"Ľ": "L",
	"ľ": "l",
	"Ŀ": "L",
	"ŀ": "l",
	"Ł": "l",
	"ł": "l",
	"Ḿ": "M",
	"ḿ": "m",
	"M̆": "M",
	"m̆": "m",
	"Ń": "N",
	"ń": "n",
	"Ņ": "N",
	"ņ": "n",
	"Ň": "N",
	"ň": "n",
	"ŉ": "n",
	"N̆": "N",
	"n̆": "n",
	"Ō": "O",
	"ō": "o",
	"Ŏ": "O",
	"ŏ": "o",
	"Ő": "O",
	"ő": "o",
	"Œ": "OE",
	"œ": "oe",
	"P̆": "P",
	"p̆": "p",
	"Ŕ": "R",
	"ŕ": "r",
	"Ŗ": "R",
	"ŗ": "r",
	"Ř": "R",
	"ř": "r",
	"R̆": "R",
	"r̆": "r",
	"Ȓ": "R",
	"ȓ": "r",
	"Ś": "S",
	"ś": "s",
	"Ŝ": "S",
	"ŝ": "s",
	"Ş": "S",
	"Ș": "S",
	"ș": "s",
	"ş": "s",
	"Š": "S",
	"š": "s",
	"Ţ": "T",
	"ţ": "t",
	"ț": "t",
	"Ț": "T",
	"Ť": "T",
	"ť": "t",
	"Ŧ": "T",
	"ŧ": "t",
	"T̆": "T",
	"t̆": "t",
	"Ũ": "U",
	"ũ": "u",
	"Ū": "U",
	"ū": "u",
	"Ŭ": "U",
	"ŭ": "u",
	"Ů": "U",
	"ů": "u",
	"Ű": "U",
	"ű": "u",
	"Ų": "U",
	"ų": "u",
	"Ȗ": "U",
	"ȗ": "u",
	"V̆": "V",
	"v̆": "v",
	"Ŵ": "W",
	"ŵ": "w",
	"Ẃ": "W",
	"ẃ": "w",
	"X̆": "X",
	"x̆": "x",
	"Ŷ": "Y",
	"ŷ": "y",
	"Ÿ": "Y",
	"Y̆": "Y",
	"y̆": "y",
	"Ź": "Z",
	"ź": "z",
	"Ż": "Z",
	"ż": "z",
	"Ž": "Z",
	"ž": "z",
	"ſ": "s",
	"ƒ": "f",
	"Ơ": "O",
	"ơ": "o",
	"Ư": "U",
	"ư": "u",
	"Ǎ": "A",
	"ǎ": "a",
	"Ǐ": "I",
	"ǐ": "i",
	"Ǒ": "O",
	"ǒ": "o",
	"Ǔ": "U",
	"ǔ": "u",
	"Ǖ": "U",
	"ǖ": "u",
	"Ǘ": "U",
	"ǘ": "u",
	"Ǚ": "U",
	"ǚ": "u",
	"Ǜ": "U",
	"ǜ": "u",
	"Ứ": "U",
	"ứ": "u",
	"Ṹ": "U",
	"ṹ": "u",
	"Ǻ": "A",
	"ǻ": "a",
	"Ǽ": "AE",
	"ǽ": "ae",
	"Ǿ": "O",
	"ǿ": "o",
	"Þ": "TH",
	"þ": "th",
	"Ṕ": "P",
	"ṕ": "p",
	"Ṥ": "S",
	"ṥ": "s",
	"X́": "X",
	"x́": "x",
	"Ѓ": "Г",
	"ѓ": "г",
	"Ќ": "К",
	"ќ": "к",
	"A̋": "A",
	"a̋": "a",
	"E̋": "E",
	"e̋": "e",
	"I̋": "I",
	"i̋": "i",
	"Ǹ": "N",
	"ǹ": "n",
	"Ồ": "O",
	"ồ": "o",
	"Ṑ": "O",
	"ṑ": "o",
	"Ừ": "U",
	"ừ": "u",
	"Ẁ": "W",
	"ẁ": "w",
	"Ỳ": "Y",
	"ỳ": "y",
	"Ȁ": "A",
	"ȁ": "a",
	"Ȅ": "E",
	"ȅ": "e",
	"Ȉ": "I",
	"ȉ": "i",
	"Ȍ": "O",
	"ȍ": "o",
	"Ȑ": "R",
	"ȑ": "r",
	"Ȕ": "U",
	"ȕ": "u",
	"B̌": "B",
	"b̌": "b",
	"Č̣": "C",
	"č̣": "c",
	"Ê̌": "E",
	"ê̌": "e",
	"F̌": "F",
	"f̌": "f",
	"Ǧ": "G",
	"ǧ": "g",
	"Ȟ": "H",
	"ȟ": "h",
	"J̌": "J",
	"ǰ": "j",
	"Ǩ": "K",
	"ǩ": "k",
	"M̌": "M",
	"m̌": "m",
	"P̌": "P",
	"p̌": "p",
	"Q̌": "Q",
	"q̌": "q",
	"Ř̩": "R",
	"ř̩": "r",
	"Ṧ": "S",
	"ṧ": "s",
	"V̌": "V",
	"v̌": "v",
	"W̌": "W",
	"w̌": "w",
	"X̌": "X",
	"x̌": "x",
	"Y̌": "Y",
	"y̌": "y",
	"A̧": "A",
	"a̧": "a",
	"B̧": "B",
	"b̧": "b",
	"Ḑ": "D",
	"ḑ": "d",
	"Ȩ": "E",
	"ȩ": "e",
	"Ɛ̧": "E",
	"ɛ̧": "e",
	"Ḩ": "H",
	"ḩ": "h",
	"I̧": "I",
	"i̧": "i",
	"Ɨ̧": "I",
	"ɨ̧": "i",
	"M̧": "M",
	"m̧": "m",
	"O̧": "O",
	"o̧": "o",
	"Q̧": "Q",
	"q̧": "q",
	"U̧": "U",
	"u̧": "u",
	"X̧": "X",
	"x̧": "x",
	"Z̧": "Z",
	"z̧": "z",
	"й":"и",
	"Й":"И",
	"ё":"е",
	"Ё":"Е",
};

var chars = Object.keys(characterMap).join('|');
var allAccents = new RegExp(chars, 'g');
var firstAccent = new RegExp(chars, '');

function matcher(match) {
	return characterMap[match];
}

var removeAccents = function(string) {
	return string.replace(allAccents, matcher);
};

var hasAccents = function(string) {
	return !!string.match(firstAccent);
};

module.exports = removeAccents;
module.exports.has = hasAccents;
module.exports.remove = removeAccents;


/***/ }),

/***/ 1609:
/***/ ((module) => {

"use strict";
module.exports = window["React"];

/***/ }),

/***/ 9746:
/***/ (() => {

/* (ignored) */

/***/ }),

/***/ 9977:
/***/ (() => {

/* (ignored) */

/***/ }),

/***/ 197:
/***/ (() => {

/* (ignored) */

/***/ }),

/***/ 1866:
/***/ (() => {

/* (ignored) */

/***/ }),

/***/ 2739:
/***/ (() => {

/* (ignored) */

/***/ }),

/***/ 5042:
/***/ ((module) => {

let urlAlphabet =
  'useandom-26T198340PX75pxJACKVERYMINDBUSHWOLF_GQZbfghjklqvwyzrict'
let customAlphabet = (alphabet, defaultSize = 21) => {
  return (size = defaultSize) => {
    let id = ''
    let i = size
    while (i--) {
      id += alphabet[(Math.random() * alphabet.length) | 0]
    }
    return id
  }
}
let nanoid = (size = 21) => {
  let id = ''
  let i = size
  while (i--) {
    id += urlAlphabet[(Math.random() * 64) | 0]
  }
  return id
}
module.exports = { nanoid, customAlphabet }


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be in strict mode.
(() => {
"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  AlignmentControl: () => (/* reexport */ AlignmentControl),
  AlignmentToolbar: () => (/* reexport */ AlignmentToolbar),
  Autocomplete: () => (/* reexport */ autocomplete),
  BlockAlignmentControl: () => (/* reexport */ BlockAlignmentControl),
  BlockAlignmentToolbar: () => (/* reexport */ BlockAlignmentToolbar),
  BlockBreadcrumb: () => (/* reexport */ block_breadcrumb),
  BlockCanvas: () => (/* reexport */ block_canvas),
  BlockColorsStyleSelector: () => (/* reexport */ color_style_selector),
  BlockContextProvider: () => (/* reexport */ BlockContextProvider),
  BlockControls: () => (/* reexport */ block_controls),
  BlockEdit: () => (/* reexport */ BlockEdit),
  BlockEditorKeyboardShortcuts: () => (/* reexport */ keyboard_shortcuts),
  BlockEditorProvider: () => (/* reexport */ provider),
  BlockFormatControls: () => (/* reexport */ BlockFormatControls),
  BlockIcon: () => (/* reexport */ block_icon),
  BlockInspector: () => (/* reexport */ block_inspector),
  BlockList: () => (/* reexport */ BlockList),
  BlockMover: () => (/* reexport */ block_mover),
  BlockNavigationDropdown: () => (/* reexport */ dropdown),
  BlockPopover: () => (/* reexport */ block_popover),
  BlockPreview: () => (/* reexport */ block_preview),
  BlockSelectionClearer: () => (/* reexport */ BlockSelectionClearer),
  BlockSettingsMenu: () => (/* reexport */ block_settings_menu),
  BlockSettingsMenuControls: () => (/* reexport */ block_settings_menu_controls),
  BlockStyles: () => (/* reexport */ block_styles),
  BlockTitle: () => (/* reexport */ BlockTitle),
  BlockToolbar: () => (/* reexport */ BlockToolbar),
  BlockTools: () => (/* reexport */ BlockTools),
  BlockVerticalAlignmentControl: () => (/* reexport */ BlockVerticalAlignmentControl),
  BlockVerticalAlignmentToolbar: () => (/* reexport */ BlockVerticalAlignmentToolbar),
  ButtonBlockAppender: () => (/* reexport */ button_block_appender),
  ButtonBlockerAppender: () => (/* reexport */ ButtonBlockerAppender),
  ColorPalette: () => (/* reexport */ color_palette),
  ColorPaletteControl: () => (/* reexport */ ColorPaletteControl),
  ContrastChecker: () => (/* reexport */ contrast_checker),
  CopyHandler: () => (/* reexport */ CopyHandler),
  DefaultBlockAppender: () => (/* reexport */ DefaultBlockAppender),
  FontSizePicker: () => (/* reexport */ font_size_picker),
  HeadingLevelDropdown: () => (/* reexport */ HeadingLevelDropdown),
  HeightControl: () => (/* reexport */ HeightControl),
  InnerBlocks: () => (/* reexport */ inner_blocks),
  Inserter: () => (/* reexport */ inserter),
  InspectorAdvancedControls: () => (/* reexport */ InspectorAdvancedControls),
  InspectorControls: () => (/* reexport */ inspector_controls),
  JustifyContentControl: () => (/* reexport */ JustifyContentControl),
  JustifyToolbar: () => (/* reexport */ JustifyToolbar),
  LineHeightControl: () => (/* reexport */ line_height_control),
  MediaPlaceholder: () => (/* reexport */ media_placeholder),
  MediaReplaceFlow: () => (/* reexport */ media_replace_flow),
  MediaUpload: () => (/* reexport */ media_upload),
  MediaUploadCheck: () => (/* reexport */ check),
  MultiSelectScrollIntoView: () => (/* reexport */ MultiSelectScrollIntoView),
  NavigableToolbar: () => (/* reexport */ NavigableToolbar),
  ObserveTyping: () => (/* reexport */ observe_typing),
  PanelColorSettings: () => (/* reexport */ panel_color_settings),
  PlainText: () => (/* reexport */ plain_text),
  RecursionProvider: () => (/* reexport */ RecursionProvider),
  ReusableBlocksRenameHint: () => (/* reexport */ ReusableBlocksRenameHint),
  RichText: () => (/* reexport */ rich_text),
  RichTextShortcut: () => (/* reexport */ RichTextShortcut),
  RichTextToolbarButton: () => (/* reexport */ RichTextToolbarButton),
  SETTINGS_DEFAULTS: () => (/* reexport */ SETTINGS_DEFAULTS),
  SkipToSelectedBlock: () => (/* reexport */ SkipToSelectedBlock),
  ToolSelector: () => (/* reexport */ tool_selector),
  Typewriter: () => (/* reexport */ typewriter),
  URLInput: () => (/* reexport */ url_input),
  URLInputButton: () => (/* reexport */ url_input_button),
  URLPopover: () => (/* reexport */ url_popover),
  Warning: () => (/* reexport */ warning),
  WritingFlow: () => (/* reexport */ writing_flow),
  __experimentalBlockAlignmentMatrixControl: () => (/* reexport */ block_alignment_matrix_control),
  __experimentalBlockFullHeightAligmentControl: () => (/* reexport */ block_full_height_alignment_control),
  __experimentalBlockPatternSetup: () => (/* reexport */ block_pattern_setup),
  __experimentalBlockPatternsList: () => (/* reexport */ block_patterns_list),
  __experimentalBlockVariationPicker: () => (/* reexport */ block_variation_picker),
  __experimentalBlockVariationTransforms: () => (/* reexport */ block_variation_transforms),
  __experimentalBorderRadiusControl: () => (/* reexport */ BorderRadiusControl),
  __experimentalColorGradientControl: () => (/* reexport */ control),
  __experimentalColorGradientSettingsDropdown: () => (/* reexport */ ColorGradientSettingsDropdown),
  __experimentalDateFormatPicker: () => (/* reexport */ DateFormatPicker),
  __experimentalDuotoneControl: () => (/* reexport */ duotone_control),
  __experimentalFontAppearanceControl: () => (/* reexport */ FontAppearanceControl),
  __experimentalFontFamilyControl: () => (/* reexport */ FontFamilyControl),
  __experimentalGetBorderClassesAndStyles: () => (/* reexport */ getBorderClassesAndStyles),
  __experimentalGetColorClassesAndStyles: () => (/* reexport */ getColorClassesAndStyles),
  __experimentalGetElementClassName: () => (/* reexport */ __experimentalGetElementClassName),
  __experimentalGetGapCSSValue: () => (/* reexport */ getGapCSSValue),
  __experimentalGetGradientClass: () => (/* reexport */ __experimentalGetGradientClass),
  __experimentalGetGradientObjectByGradientValue: () => (/* reexport */ __experimentalGetGradientObjectByGradientValue),
  __experimentalGetShadowClassesAndStyles: () => (/* reexport */ getShadowClassesAndStyles),
  __experimentalGetSpacingClassesAndStyles: () => (/* reexport */ getSpacingClassesAndStyles),
  __experimentalImageEditor: () => (/* reexport */ ImageEditor),
  __experimentalImageSizeControl: () => (/* reexport */ ImageSizeControl),
  __experimentalImageURLInputUI: () => (/* reexport */ ImageURLInputUI),
  __experimentalInspectorPopoverHeader: () => (/* reexport */ InspectorPopoverHeader),
  __experimentalLetterSpacingControl: () => (/* reexport */ LetterSpacingControl),
  __experimentalLibrary: () => (/* reexport */ library),
  __experimentalLinkControl: () => (/* reexport */ link_control),
  __experimentalLinkControlSearchInput: () => (/* reexport */ search_input),
  __experimentalLinkControlSearchItem: () => (/* reexport */ search_item),
  __experimentalLinkControlSearchResults: () => (/* reexport */ LinkControlSearchResults),
  __experimentalListView: () => (/* reexport */ components_list_view),
  __experimentalPanelColorGradientSettings: () => (/* reexport */ panel_color_gradient_settings),
  __experimentalPreviewOptions: () => (/* reexport */ PreviewOptions),
  __experimentalPublishDateTimePicker: () => (/* reexport */ publish_date_time_picker),
  __experimentalRecursionProvider: () => (/* reexport */ DeprecatedExperimentalRecursionProvider),
  __experimentalResponsiveBlockControl: () => (/* reexport */ responsive_block_control),
  __experimentalSpacingSizesControl: () => (/* reexport */ SpacingSizesControl),
  __experimentalTextDecorationControl: () => (/* reexport */ TextDecorationControl),
  __experimentalTextTransformControl: () => (/* reexport */ TextTransformControl),
  __experimentalUnitControl: () => (/* reexport */ UnitControl),
  __experimentalUseBlockOverlayActive: () => (/* reexport */ useBlockOverlayActive),
  __experimentalUseBlockPreview: () => (/* reexport */ useBlockPreview),
  __experimentalUseBorderProps: () => (/* reexport */ useBorderProps),
  __experimentalUseColorProps: () => (/* reexport */ useColorProps),
  __experimentalUseCustomSides: () => (/* reexport */ useCustomSides),
  __experimentalUseGradient: () => (/* reexport */ __experimentalUseGradient),
  __experimentalUseHasRecursion: () => (/* reexport */ DeprecatedExperimentalUseHasRecursion),
  __experimentalUseMultipleOriginColorsAndGradients: () => (/* reexport */ useMultipleOriginColorsAndGradients),
  __experimentalUseResizeCanvas: () => (/* reexport */ useResizeCanvas),
  __experimentalWritingModeControl: () => (/* reexport */ WritingModeControl),
  __unstableBlockNameContext: () => (/* reexport */ block_name_context),
  __unstableBlockSettingsMenuFirstItem: () => (/* reexport */ block_settings_menu_first_item),
  __unstableBlockToolbarLastItem: () => (/* reexport */ block_toolbar_last_item),
  __unstableEditorStyles: () => (/* reexport */ editor_styles),
  __unstableIframe: () => (/* reexport */ iframe),
  __unstableInserterMenuExtension: () => (/* reexport */ inserter_menu_extension),
  __unstableRichTextInputEvent: () => (/* reexport */ __unstableRichTextInputEvent),
  __unstableUseBlockSelectionClearer: () => (/* reexport */ useBlockSelectionClearer),
  __unstableUseClipboardHandler: () => (/* reexport */ __unstableUseClipboardHandler),
  __unstableUseMouseMoveTypingReset: () => (/* reexport */ useMouseMoveTypingReset),
  __unstableUseTypewriter: () => (/* reexport */ useTypewriter),
  __unstableUseTypingObserver: () => (/* reexport */ useTypingObserver),
  createCustomColorsHOC: () => (/* reexport */ createCustomColorsHOC),
  getColorClassName: () => (/* reexport */ getColorClassName),
  getColorObjectByAttributeValues: () => (/* reexport */ getColorObjectByAttributeValues),
  getColorObjectByColorValue: () => (/* reexport */ getColorObjectByColorValue),
  getComputedFluidTypographyValue: () => (/* reexport */ getComputedFluidTypographyValue),
  getCustomValueFromPreset: () => (/* reexport */ getCustomValueFromPreset),
  getFontSize: () => (/* reexport */ utils_getFontSize),
  getFontSizeClass: () => (/* reexport */ getFontSizeClass),
  getFontSizeObjectByValue: () => (/* reexport */ utils_getFontSizeObjectByValue),
  getGradientSlugByValue: () => (/* reexport */ getGradientSlugByValue),
  getGradientValueBySlug: () => (/* reexport */ getGradientValueBySlug),
  getPxFromCssUnit: () => (/* reexport */ get_px_from_css_unit),
  getSpacingPresetCssVar: () => (/* reexport */ getSpacingPresetCssVar),
  getTypographyClassesAndStyles: () => (/* reexport */ getTypographyClassesAndStyles),
  isValueSpacingPreset: () => (/* reexport */ isValueSpacingPreset),
  privateApis: () => (/* reexport */ privateApis),
  store: () => (/* reexport */ store),
  storeConfig: () => (/* reexport */ storeConfig),
  transformStyles: () => (/* reexport */ transform_styles),
  useBlockCommands: () => (/* reexport */ useBlockCommands),
  useBlockDisplayInformation: () => (/* reexport */ useBlockDisplayInformation),
  useBlockEditContext: () => (/* reexport */ useBlockEditContext),
  useBlockEditingMode: () => (/* reexport */ useBlockEditingMode),
  useBlockProps: () => (/* reexport */ use_block_props_useBlockProps),
  useCachedTruthy: () => (/* reexport */ useCachedTruthy),
  useHasRecursion: () => (/* reexport */ useHasRecursion),
  useInnerBlocksProps: () => (/* reexport */ useInnerBlocksProps),
  useSetting: () => (/* reexport */ useSetting),
  useSettings: () => (/* reexport */ use_settings_useSettings),
  useZoomOut: () => (/* reexport */ useZoomOut),
  withColorContext: () => (/* reexport */ with_color_context),
  withColors: () => (/* reexport */ withColors),
  withFontSizes: () => (/* reexport */ with_font_sizes)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/store/private-selectors.js
var private_selectors_namespaceObject = {};
__webpack_require__.r(private_selectors_namespaceObject);
__webpack_require__.d(private_selectors_namespaceObject, {
  getAllPatterns: () => (getAllPatterns),
  getBlockRemovalRules: () => (getBlockRemovalRules),
  getBlockSettings: () => (getBlockSettings),
  getBlockWithoutAttributes: () => (getBlockWithoutAttributes),
  getContentLockingParent: () => (getContentLockingParent),
  getEnabledBlockParents: () => (getEnabledBlockParents),
  getEnabledClientIdsTree: () => (getEnabledClientIdsTree),
  getExpandedBlock: () => (getExpandedBlock),
  getInserterMediaCategories: () => (getInserterMediaCategories),
  getLastFocus: () => (getLastFocus),
  getLastInsertedBlocksClientIds: () => (getLastInsertedBlocksClientIds),
  getOpenedBlockSettingsMenu: () => (getOpenedBlockSettingsMenu),
  getPatternBySlug: () => (getPatternBySlug),
  getRegisteredInserterMediaCategories: () => (getRegisteredInserterMediaCategories),
  getRemovalPromptData: () => (getRemovalPromptData),
  getReusableBlocks: () => (getReusableBlocks),
  getStyleOverrides: () => (getStyleOverrides),
  getTemporarilyEditingAsBlocks: () => (getTemporarilyEditingAsBlocks),
  getTemporarilyEditingFocusModeToRevert: () => (getTemporarilyEditingFocusModeToRevert),
  hasAllowedPatterns: () => (hasAllowedPatterns),
  isBlockInterfaceHidden: () => (private_selectors_isBlockInterfaceHidden),
  isBlockSubtreeDisabled: () => (isBlockSubtreeDisabled),
  isDragging: () => (private_selectors_isDragging),
  isResolvingPatterns: () => (isResolvingPatterns)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/store/selectors.js
var selectors_namespaceObject = {};
__webpack_require__.r(selectors_namespaceObject);
__webpack_require__.d(selectors_namespaceObject, {
  __experimentalGetActiveBlockIdByBlockNames: () => (__experimentalGetActiveBlockIdByBlockNames),
  __experimentalGetAllowedBlocks: () => (__experimentalGetAllowedBlocks),
  __experimentalGetAllowedPatterns: () => (__experimentalGetAllowedPatterns),
  __experimentalGetBlockListSettingsForBlocks: () => (__experimentalGetBlockListSettingsForBlocks),
  __experimentalGetDirectInsertBlock: () => (__experimentalGetDirectInsertBlock),
  __experimentalGetGlobalBlocksByName: () => (__experimentalGetGlobalBlocksByName),
  __experimentalGetLastBlockAttributeChanges: () => (__experimentalGetLastBlockAttributeChanges),
  __experimentalGetParsedPattern: () => (__experimentalGetParsedPattern),
  __experimentalGetPatternTransformItems: () => (__experimentalGetPatternTransformItems),
  __experimentalGetPatternsByBlockTypes: () => (__experimentalGetPatternsByBlockTypes),
  __experimentalGetReusableBlockTitle: () => (__experimentalGetReusableBlockTitle),
  __unstableGetBlockWithoutInnerBlocks: () => (__unstableGetBlockWithoutInnerBlocks),
  __unstableGetClientIdWithClientIdsTree: () => (__unstableGetClientIdWithClientIdsTree),
  __unstableGetClientIdsTree: () => (__unstableGetClientIdsTree),
  __unstableGetContentLockingParent: () => (__unstableGetContentLockingParent),
  __unstableGetEditorMode: () => (__unstableGetEditorMode),
  __unstableGetSelectedBlocksWithPartialSelection: () => (__unstableGetSelectedBlocksWithPartialSelection),
  __unstableGetTemporarilyEditingAsBlocks: () => (__unstableGetTemporarilyEditingAsBlocks),
  __unstableGetTemporarilyEditingFocusModeToRevert: () => (__unstableGetTemporarilyEditingFocusModeToRevert),
  __unstableGetVisibleBlocks: () => (__unstableGetVisibleBlocks),
  __unstableHasActiveBlockOverlayActive: () => (__unstableHasActiveBlockOverlayActive),
  __unstableIsFullySelected: () => (__unstableIsFullySelected),
  __unstableIsLastBlockChangeIgnored: () => (__unstableIsLastBlockChangeIgnored),
  __unstableIsSelectionCollapsed: () => (__unstableIsSelectionCollapsed),
  __unstableIsSelectionMergeable: () => (__unstableIsSelectionMergeable),
  __unstableIsWithinBlockOverlay: () => (__unstableIsWithinBlockOverlay),
  __unstableSelectionHasUnmergeableBlock: () => (__unstableSelectionHasUnmergeableBlock),
  areInnerBlocksControlled: () => (areInnerBlocksControlled),
  canEditBlock: () => (canEditBlock),
  canInsertBlockType: () => (canInsertBlockType),
  canInsertBlocks: () => (canInsertBlocks),
  canLockBlockType: () => (canLockBlockType),
  canMoveBlock: () => (canMoveBlock),
  canMoveBlocks: () => (canMoveBlocks),
  canRemoveBlock: () => (canRemoveBlock),
  canRemoveBlocks: () => (canRemoveBlocks),
  didAutomaticChange: () => (didAutomaticChange),
  getAdjacentBlockClientId: () => (getAdjacentBlockClientId),
  getAllowedBlocks: () => (getAllowedBlocks),
  getBlock: () => (getBlock),
  getBlockAttributes: () => (getBlockAttributes),
  getBlockCount: () => (getBlockCount),
  getBlockEditingMode: () => (getBlockEditingMode),
  getBlockHierarchyRootClientId: () => (getBlockHierarchyRootClientId),
  getBlockIndex: () => (getBlockIndex),
  getBlockInsertionPoint: () => (getBlockInsertionPoint),
  getBlockListSettings: () => (getBlockListSettings),
  getBlockMode: () => (getBlockMode),
  getBlockName: () => (getBlockName),
  getBlockNamesByClientId: () => (getBlockNamesByClientId),
  getBlockOrder: () => (getBlockOrder),
  getBlockParents: () => (getBlockParents),
  getBlockParentsByBlockName: () => (getBlockParentsByBlockName),
  getBlockRootClientId: () => (getBlockRootClientId),
  getBlockSelectionEnd: () => (getBlockSelectionEnd),
  getBlockSelectionStart: () => (getBlockSelectionStart),
  getBlockTransformItems: () => (getBlockTransformItems),
  getBlocks: () => (getBlocks),
  getBlocksByClientId: () => (getBlocksByClientId),
  getBlocksByName: () => (getBlocksByName),
  getClientIdsOfDescendants: () => (getClientIdsOfDescendants),
  getClientIdsWithDescendants: () => (getClientIdsWithDescendants),
  getDirectInsertBlock: () => (getDirectInsertBlock),
  getDraggedBlockClientIds: () => (getDraggedBlockClientIds),
  getFirstMultiSelectedBlockClientId: () => (getFirstMultiSelectedBlockClientId),
  getGlobalBlockCount: () => (getGlobalBlockCount),
  getInserterItems: () => (getInserterItems),
  getLastMultiSelectedBlockClientId: () => (getLastMultiSelectedBlockClientId),
  getLowestCommonAncestorWithSelectedBlock: () => (getLowestCommonAncestorWithSelectedBlock),
  getMultiSelectedBlockClientIds: () => (getMultiSelectedBlockClientIds),
  getMultiSelectedBlocks: () => (getMultiSelectedBlocks),
  getMultiSelectedBlocksEndClientId: () => (getMultiSelectedBlocksEndClientId),
  getMultiSelectedBlocksStartClientId: () => (getMultiSelectedBlocksStartClientId),
  getNextBlockClientId: () => (getNextBlockClientId),
  getPatternsByBlockTypes: () => (getPatternsByBlockTypes),
  getPreviousBlockClientId: () => (getPreviousBlockClientId),
  getSelectedBlock: () => (getSelectedBlock),
  getSelectedBlockClientId: () => (getSelectedBlockClientId),
  getSelectedBlockClientIds: () => (getSelectedBlockClientIds),
  getSelectedBlockCount: () => (getSelectedBlockCount),
  getSelectedBlocksInitialCaretPosition: () => (getSelectedBlocksInitialCaretPosition),
  getSelectionEnd: () => (getSelectionEnd),
  getSelectionStart: () => (getSelectionStart),
  getSettings: () => (getSettings),
  getTemplate: () => (getTemplate),
  getTemplateLock: () => (getTemplateLock),
  hasBlockMovingClientId: () => (selectors_hasBlockMovingClientId),
  hasDraggedInnerBlock: () => (hasDraggedInnerBlock),
  hasInserterItems: () => (hasInserterItems),
  hasMultiSelection: () => (hasMultiSelection),
  hasSelectedBlock: () => (hasSelectedBlock),
  hasSelectedInnerBlock: () => (hasSelectedInnerBlock),
  isAncestorBeingDragged: () => (isAncestorBeingDragged),
  isAncestorMultiSelected: () => (isAncestorMultiSelected),
  isBlockBeingDragged: () => (isBlockBeingDragged),
  isBlockHighlighted: () => (isBlockHighlighted),
  isBlockInsertionPointVisible: () => (isBlockInsertionPointVisible),
  isBlockMultiSelected: () => (isBlockMultiSelected),
  isBlockSelected: () => (isBlockSelected),
  isBlockValid: () => (isBlockValid),
  isBlockVisible: () => (isBlockVisible),
  isBlockWithinSelection: () => (isBlockWithinSelection),
  isCaretWithinFormattedText: () => (isCaretWithinFormattedText),
  isDraggingBlocks: () => (isDraggingBlocks),
  isFirstMultiSelectedBlock: () => (isFirstMultiSelectedBlock),
  isGroupable: () => (isGroupable),
  isLastBlockChangePersistent: () => (isLastBlockChangePersistent),
  isMultiSelecting: () => (selectors_isMultiSelecting),
  isNavigationMode: () => (isNavigationMode),
  isSelectionEnabled: () => (selectors_isSelectionEnabled),
  isTyping: () => (selectors_isTyping),
  isUngroupable: () => (isUngroupable),
  isValidTemplate: () => (isValidTemplate),
  wasBlockJustInserted: () => (wasBlockJustInserted)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/store/private-actions.js
var private_actions_namespaceObject = {};
__webpack_require__.r(private_actions_namespaceObject);
__webpack_require__.d(private_actions_namespaceObject, {
  __experimentalUpdateSettings: () => (__experimentalUpdateSettings),
  clearBlockRemovalPrompt: () => (clearBlockRemovalPrompt),
  deleteStyleOverride: () => (deleteStyleOverride),
  ensureDefaultBlock: () => (ensureDefaultBlock),
  expandBlock: () => (expandBlock),
  hideBlockInterface: () => (hideBlockInterface),
  modifyContentLockBlock: () => (modifyContentLockBlock),
  privateRemoveBlocks: () => (privateRemoveBlocks),
  setBlockRemovalRules: () => (setBlockRemovalRules),
  setLastFocus: () => (setLastFocus),
  setOpenedBlockSettingsMenu: () => (setOpenedBlockSettingsMenu),
  setStyleOverride: () => (setStyleOverride),
  showBlockInterface: () => (showBlockInterface),
  startDragging: () => (startDragging),
  stopDragging: () => (stopDragging),
  stopEditingAsBlocks: () => (stopEditingAsBlocks),
  syncDerivedUpdates: () => (syncDerivedUpdates)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/store/actions.js
var actions_namespaceObject = {};
__webpack_require__.r(actions_namespaceObject);
__webpack_require__.d(actions_namespaceObject, {
  __unstableDeleteSelection: () => (__unstableDeleteSelection),
  __unstableExpandSelection: () => (__unstableExpandSelection),
  __unstableMarkAutomaticChange: () => (__unstableMarkAutomaticChange),
  __unstableMarkLastChangeAsPersistent: () => (__unstableMarkLastChangeAsPersistent),
  __unstableMarkNextChangeAsNotPersistent: () => (__unstableMarkNextChangeAsNotPersistent),
  __unstableSaveReusableBlock: () => (__unstableSaveReusableBlock),
  __unstableSetEditorMode: () => (__unstableSetEditorMode),
  __unstableSetTemporarilyEditingAsBlocks: () => (__unstableSetTemporarilyEditingAsBlocks),
  __unstableSplitSelection: () => (__unstableSplitSelection),
  clearSelectedBlock: () => (clearSelectedBlock),
  duplicateBlocks: () => (duplicateBlocks),
  enterFormattedText: () => (enterFormattedText),
  exitFormattedText: () => (exitFormattedText),
  flashBlock: () => (flashBlock),
  hideInsertionPoint: () => (hideInsertionPoint),
  insertAfterBlock: () => (insertAfterBlock),
  insertBeforeBlock: () => (insertBeforeBlock),
  insertBlock: () => (insertBlock),
  insertBlocks: () => (insertBlocks),
  insertDefaultBlock: () => (insertDefaultBlock),
  mergeBlocks: () => (mergeBlocks),
  moveBlockToPosition: () => (moveBlockToPosition),
  moveBlocksDown: () => (moveBlocksDown),
  moveBlocksToPosition: () => (moveBlocksToPosition),
  moveBlocksUp: () => (moveBlocksUp),
  multiSelect: () => (multiSelect),
  receiveBlocks: () => (receiveBlocks),
  registerInserterMediaCategory: () => (registerInserterMediaCategory),
  removeBlock: () => (removeBlock),
  removeBlocks: () => (removeBlocks),
  replaceBlock: () => (replaceBlock),
  replaceBlocks: () => (replaceBlocks),
  replaceInnerBlocks: () => (replaceInnerBlocks),
  resetBlocks: () => (resetBlocks),
  resetSelection: () => (resetSelection),
  selectBlock: () => (selectBlock),
  selectNextBlock: () => (selectNextBlock),
  selectPreviousBlock: () => (selectPreviousBlock),
  selectionChange: () => (selectionChange),
  setBlockEditingMode: () => (setBlockEditingMode),
  setBlockMovingClientId: () => (setBlockMovingClientId),
  setBlockVisibility: () => (setBlockVisibility),
  setHasControlledInnerBlocks: () => (setHasControlledInnerBlocks),
  setNavigationMode: () => (setNavigationMode),
  setTemplateValidity: () => (setTemplateValidity),
  showInsertionPoint: () => (showInsertionPoint),
  startDraggingBlocks: () => (startDraggingBlocks),
  startMultiSelect: () => (startMultiSelect),
  startTyping: () => (startTyping),
  stopDraggingBlocks: () => (stopDraggingBlocks),
  stopMultiSelect: () => (stopMultiSelect),
  stopTyping: () => (stopTyping),
  synchronizeTemplate: () => (synchronizeTemplate),
  toggleBlockHighlight: () => (toggleBlockHighlight),
  toggleBlockMode: () => (toggleBlockMode),
  toggleSelection: () => (toggleSelection),
  unsetBlockEditingMode: () => (unsetBlockEditingMode),
  updateBlock: () => (updateBlock),
  updateBlockAttributes: () => (updateBlockAttributes),
  updateBlockListSettings: () => (updateBlockListSettings),
  updateSettings: () => (updateSettings),
  validateBlocksToTemplate: () => (validateBlocksToTemplate)
});

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/components/global-styles/index.js
var global_styles_namespaceObject = {};
__webpack_require__.r(global_styles_namespaceObject);
__webpack_require__.d(global_styles_namespaceObject, {
  AdvancedPanel: () => (AdvancedPanel),
  BackgroundPanel: () => (BackgroundPanel),
  BorderPanel: () => (BorderPanel),
  ColorPanel: () => (ColorPanel),
  DimensionsPanel: () => (DimensionsPanel),
  FiltersPanel: () => (FiltersPanel),
  GlobalStylesContext: () => (GlobalStylesContext),
  ImageSettingsPanel: () => (ImageSettingsPanel),
  TypographyPanel: () => (TypographyPanel),
  areGlobalStyleConfigsEqual: () => (areGlobalStyleConfigsEqual),
  getBlockCSSSelector: () => (getBlockCSSSelector),
  getBlockSelectors: () => (getBlockSelectors),
  getGlobalStylesChanges: () => (getGlobalStylesChanges),
  getLayoutStyles: () => (getLayoutStyles),
  toStyles: () => (toStyles),
  useGlobalSetting: () => (useGlobalSetting),
  useGlobalStyle: () => (useGlobalStyle),
  useGlobalStyleLinks: () => (useGlobalStyleLinks),
  useGlobalStylesOutput: () => (useGlobalStylesOutput),
  useGlobalStylesOutputWithConfig: () => (useGlobalStylesOutputWithConfig),
  useGlobalStylesReset: () => (useGlobalStylesReset),
  useHasBackgroundPanel: () => (useHasBackgroundPanel),
  useHasBorderPanel: () => (useHasBorderPanel),
  useHasBorderPanelControls: () => (useHasBorderPanelControls),
  useHasColorPanel: () => (useHasColorPanel),
  useHasDimensionsPanel: () => (useHasDimensionsPanel),
  useHasFiltersPanel: () => (useHasFiltersPanel),
  useHasImageSettingsPanel: () => (useHasImageSettingsPanel),
  useHasTypographyPanel: () => (useHasTypographyPanel),
  useSettingsForBlockElement: () => (useSettingsForBlockElement)
});

;// CONCATENATED MODULE: external ["wp","blocks"]
const external_wp_blocks_namespaceObject = window["wp"]["blocks"];
;// CONCATENATED MODULE: external ["wp","element"]
const external_wp_element_namespaceObject = window["wp"]["element"];
;// CONCATENATED MODULE: external ["wp","data"]
const external_wp_data_namespaceObject = window["wp"]["data"];
;// CONCATENATED MODULE: external ["wp","compose"]
const external_wp_compose_namespaceObject = window["wp"]["compose"];
;// CONCATENATED MODULE: external ["wp","hooks"]
const external_wp_hooks_namespaceObject = window["wp"]["hooks"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-edit/context.js
/**
 * WordPress dependencies
 */

const mayDisplayControlsKey = Symbol('mayDisplayControls');
const mayDisplayParentControlsKey = Symbol('mayDisplayParentControls');
const blockEditingModeKey = Symbol('blockEditingMode');
const blockBindingsKey = Symbol('blockBindings');
const isPreviewModeKey = Symbol('isPreviewMode');
const DEFAULT_BLOCK_EDIT_CONTEXT = {
  name: '',
  isSelected: false
};
const Context = (0,external_wp_element_namespaceObject.createContext)(DEFAULT_BLOCK_EDIT_CONTEXT);
const {
  Provider
} = Context;


/**
 * A hook that returns the block edit context.
 *
 * @return {Object} Block edit context
 */
function useBlockEditContext() {
  return (0,external_wp_element_namespaceObject.useContext)(Context);
}

;// CONCATENATED MODULE: external ["wp","deprecated"]
const external_wp_deprecated_namespaceObject = window["wp"]["deprecated"];
var external_wp_deprecated_default = /*#__PURE__*/__webpack_require__.n(external_wp_deprecated_namespaceObject);
// EXTERNAL MODULE: ./node_modules/fast-deep-equal/es6/index.js
var es6 = __webpack_require__(7734);
var es6_default = /*#__PURE__*/__webpack_require__.n(es6);
;// CONCATENATED MODULE: external ["wp","i18n"]
const external_wp_i18n_namespaceObject = window["wp"]["i18n"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/defaults.js
/**
 * WordPress dependencies
 */

const PREFERENCES_DEFAULTS = {
  insertUsage: {}
};

/**
 * The default editor settings
 *
 * @typedef {Object} SETTINGS_DEFAULT
 * @property {boolean}       alignWide                              Enable/Disable Wide/Full Alignments
 * @property {boolean}       supportsLayout                         Enable/disable layouts support in container blocks.
 * @property {boolean}       imageEditing                           Image Editing settings set to false to disable.
 * @property {Array}         imageSizes                             Available image sizes
 * @property {number}        maxWidth                               Max width to constraint resizing
 * @property {boolean|Array} allowedBlockTypes                      Allowed block types
 * @property {boolean}       hasFixedToolbar                        Whether or not the editor toolbar is fixed
 * @property {boolean}       distractionFree                        Whether or not the editor UI is distraction free
 * @property {boolean}       focusMode                              Whether the focus mode is enabled or not
 * @property {Array}         styles                                 Editor Styles
 * @property {boolean}       keepCaretInsideBlock                   Whether caret should move between blocks in edit mode
 * @property {string}        bodyPlaceholder                        Empty post placeholder
 * @property {string}        titlePlaceholder                       Empty title placeholder
 * @property {boolean}       canLockBlocks                          Whether the user can manage Block Lock state
 * @property {boolean}       codeEditingEnabled                     Whether or not the user can switch to the code editor
 * @property {boolean}       generateAnchors                        Enable/Disable auto anchor generation for Heading blocks
 * @property {boolean}       enableOpenverseMediaCategory           Enable/Disable the Openverse media category in the inserter.
 * @property {boolean}       clearBlockSelection                    Whether the block editor should clear selection on mousedown when a block is not clicked.
 * @property {boolean}       __experimentalCanUserUseUnfilteredHTML Whether the user should be able to use unfiltered HTML or the HTML should be filtered e.g., to remove elements considered insecure like iframes.
 * @property {boolean}       __experimentalBlockDirectory           Whether the user has enabled the Block Directory
 * @property {Array}         __experimentalBlockPatterns            Array of objects representing the block patterns
 * @property {Array}         __experimentalBlockPatternCategories   Array of objects representing the block pattern categories
 * @property {boolean}       __unstableGalleryWithImageBlocks       Whether the user has enabled the refactored gallery block which uses InnerBlocks
 */
const SETTINGS_DEFAULTS = {
  alignWide: false,
  supportsLayout: true,
  // colors setting is not used anymore now defaults are passed from theme.json on the server and core has its own defaults.
  // The setting is only kept for backward compatibility purposes.
  colors: [{
    name: (0,external_wp_i18n_namespaceObject.__)('Black'),
    slug: 'black',
    color: '#000000'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Cyan bluish gray'),
    slug: 'cyan-bluish-gray',
    color: '#abb8c3'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('White'),
    slug: 'white',
    color: '#ffffff'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Pale pink'),
    slug: 'pale-pink',
    color: '#f78da7'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Vivid red'),
    slug: 'vivid-red',
    color: '#cf2e2e'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Luminous vivid orange'),
    slug: 'luminous-vivid-orange',
    color: '#ff6900'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Luminous vivid amber'),
    slug: 'luminous-vivid-amber',
    color: '#fcb900'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Light green cyan'),
    slug: 'light-green-cyan',
    color: '#7bdcb5'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Vivid green cyan'),
    slug: 'vivid-green-cyan',
    color: '#00d084'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Pale cyan blue'),
    slug: 'pale-cyan-blue',
    color: '#8ed1fc'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Vivid cyan blue'),
    slug: 'vivid-cyan-blue',
    color: '#0693e3'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Vivid purple'),
    slug: 'vivid-purple',
    color: '#9b51e0'
  }],
  // fontSizes setting is not used anymore now defaults are passed from theme.json on the server and core has its own defaults.
  // The setting is only kept for backward compatibility purposes.
  fontSizes: [{
    name: (0,external_wp_i18n_namespaceObject._x)('Small', 'font size name'),
    size: 13,
    slug: 'small'
  }, {
    name: (0,external_wp_i18n_namespaceObject._x)('Normal', 'font size name'),
    size: 16,
    slug: 'normal'
  }, {
    name: (0,external_wp_i18n_namespaceObject._x)('Medium', 'font size name'),
    size: 20,
    slug: 'medium'
  }, {
    name: (0,external_wp_i18n_namespaceObject._x)('Large', 'font size name'),
    size: 36,
    slug: 'large'
  }, {
    name: (0,external_wp_i18n_namespaceObject._x)('Huge', 'font size name'),
    size: 42,
    slug: 'huge'
  }],
  // Image default size slug.
  imageDefaultSize: 'large',
  imageSizes: [{
    slug: 'thumbnail',
    name: (0,external_wp_i18n_namespaceObject.__)('Thumbnail')
  }, {
    slug: 'medium',
    name: (0,external_wp_i18n_namespaceObject.__)('Medium')
  }, {
    slug: 'large',
    name: (0,external_wp_i18n_namespaceObject.__)('Large')
  }, {
    slug: 'full',
    name: (0,external_wp_i18n_namespaceObject.__)('Full Size')
  }],
  // Allow plugin to disable Image Editor if need be.
  imageEditing: true,
  // This is current max width of the block inner area
  // It's used to constraint image resizing and this value could be overridden later by themes
  maxWidth: 580,
  // Allowed block types for the editor, defaulting to true (all supported).
  allowedBlockTypes: true,
  // Maximum upload size in bytes allowed for the site.
  maxUploadFileSize: 0,
  // List of allowed mime types and file extensions.
  allowedMimeTypes: null,
  // Allows to disable block locking interface.
  canLockBlocks: true,
  // Allows to disable Openverse media category in the inserter.
  enableOpenverseMediaCategory: true,
  clearBlockSelection: true,
  __experimentalCanUserUseUnfilteredHTML: false,
  __experimentalBlockDirectory: false,
  __mobileEnablePageTemplates: false,
  __experimentalBlockPatterns: [],
  __experimentalBlockPatternCategories: [],
  __unstableGalleryWithImageBlocks: false,
  __unstableIsPreviewMode: false,
  // These settings will be completely revamped in the future.
  // The goal is to evolve this into an API which will instruct
  // the block inspector to animate transitions between what it
  // displays based on the relationship between the selected block
  // and its parent, and only enable it if the parent is controlling
  // its children blocks.
  blockInspectorAnimation: {
    animationParent: 'core/navigation',
    'core/navigation': {
      enterDirection: 'leftToRight'
    },
    'core/navigation-submenu': {
      enterDirection: 'rightToLeft'
    },
    'core/navigation-link': {
      enterDirection: 'rightToLeft'
    },
    'core/search': {
      enterDirection: 'rightToLeft'
    },
    'core/social-links': {
      enterDirection: 'rightToLeft'
    },
    'core/page-list': {
      enterDirection: 'rightToLeft'
    },
    'core/spacer': {
      enterDirection: 'rightToLeft'
    },
    'core/home-link': {
      enterDirection: 'rightToLeft'
    },
    'core/site-title': {
      enterDirection: 'rightToLeft'
    },
    'core/site-logo': {
      enterDirection: 'rightToLeft'
    }
  },
  generateAnchors: false,
  // gradients setting is not used anymore now defaults are passed from theme.json on the server and core has its own defaults.
  // The setting is only kept for backward compatibility purposes.
  gradients: [{
    name: (0,external_wp_i18n_namespaceObject.__)('Vivid cyan blue to vivid purple'),
    gradient: 'linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)',
    slug: 'vivid-cyan-blue-to-vivid-purple'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Light green cyan to vivid green cyan'),
    gradient: 'linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%)',
    slug: 'light-green-cyan-to-vivid-green-cyan'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Luminous vivid amber to luminous vivid orange'),
    gradient: 'linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%)',
    slug: 'luminous-vivid-amber-to-luminous-vivid-orange'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Luminous vivid orange to vivid red'),
    gradient: 'linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%)',
    slug: 'luminous-vivid-orange-to-vivid-red'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Very light gray to cyan bluish gray'),
    gradient: 'linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%)',
    slug: 'very-light-gray-to-cyan-bluish-gray'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Cool to warm spectrum'),
    gradient: 'linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%)',
    slug: 'cool-to-warm-spectrum'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Blush light purple'),
    gradient: 'linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%)',
    slug: 'blush-light-purple'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Blush bordeaux'),
    gradient: 'linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%)',
    slug: 'blush-bordeaux'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Luminous dusk'),
    gradient: 'linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%)',
    slug: 'luminous-dusk'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Pale ocean'),
    gradient: 'linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%)',
    slug: 'pale-ocean'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Electric grass'),
    gradient: 'linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%)',
    slug: 'electric-grass'
  }, {
    name: (0,external_wp_i18n_namespaceObject.__)('Midnight'),
    gradient: 'linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%)',
    slug: 'midnight'
  }],
  __unstableResolvedAssets: {
    styles: [],
    scripts: []
  }
};

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/array.js
/**
 * Insert one or multiple elements into a given position of an array.
 *
 * @param {Array}  array    Source array.
 * @param {*}      elements Elements to insert.
 * @param {number} index    Insert Position.
 *
 * @return {Array} Result.
 */
function insertAt(array, elements, index) {
  return [...array.slice(0, index), ...(Array.isArray(elements) ? elements : [elements]), ...array.slice(index)];
}

/**
 * Moves an element in an array.
 *
 * @param {Array}  array Source array.
 * @param {number} from  Source index.
 * @param {number} to    Destination index.
 * @param {number} count Number of elements to move.
 *
 * @return {Array} Result.
 */
function moveTo(array, from, to, count = 1) {
  const withoutMovedElements = [...array];
  withoutMovedElements.splice(from, count);
  return insertAt(withoutMovedElements, array.slice(from, from + count), to);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/reducer.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


const identity = x => x;

/**
 * Given an array of blocks, returns an object where each key is a nesting
 * context, the value of which is an array of block client IDs existing within
 * that nesting context.
 *
 * @param {Array}   blocks       Blocks to map.
 * @param {?string} rootClientId Assumed root client ID.
 *
 * @return {Object} Block order map object.
 */
function mapBlockOrder(blocks, rootClientId = '') {
  const result = new Map();
  const current = [];
  result.set(rootClientId, current);
  blocks.forEach(block => {
    const {
      clientId,
      innerBlocks
    } = block;
    current.push(clientId);
    mapBlockOrder(innerBlocks, clientId).forEach((order, subClientId) => {
      result.set(subClientId, order);
    });
  });
  return result;
}

/**
 * Given an array of blocks, returns an object where each key contains
 * the clientId of the block and the value is the parent of the block.
 *
 * @param {Array}   blocks       Blocks to map.
 * @param {?string} rootClientId Assumed root client ID.
 *
 * @return {Object} Block order map object.
 */
function mapBlockParents(blocks, rootClientId = '') {
  const result = [];
  const stack = [[rootClientId, blocks]];
  while (stack.length) {
    const [parent, currentBlocks] = stack.shift();
    currentBlocks.forEach(({
      innerBlocks,
      ...block
    }) => {
      result.push([block.clientId, parent]);
      if (innerBlocks?.length) {
        stack.push([block.clientId, innerBlocks]);
      }
    });
  }
  return result;
}

/**
 * Helper method to iterate through all blocks, recursing into inner blocks,
 * applying a transformation function to each one.
 * Returns a flattened object with the transformed blocks.
 *
 * @param {Array}    blocks    Blocks to flatten.
 * @param {Function} transform Transforming function to be applied to each block.
 *
 * @return {Array} Flattened object.
 */
function flattenBlocks(blocks, transform = identity) {
  const result = [];
  const stack = [...blocks];
  while (stack.length) {
    const {
      innerBlocks,
      ...block
    } = stack.shift();
    stack.push(...innerBlocks);
    result.push([block.clientId, transform(block)]);
  }
  return result;
}
function getFlattenedClientIds(blocks) {
  const result = {};
  const stack = [...blocks];
  while (stack.length) {
    const {
      innerBlocks,
      ...block
    } = stack.shift();
    stack.push(...innerBlocks);
    result[block.clientId] = true;
  }
  return result;
}

/**
 * Given an array of blocks, returns an object containing all blocks, without
 * attributes, recursing into inner blocks. Keys correspond to the block client
 * ID, the value of which is the attributes object.
 *
 * @param {Array} blocks Blocks to flatten.
 *
 * @return {Array} Flattened block attributes object.
 */
function getFlattenedBlocksWithoutAttributes(blocks) {
  return flattenBlocks(blocks, block => {
    const {
      attributes,
      ...restBlock
    } = block;
    return restBlock;
  });
}

/**
 * Given an array of blocks, returns an object containing all block attributes,
 * recursing into inner blocks. Keys correspond to the block client ID, the
 * value of which is the attributes object.
 *
 * @param {Array} blocks Blocks to flatten.
 *
 * @return {Array} Flattened block attributes object.
 */
function getFlattenedBlockAttributes(blocks) {
  return flattenBlocks(blocks, block => block.attributes);
}

/**
 * Returns true if the two object arguments have the same keys, or false
 * otherwise.
 *
 * @param {Object} a First object.
 * @param {Object} b Second object.
 *
 * @return {boolean} Whether the two objects have the same keys.
 */
function hasSameKeys(a, b) {
  return es6_default()(Object.keys(a), Object.keys(b));
}

/**
 * Returns true if, given the currently dispatching action and the previously
 * dispatched action, the two actions are updating the same block attribute, or
 * false otherwise.
 *
 * @param {Object} action     Currently dispatching action.
 * @param {Object} lastAction Previously dispatched action.
 *
 * @return {boolean} Whether actions are updating the same block attribute.
 */
function isUpdatingSameBlockAttribute(action, lastAction) {
  return action.type === 'UPDATE_BLOCK_ATTRIBUTES' && lastAction !== undefined && lastAction.type === 'UPDATE_BLOCK_ATTRIBUTES' && es6_default()(action.clientIds, lastAction.clientIds) && hasSameKeys(action.attributes, lastAction.attributes);
}
function updateBlockTreeForBlocks(state, blocks) {
  const treeToUpdate = state.tree;
  const stack = [...blocks];
  const flattenedBlocks = [...blocks];
  while (stack.length) {
    const block = stack.shift();
    stack.push(...block.innerBlocks);
    flattenedBlocks.push(...block.innerBlocks);
  }
  // Create objects before mutating them, that way it's always defined.
  for (const block of flattenedBlocks) {
    treeToUpdate.set(block.clientId, {});
  }
  for (const block of flattenedBlocks) {
    treeToUpdate.set(block.clientId, Object.assign(treeToUpdate.get(block.clientId), {
      ...state.byClientId.get(block.clientId),
      attributes: state.attributes.get(block.clientId),
      innerBlocks: block.innerBlocks.map(subBlock => treeToUpdate.get(subBlock.clientId))
    }));
  }
}
function updateParentInnerBlocksInTree(state, updatedClientIds, updateChildrenOfUpdatedClientIds = false) {
  const treeToUpdate = state.tree;
  const uncontrolledParents = new Set([]);
  const controlledParents = new Set();
  for (const clientId of updatedClientIds) {
    let current = updateChildrenOfUpdatedClientIds ? clientId : state.parents.get(clientId);
    do {
      if (state.controlledInnerBlocks[current]) {
        // Should stop on controlled blocks.
        // If we reach a controlled parent, break out of the loop.
        controlledParents.add(current);
        break;
      } else {
        // Else continue traversing up through parents.
        uncontrolledParents.add(current);
        current = state.parents.get(current);
      }
    } while (current !== undefined);
  }

  // To make sure the order of assignments doesn't matter,
  // we first create empty objects and mutates the inner blocks later.
  for (const clientId of uncontrolledParents) {
    treeToUpdate.set(clientId, {
      ...treeToUpdate.get(clientId)
    });
  }
  for (const clientId of uncontrolledParents) {
    treeToUpdate.get(clientId).innerBlocks = (state.order.get(clientId) || []).map(subClientId => treeToUpdate.get(subClientId));
  }

  // Controlled parent blocks, need a dedicated key for their inner blocks
  // to be used when doing getBlocks( controlledBlockClientId ).
  for (const clientId of controlledParents) {
    treeToUpdate.set('controlled||' + clientId, {
      innerBlocks: (state.order.get(clientId) || []).map(subClientId => treeToUpdate.get(subClientId))
    });
  }
}

/**
 * Higher-order reducer intended to compute full block objects key for each block in the post.
 * This is a denormalization to optimize the performance of the getBlock selectors and avoid
 * recomputing the block objects and avoid heavy memoization.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */
const withBlockTree = reducer => (state = {}, action) => {
  const newState = reducer(state, action);
  if (newState === state) {
    return state;
  }
  newState.tree = state.tree ? state.tree : new Map();
  switch (action.type) {
    case 'RECEIVE_BLOCKS':
    case 'INSERT_BLOCKS':
      {
        newState.tree = new Map(newState.tree);
        updateBlockTreeForBlocks(newState, action.blocks);
        updateParentInnerBlocksInTree(newState, action.rootClientId ? [action.rootClientId] : [''], true);
        break;
      }
    case 'UPDATE_BLOCK':
      newState.tree = new Map(newState.tree);
      newState.tree.set(action.clientId, {
        ...newState.tree.get(action.clientId),
        ...newState.byClientId.get(action.clientId),
        attributes: newState.attributes.get(action.clientId)
      });
      updateParentInnerBlocksInTree(newState, [action.clientId], false);
      break;
    case 'SYNC_DERIVED_BLOCK_ATTRIBUTES':
    case 'UPDATE_BLOCK_ATTRIBUTES':
      {
        newState.tree = new Map(newState.tree);
        action.clientIds.forEach(clientId => {
          newState.tree.set(clientId, {
            ...newState.tree.get(clientId),
            attributes: newState.attributes.get(clientId)
          });
        });
        updateParentInnerBlocksInTree(newState, action.clientIds, false);
        break;
      }
    case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
      {
        const inserterClientIds = getFlattenedClientIds(action.blocks);
        newState.tree = new Map(newState.tree);
        action.replacedClientIds.forEach(clientId => {
          newState.tree.delete(clientId);
          // Controlled inner blocks are only removed
          // if the block doesn't move to another position
          // otherwise their content will be lost.
          if (!inserterClientIds[clientId]) {
            newState.tree.delete('controlled||' + clientId);
          }
        });
        updateBlockTreeForBlocks(newState, action.blocks);
        updateParentInnerBlocksInTree(newState, action.blocks.map(b => b.clientId), false);

        // If there are no replaced blocks, it means we're removing blocks so we need to update their parent.
        const parentsOfRemovedBlocks = [];
        for (const clientId of action.clientIds) {
          const parentId = state.parents.get(clientId);
          if (parentId !== undefined && (parentId === '' || newState.byClientId.get(parentId))) {
            parentsOfRemovedBlocks.push(parentId);
          }
        }
        updateParentInnerBlocksInTree(newState, parentsOfRemovedBlocks, true);
        break;
      }
    case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
      const parentsOfRemovedBlocks = [];
      for (const clientId of action.clientIds) {
        const parentId = state.parents.get(clientId);
        if (parentId !== undefined && (parentId === '' || newState.byClientId.get(parentId))) {
          parentsOfRemovedBlocks.push(parentId);
        }
      }
      newState.tree = new Map(newState.tree);
      action.removedClientIds.forEach(clientId => {
        newState.tree.delete(clientId);
        newState.tree.delete('controlled||' + clientId);
      });
      updateParentInnerBlocksInTree(newState, parentsOfRemovedBlocks, true);
      break;
    case 'MOVE_BLOCKS_TO_POSITION':
      {
        const updatedBlockUids = [];
        if (action.fromRootClientId) {
          updatedBlockUids.push(action.fromRootClientId);
        } else {
          updatedBlockUids.push('');
        }
        if (action.toRootClientId) {
          updatedBlockUids.push(action.toRootClientId);
        }
        newState.tree = new Map(newState.tree);
        updateParentInnerBlocksInTree(newState, updatedBlockUids, true);
        break;
      }
    case 'MOVE_BLOCKS_UP':
    case 'MOVE_BLOCKS_DOWN':
      {
        const updatedBlockUids = [action.rootClientId ? action.rootClientId : ''];
        newState.tree = new Map(newState.tree);
        updateParentInnerBlocksInTree(newState, updatedBlockUids, true);
        break;
      }
    case 'SAVE_REUSABLE_BLOCK_SUCCESS':
      {
        const updatedBlockUids = [];
        newState.attributes.forEach((attributes, clientId) => {
          if (newState.byClientId.get(clientId).name === 'core/block' && attributes.ref === action.updatedId) {
            updatedBlockUids.push(clientId);
          }
        });
        newState.tree = new Map(newState.tree);
        updatedBlockUids.forEach(clientId => {
          newState.tree.set(clientId, {
            ...newState.byClientId.get(clientId),
            attributes: newState.attributes.get(clientId),
            innerBlocks: newState.tree.get(clientId).innerBlocks
          });
        });
        updateParentInnerBlocksInTree(newState, updatedBlockUids, false);
      }
  }
  return newState;
};

/**
 * Higher-order reducer intended to augment the blocks reducer, assigning an
 * `isPersistentChange` property value corresponding to whether a change in
 * state can be considered as persistent. All changes are considered persistent
 * except when updating the same block attribute as in the previous action.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */
function withPersistentBlockChange(reducer) {
  let lastAction;
  let markNextChangeAsNotPersistent = false;
  let explicitPersistent;
  return (state, action) => {
    let nextState = reducer(state, action);
    let nextIsPersistentChange;
    if (action.type === 'SET_EXPLICIT_PERSISTENT') {
      var _state$isPersistentCh;
      explicitPersistent = action.isPersistentChange;
      nextIsPersistentChange = (_state$isPersistentCh = state.isPersistentChange) !== null && _state$isPersistentCh !== void 0 ? _state$isPersistentCh : true;
    }
    if (explicitPersistent !== undefined) {
      nextIsPersistentChange = explicitPersistent;
      return nextIsPersistentChange === nextState.isPersistentChange ? nextState : {
        ...nextState,
        isPersistentChange: nextIsPersistentChange
      };
    }
    const isExplicitPersistentChange = action.type === 'MARK_LAST_CHANGE_AS_PERSISTENT' || markNextChangeAsNotPersistent;

    // Defer to previous state value (or default) unless changing or
    // explicitly marking as persistent.
    if (state === nextState && !isExplicitPersistentChange) {
      var _state$isPersistentCh2;
      markNextChangeAsNotPersistent = action.type === 'MARK_NEXT_CHANGE_AS_NOT_PERSISTENT';
      nextIsPersistentChange = (_state$isPersistentCh2 = state?.isPersistentChange) !== null && _state$isPersistentCh2 !== void 0 ? _state$isPersistentCh2 : true;
      if (state.isPersistentChange === nextIsPersistentChange) {
        return state;
      }
      return {
        ...nextState,
        isPersistentChange: nextIsPersistentChange
      };
    }
    nextState = {
      ...nextState,
      isPersistentChange: isExplicitPersistentChange ? !markNextChangeAsNotPersistent : !isUpdatingSameBlockAttribute(action, lastAction)
    };

    // In comparing against the previous action, consider only those which
    // would have qualified as one which would have been ignored or not
    // have resulted in a changed state.
    lastAction = action;
    markNextChangeAsNotPersistent = action.type === 'MARK_NEXT_CHANGE_AS_NOT_PERSISTENT';
    return nextState;
  };
}

/**
 * Higher-order reducer intended to augment the blocks reducer, assigning an
 * `isIgnoredChange` property value corresponding to whether a change in state
 * can be considered as ignored. A change is considered ignored when the result
 * of an action not incurred by direct user interaction.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */
function withIgnoredBlockChange(reducer) {
  /**
   * Set of action types for which a blocks state change should be ignored.
   *
   * @type {Set}
   */
  const IGNORED_ACTION_TYPES = new Set(['RECEIVE_BLOCKS']);
  return (state, action) => {
    const nextState = reducer(state, action);
    if (nextState !== state) {
      nextState.isIgnoredChange = IGNORED_ACTION_TYPES.has(action.type);
    }
    return nextState;
  };
}

/**
 * Higher-order reducer targeting the combined blocks reducer, augmenting
 * block client IDs in remove action to include cascade of inner blocks.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */
const withInnerBlocksRemoveCascade = reducer => (state, action) => {
  // Gets all children which need to be removed.
  const getAllChildren = clientIds => {
    let result = clientIds;
    for (let i = 0; i < result.length; i++) {
      if (!state.order.get(result[i]) || action.keepControlledInnerBlocks && action.keepControlledInnerBlocks[result[i]]) {
        continue;
      }
      if (result === clientIds) {
        result = [...result];
      }
      result.push(...state.order.get(result[i]));
    }
    return result;
  };
  if (state) {
    switch (action.type) {
      case 'REMOVE_BLOCKS':
        action = {
          ...action,
          type: 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN',
          removedClientIds: getAllChildren(action.clientIds)
        };
        break;
      case 'REPLACE_BLOCKS':
        action = {
          ...action,
          type: 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN',
          replacedClientIds: getAllChildren(action.clientIds)
        };
        break;
    }
  }
  return reducer(state, action);
};

/**
 * Higher-order reducer which targets the combined blocks reducer and handles
 * the `RESET_BLOCKS` action. When dispatched, this action will replace all
 * blocks that exist in the post, leaving blocks that exist only in state (e.g.
 * reusable blocks and blocks controlled by inner blocks controllers) alone.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */
const withBlockReset = reducer => (state, action) => {
  if (action.type === 'RESET_BLOCKS') {
    const newState = {
      ...state,
      byClientId: new Map(getFlattenedBlocksWithoutAttributes(action.blocks)),
      attributes: new Map(getFlattenedBlockAttributes(action.blocks)),
      order: mapBlockOrder(action.blocks),
      parents: new Map(mapBlockParents(action.blocks)),
      controlledInnerBlocks: {}
    };
    newState.tree = new Map(state?.tree);
    updateBlockTreeForBlocks(newState, action.blocks);
    newState.tree.set('', {
      innerBlocks: action.blocks.map(subBlock => newState.tree.get(subBlock.clientId))
    });
    return newState;
  }
  return reducer(state, action);
};

/**
 * Higher-order reducer which targets the combined blocks reducer and handles
 * the `REPLACE_INNER_BLOCKS` action. When dispatched, this action the state
 * should become equivalent to the execution of a `REMOVE_BLOCKS` action
 * containing all the child's of the root block followed by the execution of
 * `INSERT_BLOCKS` with the new blocks.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */
const withReplaceInnerBlocks = reducer => (state, action) => {
  if (action.type !== 'REPLACE_INNER_BLOCKS') {
    return reducer(state, action);
  }

  // Finds every nested inner block controller. We must check the action blocks
  // and not just the block parent state because some inner block controllers
  // should be deleted if specified, whereas others should not be deleted. If
  // a controlled should not be deleted, then we need to avoid deleting its
  // inner blocks from the block state because its inner blocks will not be
  // attached to the block in the action.
  const nestedControllers = {};
  if (Object.keys(state.controlledInnerBlocks).length) {
    const stack = [...action.blocks];
    while (stack.length) {
      const {
        innerBlocks,
        ...block
      } = stack.shift();
      stack.push(...innerBlocks);
      if (!!state.controlledInnerBlocks[block.clientId]) {
        nestedControllers[block.clientId] = true;
      }
    }
  }

  // The `keepControlledInnerBlocks` prop will keep the inner blocks of the
  // marked block in the block state so that they can be reattached to the
  // marked block when we re-insert everything a few lines below.
  let stateAfterBlocksRemoval = state;
  if (state.order.get(action.rootClientId)) {
    stateAfterBlocksRemoval = reducer(stateAfterBlocksRemoval, {
      type: 'REMOVE_BLOCKS',
      keepControlledInnerBlocks: nestedControllers,
      clientIds: state.order.get(action.rootClientId)
    });
  }
  let stateAfterInsert = stateAfterBlocksRemoval;
  if (action.blocks.length) {
    stateAfterInsert = reducer(stateAfterInsert, {
      ...action,
      type: 'INSERT_BLOCKS',
      index: 0
    });

    // We need to re-attach the controlled inner blocks to the blocks tree and
    // preserve their block order. Otherwise, an inner block controller's blocks
    // will be deleted entirely from its entity.
    const stateAfterInsertOrder = new Map(stateAfterInsert.order);
    Object.keys(nestedControllers).forEach(key => {
      if (state.order.get(key)) {
        stateAfterInsertOrder.set(key, state.order.get(key));
      }
    });
    stateAfterInsert.order = stateAfterInsertOrder;
    stateAfterInsert.tree = new Map(stateAfterInsert.tree);
    Object.keys(nestedControllers).forEach(_key => {
      const key = `controlled||${_key}`;
      if (state.tree.has(key)) {
        stateAfterInsert.tree.set(key, state.tree.get(key));
      }
    });
  }
  return stateAfterInsert;
};

/**
 * Higher-order reducer which targets the combined blocks reducer and handles
 * the `SAVE_REUSABLE_BLOCK_SUCCESS` action. This action can't be handled by
 * regular reducers and needs a higher-order reducer since it needs access to
 * both `byClientId` and `attributes` simultaneously.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */
const withSaveReusableBlock = reducer => (state, action) => {
  if (state && action.type === 'SAVE_REUSABLE_BLOCK_SUCCESS') {
    const {
      id,
      updatedId
    } = action;

    // If a temporary reusable block is saved, we swap the temporary id with the final one.
    if (id === updatedId) {
      return state;
    }
    state = {
      ...state
    };
    state.attributes = new Map(state.attributes);
    state.attributes.forEach((attributes, clientId) => {
      const {
        name
      } = state.byClientId.get(clientId);
      if (name === 'core/block' && attributes.ref === id) {
        state.attributes.set(clientId, {
          ...attributes,
          ref: updatedId
        });
      }
    });
  }
  return reducer(state, action);
};
/**
 * Higher-order reducer which removes blocks from state when switching parent block controlled state.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */
const withResetControlledBlocks = reducer => (state, action) => {
  if (action.type === 'SET_HAS_CONTROLLED_INNER_BLOCKS') {
    // when switching a block from controlled to uncontrolled or inverse,
    // we need to remove its content first.
    const tempState = reducer(state, {
      type: 'REPLACE_INNER_BLOCKS',
      rootClientId: action.clientId,
      blocks: []
    });
    return reducer(tempState, action);
  }
  return reducer(state, action);
};

/**
 * Reducer returning the blocks state.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */
const blocks = (0,external_wp_compose_namespaceObject.pipe)(external_wp_data_namespaceObject.combineReducers, withSaveReusableBlock,
// Needs to be before withBlockCache.
withBlockTree,
// Needs to be before withInnerBlocksRemoveCascade.
withInnerBlocksRemoveCascade, withReplaceInnerBlocks,
// Needs to be after withInnerBlocksRemoveCascade.
withBlockReset, withPersistentBlockChange, withIgnoredBlockChange, withResetControlledBlocks)({
  // The state is using a Map instead of a plain object for performance reasons.
  // You can run the "./test/performance.js" unit test to check the impact
  // code changes can have on this reducer.
  byClientId(state = new Map(), action) {
    switch (action.type) {
      case 'RECEIVE_BLOCKS':
      case 'INSERT_BLOCKS':
        {
          const newState = new Map(state);
          getFlattenedBlocksWithoutAttributes(action.blocks).forEach(([key, value]) => {
            newState.set(key, value);
          });
          return newState;
        }
      case 'UPDATE_BLOCK':
        {
          // Ignore updates if block isn't known.
          if (!state.has(action.clientId)) {
            return state;
          }

          // Do nothing if only attributes change.
          const {
            attributes,
            ...changes
          } = action.updates;
          if (Object.values(changes).length === 0) {
            return state;
          }
          const newState = new Map(state);
          newState.set(action.clientId, {
            ...state.get(action.clientId),
            ...changes
          });
          return newState;
        }
      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          if (!action.blocks) {
            return state;
          }
          const newState = new Map(state);
          action.replacedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          getFlattenedBlocksWithoutAttributes(action.blocks).forEach(([key, value]) => {
            newState.set(key, value);
          });
          return newState;
        }
      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          const newState = new Map(state);
          action.removedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          return newState;
        }
    }
    return state;
  },
  // The state is using a Map instead of a plain object for performance reasons.
  // You can run the "./test/performance.js" unit test to check the impact
  // code changes can have on this reducer.
  attributes(state = new Map(), action) {
    switch (action.type) {
      case 'RECEIVE_BLOCKS':
      case 'INSERT_BLOCKS':
        {
          const newState = new Map(state);
          getFlattenedBlockAttributes(action.blocks).forEach(([key, value]) => {
            newState.set(key, value);
          });
          return newState;
        }
      case 'UPDATE_BLOCK':
        {
          // Ignore updates if block isn't known or there are no attribute changes.
          if (!state.get(action.clientId) || !action.updates.attributes) {
            return state;
          }
          const newState = new Map(state);
          newState.set(action.clientId, {
            ...state.get(action.clientId),
            ...action.updates.attributes
          });
          return newState;
        }
      case 'SYNC_DERIVED_BLOCK_ATTRIBUTES':
      case 'UPDATE_BLOCK_ATTRIBUTES':
        {
          // Avoid a state change if none of the block IDs are known.
          if (action.clientIds.every(id => !state.get(id))) {
            return state;
          }
          let hasChange = false;
          const newState = new Map(state);
          for (const clientId of action.clientIds) {
            var _action$attributes;
            const updatedAttributeEntries = Object.entries(action.uniqueByBlock ? action.attributes[clientId] : (_action$attributes = action.attributes) !== null && _action$attributes !== void 0 ? _action$attributes : {});
            if (updatedAttributeEntries.length === 0) {
              continue;
            }
            let hasUpdatedAttributes = false;
            const existingAttributes = state.get(clientId);
            const newAttributes = {};
            updatedAttributeEntries.forEach(([key, value]) => {
              if (existingAttributes[key] !== value) {
                hasUpdatedAttributes = true;
                newAttributes[key] = value;
              }
            });
            hasChange = hasChange || hasUpdatedAttributes;
            if (hasUpdatedAttributes) {
              newState.set(clientId, {
                ...existingAttributes,
                ...newAttributes
              });
            }
          }
          return hasChange ? newState : state;
        }
      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          if (!action.blocks) {
            return state;
          }
          const newState = new Map(state);
          action.replacedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          getFlattenedBlockAttributes(action.blocks).forEach(([key, value]) => {
            newState.set(key, value);
          });
          return newState;
        }
      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          const newState = new Map(state);
          action.removedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          return newState;
        }
    }
    return state;
  },
  // The state is using a Map instead of a plain object for performance reasons.
  // You can run the "./test/performance.js" unit test to check the impact
  // code changes can have on this reducer.
  order(state = new Map(), action) {
    switch (action.type) {
      case 'RECEIVE_BLOCKS':
        {
          var _state$get;
          const blockOrder = mapBlockOrder(action.blocks);
          const newState = new Map(state);
          blockOrder.forEach((order, clientId) => {
            if (clientId !== '') {
              newState.set(clientId, order);
            }
          });
          newState.set('', ((_state$get = state.get('')) !== null && _state$get !== void 0 ? _state$get : []).concat(blockOrder['']));
          return newState;
        }
      case 'INSERT_BLOCKS':
        {
          const {
            rootClientId = ''
          } = action;
          const subState = state.get(rootClientId) || [];
          const mappedBlocks = mapBlockOrder(action.blocks, rootClientId);
          const {
            index = subState.length
          } = action;
          const newState = new Map(state);
          mappedBlocks.forEach((order, clientId) => {
            newState.set(clientId, order);
          });
          newState.set(rootClientId, insertAt(subState, mappedBlocks.get(rootClientId), index));
          return newState;
        }
      case 'MOVE_BLOCKS_TO_POSITION':
        {
          var _state$get$filter;
          const {
            fromRootClientId = '',
            toRootClientId = '',
            clientIds
          } = action;
          const {
            index = state.get(toRootClientId).length
          } = action;

          // Moving inside the same parent block.
          if (fromRootClientId === toRootClientId) {
            const subState = state.get(toRootClientId);
            const fromIndex = subState.indexOf(clientIds[0]);
            const newState = new Map(state);
            newState.set(toRootClientId, moveTo(state.get(toRootClientId), fromIndex, index, clientIds.length));
            return newState;
          }

          // Moving from a parent block to another.
          const newState = new Map(state);
          newState.set(fromRootClientId, (_state$get$filter = state.get(fromRootClientId)?.filter(id => !clientIds.includes(id))) !== null && _state$get$filter !== void 0 ? _state$get$filter : []);
          newState.set(toRootClientId, insertAt(state.get(toRootClientId), clientIds, index));
          return newState;
        }
      case 'MOVE_BLOCKS_UP':
        {
          const {
            clientIds,
            rootClientId = ''
          } = action;
          const firstClientId = clientIds[0];
          const subState = state.get(rootClientId);
          if (!subState.length || firstClientId === subState[0]) {
            return state;
          }
          const firstIndex = subState.indexOf(firstClientId);
          const newState = new Map(state);
          newState.set(rootClientId, moveTo(subState, firstIndex, firstIndex - 1, clientIds.length));
          return newState;
        }
      case 'MOVE_BLOCKS_DOWN':
        {
          const {
            clientIds,
            rootClientId = ''
          } = action;
          const firstClientId = clientIds[0];
          const lastClientId = clientIds[clientIds.length - 1];
          const subState = state.get(rootClientId);
          if (!subState.length || lastClientId === subState[subState.length - 1]) {
            return state;
          }
          const firstIndex = subState.indexOf(firstClientId);
          const newState = new Map(state);
          newState.set(rootClientId, moveTo(subState, firstIndex, firstIndex + 1, clientIds.length));
          return newState;
        }
      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          const {
            clientIds
          } = action;
          if (!action.blocks) {
            return state;
          }
          const mappedBlocks = mapBlockOrder(action.blocks);
          const newState = new Map(state);
          action.replacedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          mappedBlocks.forEach((order, clientId) => {
            if (clientId !== '') {
              newState.set(clientId, order);
            }
          });
          newState.forEach((order, clientId) => {
            const newSubOrder = Object.values(order).reduce((result, subClientId) => {
              if (subClientId === clientIds[0]) {
                return [...result, ...mappedBlocks.get('')];
              }
              if (clientIds.indexOf(subClientId) === -1) {
                result.push(subClientId);
              }
              return result;
            }, []);
            newState.set(clientId, newSubOrder);
          });
          return newState;
        }
      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          const newState = new Map(state);
          // Remove inner block ordering for removed blocks.
          action.removedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          newState.forEach((order, clientId) => {
            var _order$filter;
            const newSubOrder = (_order$filter = order?.filter(id => !action.removedClientIds.includes(id))) !== null && _order$filter !== void 0 ? _order$filter : [];
            if (newSubOrder.length !== order.length) {
              newState.set(clientId, newSubOrder);
            }
          });
          return newState;
        }
    }
    return state;
  },
  // While technically redundant data as the inverse of `order`, it serves as
  // an optimization for the selectors which derive the ancestry of a block.
  parents(state = new Map(), action) {
    switch (action.type) {
      case 'RECEIVE_BLOCKS':
        {
          const newState = new Map(state);
          mapBlockParents(action.blocks).forEach(([key, value]) => {
            newState.set(key, value);
          });
          return newState;
        }
      case 'INSERT_BLOCKS':
        {
          const newState = new Map(state);
          mapBlockParents(action.blocks, action.rootClientId || '').forEach(([key, value]) => {
            newState.set(key, value);
          });
          return newState;
        }
      case 'MOVE_BLOCKS_TO_POSITION':
        {
          const newState = new Map(state);
          action.clientIds.forEach(id => {
            newState.set(id, action.toRootClientId || '');
          });
          return newState;
        }
      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          const newState = new Map(state);
          action.replacedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          mapBlockParents(action.blocks, state.get(action.clientIds[0])).forEach(([key, value]) => {
            newState.set(key, value);
          });
          return newState;
        }
      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          const newState = new Map(state);
          action.removedClientIds.forEach(clientId => {
            newState.delete(clientId);
          });
          return newState;
        }
    }
    return state;
  },
  controlledInnerBlocks(state = {}, {
    type,
    clientId,
    hasControlledInnerBlocks
  }) {
    if (type === 'SET_HAS_CONTROLLED_INNER_BLOCKS') {
      return {
        ...state,
        [clientId]: hasControlledInnerBlocks
      };
    }
    return state;
  }
});

/**
 * Reducer returning visibility status of block interface.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */
function isBlockInterfaceHidden(state = false, action) {
  switch (action.type) {
    case 'HIDE_BLOCK_INTERFACE':
      return true;
    case 'SHOW_BLOCK_INTERFACE':
      return false;
  }
  return state;
}

/**
 * Reducer returning typing state.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */
function isTyping(state = false, action) {
  switch (action.type) {
    case 'START_TYPING':
      return true;
    case 'STOP_TYPING':
      return false;
  }
  return state;
}

/**
 * Reducer returning dragging state. It is possible for a user to be dragging
 * data from outside of the editor, so this state is separate from `draggedBlocks`.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */
function isDragging(state = false, action) {
  switch (action.type) {
    case 'START_DRAGGING':
      return true;
    case 'STOP_DRAGGING':
      return false;
  }
  return state;
}

/**
 * Reducer returning dragged block client id.
 *
 * @param {string[]} state  Current state.
 * @param {Object}   action Dispatched action.
 *
 * @return {string[]} Updated state.
 */
function draggedBlocks(state = [], action) {
  switch (action.type) {
    case 'START_DRAGGING_BLOCKS':
      return action.clientIds;
    case 'STOP_DRAGGING_BLOCKS':
      return [];
  }
  return state;
}

/**
 * Reducer tracking the visible blocks.
 *
 * @param {Record<string,boolean>} state  Current state.
 * @param {Object}                 action Dispatched action.
 *
 * @return {Record<string,boolean>} Block visibility.
 */
function blockVisibility(state = {}, action) {
  if (action.type === 'SET_BLOCK_VISIBILITY') {
    return {
      ...state,
      ...action.updates
    };
  }
  return state;
}

/**
 * Internal helper reducer for selectionStart and selectionEnd. Can hold a block
 * selection, represented by an object with property clientId.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */
function selectionHelper(state = {}, action) {
  switch (action.type) {
    case 'CLEAR_SELECTED_BLOCK':
      {
        if (state.clientId) {
          return {};
        }
        return state;
      }
    case 'SELECT_BLOCK':
      if (action.clientId === state.clientId) {
        return state;
      }
      return {
        clientId: action.clientId
      };
    case 'REPLACE_INNER_BLOCKS':
    case 'INSERT_BLOCKS':
      {
        if (!action.updateSelection || !action.blocks.length) {
          return state;
        }
        return {
          clientId: action.blocks[0].clientId
        };
      }
    case 'REMOVE_BLOCKS':
      if (!action.clientIds || !action.clientIds.length || action.clientIds.indexOf(state.clientId) === -1) {
        return state;
      }
      return {};
    case 'REPLACE_BLOCKS':
      {
        if (action.clientIds.indexOf(state.clientId) === -1) {
          return state;
        }
        const blockToSelect = action.blocks[action.indexToSelect] || action.blocks[action.blocks.length - 1];
        if (!blockToSelect) {
          return {};
        }
        if (blockToSelect.clientId === state.clientId) {
          return state;
        }
        return {
          clientId: blockToSelect.clientId
        };
      }
  }
  return state;
}

/**
 * Reducer returning the selection state.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */
function selection(state = {}, action) {
  switch (action.type) {
    case 'SELECTION_CHANGE':
      if (action.clientId) {
        return {
          selectionStart: {
            clientId: action.clientId,
            attributeKey: action.attributeKey,
            offset: action.startOffset
          },
          selectionEnd: {
            clientId: action.clientId,
            attributeKey: action.attributeKey,
            offset: action.endOffset
          }
        };
      }
      return {
        selectionStart: action.start || state.selectionStart,
        selectionEnd: action.end || state.selectionEnd
      };
    case 'RESET_SELECTION':
      const {
        selectionStart,
        selectionEnd
      } = action;
      return {
        selectionStart,
        selectionEnd
      };
    case 'MULTI_SELECT':
      const {
        start,
        end
      } = action;
      if (start === state.selectionStart?.clientId && end === state.selectionEnd?.clientId) {
        return state;
      }
      return {
        selectionStart: {
          clientId: start
        },
        selectionEnd: {
          clientId: end
        }
      };
    case 'RESET_BLOCKS':
      const startClientId = state?.selectionStart?.clientId;
      const endClientId = state?.selectionEnd?.clientId;

      // Do nothing if there's no selected block.
      if (!startClientId && !endClientId) {
        return state;
      }

      // If the start of the selection won't exist after reset, remove selection.
      if (!action.blocks.some(block => block.clientId === startClientId)) {
        return {
          selectionStart: {},
          selectionEnd: {}
        };
      }

      // If the end of the selection won't exist after reset, collapse selection.
      if (!action.blocks.some(block => block.clientId === endClientId)) {
        return {
          ...state,
          selectionEnd: state.selectionStart
        };
      }
  }
  const selectionStart = selectionHelper(state.selectionStart, action);
  const selectionEnd = selectionHelper(state.selectionEnd, action);
  if (selectionStart === state.selectionStart && selectionEnd === state.selectionEnd) {
    return state;
  }
  return {
    selectionStart,
    selectionEnd
  };
}

/**
 * Reducer returning whether the user is multi-selecting.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */
function isMultiSelecting(state = false, action) {
  switch (action.type) {
    case 'START_MULTI_SELECT':
      return true;
    case 'STOP_MULTI_SELECT':
      return false;
  }
  return state;
}

/**
 * Reducer returning whether selection is enabled.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */
function isSelectionEnabled(state = true, action) {
  switch (action.type) {
    case 'TOGGLE_SELECTION':
      return action.isSelectionEnabled;
  }
  return state;
}

/**
 * Reducer returning the data needed to display a prompt when certain blocks
 * are removed, or `false` if no such prompt is requested.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {Object|false} Data for removal prompt display, if any.
 */
function removalPromptData(state = false, action) {
  switch (action.type) {
    case 'DISPLAY_BLOCK_REMOVAL_PROMPT':
      const {
        clientIds,
        selectPrevious,
        message
      } = action;
      return {
        clientIds,
        selectPrevious,
        message
      };
    case 'CLEAR_BLOCK_REMOVAL_PROMPT':
      return false;
  }
  return state;
}

/**
 * Reducer returning any rules that a block editor may provide in order to
 * prevent a user from accidentally removing certain blocks. These rules are
 * then used to display a confirmation prompt to the user. For instance, in the
 * Site Editor, the Query Loop block is important enough to warrant such
 * confirmation.
 *
 * The data is a record whose keys are block types (e.g. 'core/query') and
 * whose values are the explanation to be shown to users (e.g. 'Query Loop
 * displays a list of posts or pages.').
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {Record<string,string>} Updated state.
 */
function blockRemovalRules(state = false, action) {
  switch (action.type) {
    case 'SET_BLOCK_REMOVAL_RULES':
      return action.rules;
  }
  return state;
}

/**
 * Reducer returning the initial block selection.
 *
 * Currently this in only used to restore the selection after block deletion and
 * pasting new content.This reducer should eventually be removed in favour of setting
 * selection directly.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {number|null} Initial position: 0, -1 or null.
 */
function initialPosition(state = null, action) {
  if (action.type === 'REPLACE_BLOCKS' && action.initialPosition !== undefined) {
    return action.initialPosition;
  } else if (['MULTI_SELECT', 'SELECT_BLOCK', 'RESET_SELECTION', 'INSERT_BLOCKS', 'REPLACE_INNER_BLOCKS'].includes(action.type)) {
    return action.initialPosition;
  }
  return state;
}
function blocksMode(state = {}, action) {
  if (action.type === 'TOGGLE_BLOCK_MODE') {
    const {
      clientId
    } = action;
    return {
      ...state,
      [clientId]: state[clientId] && state[clientId] === 'html' ? 'visual' : 'html'
    };
  }
  return state;
}

/**
 * Reducer returning the block insertion point visibility, either null if there
 * is not an explicit insertion point assigned, or an object of its `index` and
 * `rootClientId`.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */
function insertionPoint(state = null, action) {
  switch (action.type) {
    case 'SHOW_INSERTION_POINT':
      {
        const {
          rootClientId,
          index,
          __unstableWithInserter,
          operation,
          nearestSide
        } = action;
        const nextState = {
          rootClientId,
          index,
          __unstableWithInserter,
          operation,
          nearestSide
        };

        // Bail out updates if the states are the same.
        return es6_default()(state, nextState) ? state : nextState;
      }
    case 'HIDE_INSERTION_POINT':
      return null;
  }
  return state;
}

/**
 * Reducer returning whether the post blocks match the defined template or not.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {boolean} Updated state.
 */
function template(state = {
  isValid: true
}, action) {
  switch (action.type) {
    case 'SET_TEMPLATE_VALIDITY':
      return {
        ...state,
        isValid: action.isValid
      };
  }
  return state;
}

/**
 * Reducer returning the editor setting.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */
function settings(state = SETTINGS_DEFAULTS, action) {
  switch (action.type) {
    case 'UPDATE_SETTINGS':
      if (action.reset) {
        return {
          ...SETTINGS_DEFAULTS,
          ...action.settings
        };
      }
      return {
        ...state,
        ...action.settings
      };
  }
  return state;
}

/**
 * Reducer returning the user preferences.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {string} Updated state.
 */
function preferences(state = PREFERENCES_DEFAULTS, action) {
  switch (action.type) {
    case 'INSERT_BLOCKS':
    case 'REPLACE_BLOCKS':
      {
        const nextInsertUsage = action.blocks.reduce((prevUsage, block) => {
          const {
            attributes,
            name: blockName
          } = block;
          let id = blockName;
          // If a block variation match is found change the name to be the same with the
          // one that is used for block variations in the Inserter (`getItemFromVariation`).
          const match = (0,external_wp_data_namespaceObject.select)(external_wp_blocks_namespaceObject.store).getActiveBlockVariation(blockName, attributes);
          if (match?.name) {
            id += '/' + match.name;
          }
          if (blockName === 'core/block') {
            id += '/' + attributes.ref;
          }
          return {
            ...prevUsage,
            [id]: {
              time: action.time,
              count: prevUsage[id] ? prevUsage[id].count + 1 : 1
            }
          };
        }, state.insertUsage);
        return {
          ...state,
          insertUsage: nextInsertUsage
        };
      }
  }
  return state;
}

/**
 * Reducer returning an object where each key is a block client ID, its value
 * representing the settings for its nested blocks.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */
const blockListSettings = (state = {}, action) => {
  switch (action.type) {
    // Even if the replaced blocks have the same client ID, our logic
    // should correct the state.
    case 'REPLACE_BLOCKS':
    case 'REMOVE_BLOCKS':
      {
        return Object.fromEntries(Object.entries(state).filter(([id]) => !action.clientIds.includes(id)));
      }
    case 'UPDATE_BLOCK_LIST_SETTINGS':
      {
        const updates = typeof action.clientId === 'string' ? {
          [action.clientId]: action.settings
        } : action.clientId;

        // Remove settings that are the same as the current state.
        for (const clientId in updates) {
          if (!updates[clientId]) {
            if (!state[clientId]) {
              delete updates[clientId];
            }
          } else if (es6_default()(state[clientId], updates[clientId])) {
            delete updates[clientId];
          }
        }
        if (Object.keys(updates).length === 0) {
          return state;
        }
        const merged = {
          ...state,
          ...updates
        };
        for (const clientId in updates) {
          if (!updates[clientId]) {
            delete merged[clientId];
          }
        }
        return merged;
      }
  }
  return state;
};

/**
 * Reducer returning which mode is enabled.
 *
 * @param {string} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {string} Updated state.
 */
function editorMode(state = 'edit', action) {
  // Let inserting block in navigation mode always trigger Edit mode.
  if (action.type === 'INSERT_BLOCKS' && state === 'navigation') {
    return 'edit';
  }
  if (action.type === 'SET_EDITOR_MODE') {
    return action.mode;
  }
  return state;
}

/**
 * Reducer returning whether the block moving mode is enabled or not.
 *
 * @param {string|null} state  Current state.
 * @param {Object}      action Dispatched action.
 *
 * @return {string|null} Updated state.
 */
function hasBlockMovingClientId(state = null, action) {
  if (action.type === 'SET_BLOCK_MOVING_MODE') {
    return action.hasBlockMovingClientId;
  }
  if (action.type === 'SET_EDITOR_MODE') {
    return null;
  }
  return state;
}

/**
 * Reducer return an updated state representing the most recent block attribute
 * update. The state is structured as an object where the keys represent the
 * client IDs of blocks, the values a subset of attributes from the most recent
 * block update. The state is always reset to null if the last action is
 * anything other than an attributes update.
 *
 * @param {Object<string,Object>} state  Current state.
 * @param {Object}                action Action object.
 *
 * @return {[string,Object]} Updated state.
 */
function lastBlockAttributesChange(state = null, action) {
  switch (action.type) {
    case 'UPDATE_BLOCK':
      if (!action.updates.attributes) {
        break;
      }
      return {
        [action.clientId]: action.updates.attributes
      };
    case 'UPDATE_BLOCK_ATTRIBUTES':
      return action.clientIds.reduce((accumulator, id) => ({
        ...accumulator,
        [id]: action.uniqueByBlock ? action.attributes[id] : action.attributes
      }), {});
  }
  return state;
}

/**
 * Reducer returning current highlighted block.
 *
 * @param {boolean} state  Current highlighted block.
 * @param {Object}  action Dispatched action.
 *
 * @return {string} Updated state.
 */
function highlightedBlock(state, action) {
  switch (action.type) {
    case 'TOGGLE_BLOCK_HIGHLIGHT':
      const {
        clientId,
        isHighlighted
      } = action;
      if (isHighlighted) {
        return clientId;
      } else if (state === clientId) {
        return null;
      }
      return state;
    case 'SELECT_BLOCK':
      if (action.clientId !== state) {
        return null;
      }
  }
  return state;
}

/**
 * Reducer returning current expanded block in the list view.
 *
 * @param {string|null} state  Current expanded block.
 * @param {Object}      action Dispatched action.
 *
 * @return {string|null} Updated state.
 */
function expandedBlock(state = null, action) {
  switch (action.type) {
    case 'SET_BLOCK_EXPANDED_IN_LIST_VIEW':
      return action.clientId;
    case 'SELECT_BLOCK':
      if (action.clientId !== state) {
        return null;
      }
  }
  return state;
}

/**
 * Reducer returning the block insertion event list state.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */
function lastBlockInserted(state = {}, action) {
  switch (action.type) {
    case 'INSERT_BLOCKS':
    case 'REPLACE_BLOCKS':
      if (!action.blocks.length) {
        return state;
      }
      const clientIds = action.blocks.map(block => {
        return block.clientId;
      });
      const source = action.meta?.source;
      return {
        clientIds,
        source
      };
    case 'RESET_BLOCKS':
      return {};
  }
  return state;
}

/**
 * Reducer returning the block that is eding temporarily edited as blocks.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */
function temporarilyEditingAsBlocks(state = '', action) {
  if (action.type === 'SET_TEMPORARILY_EDITING_AS_BLOCKS') {
    return action.temporarilyEditingAsBlocks;
  }
  return state;
}

/**
 * Reducer returning the focus mode that should be used when temporarily edit as blocks finishes.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */
function temporarilyEditingFocusModeRevert(state = '', action) {
  if (action.type === 'SET_TEMPORARILY_EDITING_AS_BLOCKS') {
    return action.focusModeToRevert;
  }
  return state;
}

/**
 * Reducer returning a map of block client IDs to block editing modes.
 *
 * @param {Map}    state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Map} Updated state.
 */
function blockEditingModes(state = new Map(), action) {
  switch (action.type) {
    case 'SET_BLOCK_EDITING_MODE':
      return new Map(state).set(action.clientId, action.mode);
    case 'UNSET_BLOCK_EDITING_MODE':
      {
        const newState = new Map(state);
        newState.delete(action.clientId);
        return newState;
      }
    case 'RESET_BLOCKS':
      {
        return state.has('') ? new Map().set('', state.get('')) : state;
      }
  }
  return state;
}

/**
 * Reducer returning the clientId of the block settings menu that is currently open.
 *
 * @param {string|null} state  Current state.
 * @param {Object}      action Dispatched action.
 *
 * @return {string|null} Updated state.
 */
function openedBlockSettingsMenu(state = null, action) {
  if ('SET_OPENED_BLOCK_SETTINGS_MENU' === action.type) {
    var _action$clientId;
    return (_action$clientId = action?.clientId) !== null && _action$clientId !== void 0 ? _action$clientId : null;
  }
  return state;
}

/**
 * Reducer returning a map of style IDs to style overrides.
 *
 * @param {Map}    state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Map} Updated state.
 */
function styleOverrides(state = new Map(), action) {
  switch (action.type) {
    case 'SET_STYLE_OVERRIDE':
      return new Map(state).set(action.id, action.style);
    case 'DELETE_STYLE_OVERRIDE':
      {
        const newState = new Map(state);
        newState.delete(action.id);
        return newState;
      }
  }
  return state;
}

/**
 * Reducer returning a map of the registered inserter media categories.
 *
 * @param {Array}  state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Array} Updated state.
 */
function registeredInserterMediaCategories(state = [], action) {
  switch (action.type) {
    case 'REGISTER_INSERTER_MEDIA_CATEGORY':
      return [...state, action.category];
  }
  return state;
}

/**
 * Reducer setting last focused element
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */
function lastFocus(state = false, action) {
  switch (action.type) {
    case 'LAST_FOCUS':
      return action.lastFocus;
  }
  return state;
}
const combinedReducers = (0,external_wp_data_namespaceObject.combineReducers)({
  blocks,
  isDragging,
  isTyping,
  isBlockInterfaceHidden,
  draggedBlocks,
  selection,
  isMultiSelecting,
  isSelectionEnabled,
  initialPosition,
  blocksMode,
  blockListSettings,
  insertionPoint,
  template,
  settings,
  preferences,
  lastBlockAttributesChange,
  lastFocus,
  editorMode,
  hasBlockMovingClientId,
  expandedBlock,
  highlightedBlock,
  lastBlockInserted,
  temporarilyEditingAsBlocks,
  temporarilyEditingFocusModeRevert,
  blockVisibility,
  blockEditingModes,
  styleOverrides,
  removalPromptData,
  blockRemovalRules,
  openedBlockSettingsMenu,
  registeredInserterMediaCategories
});
function withAutomaticChangeReset(reducer) {
  return (state, action) => {
    const nextState = reducer(state, action);
    if (!state) {
      return nextState;
    }

    // Take over the last value without creating a new reference.
    nextState.automaticChangeStatus = state.automaticChangeStatus;
    if (action.type === 'MARK_AUTOMATIC_CHANGE') {
      return {
        ...nextState,
        automaticChangeStatus: 'pending'
      };
    }
    if (action.type === 'MARK_AUTOMATIC_CHANGE_FINAL' && state.automaticChangeStatus === 'pending') {
      return {
        ...nextState,
        automaticChangeStatus: 'final'
      };
    }

    // If there's a change that doesn't affect blocks or selection, maintain
    // the current status.
    if (nextState.blocks === state.blocks && nextState.selection === state.selection) {
      return nextState;
    }

    // As long as the state is not final, ignore any selection changes.
    if (nextState.automaticChangeStatus !== 'final' && nextState.selection !== state.selection) {
      return nextState;
    }

    // Reset the status if blocks change or selection changes (when status is final).
    return {
      ...nextState,
      automaticChangeStatus: undefined
    };
  };
}
/* harmony default export */ const reducer = (withAutomaticChangeReset(combinedReducers));

;// CONCATENATED MODULE: external ["wp","primitives"]
const external_wp_primitives_namespaceObject = window["wp"]["primitives"];
;// CONCATENATED MODULE: external "ReactJSXRuntime"
const external_ReactJSXRuntime_namespaceObject = window["ReactJSXRuntime"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/symbol.js
/**
 * WordPress dependencies
 */


const symbol = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M21.3 10.8l-5.6-5.6c-.7-.7-1.8-.7-2.5 0l-5.6 5.6c-.7.7-.7 1.8 0 2.5l5.6 5.6c.3.3.8.5 1.2.5s.9-.2 1.2-.5l5.6-5.6c.8-.7.8-1.9.1-2.5zm-1 1.4l-5.6 5.6c-.1.1-.3.1-.4 0l-5.6-5.6c-.1-.1-.1-.3 0-.4l5.6-5.6s.1-.1.2-.1.1 0 .2.1l5.6 5.6c.1.1.1.3 0 .4zm-16.6-.4L10 5.5l-1-1-6.3 6.3c-.7.7-.7 1.8 0 2.5L9 19.5l1.1-1.1-6.3-6.3c-.2 0-.2-.2-.1-.3z"
  })
});
/* harmony default export */ const library_symbol = (symbol);

;// CONCATENATED MODULE: external ["wp","richText"]
const external_wp_richText_namespaceObject = window["wp"]["richText"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/private-keys.js
const globalStylesDataKey = Symbol('globalStylesDataKey');
const selectBlockPatternsKey = Symbol('selectBlockPatternsKey');
const reusableBlocksSelectKey = Symbol('reusableBlocksSelect');

;// CONCATENATED MODULE: external ["wp","privateApis"]
const external_wp_privateApis_namespaceObject = window["wp"]["privateApis"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/lock-unlock.js
/**
 * WordPress dependencies
 */

const {
  lock,
  unlock
} = (0,external_wp_privateApis_namespaceObject.__dangerousOptInToUnstableAPIsOnlyForCoreModules)('I know using unstable features means my theme or plugin will inevitably break in the next version of WordPress.', '@wordpress/block-editor');

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/constants.js
const STORE_NAME = 'core/block-editor';

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/utils.js
/**
 * Internal dependencies
 */



const withRootClientIdOptionKey = Symbol('withRootClientId');
const checkAllowList = (list, item, defaultResult = null) => {
  if (typeof list === 'boolean') {
    return list;
  }
  if (Array.isArray(list)) {
    // TODO: when there is a canonical way to detect that we are editing a post
    // the following check should be changed to something like:
    // if ( list.includes( 'core/post-content' ) && getEditorMode() === 'post-content' && item === null )
    if (list.includes('core/post-content') && item === null) {
      return true;
    }
    return list.includes(item);
  }
  return defaultResult;
};
const checkAllowListRecursive = (blocks, allowedBlockTypes) => {
  if (typeof allowedBlockTypes === 'boolean') {
    return allowedBlockTypes;
  }
  const blocksQueue = [...blocks];
  while (blocksQueue.length > 0) {
    const block = blocksQueue.shift();
    const isAllowed = checkAllowList(allowedBlockTypes, block.name || block.blockName, true);
    if (!isAllowed) {
      return false;
    }
    block.innerBlocks?.forEach(innerBlock => {
      blocksQueue.push(innerBlock);
    });
  }
  return true;
};
const getAllPatternsDependants = select => state => {
  return [state.settings.__experimentalBlockPatterns, state.settings.__experimentalUserPatternCategories, state.settings.__experimentalReusableBlocks, state.settings[selectBlockPatternsKey]?.(select), state.blockPatterns, unlock(select(STORE_NAME)).getReusableBlocks()];
};
function getInsertBlockTypeDependants(state, rootClientId) {
  return [state.blockListSettings[rootClientId], state.blocks.byClientId.get(rootClientId), state.settings.allowedBlockTypes, state.settings.templateLock, state.blockEditingModes];
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/utils/sorting.js
/**
 * Recursive stable sorting comparator function.
 *
 * @param {string|Function} field Field to sort by.
 * @param {Array}           items Items to sort.
 * @param {string}          order Order, 'asc' or 'desc'.
 * @return {Function} Comparison function to be used in a `.sort()`.
 */
const comparator = (field, items, order) => {
  return (a, b) => {
    let cmpA, cmpB;
    if (typeof field === 'function') {
      cmpA = field(a);
      cmpB = field(b);
    } else {
      cmpA = a[field];
      cmpB = b[field];
    }
    if (cmpA > cmpB) {
      return order === 'asc' ? 1 : -1;
    } else if (cmpB > cmpA) {
      return order === 'asc' ? -1 : 1;
    }
    const orderA = items.findIndex(item => item === a);
    const orderB = items.findIndex(item => item === b);

    // Stable sort: maintaining original array order
    if (orderA > orderB) {
      return 1;
    } else if (orderB > orderA) {
      return -1;
    }
    return 0;
  };
};

/**
 * Order items by a certain key.
 * Supports decorator functions that allow complex picking of a comparison field.
 * Sorts in ascending order by default, but supports descending as well.
 * Stable sort - maintains original order of equal items.
 *
 * @param {Array}           items Items to order.
 * @param {string|Function} field Field to order by.
 * @param {string}          order Sorting order, `asc` or `desc`.
 * @return {Array} Sorted items.
 */
function orderBy(items, field, order = 'asc') {
  return items.concat().sort(comparator(field, items, order));
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inserter/block-patterns-tab/utils.js
/**
 * WordPress dependencies
 */


const INSERTER_PATTERN_TYPES = {
  user: 'user',
  theme: 'theme',
  directory: 'directory'
};
const INSERTER_SYNC_TYPES = {
  full: 'fully',
  unsynced: 'unsynced'
};
const allPatternsCategory = {
  name: 'allPatterns',
  label: (0,external_wp_i18n_namespaceObject._x)('All', 'patterns')
};
const myPatternsCategory = {
  name: 'myPatterns',
  label: (0,external_wp_i18n_namespaceObject.__)('My patterns')
};
function isPatternFiltered(pattern, sourceFilter, syncFilter) {
  const isUserPattern = pattern.name.startsWith('core/block');
  const isDirectoryPattern = pattern.source === 'core' || pattern.source?.startsWith('pattern-directory');

  // If theme source selected, filter out user created patterns and those from
  // the core patterns directory.
  if (sourceFilter === INSERTER_PATTERN_TYPES.theme && (isUserPattern || isDirectoryPattern)) {
    return true;
  }

  // If the directory source is selected, filter out user created patterns
  // and those bundled with the theme.
  if (sourceFilter === INSERTER_PATTERN_TYPES.directory && (isUserPattern || !isDirectoryPattern)) {
    return true;
  }

  // If user source selected, filter out theme patterns.
  if (sourceFilter === INSERTER_PATTERN_TYPES.user && pattern.type !== INSERTER_PATTERN_TYPES.user) {
    return true;
  }

  // Filter by sync status.
  if (syncFilter === INSERTER_SYNC_TYPES.full && pattern.syncStatus !== '') {
    return true;
  }
  if (syncFilter === INSERTER_SYNC_TYPES.unsynced && pattern.syncStatus !== 'unsynced' && isUserPattern) {
    return true;
  }
  return false;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/utils/object.js
/**
 * Immutably sets a value inside an object. Like `lodash#set`, but returning a
 * new object. Treats nullish initial values as empty objects. Clones any
 * nested objects. Supports arrays, too.
 *
 * @param {Object}              object Object to set a value in.
 * @param {number|string|Array} path   Path in the object to modify.
 * @param {*}                   value  New value to set.
 * @return {Object} Cloned object with the new value set.
 */
function setImmutably(object, path, value) {
  // Normalize path
  path = Array.isArray(path) ? [...path] : [path];

  // Shallowly clone the base of the object
  object = Array.isArray(object) ? [...object] : {
    ...object
  };
  const leaf = path.pop();

  // Traverse object from root to leaf, shallowly cloning at each level
  let prev = object;
  for (const key of path) {
    const lvl = prev[key];
    prev = prev[key] = Array.isArray(lvl) ? [...lvl] : {
      ...lvl
    };
  }
  prev[leaf] = value;
  return object;
}

/**
 * Helper util to return a value from a certain path of the object.
 * Path is specified as either:
 * - a string of properties, separated by dots, for example: "x.y".
 * - an array of properties, for example `[ 'x', 'y' ]`.
 * You can also specify a default value in case the result is nullish.
 *
 * @param {Object}       object       Input object.
 * @param {string|Array} path         Path to the object property.
 * @param {*}            defaultValue Default value if the value at the specified path is nullish.
 * @return {*} Value of the object property at the specified path.
 */
const getValueFromObjectPath = (object, path, defaultValue) => {
  var _value;
  const arrayPath = Array.isArray(path) ? path : path.split('.');
  let value = object;
  arrayPath.forEach(fieldName => {
    value = value?.[fieldName];
  });
  return (_value = value) !== null && _value !== void 0 ? _value : defaultValue;
};

/**
 * Helper util to filter out objects with duplicate values for a given property.
 *
 * @param {Object[]} array    Array of objects to filter.
 * @param {string}   property Property to filter unique values by.
 *
 * @return {Object[]} Array of objects with unique values for the specified property.
 */
function uniqByProperty(array, property) {
  const seen = new Set();
  return array.filter(item => {
    const value = item[property];
    return seen.has(value) ? false : seen.add(value);
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/get-block-settings.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


const blockedPaths = ['color', 'border', 'dimensions', 'typography', 'spacing'];
const deprecatedFlags = {
  'color.palette': settings => settings.colors,
  'color.gradients': settings => settings.gradients,
  'color.custom': settings => settings.disableCustomColors === undefined ? undefined : !settings.disableCustomColors,
  'color.customGradient': settings => settings.disableCustomGradients === undefined ? undefined : !settings.disableCustomGradients,
  'typography.fontSizes': settings => settings.fontSizes,
  'typography.customFontSize': settings => settings.disableCustomFontSizes === undefined ? undefined : !settings.disableCustomFontSizes,
  'typography.lineHeight': settings => settings.enableCustomLineHeight,
  'spacing.units': settings => {
    if (settings.enableCustomUnits === undefined) {
      return;
    }
    if (settings.enableCustomUnits === true) {
      return ['px', 'em', 'rem', 'vh', 'vw', '%'];
    }
    return settings.enableCustomUnits;
  },
  'spacing.padding': settings => settings.enableCustomSpacing
};
const prefixedFlags = {
  /*
   * These were only available in the plugin
   * and can be removed when the minimum WordPress version
   * for the plugin is 5.9.
   */
  'border.customColor': 'border.color',
  'border.customStyle': 'border.style',
  'border.customWidth': 'border.width',
  'typography.customFontStyle': 'typography.fontStyle',
  'typography.customFontWeight': 'typography.fontWeight',
  'typography.customLetterSpacing': 'typography.letterSpacing',
  'typography.customTextDecorations': 'typography.textDecoration',
  'typography.customTextTransforms': 'typography.textTransform',
  /*
   * These were part of WordPress 5.8 and we need to keep them.
   */
  'border.customRadius': 'border.radius',
  'spacing.customMargin': 'spacing.margin',
  'spacing.customPadding': 'spacing.padding',
  'typography.customLineHeight': 'typography.lineHeight'
};

/**
 * Remove `custom` prefixes for flags that did not land in 5.8.
 *
 * This provides continued support for `custom` prefixed properties. It will
 * be removed once third party devs have had sufficient time to update themes,
 * plugins, etc.
 *
 * @see https://github.com/WordPress/gutenberg/pull/34485
 *
 * @param {string} path Path to desired value in settings.
 * @return {string}     The value for defined setting.
 */
const removeCustomPrefixes = path => {
  return prefixedFlags[path] || path;
};
function getBlockSettings(state, clientId, ...paths) {
  const blockName = getBlockName(state, clientId);
  const candidates = [];
  if (clientId) {
    let id = clientId;
    do {
      const name = getBlockName(state, id);
      if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, '__experimentalSettings', false)) {
        candidates.push(id);
      }
    } while (id = state.blocks.parents.get(id));
  }
  return paths.map(path => {
    if (blockedPaths.includes(path)) {
      // eslint-disable-next-line no-console
      console.warn('Top level useSetting paths are disabled. Please use a subpath to query the information needed.');
      return undefined;
    }

    // 0. Allow third parties to filter the block's settings at runtime.
    let result = (0,external_wp_hooks_namespaceObject.applyFilters)('blockEditor.useSetting.before', undefined, path, clientId, blockName);
    if (undefined !== result) {
      return result;
    }
    const normalizedPath = removeCustomPrefixes(path);

    // 1. Take settings from the block instance or its ancestors.
    // Start from the current block and work our way up the ancestors.
    for (const candidateClientId of candidates) {
      var _getValueFromObjectPa;
      const candidateAtts = getBlockAttributes(state, candidateClientId);
      result = (_getValueFromObjectPa = getValueFromObjectPath(candidateAtts.settings?.blocks?.[blockName], normalizedPath)) !== null && _getValueFromObjectPa !== void 0 ? _getValueFromObjectPa : getValueFromObjectPath(candidateAtts.settings, normalizedPath);
      if (result !== undefined) {
        // Stop the search for more distant ancestors and move on.
        break;
      }
    }

    // 2. Fall back to the settings from the block editor store (__experimentalFeatures).
    const settings = getSettings(state);
    if (result === undefined && blockName) {
      result = getValueFromObjectPath(settings.__experimentalFeatures?.blocks?.[blockName], normalizedPath);
    }
    if (result === undefined) {
      result = getValueFromObjectPath(settings.__experimentalFeatures, normalizedPath);
    }

    // Return if the setting was found in either the block instance or the store.
    if (result !== undefined) {
      if (external_wp_blocks_namespaceObject.__EXPERIMENTAL_PATHS_WITH_OVERRIDE[normalizedPath]) {
        var _ref, _result$custom;
        return (_ref = (_result$custom = result.custom) !== null && _result$custom !== void 0 ? _result$custom : result.theme) !== null && _ref !== void 0 ? _ref : result.default;
      }
      return result;
    }

    // 3. Otherwise, use deprecated settings.
    const deprecatedSettingsValue = deprecatedFlags[normalizedPath]?.(settings);
    if (deprecatedSettingsValue !== undefined) {
      return deprecatedSettingsValue;
    }

    // 4. Fallback for typography.dropCap:
    // This is only necessary to support typography.dropCap.
    // when __experimentalFeatures are not present (core without plugin).
    // To remove when __experimentalFeatures are ported to core.
    return normalizedPath === 'typography.dropCap' ? true : undefined;
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/private-selectors.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */








/**
 * Returns true if the block interface is hidden, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the block toolbar is hidden.
 */
function private_selectors_isBlockInterfaceHidden(state) {
  return state.isBlockInterfaceHidden;
}

/**
 * Gets the client ids of the last inserted blocks.
 *
 * @param {Object} state Global application state.
 * @return {Array|undefined} Client Ids of the last inserted block(s).
 */
function getLastInsertedBlocksClientIds(state) {
  return state?.lastBlockInserted?.clientIds;
}
function getBlockWithoutAttributes(state, clientId) {
  return state.blocks.byClientId.get(clientId);
}

/**
 * Returns true if all of the descendants of a block with the given client ID
 * have an editing mode of 'disabled', or false otherwise.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId The block client ID.
 *
 * @return {boolean} Whether the block descendants are disabled.
 */
const isBlockSubtreeDisabled = (state, clientId) => {
  const isChildSubtreeDisabled = childClientId => {
    return getBlockEditingMode(state, childClientId) === 'disabled' && getBlockOrder(state, childClientId).every(isChildSubtreeDisabled);
  };
  return getBlockOrder(state, clientId).every(isChildSubtreeDisabled);
};
function getEnabledClientIdsTreeUnmemoized(state, rootClientId) {
  const blockOrder = getBlockOrder(state, rootClientId);
  const result = [];
  for (const clientId of blockOrder) {
    const innerBlocks = getEnabledClientIdsTreeUnmemoized(state, clientId);
    if (getBlockEditingMode(state, clientId) !== 'disabled') {
      result.push({
        clientId,
        innerBlocks
      });
    } else {
      result.push(...innerBlocks);
    }
  }
  return result;
}

/**
 * Returns a tree of block objects with only clientID and innerBlocks set.
 * Blocks with a 'disabled' editing mode are not included.
 *
 * @param {Object}  state        Global application state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Object[]} Tree of block objects with only clientID and innerBlocks set.
 */
const getEnabledClientIdsTree = (0,external_wp_data_namespaceObject.createSelector)(getEnabledClientIdsTreeUnmemoized, state => [state.blocks.order, state.blockEditingModes, state.settings.templateLock, state.blockListSettings]);

/**
 * Returns a list of a given block's ancestors, from top to bottom. Blocks with
 * a 'disabled' editing mode are excluded.
 *
 * @see getBlockParents
 *
 * @param {Object}  state     Global application state.
 * @param {string}  clientId  The block client ID.
 * @param {boolean} ascending Order results from bottom to top (true) or top
 *                            to bottom (false).
 */
const getEnabledBlockParents = (0,external_wp_data_namespaceObject.createSelector)((state, clientId, ascending = false) => {
  return getBlockParents(state, clientId, ascending).filter(parent => getBlockEditingMode(state, parent) !== 'disabled');
}, state => [state.blocks.parents, state.blockEditingModes, state.settings.templateLock, state.blockListSettings]);

/**
 * Selector that returns the data needed to display a prompt when certain
 * blocks are removed, or `false` if no such prompt is requested.
 *
 * @param {Object} state Global application state.
 *
 * @return {Object|false} Data for removal prompt display, if any.
 */
function getRemovalPromptData(state) {
  return state.removalPromptData;
}

/**
 * Returns true if removal prompt exists, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether removal prompt exists.
 */
function getBlockRemovalRules(state) {
  return state.blockRemovalRules;
}

/**
 * Returns the client ID of the block settings menu that is currently open.
 *
 * @param {Object} state Global application state.
 * @return {string|null} The client ID of the block menu that is currently open.
 */
function getOpenedBlockSettingsMenu(state) {
  return state.openedBlockSettingsMenu;
}

/**
 * Returns all style overrides, intended to be merged with global editor styles.
 *
 * Overrides are sorted to match the order of the blocks they relate to. This
 * is useful to maintain correct CSS cascade order.
 *
 * @param {Object} state Global application state.
 *
 * @return {Array} An array of style ID to style override pairs.
 */
const getStyleOverrides = (0,external_wp_data_namespaceObject.createSelector)(state => {
  const clientIds = getClientIdsWithDescendants(state);
  const clientIdMap = clientIds.reduce((acc, clientId, index) => {
    acc[clientId] = index;
    return acc;
  }, {});
  return [...state.styleOverrides].sort((overrideA, overrideB) => {
    var _clientIdMap$clientId, _clientIdMap$clientId2;
    // Once the overrides Map is spread to an array, the first element
    // is the key, while the second is the override itself including
    // the clientId to sort by.
    const [, {
      clientId: clientIdA
    }] = overrideA;
    const [, {
      clientId: clientIdB
    }] = overrideB;
    const aIndex = (_clientIdMap$clientId = clientIdMap[clientIdA]) !== null && _clientIdMap$clientId !== void 0 ? _clientIdMap$clientId : -1;
    const bIndex = (_clientIdMap$clientId2 = clientIdMap[clientIdB]) !== null && _clientIdMap$clientId2 !== void 0 ? _clientIdMap$clientId2 : -1;
    return aIndex - bIndex;
  });
}, state => [state.blocks.order, state.styleOverrides]);

/** @typedef {import('./actions').InserterMediaCategory} InserterMediaCategory */
/**
 * Returns the registered inserter media categories through the public API.
 *
 * @param {Object} state Editor state.
 *
 * @return {InserterMediaCategory[]} Inserter media categories.
 */
function getRegisteredInserterMediaCategories(state) {
  return state.registeredInserterMediaCategories;
}

/**
 * Returns an array containing the allowed inserter media categories.
 * It merges the registered media categories from extenders with the
 * core ones. It also takes into account the allowed `mime_types`, which
 * can be altered by `upload_mimes` filter and restrict some of them.
 *
 * @param {Object} state Global application state.
 *
 * @return {InserterMediaCategory[]} Client IDs of descendants.
 */
const getInserterMediaCategories = (0,external_wp_data_namespaceObject.createSelector)(state => {
  const {
    settings: {
      inserterMediaCategories,
      allowedMimeTypes,
      enableOpenverseMediaCategory
    },
    registeredInserterMediaCategories
  } = state;
  // The allowed `mime_types` can be altered by `upload_mimes` filter and restrict
  // some of them. In this case we shouldn't add the category to the available media
  // categories list in the inserter.
  if (!inserterMediaCategories && !registeredInserterMediaCategories.length || !allowedMimeTypes) {
    return;
  }
  const coreInserterMediaCategoriesNames = inserterMediaCategories?.map(({
    name
  }) => name) || [];
  const mergedCategories = [...(inserterMediaCategories || []), ...(registeredInserterMediaCategories || []).filter(({
    name
  }) => !coreInserterMediaCategoriesNames.includes(name))];
  return mergedCategories.filter(category => {
    // Check if Openverse category is enabled.
    if (!enableOpenverseMediaCategory && category.name === 'openverse') {
      return false;
    }
    return Object.values(allowedMimeTypes).some(mimeType => mimeType.startsWith(`${category.mediaType}/`));
  });
}, state => [state.settings.inserterMediaCategories, state.settings.allowedMimeTypes, state.settings.enableOpenverseMediaCategory, state.registeredInserterMediaCategories]);

/**
 * Returns whether there is at least one allowed pattern for inner blocks children.
 * This is useful for deferring the parsing of all patterns until needed.
 *
 * @param {Object} state               Editor state.
 * @param {string} [rootClientId=null] Target root client ID.
 *
 * @return {boolean} If there is at least one allowed pattern.
 */
const hasAllowedPatterns = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (0,external_wp_data_namespaceObject.createSelector)((state, rootClientId = null) => {
  const {
    getAllPatterns,
    __experimentalGetParsedPattern
  } = unlock(select(STORE_NAME));
  const patterns = getAllPatterns();
  const {
    allowedBlockTypes
  } = getSettings(state);
  return patterns.some(({
    name,
    inserter = true
  }) => {
    if (!inserter) {
      return false;
    }
    const {
      blocks
    } = __experimentalGetParsedPattern(name);
    return checkAllowListRecursive(blocks, allowedBlockTypes) && blocks.every(({
      name: blockName
    }) => canInsertBlockType(state, blockName, rootClientId));
  });
}, (state, rootClientId) => [...getAllPatternsDependants(select)(state), ...getInsertBlockTypeDependants(state, rootClientId)]));
function mapUserPattern(userPattern, __experimentalUserPatternCategories = []) {
  return {
    name: `core/block/${userPattern.id}`,
    id: userPattern.id,
    type: INSERTER_PATTERN_TYPES.user,
    title: userPattern.title.raw,
    categories: userPattern.wp_pattern_category.map(catId => {
      const category = __experimentalUserPatternCategories.find(({
        id
      }) => id === catId);
      return category ? category.slug : catId;
    }),
    content: userPattern.content.raw,
    syncStatus: userPattern.wp_pattern_sync_status
  };
}
const getPatternBySlug = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (0,external_wp_data_namespaceObject.createSelector)((state, patternName) => {
  var _state$settings$__exp, _state$settings$selec;
  // Only fetch reusable blocks if we know we need them. To do: maybe
  // use the entity record API to retrieve the block by slug.
  if (patternName?.startsWith('core/block/')) {
    const _id = parseInt(patternName.slice('core/block/'.length), 10);
    const block = unlock(select(STORE_NAME)).getReusableBlocks().find(({
      id
    }) => id === _id);
    if (!block) {
      return null;
    }
    return mapUserPattern(block, state.settings.__experimentalUserPatternCategories);
  }
  return [
  // This setting is left for back compat.
  ...((_state$settings$__exp = state.settings.__experimentalBlockPatterns) !== null && _state$settings$__exp !== void 0 ? _state$settings$__exp : []), ...((_state$settings$selec = state.settings[selectBlockPatternsKey]?.(select)) !== null && _state$settings$selec !== void 0 ? _state$settings$selec : [])].find(({
    name
  }) => name === patternName);
}, (state, patternName) => patternName?.startsWith('core/block/') ? [unlock(select(STORE_NAME)).getReusableBlocks(), state.settings.__experimentalReusableBlocks] : [state.settings.__experimentalBlockPatterns, state.settings[selectBlockPatternsKey]?.(select)]));
const getAllPatterns = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (0,external_wp_data_namespaceObject.createSelector)(state => {
  var _state$settings$__exp2, _state$settings$selec2;
  return [...unlock(select(STORE_NAME)).getReusableBlocks().map(userPattern => mapUserPattern(userPattern, state.settings.__experimentalUserPatternCategories)),
  // This setting is left for back compat.
  ...((_state$settings$__exp2 = state.settings.__experimentalBlockPatterns) !== null && _state$settings$__exp2 !== void 0 ? _state$settings$__exp2 : []), ...((_state$settings$selec2 = state.settings[selectBlockPatternsKey]?.(select)) !== null && _state$settings$selec2 !== void 0 ? _state$settings$selec2 : [])].filter((x, index, arr) => index === arr.findIndex(y => x.name === y.name));
}, getAllPatternsDependants(select)));
const isResolvingPatterns = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (0,external_wp_data_namespaceObject.createSelector)(state => {
  const blockPatternsSelect = state.settings[selectBlockPatternsKey];
  const reusableBlocksSelect = state.settings[reusableBlocksSelectKey];
  return (blockPatternsSelect ? blockPatternsSelect(select) === undefined : false) || (reusableBlocksSelect ? reusableBlocksSelect(select) === undefined : false);
}, getAllPatternsDependants(select)));
const EMPTY_ARRAY = [];
const getReusableBlocks = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => state => {
  var _state$settings$__exp3;
  const reusableBlocksSelect = state.settings[reusableBlocksSelectKey];
  return reusableBlocksSelect ? reusableBlocksSelect(select) : (_state$settings$__exp3 = state.settings.__experimentalReusableBlocks) !== null && _state$settings$__exp3 !== void 0 ? _state$settings$__exp3 : EMPTY_ARRAY;
});

/**
 * Returns the element of the last element that had focus when focus left the editor canvas.
 *
 * @param {Object} state Block editor state.
 *
 * @return {Object} Element.
 */
function getLastFocus(state) {
  return state.lastFocus;
}

/**
 * Returns true if the user is dragging anything, or false otherwise. It is possible for a
 * user to be dragging data from outside of the editor, so this selector is separate from
 * the `isDraggingBlocks` selector which only returns true if the user is dragging blocks.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether user is dragging.
 */
function private_selectors_isDragging(state) {
  return state.isDragging;
}

/**
 * Retrieves the expanded block from the state.
 *
 * @param {Object} state Block editor state.
 *
 * @return {string|null} The client ID of the expanded block, if set.
 */
function getExpandedBlock(state) {
  return state.expandedBlock;
}

/**
 * Retrieves the client ID of the ancestor block that is content locking the block
 * with the provided client ID.
 *
 * @param {Object} state    Global application state.
 * @param {Object} clientId Client Id of the block.
 *
 * @return {?string} Client ID of the ancestor block that is content locking the block.
 */
const getContentLockingParent = (0,external_wp_data_namespaceObject.createSelector)((state, clientId) => {
  let current = clientId;
  let result;
  while (current = state.blocks.parents.get(current)) {
    if (getBlockName(state, current) === 'core/block' || getTemplateLock(state, current) === 'contentOnly') {
      result = current;
    }
  }
  return result;
}, state => [state.blocks.parents, state.blockListSettings]);

/**
 * Retrieves the client ID of the block that is content locked but is
 * currently being temporarily edited as a non-locked block.
 *
 * @param {Object} state Global application state.
 *
 * @return {?string} The client ID of the block being temporarily edited as a non-locked block.
 */
function getTemporarilyEditingAsBlocks(state) {
  return state.temporarilyEditingAsBlocks;
}

/**
 * Returns the focus mode that should be reapplied when the user stops editing
 * a content locked blocks as a block without locking.
 *
 * @param {Object} state Global application state.
 *
 * @return {?string} The focus mode that should be re-set when temporarily editing as blocks stops.
 */
function getTemporarilyEditingFocusModeToRevert(state) {
  return state.temporarilyEditingFocusModeRevert;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/selectors.js
/**
 * WordPress dependencies
 */








/**
 * Internal dependencies
 */






/**
 * A block selection object.
 *
 * @typedef {Object} WPBlockSelection
 *
 * @property {string} clientId     A block client ID.
 * @property {string} attributeKey A block attribute key.
 * @property {number} offset       An attribute value offset, based on the rich
 *                                 text value. See `wp.richText.create`.
 */

// Module constants.
const MILLISECONDS_PER_HOUR = 3600 * 1000;
const MILLISECONDS_PER_DAY = 24 * 3600 * 1000;
const MILLISECONDS_PER_WEEK = 7 * 24 * 3600 * 1000;

/**
 * Shared reference to an empty array for cases where it is important to avoid
 * returning a new array reference on every invocation, as in a connected or
 * other pure component which performs `shouldComponentUpdate` check on props.
 * This should be used as a last resort, since the normalized data should be
 * maintained by the reducer result in state.
 *
 * @type {Array}
 */
const selectors_EMPTY_ARRAY = [];

/**
 * Shared reference to an empty Set for cases where it is important to avoid
 * returning a new Set reference on every invocation, as in a connected or
 * other pure component which performs `shouldComponentUpdate` check on props.
 * This should be used as a last resort, since the normalized data should be
 * maintained by the reducer result in state.
 *
 * @type {Set}
 */
const EMPTY_SET = new Set();

/**
 * Returns a block's name given its client ID, or null if no block exists with
 * the client ID.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {string} Block name.
 */
function getBlockName(state, clientId) {
  const block = state.blocks.byClientId.get(clientId);
  const socialLinkName = 'core/social-link';
  if (external_wp_element_namespaceObject.Platform.OS !== 'web' && block?.name === socialLinkName) {
    const attributes = state.blocks.attributes.get(clientId);
    const {
      service
    } = attributes !== null && attributes !== void 0 ? attributes : {};
    return service ? `${socialLinkName}-${service}` : socialLinkName;
  }
  return block ? block.name : null;
}

/**
 * Returns whether a block is valid or not.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Is Valid.
 */
function isBlockValid(state, clientId) {
  const block = state.blocks.byClientId.get(clientId);
  return !!block && block.isValid;
}

/**
 * Returns a block's attributes given its client ID, or null if no block exists with
 * the client ID.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {Object?} Block attributes.
 */
function getBlockAttributes(state, clientId) {
  const block = state.blocks.byClientId.get(clientId);
  if (!block) {
    return null;
  }
  return state.blocks.attributes.get(clientId);
}

/**
 * Returns a block given its client ID. This is a parsed copy of the block,
 * containing its `blockName`, `clientId`, and current `attributes` state. This
 * is not the block's registration settings, which must be retrieved from the
 * blocks module registration store.
 *
 * getBlock recurses through its inner blocks until all its children blocks have
 * been retrieved. Note that getBlock will not return the child inner blocks of
 * an inner block controller. This is because an inner block controller syncs
 * itself with its own entity, and should therefore not be included with the
 * blocks of a different entity. For example, say you call `getBlocks( TP )` to
 * get the blocks of a template part. If another template part is a child of TP,
 * then the nested template part's child blocks will not be returned. This way,
 * the template block itself is considered part of the parent, but the children
 * are not.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {Object} Parsed block object.
 */
function getBlock(state, clientId) {
  if (!state.blocks.byClientId.has(clientId)) {
    return null;
  }
  return state.blocks.tree.get(clientId);
}
const __unstableGetBlockWithoutInnerBlocks = (0,external_wp_data_namespaceObject.createSelector)((state, clientId) => {
  const block = state.blocks.byClientId.get(clientId);
  if (!block) {
    return null;
  }
  return {
    ...block,
    attributes: getBlockAttributes(state, clientId)
  };
}, (state, clientId) => [state.blocks.byClientId.get(clientId), state.blocks.attributes.get(clientId)]);

/**
 * Returns all block objects for the current post being edited as an array in
 * the order they appear in the post. Note that this will exclude child blocks
 * of nested inner block controllers.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Object[]} Post blocks.
 */
function getBlocks(state, rootClientId) {
  const treeKey = !rootClientId || !areInnerBlocksControlled(state, rootClientId) ? rootClientId || '' : 'controlled||' + rootClientId;
  return state.blocks.tree.get(treeKey)?.innerBlocks || selectors_EMPTY_ARRAY;
}

/**
 * Returns a stripped down block object containing only its client ID,
 * and its inner blocks' client IDs.
 *
 * @deprecated
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Client ID of the block to get.
 *
 * @return {Object} Client IDs of the post blocks.
 */
const __unstableGetClientIdWithClientIdsTree = (0,external_wp_data_namespaceObject.createSelector)((state, clientId) => {
  external_wp_deprecated_default()("wp.data.select( 'core/block-editor' ).__unstableGetClientIdWithClientIdsTree", {
    since: '6.3',
    version: '6.5'
  });
  return {
    clientId,
    innerBlocks: __unstableGetClientIdsTree(state, clientId)
  };
}, state => [state.blocks.order]);

/**
 * Returns the block tree represented in the block-editor store from the
 * given root, consisting of stripped down block objects containing only
 * their client IDs, and their inner blocks' client IDs.
 *
 * @deprecated
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Object[]} Client IDs of the post blocks.
 */
const __unstableGetClientIdsTree = (0,external_wp_data_namespaceObject.createSelector)((state, rootClientId = '') => {
  external_wp_deprecated_default()("wp.data.select( 'core/block-editor' ).__unstableGetClientIdsTree", {
    since: '6.3',
    version: '6.5'
  });
  return getBlockOrder(state, rootClientId).map(clientId => __unstableGetClientIdWithClientIdsTree(state, clientId));
}, state => [state.blocks.order]);

/**
 * Returns an array containing the clientIds of all descendants of the blocks
 * given. Returned ids are ordered first by the order of the ids given, then
 * by the order that they appear in the editor.
 *
 * @param {Object}          state   Global application state.
 * @param {string|string[]} rootIds Client ID(s) for which descendant blocks are to be returned.
 *
 * @return {Array} Client IDs of descendants.
 */
const getClientIdsOfDescendants = (0,external_wp_data_namespaceObject.createSelector)((state, rootIds) => {
  rootIds = Array.isArray(rootIds) ? [...rootIds] : [rootIds];
  const ids = [];

  // Add the descendants of the root blocks first.
  for (const rootId of rootIds) {
    const order = state.blocks.order.get(rootId);
    if (order) {
      ids.push(...order);
    }
  }
  let index = 0;

  // Add the descendants of the descendants, recursively.
  while (index < ids.length) {
    const id = ids[index];
    const order = state.blocks.order.get(id);
    if (order) {
      ids.splice(index + 1, 0, ...order);
    }
    index++;
  }
  return ids;
}, state => [state.blocks.order]);

/**
 * Returns an array containing the clientIds of the top-level blocks and
 * their descendants of any depth (for nested blocks). Ids are returned
 * in the same order that they appear in the editor.
 *
 * @param {Object} state Global application state.
 *
 * @return {Array} ids of top-level and descendant blocks.
 */
const getClientIdsWithDescendants = state => getClientIdsOfDescendants(state, '');

/**
 * Returns the total number of blocks, or the total number of blocks with a specific name in a post.
 * The number returned includes nested blocks.
 *
 * @param {Object}  state     Global application state.
 * @param {?string} blockName Optional block name, if specified only blocks of that type will be counted.
 *
 * @return {number} Number of blocks in the post, or number of blocks with name equal to blockName.
 */
const getGlobalBlockCount = (0,external_wp_data_namespaceObject.createSelector)((state, blockName) => {
  const clientIds = getClientIdsWithDescendants(state);
  if (!blockName) {
    return clientIds.length;
  }
  let count = 0;
  for (const clientId of clientIds) {
    const block = state.blocks.byClientId.get(clientId);
    if (block.name === blockName) {
      count++;
    }
  }
  return count;
}, state => [state.blocks.order, state.blocks.byClientId]);

/**
 * Returns all blocks that match a blockName. Results include nested blocks.
 *
 * @param {Object}  state     Global application state.
 * @param {?string} blockName Optional block name, if not specified, returns an empty array.
 *
 * @return {Array} Array of clientIds of blocks with name equal to blockName.
 */
const getBlocksByName = (0,external_wp_data_namespaceObject.createSelector)((state, blockName) => {
  if (!blockName) {
    return selectors_EMPTY_ARRAY;
  }
  const blockNames = Array.isArray(blockName) ? blockName : [blockName];
  const clientIds = getClientIdsWithDescendants(state);
  const foundBlocks = clientIds.filter(clientId => {
    const block = state.blocks.byClientId.get(clientId);
    return blockNames.includes(block.name);
  });
  return foundBlocks.length > 0 ? foundBlocks : selectors_EMPTY_ARRAY;
}, state => [state.blocks.order, state.blocks.byClientId]);

/**
 * Returns all global blocks that match a blockName. Results include nested blocks.
 *
 * @deprecated
 *
 * @param {Object}  state     Global application state.
 * @param {?string} blockName Optional block name, if not specified, returns an empty array.
 *
 * @return {Array} Array of clientIds of blocks with name equal to blockName.
 */
function __experimentalGetGlobalBlocksByName(state, blockName) {
  external_wp_deprecated_default()("wp.data.select( 'core/block-editor' ).__experimentalGetGlobalBlocksByName", {
    since: '6.5',
    alternative: `wp.data.select( 'core/block-editor' ).getBlocksByName`
  });
  return getBlocksByName(state, blockName);
}

/**
 * Given an array of block client IDs, returns the corresponding array of block
 * objects.
 *
 * @param {Object}   state     Editor state.
 * @param {string[]} clientIds Client IDs for which blocks are to be returned.
 *
 * @return {WPBlock[]} Block objects.
 */
const getBlocksByClientId = (0,external_wp_data_namespaceObject.createSelector)((state, clientIds) => (Array.isArray(clientIds) ? clientIds : [clientIds]).map(clientId => getBlock(state, clientId)), (state, clientIds) => (Array.isArray(clientIds) ? clientIds : [clientIds]).map(clientId => state.blocks.tree.get(clientId)));

/**
 * Given an array of block client IDs, returns the corresponding array of block
 * names.
 *
 * @param {Object}   state     Editor state.
 * @param {string[]} clientIds Client IDs for which block names are to be returned.
 *
 * @return {string[]} Block names.
 */
const getBlockNamesByClientId = (0,external_wp_data_namespaceObject.createSelector)((state, clientIds) => getBlocksByClientId(state, clientIds).filter(Boolean).map(block => block.name), (state, clientIds) => getBlocksByClientId(state, clientIds));

/**
 * Returns the number of blocks currently present in the post.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {number} Number of blocks in the post.
 */
function getBlockCount(state, rootClientId) {
  return getBlockOrder(state, rootClientId).length;
}

/**
 * Returns the current selection start block client ID, attribute key and text
 * offset.
 *
 * @param {Object} state Block editor state.
 *
 * @return {WPBlockSelection} Selection start information.
 */
function getSelectionStart(state) {
  return state.selection.selectionStart;
}

/**
 * Returns the current selection end block client ID, attribute key and text
 * offset.
 *
 * @param {Object} state Block editor state.
 *
 * @return {WPBlockSelection} Selection end information.
 */
function getSelectionEnd(state) {
  return state.selection.selectionEnd;
}

/**
 * Returns the current block selection start. This value may be null, and it
 * may represent either a singular block selection or multi-selection start.
 * A selection is singular if its start and end match.
 *
 * @param {Object} state Global application state.
 *
 * @return {?string} Client ID of block selection start.
 */
function getBlockSelectionStart(state) {
  return state.selection.selectionStart.clientId;
}

/**
 * Returns the current block selection end. This value may be null, and it
 * may represent either a singular block selection or multi-selection end.
 * A selection is singular if its start and end match.
 *
 * @param {Object} state Global application state.
 *
 * @return {?string} Client ID of block selection end.
 */
function getBlockSelectionEnd(state) {
  return state.selection.selectionEnd.clientId;
}

/**
 * Returns the number of blocks currently selected in the post.
 *
 * @param {Object} state Global application state.
 *
 * @return {number} Number of blocks selected in the post.
 */
function getSelectedBlockCount(state) {
  const multiSelectedBlockCount = getMultiSelectedBlockClientIds(state).length;
  if (multiSelectedBlockCount) {
    return multiSelectedBlockCount;
  }
  return state.selection.selectionStart.clientId ? 1 : 0;
}

/**
 * Returns true if there is a single selected block, or false otherwise.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether a single block is selected.
 */
function hasSelectedBlock(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  return !!selectionStart.clientId && selectionStart.clientId === selectionEnd.clientId;
}

/**
 * Returns the currently selected block client ID, or null if there is no
 * selected block.
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Selected block client ID.
 */
function getSelectedBlockClientId(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  const {
    clientId
  } = selectionStart;
  if (!clientId || clientId !== selectionEnd.clientId) {
    return null;
  }
  return clientId;
}

/**
 * Returns the currently selected block, or null if there is no selected block.
 *
 * @param {Object} state Global application state.
 *
 * @return {?Object} Selected block.
 */
function getSelectedBlock(state) {
  const clientId = getSelectedBlockClientId(state);
  return clientId ? getBlock(state, clientId) : null;
}

/**
 * Given a block client ID, returns the root block from which the block is
 * nested, an empty string for top-level blocks, or null if the block does not
 * exist.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block from which to find root client ID.
 *
 * @return {?string} Root client ID, if exists
 */
function getBlockRootClientId(state, clientId) {
  var _state$blocks$parents;
  return (_state$blocks$parents = state.blocks.parents.get(clientId)) !== null && _state$blocks$parents !== void 0 ? _state$blocks$parents : null;
}

/**
 * Given a block client ID, returns the list of all its parents from top to bottom.
 *
 * @param {Object}  state     Editor state.
 * @param {string}  clientId  Block from which to find root client ID.
 * @param {boolean} ascending Order results from bottom to top (true) or top to bottom (false).
 *
 * @return {Array} ClientIDs of the parent blocks.
 */
const getBlockParents = (0,external_wp_data_namespaceObject.createSelector)((state, clientId, ascending = false) => {
  const parents = [];
  let current = clientId;
  while (current = state.blocks.parents.get(current)) {
    parents.push(current);
  }
  if (!parents.length) {
    return selectors_EMPTY_ARRAY;
  }
  return ascending ? parents : parents.reverse();
}, state => [state.blocks.parents]);

/**
 * Given a block client ID and a block name, returns the list of all its parents
 * from top to bottom, filtered by the given name(s). For example, if passed
 * 'core/group' as the blockName, it will only return parents which are group
 * blocks. If passed `[ 'core/group', 'core/cover']`, as the blockName, it will
 * return parents which are group blocks and parents which are cover blocks.
 *
 * @param {Object}          state     Editor state.
 * @param {string}          clientId  Block from which to find root client ID.
 * @param {string|string[]} blockName Block name(s) to filter.
 * @param {boolean}         ascending Order results from bottom to top (true) or top to bottom (false).
 *
 * @return {Array} ClientIDs of the parent blocks.
 */
const getBlockParentsByBlockName = (0,external_wp_data_namespaceObject.createSelector)((state, clientId, blockName, ascending = false) => {
  const parents = getBlockParents(state, clientId, ascending);
  const hasName = Array.isArray(blockName) ? name => blockName.includes(name) : name => blockName === name;
  return parents.filter(id => hasName(getBlockName(state, id)));
}, state => [state.blocks.parents]);
/**
 * Given a block client ID, returns the root of the hierarchy from which the block is nested, return the block itself for root level blocks.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block from which to find root client ID.
 *
 * @return {string} Root client ID
 */
function getBlockHierarchyRootClientId(state, clientId) {
  let current = clientId;
  let parent;
  do {
    parent = current;
    current = state.blocks.parents.get(current);
  } while (current);
  return parent;
}

/**
 * Given a block client ID, returns the lowest common ancestor with selected client ID.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block from which to find common ancestor client ID.
 *
 * @return {string} Common ancestor client ID or undefined
 */
function getLowestCommonAncestorWithSelectedBlock(state, clientId) {
  const selectedId = getSelectedBlockClientId(state);
  const clientParents = [...getBlockParents(state, clientId), clientId];
  const selectedParents = [...getBlockParents(state, selectedId), selectedId];
  let lowestCommonAncestor;
  const maxDepth = Math.min(clientParents.length, selectedParents.length);
  for (let index = 0; index < maxDepth; index++) {
    if (clientParents[index] === selectedParents[index]) {
      lowestCommonAncestor = clientParents[index];
    } else {
      break;
    }
  }
  return lowestCommonAncestor;
}

/**
 * Returns the client ID of the block adjacent one at the given reference
 * startClientId and modifier directionality. Defaults start startClientId to
 * the selected block, and direction as next block. Returns null if there is no
 * adjacent block.
 *
 * @param {Object}  state         Editor state.
 * @param {?string} startClientId Optional client ID of block from which to
 *                                search.
 * @param {?number} modifier      Directionality multiplier (1 next, -1
 *                                previous).
 *
 * @return {?string} Return the client ID of the block, or null if none exists.
 */
function getAdjacentBlockClientId(state, startClientId, modifier = 1) {
  // Default to selected block.
  if (startClientId === undefined) {
    startClientId = getSelectedBlockClientId(state);
  }

  // Try multi-selection starting at extent based on modifier.
  if (startClientId === undefined) {
    if (modifier < 0) {
      startClientId = getFirstMultiSelectedBlockClientId(state);
    } else {
      startClientId = getLastMultiSelectedBlockClientId(state);
    }
  }

  // Validate working start client ID.
  if (!startClientId) {
    return null;
  }

  // Retrieve start block root client ID, being careful to allow the falsey
  // empty string top-level root by explicitly testing against null.
  const rootClientId = getBlockRootClientId(state, startClientId);
  if (rootClientId === null) {
    return null;
  }
  const {
    order
  } = state.blocks;
  const orderSet = order.get(rootClientId);
  const index = orderSet.indexOf(startClientId);
  const nextIndex = index + 1 * modifier;

  // Block was first in set and we're attempting to get previous.
  if (nextIndex < 0) {
    return null;
  }

  // Block was last in set and we're attempting to get next.
  if (nextIndex === orderSet.length) {
    return null;
  }

  // Assume incremented index is within the set.
  return orderSet[nextIndex];
}

/**
 * Returns the previous block's client ID from the given reference start ID.
 * Defaults start to the selected block. Returns null if there is no previous
 * block.
 *
 * @param {Object}  state         Editor state.
 * @param {?string} startClientId Optional client ID of block from which to
 *                                search.
 *
 * @return {?string} Adjacent block's client ID, or null if none exists.
 */
function getPreviousBlockClientId(state, startClientId) {
  return getAdjacentBlockClientId(state, startClientId, -1);
}

/**
 * Returns the next block's client ID from the given reference start ID.
 * Defaults start to the selected block. Returns null if there is no next
 * block.
 *
 * @param {Object}  state         Editor state.
 * @param {?string} startClientId Optional client ID of block from which to
 *                                search.
 *
 * @return {?string} Adjacent block's client ID, or null if none exists.
 */
function getNextBlockClientId(state, startClientId) {
  return getAdjacentBlockClientId(state, startClientId, 1);
}

/* eslint-disable jsdoc/valid-types */
/**
 * Returns the initial caret position for the selected block.
 * This position is to used to position the caret properly when the selected block changes.
 * If the current block is not a RichText, having initial position set to 0 means "focus block"
 *
 * @param {Object} state Global application state.
 *
 * @return {0|-1|null} Initial position.
 */
function getSelectedBlocksInitialCaretPosition(state) {
  /* eslint-enable jsdoc/valid-types */
  return state.initialPosition;
}

/**
 * Returns the current selection set of block client IDs (multiselection or single selection).
 *
 * @param {Object} state Editor state.
 *
 * @return {Array} Multi-selected block client IDs.
 */
const getSelectedBlockClientIds = (0,external_wp_data_namespaceObject.createSelector)(state => {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  if (!selectionStart.clientId || !selectionEnd.clientId) {
    return selectors_EMPTY_ARRAY;
  }
  if (selectionStart.clientId === selectionEnd.clientId) {
    return [selectionStart.clientId];
  }

  // Retrieve root client ID to aid in retrieving relevant nested block
  // order, being careful to allow the falsey empty string top-level root
  // by explicitly testing against null.
  const rootClientId = getBlockRootClientId(state, selectionStart.clientId);
  if (rootClientId === null) {
    return selectors_EMPTY_ARRAY;
  }
  const blockOrder = getBlockOrder(state, rootClientId);
  const startIndex = blockOrder.indexOf(selectionStart.clientId);
  const endIndex = blockOrder.indexOf(selectionEnd.clientId);
  if (startIndex > endIndex) {
    return blockOrder.slice(endIndex, startIndex + 1);
  }
  return blockOrder.slice(startIndex, endIndex + 1);
}, state => [state.blocks.order, state.selection.selectionStart.clientId, state.selection.selectionEnd.clientId]);

/**
 * Returns the current multi-selection set of block client IDs, or an empty
 * array if there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {Array} Multi-selected block client IDs.
 */
function getMultiSelectedBlockClientIds(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  if (selectionStart.clientId === selectionEnd.clientId) {
    return selectors_EMPTY_ARRAY;
  }
  return getSelectedBlockClientIds(state);
}

/**
 * Returns the current multi-selection set of blocks, or an empty array if
 * there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {Array} Multi-selected block objects.
 */
const getMultiSelectedBlocks = (0,external_wp_data_namespaceObject.createSelector)(state => {
  const multiSelectedBlockClientIds = getMultiSelectedBlockClientIds(state);
  if (!multiSelectedBlockClientIds.length) {
    return selectors_EMPTY_ARRAY;
  }
  return multiSelectedBlockClientIds.map(clientId => getBlock(state, clientId));
}, state => [...getSelectedBlockClientIds.getDependants(state), state.blocks.byClientId, state.blocks.order, state.blocks.attributes]);

/**
 * Returns the client ID of the first block in the multi-selection set, or null
 * if there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} First block client ID in the multi-selection set.
 */
function getFirstMultiSelectedBlockClientId(state) {
  return getMultiSelectedBlockClientIds(state)[0] || null;
}

/**
 * Returns the client ID of the last block in the multi-selection set, or null
 * if there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Last block client ID in the multi-selection set.
 */
function getLastMultiSelectedBlockClientId(state) {
  const selectedClientIds = getMultiSelectedBlockClientIds(state);
  return selectedClientIds[selectedClientIds.length - 1] || null;
}

/**
 * Returns true if a multi-selection exists, and the block corresponding to the
 * specified client ID is the first block of the multi-selection set, or false
 * otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is first in multi-selection.
 */
function isFirstMultiSelectedBlock(state, clientId) {
  return getFirstMultiSelectedBlockClientId(state) === clientId;
}

/**
 * Returns true if the client ID occurs within the block multi-selection, or
 * false otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is in multi-selection set.
 */
function isBlockMultiSelected(state, clientId) {
  return getMultiSelectedBlockClientIds(state).indexOf(clientId) !== -1;
}

/**
 * Returns true if an ancestor of the block is multi-selected, or false
 * otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether an ancestor of the block is in multi-selection
 *                   set.
 */
const isAncestorMultiSelected = (0,external_wp_data_namespaceObject.createSelector)((state, clientId) => {
  let ancestorClientId = clientId;
  let isMultiSelected = false;
  while (ancestorClientId && !isMultiSelected) {
    ancestorClientId = getBlockRootClientId(state, ancestorClientId);
    isMultiSelected = isBlockMultiSelected(state, ancestorClientId);
  }
  return isMultiSelected;
}, state => [state.blocks.order, state.selection.selectionStart.clientId, state.selection.selectionEnd.clientId]);

/**
 * Returns the client ID of the block which begins the multi-selection set, or
 * null if there is no multi-selection.
 *
 * This is not necessarily the first client ID in the selection.
 *
 * @see getFirstMultiSelectedBlockClientId
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Client ID of block beginning multi-selection.
 */
function getMultiSelectedBlocksStartClientId(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  if (selectionStart.clientId === selectionEnd.clientId) {
    return null;
  }
  return selectionStart.clientId || null;
}

/**
 * Returns the client ID of the block which ends the multi-selection set, or
 * null if there is no multi-selection.
 *
 * This is not necessarily the last client ID in the selection.
 *
 * @see getLastMultiSelectedBlockClientId
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Client ID of block ending multi-selection.
 */
function getMultiSelectedBlocksEndClientId(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  if (selectionStart.clientId === selectionEnd.clientId) {
    return null;
  }
  return selectionEnd.clientId || null;
}

/**
 * Returns true if the selection is not partial.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether the selection is mergeable.
 */
function __unstableIsFullySelected(state) {
  const selectionAnchor = getSelectionStart(state);
  const selectionFocus = getSelectionEnd(state);
  return !selectionAnchor.attributeKey && !selectionFocus.attributeKey && typeof selectionAnchor.offset === 'undefined' && typeof selectionFocus.offset === 'undefined';
}

/**
 * Returns true if the selection is collapsed.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether the selection is collapsed.
 */
function __unstableIsSelectionCollapsed(state) {
  const selectionAnchor = getSelectionStart(state);
  const selectionFocus = getSelectionEnd(state);
  return !!selectionAnchor && !!selectionFocus && selectionAnchor.clientId === selectionFocus.clientId && selectionAnchor.attributeKey === selectionFocus.attributeKey && selectionAnchor.offset === selectionFocus.offset;
}
function __unstableSelectionHasUnmergeableBlock(state) {
  return getSelectedBlockClientIds(state).some(clientId => {
    const blockName = getBlockName(state, clientId);
    const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockName);
    return !blockType.merge;
  });
}

/**
 * Check whether the selection is mergeable.
 *
 * @param {Object}  state     Editor state.
 * @param {boolean} isForward Whether to merge forwards.
 *
 * @return {boolean} Whether the selection is mergeable.
 */
function __unstableIsSelectionMergeable(state, isForward) {
  const selectionAnchor = getSelectionStart(state);
  const selectionFocus = getSelectionEnd(state);

  // It's not mergeable if the start and end are within the same block.
  if (selectionAnchor.clientId === selectionFocus.clientId) {
    return false;
  }

  // It's not mergeable if there's no rich text selection.
  if (!selectionAnchor.attributeKey || !selectionFocus.attributeKey || typeof selectionAnchor.offset === 'undefined' || typeof selectionFocus.offset === 'undefined') {
    return false;
  }
  const anchorRootClientId = getBlockRootClientId(state, selectionAnchor.clientId);
  const focusRootClientId = getBlockRootClientId(state, selectionFocus.clientId);

  // It's not mergeable if the selection doesn't start and end in the same
  // block list. Maybe in the future it should be allowed.
  if (anchorRootClientId !== focusRootClientId) {
    return false;
  }
  const blockOrder = getBlockOrder(state, anchorRootClientId);
  const anchorIndex = blockOrder.indexOf(selectionAnchor.clientId);
  const focusIndex = blockOrder.indexOf(selectionFocus.clientId);

  // Reassign selection start and end based on order.
  let selectionStart, selectionEnd;
  if (anchorIndex > focusIndex) {
    selectionStart = selectionFocus;
    selectionEnd = selectionAnchor;
  } else {
    selectionStart = selectionAnchor;
    selectionEnd = selectionFocus;
  }
  const targetBlockClientId = isForward ? selectionEnd.clientId : selectionStart.clientId;
  const blockToMergeClientId = isForward ? selectionStart.clientId : selectionEnd.clientId;
  const targetBlockName = getBlockName(state, targetBlockClientId);
  const targetBlockType = (0,external_wp_blocks_namespaceObject.getBlockType)(targetBlockName);
  if (!targetBlockType.merge) {
    return false;
  }
  const blockToMerge = getBlock(state, blockToMergeClientId);

  // It's mergeable if the blocks are of the same type.
  if (blockToMerge.name === targetBlockName) {
    return true;
  }

  // If the blocks are of a different type, try to transform the block being
  // merged into the same type of block.
  const blocksToMerge = (0,external_wp_blocks_namespaceObject.switchToBlockType)(blockToMerge, targetBlockName);
  return blocksToMerge && blocksToMerge.length;
}

/**
 * Get partial selected blocks with their content updated
 * based on the selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {Object[]} Updated partial selected blocks.
 */
const __unstableGetSelectedBlocksWithPartialSelection = state => {
  const selectionAnchor = getSelectionStart(state);
  const selectionFocus = getSelectionEnd(state);
  if (selectionAnchor.clientId === selectionFocus.clientId) {
    return selectors_EMPTY_ARRAY;
  }

  // Can't split if the selection is not set.
  if (!selectionAnchor.attributeKey || !selectionFocus.attributeKey || typeof selectionAnchor.offset === 'undefined' || typeof selectionFocus.offset === 'undefined') {
    return selectors_EMPTY_ARRAY;
  }
  const anchorRootClientId = getBlockRootClientId(state, selectionAnchor.clientId);
  const focusRootClientId = getBlockRootClientId(state, selectionFocus.clientId);

  // It's not splittable if the selection doesn't start and end in the same
  // block list. Maybe in the future it should be allowed.
  if (anchorRootClientId !== focusRootClientId) {
    return selectors_EMPTY_ARRAY;
  }
  const blockOrder = getBlockOrder(state, anchorRootClientId);
  const anchorIndex = blockOrder.indexOf(selectionAnchor.clientId);
  const focusIndex = blockOrder.indexOf(selectionFocus.clientId);

  // Reassign selection start and end based on order.
  const [selectionStart, selectionEnd] = anchorIndex > focusIndex ? [selectionFocus, selectionAnchor] : [selectionAnchor, selectionFocus];
  const blockA = getBlock(state, selectionStart.clientId);
  const blockB = getBlock(state, selectionEnd.clientId);
  const htmlA = blockA.attributes[selectionStart.attributeKey];
  const htmlB = blockB.attributes[selectionEnd.attributeKey];
  let valueA = (0,external_wp_richText_namespaceObject.create)({
    html: htmlA
  });
  let valueB = (0,external_wp_richText_namespaceObject.create)({
    html: htmlB
  });
  valueA = (0,external_wp_richText_namespaceObject.remove)(valueA, 0, selectionStart.offset);
  valueB = (0,external_wp_richText_namespaceObject.remove)(valueB, selectionEnd.offset, valueB.text.length);
  return [{
    ...blockA,
    attributes: {
      ...blockA.attributes,
      [selectionStart.attributeKey]: (0,external_wp_richText_namespaceObject.toHTMLString)({
        value: valueA
      })
    }
  }, {
    ...blockB,
    attributes: {
      ...blockB.attributes,
      [selectionEnd.attributeKey]: (0,external_wp_richText_namespaceObject.toHTMLString)({
        value: valueB
      })
    }
  }];
};

/**
 * Returns an array containing all block client IDs in the editor in the order
 * they appear. Optionally accepts a root client ID of the block list for which
 * the order should be returned, defaulting to the top-level block order.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Array} Ordered client IDs of editor blocks.
 */
function getBlockOrder(state, rootClientId) {
  return state.blocks.order.get(rootClientId || '') || selectors_EMPTY_ARRAY;
}

/**
 * Returns the index at which the block corresponding to the specified client
 * ID occurs within the block order, or `-1` if the block does not exist.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {number} Index at which block exists in order.
 */
function getBlockIndex(state, clientId) {
  const rootClientId = getBlockRootClientId(state, clientId);
  return getBlockOrder(state, rootClientId).indexOf(clientId);
}

/**
 * Returns true if the block corresponding to the specified client ID is
 * currently selected and no multi-selection exists, or false otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is selected and multi-selection exists.
 */
function isBlockSelected(state, clientId) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  if (selectionStart.clientId !== selectionEnd.clientId) {
    return false;
  }
  return selectionStart.clientId === clientId;
}

/**
 * Returns true if one of the block's inner blocks is selected.
 *
 * @param {Object}  state    Editor state.
 * @param {string}  clientId Block client ID.
 * @param {boolean} deep     Perform a deep check.
 *
 * @return {boolean} Whether the block has an inner block selected
 */
function hasSelectedInnerBlock(state, clientId, deep = false) {
  const selectedBlockClientIds = getSelectedBlockClientIds(state);
  if (!selectedBlockClientIds.length) {
    return false;
  }
  if (deep) {
    return selectedBlockClientIds.some(id =>
    // Pass true because we don't care about order and it's more
    // performant.
    getBlockParents(state, id, true).includes(clientId));
  }
  return selectedBlockClientIds.some(id => getBlockRootClientId(state, id) === clientId);
}

/**
 * Returns true if one of the block's inner blocks is dragged.
 *
 * @param {Object}  state    Editor state.
 * @param {string}  clientId Block client ID.
 * @param {boolean} deep     Perform a deep check.
 *
 * @return {boolean} Whether the block has an inner block dragged
 */
function hasDraggedInnerBlock(state, clientId, deep = false) {
  return getBlockOrder(state, clientId).some(innerClientId => isBlockBeingDragged(state, innerClientId) || deep && hasDraggedInnerBlock(state, innerClientId, deep));
}

/**
 * Returns true if the block corresponding to the specified client ID is
 * currently selected but isn't the last of the selected blocks. Here "last"
 * refers to the block sequence in the document, _not_ the sequence of
 * multi-selection, which is why `state.selectionEnd` isn't used.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is selected and not the last in the
 *                   selection.
 */
function isBlockWithinSelection(state, clientId) {
  if (!clientId) {
    return false;
  }
  const clientIds = getMultiSelectedBlockClientIds(state);
  const index = clientIds.indexOf(clientId);
  return index > -1 && index < clientIds.length - 1;
}

/**
 * Returns true if a multi-selection has been made, or false otherwise.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether multi-selection has been made.
 */
function hasMultiSelection(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  return selectionStart.clientId !== selectionEnd.clientId;
}

/**
 * Whether in the process of multi-selecting or not. This flag is only true
 * while the multi-selection is being selected (by mouse move), and is false
 * once the multi-selection has been settled.
 *
 * @see hasMultiSelection
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} True if multi-selecting, false if not.
 */
function selectors_isMultiSelecting(state) {
  return state.isMultiSelecting;
}

/**
 * Selector that returns if multi-selection is enabled or not.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} True if it should be possible to multi-select blocks, false if multi-selection is disabled.
 */
function selectors_isSelectionEnabled(state) {
  return state.isSelectionEnabled;
}

/**
 * Returns the block's editing mode, defaulting to "visual" if not explicitly
 * assigned.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {Object} Block editing mode.
 */
function getBlockMode(state, clientId) {
  return state.blocksMode[clientId] || 'visual';
}

/**
 * Returns true if the user is typing, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether user is typing.
 */
function selectors_isTyping(state) {
  return state.isTyping;
}

/**
 * Returns true if the user is dragging blocks, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether user is dragging blocks.
 */
function isDraggingBlocks(state) {
  return !!state.draggedBlocks.length;
}

/**
 * Returns the client ids of any blocks being directly dragged.
 *
 * This does not include children of a parent being dragged.
 *
 * @param {Object} state Global application state.
 *
 * @return {string[]} Array of dragged block client ids.
 */
function getDraggedBlockClientIds(state) {
  return state.draggedBlocks;
}

/**
 * Returns whether the block is being dragged.
 *
 * Only returns true if the block is being directly dragged,
 * not if the block is a child of a parent being dragged.
 * See `isAncestorBeingDragged` for child blocks.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId Client id for block to check.
 *
 * @return {boolean} Whether the block is being dragged.
 */
function isBlockBeingDragged(state, clientId) {
  return state.draggedBlocks.includes(clientId);
}

/**
 * Returns whether a parent/ancestor of the block is being dragged.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId Client id for block to check.
 *
 * @return {boolean} Whether the block's ancestor is being dragged.
 */
function isAncestorBeingDragged(state, clientId) {
  // Return early if no blocks are being dragged rather than
  // the more expensive check for parents.
  if (!isDraggingBlocks(state)) {
    return false;
  }
  const parents = getBlockParents(state, clientId);
  return parents.some(parentClientId => isBlockBeingDragged(state, parentClientId));
}

/**
 * Returns true if the caret is within formatted text, or false otherwise.
 *
 * @deprecated
 *
 * @return {boolean} Whether the caret is within formatted text.
 */
function isCaretWithinFormattedText() {
  external_wp_deprecated_default()('wp.data.select( "core/block-editor" ).isCaretWithinFormattedText', {
    since: '6.1',
    version: '6.3'
  });
  return false;
}

/**
 * Returns the insertion point, the index at which the new inserted block would
 * be placed. Defaults to the last index.
 *
 * @param {Object} state Editor state.
 *
 * @return {Object} Insertion point object with `rootClientId`, `index`.
 */
const getBlockInsertionPoint = (0,external_wp_data_namespaceObject.createSelector)(state => {
  let rootClientId, index;
  const {
    insertionPoint,
    selection: {
      selectionEnd
    }
  } = state;
  if (insertionPoint !== null) {
    return insertionPoint;
  }
  const {
    clientId
  } = selectionEnd;
  if (clientId) {
    rootClientId = getBlockRootClientId(state, clientId) || undefined;
    index = getBlockIndex(state, selectionEnd.clientId) + 1;
  } else {
    index = getBlockOrder(state).length;
  }
  return {
    rootClientId,
    index
  };
}, state => [state.insertionPoint, state.selection.selectionEnd.clientId, state.blocks.parents, state.blocks.order]);

/**
 * Returns true if we should show the block insertion point.
 *
 * @param {Object} state Global application state.
 *
 * @return {?boolean} Whether the insertion point is visible or not.
 */
function isBlockInsertionPointVisible(state) {
  return state.insertionPoint !== null;
}

/**
 * Returns whether the blocks matches the template or not.
 *
 * @param {boolean} state
 * @return {?boolean} Whether the template is valid or not.
 */
function isValidTemplate(state) {
  return state.template.isValid;
}

/**
 * Returns the defined block template
 *
 * @param {boolean} state
 *
 * @return {?Array} Block Template.
 */
function getTemplate(state) {
  return state.settings.template;
}

/**
 * Returns the defined block template lock. Optionally accepts a root block
 * client ID as context, otherwise defaulting to the global context.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional block root client ID.
 *
 * @return {string|false} Block Template Lock
 */
function getTemplateLock(state, rootClientId) {
  var _getBlockListSettings;
  if (!rootClientId) {
    var _state$settings$templ;
    return (_state$settings$templ = state.settings.templateLock) !== null && _state$settings$templ !== void 0 ? _state$settings$templ : false;
  }
  return (_getBlockListSettings = getBlockListSettings(state, rootClientId)?.templateLock) !== null && _getBlockListSettings !== void 0 ? _getBlockListSettings : false;
}

/**
 * Determines if the given block type is allowed to be inserted into the block list.
 * This function is not exported and not memoized because using a memoized selector
 * inside another memoized selector is just a waste of time.
 *
 * @param {Object}        state        Editor state.
 * @param {string|Object} blockName    The block type object, e.g., the response
 *                                     from the block directory; or a string name of
 *                                     an installed block type, e.g.' core/paragraph'.
 * @param {?string}       rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block type is allowed to be inserted.
 */
const canInsertBlockTypeUnmemoized = (state, blockName, rootClientId = null) => {
  let blockType;
  if (blockName && 'object' === typeof blockName) {
    blockType = blockName;
    blockName = blockType.name;
  } else {
    blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockName);
  }
  if (!blockType) {
    return false;
  }
  const {
    allowedBlockTypes
  } = getSettings(state);
  const isBlockAllowedInEditor = checkAllowList(allowedBlockTypes, blockName, true);
  if (!isBlockAllowedInEditor) {
    return false;
  }
  const isLocked = !!getTemplateLock(state, rootClientId);
  if (isLocked) {
    return false;
  }
  if (getBlockEditingMode(state, rootClientId !== null && rootClientId !== void 0 ? rootClientId : '') === 'disabled') {
    return false;
  }
  const parentBlockListSettings = getBlockListSettings(state, rootClientId);

  // The parent block doesn't have settings indicating it doesn't support
  // inner blocks, return false.
  if (rootClientId && parentBlockListSettings === undefined) {
    return false;
  }
  const parentName = getBlockName(state, rootClientId);
  const parentBlockType = (0,external_wp_blocks_namespaceObject.getBlockType)(parentName);

  // Look at the `blockType.allowedBlocks` field to determine whether this is an allowed child block.
  const parentAllowedChildBlocks = parentBlockType?.allowedBlocks;
  let hasParentAllowedBlock = checkAllowList(parentAllowedChildBlocks, blockName);

  // The `allowedBlocks` block list setting can further limit which blocks are allowed children.
  if (hasParentAllowedBlock !== false) {
    const parentAllowedBlocks = parentBlockListSettings?.allowedBlocks;
    const hasParentListAllowedBlock = checkAllowList(parentAllowedBlocks, blockName);
    // Never downgrade the result from `true` to `null`
    if (hasParentListAllowedBlock !== null) {
      hasParentAllowedBlock = hasParentListAllowedBlock;
    }
  }
  const blockAllowedParentBlocks = blockType.parent;
  const hasBlockAllowedParent = checkAllowList(blockAllowedParentBlocks, parentName);
  let hasBlockAllowedAncestor = true;
  const blockAllowedAncestorBlocks = blockType.ancestor;
  if (blockAllowedAncestorBlocks) {
    const ancestors = [rootClientId, ...getBlockParents(state, rootClientId)];
    hasBlockAllowedAncestor = ancestors.some(ancestorClientId => checkAllowList(blockAllowedAncestorBlocks, getBlockName(state, ancestorClientId)));
  }
  const canInsert = hasBlockAllowedAncestor && (hasParentAllowedBlock === null && hasBlockAllowedParent === null || hasParentAllowedBlock === true || hasBlockAllowedParent === true);
  if (!canInsert) {
    return canInsert;
  }

  /**
   * This filter is an ad-hoc solution to prevent adding template parts inside post content.
   * Conceptually, having a filter inside a selector is bad pattern so this code will be
   * replaced by a declarative API that doesn't the following drawbacks:
   *
   * Filters are not reactive: Upon switching between "template mode" and non "template mode",
   * the filter and selector won't necessarily be executed again. For now, it doesn't matter much
   * because you can't switch between the two modes while the inserter stays open.
   *
   * Filters are global: Once they're defined, they will affect all editor instances and all registries.
   * An ideal API would only affect specific editor instances.
   */
  return (0,external_wp_hooks_namespaceObject.applyFilters)('blockEditor.__unstableCanInsertBlockType', canInsert, blockType, rootClientId, {
    // Pass bound selectors of the current registry. If we're in a nested
    // context, the data will differ from the one selected from the root
    // registry.
    getBlock: getBlock.bind(null, state),
    getBlockParentsByBlockName: getBlockParentsByBlockName.bind(null, state)
  });
};

/**
 * Determines if the given block type is allowed to be inserted into the block list.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  blockName    The name of the block type, e.g.' core/paragraph'.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block type is allowed to be inserted.
 */
const canInsertBlockType = (0,external_wp_data_namespaceObject.createSelector)(canInsertBlockTypeUnmemoized, (state, blockName, rootClientId) => getInsertBlockTypeDependants(state, rootClientId));

/**
 * Determines if the given blocks are allowed to be inserted into the block
 * list.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientIds    The block client IDs to be inserted.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given blocks are allowed to be inserted.
 */
function canInsertBlocks(state, clientIds, rootClientId = null) {
  return clientIds.every(id => canInsertBlockType(state, getBlockName(state, id), rootClientId));
}

/**
 * Determines if the given block is allowed to be deleted.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientId     The block client Id.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block is allowed to be removed.
 */
function canRemoveBlock(state, clientId, rootClientId = null) {
  const attributes = getBlockAttributes(state, clientId);
  if (attributes === null) {
    return true;
  }
  if (attributes.lock?.remove !== undefined) {
    return !attributes.lock.remove;
  }
  if (getTemplateLock(state, rootClientId)) {
    return false;
  }
  return getBlockEditingMode(state, rootClientId) !== 'disabled';
}

/**
 * Determines if the given blocks are allowed to be removed.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientIds    The block client IDs to be removed.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given blocks are allowed to be removed.
 */
function canRemoveBlocks(state, clientIds, rootClientId = null) {
  return clientIds.every(clientId => canRemoveBlock(state, clientId, rootClientId));
}

/**
 * Determines if the given block is allowed to be moved.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientId     The block client Id.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean | undefined} Whether the given block is allowed to be moved.
 */
function canMoveBlock(state, clientId, rootClientId = null) {
  const attributes = getBlockAttributes(state, clientId);
  if (attributes === null) {
    return true;
  }
  if (attributes.lock?.move !== undefined) {
    return !attributes.lock.move;
  }
  if (getTemplateLock(state, rootClientId) === 'all') {
    return false;
  }
  return getBlockEditingMode(state, rootClientId) !== 'disabled';
}

/**
 * Determines if the given blocks are allowed to be moved.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientIds    The block client IDs to be moved.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given blocks are allowed to be moved.
 */
function canMoveBlocks(state, clientIds, rootClientId = null) {
  return clientIds.every(clientId => canMoveBlock(state, clientId, rootClientId));
}

/**
 * Determines if the given block is allowed to be edited.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId The block client Id.
 *
 * @return {boolean} Whether the given block is allowed to be edited.
 */
function canEditBlock(state, clientId) {
  const attributes = getBlockAttributes(state, clientId);
  if (attributes === null) {
    return true;
  }
  const {
    lock
  } = attributes;

  // When the edit is true, we cannot edit the block.
  return !lock?.edit;
}

/**
 * Determines if the given block type can be locked/unlocked by a user.
 *
 * @param {Object}          state      Editor state.
 * @param {(string|Object)} nameOrType Block name or type object.
 *
 * @return {boolean} Whether a given block type can be locked/unlocked.
 */
function canLockBlockType(state, nameOrType) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(nameOrType, 'lock', true)) {
    return false;
  }

  // Use block editor settings as the default value.
  return !!state.settings?.canLockBlocks;
}

/**
 * Returns information about how recently and frequently a block has been inserted.
 *
 * @param {Object} state Global application state.
 * @param {string} id    A string which identifies the insert, e.g. 'core/block/12'
 *
 * @return {?{ time: number, count: number }} An object containing `time` which is when the last
 *                                            insert occurred as a UNIX epoch, and `count` which is
 *                                            the number of inserts that have occurred.
 */
function getInsertUsage(state, id) {
  var _state$preferences$in;
  return (_state$preferences$in = state.preferences.insertUsage?.[id]) !== null && _state$preferences$in !== void 0 ? _state$preferences$in : null;
}

/**
 * Returns whether we can show a block type in the inserter
 *
 * @param {Object}  state        Global State
 * @param {Object}  blockType    BlockType
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block type is allowed to be shown in the inserter.
 */
const canIncludeBlockTypeInInserter = (state, blockType, rootClientId) => {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'inserter', true)) {
    return false;
  }
  return canInsertBlockTypeUnmemoized(state, blockType.name, rootClientId);
};

/**
 * Return a function to be used to tranform a block variation to an inserter item
 *
 * @param {Object} state Global State
 * @param {Object} item  Denormalized inserter item
 * @return {Function} Function to transform a block variation to inserter item
 */
const getItemFromVariation = (state, item) => variation => {
  const variationId = `${item.id}/${variation.name}`;
  const {
    time,
    count = 0
  } = getInsertUsage(state, variationId) || {};
  return {
    ...item,
    id: variationId,
    icon: variation.icon || item.icon,
    title: variation.title || item.title,
    description: variation.description || item.description,
    category: variation.category || item.category,
    // If `example` is explicitly undefined for the variation, the preview will not be shown.
    example: variation.hasOwnProperty('example') ? variation.example : item.example,
    initialAttributes: {
      ...item.initialAttributes,
      ...variation.attributes
    },
    innerBlocks: variation.innerBlocks,
    keywords: variation.keywords || item.keywords,
    frecency: calculateFrecency(time, count)
  };
};

/**
 * Returns the calculated frecency.
 *
 * 'frecency' is a heuristic (https://en.wikipedia.org/wiki/Frecency)
 * that combines block usage frequenty and recency.
 *
 * @param {number} time  When the last insert occurred as a UNIX epoch
 * @param {number} count The number of inserts that have occurred.
 *
 * @return {number} The calculated frecency.
 */
const calculateFrecency = (time, count) => {
  if (!time) {
    return count;
  }
  // The selector is cached, which means Date.now() is the last time that the
  // relevant state changed. This suits our needs.
  const duration = Date.now() - time;
  switch (true) {
    case duration < MILLISECONDS_PER_HOUR:
      return count * 4;
    case duration < MILLISECONDS_PER_DAY:
      return count * 2;
    case duration < MILLISECONDS_PER_WEEK:
      return count / 2;
    default:
      return count / 4;
  }
};

/**
 * Returns a function that accepts a block type and builds an item to be shown
 * in a specific context. It's used for building items for Inserter and available
 * block Transfroms list.
 *
 * @param {Object} state              Editor state.
 * @param {Object} options            Options object for handling the building of a block type.
 * @param {string} options.buildScope The scope for which the item is going to be used.
 * @return {Function} Function returns an item to be shown in a specific context (Inserter|Transforms list).
 */
const buildBlockTypeItem = (state, {
  buildScope = 'inserter'
}) => blockType => {
  const id = blockType.name;
  let isDisabled = false;
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType.name, 'multiple', true)) {
    isDisabled = getBlocksByClientId(state, getClientIdsWithDescendants(state)).some(({
      name
    }) => name === blockType.name);
  }
  const {
    time,
    count = 0
  } = getInsertUsage(state, id) || {};
  const blockItemBase = {
    id,
    name: blockType.name,
    title: blockType.title,
    icon: blockType.icon,
    isDisabled,
    frecency: calculateFrecency(time, count)
  };
  if (buildScope === 'transform') {
    return blockItemBase;
  }
  const inserterVariations = (0,external_wp_blocks_namespaceObject.getBlockVariations)(blockType.name, 'inserter');
  return {
    ...blockItemBase,
    initialAttributes: {},
    description: blockType.description,
    category: blockType.category,
    keywords: blockType.keywords,
    variations: inserterVariations,
    example: blockType.example,
    utility: 1 // Deprecated.
  };
};

/**
 * Determines the items that appear in the inserter. Includes both static
 * items (e.g. a regular block type) and dynamic items (e.g. a reusable block).
 *
 * Each item object contains what's necessary to display a button in the
 * inserter and handle its selection.
 *
 * The 'frecency' property is a heuristic (https://en.wikipedia.org/wiki/Frecency)
 * that combines block usage frequenty and recency.
 *
 * Items are returned ordered descendingly by their 'utility' and 'frecency'.
 *
 * @param    {Object}   state             Editor state.
 * @param    {?string}  rootClientId      Optional root client ID of block list.
 *
 * @return {WPEditorInserterItem[]} Items that appear in inserter.
 *
 * @typedef {Object} WPEditorInserterItem
 * @property {string}   id                Unique identifier for the item.
 * @property {string}   name              The type of block to create.
 * @property {Object}   initialAttributes Attributes to pass to the newly created block.
 * @property {string}   title             Title of the item, as it appears in the inserter.
 * @property {string}   icon              Dashicon for the item, as it appears in the inserter.
 * @property {string}   category          Block category that the item is associated with.
 * @property {string[]} keywords          Keywords that can be searched to find this item.
 * @property {boolean}  isDisabled        Whether or not the user should be prevented from inserting
 *                                        this item.
 * @property {number}   frecency          Heuristic that combines frequency and recency.
 */
const getInserterItems = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (0,external_wp_data_namespaceObject.createSelector)((state, rootClientId = null, options = {}) => {
  const buildReusableBlockInserterItem = reusableBlock => {
    const icon = !reusableBlock.wp_pattern_sync_status ? {
      src: library_symbol,
      foreground: 'var(--wp-block-synced-color)'
    } : library_symbol;
    const id = `core/block/${reusableBlock.id}`;
    const {
      time,
      count = 0
    } = getInsertUsage(state, id) || {};
    const frecency = calculateFrecency(time, count);
    return {
      id,
      name: 'core/block',
      initialAttributes: {
        ref: reusableBlock.id
      },
      title: reusableBlock.title?.raw,
      icon,
      category: 'reusable',
      keywords: ['reusable'],
      isDisabled: false,
      utility: 1,
      // Deprecated.
      frecency,
      content: reusableBlock.content?.raw,
      syncStatus: reusableBlock.wp_pattern_sync_status
    };
  };
  const syncedPatternInserterItems = canInsertBlockTypeUnmemoized(state, 'core/block', rootClientId) ? unlock(select(STORE_NAME)).getReusableBlocks().map(buildReusableBlockInserterItem) : [];
  const buildBlockTypeInserterItem = buildBlockTypeItem(state, {
    buildScope: 'inserter'
  });
  let blockTypeInserterItems = (0,external_wp_blocks_namespaceObject.getBlockTypes)().filter(blockType => (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'inserter', true)).map(buildBlockTypeInserterItem);
  if (options[withRootClientIdOptionKey]) {
    blockTypeInserterItems = blockTypeInserterItems.reduce((accumulator, item) => {
      item.rootClientId = rootClientId !== null && rootClientId !== void 0 ? rootClientId : '';
      while (!canInsertBlockTypeUnmemoized(state, item.name, item.rootClientId)) {
        if (!item.rootClientId) {
          let sectionRootClientId;
          try {
            sectionRootClientId = unlock(getSettings(state)).sectionRootClientId;
          } catch (e) {}
          if (sectionRootClientId && canInsertBlockTypeUnmemoized(state, item.name, sectionRootClientId)) {
            item.rootClientId = sectionRootClientId;
          } else {
            delete item.rootClientId;
          }
          break;
        } else {
          const parentClientId = getBlockRootClientId(state, item.rootClientId);
          item.rootClientId = parentClientId;
        }
      }

      // We could also add non insertable items and gray them out.
      if (item.hasOwnProperty('rootClientId')) {
        accumulator.push(item);
      }
      return accumulator;
    }, []);
  } else {
    blockTypeInserterItems = blockTypeInserterItems.filter(blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId));
  }
  const items = blockTypeInserterItems.reduce((accumulator, item) => {
    const {
      variations = []
    } = item;
    // Exclude any block type item that is to be replaced by a default variation.
    if (!variations.some(({
      isDefault
    }) => isDefault)) {
      accumulator.push(item);
    }
    if (variations.length) {
      const variationMapper = getItemFromVariation(state, item);
      accumulator.push(...variations.map(variationMapper));
    }
    return accumulator;
  }, []);

  // Ensure core blocks are prioritized in the returned results,
  // because third party blocks can be registered earlier than
  // the core blocks (usually by using the `init` action),
  // thus affecting the display order.
  // We don't sort reusable blocks as they are handled differently.
  const groupByType = (blocks, block) => {
    const {
      core,
      noncore
    } = blocks;
    const type = block.name.startsWith('core/') ? core : noncore;
    type.push(block);
    return blocks;
  };
  const {
    core: coreItems,
    noncore: nonCoreItems
  } = items.reduce(groupByType, {
    core: [],
    noncore: []
  });
  const sortedBlockTypes = [...coreItems, ...nonCoreItems];
  return [...sortedBlockTypes, ...syncedPatternInserterItems];
}, (state, rootClientId) => [(0,external_wp_blocks_namespaceObject.getBlockTypes)(), unlock(select(STORE_NAME)).getReusableBlocks(), state.blocks.order, state.preferences.insertUsage, ...getInsertBlockTypeDependants(state, rootClientId)]));

/**
 * Determines the items that appear in the available block transforms list.
 *
 * Each item object contains what's necessary to display a menu item in the
 * transform list and handle its selection.
 *
 * The 'frecency' property is a heuristic (https://en.wikipedia.org/wiki/Frecency)
 * that combines block usage frequenty and recency.
 *
 * Items are returned ordered descendingly by their 'frecency'.
 *
 * @param    {Object}          state        Editor state.
 * @param    {Object|Object[]} blocks       Block object or array objects.
 * @param    {?string}         rootClientId Optional root client ID of block list.
 *
 * @return {WPEditorTransformItem[]} Items that appear in inserter.
 *
 * @typedef {Object} WPEditorTransformItem
 * @property {string}          id           Unique identifier for the item.
 * @property {string}          name         The type of block to create.
 * @property {string}          title        Title of the item, as it appears in the inserter.
 * @property {string}          icon         Dashicon for the item, as it appears in the inserter.
 * @property {boolean}         isDisabled   Whether or not the user should be prevented from inserting
 *                                          this item.
 * @property {number}          frecency     Heuristic that combines frequency and recency.
 */
const getBlockTransformItems = (0,external_wp_data_namespaceObject.createSelector)((state, blocks, rootClientId = null) => {
  const normalizedBlocks = Array.isArray(blocks) ? blocks : [blocks];
  const buildBlockTypeTransformItem = buildBlockTypeItem(state, {
    buildScope: 'transform'
  });
  const blockTypeTransformItems = (0,external_wp_blocks_namespaceObject.getBlockTypes)().filter(blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId)).map(buildBlockTypeTransformItem);
  const itemsByName = Object.fromEntries(Object.entries(blockTypeTransformItems).map(([, value]) => [value.name, value]));
  const possibleTransforms = (0,external_wp_blocks_namespaceObject.getPossibleBlockTransformations)(normalizedBlocks).reduce((accumulator, block) => {
    if (itemsByName[block?.name]) {
      accumulator.push(itemsByName[block.name]);
    }
    return accumulator;
  }, []);
  return orderBy(possibleTransforms, block => itemsByName[block.name].frecency, 'desc');
}, (state, blocks, rootClientId) => [(0,external_wp_blocks_namespaceObject.getBlockTypes)(), state.preferences.insertUsage, ...getInsertBlockTypeDependants(state, rootClientId)]);

/**
 * Determines whether there are items to show in the inserter.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Items that appear in inserter.
 */
const hasInserterItems = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (state, rootClientId = null) => {
  const hasBlockType = (0,external_wp_blocks_namespaceObject.getBlockTypes)().some(blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId));
  if (hasBlockType) {
    return true;
  }
  const hasReusableBlock = canInsertBlockTypeUnmemoized(state, 'core/block', rootClientId) && unlock(select(STORE_NAME)).getReusableBlocks().length > 0;
  return hasReusableBlock;
});

/**
 * Returns the list of allowed inserter blocks for inner blocks children.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Array?} The list of allowed block types.
 */
const getAllowedBlocks = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (0,external_wp_data_namespaceObject.createSelector)((state, rootClientId = null) => {
  if (!rootClientId) {
    return;
  }
  const blockTypes = (0,external_wp_blocks_namespaceObject.getBlockTypes)().filter(blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId));
  const hasReusableBlock = canInsertBlockTypeUnmemoized(state, 'core/block', rootClientId) && unlock(select(STORE_NAME)).getReusableBlocks().length > 0;
  if (hasReusableBlock) {
    blockTypes.push('core/block');
  }
  return blockTypes;
}, (state, rootClientId) => [(0,external_wp_blocks_namespaceObject.getBlockTypes)(), unlock(select(STORE_NAME)).getReusableBlocks(), ...getInsertBlockTypeDependants(state, rootClientId)]));
const __experimentalGetAllowedBlocks = (0,external_wp_data_namespaceObject.createSelector)((state, rootClientId = null) => {
  external_wp_deprecated_default()('wp.data.select( "core/block-editor" ).__experimentalGetAllowedBlocks', {
    alternative: 'wp.data.select( "core/block-editor" ).getAllowedBlocks',
    since: '6.2',
    version: '6.4'
  });
  return getAllowedBlocks(state, rootClientId);
}, (state, rootClientId) => getAllowedBlocks.getDependants(state, rootClientId));

/**
 * Returns the block to be directly inserted by the block appender.
 *
 * @param    {Object}         state            Editor state.
 * @param    {?string}        rootClientId     Optional root client ID of block list.
 *
 * @return {WPDirectInsertBlock|undefined}              The block type to be directly inserted.
 *
 * @typedef {Object} WPDirectInsertBlock
 * @property {string}         name             The type of block.
 * @property {?Object}        attributes       Attributes to pass to the newly created block.
 * @property {?Array<string>} attributesToCopy Attributes to be copied from adjecent blocks when inserted.
 */
function getDirectInsertBlock(state, rootClientId = null) {
  var _state$blockListSetti;
  if (!rootClientId) {
    return;
  }
  const {
    defaultBlock,
    directInsert
  } = (_state$blockListSetti = state.blockListSettings[rootClientId]) !== null && _state$blockListSetti !== void 0 ? _state$blockListSetti : {};
  if (!defaultBlock || !directInsert) {
    return;
  }
  return defaultBlock;
}
function __experimentalGetDirectInsertBlock(state, rootClientId = null) {
  external_wp_deprecated_default()('wp.data.select( "core/block-editor" ).__experimentalGetDirectInsertBlock', {
    alternative: 'wp.data.select( "core/block-editor" ).getDirectInsertBlock',
    since: '6.3',
    version: '6.4'
  });
  return getDirectInsertBlock(state, rootClientId);
}
const __experimentalGetParsedPattern = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (0,external_wp_data_namespaceObject.createSelector)((state, patternName) => {
  const pattern = unlock(select(STORE_NAME)).getPatternBySlug(patternName);
  if (!pattern) {
    return null;
  }
  const blocks = (0,external_wp_blocks_namespaceObject.parse)(pattern.content, {
    __unstableSkipMigrationLogs: true
  });
  if (blocks.length === 1) {
    blocks[0].attributes = {
      ...blocks[0].attributes,
      metadata: {
        ...(blocks[0].attributes.metadata || {}),
        categories: pattern.categories,
        patternName: pattern.name,
        name: blocks[0].attributes.metadata?.name || pattern.title
      }
    };
  }
  return {
    ...pattern,
    blocks
  };
}, (state, patternName) => [unlock(select(STORE_NAME)).getPatternBySlug(patternName)]));
const getAllowedPatternsDependants = select => (state, rootClientId) => [...getAllPatternsDependants(select)(state), ...getInsertBlockTypeDependants(state, rootClientId)];

/**
 * Returns the list of allowed patterns for inner blocks children.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional target root client ID.
 *
 * @return {Array?} The list of allowed patterns.
 */
const __experimentalGetAllowedPatterns = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => {
  return (0,external_wp_data_namespaceObject.createSelector)((state, rootClientId = null) => {
    const {
      getAllPatterns,
      __experimentalGetParsedPattern: getParsedPattern
    } = unlock(select(STORE_NAME));
    const patterns = getAllPatterns();
    const {
      allowedBlockTypes
    } = getSettings(state);
    const parsedPatterns = patterns.filter(({
      inserter = true
    }) => !!inserter).map(({
      name
    }) => getParsedPattern(name));
    const availableParsedPatterns = parsedPatterns.filter(({
      blocks
    }) => checkAllowListRecursive(blocks, allowedBlockTypes));
    const patternsAllowed = availableParsedPatterns.filter(({
      blocks
    }) => blocks.every(({
      name
    }) => canInsertBlockType(state, name, rootClientId)));
    return patternsAllowed;
  }, getAllowedPatternsDependants(select));
});

/**
 * Returns the list of patterns based on their declared `blockTypes`
 * and a block's name.
 * Patterns can use `blockTypes` to integrate in work flows like
 * suggesting appropriate patterns in a Placeholder state(during insertion)
 * or blocks transformations.
 *
 * @param {Object}          state        Editor state.
 * @param {string|string[]} blockNames   Block's name or array of block names to find matching pattens.
 * @param {?string}         rootClientId Optional target root client ID.
 *
 * @return {Array} The list of matched block patterns based on declared `blockTypes` and block name.
 */
const getPatternsByBlockTypes = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (0,external_wp_data_namespaceObject.createSelector)((state, blockNames, rootClientId = null) => {
  if (!blockNames) {
    return selectors_EMPTY_ARRAY;
  }
  const patterns = select(STORE_NAME).__experimentalGetAllowedPatterns(rootClientId);
  const normalizedBlockNames = Array.isArray(blockNames) ? blockNames : [blockNames];
  const filteredPatterns = patterns.filter(pattern => pattern?.blockTypes?.some?.(blockName => normalizedBlockNames.includes(blockName)));
  if (filteredPatterns.length === 0) {
    return selectors_EMPTY_ARRAY;
  }
  return filteredPatterns;
}, (state, blockNames, rootClientId) => getAllowedPatternsDependants(select)(state, rootClientId)));
const __experimentalGetPatternsByBlockTypes = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => {
  external_wp_deprecated_default()('wp.data.select( "core/block-editor" ).__experimentalGetPatternsByBlockTypes', {
    alternative: 'wp.data.select( "core/block-editor" ).getPatternsByBlockTypes',
    since: '6.2',
    version: '6.4'
  });
  return select(STORE_NAME).getPatternsByBlockTypes;
});

/**
 * Determines the items that appear in the available pattern transforms list.
 *
 * For now we only handle blocks without InnerBlocks and take into account
 * the `__experimentalRole` property of blocks' attributes for the transformation.
 *
 * We return the first set of possible eligible block patterns,
 * by checking the `blockTypes` property. We still have to recurse through
 * block pattern's blocks and try to find matches from the selected blocks.
 * Now this happens in the consumer to avoid heavy operations in the selector.
 *
 * @param {Object}   state        Editor state.
 * @param {Object[]} blocks       The selected blocks.
 * @param {?string}  rootClientId Optional root client ID of block list.
 *
 * @return {WPBlockPattern[]} Items that are eligible for a pattern transformation.
 */
const __experimentalGetPatternTransformItems = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (0,external_wp_data_namespaceObject.createSelector)((state, blocks, rootClientId = null) => {
  if (!blocks) {
    return selectors_EMPTY_ARRAY;
  }
  /**
   * For now we only handle blocks without InnerBlocks and take into account
   * the `__experimentalRole` property of blocks' attributes for the transformation.
   * Note that the blocks have been retrieved through `getBlock`, which doesn't
   * return the inner blocks of an inner block controller, so we still need
   * to check for this case too.
   */
  if (blocks.some(({
    clientId,
    innerBlocks
  }) => innerBlocks.length || areInnerBlocksControlled(state, clientId))) {
    return selectors_EMPTY_ARRAY;
  }

  // Create a Set of the selected block names that is used in patterns filtering.
  const selectedBlockNames = Array.from(new Set(blocks.map(({
    name
  }) => name)));
  /**
   * Here we will return first set of possible eligible block patterns,
   * by checking the `blockTypes` property. We still have to recurse through
   * block pattern's blocks and try to find matches from the selected blocks.
   * Now this happens in the consumer to avoid heavy operations in the selector.
   */
  return select(STORE_NAME).getPatternsByBlockTypes(selectedBlockNames, rootClientId);
}, (state, blocks, rootClientId) => getAllowedPatternsDependants(select)(state, rootClientId)));

/**
 * Returns the Block List settings of a block, if any exist.
 *
 * @param {Object}  state    Editor state.
 * @param {?string} clientId Block client ID.
 *
 * @return {?Object} Block settings of the block if set.
 */
function getBlockListSettings(state, clientId) {
  return state.blockListSettings[clientId];
}

/**
 * Returns the editor settings.
 *
 * @param {Object} state Editor state.
 *
 * @return {Object} The editor settings object.
 */
function getSettings(state) {
  return state.settings;
}

/**
 * Returns true if the most recent block change is be considered persistent, or
 * false otherwise. A persistent change is one committed by BlockEditorProvider
 * via its `onChange` callback, in addition to `onInput`.
 *
 * @param {Object} state Block editor state.
 *
 * @return {boolean} Whether the most recent block change was persistent.
 */
function isLastBlockChangePersistent(state) {
  return state.blocks.isPersistentChange;
}

/**
 * Returns the block list settings for an array of blocks, if any exist.
 *
 * @param {Object} state     Editor state.
 * @param {Array}  clientIds Block client IDs.
 *
 * @return {Object} An object where the keys are client ids and the values are
 *                  a block list setting object.
 */
const __experimentalGetBlockListSettingsForBlocks = (0,external_wp_data_namespaceObject.createSelector)((state, clientIds = []) => {
  return clientIds.reduce((blockListSettingsForBlocks, clientId) => {
    if (!state.blockListSettings[clientId]) {
      return blockListSettingsForBlocks;
    }
    return {
      ...blockListSettingsForBlocks,
      [clientId]: state.blockListSettings[clientId]
    };
  }, {});
}, state => [state.blockListSettings]);

/**
 * Returns the title of a given reusable block
 *
 * @param {Object}        state Global application state.
 * @param {number|string} ref   The shared block's ID.
 *
 * @return {string} The reusable block saved title.
 */
const __experimentalGetReusableBlockTitle = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (0,external_wp_data_namespaceObject.createSelector)((state, ref) => {
  external_wp_deprecated_default()("wp.data.select( 'core/block-editor' ).__experimentalGetReusableBlockTitle", {
    since: '6.6',
    version: '6.8'
  });
  const reusableBlock = unlock(select(STORE_NAME)).getReusableBlocks().find(block => block.id === ref);
  if (!reusableBlock) {
    return null;
  }
  return reusableBlock.title?.raw;
}, () => [unlock(select(STORE_NAME)).getReusableBlocks()]));

/**
 * Returns true if the most recent block change is be considered ignored, or
 * false otherwise. An ignored change is one not to be committed by
 * BlockEditorProvider, neither via `onChange` nor `onInput`.
 *
 * @param {Object} state Block editor state.
 *
 * @return {boolean} Whether the most recent block change was ignored.
 */
function __unstableIsLastBlockChangeIgnored(state) {
  // TODO: Removal Plan: Changes incurred by RECEIVE_BLOCKS should not be
  // ignored if in-fact they result in a change in blocks state. The current
  // need to ignore changes not a result of user interaction should be
  // accounted for in the refactoring of reusable blocks as occurring within
  // their own separate block editor / state (#7119).
  return state.blocks.isIgnoredChange;
}

/**
 * Returns the block attributes changed as a result of the last dispatched
 * action.
 *
 * @param {Object} state Block editor state.
 *
 * @return {Object<string,Object>} Subsets of block attributes changed, keyed
 *                                 by block client ID.
 */
function __experimentalGetLastBlockAttributeChanges(state) {
  return state.lastBlockAttributesChange;
}

/**
 * Returns whether the navigation mode is enabled.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Is navigation mode enabled.
 */
function isNavigationMode(state) {
  return state.editorMode === 'navigation';
}

/**
 * Returns the current editor mode.
 *
 * @param {Object} state Editor state.
 *
 * @return {string} the editor mode.
 */
function __unstableGetEditorMode(state) {
  return state.editorMode;
}

/**
 * Returns whether block moving mode is enabled.
 *
 * @param {Object} state Editor state.
 *
 * @return {string} Client Id of moving block.
 */
function selectors_hasBlockMovingClientId(state) {
  return state.hasBlockMovingClientId;
}

/**
 * Returns true if the last change was an automatic change, false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the last change was automatic.
 */
function didAutomaticChange(state) {
  return !!state.automaticChangeStatus;
}

/**
 * Returns true if the current highlighted block matches the block clientId.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId The block to check.
 *
 * @return {boolean} Whether the block is currently highlighted.
 */
function isBlockHighlighted(state, clientId) {
  return state.highlightedBlock === clientId;
}

/**
 * Checks if a given block has controlled inner blocks.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId The block to check.
 *
 * @return {boolean} True if the block has controlled inner blocks.
 */
function areInnerBlocksControlled(state, clientId) {
  return !!state.blocks.controlledInnerBlocks[clientId];
}

/**
 * Returns the clientId for the first 'active' block of a given array of block names.
 * A block is 'active' if it (or a child) is the selected block.
 * Returns the first match moving up the DOM from the selected block.
 *
 * @param {Object}   state            Global application state.
 * @param {string[]} validBlocksNames The names of block types to check for.
 *
 * @return {string} The matching block's clientId.
 */
const __experimentalGetActiveBlockIdByBlockNames = (0,external_wp_data_namespaceObject.createSelector)((state, validBlockNames) => {
  if (!validBlockNames.length) {
    return null;
  }
  // Check if selected block is a valid entity area.
  const selectedBlockClientId = getSelectedBlockClientId(state);
  if (validBlockNames.includes(getBlockName(state, selectedBlockClientId))) {
    return selectedBlockClientId;
  }
  // Check if first selected block is a child of a valid entity area.
  const multiSelectedBlockClientIds = getMultiSelectedBlockClientIds(state);
  const entityAreaParents = getBlockParentsByBlockName(state, selectedBlockClientId || multiSelectedBlockClientIds[0], validBlockNames);
  if (entityAreaParents) {
    // Last parent closest/most interior.
    return entityAreaParents[entityAreaParents.length - 1];
  }
  return null;
}, (state, validBlockNames) => [state.selection.selectionStart.clientId, state.selection.selectionEnd.clientId, validBlockNames]);

/**
 * Tells if the block with the passed clientId was just inserted.
 *
 * @param {Object}  state    Global application state.
 * @param {Object}  clientId Client Id of the block.
 * @param {?string} source   Optional insertion source of the block.
 * @return {boolean} True if the block matches the last block inserted from the specified source.
 */
function wasBlockJustInserted(state, clientId, source) {
  const {
    lastBlockInserted
  } = state;
  return lastBlockInserted.clientIds?.includes(clientId) && lastBlockInserted.source === source;
}

/**
 * Tells if the block is visible on the canvas or not.
 *
 * @param {Object} state    Global application state.
 * @param {Object} clientId Client Id of the block.
 * @return {boolean} True if the block is visible.
 */
function isBlockVisible(state, clientId) {
  var _state$blockVisibilit;
  return (_state$blockVisibilit = state.blockVisibility?.[clientId]) !== null && _state$blockVisibilit !== void 0 ? _state$blockVisibilit : true;
}

/**
 * Returns the list of all hidden blocks.
 *
 * @param {Object} state Global application state.
 * @return {[string]} List of hidden blocks.
 */
const __unstableGetVisibleBlocks = (0,external_wp_data_namespaceObject.createSelector)(state => {
  const visibleBlocks = new Set(Object.keys(state.blockVisibility).filter(key => state.blockVisibility[key]));
  if (visibleBlocks.size === 0) {
    return EMPTY_SET;
  }
  return visibleBlocks;
}, state => [state.blockVisibility]);
function __unstableHasActiveBlockOverlayActive(state, clientId) {
  // Prevent overlay on blocks with a non-default editing mode. If the mdoe is
  // 'disabled' then the overlay is redundant since the block can't be
  // selected. If the mode is 'contentOnly' then the overlay is redundant
  // since there will be no controls to interact with once selected.
  if (getBlockEditingMode(state, clientId) !== 'default') {
    return false;
  }

  // If the block editing is locked, the block overlay is always active.
  if (!canEditBlock(state, clientId)) {
    return true;
  }
  const editorMode = __unstableGetEditorMode(state);

  // In zoom-out mode, the block overlay is always active for section level blocks.
  if (editorMode === 'zoom-out') {
    const {
      sectionRootClientId
    } = unlock(getSettings(state));
    if (sectionRootClientId) {
      const sectionClientIds = getBlockOrder(state, sectionRootClientId);
      if (sectionClientIds?.includes(clientId)) {
        return true;
      }
    } else if (clientId && !getBlockRootClientId(state, clientId)) {
      return true;
    }
  }

  // In navigation mode, the block overlay is active when the block is not
  // selected (and doesn't contain a selected child). The same behavior is
  // also enabled in all modes for blocks that have controlled children
  // (reusable block, template part, navigation), unless explicitly disabled
  // with `supports.__experimentalDisableBlockOverlay`.
  const blockSupportDisable = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(getBlockName(state, clientId), '__experimentalDisableBlockOverlay', false);
  const shouldEnableIfUnselected = editorMode === 'navigation' || (blockSupportDisable ? false : areInnerBlocksControlled(state, clientId));
  return shouldEnableIfUnselected && !isBlockSelected(state, clientId) && !hasSelectedInnerBlock(state, clientId, true);
}
function __unstableIsWithinBlockOverlay(state, clientId) {
  let parent = state.blocks.parents.get(clientId);
  while (!!parent) {
    if (__unstableHasActiveBlockOverlayActive(state, parent)) {
      return true;
    }
    parent = state.blocks.parents.get(parent);
  }
  return false;
}

/**
 * @typedef {import('../components/block-editing-mode').BlockEditingMode} BlockEditingMode
 */

/**
 * Returns the block editing mode for a given block.
 *
 * The mode can be one of three options:
 *
 * - `'disabled'`: Prevents editing the block entirely, i.e. it cannot be
 *   selected.
 * - `'contentOnly'`: Hides all non-content UI, e.g. auxiliary controls in the
 *   toolbar, the block movers, block settings.
 * - `'default'`: Allows editing the block as normal.
 *
 * Blocks can set a mode using the `useBlockEditingMode` hook.
 *
 * The mode is inherited by all of the block's inner blocks, unless they have
 * their own mode.
 *
 * A template lock can also set a mode. If the template lock is `'contentOnly'`,
 * the block's mode is overridden to `'contentOnly'` if the block has a content
 * role attribute, or `'disabled'` otherwise.
 *
 * @see useBlockEditingMode
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId The block client ID, or `''` for the root container.
 *
 * @return {BlockEditingMode} The block editing mode. One of `'disabled'`,
 *                            `'contentOnly'`, or `'default'`.
 */
const getBlockEditingMode = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (state, clientId = '') => {
  // Some selectors that call this provide `null` as the default
  // rootClientId, but the default rootClientId is actually `''`.
  if (clientId === null) {
    clientId = '';
  }
  // In zoom-out mode, override the behavior set by
  // __unstableSetBlockEditingMode to only allow editing the top-level
  // sections.
  const editorMode = __unstableGetEditorMode(state);
  if (editorMode === 'zoom-out') {
    const {
      sectionRootClientId
    } = unlock(getSettings(state));
    if (clientId === '' /* ROOT_CONTAINER_CLIENT_ID */) {
      return sectionRootClientId ? 'disabled' : 'contentOnly';
    }
    if (clientId === sectionRootClientId) {
      return 'contentOnly';
    }
    const sectionsClientIds = getBlockOrder(state, sectionRootClientId);
    if (!sectionsClientIds?.includes(clientId)) {
      return 'disabled';
    }
  }
  const blockEditingMode = state.blockEditingModes.get(clientId);
  if (blockEditingMode) {
    return blockEditingMode;
  }
  if (!clientId) {
    return 'default';
  }
  const rootClientId = getBlockRootClientId(state, clientId);
  const templateLock = getTemplateLock(state, rootClientId);
  if (templateLock === 'contentOnly') {
    const name = getBlockName(state, clientId);
    const isContent = select(external_wp_blocks_namespaceObject.store).__experimentalHasContentRoleAttribute(name);
    return isContent ? 'contentOnly' : 'disabled';
  }
  const parentMode = getBlockEditingMode(state, rootClientId);
  return parentMode === 'contentOnly' ? 'default' : parentMode;
});

/**
 * Indicates if a block is ungroupable.
 * A block is ungroupable if it is a single grouping block with inner blocks.
 * If a block has an `ungroup` transform, it is also ungroupable, without the
 * requirement of being the default grouping block.
 * Additionally a block can only be ungrouped if it has inner blocks and can
 * be removed.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId Client Id of the block. If not passed the selected block's client id will be used.
 * @return {boolean} True if the block is ungroupable.
 */
const isUngroupable = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (state, clientId = '') => {
  const _clientId = clientId || getSelectedBlockClientId(state);
  if (!_clientId) {
    return false;
  }
  const {
    getGroupingBlockName
  } = select(external_wp_blocks_namespaceObject.store);
  const block = getBlock(state, _clientId);
  const groupingBlockName = getGroupingBlockName();
  const _isUngroupable = block && (block.name === groupingBlockName || (0,external_wp_blocks_namespaceObject.getBlockType)(block.name)?.transforms?.ungroup) && !!block.innerBlocks.length;
  return _isUngroupable && canRemoveBlock(state, _clientId);
});

/**
 * Indicates if the provided blocks(by client ids) are groupable.
 * We need to have at least one block, have a grouping block name set and
 * be able to remove these blocks.
 *
 * @param {Object}   state     Global application state.
 * @param {string[]} clientIds Block client ids. If not passed the selected blocks client ids will be used.
 * @return {boolean} True if the blocks are groupable.
 */
const isGroupable = (0,external_wp_data_namespaceObject.createRegistrySelector)(select => (state, clientIds = selectors_EMPTY_ARRAY) => {
  const {
    getGroupingBlockName
  } = select(external_wp_blocks_namespaceObject.store);
  const groupingBlockName = getGroupingBlockName();
  const _clientIds = clientIds?.length ? clientIds : getSelectedBlockClientIds(state);
  const rootClientId = _clientIds?.length ? getBlockRootClientId(state, _clientIds[0]) : undefined;
  const groupingBlockAvailable = canInsertBlockType(state, groupingBlockName, rootClientId);
  const _isGroupable = groupingBlockAvailable && _clientIds.length;
  return _isGroupable && canRemoveBlocks(state, _clientIds, rootClientId);
});

/**
 * DO-NOT-USE in production.
 * This selector is created for internal/experimental only usage and may be
 * removed anytime without any warning, causing breakage on any plugin or theme invoking it.
 *
 * @deprecated
 *
 * @param {Object} state    Global application state.
 * @param {Object} clientId Client Id of the block.
 *
 * @return {?string} Client ID of the ancestor block that is content locking the block.
 */
const __unstableGetContentLockingParent = (state, clientId) => {
  external_wp_deprecated_default()("wp.data.select( 'core/block-editor' ).__unstableGetContentLockingParent", {
    since: '6.1',
    version: '6.7'
  });
  return getContentLockingParent(state, clientId);
};

/**
 * DO-NOT-USE in production.
 * This selector is created for internal/experimental only usage and may be
 * removed anytime without any warning, causing breakage on any plugin or theme invoking it.
 *
 * @deprecated
 *
 * @param {Object} state Global application state.
 */
function __unstableGetTemporarilyEditingAsBlocks(state) {
  external_wp_deprecated_default()("wp.data.select( 'core/block-editor' ).__unstableGetTemporarilyEditingAsBlocks", {
    since: '6.1',
    version: '6.7'
  });
  return getTemporarilyEditingAsBlocks(state);
}

/**
 * DO-NOT-USE in production.
 * This selector is created for internal/experimental only usage and may be
 * removed anytime without any warning, causing breakage on any plugin or theme invoking it.
 *
 * @deprecated
 *
 * @param {Object} state Global application state.
 */
function __unstableGetTemporarilyEditingFocusModeToRevert(state) {
  external_wp_deprecated_default()("wp.data.select( 'core/block-editor' ).__unstableGetTemporarilyEditingFocusModeToRevert", {
    since: '6.5',
    version: '6.7'
  });
  return getTemporarilyEditingFocusModeToRevert(state);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/undo-ignore.js
// Keep track of the blocks that should not be pushing an additional
// undo stack when editing the entity.
// See the implementation of `syncDerivedUpdates` and `useBlockSync`.
const undoIgnoreBlocks = new WeakSet();

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/private-actions.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



const castArray = maybeArray => Array.isArray(maybeArray) ? maybeArray : [maybeArray];

/**
 * A list of private/experimental block editor settings that
 * should not become a part of the WordPress public API.
 * BlockEditorProvider will remove these settings from the
 * settings object it receives.
 *
 * @see https://github.com/WordPress/gutenberg/pull/46131
 */
const privateSettings = ['inserterMediaCategories', 'blockInspectorAnimation'];

/**
 * Action that updates the block editor settings and
 * conditionally preserves the experimental ones.
 *
 * @param {Object}  settings                          Updated settings
 * @param {Object}  options                           Options object.
 * @param {boolean} options.stripExperimentalSettings Whether to strip experimental settings.
 * @param {boolean} options.reset                     Whether to reset the settings.
 * @return {Object} Action object
 */
function __experimentalUpdateSettings(settings, {
  stripExperimentalSettings = false,
  reset = false
} = {}) {
  let cleanSettings = settings;
  // There are no plugins in the mobile apps, so there is no
  // need to strip the experimental settings:
  if (stripExperimentalSettings && external_wp_element_namespaceObject.Platform.OS === 'web') {
    cleanSettings = {};
    for (const key in settings) {
      if (!privateSettings.includes(key)) {
        cleanSettings[key] = settings[key];
      }
    }
  }
  return {
    type: 'UPDATE_SETTINGS',
    settings: cleanSettings,
    reset
  };
}

/**
 * Hides the block interface (eg. toolbar, outline, etc.)
 *
 * @return {Object} Action object.
 */
function hideBlockInterface() {
  return {
    type: 'HIDE_BLOCK_INTERFACE'
  };
}

/**
 * Shows the block interface (eg. toolbar, outline, etc.)
 *
 * @return {Object} Action object.
 */
function showBlockInterface() {
  return {
    type: 'SHOW_BLOCK_INTERFACE'
  };
}

/**
 * Yields action objects used in signalling that the blocks corresponding to
 * the set of specified client IDs are to be removed.
 *
 * Compared to `removeBlocks`, this private interface exposes an additional
 * parameter; see `forceRemove`.
 *
 * @param {string|string[]} clientIds      Client IDs of blocks to remove.
 * @param {boolean}         selectPrevious True if the previous block
 *                                         or the immediate parent
 *                                         (if no previous block exists)
 *                                         should be selected
 *                                         when a block is removed.
 * @param {boolean}         forceRemove    Whether to force the operation,
 *                                         bypassing any checks for certain
 *                                         block types.
 */
const privateRemoveBlocks = (clientIds, selectPrevious = true, forceRemove = false) => ({
  select,
  dispatch,
  registry
}) => {
  if (!clientIds || !clientIds.length) {
    return;
  }
  clientIds = castArray(clientIds);
  const rootClientId = select.getBlockRootClientId(clientIds[0]);
  const canRemoveBlocks = select.canRemoveBlocks(clientIds, rootClientId);
  if (!canRemoveBlocks) {
    return;
  }

  // In certain editing contexts, we'd like to prevent accidental removal
  // of important blocks. For example, in the site editor, the Query Loop
  // block is deemed important. In such cases, we'll ask the user for
  // confirmation that they intended to remove such block(s). However,
  // the editor instance is responsible for presenting those confirmation
  // prompts to the user. Any instance opting into removal prompts must
  // register using `setBlockRemovalRules()`.
  //
  // @see https://github.com/WordPress/gutenberg/pull/51145
  const rules = !forceRemove && select.getBlockRemovalRules();
  if (rules) {
    function flattenBlocks(blocks) {
      const result = [];
      const stack = [...blocks];
      while (stack.length) {
        const {
          innerBlocks,
          ...block
        } = stack.shift();
        stack.push(...innerBlocks);
        result.push(block);
      }
      return result;
    }
    const blockList = clientIds.map(select.getBlock);
    const flattenedBlocks = flattenBlocks(blockList);

    // Find the first message and use it.
    let message;
    for (const rule of rules) {
      message = rule.callback(flattenedBlocks);
      if (message) {
        dispatch(displayBlockRemovalPrompt(clientIds, selectPrevious, message));
        return;
      }
    }
  }
  if (selectPrevious) {
    dispatch.selectPreviousBlock(clientIds[0], selectPrevious);
  }

  // We're batching these two actions because an extra `undo/redo` step can
  // be created, based on whether we insert a default block or not.
  registry.batch(() => {
    dispatch({
      type: 'REMOVE_BLOCKS',
      clientIds
    });
    // To avoid a focus loss when removing the last block, assure there is
    // always a default block if the last of the blocks have been removed.
    dispatch(ensureDefaultBlock());
  });
};

/**
 * Action which will insert a default block insert action if there
 * are no other blocks at the root of the editor. This action should be used
 * in actions which may result in no blocks remaining in the editor (removal,
 * replacement, etc).
 */
const ensureDefaultBlock = () => ({
  select,
  dispatch
}) => {
  // To avoid a focus loss when removing the last block, assure there is
  // always a default block if the last of the blocks have been removed.
  const count = select.getBlockCount();
  if (count > 0) {
    return;
  }

  // If there's an custom appender, don't insert default block.
  // We have to remember to manually move the focus elsewhere to
  // prevent it from being lost though.
  const {
    __unstableHasCustomAppender
  } = select.getSettings();
  if (__unstableHasCustomAppender) {
    return;
  }
  dispatch.insertDefaultBlock();
};

/**
 * Returns an action object used in signalling that a block removal prompt must
 * be displayed.
 *
 * Contrast with `setBlockRemovalRules`.
 *
 * @param {string|string[]} clientIds      Client IDs of blocks to remove.
 * @param {boolean}         selectPrevious True if the previous block or the
 *                                         immediate parent (if no previous
 *                                         block exists) should be selected
 *                                         when a block is removed.
 * @param {string}          message        Message to display in the prompt.
 *
 * @return {Object} Action object.
 */
function displayBlockRemovalPrompt(clientIds, selectPrevious, message) {
  return {
    type: 'DISPLAY_BLOCK_REMOVAL_PROMPT',
    clientIds,
    selectPrevious,
    message
  };
}

/**
 * Returns an action object used in signalling that a block removal prompt must
 * be cleared, either be cause the user has confirmed or canceled the request
 * for removal.
 *
 * @return {Object} Action object.
 */
function clearBlockRemovalPrompt() {
  return {
    type: 'CLEAR_BLOCK_REMOVAL_PROMPT'
  };
}

/**
 * Returns an action object used to set up any rules that a block editor may
 * provide in order to prevent a user from accidentally removing certain
 * blocks. These rules are then used to display a confirmation prompt to the
 * user. For instance, in the Site Editor, the Query Loop block is important
 * enough to warrant such confirmation.
 *
 * IMPORTANT: Registering rules implicitly signals to the `privateRemoveBlocks`
 * action that the editor will be responsible for displaying block removal
 * prompts and confirming deletions. This action is meant to be used by
 * component `BlockRemovalWarningModal` only.
 *
 * The data is a record whose keys are block types (e.g. 'core/query') and
 * whose values are the explanation to be shown to users (e.g. 'Query Loop
 * displays a list of posts or pages.').
 *
 * Contrast with `displayBlockRemovalPrompt`.
 *
 * @param {Record<string,string>|false} rules Block removal rules.
 * @return {Object} Action object.
 */
function setBlockRemovalRules(rules = false) {
  return {
    type: 'SET_BLOCK_REMOVAL_RULES',
    rules
  };
}

/**
 * Sets the client ID of the block settings menu that is currently open.
 *
 * @param {?string} clientId The block client ID.
 * @return {Object} Action object.
 */
function setOpenedBlockSettingsMenu(clientId) {
  return {
    type: 'SET_OPENED_BLOCK_SETTINGS_MENU',
    clientId
  };
}
function setStyleOverride(id, style) {
  return {
    type: 'SET_STYLE_OVERRIDE',
    id,
    style
  };
}
function deleteStyleOverride(id) {
  return {
    type: 'DELETE_STYLE_OVERRIDE',
    id
  };
}

/**
 * A higher-order action that mark every change inside a callback as "non-persistent"
 * and ignore pushing to the undo history stack. It's primarily used for synchronized
 * derived updates from the block editor without affecting the undo history.
 *
 * @param {() => void} callback The synchronous callback to derive updates.
 */
function syncDerivedUpdates(callback) {
  return ({
    dispatch,
    select,
    registry
  }) => {
    registry.batch(() => {
      // Mark every change in the `callback` as non-persistent.
      dispatch({
        type: 'SET_EXPLICIT_PERSISTENT',
        isPersistentChange: false
      });
      callback();
      dispatch({
        type: 'SET_EXPLICIT_PERSISTENT',
        isPersistentChange: undefined
      });

      // Ignore pushing undo stack for the updated blocks.
      const updatedBlocks = select.getBlocks();
      undoIgnoreBlocks.add(updatedBlocks);
    });
  };
}

/**
 * Action that sets the element that had focus when focus leaves the editor canvas.
 *
 * @param {Object} lastFocus The last focused element.
 *
 *
 * @return {Object} Action object.
 */
function setLastFocus(lastFocus = null) {
  return {
    type: 'LAST_FOCUS',
    lastFocus
  };
}

/**
 * Action that stops temporarily editing as blocks.
 *
 * @param {string} clientId The block's clientId.
 */
function stopEditingAsBlocks(clientId) {
  return ({
    select,
    dispatch,
    registry
  }) => {
    const focusModeToRevert = unlock(registry.select(store)).getTemporarilyEditingFocusModeToRevert();
    dispatch.__unstableMarkNextChangeAsNotPersistent();
    dispatch.updateBlockAttributes(clientId, {
      templateLock: 'contentOnly'
    });
    dispatch.updateBlockListSettings(clientId, {
      ...select.getBlockListSettings(clientId),
      templateLock: 'contentOnly'
    });
    dispatch.updateSettings({
      focusMode: focusModeToRevert
    });
    dispatch.__unstableSetTemporarilyEditingAsBlocks();
  };
}

/**
 * Returns an action object used in signalling that the user has begun to drag.
 *
 * @return {Object} Action object.
 */
function startDragging() {
  return {
    type: 'START_DRAGGING'
  };
}

/**
 * Returns an action object used in signalling that the user has stopped dragging.
 *
 * @return {Object} Action object.
 */
function stopDragging() {
  return {
    type: 'STOP_DRAGGING'
  };
}

/**
 * @param {string|null} clientId The block's clientId, or `null` to clear.
 *
 * @return  {Object} Action object.
 */
function expandBlock(clientId) {
  return {
    type: 'SET_BLOCK_EXPANDED_IN_LIST_VIEW',
    clientId
  };
}

/**
 * Temporarily modify/unlock the content-only block for editions.
 *
 * @param {string} clientId The client id of the block.
 */
const modifyContentLockBlock = clientId => ({
  select,
  dispatch
}) => {
  dispatch.__unstableMarkNextChangeAsNotPersistent();
  dispatch.updateBlockAttributes(clientId, {
    templateLock: undefined
  });
  dispatch.updateBlockListSettings(clientId, {
    ...select.getBlockListSettings(clientId),
    templateLock: false
  });
  const focusModeToRevert = select.getSettings().focusMode;
  dispatch.updateSettings({
    focusMode: true
  });
  dispatch.__unstableSetTemporarilyEditingAsBlocks(clientId, focusModeToRevert);
};

;// CONCATENATED MODULE: external ["wp","a11y"]
const external_wp_a11y_namespaceObject = window["wp"]["a11y"];
;// CONCATENATED MODULE: external ["wp","notices"]
const external_wp_notices_namespaceObject = window["wp"]["notices"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/utils/selection.js
/**
 * WordPress dependencies
 */


/**
 * A robust way to retain selection position through various
 * transforms is to insert a special character at the position and
 * then recover it.
 */
const START_OF_SELECTED_AREA = '\u0086';

/**
 * Retrieve the block attribute that contains the selection position.
 *
 * @param {Object} blockAttributes Block attributes.
 * @return {string|void} The name of the block attribute that was previously selected.
 */
function retrieveSelectedAttribute(blockAttributes) {
  if (!blockAttributes) {
    return;
  }
  return Object.keys(blockAttributes).find(name => {
    const value = blockAttributes[name];
    return (typeof value === 'string' || value instanceof external_wp_richText_namespaceObject.RichTextData) &&
    // To do: refactor this to use rich text's selection instead, so we
    // no longer have to use on this hack inserting a special character.
    value.toString().indexOf(START_OF_SELECTED_AREA) !== -1;
  });
}
function findRichTextAttributeKey(blockType) {
  for (const [key, value] of Object.entries(blockType.attributes)) {
    if (value.source === 'rich-text' || value.source === 'html') {
      return key;
    }
  }
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/actions.js
/* eslint no-console: [ 'error', { allow: [ 'error', 'warn' ] } ] */
/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */





/** @typedef {import('../components/use-on-block-drop/types').WPDropOperation} WPDropOperation */

const actions_castArray = maybeArray => Array.isArray(maybeArray) ? maybeArray : [maybeArray];

/**
 * Action that resets blocks state to the specified array of blocks, taking precedence
 * over any other content reflected as an edit in state.
 *
 * @param {Array} blocks Array of blocks.
 */
const resetBlocks = blocks => ({
  dispatch
}) => {
  dispatch({
    type: 'RESET_BLOCKS',
    blocks
  });
  dispatch(validateBlocksToTemplate(blocks));
};

/**
 * Block validity is a function of blocks state (at the point of a
 * reset) and the template setting. As a compromise to its placement
 * across distinct parts of state, it is implemented here as a side
 * effect of the block reset action.
 *
 * @param {Array} blocks Array of blocks.
 */
const validateBlocksToTemplate = blocks => ({
  select,
  dispatch
}) => {
  const template = select.getTemplate();
  const templateLock = select.getTemplateLock();

  // Unlocked templates are considered always valid because they act
  // as default values only.
  const isBlocksValidToTemplate = !template || templateLock !== 'all' || (0,external_wp_blocks_namespaceObject.doBlocksMatchTemplate)(blocks, template);

  // Update if validity has changed.
  const isValidTemplate = select.isValidTemplate();
  if (isBlocksValidToTemplate !== isValidTemplate) {
    dispatch.setTemplateValidity(isBlocksValidToTemplate);
    return isBlocksValidToTemplate;
  }
};

/**
 * A block selection object.
 *
 * @typedef {Object} WPBlockSelection
 *
 * @property {string} clientId     A block client ID.
 * @property {string} attributeKey A block attribute key.
 * @property {number} offset       An attribute value offset, based on the rich
 *                                 text value. See `wp.richText.create`.
 */

/**
 * A selection object.
 *
 * @typedef {Object} WPSelection
 *
 * @property {WPBlockSelection} start The selection start.
 * @property {WPBlockSelection} end   The selection end.
 */

/* eslint-disable jsdoc/valid-types */
/**
 * Returns an action object used in signalling that selection state should be
 * reset to the specified selection.
 *
 * @param {WPBlockSelection} selectionStart  The selection start.
 * @param {WPBlockSelection} selectionEnd    The selection end.
 * @param {0|-1|null}        initialPosition Initial block position.
 *
 * @return {Object} Action object.
 */
function resetSelection(selectionStart, selectionEnd, initialPosition) {
  /* eslint-enable jsdoc/valid-types */
  return {
    type: 'RESET_SELECTION',
    selectionStart,
    selectionEnd,
    initialPosition
  };
}

/**
 * Returns an action object used in signalling that blocks have been received.
 * Unlike resetBlocks, these should be appended to the existing known set, not
 * replacing.
 *
 * @deprecated
 *
 * @param {Object[]} blocks Array of block objects.
 *
 * @return {Object} Action object.
 */
function receiveBlocks(blocks) {
  external_wp_deprecated_default()('wp.data.dispatch( "core/block-editor" ).receiveBlocks', {
    since: '5.9',
    alternative: 'resetBlocks or insertBlocks'
  });
  return {
    type: 'RECEIVE_BLOCKS',
    blocks
  };
}

/**
 * Action that updates attributes of multiple blocks with the specified client IDs.
 *
 * @param {string|string[]} clientIds     Block client IDs.
 * @param {Object}          attributes    Block attributes to be merged. Should be keyed by clientIds if
 *                                        uniqueByBlock is true.
 * @param {boolean}         uniqueByBlock true if each block in clientIds array has a unique set of attributes
 * @return {Object} Action object.
 */
function updateBlockAttributes(clientIds, attributes, uniqueByBlock = false) {
  return {
    type: 'UPDATE_BLOCK_ATTRIBUTES',
    clientIds: actions_castArray(clientIds),
    attributes,
    uniqueByBlock
  };
}

/**
 * Action that updates the block with the specified client ID.
 *
 * @param {string} clientId Block client ID.
 * @param {Object} updates  Block attributes to be merged.
 *
 * @return {Object} Action object.
 */
function updateBlock(clientId, updates) {
  return {
    type: 'UPDATE_BLOCK',
    clientId,
    updates
  };
}

/* eslint-disable jsdoc/valid-types */
/**
 * Returns an action object used in signalling that the block with the
 * specified client ID has been selected, optionally accepting a position
 * value reflecting its selection directionality. An initialPosition of -1
 * reflects a reverse selection.
 *
 * @param {string}    clientId        Block client ID.
 * @param {0|-1|null} initialPosition Optional initial position. Pass as -1 to
 *                                    reflect reverse selection.
 *
 * @return {Object} Action object.
 */
function selectBlock(clientId, initialPosition = 0) {
  /* eslint-enable jsdoc/valid-types */
  return {
    type: 'SELECT_BLOCK',
    initialPosition,
    clientId
  };
}

/**
 * Yields action objects used in signalling that the block preceding the given
 * clientId (or optionally, its first parent from bottom to top)
 * should be selected.
 *
 * @param {string}  clientId         Block client ID.
 * @param {boolean} fallbackToParent If true, select the first parent if there is no previous block.
 */
const selectPreviousBlock = (clientId, fallbackToParent = false) => ({
  select,
  dispatch
}) => {
  const previousBlockClientId = select.getPreviousBlockClientId(clientId);
  if (previousBlockClientId) {
    dispatch.selectBlock(previousBlockClientId, -1);
  } else if (fallbackToParent) {
    const firstParentClientId = select.getBlockRootClientId(clientId);
    if (firstParentClientId) {
      dispatch.selectBlock(firstParentClientId, -1);
    }
  }
};

/**
 * Yields action objects used in signalling that the block following the given
 * clientId should be selected.
 *
 * @param {string} clientId Block client ID.
 */
const selectNextBlock = clientId => ({
  select,
  dispatch
}) => {
  const nextBlockClientId = select.getNextBlockClientId(clientId);
  if (nextBlockClientId) {
    dispatch.selectBlock(nextBlockClientId);
  }
};

/**
 * Action that starts block multi-selection.
 *
 * @return {Object} Action object.
 */
function startMultiSelect() {
  return {
    type: 'START_MULTI_SELECT'
  };
}

/**
 * Action that stops block multi-selection.
 *
 * @return {Object} Action object.
 */
function stopMultiSelect() {
  return {
    type: 'STOP_MULTI_SELECT'
  };
}

/**
 * Action that changes block multi-selection.
 *
 * @param {string}      start                         First block of the multi selection.
 * @param {string}      end                           Last block of the multiselection.
 * @param {number|null} __experimentalInitialPosition Optional initial position. Pass as null to skip focus within editor canvas.
 */
const multiSelect = (start, end, __experimentalInitialPosition = 0) => ({
  select,
  dispatch
}) => {
  const startBlockRootClientId = select.getBlockRootClientId(start);
  const endBlockRootClientId = select.getBlockRootClientId(end);

  // Only allow block multi-selections at the same level.
  if (startBlockRootClientId !== endBlockRootClientId) {
    return;
  }
  dispatch({
    type: 'MULTI_SELECT',
    start,
    end,
    initialPosition: __experimentalInitialPosition
  });
  const blockCount = select.getSelectedBlockCount();
  (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.sprintf)( /* translators: %s: number of selected blocks */
  (0,external_wp_i18n_namespaceObject._n)('%s block selected.', '%s blocks selected.', blockCount), blockCount), 'assertive');
};

/**
 * Action that clears the block selection.
 *
 * @return {Object} Action object.
 */
function clearSelectedBlock() {
  return {
    type: 'CLEAR_SELECTED_BLOCK'
  };
}

/**
 * Action that enables or disables block selection.
 *
 * @param {boolean} [isSelectionEnabled=true] Whether block selection should
 *                                            be enabled.
 *
 * @return {Object} Action object.
 */
function toggleSelection(isSelectionEnabled = true) {
  return {
    type: 'TOGGLE_SELECTION',
    isSelectionEnabled
  };
}

/* eslint-disable jsdoc/valid-types */
/**
 * Action that replaces given blocks with one or more replacement blocks.
 *
 * @param {(string|string[])} clientIds       Block client ID(s) to replace.
 * @param {(Object|Object[])} blocks          Replacement block(s).
 * @param {number}            indexToSelect   Index of replacement block to select.
 * @param {0|-1|null}         initialPosition Index of caret after in the selected block after the operation.
 * @param {?Object}           meta            Optional Meta values to be passed to the action object.
 *
 * @return {Object} Action object.
 */
const replaceBlocks = (clientIds, blocks, indexToSelect, initialPosition = 0, meta) => ({
  select,
  dispatch,
  registry
}) => {
  /* eslint-enable jsdoc/valid-types */
  clientIds = actions_castArray(clientIds);
  blocks = actions_castArray(blocks);
  const rootClientId = select.getBlockRootClientId(clientIds[0]);
  // Replace is valid if the new blocks can be inserted in the root block.
  for (let index = 0; index < blocks.length; index++) {
    const block = blocks[index];
    const canInsertBlock = select.canInsertBlockType(block.name, rootClientId);
    if (!canInsertBlock) {
      return;
    }
  }
  // We're batching these two actions because an extra `undo/redo` step can
  // be created, based on whether we insert a default block or not.
  registry.batch(() => {
    dispatch({
      type: 'REPLACE_BLOCKS',
      clientIds,
      blocks,
      time: Date.now(),
      indexToSelect,
      initialPosition,
      meta
    });
    // To avoid a focus loss when removing the last block, assure there is
    // always a default block if the last of the blocks have been removed.
    dispatch.ensureDefaultBlock();
  });
};

/**
 * Action that replaces a single block with one or more replacement blocks.
 *
 * @param {(string|string[])} clientId Block client ID to replace.
 * @param {(Object|Object[])} block    Replacement block(s).
 *
 * @return {Object} Action object.
 */
function replaceBlock(clientId, block) {
  return replaceBlocks(clientId, block);
}

/**
 * Higher-order action creator which, given the action type to dispatch creates
 * an action creator for managing block movement.
 *
 * @param {string} type Action type to dispatch.
 *
 * @return {Function} Action creator.
 */
const createOnMove = type => (clientIds, rootClientId) => ({
  select,
  dispatch
}) => {
  // If one of the blocks is locked or the parent is locked, we cannot move any block.
  const canMoveBlocks = select.canMoveBlocks(clientIds, rootClientId);
  if (!canMoveBlocks) {
    return;
  }
  dispatch({
    type,
    clientIds: actions_castArray(clientIds),
    rootClientId
  });
};
const moveBlocksDown = createOnMove('MOVE_BLOCKS_DOWN');
const moveBlocksUp = createOnMove('MOVE_BLOCKS_UP');

/**
 * Action that moves given blocks to a new position.
 *
 * @param {?string} clientIds        The client IDs of the blocks.
 * @param {?string} fromRootClientId Root client ID source.
 * @param {?string} toRootClientId   Root client ID destination.
 * @param {number}  index            The index to move the blocks to.
 */
const moveBlocksToPosition = (clientIds, fromRootClientId = '', toRootClientId = '', index) => ({
  select,
  dispatch
}) => {
  const canMoveBlocks = select.canMoveBlocks(clientIds, fromRootClientId);

  // If one of the blocks is locked or the parent is locked, we cannot move any block.
  if (!canMoveBlocks) {
    return;
  }

  // If moving inside the same root block the move is always possible.
  if (fromRootClientId !== toRootClientId) {
    const canRemoveBlocks = select.canRemoveBlocks(clientIds, fromRootClientId);

    // If we're moving to another block, it means we're deleting blocks from
    // the original block, so we need to check if removing is possible.
    if (!canRemoveBlocks) {
      return;
    }
    const canInsertBlocks = select.canInsertBlocks(clientIds, toRootClientId);

    // If moving to other parent block, the move is possible if we can insert a block of the same type inside the new parent block.
    if (!canInsertBlocks) {
      return;
    }
  }
  dispatch({
    type: 'MOVE_BLOCKS_TO_POSITION',
    fromRootClientId,
    toRootClientId,
    clientIds,
    index
  });
};

/**
 * Action that moves given block to a new position.
 *
 * @param {?string} clientId         The client ID of the block.
 * @param {?string} fromRootClientId Root client ID source.
 * @param {?string} toRootClientId   Root client ID destination.
 * @param {number}  index            The index to move the block to.
 */
function moveBlockToPosition(clientId, fromRootClientId = '', toRootClientId = '', index) {
  return moveBlocksToPosition([clientId], fromRootClientId, toRootClientId, index);
}

/**
 * Action that inserts a single block, optionally at a specific index respective a root block list.
 *
 * Only allowed blocks are inserted. The action may fail silently for blocks that are not allowed or if
 * a templateLock is active on the block list.
 *
 * @param {Object}   block           Block object to insert.
 * @param {?number}  index           Index at which block should be inserted.
 * @param {?string}  rootClientId    Optional root client ID of block list on which to insert.
 * @param {?boolean} updateSelection If true block selection will be updated. If false, block selection will not change. Defaults to true.
 * @param {?Object}  meta            Optional Meta values to be passed to the action object.
 *
 * @return {Object} Action object.
 */
function insertBlock(block, index, rootClientId, updateSelection, meta) {
  return insertBlocks([block], index, rootClientId, updateSelection, 0, meta);
}

/* eslint-disable jsdoc/valid-types */
/**
 * Action that inserts an array of blocks, optionally at a specific index respective a root block list.
 *
 * Only allowed blocks are inserted. The action may fail silently for blocks that are not allowed or if
 * a templateLock is active on the block list.
 *
 * @param {Object[]}  blocks          Block objects to insert.
 * @param {?number}   index           Index at which block should be inserted.
 * @param {?string}   rootClientId    Optional root client ID of block list on which to insert.
 * @param {?boolean}  updateSelection If true block selection will be updated.  If false, block selection will not change. Defaults to true.
 * @param {0|-1|null} initialPosition Initial focus position. Setting it to null prevent focusing the inserted block.
 * @param {?Object}   meta            Optional Meta values to be passed to the action object.
 *
 * @return {Object} Action object.
 */
const insertBlocks = (blocks, index, rootClientId, updateSelection = true, initialPosition = 0, meta) => ({
  select,
  dispatch
}) => {
  /* eslint-enable jsdoc/valid-types */
  if (initialPosition !== null && typeof initialPosition === 'object') {
    meta = initialPosition;
    initialPosition = 0;
    external_wp_deprecated_default()("meta argument in wp.data.dispatch('core/block-editor')", {
      since: '5.8',
      hint: 'The meta argument is now the 6th argument of the function'
    });
  }
  blocks = actions_castArray(blocks);
  const allowedBlocks = [];
  for (const block of blocks) {
    const isValid = select.canInsertBlockType(block.name, rootClientId);
    if (isValid) {
      allowedBlocks.push(block);
    }
  }
  if (allowedBlocks.length) {
    dispatch({
      type: 'INSERT_BLOCKS',
      blocks: allowedBlocks,
      index,
      rootClientId,
      time: Date.now(),
      updateSelection,
      initialPosition: updateSelection ? initialPosition : null,
      meta
    });
  }
};

/**
 * Action that shows the insertion point.
 *
 * @param    {?string}         rootClientId           Optional root client ID of block list on
 *                                                    which to insert.
 * @param    {?number}         index                  Index at which block should be inserted.
 * @param    {?Object}         __unstableOptions      Additional options.
 * @property {boolean}         __unstableWithInserter Whether or not to show an inserter button.
 * @property {WPDropOperation} operation              The operation to perform when applied,
 *                                                    either 'insert' or 'replace' for now.
 *
 * @return {Object} Action object.
 */
function showInsertionPoint(rootClientId, index, __unstableOptions = {}) {
  const {
    __unstableWithInserter,
    operation,
    nearestSide
  } = __unstableOptions;
  return {
    type: 'SHOW_INSERTION_POINT',
    rootClientId,
    index,
    __unstableWithInserter,
    operation,
    nearestSide
  };
}
/**
 * Action that hides the insertion point.
 */
const hideInsertionPoint = () => ({
  select,
  dispatch
}) => {
  if (!select.isBlockInsertionPointVisible()) {
    return;
  }
  dispatch({
    type: 'HIDE_INSERTION_POINT'
  });
};

/**
 * Action that resets the template validity.
 *
 * @param {boolean} isValid template validity flag.
 *
 * @return {Object} Action object.
 */
function setTemplateValidity(isValid) {
  return {
    type: 'SET_TEMPLATE_VALIDITY',
    isValid
  };
}

/**
 * Action that synchronizes the template with the list of blocks.
 *
 * @return {Object} Action object.
 */
const synchronizeTemplate = () => ({
  select,
  dispatch
}) => {
  dispatch({
    type: 'SYNCHRONIZE_TEMPLATE'
  });
  const blocks = select.getBlocks();
  const template = select.getTemplate();
  const updatedBlockList = (0,external_wp_blocks_namespaceObject.synchronizeBlocksWithTemplate)(blocks, template);
  dispatch.resetBlocks(updatedBlockList);
};

/**
 * Delete the current selection.
 *
 * @param {boolean} isForward
 */
const __unstableDeleteSelection = isForward => ({
  registry,
  select,
  dispatch
}) => {
  const selectionAnchor = select.getSelectionStart();
  const selectionFocus = select.getSelectionEnd();
  if (selectionAnchor.clientId === selectionFocus.clientId) {
    return;
  }

  // It's not mergeable if there's no rich text selection.
  if (!selectionAnchor.attributeKey || !selectionFocus.attributeKey || typeof selectionAnchor.offset === 'undefined' || typeof selectionFocus.offset === 'undefined') {
    return false;
  }
  const anchorRootClientId = select.getBlockRootClientId(selectionAnchor.clientId);
  const focusRootClientId = select.getBlockRootClientId(selectionFocus.clientId);

  // It's not mergeable if the selection doesn't start and end in the same
  // block list. Maybe in the future it should be allowed.
  if (anchorRootClientId !== focusRootClientId) {
    return;
  }
  const blockOrder = select.getBlockOrder(anchorRootClientId);
  const anchorIndex = blockOrder.indexOf(selectionAnchor.clientId);
  const focusIndex = blockOrder.indexOf(selectionFocus.clientId);

  // Reassign selection start and end based on order.
  let selectionStart, selectionEnd;
  if (anchorIndex > focusIndex) {
    selectionStart = selectionFocus;
    selectionEnd = selectionAnchor;
  } else {
    selectionStart = selectionAnchor;
    selectionEnd = selectionFocus;
  }
  const targetSelection = isForward ? selectionEnd : selectionStart;
  const targetBlock = select.getBlock(targetSelection.clientId);
  const targetBlockType = (0,external_wp_blocks_namespaceObject.getBlockType)(targetBlock.name);
  if (!targetBlockType.merge) {
    return;
  }
  const selectionA = selectionStart;
  const selectionB = selectionEnd;
  const blockA = select.getBlock(selectionA.clientId);
  const blockB = select.getBlock(selectionB.clientId);
  const htmlA = blockA.attributes[selectionA.attributeKey];
  const htmlB = blockB.attributes[selectionB.attributeKey];
  let valueA = (0,external_wp_richText_namespaceObject.create)({
    html: htmlA
  });
  let valueB = (0,external_wp_richText_namespaceObject.create)({
    html: htmlB
  });
  valueA = (0,external_wp_richText_namespaceObject.remove)(valueA, selectionA.offset, valueA.text.length);
  valueB = (0,external_wp_richText_namespaceObject.insert)(valueB, START_OF_SELECTED_AREA, 0, selectionB.offset);

  // Clone the blocks so we don't manipulate the original.
  const cloneA = (0,external_wp_blocks_namespaceObject.cloneBlock)(blockA, {
    [selectionA.attributeKey]: (0,external_wp_richText_namespaceObject.toHTMLString)({
      value: valueA
    })
  });
  const cloneB = (0,external_wp_blocks_namespaceObject.cloneBlock)(blockB, {
    [selectionB.attributeKey]: (0,external_wp_richText_namespaceObject.toHTMLString)({
      value: valueB
    })
  });
  const followingBlock = isForward ? cloneA : cloneB;

  // We can only merge blocks with similar types
  // thus, we transform the block to merge first
  const blocksWithTheSameType = blockA.name === blockB.name ? [followingBlock] : (0,external_wp_blocks_namespaceObject.switchToBlockType)(followingBlock, targetBlockType.name);

  // If the block types can not match, do nothing
  if (!blocksWithTheSameType || !blocksWithTheSameType.length) {
    return;
  }
  let updatedAttributes;
  if (isForward) {
    const blockToMerge = blocksWithTheSameType.pop();
    updatedAttributes = targetBlockType.merge(blockToMerge.attributes, cloneB.attributes);
  } else {
    const blockToMerge = blocksWithTheSameType.shift();
    updatedAttributes = targetBlockType.merge(cloneA.attributes, blockToMerge.attributes);
  }
  const newAttributeKey = retrieveSelectedAttribute(updatedAttributes);
  const convertedHtml = updatedAttributes[newAttributeKey];
  const convertedValue = (0,external_wp_richText_namespaceObject.create)({
    html: convertedHtml
  });
  const newOffset = convertedValue.text.indexOf(START_OF_SELECTED_AREA);
  const newValue = (0,external_wp_richText_namespaceObject.remove)(convertedValue, newOffset, newOffset + 1);
  const newHtml = (0,external_wp_richText_namespaceObject.toHTMLString)({
    value: newValue
  });
  updatedAttributes[newAttributeKey] = newHtml;
  const selectedBlockClientIds = select.getSelectedBlockClientIds();
  const replacement = [...(isForward ? blocksWithTheSameType : []), {
    // Preserve the original client ID.
    ...targetBlock,
    attributes: {
      ...targetBlock.attributes,
      ...updatedAttributes
    }
  }, ...(isForward ? [] : blocksWithTheSameType)];
  registry.batch(() => {
    dispatch.selectionChange(targetBlock.clientId, newAttributeKey, newOffset, newOffset);
    dispatch.replaceBlocks(selectedBlockClientIds, replacement, 0,
    // If we don't pass the `indexToSelect` it will default to the last block.
    select.getSelectedBlocksInitialCaretPosition());
  });
};

/**
 * Split the current selection.
 * @param {?Array} blocks
 */
const __unstableSplitSelection = (blocks = []) => ({
  registry,
  select,
  dispatch
}) => {
  const selectionAnchor = select.getSelectionStart();
  const selectionFocus = select.getSelectionEnd();
  const anchorRootClientId = select.getBlockRootClientId(selectionAnchor.clientId);
  const focusRootClientId = select.getBlockRootClientId(selectionFocus.clientId);

  // It's not splittable if the selection doesn't start and end in the same
  // block list. Maybe in the future it should be allowed.
  if (anchorRootClientId !== focusRootClientId) {
    return;
  }
  const blockOrder = select.getBlockOrder(anchorRootClientId);
  const anchorIndex = blockOrder.indexOf(selectionAnchor.clientId);
  const focusIndex = blockOrder.indexOf(selectionFocus.clientId);

  // Reassign selection start and end based on order.
  let selectionStart, selectionEnd;
  if (anchorIndex > focusIndex) {
    selectionStart = selectionFocus;
    selectionEnd = selectionAnchor;
  } else {
    selectionStart = selectionAnchor;
    selectionEnd = selectionFocus;
  }
  const selectionA = selectionStart;
  const selectionB = selectionEnd;
  const blockA = select.getBlock(selectionA.clientId);
  const blockB = select.getBlock(selectionB.clientId);
  const blockAType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockA.name);
  const blockBType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockB.name);
  const attributeKeyA = typeof selectionA.attributeKey === 'string' ? selectionA.attributeKey : findRichTextAttributeKey(blockAType);
  const attributeKeyB = typeof selectionB.attributeKey === 'string' ? selectionB.attributeKey : findRichTextAttributeKey(blockBType);
  const blockAttributes = select.getBlockAttributes(selectionA.clientId);
  const bindings = blockAttributes?.metadata?.bindings;

  // If the attribute is bound, don't split the selection and insert a new block instead.
  if (bindings?.[attributeKeyA]) {
    // Show warning if user tries to insert a block into another block with bindings.
    if (blocks.length) {
      const {
        createWarningNotice
      } = registry.dispatch(external_wp_notices_namespaceObject.store);
      createWarningNotice((0,external_wp_i18n_namespaceObject.__)("Blocks can't be inserted into other blocks with bindings"), {
        type: 'snackbar'
      });
      return;
    }
    dispatch.insertAfterBlock(selectionA.clientId);
    return;
  }

  // Can't split if the selection is not set.
  if (!attributeKeyA || !attributeKeyB || typeof selectionAnchor.offset === 'undefined' || typeof selectionFocus.offset === 'undefined') {
    return;
  }

  // We can do some short-circuiting if the selection is collapsed.
  if (selectionA.clientId === selectionB.clientId && attributeKeyA === attributeKeyB && selectionA.offset === selectionB.offset) {
    // If an unmodified default block is selected, replace it. We don't
    // want to be converting into a default block.
    if (blocks.length) {
      if ((0,external_wp_blocks_namespaceObject.isUnmodifiedDefaultBlock)(blockA)) {
        dispatch.replaceBlocks([selectionA.clientId], blocks, blocks.length - 1, -1);
        return;
      }
    }

    // If selection is at the start or end, we can simply insert an
    // empty block, provided this block has no inner blocks.
    else if (!select.getBlockOrder(selectionA.clientId).length) {
      function createEmpty() {
        const defaultBlockName = (0,external_wp_blocks_namespaceObject.getDefaultBlockName)();
        return select.canInsertBlockType(defaultBlockName, anchorRootClientId) ? (0,external_wp_blocks_namespaceObject.createBlock)(defaultBlockName) : (0,external_wp_blocks_namespaceObject.createBlock)(select.getBlockName(selectionA.clientId));
      }
      const length = blockAttributes[attributeKeyA].length;
      if (selectionA.offset === 0 && length) {
        dispatch.insertBlocks([createEmpty()], select.getBlockIndex(selectionA.clientId), anchorRootClientId, false);
        return;
      }
      if (selectionA.offset === length) {
        dispatch.insertBlocks([createEmpty()], select.getBlockIndex(selectionA.clientId) + 1, anchorRootClientId);
        return;
      }
    }
  }
  const htmlA = blockA.attributes[attributeKeyA];
  const htmlB = blockB.attributes[attributeKeyB];
  let valueA = (0,external_wp_richText_namespaceObject.create)({
    html: htmlA
  });
  let valueB = (0,external_wp_richText_namespaceObject.create)({
    html: htmlB
  });
  valueA = (0,external_wp_richText_namespaceObject.remove)(valueA, selectionA.offset, valueA.text.length);
  valueB = (0,external_wp_richText_namespaceObject.remove)(valueB, 0, selectionB.offset);
  let head = {
    // Preserve the original client ID.
    ...blockA,
    // If both start and end are the same, should only copy innerBlocks
    // once.
    innerBlocks: blockA.clientId === blockB.clientId ? [] : blockA.innerBlocks,
    attributes: {
      ...blockA.attributes,
      [attributeKeyA]: (0,external_wp_richText_namespaceObject.toHTMLString)({
        value: valueA
      })
    }
  };
  const tail = {
    ...blockB,
    // Only preserve the original client ID if the end is different.
    clientId: blockA.clientId === blockB.clientId ? (0,external_wp_blocks_namespaceObject.createBlock)(blockB.name).clientId : blockB.clientId,
    attributes: {
      ...blockB.attributes,
      [attributeKeyB]: (0,external_wp_richText_namespaceObject.toHTMLString)({
        value: valueB
      })
    }
  };
  if (!blocks.length) {
    dispatch.replaceBlocks(select.getSelectedBlockClientIds(), [head, tail]);
    return;
  }
  let selection;
  const output = [];
  const clonedBlocks = [...blocks];
  const firstBlock = clonedBlocks.shift();
  const headType = (0,external_wp_blocks_namespaceObject.getBlockType)(head.name);
  const firstBlocks = headType.merge && firstBlock.name === headType.name ? [firstBlock] : (0,external_wp_blocks_namespaceObject.switchToBlockType)(firstBlock, headType.name);
  if (firstBlocks?.length) {
    const first = firstBlocks.shift();
    head = {
      ...head,
      attributes: {
        ...head.attributes,
        ...headType.merge(head.attributes, first.attributes)
      }
    };
    output.push(head);
    selection = {
      clientId: head.clientId,
      attributeKey: attributeKeyA,
      offset: (0,external_wp_richText_namespaceObject.create)({
        html: head.attributes[attributeKeyA]
      }).text.length
    };
    clonedBlocks.unshift(...firstBlocks);
  } else {
    if (!(0,external_wp_blocks_namespaceObject.isUnmodifiedBlock)(head)) {
      output.push(head);
    }
    output.push(firstBlock);
  }
  const lastBlock = clonedBlocks.pop();
  const tailType = (0,external_wp_blocks_namespaceObject.getBlockType)(tail.name);
  if (clonedBlocks.length) {
    output.push(...clonedBlocks);
  }
  if (lastBlock) {
    const lastBlocks = tailType.merge && tailType.name === lastBlock.name ? [lastBlock] : (0,external_wp_blocks_namespaceObject.switchToBlockType)(lastBlock, tailType.name);
    if (lastBlocks?.length) {
      const last = lastBlocks.pop();
      output.push({
        ...tail,
        attributes: {
          ...tail.attributes,
          ...tailType.merge(last.attributes, tail.attributes)
        }
      });
      output.push(...lastBlocks);
      selection = {
        clientId: tail.clientId,
        attributeKey: attributeKeyB,
        offset: (0,external_wp_richText_namespaceObject.create)({
          html: last.attributes[attributeKeyB]
        }).text.length
      };
    } else {
      output.push(lastBlock);
      if (!(0,external_wp_blocks_namespaceObject.isUnmodifiedBlock)(tail)) {
        output.push(tail);
      }
    }
  } else if (!(0,external_wp_blocks_namespaceObject.isUnmodifiedBlock)(tail)) {
    output.push(tail);
  }
  registry.batch(() => {
    dispatch.replaceBlocks(select.getSelectedBlockClientIds(), output, output.length - 1, 0);
    if (selection) {
      dispatch.selectionChange(selection.clientId, selection.attributeKey, selection.offset, selection.offset);
    }
  });
};

/**
 * Expand the selection to cover the entire blocks, removing partial selection.
 */
const __unstableExpandSelection = () => ({
  select,
  dispatch
}) => {
  const selectionAnchor = select.getSelectionStart();
  const selectionFocus = select.getSelectionEnd();
  dispatch.selectionChange({
    start: {
      clientId: selectionAnchor.clientId
    },
    end: {
      clientId: selectionFocus.clientId
    }
  });
};

/**
 * Action that merges two blocks.
 *
 * @param {string} firstBlockClientId  Client ID of the first block to merge.
 * @param {string} secondBlockClientId Client ID of the second block to merge.
 */
const mergeBlocks = (firstBlockClientId, secondBlockClientId) => ({
  registry,
  select,
  dispatch
}) => {
  const clientIdA = firstBlockClientId;
  const clientIdB = secondBlockClientId;
  const blockA = select.getBlock(clientIdA);
  const blockAType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockA.name);
  if (!blockAType) {
    return;
  }
  const blockB = select.getBlock(clientIdB);
  if (!blockAType.merge && (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockA.name, '__experimentalOnMerge')) {
    // If there's no merge function defined, attempt merging inner
    // blocks.
    const blocksWithTheSameType = (0,external_wp_blocks_namespaceObject.switchToBlockType)(blockB, blockAType.name);
    // Only focus the previous block if it's not mergeable.
    if (blocksWithTheSameType?.length !== 1) {
      dispatch.selectBlock(blockA.clientId);
      return;
    }
    const [blockWithSameType] = blocksWithTheSameType;
    if (blockWithSameType.innerBlocks.length < 1) {
      dispatch.selectBlock(blockA.clientId);
      return;
    }
    registry.batch(() => {
      dispatch.insertBlocks(blockWithSameType.innerBlocks, undefined, clientIdA);
      dispatch.removeBlock(clientIdB);
      dispatch.selectBlock(blockWithSameType.innerBlocks[0].clientId);

      // Attempt to merge the next block if it's the same type and
      // same attributes. This is useful when merging a paragraph into
      // a list, and the next block is also a list. If we don't merge,
      // it looks like one list, but it's actually two lists. The same
      // applies to other blocks such as a group with the same
      // attributes.
      const nextBlockClientId = select.getNextBlockClientId(clientIdA);
      if (nextBlockClientId && select.getBlockName(clientIdA) === select.getBlockName(nextBlockClientId)) {
        const rootAttributes = select.getBlockAttributes(clientIdA);
        const previousRootAttributes = select.getBlockAttributes(nextBlockClientId);
        if (Object.keys(rootAttributes).every(key => rootAttributes[key] === previousRootAttributes[key])) {
          dispatch.moveBlocksToPosition(select.getBlockOrder(nextBlockClientId), nextBlockClientId, clientIdA);
          dispatch.removeBlock(nextBlockClientId, false);
        }
      }
    });
    return;
  }
  if ((0,external_wp_blocks_namespaceObject.isUnmodifiedDefaultBlock)(blockA)) {
    dispatch.removeBlock(clientIdA, select.isBlockSelected(clientIdA));
    return;
  }
  if ((0,external_wp_blocks_namespaceObject.isUnmodifiedDefaultBlock)(blockB)) {
    dispatch.removeBlock(clientIdB, select.isBlockSelected(clientIdB));
    return;
  }
  if (!blockAType.merge) {
    dispatch.selectBlock(blockA.clientId);
    return;
  }
  const blockBType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockB.name);
  const {
    clientId,
    attributeKey,
    offset
  } = select.getSelectionStart();
  const selectedBlockType = clientId === clientIdA ? blockAType : blockBType;
  const attributeDefinition = selectedBlockType.attributes[attributeKey];
  const canRestoreTextSelection = (clientId === clientIdA || clientId === clientIdB) && attributeKey !== undefined && offset !== undefined &&
  // We cannot restore text selection if the RichText identifier
  // is not a defined block attribute key. This can be the case if the
  // fallback intance ID is used to store selection (and no RichText
  // identifier is set), or when the identifier is wrong.
  !!attributeDefinition;
  if (!attributeDefinition) {
    if (typeof attributeKey === 'number') {
      window.console.error(`RichText needs an identifier prop that is the block attribute key of the attribute it controls. Its type is expected to be a string, but was ${typeof attributeKey}`);
    } else {
      window.console.error('The RichText identifier prop does not match any attributes defined by the block.');
    }
  }

  // Clone the blocks so we don't insert the character in a "live" block.
  const cloneA = (0,external_wp_blocks_namespaceObject.cloneBlock)(blockA);
  const cloneB = (0,external_wp_blocks_namespaceObject.cloneBlock)(blockB);
  if (canRestoreTextSelection) {
    const selectedBlock = clientId === clientIdA ? cloneA : cloneB;
    const html = selectedBlock.attributes[attributeKey];
    const value = (0,external_wp_richText_namespaceObject.insert)((0,external_wp_richText_namespaceObject.create)({
      html
    }), START_OF_SELECTED_AREA, offset, offset);
    selectedBlock.attributes[attributeKey] = (0,external_wp_richText_namespaceObject.toHTMLString)({
      value
    });
  }

  // We can only merge blocks with similar types
  // thus, we transform the block to merge first.
  const blocksWithTheSameType = blockA.name === blockB.name ? [cloneB] : (0,external_wp_blocks_namespaceObject.switchToBlockType)(cloneB, blockA.name);

  // If the block types can not match, do nothing.
  if (!blocksWithTheSameType || !blocksWithTheSameType.length) {
    return;
  }

  // Calling the merge to update the attributes and remove the block to be merged.
  const updatedAttributes = blockAType.merge(cloneA.attributes, blocksWithTheSameType[0].attributes);
  if (canRestoreTextSelection) {
    const newAttributeKey = retrieveSelectedAttribute(updatedAttributes);
    const convertedHtml = updatedAttributes[newAttributeKey];
    const convertedValue = (0,external_wp_richText_namespaceObject.create)({
      html: convertedHtml
    });
    const newOffset = convertedValue.text.indexOf(START_OF_SELECTED_AREA);
    const newValue = (0,external_wp_richText_namespaceObject.remove)(convertedValue, newOffset, newOffset + 1);
    const newHtml = (0,external_wp_richText_namespaceObject.toHTMLString)({
      value: newValue
    });
    updatedAttributes[newAttributeKey] = newHtml;
    dispatch.selectionChange(blockA.clientId, newAttributeKey, newOffset, newOffset);
  }
  dispatch.replaceBlocks([blockA.clientId, blockB.clientId], [{
    ...blockA,
    attributes: {
      ...blockA.attributes,
      ...updatedAttributes
    }
  }, ...blocksWithTheSameType.slice(1)], 0 // If we don't pass the `indexToSelect` it will default to the last block.
  );
};

/**
 * Yields action objects used in signalling that the blocks corresponding to
 * the set of specified client IDs are to be removed.
 *
 * @param {string|string[]} clientIds      Client IDs of blocks to remove.
 * @param {boolean}         selectPrevious True if the previous block
 *                                         or the immediate parent
 *                                         (if no previous block exists)
 *                                         should be selected
 *                                         when a block is removed.
 */
const removeBlocks = (clientIds, selectPrevious = true) => privateRemoveBlocks(clientIds, selectPrevious);

/**
 * Returns an action object used in signalling that the block with the
 * specified client ID is to be removed.
 *
 * @param {string}  clientId       Client ID of block to remove.
 * @param {boolean} selectPrevious True if the previous block should be
 *                                 selected when a block is removed.
 *
 * @return {Object} Action object.
 */
function removeBlock(clientId, selectPrevious) {
  return removeBlocks([clientId], selectPrevious);
}

/* eslint-disable jsdoc/valid-types */
/**
 * Returns an action object used in signalling that the inner blocks with the
 * specified client ID should be replaced.
 *
 * @param {string}    rootClientId    Client ID of the block whose InnerBlocks will re replaced.
 * @param {Object[]}  blocks          Block objects to insert as new InnerBlocks
 * @param {?boolean}  updateSelection If true block selection will be updated. If false, block selection will not change. Defaults to false.
 * @param {0|-1|null} initialPosition Initial block position.
 * @return {Object} Action object.
 */
function replaceInnerBlocks(rootClientId, blocks, updateSelection = false, initialPosition = 0) {
  /* eslint-enable jsdoc/valid-types */
  return {
    type: 'REPLACE_INNER_BLOCKS',
    rootClientId,
    blocks,
    updateSelection,
    initialPosition: updateSelection ? initialPosition : null,
    time: Date.now()
  };
}

/**
 * Returns an action object used to toggle the block editing mode between
 * visual and HTML modes.
 *
 * @param {string} clientId Block client ID.
 *
 * @return {Object} Action object.
 */
function toggleBlockMode(clientId) {
  return {
    type: 'TOGGLE_BLOCK_MODE',
    clientId
  };
}

/**
 * Returns an action object used in signalling that the user has begun to type.
 *
 * @return {Object} Action object.
 */
function startTyping() {
  return {
    type: 'START_TYPING'
  };
}

/**
 * Returns an action object used in signalling that the user has stopped typing.
 *
 * @return {Object} Action object.
 */
function stopTyping() {
  return {
    type: 'STOP_TYPING'
  };
}

/**
 * Returns an action object used in signalling that the user has begun to drag blocks.
 *
 * @param {string[]} clientIds An array of client ids being dragged
 *
 * @return {Object} Action object.
 */
function startDraggingBlocks(clientIds = []) {
  return {
    type: 'START_DRAGGING_BLOCKS',
    clientIds
  };
}

/**
 * Returns an action object used in signalling that the user has stopped dragging blocks.
 *
 * @return {Object} Action object.
 */
function stopDraggingBlocks() {
  return {
    type: 'STOP_DRAGGING_BLOCKS'
  };
}

/**
 * Returns an action object used in signalling that the caret has entered formatted text.
 *
 * @deprecated
 *
 * @return {Object} Action object.
 */
function enterFormattedText() {
  external_wp_deprecated_default()('wp.data.dispatch( "core/block-editor" ).enterFormattedText', {
    since: '6.1',
    version: '6.3'
  });
  return {
    type: 'DO_NOTHING'
  };
}

/**
 * Returns an action object used in signalling that the user caret has exited formatted text.
 *
 * @deprecated
 *
 * @return {Object} Action object.
 */
function exitFormattedText() {
  external_wp_deprecated_default()('wp.data.dispatch( "core/block-editor" ).exitFormattedText', {
    since: '6.1',
    version: '6.3'
  });
  return {
    type: 'DO_NOTHING'
  };
}

/**
 * Action that changes the position of the user caret.
 *
 * @param {string|WPSelection} clientId     The selected block client ID.
 * @param {string}             attributeKey The selected block attribute key.
 * @param {number}             startOffset  The start offset.
 * @param {number}             endOffset    The end offset.
 *
 * @return {Object} Action object.
 */
function selectionChange(clientId, attributeKey, startOffset, endOffset) {
  if (typeof clientId === 'string') {
    return {
      type: 'SELECTION_CHANGE',
      clientId,
      attributeKey,
      startOffset,
      endOffset
    };
  }
  return {
    type: 'SELECTION_CHANGE',
    ...clientId
  };
}

/**
 * Action that adds a new block of the default type to the block list.
 *
 * @param {?Object} attributes   Optional attributes of the block to assign.
 * @param {?string} rootClientId Optional root client ID of block list on which
 *                               to append.
 * @param {?number} index        Optional index where to insert the default block.
 */
const insertDefaultBlock = (attributes, rootClientId, index) => ({
  dispatch
}) => {
  // Abort if there is no default block type (if it has been unregistered).
  const defaultBlockName = (0,external_wp_blocks_namespaceObject.getDefaultBlockName)();
  if (!defaultBlockName) {
    return;
  }
  const block = (0,external_wp_blocks_namespaceObject.createBlock)(defaultBlockName, attributes);
  return dispatch.insertBlock(block, index, rootClientId);
};

/**
 * @typedef {Object< string, Object >} SettingsByClientId
 */

/**
 * Action that changes the nested settings of the given block(s).
 *
 * @param {string | SettingsByClientId} clientId Client ID of the block whose
 *                                               nested setting are being
 *                                               received, or object of settings
 *                                               by client ID.
 * @param {Object}                      settings Object with the new settings
 *                                               for the nested block.
 *
 * @return {Object} Action object
 */
function updateBlockListSettings(clientId, settings) {
  return {
    type: 'UPDATE_BLOCK_LIST_SETTINGS',
    clientId,
    settings
  };
}

/**
 * Action that updates the block editor settings.
 *
 * @param {Object} settings Updated settings
 *
 * @return {Object} Action object
 */
function updateSettings(settings) {
  return __experimentalUpdateSettings(settings, {
    stripExperimentalSettings: true
  });
}

/**
 * Action that signals that a temporary reusable block has been saved
 * in order to switch its temporary id with the real id.
 *
 * @param {string} id        Reusable block's id.
 * @param {string} updatedId Updated block's id.
 *
 * @return {Object} Action object.
 */
function __unstableSaveReusableBlock(id, updatedId) {
  return {
    type: 'SAVE_REUSABLE_BLOCK_SUCCESS',
    id,
    updatedId
  };
}

/**
 * Action that marks the last block change explicitly as persistent.
 *
 * @return {Object} Action object.
 */
function __unstableMarkLastChangeAsPersistent() {
  return {
    type: 'MARK_LAST_CHANGE_AS_PERSISTENT'
  };
}

/**
 * Action that signals that the next block change should be marked explicitly as not persistent.
 *
 * @return {Object} Action object.
 */
function __unstableMarkNextChangeAsNotPersistent() {
  return {
    type: 'MARK_NEXT_CHANGE_AS_NOT_PERSISTENT'
  };
}

/**
 * Action that marks the last block change as an automatic change, meaning it was not
 * performed by the user, and can be undone using the `Escape` and `Backspace` keys.
 * This action must be called after the change was made, and any actions that are a
 * consequence of it, so it is recommended to be called at the next idle period to ensure all
 * selection changes have been recorded.
 */
const __unstableMarkAutomaticChange = () => ({
  dispatch
}) => {
  dispatch({
    type: 'MARK_AUTOMATIC_CHANGE'
  });
  const {
    requestIdleCallback = cb => setTimeout(cb, 100)
  } = window;
  requestIdleCallback(() => {
    dispatch({
      type: 'MARK_AUTOMATIC_CHANGE_FINAL'
    });
  });
};

/**
 * Action that enables or disables the navigation mode.
 *
 * @param {boolean} isNavigationMode Enable/Disable navigation mode.
 */
const setNavigationMode = (isNavigationMode = true) => ({
  dispatch
}) => {
  dispatch.__unstableSetEditorMode(isNavigationMode ? 'navigation' : 'edit');
};

/**
 * Action that sets the editor mode
 *
 * @param {string} mode Editor mode
 */
const __unstableSetEditorMode = mode => ({
  dispatch,
  select,
  registry
}) => {
  // When switching to zoom-out mode, we need to select the parent section
  if (mode === 'zoom-out') {
    const firstSelectedClientId = select.getBlockSelectionStart();
    const {
      sectionRootClientId
    } = unlock(registry.select(STORE_NAME).getSettings());
    if (firstSelectedClientId) {
      let sectionClientId;
      if (sectionRootClientId) {
        const sectionClientIds = select.getBlockOrder(sectionRootClientId);
        sectionClientId = select.getBlockParents(firstSelectedClientId).find(parent => sectionClientIds.includes(parent));
      } else {
        sectionClientId = select.getBlockHierarchyRootClientId(firstSelectedClientId);
      }
      if (sectionClientId) {
        dispatch.selectBlock(sectionClientId);
      } else {
        dispatch.clearSelectedBlock();
      }
    }
  }
  dispatch({
    type: 'SET_EDITOR_MODE',
    mode
  });
  if (mode === 'navigation') {
    (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('You are currently in navigation mode. Navigate blocks using the Tab key and Arrow keys. Use Left and Right Arrow keys to move between nesting levels. To exit navigation mode and edit the selected block, press Enter.'));
  } else if (mode === 'edit') {
    (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('You are currently in edit mode. To return to the navigation mode, press Escape.'));
  } else if (mode === 'zoom-out') {
    (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('You are currently in zoom-out mode.'));
  }
};

/**
 * Action that enables or disables the block moving mode.
 *
 * @param {string|null} hasBlockMovingClientId Enable/Disable block moving mode.
 */
const setBlockMovingClientId = (hasBlockMovingClientId = null) => ({
  dispatch
}) => {
  dispatch({
    type: 'SET_BLOCK_MOVING_MODE',
    hasBlockMovingClientId
  });
  if (hasBlockMovingClientId) {
    (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('Use the Tab key and Arrow keys to choose new block location. Use Left and Right Arrow keys to move between nesting levels. Once location is selected press Enter or Space to move the block.'));
  }
};

/**
 * Action that duplicates a list of blocks.
 *
 * @param {string[]} clientIds
 * @param {boolean}  updateSelection
 */
const duplicateBlocks = (clientIds, updateSelection = true) => ({
  select,
  dispatch
}) => {
  if (!clientIds || !clientIds.length) {
    return;
  }

  // Return early if blocks don't exist.
  const blocks = select.getBlocksByClientId(clientIds);
  if (blocks.some(block => !block)) {
    return;
  }

  // Return early if blocks don't support multiple usage.
  const blockNames = blocks.map(block => block.name);
  if (blockNames.some(blockName => !(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockName, 'multiple', true))) {
    return;
  }
  const rootClientId = select.getBlockRootClientId(clientIds[0]);
  const clientIdsArray = actions_castArray(clientIds);
  const lastSelectedIndex = select.getBlockIndex(clientIdsArray[clientIdsArray.length - 1]);
  const clonedBlocks = blocks.map(block => (0,external_wp_blocks_namespaceObject.__experimentalCloneSanitizedBlock)(block));
  dispatch.insertBlocks(clonedBlocks, lastSelectedIndex + 1, rootClientId, updateSelection);
  if (clonedBlocks.length > 1 && updateSelection) {
    dispatch.multiSelect(clonedBlocks[0].clientId, clonedBlocks[clonedBlocks.length - 1].clientId);
  }
  return clonedBlocks.map(block => block.clientId);
};

/**
 * Action that inserts a default block before a given block.
 *
 * @param {string} clientId
 */
const insertBeforeBlock = clientId => ({
  select,
  dispatch
}) => {
  if (!clientId) {
    return;
  }
  const rootClientId = select.getBlockRootClientId(clientId);
  const isLocked = select.getTemplateLock(rootClientId);
  if (isLocked) {
    return;
  }
  const blockIndex = select.getBlockIndex(clientId);
  const directInsertBlock = rootClientId ? select.getDirectInsertBlock(rootClientId) : null;
  if (!directInsertBlock) {
    return dispatch.insertDefaultBlock({}, rootClientId, blockIndex);
  }
  const copiedAttributes = {};
  if (directInsertBlock.attributesToCopy) {
    const attributes = select.getBlockAttributes(clientId);
    directInsertBlock.attributesToCopy.forEach(key => {
      if (attributes[key]) {
        copiedAttributes[key] = attributes[key];
      }
    });
  }
  const block = (0,external_wp_blocks_namespaceObject.createBlock)(directInsertBlock.name, {
    ...directInsertBlock.attributes,
    ...copiedAttributes
  });
  return dispatch.insertBlock(block, blockIndex, rootClientId);
};

/**
 * Action that inserts a default block after a given block.
 *
 * @param {string} clientId
 */
const insertAfterBlock = clientId => ({
  select,
  dispatch
}) => {
  if (!clientId) {
    return;
  }
  const rootClientId = select.getBlockRootClientId(clientId);
  const isLocked = select.getTemplateLock(rootClientId);
  if (isLocked) {
    return;
  }
  const blockIndex = select.getBlockIndex(clientId);
  const directInsertBlock = rootClientId ? select.getDirectInsertBlock(rootClientId) : null;
  if (!directInsertBlock) {
    return dispatch.insertDefaultBlock({}, rootClientId, blockIndex + 1);
  }
  const copiedAttributes = {};
  if (directInsertBlock.attributesToCopy) {
    const attributes = select.getBlockAttributes(clientId);
    directInsertBlock.attributesToCopy.forEach(key => {
      if (attributes[key]) {
        copiedAttributes[key] = attributes[key];
      }
    });
  }
  const block = (0,external_wp_blocks_namespaceObject.createBlock)(directInsertBlock.name, {
    ...directInsertBlock.attributes,
    ...copiedAttributes
  });
  return dispatch.insertBlock(block, blockIndex + 1, rootClientId);
};

/**
 * Action that toggles the highlighted block state.
 *
 * @param {string}  clientId      The block's clientId.
 * @param {boolean} isHighlighted The highlight state.
 */
function toggleBlockHighlight(clientId, isHighlighted) {
  return {
    type: 'TOGGLE_BLOCK_HIGHLIGHT',
    clientId,
    isHighlighted
  };
}

/**
 * Action that "flashes" the block with a given `clientId` by rhythmically highlighting it.
 *
 * @param {string} clientId Target block client ID.
 */
const flashBlock = clientId => async ({
  dispatch
}) => {
  dispatch(toggleBlockHighlight(clientId, true));
  await new Promise(resolve => setTimeout(resolve, 150));
  dispatch(toggleBlockHighlight(clientId, false));
};

/**
 * Action that sets whether a block has controlled inner blocks.
 *
 * @param {string}  clientId                 The block's clientId.
 * @param {boolean} hasControlledInnerBlocks True if the block's inner blocks are controlled.
 */
function setHasControlledInnerBlocks(clientId, hasControlledInnerBlocks) {
  return {
    type: 'SET_HAS_CONTROLLED_INNER_BLOCKS',
    hasControlledInnerBlocks,
    clientId
  };
}

/**
 * Action that sets whether given blocks are visible on the canvas.
 *
 * @param {Record<string,boolean>} updates For each block's clientId, its new visibility setting.
 */
function setBlockVisibility(updates) {
  return {
    type: 'SET_BLOCK_VISIBILITY',
    updates
  };
}

/**
 * Action that sets whether a block is being temporarily edited as blocks.
 *
 * DO-NOT-USE in production.
 * This action is created for internal/experimental only usage and may be
 * removed anytime without any warning, causing breakage on any plugin or theme invoking it.
 *
 * @param {?string} temporarilyEditingAsBlocks The block's clientId being temporarily edited as blocks.
 * @param {?string} focusModeToRevert          The focus mode to revert after temporarily edit as blocks finishes.
 */
function __unstableSetTemporarilyEditingAsBlocks(temporarilyEditingAsBlocks, focusModeToRevert) {
  return {
    type: 'SET_TEMPORARILY_EDITING_AS_BLOCKS',
    temporarilyEditingAsBlocks,
    focusModeToRevert
  };
}

/**
 * Interface for inserter media requests.
 *
 * @typedef {Object} InserterMediaRequest
 * @property {number} per_page How many items to fetch per page.
 * @property {string} search   The search term to use for filtering the results.
 */

/**
 * Interface for inserter media responses. Any media resource should
 * map their response to this interface, in order to create the core
 * WordPress media blocks (image, video, audio).
 *
 * @typedef {Object} InserterMediaItem
 * @property {string}        title        The title of the media item.
 * @property {string}        url          The source url of the media item.
 * @property {string}        [previewUrl] The preview source url of the media item to display in the media list.
 * @property {number}        [id]         The WordPress id of the media item.
 * @property {number|string} [sourceId]   The id of the media item from external source.
 * @property {string}        [alt]        The alt text of the media item.
 * @property {string}        [caption]    The caption of the media item.
 */

/**
 * Registers a new inserter media category. Once registered, the media category is
 * available in the inserter's media tab.
 *
 * The following interfaces are used:
 *
 * _Type Definition_
 *
 * - _InserterMediaRequest_ `Object`: Interface for inserter media requests.
 *
 * _Properties_
 *
 * - _per_page_ `number`: How many items to fetch per page.
 * - _search_ `string`: The search term to use for filtering the results.
 *
 * _Type Definition_
 *
 * - _InserterMediaItem_ `Object`: Interface for inserter media responses. Any media resource should
 * map their response to this interface, in order to create the core
 * WordPress media blocks (image, video, audio).
 *
 * _Properties_
 *
 * - _title_ `string`: The title of the media item.
 * - _url_ `string: The source url of the media item.
 * - _previewUrl_ `[string]`: The preview source url of the media item to display in the media list.
 * - _id_ `[number]`: The WordPress id of the media item.
 * - _sourceId_ `[number|string]`: The id of the media item from external source.
 * - _alt_ `[string]`: The alt text of the media item.
 * - _caption_ `[string]`: The caption of the media item.
 *
 * @param    {InserterMediaCategory}                                  category                       The inserter media category to register.
 *
 * @example
 * ```js
 *
 * wp.data.dispatch('core/block-editor').registerInserterMediaCategory( {
 * 	 name: 'openverse',
 * 	 labels: {
 * 	 	name: 'Openverse',
 * 	 	search_items: 'Search Openverse',
 * 	 },
 * 	 mediaType: 'image',
 * 	 async fetch( query = {} ) {
 * 	 	const defaultArgs = {
 * 	 		mature: false,
 * 	 		excluded_source: 'flickr,inaturalist,wikimedia',
 * 	 		license: 'pdm,cc0',
 * 	 	};
 * 	 	const finalQuery = { ...query, ...defaultArgs };
 * 	 	// Sometimes you might need to map the supported request params according to `InserterMediaRequest`.
 * 	 	// interface. In this example the `search` query param is named `q`.
 * 	 	const mapFromInserterMediaRequest = {
 * 	 		per_page: 'page_size',
 * 	 		search: 'q',
 * 	 	};
 * 	 	const url = new URL( 'https://api.openverse.engineering/v1/images/' );
 * 	 	Object.entries( finalQuery ).forEach( ( [ key, value ] ) => {
 * 	 		const queryKey = mapFromInserterMediaRequest[ key ] || key;
 * 	 		url.searchParams.set( queryKey, value );
 * 	 	} );
 * 	 	const response = await window.fetch( url, {
 * 	 		headers: {
 * 	 			'User-Agent': 'WordPress/inserter-media-fetch',
 * 	 		},
 * 	 	} );
 * 	 	const jsonResponse = await response.json();
 * 	 	const results = jsonResponse.results;
 * 	 	return results.map( ( result ) => ( {
 * 	 		...result,
 * 	 		// If your response result includes an `id` prop that you want to access later, it should
 * 	 		// be mapped to `InserterMediaItem`'s `sourceId` prop. This can be useful if you provide
 * 	 		// a report URL getter.
 * 	 		// Additionally you should always clear the `id` value of your response results because
 * 	 		// it is used to identify WordPress media items.
 * 	 		sourceId: result.id,
 * 	 		id: undefined,
 * 	 		caption: result.caption,
 * 	 		previewUrl: result.thumbnail,
 * 	 	} ) );
 * 	 },
 * 	 getReportUrl: ( { sourceId } ) =>
 * 	 	`https://wordpress.org/openverse/image/${ sourceId }/report/`,
 * 	 isExternalResource: true,
 * } );
 * ```
 *
 * @typedef {Object} InserterMediaCategory Interface for inserter media category.
 * @property {string}                                                 name                           The name of the media category, that should be unique among all media categories.
 * @property {Object}                                                 labels                         Labels for the media category.
 * @property {string}                                                 labels.name                    General name of the media category. It's used in the inserter media items list.
 * @property {string}                                                 [labels.search_items='Search'] Label for searching items. Default is ‘Search Posts’ / ‘Search Pages’.
 * @property {('image'|'audio'|'video')}                              mediaType                      The media type of the media category.
 * @property {(InserterMediaRequest) => Promise<InserterMediaItem[]>} fetch                          The function to fetch media items for the category.
 * @property {(InserterMediaItem) => string}                          [getReportUrl]                 If the media category supports reporting media items, this function should return
 *                                                                                                   the report url for the media item. It accepts the `InserterMediaItem` as an argument.
 * @property {boolean}                                                [isExternalResource]           If the media category is an external resource, this should be set to true.
 *                                                                                                   This is used to avoid making a request to the external resource when the user
 */
const registerInserterMediaCategory = category => ({
  select,
  dispatch
}) => {
  if (!category || typeof category !== 'object') {
    console.error('Category should be an `InserterMediaCategory` object.');
    return;
  }
  if (!category.name) {
    console.error('Category should have a `name` that should be unique among all media categories.');
    return;
  }
  if (!category.labels?.name) {
    console.error('Category should have a `labels.name`.');
    return;
  }
  if (!['image', 'audio', 'video'].includes(category.mediaType)) {
    console.error('Category should have `mediaType` property that is one of `image|audio|video`.');
    return;
  }
  if (!category.fetch || typeof category.fetch !== 'function') {
    console.error('Category should have a `fetch` function defined with the following signature `(InserterMediaRequest) => Promise<InserterMediaItem[]>`.');
    return;
  }
  const registeredInserterMediaCategories = select.getRegisteredInserterMediaCategories();
  if (registeredInserterMediaCategories.some(({
    name
  }) => name === category.name)) {
    console.error(`A category is already registered with the same name: "${category.name}".`);
    return;
  }
  if (registeredInserterMediaCategories.some(({
    labels: {
      name
    } = {}
  }) => name === category.labels?.name)) {
    console.error(`A category is already registered with the same labels.name: "${category.labels.name}".`);
    return;
  }
  // `inserterMediaCategories` is a private block editor setting, which means it cannot
  // be updated through the public `updateSettings` action. We preserve this setting as
  // private, so extenders can only add new inserter media categories and don't have any
  // control over the core media categories.
  dispatch({
    type: 'REGISTER_INSERTER_MEDIA_CATEGORY',
    category: {
      ...category,
      isExternalResource: true
    }
  });
};

/**
 * @typedef {import('../components/block-editing-mode').BlockEditingMode} BlockEditingMode
 */

/**
 * Sets the block editing mode for a given block.
 *
 * @see useBlockEditingMode
 *
 * @param {string}           clientId The block client ID, or `''` for the root container.
 * @param {BlockEditingMode} mode     The block editing mode. One of `'disabled'`,
 *                                    `'contentOnly'`, or `'default'`.
 *
 * @return {Object} Action object.
 */
function setBlockEditingMode(clientId = '', mode) {
  return {
    type: 'SET_BLOCK_EDITING_MODE',
    clientId,
    mode
  };
}

/**
 * Clears the block editing mode for a given block.
 *
 * @see useBlockEditingMode
 *
 * @param {string} clientId The block client ID, or `''` for the root container.
 *
 * @return {Object} Action object.
 */
function unsetBlockEditingMode(clientId = '') {
  return {
    type: 'UNSET_BLOCK_EDITING_MODE',
    clientId
  };
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/index.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */








/**
 * Block editor data store configuration.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/data/README.md#registerStore
 */
const storeConfig = {
  reducer: reducer,
  selectors: selectors_namespaceObject,
  actions: actions_namespaceObject
};

/**
 * Store definition for the block editor namespace.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/data/README.md#createReduxStore
 */
const store = (0,external_wp_data_namespaceObject.createReduxStore)(STORE_NAME, {
  ...storeConfig,
  persist: ['preferences']
});

// We will be able to use the `register` function once we switch
// the "preferences" persistence to use the new preferences package.
const registeredStore = (0,external_wp_data_namespaceObject.registerStore)(STORE_NAME, {
  ...storeConfig,
  persist: ['preferences']
});
unlock(registeredStore).registerPrivateActions(private_actions_namespaceObject);
unlock(registeredStore).registerPrivateSelectors(private_selectors_namespaceObject);

// TODO: Remove once we switch to the `register` function (see above).
//
// Until then, private functions also need to be attached to the original
// `store` descriptor in order to avoid unit tests failing, which could happen
// when tests create new registries in which they register stores.
//
// @see https://github.com/WordPress/gutenberg/pull/51145#discussion_r1239999590
unlock(store).registerPrivateActions(private_actions_namespaceObject);
unlock(store).registerPrivateSelectors(private_selectors_namespaceObject);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/use-settings/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




/**
 * Hook that retrieves the given settings for the block instance in use.
 *
 * It looks up the settings first in the block instance hierarchy.
 * If none are found, it'll look them up in the block editor settings.
 *
 * @param {string[]} paths The paths to the settings.
 * @return {any[]} Returns the values defined for the settings.
 * @example
 * ```js
 * const [ fixed, sticky ] = useSettings( 'position.fixed', 'position.sticky' );
 * ```
 */
function use_settings_useSettings(...paths) {
  const {
    clientId = null
  } = useBlockEditContext();
  return (0,external_wp_data_namespaceObject.useSelect)(select => unlock(select(store)).getBlockSettings(clientId, ...paths),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [clientId, ...paths]);
}

/**
 * Hook that retrieves the given setting for the block instance in use.
 *
 * It looks up the setting first in the block instance hierarchy.
 * If none is found, it'll look it up in the block editor settings.
 *
 * @param {string} path The path to the setting.
 * @return {any} Returns the value defined for the setting.
 * @deprecated 6.5.0 Use useSettings instead.
 * @example
 * ```js
 * const isEnabled = useSetting( 'typography.dropCap' );
 * ```
 */
function useSetting(path) {
  external_wp_deprecated_default()('wp.blockEditor.useSetting', {
    since: '6.5',
    alternative: 'wp.blockEditor.useSettings',
    note: 'The new useSettings function can retrieve multiple settings at once, with better performance.'
  });
  const [value] = use_settings_useSettings(path);
  return value;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/font-sizes/fluid-utils.js
/**
 * The fluid utilities must match the backend equivalent.
 * See: gutenberg_get_typography_font_size_value() in lib/block-supports/typography.php
 * ---------------------------------------------------------------
 */

// Defaults.
const DEFAULT_MAXIMUM_VIEWPORT_WIDTH = '1600px';
const DEFAULT_MINIMUM_VIEWPORT_WIDTH = '320px';
const DEFAULT_SCALE_FACTOR = 1;
const DEFAULT_MINIMUM_FONT_SIZE_FACTOR_MIN = 0.25;
const DEFAULT_MINIMUM_FONT_SIZE_FACTOR_MAX = 0.75;
const DEFAULT_MINIMUM_FONT_SIZE_LIMIT = '14px';

/**
 * Computes a fluid font-size value that uses clamp(). A minimum and maximum
 * font size OR a single font size can be specified.
 *
 * If a single font size is specified, it is scaled up and down using a logarithmic scale.
 *
 * @example
 * ```js
 * // Calculate fluid font-size value from a minimum and maximum value.
 * const fontSize = getComputedFluidTypographyValue( {
 *     minimumFontSize: '20px',
 *     maximumFontSize: '45px'
 * } );
 * // Calculate fluid font-size value from a single font size.
 * const fontSize = getComputedFluidTypographyValue( {
 *     fontSize: '30px',
 * } );
 * ```
 *
 * @param {Object}        args
 * @param {?string}       args.minimumViewportWidth Minimum viewport size from which type will have fluidity. Optional if fontSize is specified.
 * @param {?string}       args.maximumViewportWidth Maximum size up to which type will have fluidity. Optional if fontSize is specified.
 * @param {string|number} [args.fontSize]           Size to derive maximumFontSize and minimumFontSize from, if necessary. Optional if minimumFontSize and maximumFontSize are specified.
 * @param {?string}       args.maximumFontSize      Maximum font size for any clamp() calculation. Optional.
 * @param {?string}       args.minimumFontSize      Minimum font size for any clamp() calculation. Optional.
 * @param {?number}       args.scaleFactor          A scale factor to determine how fast a font scales within boundaries. Optional.
 * @param {?string}       args.minimumFontSizeLimit The smallest a calculated font size may be. Optional.
 *
 * @return {string|null} A font-size value using clamp().
 */
function getComputedFluidTypographyValue({
  minimumFontSize,
  maximumFontSize,
  fontSize,
  minimumViewportWidth = DEFAULT_MINIMUM_VIEWPORT_WIDTH,
  maximumViewportWidth = DEFAULT_MAXIMUM_VIEWPORT_WIDTH,
  scaleFactor = DEFAULT_SCALE_FACTOR,
  minimumFontSizeLimit
}) {
  // Validate incoming settings and set defaults.
  minimumFontSizeLimit = !!getTypographyValueAndUnit(minimumFontSizeLimit) ? minimumFontSizeLimit : DEFAULT_MINIMUM_FONT_SIZE_LIMIT;

  /*
   * Calculates missing minimumFontSize and maximumFontSize from
   * defaultFontSize if provided.
   */
  if (fontSize) {
    // Parses default font size.
    const fontSizeParsed = getTypographyValueAndUnit(fontSize);

    // Protect against invalid units.
    if (!fontSizeParsed?.unit) {
      return null;
    }

    // Parses the minimum font size limit, so we can perform checks using it.
    const minimumFontSizeLimitParsed = getTypographyValueAndUnit(minimumFontSizeLimit, {
      coerceTo: fontSizeParsed.unit
    });

    // Don't enforce minimum font size if a font size has explicitly set a min and max value.
    if (!!minimumFontSizeLimitParsed?.value && !minimumFontSize && !maximumFontSize) {
      /*
       * If a minimum size was not passed to this function
       * and the user-defined font size is lower than $minimum_font_size_limit,
       * do not calculate a fluid value.
       */
      if (fontSizeParsed?.value <= minimumFontSizeLimitParsed?.value) {
        return null;
      }
    }

    // If no fluid max font size is available use the incoming value.
    if (!maximumFontSize) {
      maximumFontSize = `${fontSizeParsed.value}${fontSizeParsed.unit}`;
    }

    /*
     * If no minimumFontSize is provided, create one using
     * the given font size multiplied by the min font size scale factor.
     */
    if (!minimumFontSize) {
      const fontSizeValueInPx = fontSizeParsed.unit === 'px' ? fontSizeParsed.value : fontSizeParsed.value * 16;

      /*
       * The scale factor is a multiplier that affects how quickly the curve will move towards the minimum,
       * that is, how quickly the size factor reaches 0 given increasing font size values.
       * For a - b * log2(), lower values of b will make the curve move towards the minimum faster.
       * The scale factor is constrained between min and max values.
       */
      const minimumFontSizeFactor = Math.min(Math.max(1 - 0.075 * Math.log2(fontSizeValueInPx), DEFAULT_MINIMUM_FONT_SIZE_FACTOR_MIN), DEFAULT_MINIMUM_FONT_SIZE_FACTOR_MAX);

      // Calculates the minimum font size.
      const calculatedMinimumFontSize = roundToPrecision(fontSizeParsed.value * minimumFontSizeFactor, 3);

      // Only use calculated min font size if it's > $minimum_font_size_limit value.
      if (!!minimumFontSizeLimitParsed?.value && calculatedMinimumFontSize < minimumFontSizeLimitParsed?.value) {
        minimumFontSize = `${minimumFontSizeLimitParsed.value}${minimumFontSizeLimitParsed.unit}`;
      } else {
        minimumFontSize = `${calculatedMinimumFontSize}${fontSizeParsed.unit}`;
      }
    }
  }

  // Grab the minimum font size and normalize it in order to use the value for calculations.
  const minimumFontSizeParsed = getTypographyValueAndUnit(minimumFontSize);

  // We get a 'preferred' unit to keep units consistent when calculating,
  // otherwise the result will not be accurate.
  const fontSizeUnit = minimumFontSizeParsed?.unit || 'rem';

  // Grabs the maximum font size and normalize it in order to use the value for calculations.
  const maximumFontSizeParsed = getTypographyValueAndUnit(maximumFontSize, {
    coerceTo: fontSizeUnit
  });

  // Checks for mandatory min and max sizes, and protects against unsupported units.
  if (!minimumFontSizeParsed || !maximumFontSizeParsed) {
    return null;
  }

  // Uses rem for accessible fluid target font scaling.
  const minimumFontSizeRem = getTypographyValueAndUnit(minimumFontSize, {
    coerceTo: 'rem'
  });

  // Viewport widths defined for fluid typography. Normalize units
  const maximumViewportWidthParsed = getTypographyValueAndUnit(maximumViewportWidth, {
    coerceTo: fontSizeUnit
  });
  const minimumViewportWidthParsed = getTypographyValueAndUnit(minimumViewportWidth, {
    coerceTo: fontSizeUnit
  });

  // Protect against unsupported units.
  if (!maximumViewportWidthParsed || !minimumViewportWidthParsed || !minimumFontSizeRem) {
    return null;
  }

  // Calculates the linear factor denominator. If it's 0, we cannot calculate a fluid value.
  const linearDenominator = maximumViewportWidthParsed.value - minimumViewportWidthParsed.value;
  if (!linearDenominator) {
    return null;
  }

  // Build CSS rule.
  // Borrowed from https://websemantics.uk/tools/responsive-font-calculator/.
  const minViewportWidthOffsetValue = roundToPrecision(minimumViewportWidthParsed.value / 100, 3);
  const viewportWidthOffset = roundToPrecision(minViewportWidthOffsetValue, 3) + fontSizeUnit;
  const linearFactor = 100 * ((maximumFontSizeParsed.value - minimumFontSizeParsed.value) / linearDenominator);
  const linearFactorScaled = roundToPrecision((linearFactor || 1) * scaleFactor, 3);
  const fluidTargetFontSize = `${minimumFontSizeRem.value}${minimumFontSizeRem.unit} + ((1vw - ${viewportWidthOffset}) * ${linearFactorScaled})`;
  return `clamp(${minimumFontSize}, ${fluidTargetFontSize}, ${maximumFontSize})`;
}

/**
 * Internal method that checks a string for a unit and value and returns an array consisting of `'value'` and `'unit'`, e.g., [ '42', 'rem' ].
 * A raw font size of `value + unit` is expected. If the value is an integer, it will convert to `value + 'px'`.
 *
 * @param {string|number}    rawValue Raw size value from theme.json.
 * @param {Object|undefined} options  Calculation options.
 *
 * @return {{ unit: string, value: number }|null} An object consisting of `'value'` and `'unit'` properties.
 */
function getTypographyValueAndUnit(rawValue, options = {}) {
  if (typeof rawValue !== 'string' && typeof rawValue !== 'number') {
    return null;
  }

  // Converts numeric values to pixel values by default.
  if (isFinite(rawValue)) {
    rawValue = `${rawValue}px`;
  }
  const {
    coerceTo,
    rootSizeValue,
    acceptableUnits
  } = {
    coerceTo: '',
    // Default browser font size. Later we could inject some JS to compute this `getComputedStyle( document.querySelector( "html" ) ).fontSize`.
    rootSizeValue: 16,
    acceptableUnits: ['rem', 'px', 'em'],
    ...options
  };
  const acceptableUnitsGroup = acceptableUnits?.join('|');
  const regexUnits = new RegExp(`^(\\d*\\.?\\d+)(${acceptableUnitsGroup}){1,1}$`);
  const matches = rawValue.match(regexUnits);

  // We need a number value and a unit.
  if (!matches || matches.length < 3) {
    return null;
  }
  let [, value, unit] = matches;
  let returnValue = parseFloat(value);
  if ('px' === coerceTo && ('em' === unit || 'rem' === unit)) {
    returnValue = returnValue * rootSizeValue;
    unit = coerceTo;
  }
  if ('px' === unit && ('em' === coerceTo || 'rem' === coerceTo)) {
    returnValue = returnValue / rootSizeValue;
    unit = coerceTo;
  }

  /*
   * No calculation is required if swapping between em and rem yet,
   * since we assume a root size value. Later we might like to differentiate between
   * :root font size (rem) and parent element font size (em) relativity.
   */
  if (('em' === coerceTo || 'rem' === coerceTo) && ('em' === unit || 'rem' === unit)) {
    unit = coerceTo;
  }
  return {
    value: roundToPrecision(returnValue, 3),
    unit
  };
}

/**
 * Returns a value rounded to defined precision.
 * Returns `undefined` if the value is not a valid finite number.
 *
 * @param {number} value  Raw value.
 * @param {number} digits The number of digits to appear after the decimal point
 *
 * @return {number|undefined} Value rounded to standard precision.
 */
function roundToPrecision(value, digits = 3) {
  const base = Math.pow(10, digits);
  return Number.isFinite(value) ? parseFloat(Math.round(value * base) / base) : undefined;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/global-styles/typography-utils.js
/**
 * The fluid utilities must match the backend equivalent.
 * See: gutenberg_get_typography_font_size_value() in lib/block-supports/typography.php
 * ---------------------------------------------------------------
 */

/**
 * Internal dependencies
 */


/**
 * @typedef {Object} FluidPreset
 * @property {string|undefined}  max A maximum font size value.
 * @property {?string|undefined} min A minimum font size value.
 */

/**
 * @typedef {Object} Preset
 * @property {?string|?number}               size  A default font size.
 * @property {string}                        name  A font size name, displayed in the UI.
 * @property {string}                        slug  A font size slug
 * @property {boolean|FluidPreset|undefined} fluid Specifies the minimum and maximum font size value of a fluid font size.
 */

/**
 * @typedef {Object} TypographySettings
 * @property {?string} minViewportWidth  Minimum viewport size from which type will have fluidity. Optional if size is specified.
 * @property {?string} maxViewportWidth  Maximum size up to which type will have fluidity. Optional if size is specified.
 * @property {?number} scaleFactor       A scale factor to determine how fast a font scales within boundaries. Optional.
 * @property {?number} minFontSizeFactor How much to scale defaultFontSize by to derive minimumFontSize. Optional.
 * @property {?string} minFontSize       The smallest a calculated font size may be. Optional.
 */

/**
 * Returns a font-size value based on a given font-size preset.
 * Takes into account fluid typography parameters and attempts to return a css formula depending on available, valid values.
 *
 * @param {Preset}                     preset
 * @param {Object}                     settings
 * @param {boolean|TypographySettings} settings.typography.fluid  Whether fluid typography is enabled, and, optionally, fluid font size options.
 * @param {Object?}                    settings.typography.layout Layout options.
 *
 * @return {string|*} A font-size value or the value of preset.size.
 */
function getTypographyFontSizeValue(preset, settings) {
  const {
    size: defaultSize
  } = preset;
  if (!isFluidTypographyEnabled(settings?.typography)) {
    return defaultSize;
  }
  /*
   * Checks whether a font size has explicitly bypassed fluid calculations.
   * Also catches falsy values and 0/'0'.
   * Fluid calculations cannot be performed on `0`.
   */
  if (!defaultSize || '0' === defaultSize || false === preset?.fluid) {
    return defaultSize;
  }
  let fluidTypographySettings = getFluidTypographyOptionsFromSettings(settings);
  fluidTypographySettings = typeof fluidTypographySettings?.fluid === 'object' ? fluidTypographySettings?.fluid : {};
  const fluidFontSizeValue = getComputedFluidTypographyValue({
    minimumFontSize: preset?.fluid?.min,
    maximumFontSize: preset?.fluid?.max,
    fontSize: defaultSize,
    minimumFontSizeLimit: fluidTypographySettings?.minFontSize,
    maximumViewportWidth: fluidTypographySettings?.maxViewportWidth,
    minimumViewportWidth: fluidTypographySettings?.minViewportWidth
  });
  if (!!fluidFontSizeValue) {
    return fluidFontSizeValue;
  }
  return defaultSize;
}
function isFluidTypographyEnabled(typographySettings) {
  const fluidSettings = typographySettings?.fluid;
  return true === fluidSettings || fluidSettings && typeof fluidSettings === 'object' && Object.keys(fluidSettings).length > 0;
}

/**
 * Returns fluid typography settings from theme.json setting object.
 *
 * @param {Object} settings            Theme.json settings
 * @param {Object} settings.typography Theme.json typography settings
 * @param {Object} settings.layout     Theme.json layout settings
 * @return {TypographySettings} Fluid typography settings
 */
function getFluidTypographyOptionsFromSettings(settings) {
  const typographySettings = settings?.typography;
  const layoutSettings = settings?.layout;
  const defaultMaxViewportWidth = getTypographyValueAndUnit(layoutSettings?.wideSize) ? layoutSettings?.wideSize : null;
  return isFluidTypographyEnabled(typographySettings) && defaultMaxViewportWidth ? {
    fluid: {
      maxViewportWidth: defaultMaxViewportWidth,
      ...typographySettings.fluid
    }
  } : {
    fluid: typographySettings?.fluid
  };
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/global-styles/utils.js
/**
 * External dependencies
 */


/**
 * Internal dependencies
 */



/* Supporting data. */
const ROOT_BLOCK_SELECTOR = 'body';
const ROOT_CSS_PROPERTIES_SELECTOR = ':root';
const PRESET_METADATA = [{
  path: ['color', 'palette'],
  valueKey: 'color',
  cssVarInfix: 'color',
  classes: [{
    classSuffix: 'color',
    propertyName: 'color'
  }, {
    classSuffix: 'background-color',
    propertyName: 'background-color'
  }, {
    classSuffix: 'border-color',
    propertyName: 'border-color'
  }]
}, {
  path: ['color', 'gradients'],
  valueKey: 'gradient',
  cssVarInfix: 'gradient',
  classes: [{
    classSuffix: 'gradient-background',
    propertyName: 'background'
  }]
}, {
  path: ['color', 'duotone'],
  valueKey: 'colors',
  cssVarInfix: 'duotone',
  valueFunc: ({
    slug
  }) => `url( '#wp-duotone-${slug}' )`,
  classes: []
}, {
  path: ['shadow', 'presets'],
  valueKey: 'shadow',
  cssVarInfix: 'shadow',
  classes: []
}, {
  path: ['typography', 'fontSizes'],
  valueFunc: (preset, settings) => getTypographyFontSizeValue(preset, settings),
  valueKey: 'size',
  cssVarInfix: 'font-size',
  classes: [{
    classSuffix: 'font-size',
    propertyName: 'font-size'
  }]
}, {
  path: ['typography', 'fontFamilies'],
  valueKey: 'fontFamily',
  cssVarInfix: 'font-family',
  classes: [{
    classSuffix: 'font-family',
    propertyName: 'font-family'
  }]
}, {
  path: ['spacing', 'spacingSizes'],
  valueKey: 'size',
  cssVarInfix: 'spacing',
  valueFunc: ({
    size
  }) => size,
  classes: []
}];
const STYLE_PATH_TO_CSS_VAR_INFIX = {
  'color.background': 'color',
  'color.text': 'color',
  'filter.duotone': 'duotone',
  'elements.link.color.text': 'color',
  'elements.link.:hover.color.text': 'color',
  'elements.link.typography.fontFamily': 'font-family',
  'elements.link.typography.fontSize': 'font-size',
  'elements.button.color.text': 'color',
  'elements.button.color.background': 'color',
  'elements.caption.color.text': 'color',
  'elements.button.typography.fontFamily': 'font-family',
  'elements.button.typography.fontSize': 'font-size',
  'elements.heading.color': 'color',
  'elements.heading.color.background': 'color',
  'elements.heading.typography.fontFamily': 'font-family',
  'elements.heading.gradient': 'gradient',
  'elements.heading.color.gradient': 'gradient',
  'elements.h1.color': 'color',
  'elements.h1.color.background': 'color',
  'elements.h1.typography.fontFamily': 'font-family',
  'elements.h1.color.gradient': 'gradient',
  'elements.h2.color': 'color',
  'elements.h2.color.background': 'color',
  'elements.h2.typography.fontFamily': 'font-family',
  'elements.h2.color.gradient': 'gradient',
  'elements.h3.color': 'color',
  'elements.h3.color.background': 'color',
  'elements.h3.typography.fontFamily': 'font-family',
  'elements.h3.color.gradient': 'gradient',
  'elements.h4.color': 'color',
  'elements.h4.color.background': 'color',
  'elements.h4.typography.fontFamily': 'font-family',
  'elements.h4.color.gradient': 'gradient',
  'elements.h5.color': 'color',
  'elements.h5.color.background': 'color',
  'elements.h5.typography.fontFamily': 'font-family',
  'elements.h5.color.gradient': 'gradient',
  'elements.h6.color': 'color',
  'elements.h6.color.background': 'color',
  'elements.h6.typography.fontFamily': 'font-family',
  'elements.h6.color.gradient': 'gradient',
  'color.gradient': 'gradient',
  shadow: 'shadow',
  'typography.fontSize': 'font-size',
  'typography.fontFamily': 'font-family'
};

// A static list of block attributes that store global style preset slugs.
const STYLE_PATH_TO_PRESET_BLOCK_ATTRIBUTE = {
  'color.background': 'backgroundColor',
  'color.text': 'textColor',
  'color.gradient': 'gradient',
  'typography.fontSize': 'fontSize',
  'typography.fontFamily': 'fontFamily'
};
const TOOLSPANEL_DROPDOWNMENU_PROPS = {
  popoverProps: {
    placement: 'left-start',
    offset: 259 // Inner sidebar width (248px) - button width (24px) - border (1px) + padding (16px) + spacing (20px)
  }
};
function findInPresetsBy(features, blockName, presetPath, presetProperty, presetValueValue) {
  // Block presets take priority above root level presets.
  const orderedPresetsByOrigin = [getValueFromObjectPath(features, ['blocks', blockName, ...presetPath]), getValueFromObjectPath(features, presetPath)];
  for (const presetByOrigin of orderedPresetsByOrigin) {
    if (presetByOrigin) {
      // Preset origins ordered by priority.
      const origins = ['custom', 'theme', 'default'];
      for (const origin of origins) {
        const presets = presetByOrigin[origin];
        if (presets) {
          const presetObject = presets.find(preset => preset[presetProperty] === presetValueValue);
          if (presetObject) {
            if (presetProperty === 'slug') {
              return presetObject;
            }
            // If there is a highest priority preset with the same slug but different value the preset we found was overwritten and should be ignored.
            const highestPresetObjectWithSameSlug = findInPresetsBy(features, blockName, presetPath, 'slug', presetObject.slug);
            if (highestPresetObjectWithSameSlug[presetProperty] === presetObject[presetProperty]) {
              return presetObject;
            }
            return undefined;
          }
        }
      }
    }
  }
}
function getPresetVariableFromValue(features, blockName, variableStylePath, presetPropertyValue) {
  if (!presetPropertyValue) {
    return presetPropertyValue;
  }
  const cssVarInfix = STYLE_PATH_TO_CSS_VAR_INFIX[variableStylePath];
  const metadata = PRESET_METADATA.find(data => data.cssVarInfix === cssVarInfix);
  if (!metadata) {
    // The property doesn't have preset data
    // so the value should be returned as it is.
    return presetPropertyValue;
  }
  const {
    valueKey,
    path
  } = metadata;
  const presetObject = findInPresetsBy(features, blockName, path, valueKey, presetPropertyValue);
  if (!presetObject) {
    // Value wasn't found in the presets,
    // so it must be a custom value.
    return presetPropertyValue;
  }
  return `var:preset|${cssVarInfix}|${presetObject.slug}`;
}
function getValueFromPresetVariable(features, blockName, variable, [presetType, slug]) {
  const metadata = PRESET_METADATA.find(data => data.cssVarInfix === presetType);
  if (!metadata) {
    return variable;
  }
  const presetObject = findInPresetsBy(features.settings, blockName, metadata.path, 'slug', slug);
  if (presetObject) {
    const {
      valueKey
    } = metadata;
    const result = presetObject[valueKey];
    return getValueFromVariable(features, blockName, result);
  }
  return variable;
}
function getValueFromCustomVariable(features, blockName, variable, path) {
  var _getValueFromObjectPa;
  const result = (_getValueFromObjectPa = getValueFromObjectPath(features.settings, ['blocks', blockName, 'custom', ...path])) !== null && _getValueFromObjectPa !== void 0 ? _getValueFromObjectPa : getValueFromObjectPath(features.settings, ['custom', ...path]);
  if (!result) {
    return variable;
  }
  // A variable may reference another variable so we need recursion until we find the value.
  return getValueFromVariable(features, blockName, result);
}

/**
 * Attempts to fetch the value of a theme.json CSS variable.
 *
 * @param {Object}   features  GlobalStylesContext config, e.g., user, base or merged. Represents the theme.json tree.
 * @param {string}   blockName The name of a block as represented in the styles property. E.g., 'root' for root-level, and 'core/${blockName}' for blocks.
 * @param {string|*} variable  An incoming style value. A CSS var value is expected, but it could be any value.
 * @return {string|*|{ref}} The value of the CSS var, if found. If not found, the passed variable argument.
 */
function getValueFromVariable(features, blockName, variable) {
  if (!variable || typeof variable !== 'string') {
    if (variable?.ref && typeof variable?.ref === 'string') {
      const refPath = variable.ref.split('.');
      variable = getValueFromObjectPath(features, refPath);
      // Presence of another ref indicates a reference to another dynamic value.
      // Pointing to another dynamic value is not supported.
      if (!variable || !!variable?.ref) {
        return variable;
      }
    } else {
      return variable;
    }
  }
  const USER_VALUE_PREFIX = 'var:';
  const THEME_VALUE_PREFIX = 'var(--wp--';
  const THEME_VALUE_SUFFIX = ')';
  let parsedVar;
  if (variable.startsWith(USER_VALUE_PREFIX)) {
    parsedVar = variable.slice(USER_VALUE_PREFIX.length).split('|');
  } else if (variable.startsWith(THEME_VALUE_PREFIX) && variable.endsWith(THEME_VALUE_SUFFIX)) {
    parsedVar = variable.slice(THEME_VALUE_PREFIX.length, -THEME_VALUE_SUFFIX.length).split('--');
  } else {
    // We don't know how to parse the value: either is raw of uses complex CSS such as `calc(1px * var(--wp--variable) )`
    return variable;
  }
  const [type, ...path] = parsedVar;
  if (type === 'preset') {
    return getValueFromPresetVariable(features, blockName, variable, path);
  }
  if (type === 'custom') {
    return getValueFromCustomVariable(features, blockName, variable, path);
  }
  return variable;
}

/**
 * Function that scopes a selector with another one. This works a bit like
 * SCSS nesting except the `&` operator isn't supported.
 *
 * @example
 * ```js
 * const scope = '.a, .b .c';
 * const selector = '> .x, .y';
 * const merged = scopeSelector( scope, selector );
 * // merged is '.a > .x, .a .y, .b .c > .x, .b .c .y'
 * ```
 *
 * @param {string} scope    Selector to scope to.
 * @param {string} selector Original selector.
 *
 * @return {string} Scoped selector.
 */
function scopeSelector(scope, selector) {
  if (!scope || !selector) {
    return selector;
  }
  const scopes = scope.split(',');
  const selectors = selector.split(',');
  const selectorsScoped = [];
  scopes.forEach(outer => {
    selectors.forEach(inner => {
      selectorsScoped.push(`${outer.trim()} ${inner.trim()}`);
    });
  });
  return selectorsScoped.join(', ');
}

/**
 * Scopes a collection of selectors for features and subfeatures.
 *
 * @example
 * ```js
 * const scope = '.custom-scope';
 * const selectors = {
 *     color: '.wp-my-block p',
 *     typography: { fontSize: '.wp-my-block caption' },
 * };
 * const result = scopeFeatureSelector( scope, selectors );
 * // result is {
 * //     color: '.custom-scope .wp-my-block p',
 * //     typography: { fonSize: '.custom-scope .wp-my-block caption' },
 * // }
 * ```
 *
 * @param {string} scope     Selector to scope collection of selectors with.
 * @param {Object} selectors Collection of feature selectors e.g.
 *
 * @return {Object|undefined} Scoped collection of feature selectors.
 */
function scopeFeatureSelectors(scope, selectors) {
  if (!scope || !selectors) {
    return;
  }
  const featureSelectors = {};
  Object.entries(selectors).forEach(([feature, selector]) => {
    if (typeof selector === 'string') {
      featureSelectors[feature] = scopeSelector(scope, selector);
    }
    if (typeof selector === 'object') {
      featureSelectors[feature] = {};
      Object.entries(selector).forEach(([subfeature, subfeatureSelector]) => {
        featureSelectors[feature][subfeature] = scopeSelector(scope, subfeatureSelector);
      });
    }
  });
  return featureSelectors;
}

/**
 * Appends a sub-selector to an existing one.
 *
 * Given the compounded `selector` "h1, h2, h3"
 * and the `toAppend` selector ".some-class" the result will be
 * "h1.some-class, h2.some-class, h3.some-class".
 *
 * @param {string} selector Original selector.
 * @param {string} toAppend Selector to append.
 *
 * @return {string} The new selector.
 */
function appendToSelector(selector, toAppend) {
  if (!selector.includes(',')) {
    return selector + toAppend;
  }
  const selectors = selector.split(',');
  const newSelectors = selectors.map(sel => sel + toAppend);
  return newSelectors.join(',');
}

/**
 * Compares global style variations according to their styles and settings properties.
 *
 * @example
 * ```js
 * const globalStyles = { styles: { typography: { fontSize: '10px' } }, settings: {} };
 * const variation = { styles: { typography: { fontSize: '10000px' } }, settings: {} };
 * const isEqual = areGlobalStyleConfigsEqual( globalStyles, variation );
 * // false
 * ```
 *
 * @param {Object} original  A global styles object.
 * @param {Object} variation A global styles object.
 *
 * @return {boolean} Whether `original` and `variation` match.
 */
function areGlobalStyleConfigsEqual(original, variation) {
  if (typeof original !== 'object' || typeof variation !== 'object') {
    return original === variation;
  }
  return es6_default()(original?.styles, variation?.styles) && es6_default()(original?.settings, variation?.settings);
}

/**
 * Generates the selector for a block style variation by creating the
 * appropriate CSS class and adding it to the ancestor portion of the block's
 * selector.
 *
 * For example, take the Button block which has a compound selector:
 * `.wp-block-button .wp-block-button__link`. With a variation named 'custom',
 * the class `.is-style-custom` should be added to the `.wp-block-button`
 * ancestor only.
 *
 * This function will take into account comma separated and complex selectors.
 *
 * @param {string} variation     Name for the variation.
 * @param {string} blockSelector CSS selector for the block.
 *
 * @return {string} CSS selector for the block style variation.
 */
function getBlockStyleVariationSelector(variation, blockSelector) {
  const variationClass = `.is-style-${variation}`;
  if (!blockSelector) {
    return variationClass;
  }
  const ancestorRegex = /((?::\([^)]+\))?\s*)([^\s:]+)/;
  const addVariationClass = (_match, group1, group2) => {
    return group1 + group2 + variationClass;
  };
  const result = blockSelector.split(',').map(part => part.replace(ancestorRegex, addVariationClass));
  return result.join(',');
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/global-styles/context.js
/**
 * WordPress dependencies
 */

const DEFAULT_GLOBAL_STYLES_CONTEXT = {
  user: {},
  base: {},
  merged: {},
  setUserConfig: () => {}
};
const GlobalStylesContext = (0,external_wp_element_namespaceObject.createContext)(DEFAULT_GLOBAL_STYLES_CONTEXT);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/global-styles/hooks.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */




const EMPTY_CONFIG = {
  settings: {},
  styles: {}
};
const VALID_SETTINGS = ['appearanceTools', 'useRootPaddingAwareAlignments', 'background.backgroundImage', 'background.backgroundRepeat', 'background.backgroundSize', 'background.backgroundPosition', 'border.color', 'border.radius', 'border.style', 'border.width', 'shadow.presets', 'shadow.defaultPresets', 'color.background', 'color.button', 'color.caption', 'color.custom', 'color.customDuotone', 'color.customGradient', 'color.defaultDuotone', 'color.defaultGradients', 'color.defaultPalette', 'color.duotone', 'color.gradients', 'color.heading', 'color.link', 'color.palette', 'color.text', 'custom', 'dimensions.aspectRatio', 'dimensions.minHeight', 'layout.contentSize', 'layout.definitions', 'layout.wideSize', 'lightbox.enabled', 'lightbox.allowEditing', 'position.fixed', 'position.sticky', 'spacing.customSpacingSize', 'spacing.defaultSpacingSizes', 'spacing.spacingSizes', 'spacing.spacingScale', 'spacing.blockGap', 'spacing.margin', 'spacing.padding', 'spacing.units', 'typography.fluid', 'typography.customFontSize', 'typography.defaultFontSizes', 'typography.dropCap', 'typography.fontFamilies', 'typography.fontSizes', 'typography.fontStyle', 'typography.fontWeight', 'typography.letterSpacing', 'typography.lineHeight', 'typography.textAlign', 'typography.textColumns', 'typography.textDecoration', 'typography.textTransform', 'typography.writingMode'];
const useGlobalStylesReset = () => {
  const {
    user: config,
    setUserConfig
  } = (0,external_wp_element_namespaceObject.useContext)(GlobalStylesContext);
  const canReset = !!config && !es6_default()(config, EMPTY_CONFIG);
  return [canReset, (0,external_wp_element_namespaceObject.useCallback)(() => setUserConfig(() => EMPTY_CONFIG), [setUserConfig])];
};
function useGlobalSetting(propertyPath, blockName, source = 'all') {
  const {
    setUserConfig,
    ...configs
  } = (0,external_wp_element_namespaceObject.useContext)(GlobalStylesContext);
  const appendedBlockPath = blockName ? '.blocks.' + blockName : '';
  const appendedPropertyPath = propertyPath ? '.' + propertyPath : '';
  const contextualPath = `settings${appendedBlockPath}${appendedPropertyPath}`;
  const globalPath = `settings${appendedPropertyPath}`;
  const sourceKey = source === 'all' ? 'merged' : source;
  const settingValue = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const configToUse = configs[sourceKey];
    if (!configToUse) {
      throw 'Unsupported source';
    }
    if (propertyPath) {
      var _getValueFromObjectPa;
      return (_getValueFromObjectPa = getValueFromObjectPath(configToUse, contextualPath)) !== null && _getValueFromObjectPa !== void 0 ? _getValueFromObjectPa : getValueFromObjectPath(configToUse, globalPath);
    }
    let result = {};
    VALID_SETTINGS.forEach(setting => {
      var _getValueFromObjectPa2;
      const value = (_getValueFromObjectPa2 = getValueFromObjectPath(configToUse, `settings${appendedBlockPath}.${setting}`)) !== null && _getValueFromObjectPa2 !== void 0 ? _getValueFromObjectPa2 : getValueFromObjectPath(configToUse, `settings.${setting}`);
      if (value !== undefined) {
        result = setImmutably(result, setting.split('.'), value);
      }
    });
    return result;
  }, [configs, sourceKey, propertyPath, contextualPath, globalPath, appendedBlockPath]);
  const setSetting = newValue => {
    setUserConfig(currentConfig => setImmutably(currentConfig, contextualPath.split('.'), newValue));
  };
  return [settingValue, setSetting];
}
function useGlobalStyle(path, blockName, source = 'all', {
  shouldDecodeEncode = true
} = {}) {
  const {
    merged: mergedConfig,
    base: baseConfig,
    user: userConfig,
    setUserConfig
  } = (0,external_wp_element_namespaceObject.useContext)(GlobalStylesContext);
  const appendedPath = path ? '.' + path : '';
  const finalPath = !blockName ? `styles${appendedPath}` : `styles.blocks.${blockName}${appendedPath}`;
  const setStyle = newValue => {
    setUserConfig(currentConfig => setImmutably(currentConfig, finalPath.split('.'), shouldDecodeEncode ? getPresetVariableFromValue(mergedConfig.settings, blockName, path, newValue) : newValue));
  };
  let rawResult, result;
  switch (source) {
    case 'all':
      rawResult = getValueFromObjectPath(mergedConfig, finalPath);
      result = shouldDecodeEncode ? getValueFromVariable(mergedConfig, blockName, rawResult) : rawResult;
      break;
    case 'user':
      rawResult = getValueFromObjectPath(userConfig, finalPath);
      result = shouldDecodeEncode ? getValueFromVariable(mergedConfig, blockName, rawResult) : rawResult;
      break;
    case 'base':
      rawResult = getValueFromObjectPath(baseConfig, finalPath);
      result = shouldDecodeEncode ? getValueFromVariable(baseConfig, blockName, rawResult) : rawResult;
      break;
    default:
      throw 'Unsupported source';
  }
  return [result, setStyle];
}
function useGlobalStyleLinks() {
  const {
    merged: mergedConfig
  } = (0,external_wp_element_namespaceObject.useContext)(GlobalStylesContext);
  return mergedConfig?._links;
}

/**
 * React hook that overrides a global settings object with block and element specific settings.
 *
 * @param {Object}     parentSettings Settings object.
 * @param {blockName?} blockName      Block name.
 * @param {element?}   element        Element name.
 *
 * @return {Object} Merge of settings and supports.
 */
function useSettingsForBlockElement(parentSettings, blockName, element) {
  const {
    supportedStyles,
    supports
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    return {
      supportedStyles: unlock(select(external_wp_blocks_namespaceObject.store)).getSupportedStyles(blockName, element),
      supports: select(external_wp_blocks_namespaceObject.store).getBlockType(blockName)?.supports
    };
  }, [blockName, element]);
  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    const updatedSettings = {
      ...parentSettings
    };
    if (!supportedStyles.includes('fontSize')) {
      updatedSettings.typography = {
        ...updatedSettings.typography,
        fontSizes: {},
        customFontSize: false,
        defaultFontSizes: false
      };
    }
    if (!supportedStyles.includes('fontFamily')) {
      updatedSettings.typography = {
        ...updatedSettings.typography,
        fontFamilies: {}
      };
    }
    updatedSettings.color = {
      ...updatedSettings.color,
      text: updatedSettings.color?.text && supportedStyles.includes('color'),
      background: updatedSettings.color?.background && (supportedStyles.includes('background') || supportedStyles.includes('backgroundColor')),
      button: updatedSettings.color?.button && supportedStyles.includes('buttonColor'),
      heading: updatedSettings.color?.heading && supportedStyles.includes('headingColor'),
      link: updatedSettings.color?.link && supportedStyles.includes('linkColor'),
      caption: updatedSettings.color?.caption && supportedStyles.includes('captionColor')
    };

    // Some blocks can enable background colors but disable gradients.
    if (!supportedStyles.includes('background')) {
      updatedSettings.color.gradients = [];
      updatedSettings.color.customGradient = false;
    }

    // If filters are not supported by the block/element, disable duotone.
    if (!supportedStyles.includes('filter')) {
      updatedSettings.color.defaultDuotone = false;
      updatedSettings.color.customDuotone = false;
    }
    ['lineHeight', 'fontStyle', 'fontWeight', 'letterSpacing', 'textTransform', 'textDecoration', 'writingMode'].forEach(key => {
      if (!supportedStyles.includes(key)) {
        updatedSettings.typography = {
          ...updatedSettings.typography,
          [key]: false
        };
      }
    });

    // The column-count style is named text column to reduce confusion with
    // the columns block and manage expectations from the support.
    // See: https://github.com/WordPress/gutenberg/pull/33587
    if (!supportedStyles.includes('columnCount')) {
      updatedSettings.typography = {
        ...updatedSettings.typography,
        textColumns: false
      };
    }
    ['contentSize', 'wideSize'].forEach(key => {
      if (!supportedStyles.includes(key)) {
        updatedSettings.layout = {
          ...updatedSettings.layout,
          [key]: false
        };
      }
    });
    ['padding', 'margin', 'blockGap'].forEach(key => {
      if (!supportedStyles.includes(key)) {
        updatedSettings.spacing = {
          ...updatedSettings.spacing,
          [key]: false
        };
      }
      const sides = Array.isArray(supports?.spacing?.[key]) ? supports?.spacing?.[key] : supports?.spacing?.[key]?.sides;
      // Check if spacing type is supported before adding sides.
      if (sides?.length && updatedSettings.spacing?.[key]) {
        updatedSettings.spacing = {
          ...updatedSettings.spacing,
          [key]: {
            ...updatedSettings.spacing?.[key],
            sides
          }
        };
      }
    });
    ['aspectRatio', 'minHeight'].forEach(key => {
      if (!supportedStyles.includes(key)) {
        updatedSettings.dimensions = {
          ...updatedSettings.dimensions,
          [key]: false
        };
      }
    });
    ['radius', 'color', 'style', 'width'].forEach(key => {
      if (!supportedStyles.includes('border' + key.charAt(0).toUpperCase() + key.slice(1))) {
        updatedSettings.border = {
          ...updatedSettings.border,
          [key]: false
        };
      }
    });
    updatedSettings.shadow = supportedStyles.includes('shadow') ? updatedSettings.shadow : false;

    // Text alignment is only available for blocks.
    if (element) {
      updatedSettings.typography.textAlign = false;
    }
    return updatedSettings;
  }, [parentSettings, supportedStyles, supports, element]);
}
function useColorsPerOrigin(settings) {
  const customColors = settings?.color?.palette?.custom;
  const themeColors = settings?.color?.palette?.theme;
  const defaultColors = settings?.color?.palette?.default;
  const shouldDisplayDefaultColors = settings?.color?.defaultPalette;
  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    const result = [];
    if (themeColors && themeColors.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Theme', 'Indicates this palette comes from the theme.'),
        colors: themeColors
      });
    }
    if (shouldDisplayDefaultColors && defaultColors && defaultColors.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Default', 'Indicates this palette comes from WordPress.'),
        colors: defaultColors
      });
    }
    if (customColors && customColors.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Custom', 'Indicates this palette is created by the user.'),
        colors: customColors
      });
    }
    return result;
  }, [customColors, themeColors, defaultColors, shouldDisplayDefaultColors]);
}
function useGradientsPerOrigin(settings) {
  const customGradients = settings?.color?.gradients?.custom;
  const themeGradients = settings?.color?.gradients?.theme;
  const defaultGradients = settings?.color?.gradients?.default;
  const shouldDisplayDefaultGradients = settings?.color?.defaultGradients;
  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    const result = [];
    if (themeGradients && themeGradients.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Theme', 'Indicates this palette comes from the theme.'),
        gradients: themeGradients
      });
    }
    if (shouldDisplayDefaultGradients && defaultGradients && defaultGradients.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Default', 'Indicates this palette comes from WordPress.'),
        gradients: defaultGradients
      });
    }
    if (customGradients && customGradients.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Custom', 'Indicates this palette is created by the user.'),
        gradients: customGradients
      });
    }
    return result;
  }, [customGradients, themeGradients, defaultGradients, shouldDisplayDefaultGradients]);
}

;// CONCATENATED MODULE: ./node_modules/clsx/dist/clsx.mjs
function r(e){var t,f,n="";if("string"==typeof e||"number"==typeof e)n+=e;else if("object"==typeof e)if(Array.isArray(e)){var o=e.length;for(t=0;t<o;t++)e[t]&&(f=r(e[t]))&&(n&&(n+=" "),n+=f)}else for(f in e)e[f]&&(n&&(n+=" "),n+=f);return n}function clsx(){for(var e,t,f=0,n="",o=arguments.length;f<o;f++)(e=arguments[f])&&(t=r(e))&&(n&&(n+=" "),n+=t);return n}/* harmony default export */ const dist_clsx = (clsx);
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/utils.js
/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */






/**
 * External dependencies
 */


/**
 * Removed falsy values from nested object.
 *
 * @param {*} object
 * @return {*} Object cleaned from falsy values
 */

const utils_cleanEmptyObject = object => {
  if (object === null || typeof object !== 'object' || Array.isArray(object)) {
    return object;
  }
  const cleanedNestedObjects = Object.entries(object).map(([key, value]) => [key, utils_cleanEmptyObject(value)]).filter(([, value]) => value !== undefined);
  return !cleanedNestedObjects.length ? undefined : Object.fromEntries(cleanedNestedObjects);
};
function transformStyles(activeSupports, migrationPaths, result, source, index, results) {
  // If there are no active supports return early.
  if (Object.values(activeSupports !== null && activeSupports !== void 0 ? activeSupports : {}).every(isActive => !isActive)) {
    return result;
  }
  // If the condition verifies we are probably in the presence of a wrapping transform
  // e.g: nesting paragraphs in a group or columns and in that case the styles should not be transformed.
  if (results.length === 1 && result.innerBlocks.length === source.length) {
    return result;
  }
  // For cases where we have a transform from one block to multiple blocks
  // or multiple blocks to one block we apply the styles of the first source block
  // to the result(s).
  let referenceBlockAttributes = source[0]?.attributes;
  // If we are in presence of transform between more than one block in the source
  // that has more than one block in the result
  // we apply the styles on source N to the result N,
  // if source N does not exists we do nothing.
  if (results.length > 1 && source.length > 1) {
    if (source[index]) {
      referenceBlockAttributes = source[index]?.attributes;
    } else {
      return result;
    }
  }
  let returnBlock = result;
  Object.entries(activeSupports).forEach(([support, isActive]) => {
    if (isActive) {
      migrationPaths[support].forEach(path => {
        const styleValue = getValueFromObjectPath(referenceBlockAttributes, path);
        if (styleValue) {
          returnBlock = {
            ...returnBlock,
            attributes: setImmutably(returnBlock.attributes, path, styleValue)
          };
        }
      });
    }
  });
  return returnBlock;
}

/**
 * Check whether serialization of specific block support feature or set should
 * be skipped.
 *
 * @param {string|Object} blockNameOrType Block name or block type object.
 * @param {string}        featureSet      Name of block support feature set.
 * @param {string}        feature         Name of the individual feature to check.
 *
 * @return {boolean} Whether serialization should occur.
 */
function shouldSkipSerialization(blockNameOrType, featureSet, feature) {
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockNameOrType, featureSet);
  const skipSerialization = support?.__experimentalSkipSerialization;
  if (Array.isArray(skipSerialization)) {
    return skipSerialization.includes(feature);
  }
  return skipSerialization;
}
const pendingStyleOverrides = new WeakMap();
function useStyleOverride({
  id,
  css,
  assets,
  __unstableType,
  clientId
} = {}) {
  const {
    setStyleOverride,
    deleteStyleOverride
  } = unlock((0,external_wp_data_namespaceObject.useDispatch)(store));
  const registry = (0,external_wp_data_namespaceObject.useRegistry)();
  const fallbackId = (0,external_wp_element_namespaceObject.useId)();
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // Unmount if there is CSS and assets are empty.
    if (!css && !assets) {
      return;
    }
    const _id = id || fallbackId;
    const override = {
      id,
      css,
      assets,
      __unstableType,
      clientId
    };
    // Batch updates to style overrides to avoid triggering cascading renders
    // for each style override block included in a tree and optimize initial render.
    if (!pendingStyleOverrides.get(registry)) {
      pendingStyleOverrides.set(registry, []);
    }
    pendingStyleOverrides.get(registry).push([_id, override]);
    window.queueMicrotask(() => {
      if (pendingStyleOverrides.get(registry)?.length) {
        registry.batch(() => {
          pendingStyleOverrides.get(registry).forEach(args => {
            setStyleOverride(...args);
          });
          pendingStyleOverrides.set(registry, []);
        });
      }
    });
    return () => {
      const isPending = pendingStyleOverrides.get(registry)?.find(([currentId]) => currentId === _id);
      if (isPending) {
        pendingStyleOverrides.set(registry, pendingStyleOverrides.get(registry).filter(([currentId]) => currentId !== _id));
      } else {
        deleteStyleOverride(_id);
      }
    };
  }, [id, css, clientId, assets, __unstableType, fallbackId, setStyleOverride, deleteStyleOverride, registry]);
}

/**
 * Based on the block and its context, returns an object of all the block settings.
 * This object can be passed as a prop to all the Styles UI components
 * (TypographyPanel, DimensionsPanel...).
 *
 * @param {string} name         Block name.
 * @param {*}      parentLayout Parent layout.
 *
 * @return {Object} Settings object.
 */
function useBlockSettings(name, parentLayout) {
  const [backgroundImage, backgroundSize, customFontFamilies, defaultFontFamilies, themeFontFamilies, defaultFontSizesEnabled, customFontSizes, defaultFontSizes, themeFontSizes, customFontSize, fontStyle, fontWeight, lineHeight, textAlign, textColumns, textDecoration, writingMode, textTransform, letterSpacing, padding, margin, blockGap, defaultSpacingSizesEnabled, customSpacingSize, userSpacingSizes, defaultSpacingSizes, themeSpacingSizes, units, aspectRatio, minHeight, layout, borderColor, borderRadius, borderStyle, borderWidth, customColorsEnabled, customColors, customDuotone, themeColors, defaultColors, defaultPalette, defaultDuotone, userDuotonePalette, themeDuotonePalette, defaultDuotonePalette, userGradientPalette, themeGradientPalette, defaultGradientPalette, defaultGradients, areCustomGradientsEnabled, isBackgroundEnabled, isLinkEnabled, isTextEnabled, isHeadingEnabled, isButtonEnabled, shadow] = use_settings_useSettings('background.backgroundImage', 'background.backgroundSize', 'typography.fontFamilies.custom', 'typography.fontFamilies.default', 'typography.fontFamilies.theme', 'typography.defaultFontSizes', 'typography.fontSizes.custom', 'typography.fontSizes.default', 'typography.fontSizes.theme', 'typography.customFontSize', 'typography.fontStyle', 'typography.fontWeight', 'typography.lineHeight', 'typography.textAlign', 'typography.textColumns', 'typography.textDecoration', 'typography.writingMode', 'typography.textTransform', 'typography.letterSpacing', 'spacing.padding', 'spacing.margin', 'spacing.blockGap', 'spacing.defaultSpacingSizes', 'spacing.customSpacingSize', 'spacing.spacingSizes.custom', 'spacing.spacingSizes.default', 'spacing.spacingSizes.theme', 'spacing.units', 'dimensions.aspectRatio', 'dimensions.minHeight', 'layout', 'border.color', 'border.radius', 'border.style', 'border.width', 'color.custom', 'color.palette.custom', 'color.customDuotone', 'color.palette.theme', 'color.palette.default', 'color.defaultPalette', 'color.defaultDuotone', 'color.duotone.custom', 'color.duotone.theme', 'color.duotone.default', 'color.gradients.custom', 'color.gradients.theme', 'color.gradients.default', 'color.defaultGradients', 'color.customGradient', 'color.background', 'color.link', 'color.text', 'color.heading', 'color.button', 'shadow');
  const rawSettings = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return {
      background: {
        backgroundImage,
        backgroundSize
      },
      color: {
        palette: {
          custom: customColors,
          theme: themeColors,
          default: defaultColors
        },
        gradients: {
          custom: userGradientPalette,
          theme: themeGradientPalette,
          default: defaultGradientPalette
        },
        duotone: {
          custom: userDuotonePalette,
          theme: themeDuotonePalette,
          default: defaultDuotonePalette
        },
        defaultGradients,
        defaultPalette,
        defaultDuotone,
        custom: customColorsEnabled,
        customGradient: areCustomGradientsEnabled,
        customDuotone,
        background: isBackgroundEnabled,
        link: isLinkEnabled,
        heading: isHeadingEnabled,
        button: isButtonEnabled,
        text: isTextEnabled
      },
      typography: {
        fontFamilies: {
          custom: customFontFamilies,
          default: defaultFontFamilies,
          theme: themeFontFamilies
        },
        fontSizes: {
          custom: customFontSizes,
          default: defaultFontSizes,
          theme: themeFontSizes
        },
        customFontSize,
        defaultFontSizes: defaultFontSizesEnabled,
        fontStyle,
        fontWeight,
        lineHeight,
        textAlign,
        textColumns,
        textDecoration,
        textTransform,
        letterSpacing,
        writingMode
      },
      spacing: {
        spacingSizes: {
          custom: userSpacingSizes,
          default: defaultSpacingSizes,
          theme: themeSpacingSizes
        },
        customSpacingSize,
        defaultSpacingSizes: defaultSpacingSizesEnabled,
        padding,
        margin,
        blockGap,
        units
      },
      border: {
        color: borderColor,
        radius: borderRadius,
        style: borderStyle,
        width: borderWidth
      },
      dimensions: {
        aspectRatio,
        minHeight
      },
      layout,
      parentLayout,
      shadow
    };
  }, [backgroundImage, backgroundSize, customFontFamilies, defaultFontFamilies, themeFontFamilies, defaultFontSizesEnabled, customFontSizes, defaultFontSizes, themeFontSizes, customFontSize, fontStyle, fontWeight, lineHeight, textAlign, textColumns, textDecoration, textTransform, letterSpacing, writingMode, padding, margin, blockGap, defaultSpacingSizesEnabled, customSpacingSize, userSpacingSizes, defaultSpacingSizes, themeSpacingSizes, units, aspectRatio, minHeight, layout, parentLayout, borderColor, borderRadius, borderStyle, borderWidth, customColorsEnabled, customColors, customDuotone, themeColors, defaultColors, defaultPalette, defaultDuotone, userDuotonePalette, themeDuotonePalette, defaultDuotonePalette, userGradientPalette, themeGradientPalette, defaultGradientPalette, defaultGradients, areCustomGradientsEnabled, isBackgroundEnabled, isLinkEnabled, isTextEnabled, isHeadingEnabled, isButtonEnabled, shadow]);
  return useSettingsForBlockElement(rawSettings, name);
}
function createBlockEditFilter(features) {
  // We don't want block controls to re-render when typing inside a block.
  // `memo` will prevent re-renders unless props change, so only pass the
  // needed props and not the whole attributes object.
  features = features.map(settings => {
    return {
      ...settings,
      Edit: (0,external_wp_element_namespaceObject.memo)(settings.edit)
    };
  });
  const withBlockEditHooks = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(OriginalBlockEdit => props => {
    const context = useBlockEditContext();
    // CAUTION: code added before this line will be executed for all
    // blocks, not just those that support the feature! Code added
    // above this line should be carefully evaluated for its impact on
    // performance.
    return [...features.map((feature, i) => {
      const {
        Edit,
        hasSupport,
        attributeKeys = [],
        shareWithChildBlocks
      } = feature;
      const shouldDisplayControls = context[mayDisplayControlsKey] || context[mayDisplayParentControlsKey] && shareWithChildBlocks;
      if (!shouldDisplayControls || !hasSupport(props.name)) {
        return null;
      }
      const neededProps = {};
      for (const key of attributeKeys) {
        if (props.attributes[key]) {
          neededProps[key] = props.attributes[key];
        }
      }
      return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Edit
      // We can use the index because the array length
      // is fixed per page load right now.
      , {
        name: props.name,
        isSelected: props.isSelected,
        clientId: props.clientId,
        setAttributes: props.setAttributes,
        __unstableParentLayout: props.__unstableParentLayout
        // This component is pure, so only pass needed
        // props!!!
        ,
        ...neededProps
      }, i);
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(OriginalBlockEdit, {
      ...props
    }, "edit")];
  }, 'withBlockEditHooks');
  (0,external_wp_hooks_namespaceObject.addFilter)('editor.BlockEdit', 'core/editor/hooks', withBlockEditHooks);
}
function BlockProps({
  index,
  useBlockProps,
  setAllWrapperProps,
  ...props
}) {
  const wrapperProps = useBlockProps(props);
  const setWrapperProps = next => setAllWrapperProps(prev => {
    const nextAll = [...prev];
    nextAll[index] = next;
    return nextAll;
  });
  // Setting state after every render is fine because this component is
  // pure and will only re-render when needed props change.
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // We could shallow compare the props, but since this component only
    // changes when needed attributes change, the benefit is probably small.
    setWrapperProps(wrapperProps);
    return () => {
      setWrapperProps(undefined);
    };
  });
  return null;
}
const BlockPropsPure = (0,external_wp_element_namespaceObject.memo)(BlockProps);
function createBlockListBlockFilter(features) {
  const withBlockListBlockHooks = (0,external_wp_compose_namespaceObject.createHigherOrderComponent)(BlockListBlock => props => {
    const [allWrapperProps, setAllWrapperProps] = (0,external_wp_element_namespaceObject.useState)(Array(features.length).fill(undefined));
    return [...features.map((feature, i) => {
      const {
        hasSupport,
        attributeKeys = [],
        useBlockProps
      } = feature;
      const neededProps = {};
      for (const key of attributeKeys) {
        if (props.attributes[key]) {
          neededProps[key] = props.attributes[key];
        }
      }
      if (
      // Skip rendering if none of the needed attributes are
      // set.
      !Object.keys(neededProps).length || !hasSupport(props.name)) {
        return null;
      }
      return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockPropsPure
      // We can use the index because the array length
      // is fixed per page load right now.
      , {
        index: i,
        useBlockProps: useBlockProps
        // This component is pure, so we must pass a stable
        // function reference.
        ,
        setAllWrapperProps: setAllWrapperProps,
        name: props.name,
        clientId: props.clientId
        // This component is pure, so only pass needed
        // props!!!
        ,
        ...neededProps
      }, i);
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockListBlock, {
      ...props,
      wrapperProps: allWrapperProps.filter(Boolean).reduce((acc, wrapperProps) => {
        return {
          ...acc,
          ...wrapperProps,
          className: dist_clsx(acc.className, wrapperProps.className),
          style: {
            ...acc.style,
            ...wrapperProps.style
          }
        };
      }, props.wrapperProps || {})
    }, "edit")];
  }, 'withBlockListBlockHooks');
  (0,external_wp_hooks_namespaceObject.addFilter)('editor.BlockListBlock', 'core/editor/hooks', withBlockListBlockHooks);
}
function createBlockSaveFilter(features) {
  function extraPropsFromHooks(props, name, attributes) {
    return features.reduce((accu, feature) => {
      const {
        hasSupport,
        attributeKeys = [],
        addSaveProps
      } = feature;
      const neededAttributes = {};
      for (const key of attributeKeys) {
        if (attributes[key]) {
          neededAttributes[key] = attributes[key];
        }
      }
      if (
      // Skip rendering if none of the needed attributes are
      // set.
      !Object.keys(neededAttributes).length || !hasSupport(name)) {
        return accu;
      }
      return addSaveProps(accu, name, neededAttributes);
    }, props);
  }
  (0,external_wp_hooks_namespaceObject.addFilter)('blocks.getSaveContent.extraProps', 'core/editor/hooks', extraPropsFromHooks, 0);
  (0,external_wp_hooks_namespaceObject.addFilter)('blocks.getSaveContent.extraProps', 'core/editor/hooks', props => {
    // Previously we had a filter deleting the className if it was an empty
    // string. That filter is no longer running, so now we need to delete it
    // here.
    if (props.hasOwnProperty('className') && !props.className) {
      delete props.className;
    }
    return props;
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/compat.js
/**
 * WordPress dependencies
 */


function migrateLightBlockWrapper(settings) {
  const {
    apiVersion = 1
  } = settings;
  if (apiVersion < 2 && (0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, 'lightBlockWrapper', false)) {
    settings.apiVersion = 2;
  }
  return settings;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/compat/migrateLightBlockWrapper', migrateLightBlockWrapper);

;// CONCATENATED MODULE: external ["wp","components"]
const external_wp_components_namespaceObject = window["wp"]["components"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-controls/groups.js
/**
 * WordPress dependencies
 */

const BlockControlsDefault = (0,external_wp_components_namespaceObject.createSlotFill)('BlockControls');
const BlockControlsBlock = (0,external_wp_components_namespaceObject.createSlotFill)('BlockControlsBlock');
const BlockControlsInline = (0,external_wp_components_namespaceObject.createSlotFill)('BlockFormatControls');
const BlockControlsOther = (0,external_wp_components_namespaceObject.createSlotFill)('BlockControlsOther');
const BlockControlsParent = (0,external_wp_components_namespaceObject.createSlotFill)('BlockControlsParent');
const groups = {
  default: BlockControlsDefault,
  block: BlockControlsBlock,
  inline: BlockControlsInline,
  other: BlockControlsOther,
  parent: BlockControlsParent
};
/* harmony default export */ const block_controls_groups = (groups);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-controls/hook.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


function useBlockControlsFill(group, shareWithChildBlocks) {
  const context = useBlockEditContext();
  if (context[mayDisplayControlsKey]) {
    return block_controls_groups[group]?.Fill;
  }
  if (context[mayDisplayParentControlsKey] && shareWithChildBlocks) {
    return block_controls_groups.parent.Fill;
  }
  return null;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-controls/fill.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function BlockControlsFill({
  group = 'default',
  controls,
  children,
  __experimentalShareWithChildBlocks = false
}) {
  const Fill = useBlockControlsFill(group, __experimentalShareWithChildBlocks);
  if (!Fill) {
    return null;
  }
  const innerMarkup = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [group === 'default' && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ToolbarGroup, {
      controls: controls
    }), children]
  });
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalStyleProvider, {
    document: document,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Fill, {
      children: fillProps => {
        // `fillProps.forwardedContext` is an array of context provider entries, provided by slot,
        // that should wrap the fill markup.
        const {
          forwardedContext = []
        } = fillProps;
        return forwardedContext.reduce((inner, [Provider, props]) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Provider, {
          ...props,
          children: inner
        }), innerMarkup);
      }
    })
  });
}

;// CONCATENATED MODULE: external ["wp","warning"]
const external_wp_warning_namespaceObject = window["wp"]["warning"];
var external_wp_warning_default = /*#__PURE__*/__webpack_require__.n(external_wp_warning_namespaceObject);
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-controls/slot.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



const {
  ComponentsContext
} = unlock(external_wp_components_namespaceObject.privateApis);
function BlockControlsSlot({
  group = 'default',
  ...props
}) {
  const toolbarState = (0,external_wp_element_namespaceObject.useContext)(external_wp_components_namespaceObject.__experimentalToolbarContext);
  const contextState = (0,external_wp_element_namespaceObject.useContext)(ComponentsContext);
  const fillProps = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    forwardedContext: [[external_wp_components_namespaceObject.__experimentalToolbarContext.Provider, {
      value: toolbarState
    }], [ComponentsContext.Provider, {
      value: contextState
    }]]
  }), [toolbarState, contextState]);
  const Slot = block_controls_groups[group]?.Slot;
  const fills = (0,external_wp_components_namespaceObject.__experimentalUseSlotFills)(Slot?.__unstableName);
  if (!Slot) {
     true ? external_wp_warning_default()(`Unknown BlockControls group "${group}" provided.`) : 0;
    return null;
  }
  if (!fills?.length) {
    return null;
  }
  const slot = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Slot, {
    ...props,
    bubblesVirtually: true,
    fillProps: fillProps
  });
  if (group === 'default') {
    return slot;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ToolbarGroup, {
    children: slot
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-controls/index.js
/**
 * Internal dependencies
 */



const BlockControls = BlockControlsFill;
BlockControls.Slot = BlockControlsSlot;

// This is just here for backward compatibility.
const BlockFormatControls = props => {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockControlsFill, {
    group: "inline",
    ...props
  });
};
BlockFormatControls.Slot = props => {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockControlsSlot, {
    group: "inline",
    ...props
  });
};
/* harmony default export */ const block_controls = (BlockControls);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-left.js
/**
 * WordPress dependencies
 */


const justifyLeft = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M9 9v6h11V9H9zM4 20h1.5V4H4v16z"
  })
});
/* harmony default export */ const justify_left = (justifyLeft);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-center.js
/**
 * WordPress dependencies
 */


const justifyCenter = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M12.5 15v5H11v-5H4V9h7V4h1.5v5h7v6h-7Z"
  })
});
/* harmony default export */ const justify_center = (justifyCenter);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-right.js
/**
 * WordPress dependencies
 */


const justifyRight = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M4 15h11V9H4v6zM18.5 4v16H20V4h-1.5z"
  })
});
/* harmony default export */ const justify_right = (justifyRight);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-space-between.js
/**
 * WordPress dependencies
 */


const justifySpaceBetween = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M9 15h6V9H9v6zm-5 5h1.5V4H4v16zM18.5 4v16H20V4h-1.5z"
  })
});
/* harmony default export */ const justify_space_between = (justifySpaceBetween);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-stretch.js
/**
 * WordPress dependencies
 */


const justifyStretch = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M4 4H5.5V20H4V4ZM7 10L17 10V14L7 14V10ZM20 4H18.5V20H20V4Z"
  })
});
/* harmony default export */ const justify_stretch = (justifyStretch);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/arrow-right.js
/**
 * WordPress dependencies
 */


const arrowRight = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m14.5 6.5-1 1 3.7 3.7H4v1.6h13.2l-3.7 3.7 1 1 5.6-5.5z"
  })
});
/* harmony default export */ const arrow_right = (arrowRight);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/arrow-down.js
/**
 * WordPress dependencies
 */


const arrowDown = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m16.5 13.5-3.7 3.7V4h-1.5v13.2l-3.8-3.7-1 1 5.5 5.6 5.5-5.6z"
  })
});
/* harmony default export */ const arrow_down = (arrowDown);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/definitions.js
// Layout definitions keyed by layout type.
// Provides a common definition of slugs, classnames, base styles, and spacing styles for each layout type.
// If making changes or additions to layout definitions, be sure to update the corresponding PHP definitions in
// `block-supports/layout.php` so that the server-side and client-side definitions match.
const LAYOUT_DEFINITIONS = {
  default: {
    name: 'default',
    slug: 'flow',
    className: 'is-layout-flow',
    baseStyles: [{
      selector: ' > .alignleft',
      rules: {
        float: 'left',
        'margin-inline-start': '0',
        'margin-inline-end': '2em'
      }
    }, {
      selector: ' > .alignright',
      rules: {
        float: 'right',
        'margin-inline-start': '2em',
        'margin-inline-end': '0'
      }
    }, {
      selector: ' > .aligncenter',
      rules: {
        'margin-left': 'auto !important',
        'margin-right': 'auto !important'
      }
    }],
    spacingStyles: [{
      selector: ' > :first-child',
      rules: {
        'margin-block-start': '0'
      }
    }, {
      selector: ' > :last-child',
      rules: {
        'margin-block-end': '0'
      }
    }, {
      selector: ' > *',
      rules: {
        'margin-block-start': null,
        'margin-block-end': '0'
      }
    }]
  },
  constrained: {
    name: 'constrained',
    slug: 'constrained',
    className: 'is-layout-constrained',
    baseStyles: [{
      selector: ' > .alignleft',
      rules: {
        float: 'left',
        'margin-inline-start': '0',
        'margin-inline-end': '2em'
      }
    }, {
      selector: ' > .alignright',
      rules: {
        float: 'right',
        'margin-inline-start': '2em',
        'margin-inline-end': '0'
      }
    }, {
      selector: ' > .aligncenter',
      rules: {
        'margin-left': 'auto !important',
        'margin-right': 'auto !important'
      }
    }, {
      selector: ' > :where(:not(.alignleft):not(.alignright):not(.alignfull))',
      rules: {
        'max-width': 'var(--wp--style--global--content-size)',
        'margin-left': 'auto !important',
        'margin-right': 'auto !important'
      }
    }, {
      selector: ' > .alignwide',
      rules: {
        'max-width': 'var(--wp--style--global--wide-size)'
      }
    }],
    spacingStyles: [{
      selector: ' > :first-child',
      rules: {
        'margin-block-start': '0'
      }
    }, {
      selector: ' > :last-child',
      rules: {
        'margin-block-end': '0'
      }
    }, {
      selector: ' > *',
      rules: {
        'margin-block-start': null,
        'margin-block-end': '0'
      }
    }]
  },
  flex: {
    name: 'flex',
    slug: 'flex',
    className: 'is-layout-flex',
    displayMode: 'flex',
    baseStyles: [{
      selector: '',
      rules: {
        'flex-wrap': 'wrap',
        'align-items': 'center'
      }
    }, {
      selector: ' > :is(*, div)',
      // :is(*, div) instead of just * increases the specificity by 001.
      rules: {
        margin: '0'
      }
    }],
    spacingStyles: [{
      selector: '',
      rules: {
        gap: null
      }
    }]
  },
  grid: {
    name: 'grid',
    slug: 'grid',
    className: 'is-layout-grid',
    displayMode: 'grid',
    baseStyles: [{
      selector: ' > :is(*, div)',
      // :is(*, div) instead of just * increases the specificity by 001.
      rules: {
        margin: '0'
      }
    }],
    spacingStyles: [{
      selector: '',
      rules: {
        gap: null
      }
    }]
  }
};

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/utils.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Utility to generate the proper CSS selector for layout styles.
 *
 * @param {string} selectors CSS selector, also supports multiple comma-separated selectors.
 * @param {string} append    The string to append.
 *
 * @return {string} - CSS selector.
 */
function appendSelectors(selectors, append = '') {
  // Ideally we shouldn't need the `.editor-styles-wrapper` increased specificity here
  // The problem though is that we have a `.editor-styles-wrapper p { margin: reset; }` style
  // it's used to reset the default margin added by wp-admin to paragraphs
  // so we need this to be higher speficity otherwise, it won't be applied to paragraphs inside containers
  // When the post editor is fully iframed, this extra classname could be removed.

  return selectors.split(',').map(subselector => `.editor-styles-wrapper ${subselector}${append ? ` ${append}` : ''}`).join(',');
}

/**
 * Get generated blockGap CSS rules based on layout definitions provided in theme.json
 * Falsy values in the layout definition's spacingStyles rules will be swapped out
 * with the provided `blockGapValue`.
 *
 * @param {string} selector          The CSS selector to target for the generated rules.
 * @param {Object} layoutDefinitions Layout definitions object.
 * @param {string} layoutType        The layout type (e.g. `default` or `flex`).
 * @param {string} blockGapValue     The current blockGap value to be applied.
 * @return {string} The generated CSS rules.
 */
function getBlockGapCSS(selector, layoutDefinitions = LAYOUT_DEFINITIONS, layoutType, blockGapValue) {
  let output = '';
  if (layoutDefinitions?.[layoutType]?.spacingStyles?.length && blockGapValue) {
    layoutDefinitions[layoutType].spacingStyles.forEach(gapStyle => {
      output += `${appendSelectors(selector, gapStyle.selector.trim())} { `;
      output += Object.entries(gapStyle.rules).map(([cssProperty, value]) => `${cssProperty}: ${value ? value : blockGapValue}`).join('; ');
      output += '; }';
    });
  }
  return output;
}

/**
 * Helper method to assign contextual info to clarify
 * alignment settings.
 *
 * Besides checking if `contentSize` and `wideSize` have a
 * value, we now show this information only if their values
 * are not a `css var`. This needs to change when parsing
 * css variables land.
 *
 * @see https://github.com/WordPress/gutenberg/pull/34710#issuecomment-918000752
 *
 * @param {Object} layout The layout object.
 * @return {Object} An object with contextual info per alignment.
 */
function getAlignmentsInfo(layout) {
  const {
    contentSize,
    wideSize,
    type = 'default'
  } = layout;
  const alignmentInfo = {};
  const sizeRegex = /^(?!0)\d+(px|em|rem|vw|vh|%|svw|lvw|dvw|svh|lvh|dvh|vi|svi|lvi|dvi|vb|svb|lvb|dvb|vmin|svmin|lvmin|dvmin|vmax|svmax|lvmax|dvmax)?$/i;
  if (sizeRegex.test(contentSize) && type === 'constrained') {
    // translators: %s: container size (i.e. 600px etc)
    alignmentInfo.none = (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('Max %s wide'), contentSize);
  }
  if (sizeRegex.test(wideSize)) {
    // translators: %s: container size (i.e. 600px etc)
    alignmentInfo.wide = (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('Max %s wide'), wideSize);
  }
  return alignmentInfo;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/sides-all.js
/**
 * WordPress dependencies
 */


const sidesAll = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m7.5 6h9v-1.5h-9zm0 13.5h9v-1.5h-9zm-3-3h1.5v-9h-1.5zm13.5-9v9h1.5v-9z"
  })
});
/* harmony default export */ const sides_all = (sidesAll);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/sides-horizontal.js
/**
 * WordPress dependencies
 */



const sidesHorizontal = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m7.5 6h9v-1.5h-9zm0 13.5h9v-1.5h-9zm-3-3h1.5v-9h-1.5zm13.5-9v9h1.5v-9z",
    style: {
      opacity: 0.25
    }
  }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m4.5 7.5v9h1.5v-9z"
  }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m18 7.5v9h1.5v-9z"
  })]
});
/* harmony default export */ const sides_horizontal = (sidesHorizontal);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/sides-vertical.js
/**
 * WordPress dependencies
 */



const sidesVertical = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m7.5 6h9v-1.5h-9zm0 13.5h9v-1.5h-9zm-3-3h1.5v-9h-1.5zm13.5-9v9h1.5v-9z",
    style: {
      opacity: 0.25
    }
  }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m7.5 6h9v-1.5h-9z"
  }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m7.5 19.5h9v-1.5h-9z"
  })]
});
/* harmony default export */ const sides_vertical = (sidesVertical);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/sides-top.js
/**
 * WordPress dependencies
 */



const sidesTop = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m7.5 6h9v-1.5h-9zm0 13.5h9v-1.5h-9zm-3-3h1.5v-9h-1.5zm13.5-9v9h1.5v-9z",
    style: {
      opacity: 0.25
    }
  }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m16.5 6h-9v-1.5h9z"
  })]
});
/* harmony default export */ const sides_top = (sidesTop);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/sides-right.js
/**
 * WordPress dependencies
 */



const sidesRight = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m7.5 6h9v-1.5h-9zm0 13.5h9v-1.5h-9zm-3-3h1.5v-9h-1.5zm13.5-9v9h1.5v-9z",
    style: {
      opacity: 0.25
    }
  }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m18 16.5v-9h1.5v9z"
  })]
});
/* harmony default export */ const sides_right = (sidesRight);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/sides-bottom.js
/**
 * WordPress dependencies
 */



const sidesBottom = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m7.5 6h9v-1.5h-9zm0 13.5h9v-1.5h-9zm-3-3h1.5v-9h-1.5zm13.5-9v9h1.5v-9z",
    style: {
      opacity: 0.25
    }
  }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m16.5 19.5h-9v-1.5h9z",
    style: {
      fill: '#1e1e1e'
    }
  })]
});
/* harmony default export */ const sides_bottom = (sidesBottom);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/sides-left.js
/**
 * WordPress dependencies
 */



const sidesLeft = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m7.5 6h9v-1.5h-9zm0 13.5h9v-1.5h-9zm-3-3h1.5v-9h-1.5zm13.5-9v9h1.5v-9z",
    style: {
      opacity: 0.25
    }
  }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m4.5 16.5v-9h1.5v9z"
  })]
});
/* harmony default export */ const sides_left = (sidesLeft);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/utils.js
/**
 * WordPress dependencies
 */


const RANGE_CONTROL_MAX_SIZE = 8;
const ALL_SIDES = ['top', 'right', 'bottom', 'left'];
const DEFAULT_VALUES = {
  top: undefined,
  right: undefined,
  bottom: undefined,
  left: undefined
};
const ICONS = {
  custom: sides_all,
  axial: sides_all,
  horizontal: sides_horizontal,
  vertical: sides_vertical,
  top: sides_top,
  right: sides_right,
  bottom: sides_bottom,
  left: sides_left
};
const LABELS = {
  default: (0,external_wp_i18n_namespaceObject.__)('Spacing control'),
  top: (0,external_wp_i18n_namespaceObject.__)('Top'),
  bottom: (0,external_wp_i18n_namespaceObject.__)('Bottom'),
  left: (0,external_wp_i18n_namespaceObject.__)('Left'),
  right: (0,external_wp_i18n_namespaceObject.__)('Right'),
  mixed: (0,external_wp_i18n_namespaceObject.__)('Mixed'),
  vertical: (0,external_wp_i18n_namespaceObject.__)('Vertical'),
  horizontal: (0,external_wp_i18n_namespaceObject.__)('Horizontal'),
  axial: (0,external_wp_i18n_namespaceObject.__)('Horizontal & vertical'),
  custom: (0,external_wp_i18n_namespaceObject.__)('Custom')
};
const VIEWS = {
  axial: 'axial',
  top: 'top',
  right: 'right',
  bottom: 'bottom',
  left: 'left',
  custom: 'custom'
};

/**
 * Checks is given value is a spacing preset.
 *
 * @param {string} value Value to check
 *
 * @return {boolean} Return true if value is string in format var:preset|spacing|.
 */
function isValueSpacingPreset(value) {
  if (!value?.includes) {
    return false;
  }
  return value === '0' || value.includes('var:preset|spacing|');
}

/**
 * Converts a spacing preset into a custom value.
 *
 * @param {string} value        Value to convert
 * @param {Array}  spacingSizes Array of the current spacing preset objects
 *
 * @return {string} Mapping of the spacing preset to its equivalent custom value.
 */
function getCustomValueFromPreset(value, spacingSizes) {
  if (!isValueSpacingPreset(value)) {
    return value;
  }
  const slug = getSpacingPresetSlug(value);
  const spacingSize = spacingSizes.find(size => String(size.slug) === slug);
  return spacingSize?.size;
}

/**
 * Converts a custom value to preset value if one can be found.
 *
 * Returns value as-is if no match is found.
 *
 * @param {string} value        Value to convert
 * @param {Array}  spacingSizes Array of the current spacing preset objects
 *
 * @return {string} The preset value if it can be found.
 */
function getPresetValueFromCustomValue(value, spacingSizes) {
  // Return value as-is if it is undefined or is already a preset, or '0';
  if (!value || isValueSpacingPreset(value) || value === '0') {
    return value;
  }
  const spacingMatch = spacingSizes.find(size => String(size.size) === String(value));
  if (spacingMatch?.slug) {
    return `var:preset|spacing|${spacingMatch.slug}`;
  }
  return value;
}

/**
 * Converts a spacing preset into a custom value.
 *
 * @param {string} value Value to convert.
 *
 * @return {string | undefined} CSS var string for given spacing preset value.
 */
function getSpacingPresetCssVar(value) {
  if (!value) {
    return;
  }
  const slug = value.match(/var:preset\|spacing\|(.+)/);
  if (!slug) {
    return value;
  }
  return `var(--wp--preset--spacing--${slug[1]})`;
}

/**
 * Returns the slug section of the given spacing preset string.
 *
 * @param {string} value Value to extract slug from.
 *
 * @return {string|undefined} The int value of the slug from given spacing preset.
 */
function getSpacingPresetSlug(value) {
  if (!value) {
    return;
  }
  if (value === '0' || value === 'default') {
    return value;
  }
  const slug = value.match(/var:preset\|spacing\|(.+)/);
  return slug ? slug[1] : undefined;
}

/**
 * Converts spacing preset value into a Range component value .
 *
 * @param {string} presetValue  Value to convert to Range value.
 * @param {Array}  spacingSizes Array of current spacing preset value objects.
 *
 * @return {number} The int value for use in Range control.
 */
function getSliderValueFromPreset(presetValue, spacingSizes) {
  if (presetValue === undefined) {
    return 0;
  }
  const slug = parseFloat(presetValue, 10) === 0 ? '0' : getSpacingPresetSlug(presetValue);
  const sliderValue = spacingSizes.findIndex(spacingSize => {
    return String(spacingSize.slug) === slug;
  });

  // Returning NaN rather than undefined as undefined makes range control thumb sit in center
  return sliderValue !== -1 ? sliderValue : NaN;
}

/**
 * Gets an items with the most occurrence within an array
 * https://stackoverflow.com/a/20762713
 *
 * @param {Array<any>} arr Array of items to check.
 * @return {any} The item with the most occurrences.
 */
function mode(arr) {
  return arr.sort((a, b) => arr.filter(v => v === a).length - arr.filter(v => v === b).length).pop();
}

/**
 * Gets the 'all' input value from values data.
 *
 * @param {Object} values Box spacing values
 *
 * @return {string} The most common value from all sides of box.
 */
function getAllRawValue(values = {}) {
  return mode(Object.values(values));
}

/**
 * Checks to determine if values are mixed.
 *
 * @param {Object} values Box values.
 * @param {Array}  sides  Sides that values relate to.
 *
 * @return {boolean} Whether values are mixed.
 */
function isValuesMixed(values = {}, sides = ALL_SIDES) {
  return Object.values(values).length >= 1 && Object.values(values).length < sides.length || new Set(Object.values(values)).size > 1;
}

/**
 * Checks to determine if values are defined.
 *
 * @param {Object} values Box values.
 *
 * @return {boolean} Whether values are defined.
 */
function isValuesDefined(values) {
  if (values === undefined || values === null) {
    return false;
  }
  return Object.values(values).filter(value => !!value).length > 0;
}

/**
 * Determines whether a particular axis has support. If no axis is
 * specified, this function checks if either axis is supported.
 *
 * @param {Array}  sides Supported sides.
 * @param {string} axis  Which axis to check.
 *
 * @return {boolean} Whether there is support for the specified axis or both axes.
 */
function hasAxisSupport(sides, axis) {
  if (!sides || !sides.length) {
    return false;
  }
  const hasHorizontalSupport = sides.includes('horizontal') || sides.includes('left') && sides.includes('right');
  const hasVerticalSupport = sides.includes('vertical') || sides.includes('top') && sides.includes('bottom');
  if (axis === 'horizontal') {
    return hasHorizontalSupport;
  }
  if (axis === 'vertical') {
    return hasVerticalSupport;
  }
  return hasHorizontalSupport || hasVerticalSupport;
}

/**
 * Determines which menu options should be included in the SidePicker.
 *
 * @param {Array} sides Supported sides.
 *
 * @return {Object} Menu options with each option containing label & icon.
 */
function getSupportedMenuItems(sides) {
  if (!sides || !sides.length) {
    return {};
  }
  const menuItems = {};

  // Determine the primary "side" menu options.
  const hasHorizontalSupport = hasAxisSupport(sides, 'horizontal');
  const hasVerticalSupport = hasAxisSupport(sides, 'vertical');
  if (hasHorizontalSupport && hasVerticalSupport) {
    menuItems.axial = {
      label: LABELS.axial,
      icon: ICONS.axial
    };
  } else if (hasHorizontalSupport) {
    menuItems.axial = {
      label: LABELS.horizontal,
      icon: ICONS.horizontal
    };
  } else if (hasVerticalSupport) {
    menuItems.axial = {
      label: LABELS.vertical,
      icon: ICONS.vertical
    };
  }

  // Track whether we have any individual sides so we can omit the custom
  // option if required.
  let numberOfIndividualSides = 0;
  ALL_SIDES.forEach(side => {
    if (sides.includes(side)) {
      numberOfIndividualSides += 1;
      menuItems[side] = {
        label: LABELS[side],
        icon: ICONS[side]
      };
    }
  });

  // Add custom item if there are enough sides to warrant a separated view.
  if (numberOfIndividualSides > 1) {
    menuItems.custom = {
      label: LABELS.custom,
      icon: ICONS.custom
    };
  }
  return menuItems;
}

/**
 * Checks if the supported sides are balanced for each axis.
 * - Horizontal - both left and right sides are supported.
 * - Vertical - both top and bottom are supported.
 *
 * @param {Array} sides The supported sides which may be axes as well.
 *
 * @return {boolean} Whether or not the supported sides are balanced.
 */
function hasBalancedSidesSupport(sides = []) {
  const counts = {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0
  };
  sides.forEach(side => counts[side] += 1);
  return (counts.top + counts.bottom) % 2 === 0 && (counts.left + counts.right) % 2 === 0;
}

/**
 * Determines which view the SpacingSizesControl should default to on its
 * first render; Axial, Custom, or Single side.
 *
 * @param {Object} values Current side values.
 * @param {Array}  sides  Supported sides.
 *
 * @return {string} View to display.
 */
function getInitialView(values = {}, sides) {
  const {
    top,
    right,
    bottom,
    left
  } = values;
  const sideValues = [top, right, bottom, left].filter(Boolean);

  // Axial ( Horizontal & vertical ).
  // - Has axial side support
  // - Has axial side values which match
  // - Has no values and the supported sides are balanced
  const hasMatchingAxialValues = top === bottom && left === right && (!!top || !!left);
  const hasNoValuesAndBalancedSides = !sideValues.length && hasBalancedSidesSupport(sides);
  if (hasAxisSupport(sides) && (hasMatchingAxialValues || hasNoValuesAndBalancedSides)) {
    return VIEWS.axial;
  }

  // Single side.
  // - Ensure the side returned is the first side that has a value.
  if (sideValues.length === 1) {
    let side;
    Object.entries(values).some(([key, value]) => {
      side = key;
      return value !== undefined;
    });
    return side;
  }

  // Only single side supported and no value defined.
  if (sides?.length === 1 && !sideValues.length) {
    return sides[0];
  }

  // Default to the Custom (separated sides) view.
  return VIEWS.custom;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/gap.js
/**
 * Internal dependencies
 */


/**
 * Returns a BoxControl object value from a given blockGap style value.
 * The string check is for backwards compatibility before Gutenberg supported
 * split gap values (row and column) and the value was a string n + unit.
 *
 * @param {string? | Object?} blockGapValue A block gap string or axial object value, e.g., '10px' or { top: '10px', left: '10px'}.
 * @return {Object|null}                    A value to pass to the BoxControl component.
 */
function getGapBoxControlValueFromStyle(blockGapValue) {
  if (!blockGapValue) {
    return null;
  }
  const isValueString = typeof blockGapValue === 'string';
  return {
    top: isValueString ? blockGapValue : blockGapValue?.top,
    left: isValueString ? blockGapValue : blockGapValue?.left
  };
}

/**
 * Returns a CSS value for the `gap` property from a given blockGap style.
 *
 * @param {string? | Object?} blockGapValue A block gap string or axial object value, e.g., '10px' or { top: '10px', left: '10px'}.
 * @param {string?}           defaultValue  A default gap value.
 * @return {string|null}                    The concatenated gap value (row and column).
 */
function getGapCSSValue(blockGapValue, defaultValue = '0') {
  const blockGapBoxControlValue = getGapBoxControlValueFromStyle(blockGapValue);
  if (!blockGapBoxControlValue) {
    return null;
  }
  const row = getSpacingPresetCssVar(blockGapBoxControlValue?.top) || defaultValue;
  const column = getSpacingPresetCssVar(blockGapBoxControlValue?.left) || defaultValue;
  return row === column ? row : `${row} ${column}`;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-vertical-alignment-control/icons.js
/**
 * WordPress dependencies
 */


const alignBottom = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Path, {
    d: "M15 4H9v11h6V4zM4 18.5V20h16v-1.5H4z"
  })
});
const alignCenter = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Path, {
    d: "M20 11h-5V4H9v7H4v1.5h5V20h6v-7.5h5z"
  })
});
const alignTop = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Path, {
    d: "M9 20h6V9H9v11zM4 4v1.5h16V4H4z"
  })
});
const alignStretch = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Path, {
    d: "M4 4L20 4L20 5.5L4 5.5L4 4ZM10 7L14 7L14 17L10 17L10 7ZM20 18.5L4 18.5L4 20L20 20L20 18.5Z"
  })
});
const spaceBetween = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Path, {
    d: "M7 4H17V8L7 8V4ZM7 16L17 16V20L7 20V16ZM20 11.25H4V12.75H20V11.25Z"
  })
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-vertical-alignment-control/ui.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


const BLOCK_ALIGNMENTS_CONTROLS = {
  top: {
    icon: alignTop,
    title: (0,external_wp_i18n_namespaceObject._x)('Align top', 'Block vertical alignment setting')
  },
  center: {
    icon: alignCenter,
    title: (0,external_wp_i18n_namespaceObject._x)('Align middle', 'Block vertical alignment setting')
  },
  bottom: {
    icon: alignBottom,
    title: (0,external_wp_i18n_namespaceObject._x)('Align bottom', 'Block vertical alignment setting')
  },
  stretch: {
    icon: alignStretch,
    title: (0,external_wp_i18n_namespaceObject._x)('Stretch to fill', 'Block vertical alignment setting')
  },
  'space-between': {
    icon: spaceBetween,
    title: (0,external_wp_i18n_namespaceObject._x)('Space between', 'Block vertical alignment setting')
  }
};
const DEFAULT_CONTROLS = ['top', 'center', 'bottom'];
const DEFAULT_CONTROL = 'top';
function BlockVerticalAlignmentUI({
  value,
  onChange,
  controls = DEFAULT_CONTROLS,
  isCollapsed = true,
  isToolbar
}) {
  function applyOrUnset(align) {
    return () => onChange(value === align ? undefined : align);
  }
  const activeAlignment = BLOCK_ALIGNMENTS_CONTROLS[value];
  const defaultAlignmentControl = BLOCK_ALIGNMENTS_CONTROLS[DEFAULT_CONTROL];
  const UIComponent = isToolbar ? external_wp_components_namespaceObject.ToolbarGroup : external_wp_components_namespaceObject.ToolbarDropdownMenu;
  const extraProps = isToolbar ? {
    isCollapsed
  } : {};
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(UIComponent, {
    icon: activeAlignment ? activeAlignment.icon : defaultAlignmentControl.icon,
    label: (0,external_wp_i18n_namespaceObject._x)('Change vertical alignment', 'Block vertical alignment setting label'),
    controls: controls.map(control => {
      return {
        ...BLOCK_ALIGNMENTS_CONTROLS[control],
        isActive: value === control,
        role: isCollapsed ? 'menuitemradio' : undefined,
        onClick: applyOrUnset(control)
      };
    }),
    ...extraProps
  });
}

/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/block-vertical-alignment-toolbar/README.md
 */
/* harmony default export */ const ui = (BlockVerticalAlignmentUI);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-vertical-alignment-control/index.js
/**
 * Internal dependencies
 */


const BlockVerticalAlignmentControl = props => {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ui, {
    ...props,
    isToolbar: false
  });
};
const BlockVerticalAlignmentToolbar = props => {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ui, {
    ...props,
    isToolbar: true
  });
};

/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/block-vertical-alignment-control/README.md
 */


;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/justify-content-control/ui.js
/**
 * WordPress dependencies
 */




const icons = {
  left: justify_left,
  center: justify_center,
  right: justify_right,
  'space-between': justify_space_between,
  stretch: justify_stretch
};
function JustifyContentUI({
  allowedControls = ['left', 'center', 'right', 'space-between'],
  isCollapsed = true,
  onChange,
  value,
  popoverProps,
  isToolbar
}) {
  // If the control is already selected we want a click
  // again on the control to deselect the item, so we
  // call onChange( undefined )
  const handleClick = next => {
    if (next === value) {
      onChange(undefined);
    } else {
      onChange(next);
    }
  };
  const icon = value ? icons[value] : icons.left;
  const allControls = [{
    name: 'left',
    icon: justify_left,
    title: (0,external_wp_i18n_namespaceObject.__)('Justify items left'),
    isActive: 'left' === value,
    onClick: () => handleClick('left')
  }, {
    name: 'center',
    icon: justify_center,
    title: (0,external_wp_i18n_namespaceObject.__)('Justify items center'),
    isActive: 'center' === value,
    onClick: () => handleClick('center')
  }, {
    name: 'right',
    icon: justify_right,
    title: (0,external_wp_i18n_namespaceObject.__)('Justify items right'),
    isActive: 'right' === value,
    onClick: () => handleClick('right')
  }, {
    name: 'space-between',
    icon: justify_space_between,
    title: (0,external_wp_i18n_namespaceObject.__)('Space between items'),
    isActive: 'space-between' === value,
    onClick: () => handleClick('space-between')
  }, {
    name: 'stretch',
    icon: justify_stretch,
    title: (0,external_wp_i18n_namespaceObject.__)('Stretch items'),
    isActive: 'stretch' === value,
    onClick: () => handleClick('stretch')
  }];
  const UIComponent = isToolbar ? external_wp_components_namespaceObject.ToolbarGroup : external_wp_components_namespaceObject.ToolbarDropdownMenu;
  const extraProps = isToolbar ? {
    isCollapsed
  } : {};
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(UIComponent, {
    icon: icon,
    popoverProps: popoverProps,
    label: (0,external_wp_i18n_namespaceObject.__)('Change items justification'),
    controls: allControls.filter(elem => allowedControls.includes(elem.name)),
    ...extraProps
  });
}
/* harmony default export */ const justify_content_control_ui = (JustifyContentUI);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/justify-content-control/index.js
/**
 * Internal dependencies
 */


const JustifyContentControl = props => {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(justify_content_control_ui, {
    ...props,
    isToolbar: false
  });
};
const JustifyToolbar = props => {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(justify_content_control_ui, {
    ...props,
    isToolbar: true
  });
};

/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/justify-content-control/README.md
 */


;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/flex.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */






// Used with the default, horizontal flex orientation.



const justifyContentMap = {
  left: 'flex-start',
  right: 'flex-end',
  center: 'center',
  'space-between': 'space-between'
};

// Used with the vertical (column) flex orientation.
const alignItemsMap = {
  left: 'flex-start',
  right: 'flex-end',
  center: 'center',
  stretch: 'stretch'
};
const verticalAlignmentMap = {
  top: 'flex-start',
  center: 'center',
  bottom: 'flex-end',
  stretch: 'stretch',
  'space-between': 'space-between'
};
const flexWrapOptions = ['wrap', 'nowrap'];
/* harmony default export */ const flex = ({
  name: 'flex',
  label: (0,external_wp_i18n_namespaceObject.__)('Flex'),
  inspectorControls: function FlexLayoutInspectorControls({
    layout = {},
    onChange,
    layoutBlockSupport = {}
  }) {
    const {
      allowOrientation = true
    } = layoutBlockSupport;
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Flex, {
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, {
          children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(FlexLayoutJustifyContentControl, {
            layout: layout,
            onChange: onChange
          })
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, {
          children: allowOrientation && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(OrientationControl, {
            layout: layout,
            onChange: onChange
          })
        })]
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(FlexWrapControl, {
        layout: layout,
        onChange: onChange
      })]
    });
  },
  toolBarControls: function FlexLayoutToolbarControls({
    layout = {},
    onChange,
    layoutBlockSupport
  }) {
    if (layoutBlockSupport?.allowSwitching) {
      return null;
    }
    const {
      allowVerticalAlignment = true
    } = layoutBlockSupport;
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(block_controls, {
      group: "block",
      __experimentalShareWithChildBlocks: true,
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(FlexLayoutJustifyContentControl, {
        layout: layout,
        onChange: onChange,
        isToolbar: true
      }), allowVerticalAlignment && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(FlexLayoutVerticalAlignmentControl, {
        layout: layout,
        onChange: onChange,
        isToolbar: true
      })]
    });
  },
  getLayoutStyle: function getLayoutStyle({
    selector,
    layout,
    style,
    blockName,
    hasBlockGapSupport,
    layoutDefinitions = LAYOUT_DEFINITIONS
  }) {
    const {
      orientation = 'horizontal'
    } = layout;

    // If a block's block.json skips serialization for spacing or spacing.blockGap,
    // don't apply the user-defined value to the styles.
    const blockGapValue = style?.spacing?.blockGap && !shouldSkipSerialization(blockName, 'spacing', 'blockGap') ? getGapCSSValue(style?.spacing?.blockGap, '0.5em') : undefined;
    const justifyContent = justifyContentMap[layout.justifyContent];
    const flexWrap = flexWrapOptions.includes(layout.flexWrap) ? layout.flexWrap : 'wrap';
    const verticalAlignment = verticalAlignmentMap[layout.verticalAlignment];
    const alignItems = alignItemsMap[layout.justifyContent] || alignItemsMap.left;
    let output = '';
    const rules = [];
    if (flexWrap && flexWrap !== 'wrap') {
      rules.push(`flex-wrap: ${flexWrap}`);
    }
    if (orientation === 'horizontal') {
      if (verticalAlignment) {
        rules.push(`align-items: ${verticalAlignment}`);
      }
      if (justifyContent) {
        rules.push(`justify-content: ${justifyContent}`);
      }
    } else {
      if (verticalAlignment) {
        rules.push(`justify-content: ${verticalAlignment}`);
      }
      rules.push('flex-direction: column');
      rules.push(`align-items: ${alignItems}`);
    }
    if (rules.length) {
      output = `${appendSelectors(selector)} {
				${rules.join('; ')};
			}`;
    }

    // Output blockGap styles based on rules contained in layout definitions in theme.json.
    if (hasBlockGapSupport && blockGapValue) {
      output += getBlockGapCSS(selector, layoutDefinitions, 'flex', blockGapValue);
    }
    return output;
  },
  getOrientation(layout) {
    const {
      orientation = 'horizontal'
    } = layout;
    return orientation;
  },
  getAlignments() {
    return [];
  }
});
function FlexLayoutVerticalAlignmentControl({
  layout,
  onChange,
  isToolbar = false
}) {
  const {
    orientation = 'horizontal'
  } = layout;
  const defaultVerticalAlignment = orientation === 'horizontal' ? verticalAlignmentMap.center : verticalAlignmentMap.top;
  const {
    verticalAlignment = defaultVerticalAlignment
  } = layout;
  const onVerticalAlignmentChange = value => {
    onChange({
      ...layout,
      verticalAlignment: value
    });
  };
  if (isToolbar) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockVerticalAlignmentControl, {
      onChange: onVerticalAlignmentChange,
      value: verticalAlignment,
      controls: orientation === 'horizontal' ? ['top', 'center', 'bottom', 'stretch'] : ['top', 'center', 'bottom', 'space-between']
    });
  }
  const verticalAlignmentOptions = [{
    value: 'flex-start',
    label: (0,external_wp_i18n_namespaceObject.__)('Align items top')
  }, {
    value: 'center',
    label: (0,external_wp_i18n_namespaceObject.__)('Align items center')
  }, {
    value: 'flex-end',
    label: (0,external_wp_i18n_namespaceObject.__)('Align items bottom')
  }];
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", {
    className: "block-editor-hooks__flex-layout-vertical-alignment-control",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("legend", {
      children: (0,external_wp_i18n_namespaceObject.__)('Vertical alignment')
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      children: verticalAlignmentOptions.map((value, icon, label) => {
        return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          label: label,
          icon: icon,
          isPressed: verticalAlignment === value,
          onClick: () => onVerticalAlignmentChange(value)
        }, value);
      })
    })]
  });
}
const POPOVER_PROPS = {
  placement: 'bottom-start'
};
function FlexLayoutJustifyContentControl({
  layout,
  onChange,
  isToolbar = false
}) {
  const {
    justifyContent = 'left',
    orientation = 'horizontal'
  } = layout;
  const onJustificationChange = value => {
    onChange({
      ...layout,
      justifyContent: value
    });
  };
  const allowedControls = ['left', 'center', 'right'];
  if (orientation === 'horizontal') {
    allowedControls.push('space-between');
  } else {
    allowedControls.push('stretch');
  }
  if (isToolbar) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(JustifyContentControl, {
      allowedControls: allowedControls,
      value: justifyContent,
      onChange: onJustificationChange,
      popoverProps: POPOVER_PROPS
    });
  }
  const justificationOptions = [{
    value: 'left',
    icon: justify_left,
    label: (0,external_wp_i18n_namespaceObject.__)('Justify items left')
  }, {
    value: 'center',
    icon: justify_center,
    label: (0,external_wp_i18n_namespaceObject.__)('Justify items center')
  }, {
    value: 'right',
    icon: justify_right,
    label: (0,external_wp_i18n_namespaceObject.__)('Justify items right')
  }];
  if (orientation === 'horizontal') {
    justificationOptions.push({
      value: 'space-between',
      icon: justify_space_between,
      label: (0,external_wp_i18n_namespaceObject.__)('Space between items')
    });
  } else {
    justificationOptions.push({
      value: 'stretch',
      icon: justify_stretch,
      label: (0,external_wp_i18n_namespaceObject.__)('Stretch items')
    });
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToggleGroupControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Justification'),
    value: justifyContent,
    onChange: onJustificationChange,
    className: "block-editor-hooks__flex-layout-justification-controls",
    children: justificationOptions.map(({
      value,
      icon,
      label
    }) => {
      return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon, {
        value: value,
        icon: icon,
        label: label
      }, value);
    })
  });
}
function FlexWrapControl({
  layout,
  onChange
}) {
  const {
    flexWrap = 'wrap'
  } = layout;
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ToggleControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Allow to wrap to multiple lines'),
    onChange: value => {
      onChange({
        ...layout,
        flexWrap: value ? 'wrap' : 'nowrap'
      });
    },
    checked: flexWrap === 'wrap'
  });
}
function OrientationControl({
  layout,
  onChange
}) {
  const {
    orientation = 'horizontal',
    verticalAlignment,
    justifyContent
  } = layout;
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalToggleGroupControl, {
    __nextHasNoMarginBottom: true,
    className: "block-editor-hooks__flex-layout-orientation-controls",
    label: (0,external_wp_i18n_namespaceObject.__)('Orientation'),
    value: orientation,
    onChange: value => {
      // Make sure the vertical alignment and justification are compatible with the new orientation.
      let newVerticalAlignment = verticalAlignment;
      let newJustification = justifyContent;
      if (value === 'horizontal') {
        if (verticalAlignment === 'space-between') {
          newVerticalAlignment = 'center';
        }
        if (justifyContent === 'stretch') {
          newJustification = 'left';
        }
      } else {
        if (verticalAlignment === 'stretch') {
          newVerticalAlignment = 'top';
        }
        if (justifyContent === 'space-between') {
          newJustification = 'left';
        }
      }
      return onChange({
        ...layout,
        orientation: value,
        verticalAlignment: newVerticalAlignment,
        justifyContent: newJustification
      });
    },
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon, {
      icon: arrow_right,
      value: "horizontal",
      label: (0,external_wp_i18n_namespaceObject.__)('Horizontal')
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon, {
      icon: arrow_down,
      value: "vertical",
      label: (0,external_wp_i18n_namespaceObject.__)('Vertical')
    })]
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/flow.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




/* harmony default export */ const flow = ({
  name: 'default',
  label: (0,external_wp_i18n_namespaceObject.__)('Flow'),
  inspectorControls: function DefaultLayoutInspectorControls() {
    return null;
  },
  toolBarControls: function DefaultLayoutToolbarControls() {
    return null;
  },
  getLayoutStyle: function getLayoutStyle({
    selector,
    style,
    blockName,
    hasBlockGapSupport,
    layoutDefinitions = LAYOUT_DEFINITIONS
  }) {
    const blockGapStyleValue = getGapCSSValue(style?.spacing?.blockGap);

    // If a block's block.json skips serialization for spacing or
    // spacing.blockGap, don't apply the user-defined value to the styles.
    let blockGapValue = '';
    if (!shouldSkipSerialization(blockName, 'spacing', 'blockGap')) {
      // If an object is provided only use the 'top' value for this kind of gap.
      if (blockGapStyleValue?.top) {
        blockGapValue = getGapCSSValue(blockGapStyleValue?.top);
      } else if (typeof blockGapStyleValue === 'string') {
        blockGapValue = getGapCSSValue(blockGapStyleValue);
      }
    }
    let output = '';

    // Output blockGap styles based on rules contained in layout definitions in theme.json.
    if (hasBlockGapSupport && blockGapValue) {
      output += getBlockGapCSS(selector, layoutDefinitions, 'default', blockGapValue);
    }
    return output;
  },
  getOrientation() {
    return 'vertical';
  },
  getAlignments(layout, isBlockBasedTheme) {
    const alignmentInfo = getAlignmentsInfo(layout);
    if (layout.alignments !== undefined) {
      if (!layout.alignments.includes('none')) {
        layout.alignments.unshift('none');
      }
      return layout.alignments.map(alignment => ({
        name: alignment,
        info: alignmentInfo[alignment]
      }));
    }
    const alignments = [{
      name: 'left'
    }, {
      name: 'center'
    }, {
      name: 'right'
    }];

    // This is for backwards compatibility with hybrid themes.
    if (!isBlockBasedTheme) {
      const {
        contentSize,
        wideSize
      } = layout;
      if (contentSize) {
        alignments.unshift({
          name: 'full'
        });
      }
      if (wideSize) {
        alignments.unshift({
          name: 'wide',
          info: alignmentInfo.wide
        });
      }
    }
    alignments.unshift({
      name: 'none',
      info: alignmentInfo.none
    });
    return alignments;
  }
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/icon/index.js
/**
 * WordPress dependencies
 */


/** @typedef {{icon: JSX.Element, size?: number} & import('@wordpress/primitives').SVGProps} IconProps */

/**
 * Return an SVG icon.
 *
 * @param {IconProps}                                 props icon is the SVG component to render
 *                                                          size is a number specifiying the icon size in pixels
 *                                                          Other props will be passed to wrapped SVG component
 * @param {import('react').ForwardedRef<HTMLElement>} ref   The forwarded ref to the SVG element.
 *
 * @return {JSX.Element}  Icon component
 */
function Icon({
  icon,
  size = 24,
  ...props
}, ref) {
  return (0,external_wp_element_namespaceObject.cloneElement)(icon, {
    width: size,
    height: size,
    ...props,
    ref
  });
}
/* harmony default export */ const build_module_icon = ((0,external_wp_element_namespaceObject.forwardRef)(Icon));

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/position-center.js
/**
 * WordPress dependencies
 */


const positionCenter = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M19 5.5H5V4h14v1.5ZM19 20H5v-1.5h14V20ZM7 9h10v6H7V9Z"
  })
});
/* harmony default export */ const position_center = (positionCenter);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/stretch-wide.js
/**
 * WordPress dependencies
 */


const stretchWide = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M16 5.5H8V4h8v1.5ZM16 20H8v-1.5h8V20ZM5 9h14v6H5V9Z"
  })
});
/* harmony default export */ const stretch_wide = (stretchWide);

;// CONCATENATED MODULE: external ["wp","styleEngine"]
const external_wp_styleEngine_namespaceObject = window["wp"]["styleEngine"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/constrained.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */








/* harmony default export */ const constrained = ({
  name: 'constrained',
  label: (0,external_wp_i18n_namespaceObject.__)('Constrained'),
  inspectorControls: function DefaultLayoutInspectorControls({
    layout,
    onChange,
    layoutBlockSupport = {}
  }) {
    const {
      wideSize,
      contentSize,
      justifyContent = 'center'
    } = layout;
    const {
      allowJustification = true,
      allowCustomContentAndWideSize = true
    } = layoutBlockSupport;
    const onJustificationChange = value => {
      onChange({
        ...layout,
        justifyContent: value
      });
    };
    const justificationOptions = [{
      value: 'left',
      icon: justify_left,
      label: (0,external_wp_i18n_namespaceObject.__)('Justify items left')
    }, {
      value: 'center',
      icon: justify_center,
      label: (0,external_wp_i18n_namespaceObject.__)('Justify items center')
    }, {
      value: 'right',
      icon: justify_right,
      label: (0,external_wp_i18n_namespaceObject.__)('Justify items right')
    }];
    const [availableUnits] = use_settings_useSettings('spacing.units');
    const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
      availableUnits: availableUnits || ['%', 'px', 'em', 'rem', 'vw']
    });
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
      children: [allowCustomContentAndWideSize && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
          className: "block-editor-hooks__layout-controls",
          children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
            className: "block-editor-hooks__layout-controls-unit",
            children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalUnitControl, {
              className: "block-editor-hooks__layout-controls-unit-input",
              label: (0,external_wp_i18n_namespaceObject.__)('Content'),
              labelPosition: "top",
              __unstableInputWidth: "80px",
              value: contentSize || wideSize || '',
              onChange: nextWidth => {
                nextWidth = 0 > parseFloat(nextWidth) ? '0' : nextWidth;
                onChange({
                  ...layout,
                  contentSize: nextWidth
                });
              },
              units: units
            }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(build_module_icon, {
              icon: position_center
            })]
          }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
            className: "block-editor-hooks__layout-controls-unit",
            children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalUnitControl, {
              className: "block-editor-hooks__layout-controls-unit-input",
              label: (0,external_wp_i18n_namespaceObject.__)('Wide'),
              labelPosition: "top",
              __unstableInputWidth: "80px",
              value: wideSize || contentSize || '',
              onChange: nextWidth => {
                nextWidth = 0 > parseFloat(nextWidth) ? '0' : nextWidth;
                onChange({
                  ...layout,
                  wideSize: nextWidth
                });
              },
              units: units
            }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(build_module_icon, {
              icon: stretch_wide
            })]
          })]
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("p", {
          className: "block-editor-hooks__layout-controls-helptext",
          children: (0,external_wp_i18n_namespaceObject.__)('Customize the width for all elements that are assigned to the center or wide columns.')
        })]
      }), allowJustification && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToggleGroupControl, {
        __nextHasNoMarginBottom: true,
        label: (0,external_wp_i18n_namespaceObject.__)('Justification'),
        value: justifyContent,
        onChange: onJustificationChange,
        children: justificationOptions.map(({
          value,
          icon,
          label
        }) => {
          return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOptionIcon, {
            value: value,
            icon: icon,
            label: label
          }, value);
        })
      })]
    });
  },
  toolBarControls: function DefaultLayoutToolbarControls() {
    return null;
  },
  getLayoutStyle: function getLayoutStyle({
    selector,
    layout = {},
    style,
    blockName,
    hasBlockGapSupport,
    layoutDefinitions = LAYOUT_DEFINITIONS
  }) {
    const {
      contentSize,
      wideSize,
      justifyContent
    } = layout;
    const blockGapStyleValue = getGapCSSValue(style?.spacing?.blockGap);

    // If a block's block.json skips serialization for spacing or
    // spacing.blockGap, don't apply the user-defined value to the styles.
    let blockGapValue = '';
    if (!shouldSkipSerialization(blockName, 'spacing', 'blockGap')) {
      // If an object is provided only use the 'top' value for this kind of gap.
      if (blockGapStyleValue?.top) {
        blockGapValue = getGapCSSValue(blockGapStyleValue?.top);
      } else if (typeof blockGapStyleValue === 'string') {
        blockGapValue = getGapCSSValue(blockGapStyleValue);
      }
    }
    const marginLeft = justifyContent === 'left' ? '0 !important' : 'auto !important';
    const marginRight = justifyContent === 'right' ? '0 !important' : 'auto !important';
    let output = !!contentSize || !!wideSize ? `
					${appendSelectors(selector, '> :where(:not(.alignleft):not(.alignright):not(.alignfull))')} {
						max-width: ${contentSize !== null && contentSize !== void 0 ? contentSize : wideSize};
						margin-left: ${marginLeft};
						margin-right: ${marginRight};
					}
					${appendSelectors(selector, '> .alignwide')}  {
						max-width: ${wideSize !== null && wideSize !== void 0 ? wideSize : contentSize};
					}
					${appendSelectors(selector, '> .alignfull')} {
						max-width: none;
					}
				` : '';
    if (justifyContent === 'left') {
      output += `${appendSelectors(selector, '> :where(:not(.alignleft):not(.alignright):not(.alignfull))')}
			{ margin-left: ${marginLeft}; }`;
    } else if (justifyContent === 'right') {
      output += `${appendSelectors(selector, '> :where(:not(.alignleft):not(.alignright):not(.alignfull))')}
			{ margin-right: ${marginRight}; }`;
    }

    // If there is custom padding, add negative margins for alignfull blocks.
    if (style?.spacing?.padding) {
      // The style object might be storing a preset so we need to make sure we get a usable value.
      const paddingValues = (0,external_wp_styleEngine_namespaceObject.getCSSRules)(style);
      paddingValues.forEach(rule => {
        if (rule.key === 'paddingRight') {
          output += `
					${appendSelectors(selector, '> .alignfull')} {
						margin-right: calc(${rule.value} * -1);
					}
					`;
        } else if (rule.key === 'paddingLeft') {
          output += `
					${appendSelectors(selector, '> .alignfull')} {
						margin-left: calc(${rule.value} * -1);
					}
					`;
        }
      });
    }

    // Output blockGap styles based on rules contained in layout definitions in theme.json.
    if (hasBlockGapSupport && blockGapValue) {
      output += getBlockGapCSS(selector, layoutDefinitions, 'constrained', blockGapValue);
    }
    return output;
  },
  getOrientation() {
    return 'vertical';
  },
  getAlignments(layout) {
    const alignmentInfo = getAlignmentsInfo(layout);
    if (layout.alignments !== undefined) {
      if (!layout.alignments.includes('none')) {
        layout.alignments.unshift('none');
      }
      return layout.alignments.map(alignment => ({
        name: alignment,
        info: alignmentInfo[alignment]
      }));
    }
    const {
      contentSize,
      wideSize
    } = layout;
    const alignments = [{
      name: 'left'
    }, {
      name: 'center'
    }, {
      name: 'right'
    }];
    if (contentSize) {
      alignments.unshift({
        name: 'full'
      });
    }
    if (wideSize) {
      alignments.unshift({
        name: 'wide',
        info: alignmentInfo.wide
      });
    }
    alignments.unshift({
      name: 'none',
      info: alignmentInfo.none
    });
    return alignments;
  }
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/provider/block-refs-provider.js
/**
 * WordPress dependencies
 */



const BlockRefs = (0,external_wp_element_namespaceObject.createContext)({
  refsMap: (0,external_wp_compose_namespaceObject.observableMap)()
});
function BlockRefsProvider({
  children
}) {
  const value = (0,external_wp_element_namespaceObject.useMemo)(() => ({
    refsMap: (0,external_wp_compose_namespaceObject.observableMap)()
  }), []);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockRefs.Provider, {
    value: value,
    children: children
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list/use-block-props/use-block-refs.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/** @typedef {import('@wordpress/element').RefCallback} RefCallback */
/** @typedef {import('@wordpress/element').RefObject} RefObject */

/**
 * Provides a ref to the BlockRefs context.
 *
 * @param {string} clientId The client ID of the element ref.
 *
 * @return {RefCallback} Ref callback.
 */
function useBlockRefProvider(clientId) {
  const {
    refsMap
  } = (0,external_wp_element_namespaceObject.useContext)(BlockRefs);
  return (0,external_wp_compose_namespaceObject.useRefEffect)(element => {
    refsMap.set(clientId, element);
    return () => refsMap.delete(clientId);
  }, [clientId]);
}

/**
 * Gets a ref pointing to the current block element. Continues to return the same
 * stable ref object even if the `clientId` argument changes. This hook is not
 * reactive, i.e., it won't trigger a rerender of the calling component if the
 * ref value changes. For reactive use cases there is the `useBlockElement` hook.
 *
 * @param {string} clientId The client ID to get a ref for.
 *
 * @return {RefObject} A ref containing the element.
 */
function useBlockRef(clientId) {
  const {
    refsMap
  } = (0,external_wp_element_namespaceObject.useContext)(BlockRefs);
  const latestClientId = (0,external_wp_element_namespaceObject.useRef)();
  latestClientId.current = clientId;

  // Always return an object, even if no ref exists for a given client ID, so
  // that `current` works at a later point.
  return (0,external_wp_element_namespaceObject.useMemo)(() => ({
    get current() {
      var _refsMap$get;
      return (_refsMap$get = refsMap.get(latestClientId.current)) !== null && _refsMap$get !== void 0 ? _refsMap$get : null;
    }
  }), [refsMap]);
}

/**
 * Return the element for a given client ID. Updates whenever the element
 * changes, becomes available, or disappears.
 *
 * @param {string} clientId The client ID to an element for.
 *
 * @return {Element|null} The block's wrapper element.
 */
function useBlockElement(clientId) {
  var _useObservableValue;
  const {
    refsMap
  } = (0,external_wp_element_namespaceObject.useContext)(BlockRefs);
  return (_useObservableValue = (0,external_wp_compose_namespaceObject.useObservableValue)(refsMap, clientId)) !== null && _useObservableValue !== void 0 ? _useObservableValue : null;
}



;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-popover/use-popover-scroll.js
/**
 * WordPress dependencies
 */


/**
 * Allow scrolling "through" popovers over the canvas. This is only called for
 * as long as the pointer is over a popover. Do not use React events because it
 * will bubble through portals.
 *
 * @param {Object} scrollableRef
 */
function usePopoverScroll(scrollableRef) {
  return (0,external_wp_compose_namespaceObject.useRefEffect)(node => {
    if (!scrollableRef) {
      return;
    }
    function onWheel(event) {
      const {
        deltaX,
        deltaY
      } = event;
      scrollableRef.current.scrollBy(deltaX, deltaY);
    }
    // Tell the browser that we do not call event.preventDefault
    // See https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener#improving_scrolling_performance_with_passive_listeners
    const options = {
      passive: true
    };
    node.addEventListener('wheel', onWheel, options);
    return () => {
      node.removeEventListener('wheel', onWheel, options);
    };
  }, [scrollableRef]);
}
/* harmony default export */ const use_popover_scroll = (usePopoverScroll);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-popover/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



const MAX_POPOVER_RECOMPUTE_COUNTER = Number.MAX_SAFE_INTEGER;
function BlockPopover({
  clientId,
  bottomClientId,
  children,
  __unstablePopoverSlot,
  __unstableContentRef,
  shift = true,
  ...props
}, ref) {
  const selectedElement = useBlockElement(clientId);
  const lastSelectedElement = useBlockElement(bottomClientId !== null && bottomClientId !== void 0 ? bottomClientId : clientId);
  const mergedRefs = (0,external_wp_compose_namespaceObject.useMergeRefs)([ref, use_popover_scroll(__unstableContentRef)]);
  const [popoverDimensionsRecomputeCounter, forceRecomputePopoverDimensions] = (0,external_wp_element_namespaceObject.useReducer)(
  // Module is there to make sure that the counter doesn't overflow.
  s => (s + 1) % MAX_POPOVER_RECOMPUTE_COUNTER, 0);

  // When blocks are moved up/down, they are animated to their new position by
  // updating the `transform` property manually (i.e. without using CSS
  // transitions or animations). The animation, which can also scroll the block
  // editor, can sometimes cause the position of the Popover to get out of sync.
  // A MutationObserver is therefore used to make sure that changes to the
  // selectedElement's attribute (i.e. `transform`) can be tracked and used to
  // trigger the Popover to rerender.
  (0,external_wp_element_namespaceObject.useLayoutEffect)(() => {
    if (!selectedElement) {
      return;
    }
    const observer = new window.MutationObserver(forceRecomputePopoverDimensions);
    observer.observe(selectedElement, {
      attributes: true
    });
    return () => {
      observer.disconnect();
    };
  }, [selectedElement]);
  const popoverAnchor = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (
    // popoverDimensionsRecomputeCounter is by definition always equal or greater
    // than 0. This check is only there to satisfy the correctness of the
    // exhaustive-deps rule for the `useMemo` hook.
    popoverDimensionsRecomputeCounter < 0 || !selectedElement || bottomClientId && !lastSelectedElement) {
      return undefined;
    }
    return {
      getBoundingClientRect() {
        var _lastSelectedBCR$left, _lastSelectedBCR$top, _lastSelectedBCR$righ, _lastSelectedBCR$bott;
        const selectedBCR = selectedElement.getBoundingClientRect();
        const lastSelectedBCR = lastSelectedElement?.getBoundingClientRect();

        // Get the biggest rectangle that encompasses completely the currently
        // selected element and the last selected element:
        // - for top/left coordinates, use the smaller numbers
        // - for the bottom/right coordinates, use the largest numbers
        const left = Math.min(selectedBCR.left, (_lastSelectedBCR$left = lastSelectedBCR?.left) !== null && _lastSelectedBCR$left !== void 0 ? _lastSelectedBCR$left : Infinity);
        const top = Math.min(selectedBCR.top, (_lastSelectedBCR$top = lastSelectedBCR?.top) !== null && _lastSelectedBCR$top !== void 0 ? _lastSelectedBCR$top : Infinity);
        const right = Math.max(selectedBCR.right, (_lastSelectedBCR$righ = lastSelectedBCR.right) !== null && _lastSelectedBCR$righ !== void 0 ? _lastSelectedBCR$righ : -Infinity);
        const bottom = Math.max(selectedBCR.bottom, (_lastSelectedBCR$bott = lastSelectedBCR.bottom) !== null && _lastSelectedBCR$bott !== void 0 ? _lastSelectedBCR$bott : -Infinity);
        const width = right - left;
        const height = bottom - top;
        return new window.DOMRect(left, top, width, height);
      },
      contextElement: selectedElement
    };
  }, [bottomClientId, lastSelectedElement, selectedElement, popoverDimensionsRecomputeCounter]);
  if (!selectedElement || bottomClientId && !lastSelectedElement) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Popover, {
    ref: mergedRefs,
    animate: false,
    focusOnMount: false,
    anchor: popoverAnchor
    // Render in the old slot if needed for backward compatibility,
    // otherwise render in place (not in the default popover slot).
    ,
    __unstableSlotName: __unstablePopoverSlot,
    inline: !__unstablePopoverSlot,
    placement: "top-start",
    resize: false,
    flip: false,
    shift: shift,
    ...props,
    className: dist_clsx('block-editor-block-popover', props.className),
    variant: "unstyled",
    children: children
  });
}
const PrivateBlockPopover = (0,external_wp_element_namespaceObject.forwardRef)(BlockPopover);
const PublicBlockPopover = ({
  clientId,
  bottomClientId,
  children,
  ...props
}, ref) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PrivateBlockPopover, {
  ...props,
  bottomClientId: bottomClientId,
  clientId: clientId,
  __unstableContentRef: undefined,
  __unstablePopoverSlot: undefined,
  ref: ref,
  children: children
});

/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/block-popover/README.md
 */
/* harmony default export */ const block_popover = ((0,external_wp_element_namespaceObject.forwardRef)(PublicBlockPopover));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-popover/cover.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function BlockPopoverCover({
  clientId,
  bottomClientId,
  children,
  shift = false,
  additionalStyles,
  ...props
}, ref) {
  var _bottomClientId;
  (_bottomClientId = bottomClientId) !== null && _bottomClientId !== void 0 ? _bottomClientId : bottomClientId = clientId;
  const selectedElement = useBlockElement(clientId);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(PrivateBlockPopover, {
    ref: ref,
    clientId: clientId,
    bottomClientId: bottomClientId,
    shift: shift,
    ...props,
    children: selectedElement && clientId === bottomClientId ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(CoverContainer, {
      selectedElement: selectedElement,
      additionalStyles: additionalStyles,
      children: children
    }) : children
  });
}
function CoverContainer({
  selectedElement,
  additionalStyles = {},
  children
}) {
  const [width, setWidth] = (0,external_wp_element_namespaceObject.useState)(selectedElement.offsetWidth);
  const [height, setHeight] = (0,external_wp_element_namespaceObject.useState)(selectedElement.offsetHeight);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const observer = new window.ResizeObserver(() => {
      setWidth(selectedElement.offsetWidth);
      setHeight(selectedElement.offsetHeight);
    });
    observer.observe(selectedElement, {
      box: 'border-box'
    });
    return () => observer.disconnect();
  }, [selectedElement]);
  const style = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return {
      position: 'absolute',
      width,
      height,
      ...additionalStyles
    };
  }, [width, height, additionalStyles]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
    style: style,
    children: children
  });
}
/* harmony default export */ const cover = ((0,external_wp_element_namespaceObject.forwardRef)(BlockPopoverCover));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/grid-visualizer/utils.js
function getComputedCSS(element, property) {
  return element.ownerDocument.defaultView.getComputedStyle(element).getPropertyValue(property);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/grid-visualizer/grid-visualizer.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





function GridVisualizer({
  clientId,
  contentRef
}) {
  const isDistractionFree = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).getSettings().isDistractionFree, []);
  const blockElement = useBlockElement(clientId);
  if (isDistractionFree || !blockElement) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(cover, {
    className: "block-editor-grid-visualizer",
    clientId: clientId,
    __unstablePopoverSlot: "block-toolbar",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(GridVisualizerGrid, {
      ref: contentRef,
      blockElement: blockElement
    })
  });
}
const GridVisualizerGrid = (0,external_wp_element_namespaceObject.forwardRef)(({
  blockElement
}, ref) => {
  const [gridInfo, setGridInfo] = (0,external_wp_element_namespaceObject.useState)(() => getGridInfo(blockElement));
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    const observers = [];
    for (const element of [blockElement, ...blockElement.children]) {
      const observer = new window.ResizeObserver(() => {
        setGridInfo(getGridInfo(blockElement));
      });
      observer.observe(element);
      observers.push(observer);
    }
    return () => {
      for (const observer of observers) {
        observer.disconnect();
      }
    };
  }, [blockElement]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
    ref: ref,
    className: "block-editor-grid-visualizer__grid",
    style: gridInfo.style,
    children: Array.from({
      length: gridInfo.numItems
    }, (_, i) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: "block-editor-grid-visualizer__item",
      style: {
        boxShadow: `inset 0 0 0 1px color-mix(in srgb, ${gridInfo.currentColor} 20%, #0000)`
      }
    }, i))
  });
});
function getGridInfo(blockElement) {
  const gridTemplateColumns = getComputedCSS(blockElement, 'grid-template-columns');
  const gridTemplateRows = getComputedCSS(blockElement, 'grid-template-rows');
  const numColumns = gridTemplateColumns.split(' ').length;
  const numRows = gridTemplateRows.split(' ').length;
  const numItems = numColumns * numRows;
  return {
    numItems,
    currentColor: getComputedCSS(blockElement, 'color'),
    style: {
      gridTemplateColumns,
      gridTemplateRows,
      gap: getComputedCSS(blockElement, 'gap'),
      padding: getComputedCSS(blockElement, 'padding')
    }
  };
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/grid.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */








const RANGE_CONTROL_MAX_VALUES = {
  px: 600,
  '%': 100,
  vw: 100,
  vh: 100,
  em: 38,
  rem: 38,
  svw: 100,
  lvw: 100,
  dvw: 100,
  svh: 100,
  lvh: 100,
  dvh: 100,
  vi: 100,
  svi: 100,
  lvi: 100,
  dvi: 100,
  vb: 100,
  svb: 100,
  lvb: 100,
  dvb: 100,
  vmin: 100,
  svmin: 100,
  lvmin: 100,
  dvmin: 100,
  vmax: 100,
  svmax: 100,
  lvmax: 100,
  dvmax: 100
};
const units = [{
  value: 'px',
  label: 'px',
  default: 0
}, {
  value: 'rem',
  label: 'rem',
  default: 0
}, {
  value: 'em',
  label: 'em',
  default: 0
}];
/* harmony default export */ const grid = ({
  name: 'grid',
  label: (0,external_wp_i18n_namespaceObject.__)('Grid'),
  inspectorControls: function GridLayoutInspectorControls({
    layout = {},
    onChange,
    layoutBlockSupport = {}
  }) {
    const {
      allowSizingOnChildren = false
    } = layoutBlockSupport;
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(GridLayoutTypeControl, {
        layout: layout,
        onChange: onChange
      }), layout?.columnCount ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(GridLayoutColumnsAndRowsControl, {
        layout: layout,
        onChange: onChange,
        allowSizingOnChildren: allowSizingOnChildren
      }) : /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(GridLayoutMinimumWidthControl, {
        layout: layout,
        onChange: onChange
      })]
    });
  },
  toolBarControls: function GridLayoutToolbarControls({
    clientId
  }) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(GridVisualizer, {
      clientId: clientId
    });
  },
  getLayoutStyle: function getLayoutStyle({
    selector,
    layout,
    style,
    blockName,
    hasBlockGapSupport,
    layoutDefinitions = LAYOUT_DEFINITIONS
  }) {
    const {
      minimumColumnWidth = '12rem',
      columnCount = null,
      rowCount = null
    } = layout;

    // If a block's block.json skips serialization for spacing or spacing.blockGap,
    // don't apply the user-defined value to the styles.
    const blockGapValue = style?.spacing?.blockGap && !shouldSkipSerialization(blockName, 'spacing', 'blockGap') ? getGapCSSValue(style?.spacing?.blockGap, '0.5em') : undefined;
    let output = '';
    const rules = [];
    if (columnCount) {
      rules.push(`grid-template-columns: repeat(${columnCount}, minmax(0, 1fr))`);
      if (rowCount) {
        rules.push(`grid-template-rows: repeat(${rowCount}, minmax(0, 1fr))`);
      }
    } else if (minimumColumnWidth) {
      rules.push(`grid-template-columns: repeat(auto-fill, minmax(min(${minimumColumnWidth}, 100%), 1fr))`, 'container-type: inline-size');
    }
    if (rules.length) {
      // Reason to disable: the extra line breaks added by prettier mess with the unit tests.
      // eslint-disable-next-line prettier/prettier
      output = `${appendSelectors(selector)} { ${rules.join('; ')}; }`;
    }

    // Output blockGap styles based on rules contained in layout definitions in theme.json.
    if (hasBlockGapSupport && blockGapValue) {
      output += getBlockGapCSS(selector, layoutDefinitions, 'grid', blockGapValue);
    }
    return output;
  },
  getOrientation() {
    return 'horizontal';
  },
  getAlignments() {
    return [];
  }
});

// Enables setting minimum width of grid items.
function GridLayoutMinimumWidthControl({
  layout,
  onChange
}) {
  const {
    minimumColumnWidth: value = '12rem'
  } = layout;
  const [quantity, unit] = (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(value);
  const handleSliderChange = next => {
    onChange({
      ...layout,
      minimumColumnWidth: [next, unit].join('')
    });
  };

  // Mostly copied from HeightControl.
  const handleUnitChange = newUnit => {
    // Attempt to smooth over differences between currentUnit and newUnit.
    // This should slightly improve the experience of switching between unit types.
    let newValue;
    if (['em', 'rem'].includes(newUnit) && unit === 'px') {
      // Convert pixel value to an approximate of the new unit, assuming a root size of 16px.
      newValue = (quantity / 16).toFixed(2) + newUnit;
    } else if (['em', 'rem'].includes(unit) && newUnit === 'px') {
      // Convert to pixel value assuming a root size of 16px.
      newValue = Math.round(quantity * 16) + newUnit;
    }
    onChange({
      ...layout,
      minimumColumnWidth: newValue
    });
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, {
      as: "legend",
      children: (0,external_wp_i18n_namespaceObject.__)('Minimum column width')
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Flex, {
      gap: 4,
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, {
        isBlock: true,
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalUnitControl, {
          size: "__unstable-large",
          onChange: newValue => {
            onChange({
              ...layout,
              minimumColumnWidth: newValue
            });
          },
          onUnitChange: handleUnitChange,
          value: value,
          units: units,
          min: 0,
          label: (0,external_wp_i18n_namespaceObject.__)('Minimum column width'),
          hideLabelFromVision: true
        })
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, {
        isBlock: true,
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.RangeControl, {
          onChange: handleSliderChange,
          value: quantity,
          min: 0,
          max: RANGE_CONTROL_MAX_VALUES[unit] || 600,
          withInputField: false,
          label: (0,external_wp_i18n_namespaceObject.__)('Minimum column width'),
          hideLabelFromVision: true
        })
      })]
    })]
  });
}

// Enables setting number of grid columns
function GridLayoutColumnsAndRowsControl({
  layout,
  onChange,
  allowSizingOnChildren
}) {
  const {
    columnCount = 3,
    rowCount
  } = layout;
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", {
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, {
        as: "legend",
        children: (0,external_wp_i18n_namespaceObject.__)('Columns')
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Flex, {
        gap: 4,
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, {
          isBlock: true,
          children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalNumberControl, {
            size: "__unstable-large",
            onChange: value => {
              /**
               * If the input is cleared, avoid switching
               * back to "Auto" by setting a value of "1".
               */
              const validValue = value !== '' ? value : '1';
              onChange({
                ...layout,
                columnCount: validValue
              });
            },
            value: columnCount,
            min: 1,
            label: (0,external_wp_i18n_namespaceObject.__)('Columns'),
            hideLabelFromVision: true
          })
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, {
          isBlock: true,
          children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.RangeControl, {
            value: parseInt(columnCount, 10) // RangeControl can't deal with strings.
            ,
            onChange: value => onChange({
              ...layout,
              columnCount: value
            }),
            min: 1,
            max: 16,
            withInputField: false,
            label: (0,external_wp_i18n_namespaceObject.__)('Columns'),
            hideLabelFromVision: true
          })
        })]
      })]
    }), allowSizingOnChildren && window.__experimentalEnableGridInteractivity && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", {
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, {
        as: "legend",
        children: (0,external_wp_i18n_namespaceObject.__)('Rows')
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.Flex, {
        gap: 4,
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, {
          isBlock: true,
          children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalNumberControl, {
            size: "__unstable-large",
            onChange: value => {
              onChange({
                ...layout,
                rowCount: value
              });
            },
            value: rowCount,
            min: 1,
            label: (0,external_wp_i18n_namespaceObject.__)('Rows'),
            hideLabelFromVision: true
          })
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, {
          isBlock: true,
          children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.RangeControl, {
            value: parseInt(rowCount, 10) // RangeControl can't deal with strings.
            ,
            onChange: value => onChange({
              ...layout,
              rowCount: value
            }),
            min: 1,
            max: 16,
            withInputField: false,
            label: (0,external_wp_i18n_namespaceObject.__)('Rows'),
            hideLabelFromVision: true
          })
        })]
      })]
    })]
  });
}

// Enables switching between grid types
function GridLayoutTypeControl({
  layout,
  onChange
}) {
  const {
    columnCount,
    minimumColumnWidth
  } = layout;

  /**
   * When switching, temporarily save any custom values set on the
   * previous type so we can switch back without loss.
   */
  const [tempColumnCount, setTempColumnCount] = (0,external_wp_element_namespaceObject.useState)(columnCount || 3);
  const [tempMinimumColumnWidth, setTempMinimumColumnWidth] = (0,external_wp_element_namespaceObject.useState)(minimumColumnWidth || '12rem');
  const isManual = !!columnCount ? 'manual' : 'auto';
  const onChangeType = value => {
    if (value === 'manual') {
      setTempMinimumColumnWidth(minimumColumnWidth || '12rem');
    } else {
      setTempColumnCount(columnCount || 3);
    }
    onChange({
      ...layout,
      columnCount: value === 'manual' ? tempColumnCount : null,
      minimumColumnWidth: value === 'auto' ? tempMinimumColumnWidth : null
    });
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalToggleGroupControl, {
    __nextHasNoMarginBottom: true,
    label: (0,external_wp_i18n_namespaceObject.__)('Type'),
    value: isManual,
    onChange: onChangeType,
    isBlock: true,
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOption, {
      value: "auto",
      label: (0,external_wp_i18n_namespaceObject.__)('Auto')
    }, "auto"), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOption, {
      value: "manual",
      label: (0,external_wp_i18n_namespaceObject.__)('Manual')
    }, "manual")]
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/index.js
/**
 * Internal dependencies
 */




const layoutTypes = [flow, flex, constrained, grid];

/**
 * Retrieves a layout type by name.
 *
 * @param {string} name - The name of the layout type.
 * @return {Object} Layout type.
 */
function getLayoutType(name = 'default') {
  return layoutTypes.find(layoutType => layoutType.name === name);
}

/**
 * Retrieves the available layout types.
 *
 * @return {Array} Layout types.
 */
function getLayoutTypes() {
  return layoutTypes;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list/layout.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



const defaultLayout = {
  type: 'default'
};
const Layout = (0,external_wp_element_namespaceObject.createContext)(defaultLayout);

/**
 * Allows to define the layout.
 */
const LayoutProvider = Layout.Provider;

/**
 * React hook used to retrieve the layout config.
 */
function useLayout() {
  return (0,external_wp_element_namespaceObject.useContext)(Layout);
}
function LayoutStyle({
  layout = {},
  css,
  ...props
}) {
  const layoutType = getLayoutType(layout.type);
  const [blockGapSupport] = use_settings_useSettings('spacing.blockGap');
  const hasBlockGapSupport = blockGapSupport !== null;
  if (layoutType) {
    if (css) {
      return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("style", {
        children: css
      });
    }
    const layoutStyle = layoutType.getLayoutStyle?.({
      hasBlockGapSupport,
      layout,
      ...props
    });
    if (layoutStyle) {
      return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("style", {
        children: layoutStyle
      });
    }
  }
  return null;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-alignment-control/use-available-alignments.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



const use_available_alignments_EMPTY_ARRAY = [];
const use_available_alignments_DEFAULT_CONTROLS = ['none', 'left', 'center', 'right', 'wide', 'full'];
const WIDE_CONTROLS = ['wide', 'full'];
function useAvailableAlignments(controls = use_available_alignments_DEFAULT_CONTROLS) {
  // Always add the `none` option if not exists.
  if (!controls.includes('none')) {
    controls = ['none', ...controls];
  }
  const isNoneOnly = controls.length === 1 && controls[0] === 'none';
  const [wideControlsEnabled, themeSupportsLayout, isBlockBasedTheme] = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _settings$alignWide;
    // If `isNoneOnly` is true, we'll be returning early because there is
    // nothing to filter on an empty array. We won't need the info from
    // the `useSelect` but we must call it anyway because Rules of Hooks.
    // So the callback returns early to avoid block editor subscription.
    if (isNoneOnly) {
      return [false, false, false];
    }
    const settings = select(store).getSettings();
    return [(_settings$alignWide = settings.alignWide) !== null && _settings$alignWide !== void 0 ? _settings$alignWide : false, settings.supportsLayout, settings.__unstableIsBlockBasedTheme];
  }, [isNoneOnly]);
  const layout = useLayout();
  if (isNoneOnly) {
    return use_available_alignments_EMPTY_ARRAY;
  }
  const layoutType = getLayoutType(layout?.type);
  if (themeSupportsLayout) {
    const layoutAlignments = layoutType.getAlignments(layout, isBlockBasedTheme);
    const alignments = layoutAlignments.filter(alignment => controls.includes(alignment.name));
    // While we treat `none` as an alignment, we shouldn't return it if no
    // other alignments exist.
    if (alignments.length === 1 && alignments[0].name === 'none') {
      return use_available_alignments_EMPTY_ARRAY;
    }
    return alignments;
  }

  // Starting here, it's the fallback for themes not supporting the layout config.
  if (layoutType.name !== 'default' && layoutType.name !== 'constrained') {
    return use_available_alignments_EMPTY_ARRAY;
  }
  const alignments = controls.filter(control => {
    if (layout.alignments) {
      return layout.alignments.includes(control);
    }
    if (!wideControlsEnabled && WIDE_CONTROLS.includes(control)) {
      return false;
    }
    return use_available_alignments_DEFAULT_CONTROLS.includes(control);
  }).map(name => ({
    name
  }));

  // While we treat `none` as an alignment, we shouldn't return it if no
  // other alignments exist.
  if (alignments.length === 1 && alignments[0].name === 'none') {
    return use_available_alignments_EMPTY_ARRAY;
  }
  return alignments;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/align-none.js
/**
 * WordPress dependencies
 */


const alignNone = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M19 5.5H5V4h14v1.5ZM19 20H5v-1.5h14V20ZM5 9h14v6H5V9Z"
  })
});
/* harmony default export */ const align_none = (alignNone);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/position-left.js
/**
 * WordPress dependencies
 */


const positionLeft = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M5 5.5h8V4H5v1.5ZM5 20h8v-1.5H5V20ZM19 9H5v6h14V9Z"
  })
});
/* harmony default export */ const position_left = (positionLeft);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/position-right.js
/**
 * WordPress dependencies
 */


const positionRight = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M19 5.5h-8V4h8v1.5ZM19 20h-8v-1.5h8V20ZM5 9h14v6H5V9Z"
  })
});
/* harmony default export */ const position_right = (positionRight);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/stretch-full-width.js
/**
 * WordPress dependencies
 */


const stretchFullWidth = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M5 4h14v11H5V4Zm11 16H8v-1.5h8V20Z"
  })
});
/* harmony default export */ const stretch_full_width = (stretchFullWidth);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-alignment-control/constants.js
/**
 * WordPress dependencies
 */


const constants_BLOCK_ALIGNMENTS_CONTROLS = {
  none: {
    icon: align_none,
    title: (0,external_wp_i18n_namespaceObject._x)('None', 'Alignment option')
  },
  left: {
    icon: position_left,
    title: (0,external_wp_i18n_namespaceObject.__)('Align left')
  },
  center: {
    icon: position_center,
    title: (0,external_wp_i18n_namespaceObject.__)('Align center')
  },
  right: {
    icon: position_right,
    title: (0,external_wp_i18n_namespaceObject.__)('Align right')
  },
  wide: {
    icon: stretch_wide,
    title: (0,external_wp_i18n_namespaceObject.__)('Wide width')
  },
  full: {
    icon: stretch_full_width,
    title: (0,external_wp_i18n_namespaceObject.__)('Full width')
  }
};
const constants_DEFAULT_CONTROL = 'none';

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-alignment-control/ui.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function BlockAlignmentUI({
  value,
  onChange,
  controls,
  isToolbar,
  isCollapsed = true
}) {
  const enabledControls = useAvailableAlignments(controls);
  const hasEnabledControls = !!enabledControls.length;
  if (!hasEnabledControls) {
    return null;
  }
  function onChangeAlignment(align) {
    onChange([value, 'none'].includes(align) ? undefined : align);
  }
  const activeAlignmentControl = constants_BLOCK_ALIGNMENTS_CONTROLS[value];
  const defaultAlignmentControl = constants_BLOCK_ALIGNMENTS_CONTROLS[constants_DEFAULT_CONTROL];
  const UIComponent = isToolbar ? external_wp_components_namespaceObject.ToolbarGroup : external_wp_components_namespaceObject.ToolbarDropdownMenu;
  const commonProps = {
    icon: activeAlignmentControl ? activeAlignmentControl.icon : defaultAlignmentControl.icon,
    label: (0,external_wp_i18n_namespaceObject.__)('Align')
  };
  const extraProps = isToolbar ? {
    isCollapsed,
    controls: enabledControls.map(({
      name: controlName
    }) => {
      return {
        ...constants_BLOCK_ALIGNMENTS_CONTROLS[controlName],
        isActive: value === controlName || !value && controlName === 'none',
        role: isCollapsed ? 'menuitemradio' : undefined,
        onClick: () => onChangeAlignment(controlName)
      };
    })
  } : {
    toggleProps: {
      describedBy: (0,external_wp_i18n_namespaceObject.__)('Change alignment')
    },
    children: ({
      onClose
    }) => {
      return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_ReactJSXRuntime_namespaceObject.Fragment, {
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuGroup, {
          className: "block-editor-block-alignment-control__menu-group",
          children: enabledControls.map(({
            name: controlName,
            info
          }) => {
            const {
              icon,
              title
            } = constants_BLOCK_ALIGNMENTS_CONTROLS[controlName];
            // If no value is provided, mark as selected the `none` option.
            const isSelected = controlName === value || !value && controlName === 'none';
            return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
              icon: icon,
              iconPosition: "left",
              className: dist_clsx('components-dropdown-menu__menu-item', {
                'is-active': isSelected
              }),
              isSelected: isSelected,
              onClick: () => {
                onChangeAlignment(controlName);
                onClose();
              },
              role: "menuitemradio",
              info: info,
              children: title
            }, controlName);
          })
        })
      });
    }
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(UIComponent, {
    ...commonProps,
    ...extraProps
  });
}
/* harmony default export */ const block_alignment_control_ui = (BlockAlignmentUI);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-alignment-control/index.js
/**
 * Internal dependencies
 */


const BlockAlignmentControl = props => {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(block_alignment_control_ui, {
    ...props,
    isToolbar: false
  });
};
const BlockAlignmentToolbar = props => {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(block_alignment_control_ui, {
    ...props,
    isToolbar: true
  });
};

/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/block-alignment-control/README.md
 */


;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-editing-mode/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



/**
 * @typedef {'disabled'|'contentOnly'|'default'} BlockEditingMode
 */

/**
 * Allows a block to restrict the user interface that is displayed for editing
 * that block and its inner blocks.
 *
 * @example
 * ```js
 * function MyBlock( { attributes, setAttributes } ) {
 *     useBlockEditingMode( 'disabled' );
 *     return <div { ...useBlockProps() }></div>;
 * }
 * ```
 *
 * `mode` can be one of three options:
 *
 * - `'disabled'`: Prevents editing the block entirely, i.e. it cannot be
 *   selected.
 * - `'contentOnly'`: Hides all non-content UI, e.g. auxiliary controls in the
 *   toolbar, the block movers, block settings.
 * - `'default'`: Allows editing the block as normal.
 *
 * The mode is inherited by all of the block's inner blocks, unless they have
 * their own mode.
 *
 * If called outside of a block context, the mode is applied to all blocks.
 *
 * @param {?BlockEditingMode} mode The editing mode to apply. If undefined, the
 *                                 current editing mode is not changed.
 *
 * @return {BlockEditingMode} The current editing mode.
 */
function useBlockEditingMode(mode) {
  const context = useBlockEditContext();
  const {
    clientId = ''
  } = context;
  const {
    setBlockEditingMode,
    unsetBlockEditingMode
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const globalBlockEditingMode = (0,external_wp_data_namespaceObject.useSelect)(select =>
  // Avoid adding the subscription if not needed!
  clientId ? null : select(store).getBlockEditingMode(), [clientId]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (mode) {
      setBlockEditingMode(clientId, mode);
    }
    return () => {
      if (mode) {
        unsetBlockEditingMode(clientId);
      }
    };
  }, [clientId, mode, setBlockEditingMode, unsetBlockEditingMode]);
  return clientId ? context[blockEditingModeKey] : globalBlockEditingMode;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/align.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




/**
 * An array which includes all possible valid alignments,
 * used to validate if an alignment is valid or not.
 *
 * @constant
 * @type {string[]}
 */

const ALL_ALIGNMENTS = ['left', 'center', 'right', 'wide', 'full'];

/**
 * An array which includes all wide alignments.
 * In order for this alignments to be valid they need to be supported by the block,
 * and by the theme.
 *
 * @constant
 * @type {string[]}
 */
const WIDE_ALIGNMENTS = ['wide', 'full'];

/**
 * Returns the valid alignments.
 * Takes into consideration the aligns supported by a block, if the block supports wide controls or not and if theme supports wide controls or not.
 * Exported just for testing purposes, not exported outside the module.
 *
 * @param {?boolean|string[]} blockAlign          Aligns supported by the block.
 * @param {?boolean}          hasWideBlockSupport True if block supports wide alignments. And False otherwise.
 * @param {?boolean}          hasWideEnabled      True if theme supports wide alignments. And False otherwise.
 *
 * @return {string[]} Valid alignments.
 */
function getValidAlignments(blockAlign, hasWideBlockSupport = true, hasWideEnabled = true) {
  let validAlignments;
  if (Array.isArray(blockAlign)) {
    validAlignments = ALL_ALIGNMENTS.filter(value => blockAlign.includes(value));
  } else if (blockAlign === true) {
    // `true` includes all alignments...
    validAlignments = [...ALL_ALIGNMENTS];
  } else {
    validAlignments = [];
  }
  if (!hasWideEnabled || blockAlign === true && !hasWideBlockSupport) {
    return validAlignments.filter(alignment => !WIDE_ALIGNMENTS.includes(alignment));
  }
  return validAlignments;
}

/**
 * Filters registered block settings, extending attributes to include `align`.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */
function addAttribute(settings) {
  var _settings$attributes$;
  // Allow blocks to specify their own attribute definition with default values if needed.
  if ('type' in ((_settings$attributes$ = settings.attributes?.align) !== null && _settings$attributes$ !== void 0 ? _settings$attributes$ : {})) {
    return settings;
  }
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, 'align')) {
    // Gracefully handle if settings.attributes is undefined.
    settings.attributes = {
      ...settings.attributes,
      align: {
        type: 'string',
        // Allow for '' since it is used by the `updateAlignment` function
        // in toolbar controls for special cases with defined default values.
        enum: [...ALL_ALIGNMENTS, '']
      }
    };
  }
  return settings;
}
function BlockEditAlignmentToolbarControlsPure({
  name: blockName,
  align,
  setAttributes
}) {
  // Compute the block valid alignments by taking into account,
  // if the theme supports wide alignments or not and the layout's
  // available alignments. We do that for conditionally rendering
  // Slot.
  const blockAllowedAlignments = getValidAlignments((0,external_wp_blocks_namespaceObject.getBlockSupport)(blockName, 'align'), (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockName, 'alignWide', true));
  const validAlignments = useAvailableAlignments(blockAllowedAlignments).map(({
    name
  }) => name);
  const blockEditingMode = useBlockEditingMode();
  if (!validAlignments.length || blockEditingMode !== 'default') {
    return null;
  }
  const updateAlignment = nextAlign => {
    if (!nextAlign) {
      const blockType = (0,external_wp_blocks_namespaceObject.getBlockType)(blockName);
      const blockDefaultAlign = blockType?.attributes?.align?.default;
      if (blockDefaultAlign) {
        nextAlign = '';
      }
    }
    setAttributes({
      align: nextAlign
    });
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(block_controls, {
    group: "block",
    __experimentalShareWithChildBlocks: true,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockAlignmentControl, {
      value: align,
      onChange: updateAlignment,
      controls: validAlignments
    })
  });
}
/* harmony default export */ const align = ({
  shareWithChildBlocks: true,
  edit: BlockEditAlignmentToolbarControlsPure,
  useBlockProps,
  addSaveProps: addAssignedAlign,
  attributeKeys: ['align'],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, 'align', false);
  }
});
function useBlockProps({
  name,
  align
}) {
  const blockAllowedAlignments = getValidAlignments((0,external_wp_blocks_namespaceObject.getBlockSupport)(name, 'align'), (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, 'alignWide', true));
  const validAlignments = useAvailableAlignments(blockAllowedAlignments);
  if (validAlignments.some(alignment => alignment.name === align)) {
    return {
      'data-align': align
    };
  }
  return {};
}

/**
 * Override props assigned to save component to inject alignment class name if
 * block supports it.
 *
 * @param {Object} props      Additional props applied to save element.
 * @param {Object} blockType  Block type.
 * @param {Object} attributes Block attributes.
 *
 * @return {Object} Filtered props applied to save element.
 */
function addAssignedAlign(props, blockType, attributes) {
  const {
    align
  } = attributes;
  const blockAlign = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, 'align');
  const hasWideBlockSupport = (0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'alignWide', true);

  // Compute valid alignments without taking into account if
  // the theme supports wide alignments or not.
  // This way changing themes does not impact the block save.
  const isAlignValid = getValidAlignments(blockAlign, hasWideBlockSupport).includes(align);
  if (isAlignValid) {
    props.className = dist_clsx(`align${align}`, props.className);
  }
  return props;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/editor/align/addAttribute', addAttribute);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/groups.js
/**
 * WordPress dependencies
 */

const InspectorControlsDefault = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControls');
const InspectorControlsAdvanced = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorAdvancedControls');
const InspectorControlsBackground = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsBackground');
const InspectorControlsBorder = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsBorder');
const InspectorControlsColor = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsColor');
const InspectorControlsFilter = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsFilter');
const InspectorControlsDimensions = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsDimensions');
const InspectorControlsPosition = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsPosition');
const InspectorControlsTypography = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsTypography');
const InspectorControlsListView = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsListView');
const InspectorControlsStyles = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsStyles');
const InspectorControlsEffects = (0,external_wp_components_namespaceObject.createSlotFill)('InspectorControlsEffects');
const groups_groups = {
  default: InspectorControlsDefault,
  advanced: InspectorControlsAdvanced,
  background: InspectorControlsBackground,
  border: InspectorControlsBorder,
  color: InspectorControlsColor,
  dimensions: InspectorControlsDimensions,
  effects: InspectorControlsEffects,
  filter: InspectorControlsFilter,
  list: InspectorControlsListView,
  position: InspectorControlsPosition,
  settings: InspectorControlsDefault,
  // Alias for default.
  styles: InspectorControlsStyles,
  typography: InspectorControlsTypography
};
/* harmony default export */ const inspector_controls_groups = (groups_groups);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/fill.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



function InspectorControlsFill({
  children,
  group = 'default',
  __experimentalGroup,
  resetAllFilter
}) {
  if (__experimentalGroup) {
    external_wp_deprecated_default()('`__experimentalGroup` property in `InspectorControlsFill`', {
      since: '6.2',
      version: '6.4',
      alternative: '`group`'
    });
    group = __experimentalGroup;
  }
  const context = useBlockEditContext();
  const Fill = inspector_controls_groups[group]?.Fill;
  if (!Fill) {
     true ? external_wp_warning_default()(`Unknown InspectorControls group "${group}" provided.`) : 0;
    return null;
  }
  if (!context[mayDisplayControlsKey]) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalStyleProvider, {
    document: document,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Fill, {
      children: fillProps => {
        return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ToolsPanelInspectorControl, {
          fillProps: fillProps,
          children: children,
          resetAllFilter: resetAllFilter
        });
      }
    })
  });
}
function RegisterResetAll({
  resetAllFilter,
  children
}) {
  const {
    registerResetAllFilter,
    deregisterResetAllFilter
  } = (0,external_wp_element_namespaceObject.useContext)(external_wp_components_namespaceObject.__experimentalToolsPanelContext);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (resetAllFilter && registerResetAllFilter && deregisterResetAllFilter) {
      registerResetAllFilter(resetAllFilter);
      return () => {
        deregisterResetAllFilter(resetAllFilter);
      };
    }
  }, [resetAllFilter, registerResetAllFilter, deregisterResetAllFilter]);
  return children;
}
function ToolsPanelInspectorControl({
  children,
  resetAllFilter,
  fillProps
}) {
  // `fillProps.forwardedContext` is an array of context provider entries, provided by slot,
  // that should wrap the fill markup.
  const {
    forwardedContext = []
  } = fillProps;

  // Children passed to InspectorControlsFill will not have
  // access to any React Context whose Provider is part of
  // the InspectorControlsSlot tree. So we re-create the
  // Provider in this subtree.
  const innerMarkup = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(RegisterResetAll, {
    resetAllFilter: resetAllFilter,
    children: children
  });
  return forwardedContext.reduce((inner, [Provider, props]) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Provider, {
    ...props,
    children: inner
  }), innerMarkup);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/block-support-tools-panel.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */




function BlockSupportToolsPanel({
  children,
  group,
  label
}) {
  const {
    updateBlockAttributes
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const {
    getBlockAttributes,
    getMultiSelectedBlockClientIds,
    getSelectedBlockClientId,
    hasMultiSelection
  } = (0,external_wp_data_namespaceObject.useSelect)(store);
  const panelId = getSelectedBlockClientId();
  const resetAll = (0,external_wp_element_namespaceObject.useCallback)((resetFilters = []) => {
    const newAttributes = {};
    const clientIds = hasMultiSelection() ? getMultiSelectedBlockClientIds() : [panelId];
    clientIds.forEach(clientId => {
      const {
        style
      } = getBlockAttributes(clientId);
      let newBlockAttributes = {
        style
      };
      resetFilters.forEach(resetFilter => {
        newBlockAttributes = {
          ...newBlockAttributes,
          ...resetFilter(newBlockAttributes)
        };
      });

      // Enforce a cleaned style object.
      newBlockAttributes = {
        ...newBlockAttributes,
        style: utils_cleanEmptyObject(newBlockAttributes.style)
      };
      newAttributes[clientId] = newBlockAttributes;
    });
    updateBlockAttributes(clientIds, newAttributes, true);
  }, [getBlockAttributes, getMultiSelectedBlockClientIds, hasMultiSelection, panelId, updateBlockAttributes]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanel, {
    className: `${group}-block-support-panel`,
    label: label,
    resetAll: resetAll,
    panelId: panelId,
    hasInnerWrapper: true,
    shouldRenderPlaceholderItems: true // Required to maintain fills ordering.
    ,
    __experimentalFirstVisibleItemClass: "first",
    __experimentalLastVisibleItemClass: "last",
    dropdownMenuProps: TOOLSPANEL_DROPDOWNMENU_PROPS,
    children: children
  }, panelId);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/block-support-slot-container.js
/**
 * WordPress dependencies
 */



function BlockSupportSlotContainer({
  Slot,
  fillProps,
  ...props
}) {
  // Add the toolspanel context provider and value to existing fill props
  const toolsPanelContext = (0,external_wp_element_namespaceObject.useContext)(external_wp_components_namespaceObject.__experimentalToolsPanelContext);
  const computedFillProps = (0,external_wp_element_namespaceObject.useMemo)(() => {
    var _fillProps$forwardedC;
    return {
      ...(fillProps !== null && fillProps !== void 0 ? fillProps : {}),
      forwardedContext: [...((_fillProps$forwardedC = fillProps?.forwardedContext) !== null && _fillProps$forwardedC !== void 0 ? _fillProps$forwardedC : []), [external_wp_components_namespaceObject.__experimentalToolsPanelContext.Provider, {
        value: toolsPanelContext
      }]]
    };
  }, [toolsPanelContext, fillProps]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Slot, {
    ...props,
    fillProps: computedFillProps,
    bubblesVirtually: true
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/slot.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */




function InspectorControlsSlot({
  __experimentalGroup,
  group = 'default',
  label,
  fillProps,
  ...props
}) {
  if (__experimentalGroup) {
    external_wp_deprecated_default()('`__experimentalGroup` property in `InspectorControlsSlot`', {
      since: '6.2',
      version: '6.4',
      alternative: '`group`'
    });
    group = __experimentalGroup;
  }
  const Slot = inspector_controls_groups[group]?.Slot;
  const fills = (0,external_wp_components_namespaceObject.__experimentalUseSlotFills)(Slot?.__unstableName);
  const motionContextValue = (0,external_wp_element_namespaceObject.useContext)(external_wp_components_namespaceObject.__unstableMotionContext);
  const computedFillProps = (0,external_wp_element_namespaceObject.useMemo)(() => {
    var _fillProps$forwardedC;
    return {
      ...(fillProps !== null && fillProps !== void 0 ? fillProps : {}),
      forwardedContext: [...((_fillProps$forwardedC = fillProps?.forwardedContext) !== null && _fillProps$forwardedC !== void 0 ? _fillProps$forwardedC : []), [external_wp_components_namespaceObject.__unstableMotionContext.Provider, {
        value: motionContextValue
      }]]
    };
  }, [motionContextValue, fillProps]);
  if (!Slot) {
     true ? external_wp_warning_default()(`Unknown InspectorControls group "${group}" provided.`) : 0;
    return null;
  }
  if (!fills?.length) {
    return null;
  }
  if (label) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockSupportToolsPanel, {
      group: group,
      label: label,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockSupportSlotContainer, {
        ...props,
        fillProps: computedFillProps,
        Slot: Slot
      })
    });
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Slot, {
    ...props,
    fillProps: computedFillProps,
    bubblesVirtually: true
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/index.js
/**
 * Internal dependencies
 */



const InspectorControls = InspectorControlsFill;
InspectorControls.Slot = InspectorControlsSlot;

// This is just here for backward compatibility.
const InspectorAdvancedControls = props => {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(InspectorControlsFill, {
    ...props,
    group: "advanced"
  });
};
InspectorAdvancedControls.Slot = props => {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(InspectorControlsSlot, {
    ...props,
    group: "advanced"
  });
};
InspectorAdvancedControls.slotName = 'InspectorAdvancedControls';

/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/inspector-controls/README.md
 */
/* harmony default export */ const inspector_controls = (InspectorControls);

;// CONCATENATED MODULE: external ["wp","url"]
const external_wp_url_namespaceObject = window["wp"]["url"];
;// CONCATENATED MODULE: external ["wp","dom"]
const external_wp_dom_namespaceObject = window["wp"]["dom"];
;// CONCATENATED MODULE: external ["wp","blob"]
const external_wp_blob_namespaceObject = window["wp"]["blob"];
;// CONCATENATED MODULE: external ["wp","keycodes"]
const external_wp_keycodes_namespaceObject = window["wp"]["keycodes"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/media.js
/**
 * WordPress dependencies
 */



const media = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m7 6.5 4 2.5-4 2.5z"
  }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "m5 3c-1.10457 0-2 .89543-2 2v14c0 1.1046.89543 2 2 2h14c1.1046 0 2-.8954 2-2v-14c0-1.10457-.8954-2-2-2zm14 1.5h-14c-.27614 0-.5.22386-.5.5v10.7072l3.62953-2.6465c.25108-.1831.58905-.1924.84981-.0234l2.92666 1.8969 3.5712-3.4719c.2911-.2831.7545-.2831 1.0456 0l2.9772 2.8945v-9.3568c0-.27614-.2239-.5-.5-.5zm-14.5 14.5v-1.4364l4.09643-2.987 2.99567 1.9417c.2936.1903.6798.1523.9307-.0917l3.4772-3.3806 3.4772 3.3806.0228-.0234v2.5968c0 .2761-.2239.5-.5.5h-14c-.27614 0-.5-.2239-.5-.5z"
  })]
});
/* harmony default export */ const library_media = (media);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/upload.js
/**
 * WordPress dependencies
 */


const upload = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M18.5 15v3.5H13V6.7l4.5 4.1 1-1.1-6.2-5.8-5.8 5.8 1 1.1 4-4v11.7h-6V15H4v5h16v-5z"
  })
});
/* harmony default export */ const library_upload = (upload);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/post-featured-image.js
/**
 * WordPress dependencies
 */


const postFeaturedImage = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M19 3H5c-.6 0-1 .4-1 1v7c0 .5.4 1 1 1h14c.5 0 1-.4 1-1V4c0-.6-.4-1-1-1zM5.5 10.5v-.4l1.8-1.3 1.3.8c.3.2.7.2.9-.1L11 8.1l2.4 2.4H5.5zm13 0h-2.9l-4-4c-.3-.3-.8-.3-1.1 0L8.9 8l-1.2-.8c-.3-.2-.6-.2-.9 0l-1.3 1V4.5h13v6zM4 20h9v-1.5H4V20zm0-4h16v-1.5H4V16z"
  })
});
/* harmony default export */ const post_featured_image = (postFeaturedImage);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/media-upload/index.js
/**
 * WordPress dependencies
 */


/**
 * This is a placeholder for the media upload component necessary to make it possible to provide
 * an integration with the core blocks that handle media files. By default it renders nothing but
 * it provides a way to have it overridden with the `editor.MediaUpload` filter.
 *
 * @return {Component} The component to be rendered.
 */
const MediaUpload = () => null;

/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/media-upload/README.md
 */
/* harmony default export */ const media_upload = ((0,external_wp_components_namespaceObject.withFilters)('editor.MediaUpload')(MediaUpload));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/media-upload/check.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

function MediaUploadCheck({
  fallback = null,
  children
}) {
  const hasUploadPermissions = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings
    } = select(store);
    return !!getSettings().mediaUpload;
  }, []);
  return hasUploadPermissions ? children : fallback;
}

/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/media-upload/README.md
 */
/* harmony default export */ const check = (MediaUploadCheck);

;// CONCATENATED MODULE: external ["wp","isShallowEqual"]
const external_wp_isShallowEqual_namespaceObject = window["wp"]["isShallowEqual"];
var external_wp_isShallowEqual_default = /*#__PURE__*/__webpack_require__.n(external_wp_isShallowEqual_namespaceObject);
;// CONCATENATED MODULE: external ["wp","preferences"]
const external_wp_preferences_namespaceObject = window["wp"]["preferences"];
;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/keyboard-return.js
/**
 * WordPress dependencies
 */


const keyboardReturn = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m6.734 16.106 2.176-2.38-1.093-1.028-3.846 4.158 3.846 4.158 1.093-1.028-2.176-2.38h2.811c1.125 0 2.25.03 3.374 0 1.428-.001 3.362-.25 4.963-1.277 1.66-1.065 2.868-2.906 2.868-5.859 0-2.479-1.327-4.896-3.65-5.93-1.82-.813-3.044-.8-4.806-.788l-.567.002v1.5c.184 0 .368 0 .553-.002 1.82-.007 2.704-.014 4.21.657 1.854.827 2.76 2.657 2.76 4.561 0 2.472-.973 3.824-2.178 4.596-1.258.807-2.864 1.04-4.163 1.04h-.02c-1.115.03-2.229 0-3.344 0H6.734Z"
  })
});
/* harmony default export */ const keyboard_return = (keyboardReturn);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/chevron-left-small.js
/**
 * WordPress dependencies
 */


const chevronLeftSmall = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m13.1 16-3.4-4 3.4-4 1.1 1-2.6 3 2.6 3-1.1 1z"
  })
});
/* harmony default export */ const chevron_left_small = (chevronLeftSmall);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/chevron-right-small.js
/**
 * WordPress dependencies
 */


const chevronRightSmall = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M10.8622 8.04053L14.2805 12.0286L10.8622 16.0167L9.72327 15.0405L12.3049 12.0286L9.72327 9.01672L10.8622 8.04053Z"
  })
});
/* harmony default export */ const chevron_right_small = (chevronRightSmall);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/settings-drawer.js
/**
 * WordPress dependencies
 */








function LinkSettingsDrawer({
  children,
  settingsOpen,
  setSettingsOpen
}) {
  const prefersReducedMotion = (0,external_wp_compose_namespaceObject.useReducedMotion)();
  const MaybeAnimatePresence = prefersReducedMotion ? external_wp_element_namespaceObject.Fragment : external_wp_components_namespaceObject.__unstableAnimatePresence;
  const MaybeMotionDiv = prefersReducedMotion ? 'div' : external_wp_components_namespaceObject.__unstableMotion.div;
  const id = (0,external_wp_compose_namespaceObject.useInstanceId)(LinkSettingsDrawer);
  const settingsDrawerId = `link-control-settings-drawer-${id}`;
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
      className: "block-editor-link-control__drawer-toggle",
      "aria-expanded": settingsOpen,
      onClick: () => setSettingsOpen(!settingsOpen),
      icon: (0,external_wp_i18n_namespaceObject.isRTL)() ? chevron_left_small : chevron_right_small,
      "aria-controls": settingsDrawerId,
      children: (0,external_wp_i18n_namespaceObject._x)('Advanced', 'Additional link settings')
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(MaybeAnimatePresence, {
      children: settingsOpen && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(MaybeMotionDiv, {
        className: "block-editor-link-control__drawer",
        hidden: !settingsOpen,
        id: settingsDrawerId,
        initial: "collapsed",
        animate: "open",
        exit: "collapsed",
        variants: {
          open: {
            opacity: 1,
            height: 'auto'
          },
          collapsed: {
            opacity: 0,
            height: 0
          }
        },
        transition: {
          duration: 0.1
        },
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
          className: "block-editor-link-control__drawer-inner",
          children: children
        })
      })
    })]
  });
}
/* harmony default export */ const settings_drawer = (LinkSettingsDrawer);

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(1609);
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/url-input/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */









/**
 * Internal dependencies
 */


/**
 * Whether the argument is a function.
 *
 * @param {*} maybeFunc The argument to check.
 * @return {boolean} True if the argument is a function, false otherwise.
 */




function isFunction(maybeFunc) {
  return typeof maybeFunc === 'function';
}
class URLInput extends external_wp_element_namespaceObject.Component {
  constructor(props) {
    super(props);
    this.onChange = this.onChange.bind(this);
    this.onFocus = this.onFocus.bind(this);
    this.onKeyDown = this.onKeyDown.bind(this);
    this.selectLink = this.selectLink.bind(this);
    this.handleOnClick = this.handleOnClick.bind(this);
    this.bindSuggestionNode = this.bindSuggestionNode.bind(this);
    this.autocompleteRef = props.autocompleteRef || (0,external_wp_element_namespaceObject.createRef)();
    this.inputRef = (0,external_wp_element_namespaceObject.createRef)();
    this.updateSuggestions = (0,external_wp_compose_namespaceObject.debounce)(this.updateSuggestions.bind(this), 200);
    this.suggestionNodes = [];
    this.suggestionsRequest = null;
    this.state = {
      suggestions: [],
      showSuggestions: false,
      suggestionsValue: null,
      selectedSuggestion: null,
      suggestionsListboxId: '',
      suggestionOptionIdPrefix: ''
    };
  }
  componentDidUpdate(prevProps) {
    const {
      showSuggestions,
      selectedSuggestion
    } = this.state;
    const {
      value,
      __experimentalShowInitialSuggestions = false
    } = this.props;

    // Only have to worry about scrolling selected suggestion into view
    // when already expanded.
    if (showSuggestions && selectedSuggestion !== null && this.suggestionNodes[selectedSuggestion]) {
      this.suggestionNodes[selectedSuggestion].scrollIntoView({
        behavior: 'instant',
        block: 'nearest',
        inline: 'nearest'
      });
    }

    // Update suggestions when the value changes.
    if (prevProps.value !== value && !this.props.disableSuggestions) {
      if (value?.length) {
        // If the new value is not empty we need to update with suggestions for it.
        this.updateSuggestions(value);
      } else if (__experimentalShowInitialSuggestions) {
        // If the new value is empty and we can show initial suggestions, then show initial suggestions.
        this.updateSuggestions();
      }
    }
  }
  componentDidMount() {
    if (this.shouldShowInitialSuggestions()) {
      this.updateSuggestions();
    }
  }
  componentWillUnmount() {
    this.suggestionsRequest?.cancel?.();
    this.suggestionsRequest = null;
  }
  bindSuggestionNode(index) {
    return ref => {
      this.suggestionNodes[index] = ref;
    };
  }
  shouldShowInitialSuggestions() {
    const {
      __experimentalShowInitialSuggestions = false,
      value
    } = this.props;
    return __experimentalShowInitialSuggestions && !(value && value.length);
  }
  updateSuggestions(value = '') {
    const {
      __experimentalFetchLinkSuggestions: fetchLinkSuggestions,
      __experimentalHandleURLSuggestions: handleURLSuggestions
    } = this.props;
    if (!fetchLinkSuggestions) {
      return;
    }

    // Initial suggestions may only show if there is no value
    // (note: this includes whitespace).
    const isInitialSuggestions = !value?.length;

    // Trim only now we've determined whether or not it originally had a "length"
    // (even if that value was all whitespace).
    value = value.trim();

    // Allow a suggestions request if:
    // - there are at least 2 characters in the search input (except manual searches where
    //   search input length is not required to trigger a fetch)
    // - this is a direct entry (eg: a URL)
    if (!isInitialSuggestions && (value.length < 2 || !handleURLSuggestions && (0,external_wp_url_namespaceObject.isURL)(value))) {
      this.suggestionsRequest?.cancel?.();
      this.suggestionsRequest = null;
      this.setState({
        suggestions: [],
        showSuggestions: false,
        suggestionsValue: value,
        selectedSuggestion: null,
        loading: false
      });
      return;
    }
    this.setState({
      selectedSuggestion: null,
      loading: true
    });
    const request = fetchLinkSuggestions(value, {
      isInitialSuggestions
    });
    request.then(suggestions => {
      // A fetch Promise doesn't have an abort option. It's mimicked by
      // comparing the request reference in on the instance, which is
      // reset or deleted on subsequent requests or unmounting.
      if (this.suggestionsRequest !== request) {
        return;
      }
      this.setState({
        suggestions,
        suggestionsValue: value,
        loading: false,
        showSuggestions: !!suggestions.length
      });
      if (!!suggestions.length) {
        this.props.debouncedSpeak((0,external_wp_i18n_namespaceObject.sprintf)( /* translators: %s: number of results. */
        (0,external_wp_i18n_namespaceObject._n)('%d result found, use up and down arrow keys to navigate.', '%d results found, use up and down arrow keys to navigate.', suggestions.length), suggestions.length), 'assertive');
      } else {
        this.props.debouncedSpeak((0,external_wp_i18n_namespaceObject.__)('No results.'), 'assertive');
      }
    }).catch(() => {
      if (this.suggestionsRequest !== request) {
        return;
      }
      this.setState({
        loading: false
      });
    }).finally(() => {
      // If this is the current promise then reset the reference
      // to allow for checking if a new request is made.
      if (this.suggestionsRequest === request) {
        this.suggestionsRequest = null;
      }
    });

    // Note that this assignment is handled *before* the async search request
    // as a Promise always resolves on the next tick of the event loop.
    this.suggestionsRequest = request;
  }
  onChange(event) {
    this.props.onChange(event.target.value);
  }
  onFocus() {
    const {
      suggestions
    } = this.state;
    const {
      disableSuggestions,
      value
    } = this.props;

    // When opening the link editor, if there's a value present, we want to load the suggestions pane with the results for this input search value
    // Don't re-run the suggestions on focus if there are already suggestions present (prevents searching again when tabbing between the input and buttons)
    // or there is already a request in progress.
    if (value && !disableSuggestions && !(suggestions && suggestions.length) && this.suggestionsRequest === null) {
      // Ensure the suggestions are updated with the current input value.
      this.updateSuggestions(value);
    }
  }
  onKeyDown(event) {
    this.props.onKeyDown?.(event);
    const {
      showSuggestions,
      selectedSuggestion,
      suggestions,
      loading
    } = this.state;

    // If the suggestions are not shown or loading, we shouldn't handle the arrow keys
    // We shouldn't preventDefault to allow block arrow keys navigation.
    if (!showSuggestions || !suggestions.length || loading) {
      // In the Windows version of Firefox the up and down arrows don't move the caret
      // within an input field like they do for Mac Firefox/Chrome/Safari. This causes
      // a form of focus trapping that is disruptive to the user experience. This disruption
      // only happens if the caret is not in the first or last position in the text input.
      // See: https://github.com/WordPress/gutenberg/issues/5693#issuecomment-436684747
      switch (event.keyCode) {
        // When UP is pressed, if the caret is at the start of the text, move it to the 0
        // position.
        case external_wp_keycodes_namespaceObject.UP:
          {
            if (0 !== event.target.selectionStart) {
              event.preventDefault();

              // Set the input caret to position 0.
              event.target.setSelectionRange(0, 0);
            }
            break;
          }
        // When DOWN is pressed, if the caret is not at the end of the text, move it to the
        // last position.
        case external_wp_keycodes_namespaceObject.DOWN:
          {
            if (this.props.value.length !== event.target.selectionStart) {
              event.preventDefault();

              // Set the input caret to the last position.
              event.target.setSelectionRange(this.props.value.length, this.props.value.length);
            }
            break;
          }

        // Submitting while loading should trigger onSubmit.
        case external_wp_keycodes_namespaceObject.ENTER:
          {
            if (this.props.onSubmit) {
              event.preventDefault();
              this.props.onSubmit(null, event);
            }
            break;
          }
      }
      return;
    }
    const suggestion = this.state.suggestions[this.state.selectedSuggestion];
    switch (event.keyCode) {
      case external_wp_keycodes_namespaceObject.UP:
        {
          event.preventDefault();
          const previousIndex = !selectedSuggestion ? suggestions.length - 1 : selectedSuggestion - 1;
          this.setState({
            selectedSuggestion: previousIndex
          });
          break;
        }
      case external_wp_keycodes_namespaceObject.DOWN:
        {
          event.preventDefault();
          const nextIndex = selectedSuggestion === null || selectedSuggestion === suggestions.length - 1 ? 0 : selectedSuggestion + 1;
          this.setState({
            selectedSuggestion: nextIndex
          });
          break;
        }
      case external_wp_keycodes_namespaceObject.TAB:
        {
          if (this.state.selectedSuggestion !== null) {
            this.selectLink(suggestion);
            // Announce a link has been selected when tabbing away from the input field.
            this.props.speak((0,external_wp_i18n_namespaceObject.__)('Link selected.'));
          }
          break;
        }
      case external_wp_keycodes_namespaceObject.ENTER:
        {
          event.preventDefault();
          if (this.state.selectedSuggestion !== null) {
            this.selectLink(suggestion);
            if (this.props.onSubmit) {
              this.props.onSubmit(suggestion, event);
            }
          } else if (this.props.onSubmit) {
            this.props.onSubmit(null, event);
          }
          break;
        }
    }
  }
  selectLink(suggestion) {
    this.props.onChange(suggestion.url, suggestion);
    this.setState({
      selectedSuggestion: null,
      showSuggestions: false
    });
  }
  handleOnClick(suggestion) {
    this.selectLink(suggestion);
    // Move focus to the input field when a link suggestion is clicked.
    this.inputRef.current.focus();
  }
  static getDerivedStateFromProps({
    value,
    instanceId,
    disableSuggestions,
    __experimentalShowInitialSuggestions = false
  }, {
    showSuggestions
  }) {
    let shouldShowSuggestions = showSuggestions;
    const hasValue = value && value.length;
    if (!__experimentalShowInitialSuggestions && !hasValue) {
      shouldShowSuggestions = false;
    }
    if (disableSuggestions === true) {
      shouldShowSuggestions = false;
    }
    return {
      showSuggestions: shouldShowSuggestions,
      suggestionsListboxId: `block-editor-url-input-suggestions-${instanceId}`,
      suggestionOptionIdPrefix: `block-editor-url-input-suggestion-${instanceId}`
    };
  }
  render() {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
      children: [this.renderControl(), this.renderSuggestions()]
    });
  }
  renderControl() {
    const {
      /** Start opting into the new margin-free styles that will become the default in a future version. */
      __nextHasNoMarginBottom = false,
      label = null,
      className,
      isFullWidth,
      instanceId,
      placeholder = (0,external_wp_i18n_namespaceObject.__)('Paste URL or type to search'),
      __experimentalRenderControl: renderControl,
      value = '',
      hideLabelFromVision = false
    } = this.props;
    const {
      loading,
      showSuggestions,
      selectedSuggestion,
      suggestionsListboxId,
      suggestionOptionIdPrefix
    } = this.state;
    const inputId = `url-input-control-${instanceId}`;
    const controlProps = {
      id: inputId,
      // Passes attribute to label for the for attribute
      label,
      className: dist_clsx('block-editor-url-input', className, {
        'is-full-width': isFullWidth
      }),
      hideLabelFromVision
    };
    const inputProps = {
      id: inputId,
      value,
      required: true,
      className: 'block-editor-url-input__input',
      type: 'text',
      onChange: this.onChange,
      onFocus: this.onFocus,
      placeholder,
      onKeyDown: this.onKeyDown,
      role: 'combobox',
      'aria-label': label ? undefined : (0,external_wp_i18n_namespaceObject.__)('URL'),
      // Ensure input always has an accessible label
      'aria-expanded': showSuggestions,
      'aria-autocomplete': 'list',
      'aria-owns': suggestionsListboxId,
      'aria-activedescendant': selectedSuggestion !== null ? `${suggestionOptionIdPrefix}-${selectedSuggestion}` : undefined,
      ref: this.inputRef
    };
    if (renderControl) {
      return renderControl(controlProps, inputProps, loading);
    }
    if (!__nextHasNoMarginBottom) {
      external_wp_deprecated_default()('Bottom margin styles for wp.blockEditor.URLInput', {
        since: '6.2',
        version: '6.5',
        hint: 'Set the `__nextHasNoMarginBottom` prop to true to start opting into the new styles, which will become the default in a future version'
      });
    }
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.BaseControl, {
      __nextHasNoMarginBottom: __nextHasNoMarginBottom,
      ...controlProps,
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("input", {
        ...inputProps
      }), loading && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Spinner, {})]
    });
  }
  renderSuggestions() {
    const {
      className,
      __experimentalRenderSuggestions: renderSuggestions
    } = this.props;
    const {
      showSuggestions,
      suggestions,
      suggestionsValue,
      selectedSuggestion,
      suggestionsListboxId,
      suggestionOptionIdPrefix,
      loading
    } = this.state;
    if (!showSuggestions || suggestions.length === 0) {
      return null;
    }
    const suggestionsListProps = {
      id: suggestionsListboxId,
      ref: this.autocompleteRef,
      role: 'listbox'
    };
    const buildSuggestionItemProps = (suggestion, index) => {
      return {
        role: 'option',
        tabIndex: '-1',
        id: `${suggestionOptionIdPrefix}-${index}`,
        ref: this.bindSuggestionNode(index),
        'aria-selected': index === selectedSuggestion ? true : undefined
      };
    };
    if (isFunction(renderSuggestions)) {
      return renderSuggestions({
        suggestions,
        selectedSuggestion,
        suggestionsListProps,
        buildSuggestionItemProps,
        isLoading: loading,
        handleSuggestionClick: this.handleOnClick,
        isInitialSuggestions: !suggestionsValue?.length,
        currentInputValue: suggestionsValue
      });
    }
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Popover, {
      placement: "bottom",
      focusOnMount: false,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
        ...suggestionsListProps,
        className: dist_clsx('block-editor-url-input__suggestions', `${className}__suggestions`),
        children: suggestions.map((suggestion, index) => /*#__PURE__*/(0,external_React_.createElement)(external_wp_components_namespaceObject.Button, {
          ...buildSuggestionItemProps(suggestion, index),
          key: suggestion.id,
          className: dist_clsx('block-editor-url-input__suggestion', {
            'is-selected': index === selectedSuggestion
          }),
          onClick: () => this.handleOnClick(suggestion)
        }, suggestion.title))
      })
    });
  }
}

/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/url-input/README.md
 */
/* harmony default export */ const url_input = ((0,external_wp_compose_namespaceObject.compose)(external_wp_compose_namespaceObject.withSafeTimeout, external_wp_components_namespaceObject.withSpokenMessages, external_wp_compose_namespaceObject.withInstanceId, (0,external_wp_data_namespaceObject.withSelect)((select, props) => {
  // If a link suggestions handler is already provided then
  // bail.
  if (isFunction(props.__experimentalFetchLinkSuggestions)) {
    return;
  }
  const {
    getSettings
  } = select(store);
  return {
    __experimentalFetchLinkSuggestions: getSettings().__experimentalFetchLinkSuggestions
  };
}))(URLInput));

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/plus.js
/**
 * WordPress dependencies
 */


const plus = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M11 12.5V17.5H12.5V12.5H17.5V11H12.5V6H11V11H6V12.5H11Z"
  })
});
/* harmony default export */ const library_plus = (plus);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/search-create-button.js
/**
 * WordPress dependencies
 */





const LinkControlSearchCreate = ({
  searchTerm,
  onClick,
  itemProps,
  buttonText
}) => {
  if (!searchTerm) {
    return null;
  }
  let text;
  if (buttonText) {
    text = typeof buttonText === 'function' ? buttonText(searchTerm) : buttonText;
  } else {
    text = (0,external_wp_element_namespaceObject.createInterpolateElement)((0,external_wp_i18n_namespaceObject.sprintf)( /* translators: %s: search term. */
    (0,external_wp_i18n_namespaceObject.__)('Create: <mark>%s</mark>'), searchTerm), {
      mark: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("mark", {})
    });
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
    ...itemProps,
    iconPosition: "left",
    icon: library_plus,
    className: "block-editor-link-control__search-item",
    onClick: onClick,
    children: text
  });
};
/* harmony default export */ const search_create_button = (LinkControlSearchCreate);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/post-list.js
/**
 * WordPress dependencies
 */


const postList = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M18 5.5H6a.5.5 0 0 0-.5.5v12a.5.5 0 0 0 .5.5h12a.5.5 0 0 0 .5-.5V6a.5.5 0 0 0-.5-.5ZM6 4h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2Zm1 5h1.5v1.5H7V9Zm1.5 4.5H7V15h1.5v-1.5ZM10 9h7v1.5h-7V9Zm7 4.5h-7V15h7v-1.5Z"
  })
});
/* harmony default export */ const post_list = (postList);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/page.js
/**
 * WordPress dependencies
 */



const page = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M15.5 7.5h-7V9h7V7.5Zm-7 3.5h7v1.5h-7V11Zm7 3.5h-7V16h7v-1.5Z"
  }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M17 4H7a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2ZM7 5.5h10a.5.5 0 0 1 .5.5v12a.5.5 0 0 1-.5.5H7a.5.5 0 0 1-.5-.5V6a.5.5 0 0 1 .5-.5Z"
  })]
});
/* harmony default export */ const library_page = (page);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/tag.js
/**
 * WordPress dependencies
 */


const tag = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M4.75 4a.75.75 0 0 0-.75.75v7.826c0 .2.08.39.22.53l6.72 6.716a2.313 2.313 0 0 0 3.276-.001l5.61-5.611-.531-.53.532.528a2.315 2.315 0 0 0 0-3.264L13.104 4.22a.75.75 0 0 0-.53-.22H4.75ZM19 12.576a.815.815 0 0 1-.236.574l-5.61 5.611a.814.814 0 0 1-1.153 0L5.5 12.264V5.5h6.763l6.5 6.502a.816.816 0 0 1 .237.574ZM8.75 9.75a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"
  })
});
/* harmony default export */ const library_tag = (tag);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/category.js
/**
 * WordPress dependencies
 */


const category = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M6 5.5h3a.5.5 0 01.5.5v3a.5.5 0 01-.5.5H6a.5.5 0 01-.5-.5V6a.5.5 0 01.5-.5zM4 6a2 2 0 012-2h3a2 2 0 012 2v3a2 2 0 01-2 2H6a2 2 0 01-2-2V6zm11-.5h3a.5.5 0 01.5.5v3a.5.5 0 01-.5.5h-3a.5.5 0 01-.5-.5V6a.5.5 0 01.5-.5zM13 6a2 2 0 012-2h3a2 2 0 012 2v3a2 2 0 01-2 2h-3a2 2 0 01-2-2V6zm5 8.5h-3a.5.5 0 00-.5.5v3a.5.5 0 00.5.5h3a.5.5 0 00.5-.5v-3a.5.5 0 00-.5-.5zM15 13a2 2 0 00-2 2v3a2 2 0 002 2h3a2 2 0 002-2v-3a2 2 0 00-2-2h-3zm-9 1.5h3a.5.5 0 01.5.5v3a.5.5 0 01-.5.5H6a.5.5 0 01-.5-.5v-3a.5.5 0 01.5-.5zM4 15a2 2 0 012-2h3a2 2 0 012 2v3a2 2 0 01-2 2H6a2 2 0 01-2-2v-3z",
    fillRule: "evenodd",
    clipRule: "evenodd"
  })
});
/* harmony default export */ const library_category = (category);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/file.js
/**
 * WordPress dependencies
 */


const file = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M12.848 8a1 1 0 0 1-.914-.594l-.723-1.63a.5.5 0 0 0-.447-.276H5a.5.5 0 0 0-.5.5v11.5a.5.5 0 0 0 .5.5h14a.5.5 0 0 0 .5-.5v-9A.5.5 0 0 0 19 8h-6.152Zm.612-1.5a.5.5 0 0 1-.462-.31l-.445-1.084A2 2 0 0 0 10.763 4H5a2 2 0 0 0-2 2v11.5a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-9a2 2 0 0 0-2-2h-5.54Z"
  })
});
/* harmony default export */ const library_file = (file);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/globe.js
/**
 * WordPress dependencies
 */


const globe = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M12 3.3c-4.8 0-8.8 3.9-8.8 8.8 0 4.8 3.9 8.8 8.8 8.8 4.8 0 8.8-3.9 8.8-8.8s-4-8.8-8.8-8.8zm6.5 5.5h-2.6C15.4 7.3 14.8 6 14 5c2 .6 3.6 2 4.5 3.8zm.7 3.2c0 .6-.1 1.2-.2 1.8h-2.9c.1-.6.1-1.2.1-1.8s-.1-1.2-.1-1.8H19c.2.6.2 1.2.2 1.8zM12 18.7c-1-.7-1.8-1.9-2.3-3.5h4.6c-.5 1.6-1.3 2.9-2.3 3.5zm-2.6-4.9c-.1-.6-.1-1.1-.1-1.8 0-.6.1-1.2.1-1.8h5.2c.1.6.1 1.1.1 1.8s-.1 1.2-.1 1.8H9.4zM4.8 12c0-.6.1-1.2.2-1.8h2.9c-.1.6-.1 1.2-.1 1.8 0 .6.1 1.2.1 1.8H5c-.2-.6-.2-1.2-.2-1.8zM12 5.3c1 .7 1.8 1.9 2.3 3.5H9.7c.5-1.6 1.3-2.9 2.3-3.5zM10 5c-.8 1-1.4 2.3-1.8 3.8H5.5C6.4 7 8 5.6 10 5zM5.5 15.3h2.6c.4 1.5 1 2.8 1.8 3.7-1.8-.6-3.5-2-4.4-3.7zM14 19c.8-1 1.4-2.2 1.8-3.7h2.6C17.6 17 16 18.4 14 19z"
  })
});
/* harmony default export */ const library_globe = (globe);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/home.js
/**
 * WordPress dependencies
 */


const home = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M12 4L4 7.9V20h16V7.9L12 4zm6.5 14.5H14V13h-4v5.5H5.5V8.8L12 5.7l6.5 3.1v9.7z"
  })
});
/* harmony default export */ const library_home = (home);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/verse.js
/**
 * WordPress dependencies
 */


const verse = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M17.8 2l-.9.3c-.1 0-3.6 1-5.2 2.1C10 5.5 9.3 6.5 8.9 7.1c-.6.9-1.7 4.7-1.7 6.3l-.9 2.3c-.2.4 0 .8.4 1 .1 0 .2.1.3.1.3 0 .6-.2.7-.5l.6-1.5c.3 0 .7-.1 1.2-.2.7-.1 1.4-.3 2.2-.5.8-.2 1.6-.5 2.4-.8.7-.3 1.4-.7 1.9-1.2s.8-1.2 1-1.9c.2-.7.3-1.6.4-2.4.1-.8.1-1.7.2-2.5 0-.8.1-1.5.2-2.1V2zm-1.9 5.6c-.1.8-.2 1.5-.3 2.1-.2.6-.4 1-.6 1.3-.3.3-.8.6-1.4.9-.7.3-1.4.5-2.2.8-.6.2-1.3.3-1.8.4L15 7.5c.3-.3.6-.7 1-1.1 0 .4 0 .8-.1 1.2zM6 20h8v-1.5H6V20z"
  })
});
/* harmony default export */ const library_verse = (verse);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/search-item.js
/**
 * WordPress dependencies
 */







const ICONS_MAP = {
  post: post_list,
  page: library_page,
  post_tag: library_tag,
  category: library_category,
  attachment: library_file
};
function SearchItemIcon({
  isURL,
  suggestion
}) {
  let icon = null;
  if (isURL) {
    icon = library_globe;
  } else if (suggestion.type in ICONS_MAP) {
    icon = ICONS_MAP[suggestion.type];
    if (suggestion.type === 'page') {
      if (suggestion.isFrontPage) {
        icon = library_home;
      }
      if (suggestion.isBlogHome) {
        icon = library_verse;
      }
    }
  }
  if (icon) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(build_module_icon, {
      className: "block-editor-link-control__search-item-icon",
      icon: icon
    });
  }
  return null;
}

/**
 * Adds a leading slash to a url if it doesn't already have one.
 * @param {string} url the url to add a leading slash to.
 * @return {string} the url with a leading slash.
 */
function addLeadingSlash(url) {
  const trimmedURL = url?.trim();
  if (!trimmedURL?.length) {
    return url;
  }
  return url?.replace(/^\/?/, '/');
}
function removeTrailingSlash(url) {
  const trimmedURL = url?.trim();
  if (!trimmedURL?.length) {
    return url;
  }
  return url?.replace(/\/$/, '');
}
const partialRight = (fn, ...partialArgs) => (...args) => fn(...args, ...partialArgs);
const defaultTo = d => v => {
  return v === null || v === undefined || v !== v ? d : v;
};

/**
 * Prepares a URL for display in the UI.
 * - decodes the URL.
 * - filters it (removes protocol, www, etc.).
 * - truncates it if necessary.
 * - adds a leading slash.
 * @param {string} url the url.
 * @return {string} the processed url to display.
 */
function getURLForDisplay(url) {
  if (!url) {
    return url;
  }
  return (0,external_wp_compose_namespaceObject.pipe)(external_wp_url_namespaceObject.safeDecodeURI, external_wp_url_namespaceObject.getPath, defaultTo(''), partialRight(external_wp_url_namespaceObject.filterURLForDisplay, 24), removeTrailingSlash, addLeadingSlash)(url);
}
const LinkControlSearchItem = ({
  itemProps,
  suggestion,
  searchTerm,
  onClick,
  isURL = false,
  shouldShowType = false
}) => {
  const info = isURL ? (0,external_wp_i18n_namespaceObject.__)('Press ENTER to add this link') : getURLForDisplay(suggestion.url);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
    ...itemProps,
    info: info,
    iconPosition: "left",
    icon: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(SearchItemIcon, {
      suggestion: suggestion,
      isURL: isURL
    }),
    onClick: onClick,
    shortcut: shouldShowType && getVisualTypeName(suggestion),
    className: "block-editor-link-control__search-item",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.TextHighlight
    // The component expects a plain text string.
    , {
      text: (0,external_wp_dom_namespaceObject.__unstableStripHTML)(suggestion.title),
      highlight: searchTerm
    })
  });
};
function getVisualTypeName(suggestion) {
  if (suggestion.isFrontPage) {
    return 'front page';
  }
  if (suggestion.isBlogHome) {
    return 'blog home';
  }

  // Rename 'post_tag' to 'tag'. Ideally, the API would return the localised CPT or taxonomy label.
  return suggestion.type === 'post_tag' ? 'tag' : suggestion.type;
}
/* harmony default export */ const search_item = (LinkControlSearchItem);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/constants.js
/**
 * WordPress dependencies
 */


// Used as a unique identifier for the "Create" option within search results.
// Used to help distinguish the "Create" suggestion within the search results in
// order to handle it as a unique case.
const CREATE_TYPE = '__CREATE__';
const TEL_TYPE = 'tel';
const URL_TYPE = 'link';
const MAILTO_TYPE = 'mailto';
const INTERNAL_TYPE = 'internal';
const LINK_ENTRY_TYPES = [URL_TYPE, MAILTO_TYPE, TEL_TYPE, INTERNAL_TYPE];
const DEFAULT_LINK_SETTINGS = [{
  id: 'opensInNewTab',
  title: (0,external_wp_i18n_namespaceObject.__)('Open in new tab')
}];

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/search-results.js
/**
 * WordPress dependencies
 */



/**
 * External dependencies
 */


/**
 * Internal dependencies
 */





function LinkControlSearchResults({
  instanceId,
  withCreateSuggestion,
  currentInputValue,
  handleSuggestionClick,
  suggestionsListProps,
  buildSuggestionItemProps,
  suggestions,
  selectedSuggestion,
  isLoading,
  isInitialSuggestions,
  createSuggestionButtonText,
  suggestionsQuery
}) {
  const resultsListClasses = dist_clsx('block-editor-link-control__search-results', {
    'is-loading': isLoading
  });
  const isSingleDirectEntryResult = suggestions.length === 1 && LINK_ENTRY_TYPES.includes(suggestions[0].type);
  const shouldShowCreateSuggestion = withCreateSuggestion && !isSingleDirectEntryResult && !isInitialSuggestions;
  // If the query has a specified type, then we can skip showing them in the result. See #24839.
  const shouldShowSuggestionsTypes = !suggestionsQuery?.type;

  // According to guidelines aria-label should be added if the label
  // itself is not visible.
  // See: https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/listbox_role
  const searchResultsLabelId = `block-editor-link-control-search-results-label-${instanceId}`;
  const labelText = isInitialSuggestions ? (0,external_wp_i18n_namespaceObject.__)('Suggestions') : (0,external_wp_i18n_namespaceObject.sprintf)( /* translators: %s: search term. */
  (0,external_wp_i18n_namespaceObject.__)('Search results for "%s"'), currentInputValue);
  const searchResultsLabel = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.VisuallyHidden, {
    id: searchResultsLabelId,
    children: labelText
  });
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
    className: "block-editor-link-control__search-results-wrapper",
    children: [searchResultsLabel, /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      ...suggestionsListProps,
      className: resultsListClasses,
      "aria-labelledby": searchResultsLabelId,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuGroup, {
        children: suggestions.map((suggestion, index) => {
          if (shouldShowCreateSuggestion && CREATE_TYPE === suggestion.type) {
            return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(search_create_button, {
              searchTerm: currentInputValue,
              buttonText: createSuggestionButtonText,
              onClick: () => handleSuggestionClick(suggestion)
              // Intentionally only using `type` here as
              // the constant is enough to uniquely
              // identify the single "CREATE" suggestion.
              ,

              itemProps: buildSuggestionItemProps(suggestion, index),
              isSelected: index === selectedSuggestion
            }, suggestion.type);
          }

          // If we're not handling "Create" suggestions above then
          // we don't want them in the main results so exit early.
          if (CREATE_TYPE === suggestion.type) {
            return null;
          }
          return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(search_item, {
            itemProps: buildSuggestionItemProps(suggestion, index),
            suggestion: suggestion,
            index: index,
            onClick: () => {
              handleSuggestionClick(suggestion);
            },
            isSelected: index === selectedSuggestion,
            isURL: LINK_ENTRY_TYPES.includes(suggestion.type),
            searchTerm: currentInputValue,
            shouldShowType: shouldShowSuggestionsTypes,
            isFrontPage: suggestion?.isFrontPage,
            isBlogHome: suggestion?.isBlogHome
          }, `${suggestion.id}-${suggestion.type}`);
        })
      })
    })]
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/is-url-like.js
/**
 * WordPress dependencies
 */


/**
 * Determines whether a given value could be a URL. Note this does not
 * guarantee the value is a URL only that it looks like it might be one. For
 * example, just because a string has `www.` in it doesn't make it a URL,
 * but it does make it highly likely that it will be so in the context of
 * creating a link it makes sense to treat it like one.
 *
 * @param {string} val the candidate for being URL-like (or not).
 *
 * @return {boolean} whether or not the value is potentially a URL.
 */
function isURLLike(val) {
  const hasSpaces = val.includes(' ');
  if (hasSpaces) {
    return false;
  }
  const protocol = (0,external_wp_url_namespaceObject.getProtocol)(val);
  const protocolIsValid = (0,external_wp_url_namespaceObject.isValidProtocol)(protocol);
  const mayBeTLD = hasPossibleTLD(val);
  const isWWW = val?.startsWith('www.');
  const isInternal = val?.startsWith('#') && (0,external_wp_url_namespaceObject.isValidFragment)(val);
  return protocolIsValid || isWWW || isInternal || mayBeTLD;
}

/**
 * Checks if a given URL has a valid Top-Level Domain (TLD).
 *
 * @param {string} url       - The URL to check.
 * @param {number} maxLength - The maximum length of the TLD.
 * @return {boolean} Returns true if the URL has a valid TLD, false otherwise.
 */
function hasPossibleTLD(url, maxLength = 6) {
  // Clean the URL by removing anything after the first occurrence of "?" or "#".
  const cleanedURL = url.split(/[?#]/)[0];

  // Regular expression explanation:
  // - (?<=\S)                  : Positive lookbehind assertion to ensure there is at least one non-whitespace character before the TLD
  // - \.                       : Matches a literal dot (.)
  // - [a-zA-Z_]{2,maxLength}   : Matches 2 to maxLength letters or underscores, representing the TLD
  // - (?:\/|$)                 : Non-capturing group that matches either a forward slash (/) or the end of the string
  const regex = new RegExp(`(?<=\\S)\\.(?:[a-zA-Z_]{2,${maxLength}})(?:\\/|$)`);
  return regex.test(cleanedURL);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/use-search-handler.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



const handleNoop = () => Promise.resolve([]);
const handleDirectEntry = val => {
  let type = URL_TYPE;
  const protocol = (0,external_wp_url_namespaceObject.getProtocol)(val) || '';
  if (protocol.includes('mailto')) {
    type = MAILTO_TYPE;
  }
  if (protocol.includes('tel')) {
    type = TEL_TYPE;
  }
  if (val?.startsWith('#')) {
    type = INTERNAL_TYPE;
  }
  return Promise.resolve([{
    id: val,
    title: val,
    url: type === 'URL' ? (0,external_wp_url_namespaceObject.prependHTTP)(val) : val,
    type
  }]);
};
const handleEntitySearch = async (val, suggestionsQuery, fetchSearchSuggestions, withCreateSuggestion, pageOnFront, pageForPosts) => {
  const {
    isInitialSuggestions
  } = suggestionsQuery;
  const results = await fetchSearchSuggestions(val, suggestionsQuery);

  // Identify front page and update type to match.
  results.map(result => {
    if (Number(result.id) === pageOnFront) {
      result.isFrontPage = true;
      return result;
    } else if (Number(result.id) === pageForPosts) {
      result.isBlogHome = true;
      return result;
    }
    return result;
  });

  // If displaying initial suggestions just return plain results.
  if (isInitialSuggestions) {
    return results;
  }

  // Here we append a faux suggestion to represent a "CREATE" option. This
  // is detected in the rendering of the search results and handled as a
  // special case. This is currently necessary because the suggestions
  // dropdown will only appear if there are valid suggestions and
  // therefore unless the create option is a suggestion it will not
  // display in scenarios where there are no results returned from the
  // API. In addition promoting CREATE to a first class suggestion affords
  // the a11y benefits afforded by `URLInput` to all suggestions (eg:
  // keyboard handling, ARIA roles...etc).
  //
  // Note also that the value of the `title` and `url` properties must correspond
  // to the text value of the `<input>`. This is because `title` is used
  // when creating the suggestion. Similarly `url` is used when using keyboard to select
  // the suggestion (the <form> `onSubmit` handler falls-back to `url`).
  return isURLLike(val) || !withCreateSuggestion ? results : results.concat({
    // the `id` prop is intentionally ommitted here because it
    // is never exposed as part of the component's public API.
    // see: https://github.com/WordPress/gutenberg/pull/19775#discussion_r378931316.
    title: val,
    // Must match the existing `<input>`s text value.
    url: val,
    // Must match the existing `<input>`s text value.
    type: CREATE_TYPE
  });
};
function useSearchHandler(suggestionsQuery, allowDirectEntry, withCreateSuggestion) {
  const {
    fetchSearchSuggestions,
    pageOnFront,
    pageForPosts
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings
    } = select(store);
    return {
      pageOnFront: getSettings().pageOnFront,
      pageForPosts: getSettings().pageForPosts,
      fetchSearchSuggestions: getSettings().__experimentalFetchLinkSuggestions
    };
  }, []);
  const directEntryHandler = allowDirectEntry ? handleDirectEntry : handleNoop;
  return (0,external_wp_element_namespaceObject.useCallback)((val, {
    isInitialSuggestions
  }) => {
    return isURLLike(val) ? directEntryHandler(val, {
      isInitialSuggestions
    }) : handleEntitySearch(val, {
      ...suggestionsQuery,
      isInitialSuggestions
    }, fetchSearchSuggestions, withCreateSuggestion, pageOnFront, pageForPosts);
  }, [directEntryHandler, fetchSearchSuggestions, pageOnFront, pageForPosts, suggestionsQuery, withCreateSuggestion]);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/search-input.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





// Must be a function as otherwise URLInput will default
// to the fetchLinkSuggestions passed in block editor settings
// which will cause an unintended http request.


const noopSearchHandler = () => Promise.resolve([]);
const noop = () => {};
const LinkControlSearchInput = (0,external_wp_element_namespaceObject.forwardRef)(({
  value,
  children,
  currentLink = {},
  className = null,
  placeholder = null,
  withCreateSuggestion = false,
  onCreateSuggestion = noop,
  onChange = noop,
  onSelect = noop,
  showSuggestions = true,
  renderSuggestions = props => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(LinkControlSearchResults, {
    ...props
  }),
  fetchSuggestions = null,
  allowDirectEntry = true,
  showInitialSuggestions = false,
  suggestionsQuery = {},
  withURLSuggestion = true,
  createSuggestionButtonText,
  hideLabelFromVision = false
}, ref) => {
  const genericSearchHandler = useSearchHandler(suggestionsQuery, allowDirectEntry, withCreateSuggestion, withURLSuggestion);
  const searchHandler = showSuggestions ? fetchSuggestions || genericSearchHandler : noopSearchHandler;
  const instanceId = (0,external_wp_compose_namespaceObject.useInstanceId)(LinkControlSearchInput);
  const [focusedSuggestion, setFocusedSuggestion] = (0,external_wp_element_namespaceObject.useState)();

  /**
   * Handles the user moving between different suggestions. Does not handle
   * choosing an individual item.
   *
   * @param {string} selection  the url of the selected suggestion.
   * @param {Object} suggestion the suggestion object.
   */
  const onInputChange = (selection, suggestion) => {
    onChange(selection);
    setFocusedSuggestion(suggestion);
  };
  const handleRenderSuggestions = props => renderSuggestions({
    ...props,
    instanceId,
    withCreateSuggestion,
    createSuggestionButtonText,
    suggestionsQuery,
    handleSuggestionClick: suggestion => {
      if (props.handleSuggestionClick) {
        props.handleSuggestionClick(suggestion);
      }
      onSuggestionSelected(suggestion);
    }
  });
  const onSuggestionSelected = async selectedSuggestion => {
    let suggestion = selectedSuggestion;
    if (CREATE_TYPE === selectedSuggestion.type) {
      // Create a new page and call onSelect with the output from the onCreateSuggestion callback.
      try {
        suggestion = await onCreateSuggestion(selectedSuggestion.title);
        if (suggestion?.url) {
          onSelect(suggestion);
        }
      } catch (e) {}
      return;
    }
    if (allowDirectEntry || suggestion && Object.keys(suggestion).length >= 1) {
      const {
        id,
        url,
        ...restLinkProps
      } = currentLink !== null && currentLink !== void 0 ? currentLink : {};
      onSelect(
      // Some direct entries don't have types or IDs, and we still need to clear the previous ones.
      {
        ...restLinkProps,
        ...suggestion
      }, suggestion);
    }
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
    className: "block-editor-link-control__search-input-container",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(url_input, {
      disableSuggestions: currentLink?.url === value,
      __nextHasNoMarginBottom: true,
      label: (0,external_wp_i18n_namespaceObject.__)('Link'),
      hideLabelFromVision: hideLabelFromVision,
      className: className,
      value: value,
      onChange: onInputChange,
      placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : (0,external_wp_i18n_namespaceObject.__)('Search or type url'),
      __experimentalRenderSuggestions: showSuggestions ? handleRenderSuggestions : null,
      __experimentalFetchLinkSuggestions: searchHandler,
      __experimentalHandleURLSuggestions: true,
      __experimentalShowInitialSuggestions: showInitialSuggestions,
      onSubmit: (suggestion, event) => {
        const hasSuggestion = suggestion || focusedSuggestion;

        // If there is no suggestion and the value (ie: any manually entered URL) is empty
        // then don't allow submission otherwise we get empty links.
        if (!hasSuggestion && !value?.trim()?.length) {
          event.preventDefault();
        } else {
          onSuggestionSelected(hasSuggestion || {
            url: value
          });
        }
      },
      ref: ref
    }), children]
  });
});
/* harmony default export */ const search_input = (LinkControlSearchInput);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/info.js
/**
 * WordPress dependencies
 */


const info = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M12 3.2c-4.8 0-8.8 3.9-8.8 8.8 0 4.8 3.9 8.8 8.8 8.8 4.8 0 8.8-3.9 8.8-8.8 0-4.8-4-8.8-8.8-8.8zm0 16c-4 0-7.2-3.3-7.2-7.2C4.8 8 8 4.8 12 4.8s7.2 3.3 7.2 7.2c0 4-3.2 7.2-7.2 7.2zM11 17h2v-6h-2v6zm0-8h2V7h-2v2z"
  })
});
/* harmony default export */ const library_info = (info);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/pencil.js
/**
 * WordPress dependencies
 */


const pencil = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m19 7-3-3-8.5 8.5-1 4 4-1L19 7Zm-7 11.5H5V20h7v-1.5Z"
  })
});
/* harmony default export */ const library_pencil = (pencil);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/edit.js
/**
 * Internal dependencies
 */


/* harmony default export */ const edit = (library_pencil);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/link-off.js
/**
 * WordPress dependencies
 */


const linkOff = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M17.031 4.703 15.576 4l-1.56 3H14v.03l-2.324 4.47H9.5V13h1.396l-1.502 2.889h-.95a3.694 3.694 0 0 1 0-7.389H10V7H8.444a5.194 5.194 0 1 0 0 10.389h.17L7.5 19.53l1.416.719L15.049 8.5h.507a3.694 3.694 0 0 1 0 7.39H14v1.5h1.556a5.194 5.194 0 0 0 .273-10.383l1.202-2.304Z"
  })
});
/* harmony default export */ const link_off = (linkOff);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/copy-small.js
/**
 * WordPress dependencies
 */


const copySmall = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M5.625 5.5h9.75c.069 0 .125.056.125.125v9.75a.125.125 0 0 1-.125.125h-9.75a.125.125 0 0 1-.125-.125v-9.75c0-.069.056-.125.125-.125ZM4 5.625C4 4.728 4.728 4 5.625 4h9.75C16.273 4 17 4.728 17 5.625v9.75c0 .898-.727 1.625-1.625 1.625h-9.75A1.625 1.625 0 0 1 4 15.375v-9.75Zm14.5 11.656v-9H20v9C20 18.8 18.77 20 17.251 20H6.25v-1.5h11.001c.69 0 1.249-.528 1.249-1.219Z"
  })
});
/* harmony default export */ const copy_small = (copySmall);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/viewer-slot.js
/**
 * WordPress dependencies
 */

const {
  Slot: ViewerSlot,
  Fill: ViewerFill
} = (0,external_wp_components_namespaceObject.createSlotFill)('BlockEditorLinkControlViewer');

/* harmony default export */ const viewer_slot = ((/* unused pure expression or super */ null && (ViewerSlot)));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/use-rich-url-data.js
/**
 * Internal dependencies
 */


/**
 * WordPress dependencies
 */


function use_rich_url_data_reducer(state, action) {
  switch (action.type) {
    case 'RESOLVED':
      return {
        ...state,
        isFetching: false,
        richData: action.richData
      };
    case 'ERROR':
      return {
        ...state,
        isFetching: false,
        richData: null
      };
    case 'LOADING':
      return {
        ...state,
        isFetching: true
      };
    default:
      throw new Error(`Unexpected action type ${action.type}`);
  }
}
function useRemoteUrlData(url) {
  const [state, dispatch] = (0,external_wp_element_namespaceObject.useReducer)(use_rich_url_data_reducer, {
    richData: null,
    isFetching: false
  });
  const {
    fetchRichUrlData
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getSettings
    } = select(store);
    return {
      fetchRichUrlData: getSettings().__experimentalFetchRichUrlData
    };
  }, []);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // Only make the request if we have an actual URL
    // and the fetching util is available. In some editors
    // there may not be such a util.
    if (url?.length && fetchRichUrlData && typeof AbortController !== 'undefined') {
      dispatch({
        type: 'LOADING'
      });
      const controller = new window.AbortController();
      const signal = controller.signal;
      fetchRichUrlData(url, {
        signal
      }).then(urlData => {
        dispatch({
          type: 'RESOLVED',
          richData: urlData
        });
      }).catch(() => {
        // Avoid setting state on unmounted component
        if (!signal.aborted) {
          dispatch({
            type: 'ERROR'
          });
        }
      });
      // Cleanup: when the URL changes the abort the current request.
      return () => {
        controller.abort();
      };
    }
  }, [url]);
  return state;
}
/* harmony default export */ const use_rich_url_data = (useRemoteUrlData);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/link-preview.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */










/**
 * Internal dependencies
 */





function LinkPreview({
  value,
  onEditClick,
  hasRichPreviews = false,
  hasUnlinkControl = false,
  onRemove
}) {
  const showIconLabels = (0,external_wp_data_namespaceObject.useSelect)(select => select(external_wp_preferences_namespaceObject.store).get('core', 'showIconLabels'), []);

  // Avoid fetching if rich previews are not desired.
  const showRichPreviews = hasRichPreviews ? value?.url : null;
  const {
    richData,
    isFetching
  } = use_rich_url_data(showRichPreviews);

  // Rich data may be an empty object so test for that.
  const hasRichData = richData && Object.keys(richData).length;
  const displayURL = value && (0,external_wp_url_namespaceObject.filterURLForDisplay)((0,external_wp_url_namespaceObject.safeDecodeURI)(value.url), 24) || '';

  // url can be undefined if the href attribute is unset
  const isEmptyURL = !value?.url?.length;
  const displayTitle = !isEmptyURL && (0,external_wp_dom_namespaceObject.__unstableStripHTML)(richData?.title || value?.title || displayURL);
  let icon;
  if (richData?.icon) {
    icon = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("img", {
      src: richData?.icon,
      alt: ""
    });
  } else if (isEmptyURL) {
    icon = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(build_module_icon, {
      icon: library_info,
      size: 32
    });
  } else {
    icon = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(build_module_icon, {
      icon: library_globe
    });
  }
  const {
    createNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const ref = (0,external_wp_compose_namespaceObject.useCopyToClipboard)(value.url, () => {
    createNotice('info', (0,external_wp_i18n_namespaceObject.__)('Link copied to clipboard.'), {
      isDismissible: true,
      type: 'snackbar'
    });
  });
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Currently selected'),
    className: dist_clsx('block-editor-link-control__search-item', {
      'is-current': true,
      'is-rich': hasRichData,
      'is-fetching': !!isFetching,
      'is-preview': true,
      'is-error': isEmptyURL,
      'is-url-title': displayTitle === displayURL
    }),
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
      className: "block-editor-link-control__search-item-top",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("span", {
        className: "block-editor-link-control__search-item-header",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
          className: dist_clsx('block-editor-link-control__search-item-icon', {
            'is-image': richData?.icon
          }),
          children: icon
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
          className: "block-editor-link-control__search-item-details",
          children: !isEmptyURL ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
            children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ExternalLink, {
              className: "block-editor-link-control__search-item-title",
              href: value.url,
              children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalTruncate, {
                numberOfLines: 1,
                children: displayTitle
              })
            }), value?.url && displayTitle !== displayURL && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
              className: "block-editor-link-control__search-item-info",
              children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalTruncate, {
                numberOfLines: 1,
                children: displayURL
              })
            })]
          }) : /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
            className: "block-editor-link-control__search-item-error-notice",
            children: (0,external_wp_i18n_namespaceObject.__)('Link is empty')
          })
        })]
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
        icon: edit,
        label: (0,external_wp_i18n_namespaceObject.__)('Edit link'),
        onClick: onEditClick,
        size: "compact"
      }), hasUnlinkControl && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
        icon: link_off,
        label: (0,external_wp_i18n_namespaceObject.__)('Remove link'),
        onClick: onRemove,
        size: "compact"
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
        icon: copy_small,
        label: (0,external_wp_i18n_namespaceObject.sprintf)(
        // Translators: %s is a placeholder for the link URL and an optional colon, (if a Link URL is present).
        (0,external_wp_i18n_namespaceObject.__)('Copy link%s'),
        // Ends up looking like "Copy link: https://example.com".
        isEmptyURL || showIconLabels ? '' : ': ' + value.url),
        ref: ref,
        disabled: isEmptyURL,
        size: "compact"
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ViewerSlot, {
        fillProps: value
      })]
    })
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/settings.js
/**
 * WordPress dependencies
 */




const settings_noop = () => {};
const LinkControlSettings = ({
  value,
  onChange = settings_noop,
  settings
}) => {
  if (!settings || !settings.length) {
    return null;
  }
  const handleSettingChange = setting => newValue => {
    onChange({
      ...value,
      [setting.id]: newValue
    });
  };
  const theSettings = settings.map(setting => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.CheckboxControl, {
    __nextHasNoMarginBottom: true,
    className: "block-editor-link-control__setting",
    label: setting.title,
    onChange: handleSettingChange(setting),
    checked: value ? !!value[setting.id] : false,
    help: setting?.help
  }, setting.id));
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", {
    className: "block-editor-link-control__settings",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.VisuallyHidden, {
      as: "legend",
      children: (0,external_wp_i18n_namespaceObject.__)('Currently selected link settings')
    }), theSettings]
  });
};
/* harmony default export */ const link_control_settings = (LinkControlSettings);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/use-create-page.js
/**
 * WordPress dependencies
 */


function useCreatePage(handleCreatePage) {
  const cancelableCreateSuggestion = (0,external_wp_element_namespaceObject.useRef)();
  const [isCreatingPage, setIsCreatingPage] = (0,external_wp_element_namespaceObject.useState)(false);
  const [errorMessage, setErrorMessage] = (0,external_wp_element_namespaceObject.useState)(null);
  const createPage = async function (suggestionTitle) {
    setIsCreatingPage(true);
    setErrorMessage(null);
    try {
      // Make cancellable in order that we can avoid setting State
      // if the component unmounts during the call to `createSuggestion`
      cancelableCreateSuggestion.current = makeCancelable(
      // Using Promise.resolve to allow createSuggestion to return a
      // non-Promise based value.
      Promise.resolve(handleCreatePage(suggestionTitle)));
      return await cancelableCreateSuggestion.current.promise;
    } catch (error) {
      if (error && error.isCanceled) {
        return; // bail if canceled to avoid setting state
      }
      setErrorMessage(error.message || (0,external_wp_i18n_namespaceObject.__)('An unknown error occurred during creation. Please try again.'));
      throw error;
    } finally {
      setIsCreatingPage(false);
    }
  };

  /**
   * Handles cancelling any pending Promises that have been made cancelable.
   */
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    return () => {
      // componentDidUnmount
      if (cancelableCreateSuggestion.current) {
        cancelableCreateSuggestion.current.cancel();
      }
    };
  }, []);
  return {
    createPage,
    isCreatingPage,
    errorMessage
  };
}

/**
 * Creates a wrapper around a promise which allows it to be programmatically
 * cancelled.
 * See: https://reactjs.org/blog/2015/12/16/ismounted-antipattern.html
 *
 * @param {Promise} promise the Promise to make cancelable
 */
const makeCancelable = promise => {
  let hasCanceled_ = false;
  const wrappedPromise = new Promise((resolve, reject) => {
    promise.then(val => hasCanceled_ ? reject({
      isCanceled: true
    }) : resolve(val), error => hasCanceled_ ? reject({
      isCanceled: true
    }) : reject(error));
  });
  return {
    promise: wrappedPromise,
    cancel() {
      hasCanceled_ = true;
    }
  };
};

// EXTERNAL MODULE: ./node_modules/fast-deep-equal/index.js
var fast_deep_equal = __webpack_require__(5215);
var fast_deep_equal_default = /*#__PURE__*/__webpack_require__.n(fast_deep_equal);
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/use-internal-value.js
/**
 * WordPress dependencies
 */


/**
 * External dependencies
 */

function useInternalValue(value) {
  const [internalValue, setInternalValue] = (0,external_wp_element_namespaceObject.useState)(value || {});
  const [previousValue, setPreviousValue] = (0,external_wp_element_namespaceObject.useState)(value);

  // If the value prop changes, update the internal state.
  // See:
  // - https://github.com/WordPress/gutenberg/pull/51387#issuecomment-1722927384.
  // - https://react.dev/reference/react/useState#storing-information-from-previous-renders.
  if (!fast_deep_equal_default()(value, previousValue)) {
    setPreviousValue(value);
    setInternalValue(value);
  }
  const setInternalURLInputValue = nextValue => {
    setInternalValue({
      ...internalValue,
      url: nextValue
    });
  };
  const setInternalTextInputValue = nextValue => {
    setInternalValue({
      ...internalValue,
      title: nextValue
    });
  };
  const createSetInternalSettingValueHandler = settingsKeys => nextValue => {
    // Only apply settings values which are defined in the settings prop.
    const settingsUpdates = Object.keys(nextValue).reduce((acc, key) => {
      if (settingsKeys.includes(key)) {
        acc[key] = nextValue[key];
      }
      return acc;
    }, {});
    setInternalValue({
      ...internalValue,
      ...settingsUpdates
    });
  };
  return [internalValue, setInternalValue, setInternalURLInputValue, setInternalTextInputValue, createSetInternalSettingValueHandler];
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */










/**
 * Internal dependencies
 */









/**
 * Default properties associated with a link control value.
 *
 * @typedef WPLinkControlDefaultValue
 *
 * @property {string}   url           Link URL.
 * @property {string=}  title         Link title.
 * @property {boolean=} opensInNewTab Whether link should open in a new browser
 *                                    tab. This value is only assigned if not
 *                                    providing a custom `settings` prop.
 */

/* eslint-disable jsdoc/valid-types */
/**
 * Custom settings values associated with a link.
 *
 * @typedef {{[setting:string]:any}} WPLinkControlSettingsValue
 */
/* eslint-enable */

/**
 * Custom settings values associated with a link.
 *
 * @typedef WPLinkControlSetting
 *
 * @property {string} id    Identifier to use as property for setting value.
 * @property {string} title Human-readable label to show in user interface.
 */

/**
 * Properties associated with a link control value, composed as a union of the
 * default properties and any custom settings values.
 *
 * @typedef {WPLinkControlDefaultValue&WPLinkControlSettingsValue} WPLinkControlValue
 */

/** @typedef {(nextValue:WPLinkControlValue)=>void} WPLinkControlOnChangeProp */

/**
 * Properties associated with a search suggestion used within the LinkControl.
 *
 * @typedef WPLinkControlSuggestion
 *
 * @property {string} id    Identifier to use to uniquely identify the suggestion.
 * @property {string} type  Identifies the type of the suggestion (eg: `post`,
 *                          `page`, `url`...etc)
 * @property {string} title Human-readable label to show in user interface.
 * @property {string} url   A URL for the suggestion.
 */

/** @typedef {(title:string)=>WPLinkControlSuggestion} WPLinkControlCreateSuggestionProp */

/**
 * @typedef WPLinkControlProps
 *
 * @property {(WPLinkControlSetting[])=}  settings                   An array of settings objects. Each object will used to
 *                                                                   render a `ToggleControl` for that setting.
 * @property {boolean=}                   forceIsEditingLink         If passed as either `true` or `false`, controls the
 *                                                                   internal editing state of the component to respective
 *                                                                   show or not show the URL input field.
 * @property {WPLinkControlValue=}        value                      Current link value.
 * @property {WPLinkControlOnChangeProp=} onChange                   Value change handler, called with the updated value if
 *                                                                   the user selects a new link or updates settings.
 * @property {boolean=}                   noDirectEntry              Whether to allow turning a URL-like search query directly into a link.
 * @property {boolean=}                   showSuggestions            Whether to present suggestions when typing the URL.
 * @property {boolean=}                   showInitialSuggestions     Whether to present initial suggestions immediately.
 * @property {boolean=}                   withCreateSuggestion       Whether to allow creation of link value from suggestion.
 * @property {Object=}                    suggestionsQuery           Query parameters to pass along to wp.blockEditor.__experimentalFetchLinkSuggestions.
 * @property {boolean=}                   noURLSuggestion            Whether to add a fallback suggestion which treats the search query as a URL.
 * @property {boolean=}                   hasTextControl             Whether to add a text field to the UI to update the value.title.
 * @property {string|Function|undefined}  createSuggestionButtonText The text to use in the button that calls createSuggestion.
 * @property {Function}                   renderControlBottom        Optional controls to be rendered at the bottom of the component.
 */



const link_control_noop = () => {};
const PREFERENCE_SCOPE = 'core/block-editor';
const PREFERENCE_KEY = 'linkControlSettingsDrawer';

/**
 * Renders a link control. A link control is a controlled input which maintains
 * a value associated with a link (HTML anchor element) and relevant settings
 * for how that link is expected to behave.
 *
 * @param {WPLinkControlProps} props Component props.
 */
function LinkControl({
  searchInputPlaceholder,
  value,
  settings = DEFAULT_LINK_SETTINGS,
  onChange = link_control_noop,
  onRemove,
  onCancel,
  noDirectEntry = false,
  showSuggestions = true,
  showInitialSuggestions,
  forceIsEditingLink,
  createSuggestion,
  withCreateSuggestion,
  inputValue: propInputValue = '',
  suggestionsQuery = {},
  noURLSuggestion = false,
  createSuggestionButtonText,
  hasRichPreviews = false,
  hasTextControl = false,
  renderControlBottom = null
}) {
  if (withCreateSuggestion === undefined && createSuggestion) {
    withCreateSuggestion = true;
  }
  const [settingsOpen, setSettingsOpen] = (0,external_wp_element_namespaceObject.useState)(false);
  const {
    advancedSettingsPreference
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    var _prefsStore$get;
    const prefsStore = select(external_wp_preferences_namespaceObject.store);
    return {
      advancedSettingsPreference: (_prefsStore$get = prefsStore.get(PREFERENCE_SCOPE, PREFERENCE_KEY)) !== null && _prefsStore$get !== void 0 ? _prefsStore$get : false
    };
  }, []);
  const {
    set: setPreference
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_preferences_namespaceObject.store);

  /**
   * Sets the open/closed state of the Advanced Settings Drawer,
   * optionlly persisting the state to the user's preferences.
   *
   * Note that Block Editor components can be consumed by non-WordPress
   * environments which may not have preferences setup.
   * Therefore a local state is also  used as a fallback.
   *
   * @param {boolean} prefVal the open/closed state of the Advanced Settings Drawer.
   */
  const setSettingsOpenWithPreference = prefVal => {
    if (setPreference) {
      setPreference(PREFERENCE_SCOPE, PREFERENCE_KEY, prefVal);
    }
    setSettingsOpen(prefVal);
  };

  // Block Editor components can be consumed by non-WordPress environments
  // which may not have these preferences setup.
  // Therefore a local state is used as a fallback.
  const isSettingsOpen = advancedSettingsPreference || settingsOpen;
  const isMounting = (0,external_wp_element_namespaceObject.useRef)(true);
  const wrapperNode = (0,external_wp_element_namespaceObject.useRef)();
  const textInputRef = (0,external_wp_element_namespaceObject.useRef)();
  const isEndingEditWithFocus = (0,external_wp_element_namespaceObject.useRef)(false);
  const settingsKeys = settings.map(({
    id
  }) => id);
  const [internalControlValue, setInternalControlValue, setInternalURLInputValue, setInternalTextInputValue, createSetInternalSettingValueHandler] = useInternalValue(value);
  const valueHasChanges = value && !(0,external_wp_isShallowEqual_namespaceObject.isShallowEqualObjects)(internalControlValue, value);
  const [isEditingLink, setIsEditingLink] = (0,external_wp_element_namespaceObject.useState)(forceIsEditingLink !== undefined ? forceIsEditingLink : !value || !value.url);
  const {
    createPage,
    isCreatingPage,
    errorMessage
  } = useCreatePage(createSuggestion);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (forceIsEditingLink === undefined) {
      return;
    }
    setIsEditingLink(forceIsEditingLink);
  }, [forceIsEditingLink]);
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    // We don't auto focus into the Link UI on mount
    // because otherwise using the keyboard to select text
    // *within* the link format is not possible.
    if (isMounting.current) {
      return;
    }

    // Scenario - when:
    // - switching between editable and non editable LinkControl
    // - clicking on a link
    // ...then move focus to the *first* element to avoid focus loss
    // and to ensure focus is *within* the Link UI.
    const nextFocusTarget = external_wp_dom_namespaceObject.focus.focusable.find(wrapperNode.current)[0] || wrapperNode.current;
    nextFocusTarget.focus();
    isEndingEditWithFocus.current = false;
  }, [isEditingLink, isCreatingPage]);

  // The component mounting reference is maintained separately
  // to correctly reset values in `StrictMode`.
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    isMounting.current = false;
    return () => {
      isMounting.current = true;
    };
  }, []);
  const hasLinkValue = value?.url?.trim()?.length > 0;

  /**
   * Cancels editing state and marks that focus may need to be restored after
   * the next render, if focus was within the wrapper when editing finished.
   */
  const stopEditing = () => {
    isEndingEditWithFocus.current = !!wrapperNode.current?.contains(wrapperNode.current.ownerDocument.activeElement);
    setIsEditingLink(false);
  };
  const handleSelectSuggestion = updatedValue => {
    // Suggestions may contains "settings" values (e.g. `opensInNewTab`)
    // which should not overide any existing settings values set by the
    // user. This filters out any settings values from the suggestion.
    const nonSettingsChanges = Object.keys(updatedValue).reduce((acc, key) => {
      if (!settingsKeys.includes(key)) {
        acc[key] = updatedValue[key];
      }
      return acc;
    }, {});
    onChange({
      ...internalControlValue,
      ...nonSettingsChanges,
      // As title is not a setting, it must be manually applied
      // in such a way as to preserve the users changes over
      // any "title" value provided by the "suggestion".
      title: internalControlValue?.title || updatedValue?.title
    });
    stopEditing();
  };
  const handleSubmit = () => {
    if (valueHasChanges) {
      // Submit the original value with new stored values applied
      // on top. URL is a special case as it may also be a prop.
      onChange({
        ...value,
        ...internalControlValue,
        url: currentUrlInputValue
      });
    }
    stopEditing();
  };
  const handleSubmitWithEnter = event => {
    const {
      keyCode
    } = event;
    if (keyCode === external_wp_keycodes_namespaceObject.ENTER && !currentInputIsEmpty // Disallow submitting empty values.
    ) {
      event.preventDefault();
      handleSubmit();
    }
  };
  const resetInternalValues = () => {
    setInternalControlValue(value);
  };
  const handleCancel = event => {
    event.preventDefault();
    event.stopPropagation();

    // Ensure that any unsubmitted input changes are reset.
    resetInternalValues();
    if (hasLinkValue) {
      // If there is a link then exist editing mode and show preview.
      stopEditing();
    } else {
      // If there is no link value, then remove the link entirely.
      onRemove?.();
    }
    onCancel?.();
  };
  const currentUrlInputValue = propInputValue || internalControlValue?.url || '';
  const currentInputIsEmpty = !currentUrlInputValue?.trim()?.length;
  const shownUnlinkControl = onRemove && value && !isEditingLink && !isCreatingPage;
  const showActions = isEditingLink && hasLinkValue;

  // Only show text control once a URL value has been committed
  // and it isn't just empty whitespace.
  // See https://github.com/WordPress/gutenberg/pull/33849/#issuecomment-932194927.
  const showTextControl = hasLinkValue && hasTextControl;
  const isEditing = (isEditingLink || !value) && !isCreatingPage;
  const isDisabled = !valueHasChanges || currentInputIsEmpty;
  const showSettings = !!settings?.length && isEditingLink && hasLinkValue;
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
    tabIndex: -1,
    ref: wrapperNode,
    className: "block-editor-link-control",
    children: [isCreatingPage && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
      className: "block-editor-link-control__loading",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Spinner, {}), " ", (0,external_wp_i18n_namespaceObject.__)('Creating'), "\u2026"]
    }), isEditing && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
        className: dist_clsx({
          'block-editor-link-control__search-input-wrapper': true,
          'has-text-control': showTextControl,
          'has-actions': showActions
        }),
        children: [showTextControl && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.TextControl, {
          __nextHasNoMarginBottom: true,
          ref: textInputRef,
          className: "block-editor-link-control__field block-editor-link-control__text-content",
          label: (0,external_wp_i18n_namespaceObject.__)('Text'),
          value: internalControlValue?.title,
          onChange: setInternalTextInputValue,
          onKeyDown: handleSubmitWithEnter,
          size: "__unstable-large"
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(search_input, {
          currentLink: value,
          className: "block-editor-link-control__field block-editor-link-control__search-input",
          placeholder: searchInputPlaceholder,
          value: currentUrlInputValue,
          withCreateSuggestion: withCreateSuggestion,
          onCreateSuggestion: createPage,
          onChange: setInternalURLInputValue,
          onSelect: handleSelectSuggestion,
          showInitialSuggestions: showInitialSuggestions,
          allowDirectEntry: !noDirectEntry,
          showSuggestions: showSuggestions,
          suggestionsQuery: suggestionsQuery,
          withURLSuggestion: !noURLSuggestion,
          createSuggestionButtonText: createSuggestionButtonText,
          hideLabelFromVision: !showTextControl
        }), !showActions && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
          className: "block-editor-link-control__search-enter",
          children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
            onClick: isDisabled ? link_control_noop : handleSubmit,
            label: (0,external_wp_i18n_namespaceObject.__)('Submit'),
            icon: keyboard_return,
            className: "block-editor-link-control__search-submit",
            "aria-disabled": isDisabled
          })
        })]
      }), errorMessage && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Notice, {
        className: "block-editor-link-control__search-error",
        status: "error",
        isDismissible: false,
        children: errorMessage
      })]
    }), value && !isEditingLink && !isCreatingPage && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(LinkPreview, {
      // force remount when URL changes to avoid race conditions for rich previews
      value: value,
      onEditClick: () => setIsEditingLink(true),
      hasRichPreviews: hasRichPreviews,
      hasUnlinkControl: shownUnlinkControl,
      onRemove: () => {
        onRemove();
        setIsEditingLink(true);
      }
    }, value?.url), showSettings && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: "block-editor-link-control__tools",
      children: !currentInputIsEmpty && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(settings_drawer, {
        settingsOpen: isSettingsOpen,
        setSettingsOpen: setSettingsOpenWithPreference,
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(link_control_settings, {
          value: internalControlValue,
          settings: settings,
          onChange: createSetInternalSettingValueHandler(settingsKeys)
        })
      })
    }), showActions && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
      justify: "right",
      className: "block-editor-link-control__search-actions",
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
        variant: "tertiary",
        onClick: handleCancel,
        children: (0,external_wp_i18n_namespaceObject.__)('Cancel')
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
        variant: "primary",
        onClick: isDisabled ? link_control_noop : handleSubmit,
        className: "block-editor-link-control__search-submit",
        "aria-disabled": isDisabled,
        children: (0,external_wp_i18n_namespaceObject.__)('Save')
      })]
    }), !isCreatingPage && renderControlBottom && renderControlBottom()]
  });
}
LinkControl.ViewerFill = ViewerFill;
LinkControl.DEFAULT_LINK_SETTINGS = DEFAULT_LINK_SETTINGS;
/* harmony default export */ const link_control = (LinkControl);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/media-replace-flow/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */











/**
 * Internal dependencies
 */







const media_replace_flow_noop = () => {};
let uniqueId = 0;
const MediaReplaceFlow = ({
  mediaURL,
  mediaId,
  mediaIds,
  allowedTypes,
  accept,
  onError,
  onSelect,
  onSelectURL,
  onToggleFeaturedImage,
  useFeaturedImage,
  onFilesUpload = media_replace_flow_noop,
  name = (0,external_wp_i18n_namespaceObject.__)('Replace'),
  createNotice,
  removeNotice,
  children,
  multiple = false,
  addToGallery,
  handleUpload = true,
  popoverProps
}) => {
  const mediaUpload = (0,external_wp_data_namespaceObject.useSelect)(select => {
    return select(store).getSettings().mediaUpload;
  }, []);
  const canUpload = !!mediaUpload;
  const editMediaButtonRef = (0,external_wp_element_namespaceObject.useRef)();
  const errorNoticeID = `block-editor/media-replace-flow/error-notice/${++uniqueId}`;
  const onUploadError = message => {
    const safeMessage = (0,external_wp_dom_namespaceObject.__unstableStripHTML)(message);
    if (onError) {
      onError(safeMessage);
      return;
    }
    // We need to set a timeout for showing the notice
    // so that VoiceOver and possibly other screen readers
    // can announce the error afer the toolbar button
    // regains focus once the upload dialog closes.
    // Otherwise VO simply skips over the notice and announces
    // the focused element and the open menu.
    setTimeout(() => {
      createNotice('error', safeMessage, {
        speak: true,
        id: errorNoticeID,
        isDismissible: true
      });
    }, 1000);
  };
  const selectMedia = (media, closeMenu) => {
    if (useFeaturedImage && onToggleFeaturedImage) {
      onToggleFeaturedImage();
    }
    closeMenu();
    // Calling `onSelect` after the state update since it might unmount the component.
    onSelect(media);
    (0,external_wp_a11y_namespaceObject.speak)((0,external_wp_i18n_namespaceObject.__)('The media file has been replaced'));
    removeNotice(errorNoticeID);
  };
  const uploadFiles = (event, closeMenu) => {
    const files = event.target.files;
    if (!handleUpload) {
      closeMenu();
      return onSelect(files);
    }
    onFilesUpload(files);
    mediaUpload({
      allowedTypes,
      filesList: files,
      onFileChange: ([media]) => {
        selectMedia(media, closeMenu);
      },
      onError: onUploadError
    });
  };
  const openOnArrowDown = event => {
    if (event.keyCode === external_wp_keycodes_namespaceObject.DOWN) {
      event.preventDefault();
      event.target.click();
    }
  };
  const onlyAllowsImages = () => {
    if (!allowedTypes || allowedTypes.length === 0) {
      return false;
    }
    return allowedTypes.every(allowedType => allowedType === 'image' || allowedType.startsWith('image/'));
  };
  const gallery = multiple && onlyAllowsImages();
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Dropdown, {
    popoverProps: popoverProps,
    contentClassName: "block-editor-media-replace-flow__options",
    renderToggle: ({
      isOpen,
      onToggle
    }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ToolbarButton, {
      ref: editMediaButtonRef,
      "aria-expanded": isOpen,
      "aria-haspopup": "true",
      onClick: onToggle,
      onKeyDown: openOnArrowDown,
      children: name
    }),
    renderContent: ({
      onClose
    }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.NavigableMenu, {
        className: "block-editor-media-replace-flow__media-upload-menu",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(check, {
          children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(media_upload, {
            gallery: gallery,
            addToGallery: addToGallery,
            multiple: multiple,
            value: multiple ? mediaIds : mediaId,
            onSelect: media => selectMedia(media, onClose),
            allowedTypes: allowedTypes,
            render: ({
              open
            }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
              icon: library_media,
              onClick: open,
              children: (0,external_wp_i18n_namespaceObject.__)('Open Media Library')
            })
          }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FormFileUpload, {
            onChange: event => {
              uploadFiles(event, onClose);
            },
            accept: accept,
            multiple: !!multiple,
            render: ({
              openFileDialog
            }) => {
              return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
                icon: library_upload,
                onClick: () => {
                  openFileDialog();
                },
                children: (0,external_wp_i18n_namespaceObject.__)('Upload')
              });
            }
          })]
        }), onToggleFeaturedImage && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
          icon: post_featured_image,
          onClick: onToggleFeaturedImage,
          isPressed: useFeaturedImage,
          children: (0,external_wp_i18n_namespaceObject.__)('Use featured image')
        }), children]
      }), onSelectURL &&
      /*#__PURE__*/
      // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
      (0,external_ReactJSXRuntime_namespaceObject.jsxs)("form", {
        className: dist_clsx('block-editor-media-flow__url-input', {
          'has-siblings': canUpload || onToggleFeaturedImage
        }),
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
          className: "block-editor-media-replace-flow__image-url-label",
          children: (0,external_wp_i18n_namespaceObject.__)('Current media URL:')
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(link_control, {
          value: {
            url: mediaURL
          },
          settings: [],
          showSuggestions: false,
          onChange: ({
            url
          }) => {
            onSelectURL(url);
            editMediaButtonRef.current.focus();
          }
        })]
      })]
    })
  });
};

/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/media-replace-flow/README.md
 */
/* harmony default export */ const media_replace_flow = ((0,external_wp_compose_namespaceObject.compose)([(0,external_wp_data_namespaceObject.withDispatch)(dispatch => {
  const {
    createNotice,
    removeNotice
  } = dispatch(external_wp_notices_namespaceObject.store);
  return {
    createNotice,
    removeNotice
  };
}), (0,external_wp_components_namespaceObject.withFilters)('editor.MediaReplaceFlow')])(MediaReplaceFlow));

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/global-styles/theme-file-uri-utils.js
/**
 * Internal dependencies
 */


/**
 * Looks up a theme file URI based on a relative path.
 *
 * @param {string}        file          A relative path.
 * @param {Array<Object>} themeFileURIs A collection of absolute theme file URIs and their corresponding file paths.
 * @return {string?} A resolved theme file URI, if one is found in the themeFileURIs collection.
 */
function getResolvedThemeFilePath(file, themeFileURIs = []) {
  const uri = themeFileURIs.find(themeFileUri => themeFileUri.name === file);
  if (!uri?.href) {
    return file;
  }
  return uri?.href;
}

/**
 * Mutates an object by settings a value at the provided path.
 *
 * @param {Object}              object Object to set a value in.
 * @param {number|string|Array} path   Path in the object to modify.
 * @param {*}                   value  New value to set.
 * @return {Object} Object with the new value set.
 */
function setMutably(object, path, value) {
  path = path.split('.');
  const finalValueKey = path.pop();
  let prev = object;
  for (const key of path) {
    const current = prev[key];
    prev = current;
  }
  prev[finalValueKey] = value;
  return object;
}

/**
 * Resolves any relative paths if a corresponding theme file URI is available.
 * Note: this function mutates the object and is specifically to be used in
 * an async styles build context in useGlobalStylesOutput
 *
 * @param {Object}        themeJson     Theme.json/Global styles tree.
 * @param {Array<Object>} themeFileURIs A collection of absolute theme file URIs and their corresponding file paths.
 * @return {Object} Returns mutated object.
 */
function setThemeFileUris(themeJson, themeFileURIs) {
  if (!themeJson?.styles || !themeFileURIs) {
    return themeJson;
  }
  themeFileURIs.forEach(({
    name,
    href,
    target
  }) => {
    const value = getValueFromObjectPath(themeJson, target);
    if (value === name) {
      /*
       * The object must not be updated immutably here because the
       * themeJson is a reference to the global styles tree used as a dependency in the
       * useGlobalStylesOutputWithConfig() hook. If we don't mutate the object,
       * the hook will detect the change and re-render the component, resulting
       * in a maximum depth exceeded error.
       */
      themeJson = setMutably(themeJson, target, href);
    }
  });
  return themeJson;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/global-styles/background-panel.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */









/**
 * Internal dependencies
 */







const IMAGE_BACKGROUND_TYPE = 'image';
const background_panel_DEFAULT_CONTROLS = {
  backgroundImage: true,
  backgroundSize: false
};

/**
 * Checks site settings to see if the background panel may be used.
 * `settings.background.backgroundSize` exists also,
 * but can only be used if settings?.background?.backgroundImage is `true`.
 *
 * @param {Object} settings Site settings
 * @return {boolean}        Whether site settings has activated background panel.
 */
function useHasBackgroundPanel(settings) {
  return external_wp_element_namespaceObject.Platform.OS === 'web' && settings?.background?.backgroundImage;
}

/**
 * Checks if there is a current value in the background size block support
 * attributes. Background size values include background size as well
 * as background position.
 *
 * @param {Object} style Style attribute.
 * @return {boolean}     Whether the block has a background size value set.
 */
function hasBackgroundSizeValue(style) {
  return style?.background?.backgroundPosition !== undefined || style?.background?.backgroundSize !== undefined;
}

/**
 * Checks if there is a current value in the background image block support
 * attributes.
 *
 * @param {Object} style Style attribute.
 * @return {boolean}     Whether the block has a background image value set.
 */
function hasBackgroundImageValue(style) {
  return !!style?.background?.backgroundImage?.id ||
  // Supports url() string values in theme.json.
  'string' === typeof style?.background?.backgroundImage || !!style?.background?.backgroundImage?.url;
}

/**
 * Get the help text for the background size control.
 *
 * @param {string} value backgroundSize value.
 * @return {string}      Translated help text.
 */
function backgroundSizeHelpText(value) {
  if (value === 'cover' || value === undefined) {
    return (0,external_wp_i18n_namespaceObject.__)('Image covers the space evenly.');
  }
  if (value === 'contain') {
    return (0,external_wp_i18n_namespaceObject.__)('Image is contained without distortion.');
  }
  return (0,external_wp_i18n_namespaceObject.__)('Image has a fixed width.');
}

/**
 * Converts decimal x and y coords from FocalPointPicker to percentage-based values
 * to use as backgroundPosition value.
 *
 * @param {{x?:number, y?:number}} value FocalPointPicker coords.
 * @return {string}      				 backgroundPosition value.
 */
const coordsToBackgroundPosition = value => {
  if (!value || isNaN(value.x) && isNaN(value.y)) {
    return undefined;
  }
  const x = isNaN(value.x) ? 0.5 : value.x;
  const y = isNaN(value.y) ? 0.5 : value.y;
  return `${x * 100}% ${y * 100}%`;
};

/**
 * Converts backgroundPosition value to x and y coords for FocalPointPicker.
 *
 * @param {string} value backgroundPosition value.
 * @return {{x?:number, y?:number}}       FocalPointPicker coords.
 */
const backgroundPositionToCoords = value => {
  if (!value) {
    return {
      x: undefined,
      y: undefined
    };
  }
  let [x, y] = value.split(' ').map(v => parseFloat(v) / 100);
  x = isNaN(x) ? undefined : x;
  y = isNaN(y) ? x : y;
  return {
    x,
    y
  };
};
function InspectorImagePreview({
  label,
  filename,
  url: imgUrl
}) {
  const imgLabel = label || (0,external_wp_url_namespaceObject.getFilename)(imgUrl) || (0,external_wp_i18n_namespaceObject.__)('Add background image');
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalItemGroup, {
    as: "span",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
      justify: imgUrl ? 'flex-start' : 'center',
      as: "span",
      children: [imgUrl && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
        className: dist_clsx('block-editor-global-styles-background-panel__inspector-image-indicator-wrapper', {
          'has-image': imgUrl
        }),
        "aria-hidden": true,
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("span", {
          className: "block-editor-global-styles-background-panel__inspector-image-indicator",
          style: {
            backgroundImage: `url(${imgUrl})`
          }
        })
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.FlexItem, {
        as: "span",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalTruncate, {
          numberOfLines: 1,
          className: "block-editor-global-styles-background-panel__inspector-media-replace-title",
          children: imgLabel
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.VisuallyHidden, {
          as: "span",
          children: imgUrl ? (0,external_wp_i18n_namespaceObject.sprintf)( /* translators: %s: file name */
          (0,external_wp_i18n_namespaceObject.__)('Background image: %s'), filename || imgLabel) : (0,external_wp_i18n_namespaceObject.__)('No background image selected')
        })]
      })]
    })
  });
}
function BackgroundImageToolsPanelItem({
  panelId,
  isShownByDefault,
  onChange,
  style,
  inheritedValue,
  themeFileURIs
}) {
  const mediaUpload = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).getSettings().mediaUpload, []);
  const {
    id,
    title,
    url
  } = style?.background?.backgroundImage || {
    ...inheritedValue?.background?.backgroundImage
  };
  const replaceContainerRef = (0,external_wp_element_namespaceObject.useRef)();
  const {
    createErrorNotice
  } = (0,external_wp_data_namespaceObject.useDispatch)(external_wp_notices_namespaceObject.store);
  const onUploadError = message => {
    createErrorNotice(message, {
      type: 'snackbar'
    });
  };
  const resetBackgroundImage = () => onChange(setImmutably(style, ['background', 'backgroundImage'], undefined));
  const onSelectMedia = media => {
    if (!media || !media.url) {
      resetBackgroundImage();
      return;
    }
    if ((0,external_wp_blob_namespaceObject.isBlobURL)(media.url)) {
      return;
    }

    // For media selections originated from a file upload.
    if (media.media_type && media.media_type !== IMAGE_BACKGROUND_TYPE || !media.media_type && media.type && media.type !== IMAGE_BACKGROUND_TYPE) {
      onUploadError((0,external_wp_i18n_namespaceObject.__)('Only images can be used as a background image.'));
      return;
    }
    const sizeValue = style?.background?.backgroundSize;
    const positionValue = style?.background?.backgroundPosition;
    onChange(setImmutably(style, ['background'], {
      ...style?.background,
      backgroundImage: {
        url: media.url,
        id: media.id,
        source: 'file',
        title: media.title || undefined
      },
      backgroundPosition: !positionValue && ('auto' === sizeValue || !sizeValue) ? '50% 0' : positionValue
    }));
  };
  const onFilesDrop = filesList => {
    mediaUpload({
      allowedTypes: [IMAGE_BACKGROUND_TYPE],
      filesList,
      onFileChange([image]) {
        if ((0,external_wp_blob_namespaceObject.isBlobURL)(image?.url)) {
          return;
        }
        onSelectMedia(image);
      },
      onError: onUploadError
    });
  };
  const resetAllFilter = (0,external_wp_element_namespaceObject.useCallback)(previousValue => {
    return {
      ...previousValue,
      style: {
        ...previousValue.style,
        background: undefined
      }
    };
  }, []);
  const hasValue = hasBackgroundImageValue(style);
  const closeAndFocus = () => {
    const [toggleButton] = external_wp_dom_namespaceObject.focus.tabbable.find(replaceContainerRef.current);
    // Focus the toggle button and close the dropdown menu.
    // This ensures similar behaviour as to selecting an image, where the dropdown is
    // closed and focus is redirected to the dropdown toggle button.
    toggleButton?.focus();
    toggleButton?.click();
  };
  const onRemove = () => onChange(setImmutably(style, ['background', 'backgroundImage'], 'none'));
  const canRemove = !hasValue && hasBackgroundImageValue(inheritedValue);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
    className: "single-column",
    hasValue: () => hasValue,
    label: (0,external_wp_i18n_namespaceObject.__)('Background image'),
    onDeselect: resetBackgroundImage,
    isShownByDefault: isShownByDefault,
    resetAllFilter: resetAllFilter,
    panelId: panelId,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
      className: "block-editor-global-styles-background-panel__inspector-media-replace-container",
      ref: replaceContainerRef,
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(media_replace_flow, {
        mediaId: id,
        mediaURL: url,
        allowedTypes: [IMAGE_BACKGROUND_TYPE],
        accept: "image/*",
        onSelect: onSelectMedia,
        name: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(InspectorImagePreview, {
          label: title,
          filename: title,
          url: getResolvedThemeFilePath(url, themeFileURIs)
        }),
        variant: "secondary",
        children: [canRemove && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
          onClick: () => {
            closeAndFocus();
            onRemove();
          },
          children: (0,external_wp_i18n_namespaceObject.__)('Remove')
        }), hasValue && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.MenuItem, {
          onClick: () => {
            closeAndFocus();
            resetBackgroundImage();
          },
          children: (0,external_wp_i18n_namespaceObject.__)('Reset ')
        })]
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.DropZone, {
        onFilesDrop: onFilesDrop,
        label: (0,external_wp_i18n_namespaceObject.__)('Drop to upload')
      })]
    })
  });
}
function BackgroundSizeToolsPanelItem({
  panelId,
  isShownByDefault,
  onChange,
  style,
  inheritedValue,
  defaultValues,
  themeFileURIs
}) {
  const sizeValue = style?.background?.backgroundSize || inheritedValue?.background?.backgroundSize;
  const repeatValue = style?.background?.backgroundRepeat || inheritedValue?.background?.backgroundRepeat;
  const imageValue = style?.background?.backgroundImage?.url || inheritedValue?.background?.backgroundImage?.url;
  const positionValue = style?.background?.backgroundPosition || inheritedValue?.background?.backgroundPosition;

  /*
   * An `undefined` value is replaced with any supplied
   * default control value for the toggle group control.
   * An empty string is treated as `auto` - this allows a user
   * to select "Size" and then enter a custom value, with an
   * empty value being treated as `auto`.
   */
  const currentValueForToggle = sizeValue !== undefined && sizeValue !== 'cover' && sizeValue !== 'contain' || sizeValue === '' ? 'auto' : sizeValue || defaultValues?.backgroundSize;

  /*
   * If the current value is `cover` and the repeat value is `undefined`, then
   * the toggle should be unchecked as the default state. Otherwise, the toggle
   * should reflect the current repeat value.
   */
  const repeatCheckedValue = !(repeatValue === 'no-repeat' || currentValueForToggle === 'cover' && repeatValue === undefined);
  const hasValue = hasBackgroundSizeValue(style);
  const resetAllFilter = (0,external_wp_element_namespaceObject.useCallback)(previousValue => {
    return {
      ...previousValue,
      style: {
        ...previousValue.style,
        background: {
          ...previousValue.style?.background,
          backgroundRepeat: undefined,
          backgroundSize: undefined
        }
      }
    };
  }, []);
  const updateBackgroundSize = next => {
    // When switching to 'contain' toggle the repeat off.
    let nextRepeat = repeatValue;
    let nextPosition = positionValue;
    if (next === 'contain') {
      nextRepeat = 'no-repeat';
      nextPosition = undefined;
    }
    if (next === 'cover') {
      nextRepeat = undefined;
      nextPosition = undefined;
    }
    if ((currentValueForToggle === 'cover' || currentValueForToggle === 'contain') && next === 'auto') {
      nextRepeat = undefined;
      /*
       * A background image uploaded and set in the editor (an image with a record id),
       * receives a default background position of '50% 0',
       * when the toggle switches to "Tile". This is to increase the chance that
       * the image's focus point is visible.
       */
      if (!!style?.background?.backgroundImage?.id) {
        nextPosition = '50% 0';
      }
    }

    /*
     * Next will be null when the input is cleared,
     * in which case the value should be 'auto'.
     */
    if (!next && currentValueForToggle === 'auto') {
      next = 'auto';
    }
    onChange(setImmutably(style, ['background'], {
      ...style?.background,
      backgroundPosition: nextPosition,
      backgroundRepeat: nextRepeat,
      backgroundSize: next
    }));
  };
  const updateBackgroundPosition = next => {
    onChange(setImmutably(style, ['background', 'backgroundPosition'], coordsToBackgroundPosition(next)));
  };
  const toggleIsRepeated = () => onChange(setImmutably(style, ['background', 'backgroundRepeat'], repeatCheckedValue === true ? 'no-repeat' : 'repeat'));
  const resetBackgroundSize = () => onChange(setImmutably(style, ['background'], {
    ...style?.background,
    backgroundPosition: undefined,
    backgroundRepeat: undefined,
    backgroundSize: undefined
  }));
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
    as: external_wp_components_namespaceObject.__experimentalToolsPanelItem,
    spacing: 2,
    className: "single-column",
    hasValue: () => hasValue,
    label: (0,external_wp_i18n_namespaceObject.__)('Size'),
    onDeselect: resetBackgroundSize,
    isShownByDefault: isShownByDefault,
    resetAllFilter: resetAllFilter,
    panelId: panelId,
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FocalPointPicker, {
      __next40pxDefaultSize: true,
      label: (0,external_wp_i18n_namespaceObject.__)('Position'),
      url: getResolvedThemeFilePath(imageValue, themeFileURIs),
      value: backgroundPositionToCoords(positionValue),
      onChange: updateBackgroundPosition
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalToggleGroupControl, {
      size: "__unstable-large",
      label: (0,external_wp_i18n_namespaceObject.__)('Size'),
      value: currentValueForToggle,
      onChange: updateBackgroundSize,
      isBlock: true,
      help: backgroundSizeHelpText(sizeValue || defaultValues?.backgroundSize),
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOption, {
        value: "cover",
        label: (0,external_wp_i18n_namespaceObject.__)('Cover')
      }, "cover"), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOption, {
        value: "contain",
        label: (0,external_wp_i18n_namespaceObject.__)('Contain')
      }, "contain"), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToggleGroupControlOption, {
        value: "auto",
        label: (0,external_wp_i18n_namespaceObject.__)('Tile')
      }, "tile")]
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
      justify: "flex-start",
      spacing: 2,
      as: "span",
      children: [currentValueForToggle !== undefined && currentValueForToggle !== 'cover' && currentValueForToggle !== 'contain' ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalUnitControl, {
        "aria-label": (0,external_wp_i18n_namespaceObject.__)('Background image width'),
        onChange: updateBackgroundSize,
        value: sizeValue,
        size: "__unstable-large",
        __unstableInputWidth: "100px",
        min: 0,
        placeholder: (0,external_wp_i18n_namespaceObject.__)('Auto')
      }) : null, currentValueForToggle !== 'cover' && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ToggleControl, {
        label: (0,external_wp_i18n_namespaceObject.__)('Repeat'),
        checked: repeatCheckedValue,
        onChange: toggleIsRepeated
      })]
    })]
  });
}
function BackgroundToolsPanel({
  resetAllFilter,
  onChange,
  value,
  panelId,
  children,
  headerLabel
}) {
  const resetAll = () => {
    const updatedValue = resetAllFilter(value);
    onChange(updatedValue);
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalVStack, {
    as: external_wp_components_namespaceObject.__experimentalToolsPanel,
    spacing: 4,
    label: headerLabel,
    resetAll: resetAll,
    panelId: panelId,
    dropdownMenuProps: TOOLSPANEL_DROPDOWNMENU_PROPS,
    children: children
  });
}
function BackgroundPanel({
  as: Wrapper = BackgroundToolsPanel,
  value,
  onChange,
  inheritedValue = value,
  settings,
  panelId,
  defaultControls = background_panel_DEFAULT_CONTROLS,
  defaultValues = {},
  headerLabel = (0,external_wp_i18n_namespaceObject.__)('Background image'),
  themeFileURIs
}) {
  const resetAllFilter = (0,external_wp_element_namespaceObject.useCallback)(previousValue => {
    return {
      ...previousValue,
      background: {}
    };
  }, []);
  const shouldShowBackgroundSizeControls = settings?.background?.backgroundSize;
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(Wrapper, {
    resetAllFilter: resetAllFilter,
    value: value,
    onChange: onChange,
    panelId: panelId,
    headerLabel: headerLabel,
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BackgroundImageToolsPanelItem, {
      onChange: onChange,
      panelId: panelId,
      isShownByDefault: defaultControls.backgroundImage,
      style: value,
      inheritedValue: inheritedValue,
      themeFileURIs: themeFileURIs
    }), shouldShowBackgroundSizeControls && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BackgroundSizeToolsPanelItem, {
      onChange: onChange,
      panelId: panelId,
      isShownByDefault: defaultControls.backgroundSize,
      style: value,
      inheritedValue: inheritedValue,
      defaultValues: defaultValues,
      themeFileURIs: themeFileURIs
    })]
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/background.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





const BACKGROUND_SUPPORT_KEY = 'background';

// Initial control values where no block style is set.
const BACKGROUND_DEFAULT_VALUES = {
  backgroundSize: 'cover'
};

/**
 * Determine whether there is block support for background.
 *
 * @param {string} blockName Block name.
 * @param {string} feature   Background image feature to check for.
 *
 * @return {boolean} Whether there is support.
 */
function hasBackgroundSupport(blockName, feature = 'any') {
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockName, BACKGROUND_SUPPORT_KEY);
  if (support === true) {
    return true;
  }
  if (feature === 'any') {
    return !!support?.backgroundImage || !!support?.backgroundSize || !!support?.backgroundRepeat;
  }
  return !!support?.[feature];
}
function setBackgroundStyleDefaults(backgroundStyle) {
  if (!backgroundStyle) {
    return;
  }
  const backgroundImage = backgroundStyle?.backgroundImage;
  let backgroundStylesWithDefaults;

  // Set block background defaults.
  if (!!backgroundImage?.url) {
    if (!backgroundStyle?.backgroundSize) {
      backgroundStylesWithDefaults = {
        backgroundSize: 'cover'
      };
    }
    if ('contain' === backgroundStyle?.backgroundSize && !backgroundStyle?.backgroundPosition) {
      backgroundStylesWithDefaults = {
        backgroundPosition: 'center'
      };
    }
  }
  return backgroundStylesWithDefaults;
}
function background_useBlockProps({
  name,
  style
}) {
  if (!hasBackgroundSupport(name) || !style?.background?.backgroundImage) {
    return;
  }
  const backgroundStyles = setBackgroundStyleDefaults(style?.background);
  if (!backgroundStyles) {
    return;
  }
  return {
    style: {
      ...backgroundStyles
    }
  };
}

/**
 * Generates a CSS class name if an background image is set.
 *
 * @param {Object} style A block's style attribute.
 *
 * @return {string} CSS class name.
 */
function getBackgroundImageClasses(style) {
  return hasBackgroundImageValue(style) ? 'has-background' : '';
}
function BackgroundInspectorControl({
  children
}) {
  const resetAllFilter = (0,external_wp_element_namespaceObject.useCallback)(attributes => {
    return {
      ...attributes,
      style: {
        ...attributes.style,
        background: undefined
      }
    };
  }, []);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(inspector_controls, {
    group: "background",
    resetAllFilter: resetAllFilter,
    children: children
  });
}
function BackgroundImagePanel({
  clientId,
  name,
  setAttributes,
  settings
}) {
  const style = (0,external_wp_data_namespaceObject.useSelect)(select => select(store).getBlockAttributes(clientId)?.style, [clientId]);
  if (!useHasBackgroundPanel(settings) || !hasBackgroundSupport(name, 'backgroundImage')) {
    return null;
  }
  const defaultControls = (0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [BACKGROUND_SUPPORT_KEY, '__experimentalDefaultControls']);
  const onChange = newStyle => {
    setAttributes({
      style: utils_cleanEmptyObject(newStyle)
    });
  };
  const updatedSettings = {
    ...settings,
    background: {
      ...settings.background,
      backgroundSize: settings?.background?.backgroundSize && hasBackgroundSupport(name, 'backgroundSize')
    }
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BackgroundPanel, {
    as: BackgroundInspectorControl,
    panelId: clientId,
    defaultControls: defaultControls,
    defaultValues: BACKGROUND_DEFAULT_VALUES,
    settings: updatedSettings,
    onChange: onChange,
    value: style
  });
}
/* harmony default export */ const background = ({
  useBlockProps: background_useBlockProps,
  attributeKeys: ['style'],
  hasSupport: hasBackgroundSupport
});

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/lock.js
/**
 * WordPress dependencies
 */


/**
 * Filters registered block settings, extending attributes to include `lock`.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */
function lock_addAttribute(settings) {
  var _settings$attributes$;
  // Allow blocks to specify their own attribute definition with default values if needed.
  if ('type' in ((_settings$attributes$ = settings.attributes?.lock) !== null && _settings$attributes$ !== void 0 ? _settings$attributes$ : {})) {
    return settings;
  }
  // Gracefully handle if settings.attributes is undefined.
  settings.attributes = {
    ...settings.attributes,
    lock: {
      type: 'object'
    }
  };
  return settings;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/lock/addAttribute', lock_addAttribute);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/anchor.js
/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */



/**
 * Regular expression matching invalid anchor characters for replacement.
 *
 * @type {RegExp}
 */



const ANCHOR_REGEX = /[\s#]/g;
const ANCHOR_SCHEMA = {
  type: 'string',
  source: 'attribute',
  attribute: 'id',
  selector: '*'
};

/**
 * Filters registered block settings, extending attributes with anchor using ID
 * of the first node.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */
function anchor_addAttribute(settings) {
  var _settings$attributes$;
  // Allow blocks to specify their own attribute definition with default values if needed.
  if ('type' in ((_settings$attributes$ = settings.attributes?.anchor) !== null && _settings$attributes$ !== void 0 ? _settings$attributes$ : {})) {
    return settings;
  }
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, 'anchor')) {
    // Gracefully handle if settings.attributes is undefined.
    settings.attributes = {
      ...settings.attributes,
      anchor: ANCHOR_SCHEMA
    };
  }
  return settings;
}
function BlockEditAnchorControlPure({
  anchor,
  setAttributes
}) {
  const blockEditingMode = useBlockEditingMode();
  if (blockEditingMode !== 'default') {
    return null;
  }
  const isWeb = external_wp_element_namespaceObject.Platform.OS === 'web';
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(inspector_controls, {
    group: "advanced",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.TextControl, {
      __nextHasNoMarginBottom: true,
      __next40pxDefaultSize: true,
      className: "html-anchor-control",
      label: (0,external_wp_i18n_namespaceObject.__)('HTML anchor'),
      help: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
        children: [(0,external_wp_i18n_namespaceObject.__)('Enter a word or two — without spaces — to make a unique web address just for this block, called an “anchor”. Then, you’ll be able to link directly to this section of your page.'), isWeb && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
          children: [' ', /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ExternalLink, {
            href: (0,external_wp_i18n_namespaceObject.__)('https://wordpress.org/documentation/article/page-jumps/'),
            children: (0,external_wp_i18n_namespaceObject.__)('Learn more about anchors')
          })]
        })]
      }),
      value: anchor || '',
      placeholder: !isWeb ? (0,external_wp_i18n_namespaceObject.__)('Add an anchor') : null,
      onChange: nextValue => {
        nextValue = nextValue.replace(ANCHOR_REGEX, '-');
        setAttributes({
          anchor: nextValue
        });
      },
      autoCapitalize: "none",
      autoComplete: "off"
    })
  });
}
/* harmony default export */ const hooks_anchor = ({
  addSaveProps,
  edit: BlockEditAnchorControlPure,
  attributeKeys: ['anchor'],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, 'anchor');
  }
});

/**
 * Override props assigned to save component to inject anchor ID, if block
 * supports anchor. This is only applied if the block's save result is an
 * element and not a markup string.
 *
 * @param {Object} extraProps Additional props applied to save element.
 * @param {Object} blockType  Block type.
 * @param {Object} attributes Current block attributes.
 *
 * @return {Object} Filtered props applied to save element.
 */
function addSaveProps(extraProps, blockType, attributes) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'anchor')) {
    extraProps.id = attributes.anchor === '' ? null : attributes.anchor;
  }
  return extraProps;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/anchor/attribute', anchor_addAttribute);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/aria-label.js
/**
 * WordPress dependencies
 */


const ARIA_LABEL_SCHEMA = {
  type: 'string',
  source: 'attribute',
  attribute: 'aria-label',
  selector: '*'
};

/**
 * Filters registered block settings, extending attributes with ariaLabel using aria-label
 * of the first node.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */
function aria_label_addAttribute(settings) {
  // Allow blocks to specify their own attribute definition with default values if needed.
  if (settings?.attributes?.ariaLabel?.type) {
    return settings;
  }
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, 'ariaLabel')) {
    // Gracefully handle if settings.attributes is undefined.
    settings.attributes = {
      ...settings.attributes,
      ariaLabel: ARIA_LABEL_SCHEMA
    };
  }
  return settings;
}

/**
 * Override props assigned to save component to inject aria-label, if block
 * supports ariaLabel. This is only applied if the block's save result is an
 * element and not a markup string.
 *
 * @param {Object} extraProps Additional props applied to save element.
 * @param {Object} blockType  Block type.
 * @param {Object} attributes Current block attributes.
 *
 * @return {Object} Filtered props applied to save element.
 */
function aria_label_addSaveProps(extraProps, blockType, attributes) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'ariaLabel')) {
    extraProps['aria-label'] = attributes.ariaLabel === '' ? null : attributes.ariaLabel;
  }
  return extraProps;
}
/* harmony default export */ const aria_label = ({
  addSaveProps: aria_label_addSaveProps,
  attributeKeys: ['ariaLabel'],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, 'ariaLabel');
  }
});
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/ariaLabel/attribute', aria_label_addAttribute);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/custom-class-name.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



/**
 * Filters registered block settings, extending attributes to include `className`.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */

function custom_class_name_addAttribute(settings) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, 'customClassName', true)) {
    // Gracefully handle if settings.attributes is undefined.
    settings.attributes = {
      ...settings.attributes,
      className: {
        type: 'string'
      }
    };
  }
  return settings;
}
function CustomClassNameControlsPure({
  className,
  setAttributes
}) {
  const blockEditingMode = useBlockEditingMode();
  if (blockEditingMode !== 'default') {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(inspector_controls, {
    group: "advanced",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.TextControl, {
      __nextHasNoMarginBottom: true,
      __next40pxDefaultSize: true,
      autoComplete: "off",
      label: (0,external_wp_i18n_namespaceObject.__)('Additional CSS class(es)'),
      value: className || '',
      onChange: nextValue => {
        setAttributes({
          className: nextValue !== '' ? nextValue : undefined
        });
      },
      help: (0,external_wp_i18n_namespaceObject.__)('Separate multiple classes with spaces.')
    })
  });
}
/* harmony default export */ const custom_class_name = ({
  edit: CustomClassNameControlsPure,
  addSaveProps: custom_class_name_addSaveProps,
  attributeKeys: ['className'],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, 'customClassName', true);
  }
});

/**
 * Override props assigned to save component to inject the className, if block
 * supports customClassName. This is only applied if the block's save result is an
 * element and not a markup string.
 *
 * @param {Object} extraProps Additional props applied to save element.
 * @param {Object} blockType  Block type.
 * @param {Object} attributes Current block attributes.
 *
 * @return {Object} Filtered props applied to save element.
 */
function custom_class_name_addSaveProps(extraProps, blockType, attributes) {
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'customClassName', true) && attributes.className) {
    extraProps.className = dist_clsx(extraProps.className, attributes.className);
  }
  return extraProps;
}
function addTransforms(result, source, index, results) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(result.name, 'customClassName', true)) {
    return result;
  }

  // If the condition verifies we are probably in the presence of a wrapping transform
  // e.g: nesting paragraphs in a group or columns and in that case the class should not be kept.
  if (results.length === 1 && result.innerBlocks.length === source.length) {
    return result;
  }

  // If we are transforming one block to multiple blocks or multiple blocks to one block,
  // we ignore the class during the transform.
  if (results.length === 1 && source.length > 1 || results.length > 1 && source.length === 1) {
    return result;
  }

  // If we are in presence of transform between one or more block in the source
  // that have one or more blocks in the result
  // we apply the class on source N to the result N,
  // if source N does not exists we do nothing.
  if (source[index]) {
    const originClassName = source[index]?.attributes.className;
    if (originClassName) {
      return {
        ...result,
        attributes: {
          ...result.attributes,
          className: originClassName
        }
      };
    }
  }
  return result;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/editor/custom-class-name/attribute', custom_class_name_addAttribute);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.switchToBlockType.transformedBlock', 'core/color/addTransforms', addTransforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/generated-class-name.js
/**
 * WordPress dependencies
 */



/**
 * Override props assigned to save component to inject generated className if
 * block supports it. This is only applied if the block's save result is an
 * element and not a markup string.
 *
 * @param {Object} extraProps Additional props applied to save element.
 * @param {Object} blockType  Block type.
 *
 * @return {Object} Filtered props applied to save element.
 */
function addGeneratedClassName(extraProps, blockType) {
  // Adding the generated className.
  if ((0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, 'className', true)) {
    if (typeof extraProps.className === 'string') {
      // We have some extra classes and want to add the default classname
      // We use uniq to prevent duplicate classnames.

      extraProps.className = [...new Set([(0,external_wp_blocks_namespaceObject.getBlockDefaultClassName)(blockType.name), ...extraProps.className.split(' ')])].join(' ').trim();
    } else {
      // There is no string in the className variable,
      // so we just dump the default name in there.
      extraProps.className = (0,external_wp_blocks_namespaceObject.getBlockDefaultClassName)(blockType.name);
    }
  }
  return extraProps;
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.getSaveContent.extraProps', 'core/generated-class-name/save-props', addGeneratedClassName);

;// CONCATENATED MODULE: ./node_modules/colord/index.mjs
var colord_r={grad:.9,turn:360,rad:360/(2*Math.PI)},t=function(r){return"string"==typeof r?r.length>0:"number"==typeof r},n=function(r,t,n){return void 0===t&&(t=0),void 0===n&&(n=Math.pow(10,t)),Math.round(n*r)/n+0},e=function(r,t,n){return void 0===t&&(t=0),void 0===n&&(n=1),r>n?n:r>t?r:t},u=function(r){return(r=isFinite(r)?r%360:0)>0?r:r+360},a=function(r){return{r:e(r.r,0,255),g:e(r.g,0,255),b:e(r.b,0,255),a:e(r.a)}},o=function(r){return{r:n(r.r),g:n(r.g),b:n(r.b),a:n(r.a,3)}},i=/^#([0-9a-f]{3,8})$/i,s=function(r){var t=r.toString(16);return t.length<2?"0"+t:t},h=function(r){var t=r.r,n=r.g,e=r.b,u=r.a,a=Math.max(t,n,e),o=a-Math.min(t,n,e),i=o?a===t?(n-e)/o:a===n?2+(e-t)/o:4+(t-n)/o:0;return{h:60*(i<0?i+6:i),s:a?o/a*100:0,v:a/255*100,a:u}},b=function(r){var t=r.h,n=r.s,e=r.v,u=r.a;t=t/360*6,n/=100,e/=100;var a=Math.floor(t),o=e*(1-n),i=e*(1-(t-a)*n),s=e*(1-(1-t+a)*n),h=a%6;return{r:255*[e,i,o,o,s,e][h],g:255*[s,e,e,i,o,o][h],b:255*[o,o,s,e,e,i][h],a:u}},g=function(r){return{h:u(r.h),s:e(r.s,0,100),l:e(r.l,0,100),a:e(r.a)}},d=function(r){return{h:n(r.h),s:n(r.s),l:n(r.l),a:n(r.a,3)}},f=function(r){return b((n=(t=r).s,{h:t.h,s:(n*=((e=t.l)<50?e:100-e)/100)>0?2*n/(e+n)*100:0,v:e+n,a:t.a}));var t,n,e},c=function(r){return{h:(t=h(r)).h,s:(u=(200-(n=t.s))*(e=t.v)/100)>0&&u<200?n*e/100/(u<=100?u:200-u)*100:0,l:u/2,a:t.a};var t,n,e,u},l=/^hsla?\(\s*([+-]?\d*\.?\d+)(deg|rad|grad|turn)?\s*,\s*([+-]?\d*\.?\d+)%\s*,\s*([+-]?\d*\.?\d+)%\s*(?:,\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,p=/^hsla?\(\s*([+-]?\d*\.?\d+)(deg|rad|grad|turn)?\s+([+-]?\d*\.?\d+)%\s+([+-]?\d*\.?\d+)%\s*(?:\/\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,v=/^rgba?\(\s*([+-]?\d*\.?\d+)(%)?\s*,\s*([+-]?\d*\.?\d+)(%)?\s*,\s*([+-]?\d*\.?\d+)(%)?\s*(?:,\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,m=/^rgba?\(\s*([+-]?\d*\.?\d+)(%)?\s+([+-]?\d*\.?\d+)(%)?\s+([+-]?\d*\.?\d+)(%)?\s*(?:\/\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,y={string:[[function(r){var t=i.exec(r);return t?(r=t[1]).length<=4?{r:parseInt(r[0]+r[0],16),g:parseInt(r[1]+r[1],16),b:parseInt(r[2]+r[2],16),a:4===r.length?n(parseInt(r[3]+r[3],16)/255,2):1}:6===r.length||8===r.length?{r:parseInt(r.substr(0,2),16),g:parseInt(r.substr(2,2),16),b:parseInt(r.substr(4,2),16),a:8===r.length?n(parseInt(r.substr(6,2),16)/255,2):1}:null:null},"hex"],[function(r){var t=v.exec(r)||m.exec(r);return t?t[2]!==t[4]||t[4]!==t[6]?null:a({r:Number(t[1])/(t[2]?100/255:1),g:Number(t[3])/(t[4]?100/255:1),b:Number(t[5])/(t[6]?100/255:1),a:void 0===t[7]?1:Number(t[7])/(t[8]?100:1)}):null},"rgb"],[function(t){var n=l.exec(t)||p.exec(t);if(!n)return null;var e,u,a=g({h:(e=n[1],u=n[2],void 0===u&&(u="deg"),Number(e)*(colord_r[u]||1)),s:Number(n[3]),l:Number(n[4]),a:void 0===n[5]?1:Number(n[5])/(n[6]?100:1)});return f(a)},"hsl"]],object:[[function(r){var n=r.r,e=r.g,u=r.b,o=r.a,i=void 0===o?1:o;return t(n)&&t(e)&&t(u)?a({r:Number(n),g:Number(e),b:Number(u),a:Number(i)}):null},"rgb"],[function(r){var n=r.h,e=r.s,u=r.l,a=r.a,o=void 0===a?1:a;if(!t(n)||!t(e)||!t(u))return null;var i=g({h:Number(n),s:Number(e),l:Number(u),a:Number(o)});return f(i)},"hsl"],[function(r){var n=r.h,a=r.s,o=r.v,i=r.a,s=void 0===i?1:i;if(!t(n)||!t(a)||!t(o))return null;var h=function(r){return{h:u(r.h),s:e(r.s,0,100),v:e(r.v,0,100),a:e(r.a)}}({h:Number(n),s:Number(a),v:Number(o),a:Number(s)});return b(h)},"hsv"]]},N=function(r,t){for(var n=0;n<t.length;n++){var e=t[n][0](r);if(e)return[e,t[n][1]]}return[null,void 0]},x=function(r){return"string"==typeof r?N(r.trim(),y.string):"object"==typeof r&&null!==r?N(r,y.object):[null,void 0]},I=function(r){return x(r)[1]},M=function(r,t){var n=c(r);return{h:n.h,s:e(n.s+100*t,0,100),l:n.l,a:n.a}},H=function(r){return(299*r.r+587*r.g+114*r.b)/1e3/255},$=function(r,t){var n=c(r);return{h:n.h,s:n.s,l:e(n.l+100*t,0,100),a:n.a}},colord_j=function(){function r(r){this.parsed=x(r)[0],this.rgba=this.parsed||{r:0,g:0,b:0,a:1}}return r.prototype.isValid=function(){return null!==this.parsed},r.prototype.brightness=function(){return n(H(this.rgba),2)},r.prototype.isDark=function(){return H(this.rgba)<.5},r.prototype.isLight=function(){return H(this.rgba)>=.5},r.prototype.toHex=function(){return r=o(this.rgba),t=r.r,e=r.g,u=r.b,i=(a=r.a)<1?s(n(255*a)):"","#"+s(t)+s(e)+s(u)+i;var r,t,e,u,a,i},r.prototype.toRgb=function(){return o(this.rgba)},r.prototype.toRgbString=function(){return r=o(this.rgba),t=r.r,n=r.g,e=r.b,(u=r.a)<1?"rgba("+t+", "+n+", "+e+", "+u+")":"rgb("+t+", "+n+", "+e+")";var r,t,n,e,u},r.prototype.toHsl=function(){return d(c(this.rgba))},r.prototype.toHslString=function(){return r=d(c(this.rgba)),t=r.h,n=r.s,e=r.l,(u=r.a)<1?"hsla("+t+", "+n+"%, "+e+"%, "+u+")":"hsl("+t+", "+n+"%, "+e+"%)";var r,t,n,e,u},r.prototype.toHsv=function(){return r=h(this.rgba),{h:n(r.h),s:n(r.s),v:n(r.v),a:n(r.a,3)};var r},r.prototype.invert=function(){return w({r:255-(r=this.rgba).r,g:255-r.g,b:255-r.b,a:r.a});var r},r.prototype.saturate=function(r){return void 0===r&&(r=.1),w(M(this.rgba,r))},r.prototype.desaturate=function(r){return void 0===r&&(r=.1),w(M(this.rgba,-r))},r.prototype.grayscale=function(){return w(M(this.rgba,-1))},r.prototype.lighten=function(r){return void 0===r&&(r=.1),w($(this.rgba,r))},r.prototype.darken=function(r){return void 0===r&&(r=.1),w($(this.rgba,-r))},r.prototype.rotate=function(r){return void 0===r&&(r=15),this.hue(this.hue()+r)},r.prototype.alpha=function(r){return"number"==typeof r?w({r:(t=this.rgba).r,g:t.g,b:t.b,a:r}):n(this.rgba.a,3);var t},r.prototype.hue=function(r){var t=c(this.rgba);return"number"==typeof r?w({h:r,s:t.s,l:t.l,a:t.a}):n(t.h)},r.prototype.isEqual=function(r){return this.toHex()===w(r).toHex()},r}(),w=function(r){return r instanceof colord_j?r:new colord_j(r)},S=[],k=function(r){r.forEach(function(r){S.indexOf(r)<0&&(r(colord_j,y),S.push(r))})},E=function(){return new colord_j({r:255*Math.random(),g:255*Math.random(),b:255*Math.random()})};

;// CONCATENATED MODULE: ./node_modules/colord/plugins/names.mjs
/* harmony default export */ function names(e,f){var a={white:"#ffffff",bisque:"#ffe4c4",blue:"#0000ff",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",antiquewhite:"#faebd7",aqua:"#00ffff",azure:"#f0ffff",whitesmoke:"#f5f5f5",papayawhip:"#ffefd5",plum:"#dda0dd",blanchedalmond:"#ffebcd",black:"#000000",gold:"#ffd700",goldenrod:"#daa520",gainsboro:"#dcdcdc",cornsilk:"#fff8dc",cornflowerblue:"#6495ed",burlywood:"#deb887",aquamarine:"#7fffd4",beige:"#f5f5dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkkhaki:"#bdb76b",darkgray:"#a9a9a9",darkgreen:"#006400",darkgrey:"#a9a9a9",peachpuff:"#ffdab9",darkmagenta:"#8b008b",darkred:"#8b0000",darkorchid:"#9932cc",darkorange:"#ff8c00",darkslateblue:"#483d8b",gray:"#808080",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",deeppink:"#ff1493",deepskyblue:"#00bfff",wheat:"#f5deb3",firebrick:"#b22222",floralwhite:"#fffaf0",ghostwhite:"#f8f8ff",darkviolet:"#9400d3",magenta:"#ff00ff",green:"#008000",dodgerblue:"#1e90ff",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",blueviolet:"#8a2be2",forestgreen:"#228b22",lawngreen:"#7cfc00",indianred:"#cd5c5c",indigo:"#4b0082",fuchsia:"#ff00ff",brown:"#a52a2a",maroon:"#800000",mediumblue:"#0000cd",lightcoral:"#f08080",darkturquoise:"#00ced1",lightcyan:"#e0ffff",ivory:"#fffff0",lightyellow:"#ffffe0",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",linen:"#faf0e6",mediumaquamarine:"#66cdaa",lemonchiffon:"#fffacd",lime:"#00ff00",khaki:"#f0e68c",mediumseagreen:"#3cb371",limegreen:"#32cd32",mediumspringgreen:"#00fa9a",lightskyblue:"#87cefa",lightblue:"#add8e6",midnightblue:"#191970",lightpink:"#ffb6c1",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",mintcream:"#f5fffa",lightslategray:"#778899",lightslategrey:"#778899",navajowhite:"#ffdead",navy:"#000080",mediumvioletred:"#c71585",powderblue:"#b0e0e6",palegoldenrod:"#eee8aa",oldlace:"#fdf5e6",paleturquoise:"#afeeee",mediumturquoise:"#48d1cc",mediumorchid:"#ba55d3",rebeccapurple:"#663399",lightsteelblue:"#b0c4de",mediumslateblue:"#7b68ee",thistle:"#d8bfd8",tan:"#d2b48c",orchid:"#da70d6",mediumpurple:"#9370db",purple:"#800080",pink:"#ffc0cb",skyblue:"#87ceeb",springgreen:"#00ff7f",palegreen:"#98fb98",red:"#ff0000",yellow:"#ffff00",slateblue:"#6a5acd",lavenderblush:"#fff0f5",peru:"#cd853f",palevioletred:"#db7093",violet:"#ee82ee",teal:"#008080",slategray:"#708090",slategrey:"#708090",aliceblue:"#f0f8ff",darkseagreen:"#8fbc8f",darkolivegreen:"#556b2f",greenyellow:"#adff2f",seagreen:"#2e8b57",seashell:"#fff5ee",tomato:"#ff6347",silver:"#c0c0c0",sienna:"#a0522d",lavender:"#e6e6fa",lightgreen:"#90ee90",orange:"#ffa500",orangered:"#ff4500",steelblue:"#4682b4",royalblue:"#4169e1",turquoise:"#40e0d0",yellowgreen:"#9acd32",salmon:"#fa8072",saddlebrown:"#8b4513",sandybrown:"#f4a460",rosybrown:"#bc8f8f",darksalmon:"#e9967a",lightgoldenrodyellow:"#fafad2",snow:"#fffafa",lightgrey:"#d3d3d3",lightgray:"#d3d3d3",dimgray:"#696969",dimgrey:"#696969",olivedrab:"#6b8e23",olive:"#808000"},r={};for(var d in a)r[a[d]]=d;var l={};e.prototype.toName=function(f){if(!(this.rgba.a||this.rgba.r||this.rgba.g||this.rgba.b))return"transparent";var d,i,n=r[this.toHex()];if(n)return n;if(null==f?void 0:f.closest){var o=this.toRgb(),t=1/0,b="black";if(!l.length)for(var c in a)l[c]=new e(a[c]).toRgb();for(var g in a){var u=(d=o,i=l[g],Math.pow(d.r-i.r,2)+Math.pow(d.g-i.g,2)+Math.pow(d.b-i.b,2));u<t&&(t=u,b=g)}return b}};f.string.push([function(f){var r=f.toLowerCase(),d="transparent"===r?"#0000":a[r];return d?new e(d).toRgb():null},"name"])}

;// CONCATENATED MODULE: ./node_modules/colord/plugins/a11y.mjs
var a11y_o=function(o){var t=o/255;return t<.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)},a11y_t=function(t){return.2126*a11y_o(t.r)+.7152*a11y_o(t.g)+.0722*a11y_o(t.b)};/* harmony default export */ function a11y(o){o.prototype.luminance=function(){return o=a11y_t(this.rgba),void 0===(r=2)&&(r=0),void 0===n&&(n=Math.pow(10,r)),Math.round(n*o)/n+0;var o,r,n},o.prototype.contrast=function(r){void 0===r&&(r="#FFF");var n,a,i,e,v,u,d,c=r instanceof o?r:new o(r);return e=this.rgba,v=c.toRgb(),u=a11y_t(e),d=a11y_t(v),n=u>d?(u+.05)/(d+.05):(d+.05)/(u+.05),void 0===(a=2)&&(a=0),void 0===i&&(i=Math.pow(10,a)),Math.floor(i*n)/i+0},o.prototype.isReadable=function(o,t){return void 0===o&&(o="#FFF"),void 0===t&&(t={}),this.contrast(o)>=(e=void 0===(i=(r=t).size)?"normal":i,"AAA"===(a=void 0===(n=r.level)?"AA":n)&&"normal"===e?7:"AA"===a&&"large"===e?3:4.5);var r,n,a,i,e}}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/colors/utils.js
/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

k([names, a11y]);
const {
  kebabCase
} = unlock(external_wp_components_namespaceObject.privateApis);

/**
 * Provided an array of color objects as set by the theme or by the editor defaults,
 * and the values of the defined color or custom color returns a color object describing the color.
 *
 * @param {Array}   colors       Array of color objects as set by the theme or by the editor defaults.
 * @param {?string} definedColor A string containing the color slug.
 * @param {?string} customColor  A string containing the customColor value.
 *
 * @return {?Object} If definedColor is passed and the name is found in colors,
 *                   the color object exactly as set by the theme or editor defaults is returned.
 *                   Otherwise, an object that just sets the color is defined.
 */
const getColorObjectByAttributeValues = (colors, definedColor, customColor) => {
  if (definedColor) {
    const colorObj = colors?.find(color => color.slug === definedColor);
    if (colorObj) {
      return colorObj;
    }
  }
  return {
    color: customColor
  };
};

/**
 * Provided an array of color objects as set by the theme or by the editor defaults, and a color value returns the color object matching that value or undefined.
 *
 * @param {Array}   colors     Array of color objects as set by the theme or by the editor defaults.
 * @param {?string} colorValue A string containing the color value.
 *
 * @return {?Object} Color object included in the colors array whose color property equals colorValue.
 *                   Returns undefined if no color object matches this requirement.
 */
const getColorObjectByColorValue = (colors, colorValue) => {
  return colors?.find(color => color.color === colorValue);
};

/**
 * Returns a class based on the context a color is being used and its slug.
 *
 * @param {string} colorContextName Context/place where color is being used e.g: background, text etc...
 * @param {string} colorSlug        Slug of the color.
 *
 * @return {?string} String with the class corresponding to the color in the provided context.
 *                   Returns undefined if either colorContextName or colorSlug are not provided.
 */
function getColorClassName(colorContextName, colorSlug) {
  if (!colorContextName || !colorSlug) {
    return undefined;
  }
  return `has-${kebabCase(colorSlug)}-${colorContextName}`;
}

/**
 * Given an array of color objects and a color value returns the color value of the most readable color in the array.
 *
 * @param {Array}   colors     Array of color objects as set by the theme or by the editor defaults.
 * @param {?string} colorValue A string containing the color value.
 *
 * @return {string} String with the color value of the most readable color.
 */
function getMostReadableColor(colors, colorValue) {
  const colordColor = w(colorValue);
  const getColorContrast = ({
    color
  }) => colordColor.contrast(color);
  const maxContrast = Math.max(...colors.map(getColorContrast));
  return colors.find(color => getColorContrast(color) === maxContrast).color;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/colors-gradients/use-multiple-origin-colors-and-gradients.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Retrieves color and gradient related settings.
 *
 * The arrays for colors and gradients are made up of color palettes from each
 * origin i.e. "Core", "Theme", and "User".
 *
 * @return {Object} Color and gradient related settings.
 */
function useMultipleOriginColorsAndGradients() {
  const [enableCustomColors, customColors, themeColors, defaultColors, shouldDisplayDefaultColors, enableCustomGradients, customGradients, themeGradients, defaultGradients, shouldDisplayDefaultGradients] = use_settings_useSettings('color.custom', 'color.palette.custom', 'color.palette.theme', 'color.palette.default', 'color.defaultPalette', 'color.customGradient', 'color.gradients.custom', 'color.gradients.theme', 'color.gradients.default', 'color.defaultGradients');
  const colorGradientSettings = {
    disableCustomColors: !enableCustomColors,
    disableCustomGradients: !enableCustomGradients
  };
  colorGradientSettings.colors = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const result = [];
    if (themeColors && themeColors.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Theme', 'Indicates this palette comes from the theme.'),
        colors: themeColors
      });
    }
    if (shouldDisplayDefaultColors && defaultColors && defaultColors.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Default', 'Indicates this palette comes from WordPress.'),
        colors: defaultColors
      });
    }
    if (customColors && customColors.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Custom', 'Indicates this palette comes from the theme.'),
        colors: customColors
      });
    }
    return result;
  }, [customColors, themeColors, defaultColors, shouldDisplayDefaultColors]);
  colorGradientSettings.gradients = (0,external_wp_element_namespaceObject.useMemo)(() => {
    const result = [];
    if (themeGradients && themeGradients.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Theme', 'Indicates this palette comes from the theme.'),
        gradients: themeGradients
      });
    }
    if (shouldDisplayDefaultGradients && defaultGradients && defaultGradients.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Default', 'Indicates this palette comes from WordPress.'),
        gradients: defaultGradients
      });
    }
    if (customGradients && customGradients.length) {
      result.push({
        name: (0,external_wp_i18n_namespaceObject._x)('Custom', 'Indicates this palette is created by the user.'),
        gradients: customGradients
      });
    }
    return result;
  }, [customGradients, themeGradients, defaultGradients, shouldDisplayDefaultGradients]);
  colorGradientSettings.hasColorsOrGradients = !!colorGradientSettings.colors.length || !!colorGradientSettings.gradients.length;
  return colorGradientSettings;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/border-radius-control/utils.js
/**
 * WordPress dependencies
 */


/**
 * Gets the (non-undefined) item with the highest occurrence within an array
 * Based in part on: https://stackoverflow.com/a/20762713
 *
 * Undefined values are always sorted to the end by `sort`, so this function
 * returns the first element, to always prioritize real values over undefined
 * values.
 *
 * See: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/sort#description
 *
 * @param {Array<any>} inputArray Array of items to check.
 * @return {any}                  The item with the most occurrences.
 */
function utils_mode(inputArray) {
  const arr = [...inputArray];
  return arr.sort((a, b) => inputArray.filter(v => v === b).length - inputArray.filter(v => v === a).length).shift();
}

/**
 * Returns the most common CSS unit from the current CSS unit selections.
 *
 * - If a single flat border radius is set, its unit will be used
 * - If individual corner selections, the most common of those will be used
 * - Failing any unit selections a default of 'px' is returned.
 *
 * @param {Object} selectedUnits Unit selections for flat radius & each corner.
 * @return {string} Most common CSS unit from current selections. Default: `px`.
 */
function getAllUnit(selectedUnits = {}) {
  const {
    flat,
    ...cornerUnits
  } = selectedUnits;
  return flat || utils_mode(Object.values(cornerUnits).filter(Boolean)) || 'px';
}

/**
 * Gets the 'all' input value and unit from values data.
 *
 * @param {Object|string} values Radius values.
 * @return {string}              A value + unit for the 'all' input.
 */
function getAllValue(values = {}) {
  /**
   * Border radius support was originally a single pixel value.
   *
   * To maintain backwards compatibility treat this case as the all value.
   */
  if (typeof values === 'string') {
    return values;
  }
  const parsedQuantitiesAndUnits = Object.values(values).map(value => (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(value));
  const allValues = parsedQuantitiesAndUnits.map(value => {
    var _value$;
    return (_value$ = value[0]) !== null && _value$ !== void 0 ? _value$ : '';
  });
  const allUnits = parsedQuantitiesAndUnits.map(value => value[1]);
  const value = allValues.every(v => v === allValues[0]) ? allValues[0] : '';
  const unit = utils_mode(allUnits);
  const allValue = value === 0 || value ? `${value}${unit}` : undefined;
  return allValue;
}

/**
 * Checks to determine if values are mixed.
 *
 * @param {Object} values Radius values.
 * @return {boolean}      Whether values are mixed.
 */
function hasMixedValues(values = {}) {
  const allValue = getAllValue(values);
  const isMixed = typeof values === 'string' ? false : isNaN(parseFloat(allValue));
  return isMixed;
}

/**
 * Checks to determine if values are defined.
 *
 * @param {Object} values Radius values.
 * @return {boolean}      Whether values are mixed.
 */
function hasDefinedValues(values) {
  if (!values) {
    return false;
  }

  // A string value represents a shorthand value.
  if (typeof values === 'string') {
    return true;
  }

  // An object represents longhand border radius values, if any are set
  // flag values as being defined.
  const filteredValues = Object.values(values).filter(value => {
    return !!value || value === 0;
  });
  return !!filteredValues.length;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/border-radius-control/all-input-control.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function AllInputControl({
  onChange,
  selectedUnits,
  setSelectedUnits,
  values,
  ...props
}) {
  let allValue = getAllValue(values);
  if (allValue === undefined) {
    // If we don't have any value set the unit to any current selection
    // or the most common unit from the individual radii values.
    allValue = getAllUnit(selectedUnits);
  }
  const hasValues = hasDefinedValues(values);
  const isMixed = hasValues && hasMixedValues(values);
  const allPlaceholder = isMixed ? (0,external_wp_i18n_namespaceObject.__)('Mixed') : null;

  // Filter out CSS-unit-only values to prevent invalid styles.
  const handleOnChange = next => {
    const isNumeric = !isNaN(parseFloat(next));
    const nextValue = isNumeric ? next : undefined;
    onChange(nextValue);
  };

  // Store current unit selection for use as fallback for individual
  // radii controls.
  const handleOnUnitChange = unit => {
    setSelectedUnits({
      topLeft: unit,
      topRight: unit,
      bottomLeft: unit,
      bottomRight: unit
    });
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalUnitControl, {
    ...props,
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Border radius'),
    disableUnits: isMixed,
    isOnly: true,
    value: allValue,
    onChange: handleOnChange,
    onUnitChange: handleOnUnitChange,
    placeholder: allPlaceholder,
    size: "__unstable-large"
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/border-radius-control/input-controls.js
/**
 * WordPress dependencies
 */



const CORNERS = {
  topLeft: (0,external_wp_i18n_namespaceObject.__)('Top left'),
  topRight: (0,external_wp_i18n_namespaceObject.__)('Top right'),
  bottomLeft: (0,external_wp_i18n_namespaceObject.__)('Bottom left'),
  bottomRight: (0,external_wp_i18n_namespaceObject.__)('Bottom right')
};
function BoxInputControls({
  onChange,
  selectedUnits,
  setSelectedUnits,
  values: valuesProp,
  ...props
}) {
  const createHandleOnChange = corner => next => {
    if (!onChange) {
      return;
    }

    // Filter out CSS-unit-only values to prevent invalid styles.
    const isNumeric = !isNaN(parseFloat(next));
    const nextValue = isNumeric ? next : undefined;
    onChange({
      ...values,
      [corner]: nextValue
    });
  };
  const createHandleOnUnitChange = side => next => {
    const newUnits = {
      ...selectedUnits
    };
    newUnits[side] = next;
    setSelectedUnits(newUnits);
  };

  // For shorthand style & backwards compatibility, handle flat string value.
  const values = typeof valuesProp !== 'string' ? valuesProp : {
    topLeft: valuesProp,
    topRight: valuesProp,
    bottomLeft: valuesProp,
    bottomRight: valuesProp
  };

  // Controls are wrapped in tooltips as visible labels aren't desired here.
  // Tooltip rendering also requires the UnitControl to be wrapped. See:
  // https://github.com/WordPress/gutenberg/pull/24966#issuecomment-685875026
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
    className: "components-border-radius-control__input-controls-wrapper",
    children: Object.entries(CORNERS).map(([corner, label]) => {
      const [parsedQuantity, parsedUnit] = (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(values[corner]);
      const computedUnit = values[corner] ? parsedUnit : selectedUnits[corner] || selectedUnits.flat;
      return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Tooltip, {
        text: label,
        placement: "top",
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
          className: "components-border-radius-control__tooltip-wrapper",
          children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalUnitControl, {
            ...props,
            "aria-label": label,
            value: [parsedQuantity, computedUnit].join(''),
            onChange: createHandleOnChange(corner),
            onUnitChange: createHandleOnUnitChange(corner),
            size: "__unstable-large"
          })
        })
      }, corner);
    })
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/link.js
/**
 * WordPress dependencies
 */


const link_link = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M10 17.389H8.444A5.194 5.194 0 1 1 8.444 7H10v1.5H8.444a3.694 3.694 0 0 0 0 7.389H10v1.5ZM14 7h1.556a5.194 5.194 0 0 1 0 10.39H14v-1.5h1.556a3.694 3.694 0 0 0 0-7.39H14V7Zm-4.5 6h5v-1.5h-5V13Z"
  })
});
/* harmony default export */ const library_link = (link_link);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/border-radius-control/linked-button.js
/**
 * WordPress dependencies
 */




function LinkedButton({
  isLinked,
  ...props
}) {
  const label = isLinked ? (0,external_wp_i18n_namespaceObject.__)('Unlink radii') : (0,external_wp_i18n_namespaceObject.__)('Link radii');
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Tooltip, {
    text: label,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
      ...props,
      className: "component-border-radius-control__linked-button",
      size: "small",
      icon: isLinked ? library_link : link_off,
      iconSize: 24,
      "aria-label": label
    })
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/border-radius-control/index.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */








const border_radius_control_DEFAULT_VALUES = {
  topLeft: undefined,
  topRight: undefined,
  bottomLeft: undefined,
  bottomRight: undefined
};
const MIN_BORDER_RADIUS_VALUE = 0;
const MAX_BORDER_RADIUS_VALUES = {
  px: 100,
  em: 20,
  rem: 20
};

/**
 * Control to display border radius options.
 *
 * @param {Object}   props          Component props.
 * @param {Function} props.onChange Callback to handle onChange.
 * @param {Object}   props.values   Border radius values.
 *
 * @return {Element}              Custom border radius control.
 */
function BorderRadiusControl({
  onChange,
  values
}) {
  const [isLinked, setIsLinked] = (0,external_wp_element_namespaceObject.useState)(!hasDefinedValues(values) || !hasMixedValues(values));

  // Tracking selected units via internal state allows filtering of CSS unit
  // only values from being saved while maintaining preexisting unit selection
  // behaviour. Filtering CSS unit only values prevents invalid style values.
  const [selectedUnits, setSelectedUnits] = (0,external_wp_element_namespaceObject.useState)({
    flat: typeof values === 'string' ? (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(values)[1] : undefined,
    topLeft: (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(values?.topLeft)[1],
    topRight: (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(values?.topRight)[1],
    bottomLeft: (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(values?.bottomLeft)[1],
    bottomRight: (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(values?.bottomRight)[1]
  });
  const [availableUnits] = use_settings_useSettings('spacing.units');
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: availableUnits || ['px', 'em', 'rem']
  });
  const unit = getAllUnit(selectedUnits);
  const unitConfig = units && units.find(item => item.value === unit);
  const step = unitConfig?.step || 1;
  const [allValue] = (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(getAllValue(values));
  const toggleLinked = () => setIsLinked(!isLinked);
  const handleSliderChange = next => {
    onChange(next !== undefined ? `${next}${unit}` : undefined);
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", {
    className: "components-border-radius-control",
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, {
      as: "legend",
      children: (0,external_wp_i18n_namespaceObject.__)('Radius')
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
      className: "components-border-radius-control__wrapper",
      children: [isLinked ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_ReactJSXRuntime_namespaceObject.Fragment, {
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(AllInputControl, {
          className: "components-border-radius-control__unit-control",
          values: values,
          min: MIN_BORDER_RADIUS_VALUE,
          onChange: onChange,
          selectedUnits: selectedUnits,
          setSelectedUnits: setSelectedUnits,
          units: units
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.RangeControl, {
          label: (0,external_wp_i18n_namespaceObject.__)('Border radius'),
          hideLabelFromVision: true,
          className: "components-border-radius-control__range-control",
          value: allValue !== null && allValue !== void 0 ? allValue : '',
          min: MIN_BORDER_RADIUS_VALUE,
          max: MAX_BORDER_RADIUS_VALUES[unit],
          initialPosition: 0,
          withInputField: false,
          onChange: handleSliderChange,
          step: step,
          __nextHasNoMarginBottom: true
        })]
      }) : /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BoxInputControls, {
        min: MIN_BORDER_RADIUS_VALUE,
        onChange: onChange,
        selectedUnits: selectedUnits,
        setSelectedUnits: setSelectedUnits,
        values: values || border_radius_control_DEFAULT_VALUES,
        units: units
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(LinkedButton, {
        onClick: toggleLinked,
        isLinked: isLinked
      })]
    })]
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/check.js
/**
 * WordPress dependencies
 */


const check_check = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M16.7 7.1l-6.3 8.5-3.3-2.5-.9 1.2 4.5 3.4L17.9 8z"
  })
});
/* harmony default export */ const library_check = (check_check);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/shadow.js
/**
 * WordPress dependencies
 */


const shadow = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M12 8c-2.2 0-4 1.8-4 4s1.8 4 4 4 4-1.8 4-4-1.8-4-4-4zm0 6.5c-1.4 0-2.5-1.1-2.5-2.5s1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5-1.1 2.5-2.5 2.5zM12.8 3h-1.5v3h1.5V3zm-1.6 18h1.5v-3h-1.5v3zm6.8-9.8v1.5h3v-1.5h-3zm-12 0H3v1.5h3v-1.5zm9.7 5.6 2.1 2.1 1.1-1.1-2.1-2.1-1.1 1.1zM8.3 7.2 6.2 5.1 5.1 6.2l2.1 2.1 1.1-1.1zM5.1 17.8l1.1 1.1 2.1-2.1-1.1-1.1-2.1 2.1zM18.9 6.2l-1.1-1.1-2.1 2.1 1.1 1.1 2.1-2.1z"
  })
});
/* harmony default export */ const library_shadow = (shadow);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/global-styles/shadow-panel-components.js
/**
 * WordPress dependencies
 */





/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Shared reference to an empty array for cases where it is important to avoid
 * returning a new array reference on every invocation.
 *
 * @type {Array}
 */


const shadow_panel_components_EMPTY_ARRAY = [];
const {
  CompositeItemV2: CompositeItem,
  CompositeV2: Composite,
  useCompositeStoreV2: useCompositeStore
} = unlock(external_wp_components_namespaceObject.privateApis);
function ShadowPopoverContainer({
  shadow,
  onShadowChange,
  settings
}) {
  const shadows = useShadowPresets(settings);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
    className: "block-editor-global-styles__shadow-popover-container",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
      spacing: 4,
      children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalHeading, {
        level: 5,
        children: (0,external_wp_i18n_namespaceObject.__)('Drop shadow')
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ShadowPresets, {
        presets: shadows,
        activeShadow: shadow,
        onSelect: onShadowChange
      }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
        className: "block-editor-global-styles__clear-shadow",
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          variant: "tertiary",
          onClick: () => onShadowChange(undefined),
          children: (0,external_wp_i18n_namespaceObject.__)('Clear')
        })
      })]
    })
  });
}
function ShadowPresets({
  presets,
  activeShadow,
  onSelect
}) {
  const compositeStore = useCompositeStore();
  return !presets ? null : /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Composite, {
    store: compositeStore,
    role: "listbox",
    className: "block-editor-global-styles__shadow__list",
    "aria-label": (0,external_wp_i18n_namespaceObject.__)('Drop shadows'),
    children: presets.map(({
      name,
      slug,
      shadow
    }) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ShadowIndicator, {
      label: name,
      isActive: shadow === activeShadow,
      type: slug === 'unset' ? 'unset' : 'preset',
      onSelect: () => onSelect(shadow === activeShadow ? undefined : shadow),
      shadow: shadow
    }, slug))
  });
}
function ShadowIndicator({
  type,
  label,
  isActive,
  onSelect,
  shadow
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(CompositeItem, {
    role: "option",
    "aria-label": label,
    "aria-selected": isActive,
    className: dist_clsx('block-editor-global-styles__shadow__item', {
      'is-active': isActive
    }),
    render: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
      className: dist_clsx('block-editor-global-styles__shadow-indicator', {
        unset: type === 'unset'
      }),
      onClick: onSelect,
      label: label,
      style: {
        boxShadow: shadow
      },
      showTooltip: true,
      children: isActive && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(build_module_icon, {
        icon: library_check
      })
    })
  });
}
function ShadowPopover({
  shadow,
  onShadowChange,
  settings
}) {
  const popoverProps = {
    placement: 'left-start',
    offset: 36,
    shift: true
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Dropdown, {
    popoverProps: popoverProps,
    className: "block-editor-global-styles__shadow-dropdown",
    renderToggle: renderShadowToggle(),
    renderContent: () => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalDropdownContentWrapper, {
      paddingSize: "medium",
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ShadowPopoverContainer, {
        shadow: shadow,
        onShadowChange: onShadowChange,
        settings: settings
      })
    })
  });
}
function renderShadowToggle() {
  return ({
    onToggle,
    isOpen
  }) => {
    const toggleProps = {
      onClick: onToggle,
      className: dist_clsx({
        'is-open': isOpen
      }),
      'aria-expanded': isOpen
    };
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
      ...toggleProps,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
        justify: "flex-start",
        children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(build_module_icon, {
          className: "block-editor-global-styles__toggle-icon",
          icon: library_shadow,
          size: 24
        }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, {
          children: (0,external_wp_i18n_namespaceObject.__)('Drop shadow')
        })]
      })
    });
  };
}
function useShadowPresets(settings) {
  return (0,external_wp_element_namespaceObject.useMemo)(() => {
    var _settings$shadow$pres;
    if (!settings?.shadow) {
      return shadow_panel_components_EMPTY_ARRAY;
    }
    const defaultPresetsEnabled = settings?.shadow?.defaultPresets;
    const {
      default: defaultShadows,
      theme: themeShadows,
      custom: customShadows
    } = (_settings$shadow$pres = settings?.shadow?.presets) !== null && _settings$shadow$pres !== void 0 ? _settings$shadow$pres : {};
    const unsetShadow = {
      name: (0,external_wp_i18n_namespaceObject.__)('Unset'),
      slug: 'unset',
      shadow: 'none'
    };
    const shadowPresets = [...(defaultPresetsEnabled && defaultShadows || shadow_panel_components_EMPTY_ARRAY), ...(themeShadows || shadow_panel_components_EMPTY_ARRAY), ...(customShadows || shadow_panel_components_EMPTY_ARRAY)];
    if (shadowPresets.length) {
      shadowPresets.unshift(unsetShadow);
    }
    return shadowPresets;
  }, [settings]);
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/global-styles/border-panel.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */








function useHasBorderPanel(settings) {
  const controls = Object.values(useHasBorderPanelControls(settings));
  return controls.some(Boolean);
}
function useHasBorderPanelControls(settings) {
  const controls = {
    hasBorderColor: useHasBorderColorControl(settings),
    hasBorderRadius: useHasBorderRadiusControl(settings),
    hasBorderStyle: useHasBorderStyleControl(settings),
    hasBorderWidth: useHasBorderWidthControl(settings),
    hasShadow: useHasShadowControl(settings)
  };
  return controls;
}
function useHasBorderColorControl(settings) {
  return settings?.border?.color;
}
function useHasBorderRadiusControl(settings) {
  return settings?.border?.radius;
}
function useHasBorderStyleControl(settings) {
  return settings?.border?.style;
}
function useHasBorderWidthControl(settings) {
  return settings?.border?.width;
}
function useHasShadowControl(settings) {
  const shadows = useShadowPresets(settings);
  return !!settings?.shadow && shadows.length > 0;
}
function BorderToolsPanel({
  resetAllFilter,
  onChange,
  value,
  panelId,
  children,
  label
}) {
  const resetAll = () => {
    const updatedValue = resetAllFilter(value);
    onChange(updatedValue);
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanel, {
    label: label,
    resetAll: resetAll,
    panelId: panelId,
    dropdownMenuProps: TOOLSPANEL_DROPDOWNMENU_PROPS,
    children: children
  });
}
const border_panel_DEFAULT_CONTROLS = {
  radius: true,
  color: true,
  width: true,
  shadow: true
};
function BorderPanel({
  as: Wrapper = BorderToolsPanel,
  value,
  onChange,
  inheritedValue = value,
  settings,
  panelId,
  name,
  defaultControls = border_panel_DEFAULT_CONTROLS
}) {
  var _settings$shadow$pres, _ref, _ref2, _shadowPresets$custom;
  const colors = useColorsPerOrigin(settings);
  const decodeValue = (0,external_wp_element_namespaceObject.useCallback)(rawValue => getValueFromVariable({
    settings
  }, '', rawValue), [settings]);
  const encodeColorValue = colorValue => {
    const allColors = colors.flatMap(({
      colors: originColors
    }) => originColors);
    const colorObject = allColors.find(({
      color
    }) => color === colorValue);
    return colorObject ? 'var:preset|color|' + colorObject.slug : colorValue;
  };
  const border = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if ((0,external_wp_components_namespaceObject.__experimentalHasSplitBorders)(inheritedValue?.border)) {
      const borderValue = {
        ...inheritedValue?.border
      };
      ['top', 'right', 'bottom', 'left'].forEach(side => {
        borderValue[side] = {
          ...borderValue[side],
          color: decodeValue(borderValue[side]?.color)
        };
      });
      return borderValue;
    }
    return {
      ...inheritedValue?.border,
      color: inheritedValue?.border?.color ? decodeValue(inheritedValue?.border?.color) : undefined
    };
  }, [inheritedValue?.border, decodeValue]);
  const setBorder = newBorder => onChange({
    ...value,
    border: newBorder
  });
  const showBorderColor = useHasBorderColorControl(settings);
  const showBorderStyle = useHasBorderStyleControl(settings);
  const showBorderWidth = useHasBorderWidthControl(settings);

  // Border radius.
  const showBorderRadius = useHasBorderRadiusControl(settings);
  const borderRadiusValues = decodeValue(border?.radius);
  const setBorderRadius = newBorderRadius => setBorder({
    ...border,
    radius: newBorderRadius
  });
  const hasBorderRadius = () => {
    const borderValues = value?.border?.radius;
    if (typeof borderValues === 'object') {
      return Object.entries(borderValues).some(Boolean);
    }
    return !!borderValues;
  };
  const hasShadowControl = useHasShadowControl(settings);

  // Shadow
  const shadow = decodeValue(inheritedValue?.shadow);
  const shadowPresets = (_settings$shadow$pres = settings?.shadow?.presets) !== null && _settings$shadow$pres !== void 0 ? _settings$shadow$pres : {};
  const mergedShadowPresets = (_ref = (_ref2 = (_shadowPresets$custom = shadowPresets.custom) !== null && _shadowPresets$custom !== void 0 ? _shadowPresets$custom : shadowPresets.theme) !== null && _ref2 !== void 0 ? _ref2 : shadowPresets.default) !== null && _ref !== void 0 ? _ref : [];
  const setShadow = newValue => {
    const slug = mergedShadowPresets?.find(({
      shadow: shadowName
    }) => shadowName === newValue)?.slug;
    onChange(setImmutably(value, ['shadow'], slug ? `var:preset|shadow|${slug}` : newValue || undefined));
  };
  const hasShadow = () => !!value?.shadow;
  const resetShadow = () => setShadow(undefined);
  const resetBorder = () => {
    if (hasBorderRadius()) {
      return setBorder({
        radius: value?.border?.radius
      });
    }
    setBorder(undefined);
  };
  const onBorderChange = newBorder => {
    // Ensure we have a visible border style when a border width or
    // color is being selected.
    const updatedBorder = {
      ...newBorder
    };
    if ((0,external_wp_components_namespaceObject.__experimentalHasSplitBorders)(updatedBorder)) {
      ['top', 'right', 'bottom', 'left'].forEach(side => {
        if (updatedBorder[side]) {
          updatedBorder[side] = {
            ...updatedBorder[side],
            color: encodeColorValue(updatedBorder[side]?.color)
          };
        }
      });
    } else if (updatedBorder) {
      updatedBorder.color = encodeColorValue(updatedBorder.color);
    }

    // As radius is maintained separately to color, style, and width
    // maintain its value. Undefined values here will be cleaned when
    // global styles are saved.
    setBorder({
      radius: border?.radius,
      ...updatedBorder
    });
  };
  const resetAllFilter = (0,external_wp_element_namespaceObject.useCallback)(previousValue => {
    return {
      ...previousValue,
      border: undefined,
      shadow: undefined
    };
  }, []);
  const showBorderByDefault = defaultControls?.color || defaultControls?.width;
  const hasBorderControl = showBorderColor || showBorderStyle || showBorderWidth || showBorderRadius;
  const label = useBorderPanelLabel({
    blockName: name,
    hasShadowControl,
    hasBorderControl
  });
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(Wrapper, {
    resetAllFilter: resetAllFilter,
    value: value,
    onChange: onChange,
    panelId: panelId,
    label: label,
    children: [(showBorderWidth || showBorderColor) && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
      hasValue: () => (0,external_wp_components_namespaceObject.__experimentalIsDefinedBorder)(value?.border),
      label: (0,external_wp_i18n_namespaceObject.__)('Border'),
      onDeselect: () => resetBorder(),
      isShownByDefault: showBorderByDefault,
      panelId: panelId,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalBorderBoxControl, {
        colors: colors,
        enableAlpha: true,
        enableStyle: showBorderStyle,
        onChange: onBorderChange,
        popoverOffset: 40,
        popoverPlacement: "left-start",
        value: border,
        __experimentalIsRenderedInSidebar: true,
        size: "__unstable-large",
        hideLabelFromVision: !hasShadowControl,
        label: (0,external_wp_i18n_namespaceObject.__)('Border')
      })
    }), showBorderRadius && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
      hasValue: hasBorderRadius,
      label: (0,external_wp_i18n_namespaceObject.__)('Radius'),
      onDeselect: () => setBorderRadius(undefined),
      isShownByDefault: defaultControls.radius,
      panelId: panelId,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BorderRadiusControl, {
        values: borderRadiusValues,
        onChange: newValue => {
          setBorderRadius(newValue || undefined);
        }
      })
    }), hasShadowControl && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
      label: (0,external_wp_i18n_namespaceObject.__)('Shadow'),
      hasValue: hasShadow,
      onDeselect: resetShadow,
      isShownByDefault: defaultControls.shadow,
      panelId: panelId,
      children: [hasBorderControl ? /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, {
        as: "legend",
        children: (0,external_wp_i18n_namespaceObject.__)('Shadow')
      }) : null, /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalItemGroup, {
        isBordered: true,
        isSeparated: true,
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ShadowPopover, {
          shadow: shadow,
          onShadowChange: setShadow,
          settings: settings
        })
      })]
    })]
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/border.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */








const BORDER_SUPPORT_KEY = '__experimentalBorder';
const SHADOW_SUPPORT_KEY = 'shadow';
const getColorByProperty = (colors, property, value) => {
  let matchedColor;
  colors.some(origin => origin.colors.some(color => {
    if (color[property] === value) {
      matchedColor = color;
      return true;
    }
    return false;
  }));
  return matchedColor;
};
const getMultiOriginColor = ({
  colors,
  namedColor,
  customColor
}) => {
  // Search each origin (default, theme, or user) for matching color by name.
  if (namedColor) {
    const colorObject = getColorByProperty(colors, 'slug', namedColor);
    if (colorObject) {
      return colorObject;
    }
  }

  // Skip if no custom color or matching named color.
  if (!customColor) {
    return {
      color: undefined
    };
  }

  // Attempt to find color via custom color value or build new object.
  const colorObject = getColorByProperty(colors, 'color', customColor);
  return colorObject ? colorObject : {
    color: customColor
  };
};
function getColorSlugFromVariable(value) {
  const namedColor = /var:preset\|color\|(.+)/.exec(value);
  if (namedColor && namedColor[1]) {
    return namedColor[1];
  }
  return null;
}
function styleToAttributes(style) {
  if ((0,external_wp_components_namespaceObject.__experimentalHasSplitBorders)(style?.border)) {
    return {
      style,
      borderColor: undefined
    };
  }
  const borderColorValue = style?.border?.color;
  const borderColorSlug = borderColorValue?.startsWith('var:preset|color|') ? borderColorValue.substring('var:preset|color|'.length) : undefined;
  const updatedStyle = {
    ...style
  };
  updatedStyle.border = {
    ...updatedStyle.border,
    color: borderColorSlug ? undefined : borderColorValue
  };
  return {
    style: utils_cleanEmptyObject(updatedStyle),
    borderColor: borderColorSlug
  };
}
function attributesToStyle(attributes) {
  if ((0,external_wp_components_namespaceObject.__experimentalHasSplitBorders)(attributes.style?.border)) {
    return attributes.style;
  }
  return {
    ...attributes.style,
    border: {
      ...attributes.style?.border,
      color: attributes.borderColor ? 'var:preset|color|' + attributes.borderColor : attributes.style?.border?.color
    }
  };
}
function BordersInspectorControl({
  label,
  children,
  resetAllFilter
}) {
  const attributesResetAllFilter = (0,external_wp_element_namespaceObject.useCallback)(attributes => {
    const existingStyle = attributesToStyle(attributes);
    const updatedStyle = resetAllFilter(existingStyle);
    return {
      ...attributes,
      ...styleToAttributes(updatedStyle)
    };
  }, [resetAllFilter]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(inspector_controls, {
    group: "border",
    resetAllFilter: attributesResetAllFilter,
    label: label,
    children: children
  });
}
function border_BorderPanel({
  clientId,
  name,
  setAttributes,
  settings
}) {
  const isEnabled = useHasBorderPanel(settings);
  function selector(select) {
    const {
      style,
      borderColor
    } = select(store).getBlockAttributes(clientId) || {};
    return {
      style,
      borderColor
    };
  }
  const {
    style,
    borderColor
  } = (0,external_wp_data_namespaceObject.useSelect)(selector, [clientId]);
  const value = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return attributesToStyle({
      style,
      borderColor
    });
  }, [style, borderColor]);
  const onChange = newStyle => {
    setAttributes(styleToAttributes(newStyle));
  };
  if (!isEnabled) {
    return null;
  }
  const defaultControls = {
    ...(0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [BORDER_SUPPORT_KEY, '__experimentalDefaultControls']),
    ...(0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [SHADOW_SUPPORT_KEY, '__experimentalDefaultControls'])
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BorderPanel, {
    as: BordersInspectorControl,
    panelId: clientId,
    settings: settings,
    value: value,
    onChange: onChange,
    defaultControls: defaultControls
  });
}

/**
 * Determine whether there is block support for border properties.
 *
 * @param {string} blockName Block name.
 * @param {string} feature   Border feature to check support for.
 *
 * @return {boolean} Whether there is support.
 */
function hasBorderSupport(blockName, feature = 'any') {
  if (external_wp_element_namespaceObject.Platform.OS !== 'web') {
    return false;
  }
  const support = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockName, BORDER_SUPPORT_KEY);
  if (support === true) {
    return true;
  }
  if (feature === 'any') {
    return !!(support?.color || support?.radius || support?.width || support?.style);
  }
  return !!support?.[feature];
}

/**
 * Determine whether there is block support for shadow properties.
 *
 * @param {string} blockName Block name.
 *
 * @return {boolean} Whether there is support.
 */
function hasShadowSupport(blockName) {
  return hasBlockSupport(blockName, SHADOW_SUPPORT_KEY);
}
function useBorderPanelLabel({
  blockName,
  hasBorderControl,
  hasShadowControl
} = {}) {
  const settings = useBlockSettings(blockName);
  const controls = useHasBorderPanelControls(settings);
  if (!hasBorderControl && !hasShadowControl && blockName) {
    hasBorderControl = controls?.hasBorderColor || controls?.hasBorderStyle || controls?.hasBorderWidth || controls?.hasBorderRadius;
    hasShadowControl = controls?.hasShadow;
  }
  if (hasBorderControl && hasShadowControl) {
    return (0,external_wp_i18n_namespaceObject.__)('Border & Shadow');
  }
  if (hasShadowControl) {
    return (0,external_wp_i18n_namespaceObject.__)('Shadow');
  }
  return (0,external_wp_i18n_namespaceObject.__)('Border');
}

/**
 * Returns a new style object where the specified border attribute has been
 * removed.
 *
 * @param {Object} style     Styles from block attributes.
 * @param {string} attribute The border style attribute to clear.
 *
 * @return {Object} Style object with the specified attribute removed.
 */
function removeBorderAttribute(style, attribute) {
  return cleanEmptyObject({
    ...style,
    border: {
      ...style?.border,
      [attribute]: undefined
    }
  });
}

/**
 * Filters registered block settings, extending attributes to include
 * `borderColor` if needed.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Updated block settings.
 */
function addAttributes(settings) {
  if (!hasBorderSupport(settings, 'color')) {
    return settings;
  }

  // Allow blocks to specify default value if needed.
  if (settings.attributes.borderColor) {
    return settings;
  }

  // Add new borderColor attribute to block settings.
  return {
    ...settings,
    attributes: {
      ...settings.attributes,
      borderColor: {
        type: 'string'
      }
    }
  };
}

/**
 * Override props assigned to save component to inject border color.
 *
 * @param {Object}        props           Additional props applied to save element.
 * @param {Object|string} blockNameOrType Block type definition.
 * @param {Object}        attributes      Block's attributes.
 *
 * @return {Object} Filtered props to apply to save element.
 */
function border_addSaveProps(props, blockNameOrType, attributes) {
  if (!hasBorderSupport(blockNameOrType, 'color') || shouldSkipSerialization(blockNameOrType, BORDER_SUPPORT_KEY, 'color')) {
    return props;
  }
  const borderClasses = getBorderClasses(attributes);
  const newClassName = dist_clsx(props.className, borderClasses);

  // If we are clearing the last of the previous classes in `className`
  // set it to `undefined` to avoid rendering empty DOM attributes.
  props.className = newClassName ? newClassName : undefined;
  return props;
}

/**
 * Generates a CSS class name consisting of all the applicable border color
 * classes given the current block attributes.
 *
 * @param {Object} attributes Block's attributes.
 *
 * @return {string} CSS class name.
 */
function getBorderClasses(attributes) {
  const {
    borderColor,
    style
  } = attributes;
  const borderColorClass = getColorClassName('border-color', borderColor);
  return dist_clsx({
    'has-border-color': borderColor || style?.border?.color,
    [borderColorClass]: !!borderColorClass
  });
}
function border_useBlockProps({
  name,
  borderColor,
  style
}) {
  const {
    colors
  } = useMultipleOriginColorsAndGradients();
  if (!hasBorderSupport(name, 'color') || shouldSkipSerialization(name, BORDER_SUPPORT_KEY, 'color')) {
    return {};
  }
  const {
    color: borderColorValue
  } = getMultiOriginColor({
    colors,
    namedColor: borderColor
  });
  const {
    color: borderTopColor
  } = getMultiOriginColor({
    colors,
    namedColor: getColorSlugFromVariable(style?.border?.top?.color)
  });
  const {
    color: borderRightColor
  } = getMultiOriginColor({
    colors,
    namedColor: getColorSlugFromVariable(style?.border?.right?.color)
  });
  const {
    color: borderBottomColor
  } = getMultiOriginColor({
    colors,
    namedColor: getColorSlugFromVariable(style?.border?.bottom?.color)
  });
  const {
    color: borderLeftColor
  } = getMultiOriginColor({
    colors,
    namedColor: getColorSlugFromVariable(style?.border?.left?.color)
  });
  const extraStyles = {
    borderTopColor: borderTopColor || borderColorValue,
    borderRightColor: borderRightColor || borderColorValue,
    borderBottomColor: borderBottomColor || borderColorValue,
    borderLeftColor: borderLeftColor || borderColorValue
  };
  return border_addSaveProps({
    style: utils_cleanEmptyObject(extraStyles) || {}
  }, name, {
    borderColor,
    style
  });
}
/* harmony default export */ const border = ({
  useBlockProps: border_useBlockProps,
  addSaveProps: border_addSaveProps,
  attributeKeys: ['borderColor', 'style'],
  hasSupport(name) {
    return hasBorderSupport(name, 'color');
  }
});
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/border/addAttributes', addAttributes);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/gradients/use-gradient.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function __experimentalGetGradientClass(gradientSlug) {
  if (!gradientSlug) {
    return undefined;
  }
  return `has-${gradientSlug}-gradient-background`;
}

/**
 * Retrieves the gradient value per slug.
 *
 * @param {Array}  gradients Gradient Palette
 * @param {string} slug      Gradient slug
 *
 * @return {string} Gradient value.
 */
function getGradientValueBySlug(gradients, slug) {
  const gradient = gradients?.find(g => g.slug === slug);
  return gradient && gradient.gradient;
}
function __experimentalGetGradientObjectByGradientValue(gradients, value) {
  const gradient = gradients?.find(g => g.gradient === value);
  return gradient;
}

/**
 * Retrieves the gradient slug per slug.
 *
 * @param {Array}  gradients Gradient Palette
 * @param {string} value     Gradient value
 * @return {string} Gradient slug.
 */
function getGradientSlugByValue(gradients, value) {
  const gradient = __experimentalGetGradientObjectByGradientValue(gradients, value);
  return gradient && gradient.slug;
}
function __experimentalUseGradient({
  gradientAttribute = 'gradient',
  customGradientAttribute = 'customGradient'
} = {}) {
  const {
    clientId
  } = useBlockEditContext();
  const [userGradientPalette, themeGradientPalette, defaultGradientPalette] = use_settings_useSettings('color.gradients.custom', 'color.gradients.theme', 'color.gradients.default');
  const allGradients = (0,external_wp_element_namespaceObject.useMemo)(() => [...(userGradientPalette || []), ...(themeGradientPalette || []), ...(defaultGradientPalette || [])], [userGradientPalette, themeGradientPalette, defaultGradientPalette]);
  const {
    gradient,
    customGradient
  } = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const {
      getBlockAttributes
    } = select(store);
    const attributes = getBlockAttributes(clientId) || {};
    return {
      customGradient: attributes[customGradientAttribute],
      gradient: attributes[gradientAttribute]
    };
  }, [clientId, gradientAttribute, customGradientAttribute]);
  const {
    updateBlockAttributes
  } = (0,external_wp_data_namespaceObject.useDispatch)(store);
  const setGradient = (0,external_wp_element_namespaceObject.useCallback)(newGradientValue => {
    const slug = getGradientSlugByValue(allGradients, newGradientValue);
    if (slug) {
      updateBlockAttributes(clientId, {
        [gradientAttribute]: slug,
        [customGradientAttribute]: undefined
      });
      return;
    }
    updateBlockAttributes(clientId, {
      [gradientAttribute]: undefined,
      [customGradientAttribute]: newGradientValue
    });
  }, [allGradients, clientId, updateBlockAttributes]);
  const gradientClass = __experimentalGetGradientClass(gradient);
  let gradientValue;
  if (gradient) {
    gradientValue = getGradientValueBySlug(allGradients, gradient);
  } else {
    gradientValue = customGradient;
  }
  return {
    gradientClass,
    gradientValue,
    setGradient
  };
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/colors-gradients/control.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




const {
  Tabs
} = unlock(external_wp_components_namespaceObject.privateApis);
const colorsAndGradientKeys = ['colors', 'disableCustomColors', 'gradients', 'disableCustomGradients'];
const TAB_IDS = {
  color: 'color',
  gradient: 'gradient'
};
function ColorGradientControlInner({
  colors,
  gradients,
  disableCustomColors,
  disableCustomGradients,
  __experimentalIsRenderedInSidebar,
  className,
  label,
  onColorChange,
  onGradientChange,
  colorValue,
  gradientValue,
  clearable,
  showTitle = true,
  enableAlpha,
  headingLevel
}) {
  const canChooseAColor = onColorChange && (colors && colors.length > 0 || !disableCustomColors);
  const canChooseAGradient = onGradientChange && (gradients && gradients.length > 0 || !disableCustomGradients);
  if (!canChooseAColor && !canChooseAGradient) {
    return null;
  }
  const tabPanels = {
    [TAB_IDS.color]: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ColorPalette, {
      value: colorValue,
      onChange: canChooseAGradient ? newColor => {
        onColorChange(newColor);
        onGradientChange();
      } : onColorChange,
      colors,
      disableCustomColors,
      __experimentalIsRenderedInSidebar: __experimentalIsRenderedInSidebar,
      clearable: clearable,
      enableAlpha: enableAlpha,
      headingLevel: headingLevel
    }),
    [TAB_IDS.gradient]: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.GradientPicker, {
      value: gradientValue,
      onChange: canChooseAColor ? newGradient => {
        onGradientChange(newGradient);
        onColorChange();
      } : onGradientChange,
      gradients,
      disableCustomGradients,
      __experimentalIsRenderedInSidebar: __experimentalIsRenderedInSidebar,
      clearable: clearable,
      headingLevel: headingLevel
    })
  };
  const renderPanelType = type => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
    className: "block-editor-color-gradient-control__panel",
    children: tabPanels[type]
  });
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl, {
    __nextHasNoMarginBottom: true,
    className: dist_clsx('block-editor-color-gradient-control', className),
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("fieldset", {
      className: "block-editor-color-gradient-control__fieldset",
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalVStack, {
        spacing: 1,
        children: [showTitle && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("legend", {
          children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
            className: "block-editor-color-gradient-control__color-indicator",
            children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, {
              children: label
            })
          })
        }), canChooseAColor && canChooseAGradient && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
          children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(Tabs, {
            defaultTabId: gradientValue ? TAB_IDS.gradient : !!canChooseAColor && TAB_IDS.color,
            children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(Tabs.TabList, {
              children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Tabs.Tab, {
                tabId: TAB_IDS.color,
                children: (0,external_wp_i18n_namespaceObject.__)('Color')
              }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Tabs.Tab, {
                tabId: TAB_IDS.gradient,
                children: (0,external_wp_i18n_namespaceObject.__)('Gradient')
              })]
            }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Tabs.TabPanel, {
              tabId: TAB_IDS.color,
              className: "block-editor-color-gradient-control__panel",
              focusable: false,
              children: tabPanels.color
            }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(Tabs.TabPanel, {
              tabId: TAB_IDS.gradient,
              className: "block-editor-color-gradient-control__panel",
              focusable: false,
              children: tabPanels.gradient
            })]
          })
        }), !canChooseAGradient && renderPanelType(TAB_IDS.color), !canChooseAColor && renderPanelType(TAB_IDS.gradient)]
      })
    })
  });
}
function ColorGradientControlSelect(props) {
  const [colors, gradients, customColors, customGradients] = use_settings_useSettings('color.palette', 'color.gradients', 'color.custom', 'color.customGradient');
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ColorGradientControlInner, {
    colors: colors,
    gradients: gradients,
    disableCustomColors: !customColors,
    disableCustomGradients: !customGradients,
    ...props
  });
}
function ColorGradientControl(props) {
  if (colorsAndGradientKeys.every(key => props.hasOwnProperty(key))) {
    return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ColorGradientControlInner, {
      ...props
    });
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ColorGradientControlSelect, {
    ...props
  });
}
/* harmony default export */ const control = (ColorGradientControl);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/global-styles/color-panel.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */







function useHasColorPanel(settings) {
  const hasTextPanel = useHasTextPanel(settings);
  const hasBackgroundPanel = color_panel_useHasBackgroundPanel(settings);
  const hasLinkPanel = useHasLinkPanel(settings);
  const hasHeadingPanel = useHasHeadingPanel(settings);
  const hasButtonPanel = useHasButtonPanel(settings);
  const hasCaptionPanel = useHasCaptionPanel(settings);
  return hasTextPanel || hasBackgroundPanel || hasLinkPanel || hasHeadingPanel || hasButtonPanel || hasCaptionPanel;
}
function useHasTextPanel(settings) {
  const colors = useColorsPerOrigin(settings);
  return settings?.color?.text && (colors?.length > 0 || settings?.color?.custom);
}
function useHasLinkPanel(settings) {
  const colors = useColorsPerOrigin(settings);
  return settings?.color?.link && (colors?.length > 0 || settings?.color?.custom);
}
function useHasCaptionPanel(settings) {
  const colors = useColorsPerOrigin(settings);
  return settings?.color?.caption && (colors?.length > 0 || settings?.color?.custom);
}
function useHasHeadingPanel(settings) {
  const colors = useColorsPerOrigin(settings);
  const gradients = useGradientsPerOrigin(settings);
  return settings?.color?.heading && (colors?.length > 0 || settings?.color?.custom || gradients?.length > 0 || settings?.color?.customGradient);
}
function useHasButtonPanel(settings) {
  const colors = useColorsPerOrigin(settings);
  const gradients = useGradientsPerOrigin(settings);
  return settings?.color?.button && (colors?.length > 0 || settings?.color?.custom || gradients?.length > 0 || settings?.color?.customGradient);
}
function color_panel_useHasBackgroundPanel(settings) {
  const colors = useColorsPerOrigin(settings);
  const gradients = useGradientsPerOrigin(settings);
  return settings?.color?.background && (colors?.length > 0 || settings?.color?.custom || gradients?.length > 0 || settings?.color?.customGradient);
}
function ColorToolsPanel({
  resetAllFilter,
  onChange,
  value,
  panelId,
  children
}) {
  const resetAll = () => {
    const updatedValue = resetAllFilter(value);
    onChange(updatedValue);
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanel, {
    label: (0,external_wp_i18n_namespaceObject.__)('Elements'),
    resetAll: resetAll,
    panelId: panelId,
    hasInnerWrapper: true,
    headingLevel: 3,
    className: "color-block-support-panel",
    __experimentalFirstVisibleItemClass: "first",
    __experimentalLastVisibleItemClass: "last",
    dropdownMenuProps: TOOLSPANEL_DROPDOWNMENU_PROPS,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: "color-block-support-panel__inner-wrapper",
      children: children
    })
  });
}
const color_panel_DEFAULT_CONTROLS = {
  text: true,
  background: true,
  link: true,
  heading: true,
  button: true,
  caption: true
};
const popoverProps = {
  placement: 'left-start',
  offset: 36,
  shift: true
};
const {
  Tabs: color_panel_Tabs
} = unlock(external_wp_components_namespaceObject.privateApis);
const LabeledColorIndicators = ({
  indicators,
  label
}) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_components_namespaceObject.__experimentalHStack, {
  justify: "flex-start",
  children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalZStack, {
    isLayered: false,
    offset: -8,
    children: indicators.map((indicator, index) => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Flex, {
      expanded: false,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.ColorIndicator, {
        colorValue: indicator
      })
    }, index))
  }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FlexItem, {
    className: "block-editor-panel-color-gradient-settings__color-name",
    title: label,
    children: label
  })]
});
function ColorPanelTab({
  isGradient,
  inheritedValue,
  userValue,
  setValue,
  colorGradientControlSettings
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(control, {
    ...colorGradientControlSettings,
    showTitle: false,
    enableAlpha: true,
    __experimentalIsRenderedInSidebar: true,
    colorValue: isGradient ? undefined : inheritedValue,
    gradientValue: isGradient ? inheritedValue : undefined,
    onColorChange: isGradient ? undefined : setValue,
    onGradientChange: isGradient ? setValue : undefined,
    clearable: inheritedValue === userValue,
    headingLevel: 3
  });
}
function ColorPanelDropdown({
  label,
  hasValue,
  resetValue,
  isShownByDefault,
  indicators,
  tabs,
  colorGradientControlSettings,
  panelId
}) {
  var _tabs$;
  const currentTab = tabs.find(tab => tab.userValue !== undefined);
  const {
    key: firstTabKey,
    ...firstTab
  } = (_tabs$ = tabs[0]) !== null && _tabs$ !== void 0 ? _tabs$ : {};
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
    className: "block-editor-tools-panel-color-gradient-settings__item",
    hasValue: hasValue,
    label: label,
    onDeselect: resetValue,
    isShownByDefault: isShownByDefault,
    panelId: panelId,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Dropdown, {
      popoverProps: popoverProps,
      className: "block-editor-tools-panel-color-gradient-settings__dropdown",
      renderToggle: ({
        onToggle,
        isOpen
      }) => {
        const toggleProps = {
          onClick: onToggle,
          className: dist_clsx('block-editor-panel-color-gradient-settings__dropdown', {
            'is-open': isOpen
          }),
          'aria-expanded': isOpen,
          'aria-label': (0,external_wp_i18n_namespaceObject.sprintf)( /* translators: %s is the type of color property, e.g., "background" */
          (0,external_wp_i18n_namespaceObject.__)('Color %s styles'), label)
        };
        return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          ...toggleProps,
          children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(LabeledColorIndicators, {
            indicators: indicators,
            label: label
          })
        });
      },
      renderContent: () => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalDropdownContentWrapper, {
        paddingSize: "none",
        children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("div", {
          className: "block-editor-panel-color-gradient-settings__dropdown-content",
          children: [tabs.length === 1 && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ColorPanelTab, {
            ...firstTab,
            colorGradientControlSettings: colorGradientControlSettings
          }, firstTabKey), tabs.length > 1 && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(color_panel_Tabs, {
            defaultTabId: currentTab?.key,
            children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(color_panel_Tabs.TabList, {
              children: tabs.map(tab => /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(color_panel_Tabs.Tab, {
                tabId: tab.key,
                children: tab.label
              }, tab.key))
            }), tabs.map(tab => {
              const {
                key: tabKey,
                ...restTabProps
              } = tab;
              return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(color_panel_Tabs.TabPanel, {
                tabId: tabKey,
                focusable: false,
                children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ColorPanelTab, {
                  ...restTabProps,
                  colorGradientControlSettings: colorGradientControlSettings
                }, tabKey)
              }, tabKey);
            })]
          })]
        })
      })
    })
  });
}
function ColorPanel({
  as: Wrapper = ColorToolsPanel,
  value,
  onChange,
  inheritedValue = value,
  settings,
  panelId,
  defaultControls = color_panel_DEFAULT_CONTROLS,
  children
}) {
  const colors = useColorsPerOrigin(settings);
  const gradients = useGradientsPerOrigin(settings);
  const areCustomSolidsEnabled = settings?.color?.custom;
  const areCustomGradientsEnabled = settings?.color?.customGradient;
  const hasSolidColors = colors.length > 0 || areCustomSolidsEnabled;
  const hasGradientColors = gradients.length > 0 || areCustomGradientsEnabled;
  const decodeValue = rawValue => getValueFromVariable({
    settings
  }, '', rawValue);
  const encodeColorValue = colorValue => {
    const allColors = colors.flatMap(({
      colors: originColors
    }) => originColors);
    const colorObject = allColors.find(({
      color
    }) => color === colorValue);
    return colorObject ? 'var:preset|color|' + colorObject.slug : colorValue;
  };
  const encodeGradientValue = gradientValue => {
    const allGradients = gradients.flatMap(({
      gradients: originGradients
    }) => originGradients);
    const gradientObject = allGradients.find(({
      gradient
    }) => gradient === gradientValue);
    return gradientObject ? 'var:preset|gradient|' + gradientObject.slug : gradientValue;
  };

  // BackgroundColor
  const showBackgroundPanel = color_panel_useHasBackgroundPanel(settings);
  const backgroundColor = decodeValue(inheritedValue?.color?.background);
  const userBackgroundColor = decodeValue(value?.color?.background);
  const gradient = decodeValue(inheritedValue?.color?.gradient);
  const userGradient = decodeValue(value?.color?.gradient);
  const hasBackground = () => !!userBackgroundColor || !!userGradient;
  const setBackgroundColor = newColor => {
    const newValue = setImmutably(value, ['color', 'background'], encodeColorValue(newColor));
    newValue.color.gradient = undefined;
    onChange(newValue);
  };
  const setGradient = newGradient => {
    const newValue = setImmutably(value, ['color', 'gradient'], encodeGradientValue(newGradient));
    newValue.color.background = undefined;
    onChange(newValue);
  };
  const resetBackground = () => {
    const newValue = setImmutably(value, ['color', 'background'], undefined);
    newValue.color.gradient = undefined;
    onChange(newValue);
  };

  // Links
  const showLinkPanel = useHasLinkPanel(settings);
  const linkColor = decodeValue(inheritedValue?.elements?.link?.color?.text);
  const userLinkColor = decodeValue(value?.elements?.link?.color?.text);
  const setLinkColor = newColor => {
    onChange(setImmutably(value, ['elements', 'link', 'color', 'text'], encodeColorValue(newColor)));
  };
  const hoverLinkColor = decodeValue(inheritedValue?.elements?.link?.[':hover']?.color?.text);
  const userHoverLinkColor = decodeValue(value?.elements?.link?.[':hover']?.color?.text);
  const setHoverLinkColor = newColor => {
    onChange(setImmutably(value, ['elements', 'link', ':hover', 'color', 'text'], encodeColorValue(newColor)));
  };
  const hasLink = () => !!userLinkColor || !!userHoverLinkColor;
  const resetLink = () => {
    let newValue = setImmutably(value, ['elements', 'link', ':hover', 'color', 'text'], undefined);
    newValue = setImmutably(newValue, ['elements', 'link', 'color', 'text'], undefined);
    onChange(newValue);
  };

  // Text Color
  const showTextPanel = useHasTextPanel(settings);
  const textColor = decodeValue(inheritedValue?.color?.text);
  const userTextColor = decodeValue(value?.color?.text);
  const hasTextColor = () => !!userTextColor;
  const setTextColor = newColor => {
    let changedObject = setImmutably(value, ['color', 'text'], encodeColorValue(newColor));
    if (textColor === linkColor) {
      changedObject = setImmutably(changedObject, ['elements', 'link', 'color', 'text'], encodeColorValue(newColor));
    }
    onChange(changedObject);
  };
  const resetTextColor = () => setTextColor(undefined);

  // Elements
  const elements = [{
    name: 'caption',
    label: (0,external_wp_i18n_namespaceObject.__)('Captions'),
    showPanel: useHasCaptionPanel(settings)
  }, {
    name: 'button',
    label: (0,external_wp_i18n_namespaceObject.__)('Button'),
    showPanel: useHasButtonPanel(settings)
  }, {
    name: 'heading',
    label: (0,external_wp_i18n_namespaceObject.__)('Heading'),
    showPanel: useHasHeadingPanel(settings)
  }, {
    name: 'h1',
    label: (0,external_wp_i18n_namespaceObject.__)('H1'),
    showPanel: useHasHeadingPanel(settings)
  }, {
    name: 'h2',
    label: (0,external_wp_i18n_namespaceObject.__)('H2'),
    showPanel: useHasHeadingPanel(settings)
  }, {
    name: 'h3',
    label: (0,external_wp_i18n_namespaceObject.__)('H3'),
    showPanel: useHasHeadingPanel(settings)
  }, {
    name: 'h4',
    label: (0,external_wp_i18n_namespaceObject.__)('H4'),
    showPanel: useHasHeadingPanel(settings)
  }, {
    name: 'h5',
    label: (0,external_wp_i18n_namespaceObject.__)('H5'),
    showPanel: useHasHeadingPanel(settings)
  }, {
    name: 'h6',
    label: (0,external_wp_i18n_namespaceObject.__)('H6'),
    showPanel: useHasHeadingPanel(settings)
  }];
  const resetAllFilter = (0,external_wp_element_namespaceObject.useCallback)(previousValue => {
    return {
      ...previousValue,
      color: undefined,
      elements: {
        ...previousValue?.elements,
        link: {
          ...previousValue?.elements?.link,
          color: undefined,
          ':hover': {
            color: undefined
          }
        },
        ...elements.reduce((acc, element) => {
          return {
            ...acc,
            [element.name]: {
              ...previousValue?.elements?.[element.name],
              color: undefined
            }
          };
        }, {})
      }
    };
  }, []);
  const items = [showTextPanel && {
    key: 'text',
    label: (0,external_wp_i18n_namespaceObject.__)('Text'),
    hasValue: hasTextColor,
    resetValue: resetTextColor,
    isShownByDefault: defaultControls.text,
    indicators: [textColor],
    tabs: [{
      key: 'text',
      label: (0,external_wp_i18n_namespaceObject.__)('Text'),
      inheritedValue: textColor,
      setValue: setTextColor,
      userValue: userTextColor
    }]
  }, showBackgroundPanel && {
    key: 'background',
    label: (0,external_wp_i18n_namespaceObject.__)('Background'),
    hasValue: hasBackground,
    resetValue: resetBackground,
    isShownByDefault: defaultControls.background,
    indicators: [gradient !== null && gradient !== void 0 ? gradient : backgroundColor],
    tabs: [hasSolidColors && {
      key: 'background',
      label: (0,external_wp_i18n_namespaceObject.__)('Color'),
      inheritedValue: backgroundColor,
      setValue: setBackgroundColor,
      userValue: userBackgroundColor
    }, hasGradientColors && {
      key: 'gradient',
      label: (0,external_wp_i18n_namespaceObject.__)('Gradient'),
      inheritedValue: gradient,
      setValue: setGradient,
      userValue: userGradient,
      isGradient: true
    }].filter(Boolean)
  }, showLinkPanel && {
    key: 'link',
    label: (0,external_wp_i18n_namespaceObject.__)('Link'),
    hasValue: hasLink,
    resetValue: resetLink,
    isShownByDefault: defaultControls.link,
    indicators: [linkColor, hoverLinkColor],
    tabs: [{
      key: 'link',
      label: (0,external_wp_i18n_namespaceObject.__)('Default'),
      inheritedValue: linkColor,
      setValue: setLinkColor,
      userValue: userLinkColor
    }, {
      key: 'hover',
      label: (0,external_wp_i18n_namespaceObject.__)('Hover'),
      inheritedValue: hoverLinkColor,
      setValue: setHoverLinkColor,
      userValue: userHoverLinkColor
    }]
  }].filter(Boolean);
  elements.forEach(({
    name,
    label,
    showPanel
  }) => {
    if (!showPanel) {
      return;
    }
    const elementBackgroundColor = decodeValue(inheritedValue?.elements?.[name]?.color?.background);
    const elementGradient = decodeValue(inheritedValue?.elements?.[name]?.color?.gradient);
    const elementTextColor = decodeValue(inheritedValue?.elements?.[name]?.color?.text);
    const elementBackgroundUserColor = decodeValue(value?.elements?.[name]?.color?.background);
    const elementGradientUserColor = decodeValue(value?.elements?.[name]?.color?.gradient);
    const elementTextUserColor = decodeValue(value?.elements?.[name]?.color?.text);
    const hasElement = () => !!(elementTextUserColor || elementBackgroundUserColor || elementGradientUserColor);
    const resetElement = () => {
      const newValue = setImmutably(value, ['elements', name, 'color', 'background'], undefined);
      newValue.elements[name].color.gradient = undefined;
      newValue.elements[name].color.text = undefined;
      onChange(newValue);
    };
    const setElementTextColor = newTextColor => {
      onChange(setImmutably(value, ['elements', name, 'color', 'text'], encodeColorValue(newTextColor)));
    };
    const setElementBackgroundColor = newBackgroundColor => {
      const newValue = setImmutably(value, ['elements', name, 'color', 'background'], encodeColorValue(newBackgroundColor));
      newValue.elements[name].color.gradient = undefined;
      onChange(newValue);
    };
    const setElementGradient = newGradient => {
      const newValue = setImmutably(value, ['elements', name, 'color', 'gradient'], encodeGradientValue(newGradient));
      newValue.elements[name].color.background = undefined;
      onChange(newValue);
    };
    const supportsTextColor = true;
    // Background color is not supported for `caption`
    // as there isn't yet a way to set padding for the element.
    const supportsBackground = name !== 'caption';
    items.push({
      key: name,
      label,
      hasValue: hasElement,
      resetValue: resetElement,
      isShownByDefault: defaultControls[name],
      indicators: supportsTextColor && supportsBackground ? [elementTextColor, elementGradient !== null && elementGradient !== void 0 ? elementGradient : elementBackgroundColor] : [supportsTextColor ? elementTextColor : elementGradient !== null && elementGradient !== void 0 ? elementGradient : elementBackgroundColor],
      tabs: [hasSolidColors && supportsTextColor && {
        key: 'text',
        label: (0,external_wp_i18n_namespaceObject.__)('Text'),
        inheritedValue: elementTextColor,
        setValue: setElementTextColor,
        userValue: elementTextUserColor
      }, hasSolidColors && supportsBackground && {
        key: 'background',
        label: (0,external_wp_i18n_namespaceObject.__)('Background'),
        inheritedValue: elementBackgroundColor,
        setValue: setElementBackgroundColor,
        userValue: elementBackgroundUserColor
      }, hasGradientColors && supportsBackground && {
        key: 'gradient',
        label: (0,external_wp_i18n_namespaceObject.__)('Gradient'),
        inheritedValue: elementGradient,
        setValue: setElementGradient,
        userValue: elementGradientUserColor,
        isGradient: true
      }].filter(Boolean)
    });
  });
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(Wrapper, {
    resetAllFilter: resetAllFilter,
    value: value,
    onChange: onChange,
    panelId: panelId,
    children: [items.map(item => {
      const {
        key,
        ...restItem
      } = item;
      return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ColorPanelDropdown, {
        ...restItem,
        colorGradientControlSettings: {
          colors,
          disableCustomColors: !areCustomSolidsEnabled,
          gradients,
          disableCustomGradients: !areCustomGradientsEnabled
        },
        panelId: panelId
      }, key);
    }), children]
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/contrast-checker/index.js
/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */




k([names, a11y]);
function ContrastChecker({
  backgroundColor,
  fallbackBackgroundColor,
  fallbackTextColor,
  fallbackLinkColor,
  fontSize,
  // Font size value in pixels.
  isLargeText,
  textColor,
  linkColor,
  enableAlphaChecker = false
}) {
  const currentBackgroundColor = backgroundColor || fallbackBackgroundColor;

  // Must have a background color.
  if (!currentBackgroundColor) {
    return null;
  }
  const currentTextColor = textColor || fallbackTextColor;
  const currentLinkColor = linkColor || fallbackLinkColor;

  // Must have at least one text color.
  if (!currentTextColor && !currentLinkColor) {
    return null;
  }
  const textColors = [{
    color: currentTextColor,
    description: (0,external_wp_i18n_namespaceObject.__)('text color')
  }, {
    color: currentLinkColor,
    description: (0,external_wp_i18n_namespaceObject.__)('link color')
  }];
  const colordBackgroundColor = w(currentBackgroundColor);
  const backgroundColorHasTransparency = colordBackgroundColor.alpha() < 1;
  const backgroundColorBrightness = colordBackgroundColor.brightness();
  const isReadableOptions = {
    level: 'AA',
    size: isLargeText || isLargeText !== false && fontSize >= 24 ? 'large' : 'small'
  };
  let message = '';
  let speakMessage = '';
  for (const item of textColors) {
    // If there is no color, go no further.
    if (!item.color) {
      continue;
    }
    const colordTextColor = w(item.color);
    const isColordTextReadable = colordTextColor.isReadable(colordBackgroundColor, isReadableOptions);
    const textHasTransparency = colordTextColor.alpha() < 1;

    // If the contrast is not readable.
    if (!isColordTextReadable) {
      // Don't show the message if the background or text is transparent.
      if (backgroundColorHasTransparency || textHasTransparency) {
        continue;
      }
      message = backgroundColorBrightness < colordTextColor.brightness() ? (0,external_wp_i18n_namespaceObject.sprintf)(
      // translators: %s is a type of text color, e.g., "text color" or "link color".
      (0,external_wp_i18n_namespaceObject.__)('This color combination may be hard for people to read. Try using a darker background color and/or a brighter %s.'), item.description) : (0,external_wp_i18n_namespaceObject.sprintf)(
      // translators: %s is a type of text color, e.g., "text color" or "link color".
      (0,external_wp_i18n_namespaceObject.__)('This color combination may be hard for people to read. Try using a brighter background color and/or a darker %s.'), item.description);
      speakMessage = (0,external_wp_i18n_namespaceObject.__)('This color combination may be hard for people to read.');
      // Break from the loop when we have a contrast warning.
      // These messages take priority over the transparency warning.
      break;
    }

    // If there is no contrast warning and the text is transparent,
    // show the transparent warning if alpha check is enabled.
    if (textHasTransparency && enableAlphaChecker) {
      message = (0,external_wp_i18n_namespaceObject.__)('Transparent text may be hard for people to read.');
      speakMessage = (0,external_wp_i18n_namespaceObject.__)('Transparent text may be hard for people to read.');
    }
  }
  if (!message) {
    return null;
  }

  // Note: The `Notice` component can speak messages via its `spokenMessage`
  // prop, but the contrast checker requires granular control over when the
  // announcements are made. Notably, the message will be re-announced if a
  // new color combination is selected and the contrast is still insufficient.
  (0,external_wp_a11y_namespaceObject.speak)(speakMessage);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
    className: "block-editor-contrast-checker",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Notice, {
      spokenMessage: null,
      status: "warning",
      isDismissible: false,
      children: message
    })
  });
}

/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/contrast-checker/README.md
 */
/* harmony default export */ const contrast_checker = (ContrastChecker);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/contrast-checker.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function getComputedStyle(node) {
  return node.ownerDocument.defaultView.getComputedStyle(node);
}
function BlockColorContrastChecker({
  clientId
}) {
  const [detectedBackgroundColor, setDetectedBackgroundColor] = (0,external_wp_element_namespaceObject.useState)();
  const [detectedColor, setDetectedColor] = (0,external_wp_element_namespaceObject.useState)();
  const [detectedLinkColor, setDetectedLinkColor] = (0,external_wp_element_namespaceObject.useState)();
  const ref = useBlockRef(clientId);

  // There are so many things that can change the color of a block
  // So we perform this check on every render.
  // eslint-disable-next-line react-hooks/exhaustive-deps
  (0,external_wp_element_namespaceObject.useEffect)(() => {
    if (!ref.current) {
      return;
    }
    setDetectedColor(getComputedStyle(ref.current).color);
    const firstLinkElement = ref.current?.querySelector('a');
    if (firstLinkElement && !!firstLinkElement.innerText) {
      setDetectedLinkColor(getComputedStyle(firstLinkElement).color);
    }
    let backgroundColorNode = ref.current;
    let backgroundColor = getComputedStyle(backgroundColorNode).backgroundColor;
    while (backgroundColor === 'rgba(0, 0, 0, 0)' && backgroundColorNode.parentNode && backgroundColorNode.parentNode.nodeType === backgroundColorNode.parentNode.ELEMENT_NODE) {
      backgroundColorNode = backgroundColorNode.parentNode;
      backgroundColor = getComputedStyle(backgroundColorNode).backgroundColor;
    }
    setDetectedBackgroundColor(backgroundColor);
  });
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(contrast_checker, {
    backgroundColor: detectedBackgroundColor,
    textColor: detectedColor,
    enableAlphaChecker: true,
    linkColor: detectedLinkColor
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/color.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */










const COLOR_SUPPORT_KEY = 'color';
const hasColorSupport = blockNameOrType => {
  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockNameOrType, COLOR_SUPPORT_KEY);
  return colorSupport && (colorSupport.link === true || colorSupport.gradient === true || colorSupport.background !== false || colorSupport.text !== false);
};
const hasLinkColorSupport = blockType => {
  if (external_wp_element_namespaceObject.Platform.OS !== 'web') {
    return false;
  }
  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, COLOR_SUPPORT_KEY);
  return colorSupport !== null && typeof colorSupport === 'object' && !!colorSupport.link;
};
const hasGradientSupport = blockNameOrType => {
  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockNameOrType, COLOR_SUPPORT_KEY);
  return colorSupport !== null && typeof colorSupport === 'object' && !!colorSupport.gradients;
};
const hasBackgroundColorSupport = blockType => {
  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, COLOR_SUPPORT_KEY);
  return colorSupport && colorSupport.background !== false;
};
const hasTextColorSupport = blockType => {
  const colorSupport = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, COLOR_SUPPORT_KEY);
  return colorSupport && colorSupport.text !== false;
};

/**
 * Filters registered block settings, extending attributes to include
 * `backgroundColor` and `textColor` attribute.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */
function color_addAttributes(settings) {
  if (!hasColorSupport(settings)) {
    return settings;
  }

  // Allow blocks to specify their own attribute definition with default values if needed.
  if (!settings.attributes.backgroundColor) {
    Object.assign(settings.attributes, {
      backgroundColor: {
        type: 'string'
      }
    });
  }
  if (!settings.attributes.textColor) {
    Object.assign(settings.attributes, {
      textColor: {
        type: 'string'
      }
    });
  }
  if (hasGradientSupport(settings) && !settings.attributes.gradient) {
    Object.assign(settings.attributes, {
      gradient: {
        type: 'string'
      }
    });
  }
  return settings;
}

/**
 * Override props assigned to save component to inject colors classnames.
 *
 * @param {Object}        props           Additional props applied to save element.
 * @param {Object|string} blockNameOrType Block type.
 * @param {Object}        attributes      Block attributes.
 *
 * @return {Object} Filtered props applied to save element.
 */
function color_addSaveProps(props, blockNameOrType, attributes) {
  if (!hasColorSupport(blockNameOrType) || shouldSkipSerialization(blockNameOrType, COLOR_SUPPORT_KEY)) {
    return props;
  }
  const hasGradient = hasGradientSupport(blockNameOrType);

  // I'd have preferred to avoid the "style" attribute usage here
  const {
    backgroundColor,
    textColor,
    gradient,
    style
  } = attributes;
  const shouldSerialize = feature => !shouldSkipSerialization(blockNameOrType, COLOR_SUPPORT_KEY, feature);

  // Primary color classes must come before the `has-text-color`,
  // `has-background` and `has-link-color` classes to maintain backwards
  // compatibility and avoid block invalidations.
  const textClass = shouldSerialize('text') ? getColorClassName('color', textColor) : undefined;
  const gradientClass = shouldSerialize('gradients') ? __experimentalGetGradientClass(gradient) : undefined;
  const backgroundClass = shouldSerialize('background') ? getColorClassName('background-color', backgroundColor) : undefined;
  const serializeHasBackground = shouldSerialize('background') || shouldSerialize('gradients');
  const hasBackground = backgroundColor || style?.color?.background || hasGradient && (gradient || style?.color?.gradient);
  const newClassName = dist_clsx(props.className, textClass, gradientClass, {
    // Don't apply the background class if there's a custom gradient.
    [backgroundClass]: (!hasGradient || !style?.color?.gradient) && !!backgroundClass,
    'has-text-color': shouldSerialize('text') && (textColor || style?.color?.text),
    'has-background': serializeHasBackground && hasBackground,
    'has-link-color': shouldSerialize('link') && style?.elements?.link?.color
  });
  props.className = newClassName ? newClassName : undefined;
  return props;
}
function color_styleToAttributes(style) {
  const textColorValue = style?.color?.text;
  const textColorSlug = textColorValue?.startsWith('var:preset|color|') ? textColorValue.substring('var:preset|color|'.length) : undefined;
  const backgroundColorValue = style?.color?.background;
  const backgroundColorSlug = backgroundColorValue?.startsWith('var:preset|color|') ? backgroundColorValue.substring('var:preset|color|'.length) : undefined;
  const gradientValue = style?.color?.gradient;
  const gradientSlug = gradientValue?.startsWith('var:preset|gradient|') ? gradientValue.substring('var:preset|gradient|'.length) : undefined;
  const updatedStyle = {
    ...style
  };
  updatedStyle.color = {
    ...updatedStyle.color,
    text: textColorSlug ? undefined : textColorValue,
    background: backgroundColorSlug ? undefined : backgroundColorValue,
    gradient: gradientSlug ? undefined : gradientValue
  };
  return {
    style: utils_cleanEmptyObject(updatedStyle),
    textColor: textColorSlug,
    backgroundColor: backgroundColorSlug,
    gradient: gradientSlug
  };
}
function color_attributesToStyle(attributes) {
  return {
    ...attributes.style,
    color: {
      ...attributes.style?.color,
      text: attributes.textColor ? 'var:preset|color|' + attributes.textColor : attributes.style?.color?.text,
      background: attributes.backgroundColor ? 'var:preset|color|' + attributes.backgroundColor : attributes.style?.color?.background,
      gradient: attributes.gradient ? 'var:preset|gradient|' + attributes.gradient : attributes.style?.color?.gradient
    }
  };
}
function ColorInspectorControl({
  children,
  resetAllFilter
}) {
  const attributesResetAllFilter = (0,external_wp_element_namespaceObject.useCallback)(attributes => {
    const existingStyle = color_attributesToStyle(attributes);
    const updatedStyle = resetAllFilter(existingStyle);
    return {
      ...attributes,
      ...color_styleToAttributes(updatedStyle)
    };
  }, [resetAllFilter]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(inspector_controls, {
    group: "color",
    resetAllFilter: attributesResetAllFilter,
    children: children
  });
}
function ColorEdit({
  clientId,
  name,
  setAttributes,
  settings
}) {
  const isEnabled = useHasColorPanel(settings);
  function selector(select) {
    const {
      style,
      textColor,
      backgroundColor,
      gradient
    } = select(store).getBlockAttributes(clientId) || {};
    return {
      style,
      textColor,
      backgroundColor,
      gradient
    };
  }
  const {
    style,
    textColor,
    backgroundColor,
    gradient
  } = (0,external_wp_data_namespaceObject.useSelect)(selector, [clientId]);
  const value = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return color_attributesToStyle({
      style,
      textColor,
      backgroundColor,
      gradient
    });
  }, [style, textColor, backgroundColor, gradient]);
  const onChange = newStyle => {
    setAttributes(color_styleToAttributes(newStyle));
  };
  if (!isEnabled) {
    return null;
  }
  const defaultControls = (0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [COLOR_SUPPORT_KEY, '__experimentalDefaultControls']);
  const enableContrastChecking = external_wp_element_namespaceObject.Platform.OS === 'web' && !value?.color?.gradient && (settings?.color?.text || settings?.color?.link) &&
  // Contrast checking is enabled by default.
  // Deactivating it requires `enableContrastChecker` to have
  // an explicit value of `false`.
  false !== (0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [COLOR_SUPPORT_KEY, 'enableContrastChecker']);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(ColorPanel, {
    as: ColorInspectorControl,
    panelId: clientId,
    settings: settings,
    value: value,
    onChange: onChange,
    defaultControls: defaultControls,
    enableContrastChecker: false !== (0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [COLOR_SUPPORT_KEY, 'enableContrastChecker']),
    children: enableContrastChecking && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(BlockColorContrastChecker, {
      clientId: clientId
    })
  });
}
function color_useBlockProps({
  name,
  backgroundColor,
  textColor,
  gradient,
  style
}) {
  const [userPalette, themePalette, defaultPalette] = use_settings_useSettings('color.palette.custom', 'color.palette.theme', 'color.palette.default');
  const colors = (0,external_wp_element_namespaceObject.useMemo)(() => [...(userPalette || []), ...(themePalette || []), ...(defaultPalette || [])], [userPalette, themePalette, defaultPalette]);
  if (!hasColorSupport(name) || shouldSkipSerialization(name, COLOR_SUPPORT_KEY)) {
    return {};
  }
  const extraStyles = {};
  if (textColor && !shouldSkipSerialization(name, COLOR_SUPPORT_KEY, 'text')) {
    extraStyles.color = getColorObjectByAttributeValues(colors, textColor)?.color;
  }
  if (backgroundColor && !shouldSkipSerialization(name, COLOR_SUPPORT_KEY, 'background')) {
    extraStyles.backgroundColor = getColorObjectByAttributeValues(colors, backgroundColor)?.color;
  }
  const saveProps = color_addSaveProps({
    style: extraStyles
  }, name, {
    textColor,
    backgroundColor,
    gradient,
    style
  });
  const hasBackgroundValue = backgroundColor || style?.color?.background || gradient || style?.color?.gradient;
  return {
    ...saveProps,
    className: dist_clsx(saveProps.className,
    // Add background image classes in the editor, if not already handled by background color values.
    !hasBackgroundValue && getBackgroundImageClasses(style))
  };
}
/* harmony default export */ const color = ({
  useBlockProps: color_useBlockProps,
  addSaveProps: color_addSaveProps,
  attributeKeys: ['backgroundColor', 'textColor', 'gradient', 'style'],
  hasSupport: hasColorSupport
});
const MIGRATION_PATHS = {
  linkColor: [['style', 'elements', 'link', 'color', 'text']],
  textColor: [['textColor'], ['style', 'color', 'text']],
  backgroundColor: [['backgroundColor'], ['style', 'color', 'background']],
  gradient: [['gradient'], ['style', 'color', 'gradient']]
};
function color_addTransforms(result, source, index, results) {
  const destinationBlockType = result.name;
  const activeSupports = {
    linkColor: hasLinkColorSupport(destinationBlockType),
    textColor: hasTextColorSupport(destinationBlockType),
    backgroundColor: hasBackgroundColorSupport(destinationBlockType),
    gradient: hasGradientSupport(destinationBlockType)
  };
  return transformStyles(activeSupports, MIGRATION_PATHS, result, source, index, results);
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/color/addAttribute', color_addAttributes);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.switchToBlockType.transformedBlock', 'core/color/addTransforms', color_addTransforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/font-family/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function FontFamilyControl({
  value = '',
  onChange,
  fontFamilies,
  ...props
}) {
  const [blockLevelFontFamilies] = use_settings_useSettings('typography.fontFamilies');
  if (!fontFamilies) {
    fontFamilies = blockLevelFontFamilies;
  }
  if (!fontFamilies || fontFamilies.length === 0) {
    return null;
  }
  const options = [{
    value: '',
    label: (0,external_wp_i18n_namespaceObject.__)('Default')
  }, ...fontFamilies.map(({
    fontFamily,
    name
  }) => {
    return {
      value: fontFamily,
      label: name || fontFamily
    };
  })];
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.SelectControl, {
    label: (0,external_wp_i18n_namespaceObject.__)('Font'),
    options: options,
    value: value,
    onChange: onChange,
    labelPosition: "top",
    ...props
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/font-appearance-control/index.js
/**
 * WordPress dependencies
 */




const FONT_STYLES = [{
  name: (0,external_wp_i18n_namespaceObject._x)('Regular', 'font style'),
  value: 'normal'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Italic', 'font style'),
  value: 'italic'
}];
const FONT_WEIGHTS = [{
  name: (0,external_wp_i18n_namespaceObject._x)('Thin', 'font weight'),
  value: '100'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Extra Light', 'font weight'),
  value: '200'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Light', 'font weight'),
  value: '300'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Regular', 'font weight'),
  value: '400'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Medium', 'font weight'),
  value: '500'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Semi Bold', 'font weight'),
  value: '600'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Bold', 'font weight'),
  value: '700'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Extra Bold', 'font weight'),
  value: '800'
}, {
  name: (0,external_wp_i18n_namespaceObject._x)('Black', 'font weight'),
  value: '900'
}];

/**
 * Adjusts font appearance field label in case either font styles or weights
 * are disabled.
 *
 * @param {boolean} hasFontStyles  Whether font styles are enabled and present.
 * @param {boolean} hasFontWeights Whether font weights are enabled and present.
 * @return {string} A label representing what font appearance is being edited.
 */
const getFontAppearanceLabel = (hasFontStyles, hasFontWeights) => {
  if (!hasFontStyles) {
    return (0,external_wp_i18n_namespaceObject.__)('Font weight');
  }
  if (!hasFontWeights) {
    return (0,external_wp_i18n_namespaceObject.__)('Font style');
  }
  return (0,external_wp_i18n_namespaceObject.__)('Appearance');
};

/**
 * Control to display unified font style and weight options.
 *
 * @param {Object} props Component props.
 *
 * @return {Element} Font appearance control.
 */
function FontAppearanceControl(props) {
  const {
    onChange,
    hasFontStyles = true,
    hasFontWeights = true,
    value: {
      fontStyle,
      fontWeight
    },
    ...otherProps
  } = props;
  const hasStylesOrWeights = hasFontStyles || hasFontWeights;
  const label = getFontAppearanceLabel(hasFontStyles, hasFontWeights);
  const defaultOption = {
    key: 'default',
    name: (0,external_wp_i18n_namespaceObject.__)('Default'),
    style: {
      fontStyle: undefined,
      fontWeight: undefined
    }
  };

  // Combines both font style and weight options into a single dropdown.
  const combineOptions = () => {
    const combinedOptions = [defaultOption];
    FONT_STYLES.forEach(({
      name: styleName,
      value: styleValue
    }) => {
      FONT_WEIGHTS.forEach(({
        name: weightName,
        value: weightValue
      }) => {
        const optionName = styleValue === 'normal' ? weightName : (0,external_wp_i18n_namespaceObject.sprintf)( /* translators: 1: Font weight name. 2: Font style name. */
        (0,external_wp_i18n_namespaceObject.__)('%1$s %2$s'), weightName, styleName);
        combinedOptions.push({
          key: `${styleValue}-${weightValue}`,
          name: optionName,
          style: {
            fontStyle: styleValue,
            fontWeight: weightValue
          }
        });
      });
    });
    return combinedOptions;
  };

  // Generates select options for font styles only.
  const styleOptions = () => {
    const combinedOptions = [defaultOption];
    FONT_STYLES.forEach(({
      name,
      value
    }) => {
      combinedOptions.push({
        key: value,
        name,
        style: {
          fontStyle: value,
          fontWeight: undefined
        }
      });
    });
    return combinedOptions;
  };

  // Generates select options for font weights only.
  const weightOptions = () => {
    const combinedOptions = [defaultOption];
    FONT_WEIGHTS.forEach(({
      name,
      value
    }) => {
      combinedOptions.push({
        key: value,
        name,
        style: {
          fontStyle: undefined,
          fontWeight: value
        }
      });
    });
    return combinedOptions;
  };

  // Map font styles and weights to select options.
  const selectOptions = (0,external_wp_element_namespaceObject.useMemo)(() => {
    if (hasFontStyles && hasFontWeights) {
      return combineOptions();
    }
    return hasFontStyles ? styleOptions() : weightOptions();
  }, [props.options]);

  // Find current selection by comparing font style & weight against options,
  // and fall back to the Default option if there is no matching option.
  const currentSelection = selectOptions.find(option => option.style.fontStyle === fontStyle && option.style.fontWeight === fontWeight) || selectOptions[0];

  // Adjusts screen reader description based on styles or weights.
  const getDescribedBy = () => {
    if (!currentSelection) {
      return (0,external_wp_i18n_namespaceObject.__)('No selected font appearance');
    }
    if (!hasFontStyles) {
      return (0,external_wp_i18n_namespaceObject.sprintf)(
      // translators: %s: Currently selected font weight.
      (0,external_wp_i18n_namespaceObject.__)('Currently selected font weight: %s'), currentSelection.name);
    }
    if (!hasFontWeights) {
      return (0,external_wp_i18n_namespaceObject.sprintf)(
      // translators: %s: Currently selected font style.
      (0,external_wp_i18n_namespaceObject.__)('Currently selected font style: %s'), currentSelection.name);
    }
    return (0,external_wp_i18n_namespaceObject.sprintf)(
    // translators: %s: Currently selected font appearance.
    (0,external_wp_i18n_namespaceObject.__)('Currently selected font appearance: %s'), currentSelection.name);
  };
  return hasStylesOrWeights && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.CustomSelectControl, {
    ...otherProps,
    className: "components-font-appearance-control",
    label: label,
    describedBy: getDescribedBy(),
    options: selectOptions,
    value: currentSelection,
    onChange: ({
      selectedItem
    }) => onChange(selectedItem.style)
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/line-height-control/utils.js
const BASE_DEFAULT_VALUE = 1.5;
const STEP = 0.01;
/**
 * A spin factor of 10 allows the spin controls to increment/decrement by 0.1.
 * e.g. A line-height value of 1.55 will increment to 1.65.
 */
const SPIN_FACTOR = 10;
/**
 * There are varying value types within LineHeightControl:
 *
 * {undefined} Initial value. No changes from the user.
 * {string} Input value. Value consumed/outputted by the input. Empty would be ''.
 * {number} Block attribute type. Input value needs to be converted for attribute setting.
 *
 * Note: If the value is undefined, the input requires it to be an empty string ('')
 * in order to be considered "controlled" by props (rather than internal state).
 */
const RESET_VALUE = '';

/**
 * Determines if the lineHeight attribute has been properly defined.
 *
 * @param {any} lineHeight The value to check.
 *
 * @return {boolean} Whether the lineHeight attribute is valid.
 */
function isLineHeightDefined(lineHeight) {
  return lineHeight !== undefined && lineHeight !== RESET_VALUE;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/line-height-control/index.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


const line_height_control_LineHeightControl = ({
  value: lineHeight,
  onChange,
  /** Start opting into the new margin-free styles that will become the default in a future version. */
  __nextHasNoMarginBottom = false,
  __unstableInputWidth = '60px',
  ...otherProps
}) => {
  const isDefined = isLineHeightDefined(lineHeight);
  const adjustNextValue = (nextValue, wasTypedOrPasted) => {
    // Set the next value without modification if lineHeight has been defined.
    if (isDefined) {
      return nextValue;
    }

    /**
     * The following logic handles the initial spin up/down action
     * (from an undefined value state) so that the next values are better suited for
     * line-height rendering. For example, the first spin up should immediately
     * go to 1.6, rather than the normally expected 0.1.
     *
     * Spin up/down actions can be triggered by keydowns of the up/down arrow keys,
     * dragging the input or by clicking the spin buttons.
     */
    const spin = STEP * SPIN_FACTOR;
    switch (`${nextValue}`) {
      case `${spin}`:
        // Increment by spin value.
        return BASE_DEFAULT_VALUE + spin;
      case '0':
        {
          // This means the user explicitly input '0', rather than using the
          // spin down action from an undefined value state.
          if (wasTypedOrPasted) {
            return nextValue;
          }
          // Decrement by spin value.
          return BASE_DEFAULT_VALUE - spin;
        }
      case '':
        return BASE_DEFAULT_VALUE;
      default:
        return nextValue;
    }
  };
  const stateReducer = (state, action) => {
    // Be careful when changing this — cross-browser behavior of the
    // `inputType` field in `input` events are inconsistent.
    // For example, Firefox emits an input event with inputType="insertReplacementText"
    // on spin button clicks, while other browsers do not even emit an input event.
    const wasTypedOrPasted = ['insertText', 'insertFromPaste'].includes(action.payload.event.nativeEvent?.inputType);
    const value = adjustNextValue(state.value, wasTypedOrPasted);
    return {
      ...state,
      value
    };
  };
  const value = isDefined ? lineHeight : RESET_VALUE;
  if (!__nextHasNoMarginBottom) {
    external_wp_deprecated_default()('Bottom margin styles for wp.blockEditor.LineHeightControl', {
      since: '6.0',
      version: '6.4',
      hint: 'Set the `__nextHasNoMarginBottom` prop to true to start opting into the new styles, which will become the default in a future version'
    });
  }
  const deprecatedStyles = __nextHasNoMarginBottom ? undefined : {
    marginBottom: 24
  };
  const handleOnChange = (nextValue, {
    event
  }) => {
    if (nextValue === '') {
      onChange();
      return;
    }
    if (event.type === 'click') {
      onChange(adjustNextValue(`${nextValue}`, false));
      return;
    }
    onChange(`${nextValue}`);
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
    className: "block-editor-line-height-control",
    style: deprecatedStyles,
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalNumberControl, {
      ...otherProps,
      __unstableInputWidth: __unstableInputWidth,
      __unstableStateReducer: stateReducer,
      onChange: handleOnChange,
      label: (0,external_wp_i18n_namespaceObject.__)('Line height'),
      placeholder: BASE_DEFAULT_VALUE,
      step: STEP,
      spinFactor: SPIN_FACTOR,
      value: value,
      min: 0,
      spinControls: "custom"
    })
  });
};

/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/line-height-control/README.md
 */
/* harmony default export */ const line_height_control = (line_height_control_LineHeightControl);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/letter-spacing-control/index.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Control for letter-spacing.
 *
 * @param {Object}                  props                      Component props.
 * @param {string}                  props.value                Currently selected letter-spacing.
 * @param {Function}                props.onChange             Handles change in letter-spacing selection.
 * @param {string|number|undefined} props.__unstableInputWidth Input width to pass through to inner UnitControl. Should be a valid CSS value.
 *
 * @return {Element} Letter-spacing control.
 */

function LetterSpacingControl({
  value,
  onChange,
  __unstableInputWidth = '60px',
  ...otherProps
}) {
  const [availableUnits] = use_settings_useSettings('spacing.units');
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: availableUnits || ['px', 'em', 'rem'],
    defaultValues: {
      px: 2,
      em: 0.2,
      rem: 0.2
    }
  });
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalUnitControl, {
    ...otherProps,
    label: (0,external_wp_i18n_namespaceObject.__)('Letter spacing'),
    value: value,
    __unstableInputWidth: __unstableInputWidth,
    units: units,
    onChange: onChange
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/align-left.js
/**
 * WordPress dependencies
 */


const alignLeft = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M13 5.5H4V4h9v1.5Zm7 7H4V11h16v1.5Zm-7 7H4V18h9v1.5Z"
  })
});
/* harmony default export */ const align_left = (alignLeft);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/align-center.js
/**
 * WordPress dependencies
 */


const align_center_alignCenter = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M7.5 5.5h9V4h-9v1.5Zm-3.5 7h16V11H4v1.5Zm3.5 7h9V18h-9v1.5Z"
  })
});
/* harmony default export */ const align_center = (align_center_alignCenter);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/align-right.js
/**
 * WordPress dependencies
 */


const alignRight = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M11.111 5.5H20V4h-8.889v1.5ZM4 12.5h16V11H4v1.5Zm7.111 7H20V18h-8.889v1.5Z"
  })
});
/* harmony default export */ const align_right = (alignRight);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/align-justify.js
/**
 * WordPress dependencies
 */


const alignJustify = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M4 12.8h16v-1.5H4v1.5zm0 7h12.4v-1.5H4v1.5zM4 4.3v1.5h16V4.3H4z"
  })
});
/* harmony default export */ const align_justify = (alignJustify);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/segmented-text-control/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * @typedef {Object} Option
 * @property {string} label The label of the option.
 * @property {string} value The value of the option.
 * @property {string} icon  The icon of the option.
 */

/**
 * Control to facilitate selecting a text style from a set of options.
 *
 * @param {Object}   props           Component props.
 * @param {string}   props.label     A label for the option.
 * @param {string}   props.value     Currently selected value.
 * @param {Function} props.onChange  Callback to handle onChange.
 * @param {Option[]} props.options   Array of options to display.
 * @param {string}   props.className Additional class name to apply.
 *
 * @return {Element} Element to render.
 */


function SegmentedTextControl({
  label,
  value,
  options,
  onChange,
  className
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)("fieldset", {
    className: dist_clsx('block-editor-segmented-text-control', className),
    children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.BaseControl.VisualLabel, {
      as: "legend",
      children: label
    }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)("div", {
      className: "block-editor-segmented-text-control__buttons",
      children: options.map(option => {
        return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.Button, {
          size: "compact",
          icon: option.icon,
          label: option.label,
          isPressed: option.value === value,
          onClick: () => onChange(option.value)
        }, option.value);
      })
    })]
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/text-alignment-control/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


const TEXT_ALIGNMENT_OPTIONS = [{
  label: (0,external_wp_i18n_namespaceObject.__)('Align text left'),
  value: 'left',
  icon: align_left
}, {
  label: (0,external_wp_i18n_namespaceObject.__)('Align text center'),
  value: 'center',
  icon: align_center
}, {
  label: (0,external_wp_i18n_namespaceObject.__)('Align text right'),
  value: 'right',
  icon: align_right
}, {
  label: (0,external_wp_i18n_namespaceObject.__)('Justify text'),
  value: 'justify',
  icon: align_justify
}];
const DEFAULT_OPTIONS = ['left', 'center', 'right'];

/**
 * Control to facilitate text alignment selections.
 *
 * @param {Object}   props           Component props.
 * @param {string}   props.className Class name to add to the control.
 * @param {string}   props.value     Currently selected text alignment.
 * @param {Function} props.onChange  Handles change in text alignment selection.
 * @param {string[]} props.options   Array of text alignment options to display.
 *
 * @return {Element} Text alignment control.
 */
function TextAlignmentControl({
  className,
  value,
  onChange,
  options = DEFAULT_OPTIONS
}) {
  const validOptions = (0,external_wp_element_namespaceObject.useMemo)(() => TEXT_ALIGNMENT_OPTIONS.filter(option => options.includes(option.value)), [options]);
  if (!validOptions.length) {
    return null;
  }
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(SegmentedTextControl, {
    label: (0,external_wp_i18n_namespaceObject.__)('Text alignment'),
    options: validOptions,
    className: dist_clsx('block-editor-text-alignment-control', className),
    value: value,
    onChange: newValue => {
      onChange(newValue === value ? undefined : newValue);
    }
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/reset.js
/**
 * WordPress dependencies
 */


const reset_reset = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M7 11.5h10V13H7z"
  })
});
/* harmony default export */ const library_reset = (reset_reset);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-uppercase.js
/**
 * WordPress dependencies
 */


const formatUppercase = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M6.1 6.8L2.1 18h1.6l1.1-3h4.3l1.1 3h1.6l-4-11.2H6.1zm-.8 6.8L7 8.9l1.7 4.7H5.3zm15.1-.7c-.4-.5-.9-.8-1.6-1 .4-.2.7-.5.8-.9.2-.4.3-.9.3-1.4 0-.9-.3-1.6-.8-2-.6-.5-1.3-.7-2.4-.7h-3.5V18h4.2c1.1 0 2-.3 2.6-.8.6-.6 1-1.4 1-2.4-.1-.8-.3-1.4-.6-1.9zm-5.7-4.7h1.8c.6 0 1.1.1 1.4.4.3.2.5.7.5 1.3 0 .6-.2 1.1-.5 1.3-.3.2-.8.4-1.4.4h-1.8V8.2zm4 8c-.4.3-.9.5-1.5.5h-2.6v-3.8h2.6c1.4 0 2 .6 2 1.9.1.6-.1 1-.5 1.4z"
  })
});
/* harmony default export */ const format_uppercase = (formatUppercase);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-lowercase.js
/**
 * WordPress dependencies
 */


const formatLowercase = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M11 16.8c-.1-.1-.2-.3-.3-.5v-2.6c0-.9-.1-1.7-.3-2.2-.2-.5-.5-.9-.9-1.2-.4-.2-.9-.3-1.6-.3-.5 0-1 .1-1.5.2s-.9.3-1.2.6l.2 1.2c.4-.3.7-.4 1.1-.5.3-.1.7-.2 1-.2.6 0 1 .1 1.3.4.3.2.4.7.4 1.4-1.2 0-2.3.2-3.3.7s-1.4 1.1-1.4 2.1c0 .7.2 1.2.7 1.6.4.4 1 .6 1.8.6.9 0 1.7-.4 2.4-1.2.1.3.2.5.4.7.1.2.3.3.6.4.3.1.6.1 1.1.1h.1l.2-1.2h-.1c-.4.1-.6 0-.7-.1zM9.2 16c-.2.3-.5.6-.9.8-.3.1-.7.2-1.1.2-.4 0-.7-.1-.9-.3-.2-.2-.3-.5-.3-.9 0-.6.2-1 .7-1.3.5-.3 1.3-.4 2.5-.5v2zm10.6-3.9c-.3-.6-.7-1.1-1.2-1.5-.6-.4-1.2-.6-1.9-.6-.5 0-.9.1-1.4.3-.4.2-.8.5-1.1.8V6h-1.4v12h1.3l.2-1c.2.4.6.6 1 .8.4.2.9.3 1.4.3.7 0 1.2-.2 1.8-.5.5-.4 1-.9 1.3-1.5.3-.6.5-1.3.5-2.1-.1-.6-.2-1.3-.5-1.9zm-1.7 4c-.4.5-.9.8-1.6.8s-1.2-.2-1.7-.7c-.4-.5-.7-1.2-.7-2.1 0-.9.2-1.6.7-2.1.4-.5 1-.7 1.7-.7s1.2.3 1.6.8c.4.5.6 1.2.6 2s-.2 1.4-.6 2z"
  })
});
/* harmony default export */ const format_lowercase = (formatLowercase);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-capitalize.js
/**
 * WordPress dependencies
 */


const formatCapitalize = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M7.1 6.8L3.1 18h1.6l1.1-3h4.3l1.1 3h1.6l-4-11.2H7.1zm-.8 6.8L8 8.9l1.7 4.7H6.3zm14.5-1.5c-.3-.6-.7-1.1-1.2-1.5-.6-.4-1.2-.6-1.9-.6-.5 0-.9.1-1.4.3-.4.2-.8.5-1.1.8V6h-1.4v12h1.3l.2-1c.2.4.6.6 1 .8.4.2.9.3 1.4.3.7 0 1.2-.2 1.8-.5.5-.4 1-.9 1.3-1.5.3-.6.5-1.3.5-2.1-.1-.6-.2-1.3-.5-1.9zm-1.7 4c-.4.5-.9.8-1.6.8s-1.2-.2-1.7-.7c-.4-.5-.7-1.2-.7-2.1 0-.9.2-1.6.7-2.1.4-.5 1-.7 1.7-.7s1.2.3 1.6.8c.4.5.6 1.2.6 2 .1.8-.2 1.4-.6 2z"
  })
});
/* harmony default export */ const format_capitalize = (formatCapitalize);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/text-transform-control/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


const TEXT_TRANSFORMS = [{
  label: (0,external_wp_i18n_namespaceObject.__)('None'),
  value: 'none',
  icon: library_reset
}, {
  label: (0,external_wp_i18n_namespaceObject.__)('Uppercase'),
  value: 'uppercase',
  icon: format_uppercase
}, {
  label: (0,external_wp_i18n_namespaceObject.__)('Lowercase'),
  value: 'lowercase',
  icon: format_lowercase
}, {
  label: (0,external_wp_i18n_namespaceObject.__)('Capitalize'),
  value: 'capitalize',
  icon: format_capitalize
}];

/**
 * Control to facilitate text transform selections.
 *
 * @param {Object}   props           Component props.
 * @param {string}   props.className Class name to add to the control.
 * @param {string}   props.value     Currently selected text transform.
 * @param {Function} props.onChange  Handles change in text transform selection.
 *
 * @return {Element} Text transform control.
 */
function TextTransformControl({
  className,
  value,
  onChange
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(SegmentedTextControl, {
    label: (0,external_wp_i18n_namespaceObject.__)('Letter case'),
    options: TEXT_TRANSFORMS,
    className: dist_clsx('block-editor-text-transform-control', className),
    value: value,
    onChange: newValue => {
      onChange(newValue === value ? undefined : newValue);
    }
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-underline.js
/**
 * WordPress dependencies
 */


const formatUnderline = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M7 18v1h10v-1H7zm5-2c1.5 0 2.6-.4 3.4-1.2.8-.8 1.1-2 1.1-3.5V5H15v5.8c0 1.2-.2 2.1-.6 2.8-.4.7-1.2 1-2.4 1s-2-.3-2.4-1c-.4-.7-.6-1.6-.6-2.8V5H7.5v6.2c0 1.5.4 2.7 1.1 3.5.8.9 1.9 1.3 3.4 1.3z"
  })
});
/* harmony default export */ const format_underline = (formatUnderline);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-strikethrough.js
/**
 * WordPress dependencies
 */


const formatStrikethrough = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M9.1 9v-.5c0-.6.2-1.1.7-1.4.5-.3 1.2-.5 2-.5.7 0 1.4.1 2.1.3.7.2 1.4.5 2.1.9l.2-1.9c-.6-.3-1.2-.5-1.9-.7-.8-.1-1.6-.2-2.4-.2-1.5 0-2.7.3-3.6 1-.8.7-1.2 1.5-1.2 2.6V9h2zM20 12H4v1h8.3c.3.1.6.2.8.3.5.2.9.5 1.1.8.3.3.4.7.4 1.2 0 .7-.2 1.1-.8 1.5-.5.3-1.2.5-2.1.5-.8 0-1.6-.1-2.4-.3-.8-.2-1.5-.5-2.2-.8L7 18.1c.5.2 1.2.4 2 .6.8.2 1.6.3 2.4.3 1.7 0 3-.3 3.9-1 .9-.7 1.3-1.6 1.3-2.8 0-.9-.2-1.7-.7-2.2H20v-1z"
  })
});
/* harmony default export */ const format_strikethrough = (formatStrikethrough);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/text-decoration-control/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


const TEXT_DECORATIONS = [{
  label: (0,external_wp_i18n_namespaceObject.__)('None'),
  value: 'none',
  icon: library_reset
}, {
  label: (0,external_wp_i18n_namespaceObject.__)('Underline'),
  value: 'underline',
  icon: format_underline
}, {
  label: (0,external_wp_i18n_namespaceObject.__)('Strikethrough'),
  value: 'line-through',
  icon: format_strikethrough
}];

/**
 * Control to facilitate text decoration selections.
 *
 * @param {Object}   props           Component props.
 * @param {string}   props.value     Currently selected text decoration.
 * @param {Function} props.onChange  Handles change in text decoration selection.
 * @param {string}   props.className Additional class name to apply.
 *
 * @return {Element} Text decoration control.
 */
function TextDecorationControl({
  value,
  onChange,
  className
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(SegmentedTextControl, {
    label: (0,external_wp_i18n_namespaceObject.__)('Decoration'),
    options: TEXT_DECORATIONS,
    className: dist_clsx('block-editor-text-decoration-control', className),
    value: value,
    onChange: newValue => {
      onChange(newValue === value ? undefined : newValue);
    }
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/text-horizontal.js
/**
 * WordPress dependencies
 */


const textHorizontal = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M8.2 14.4h3.9L13 17h1.7L11 6.5H9.3L5.6 17h1.7l.9-2.6zm2-5.5 1.4 4H8.8l1.4-4zm7.4 7.5-1.3.8.8 1.4H5.5V20h14.3l-2.2-3.6z"
  })
});
/* harmony default export */ const text_horizontal = (textHorizontal);

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/text-vertical.js
/**
 * WordPress dependencies
 */


const textVertical = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "M7 5.6v1.7l2.6.9v3.9L7 13v1.7L17.5 11V9.3L7 5.6zm4.2 6V8.8l4 1.4-4 1.4zm-5.7 5.6V5.5H4v14.3l3.6-2.2-.8-1.3-1.3.9z"
  })
});
/* harmony default export */ const text_vertical = (textVertical);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/writing-mode-control/index.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


const WRITING_MODES = [{
  label: (0,external_wp_i18n_namespaceObject.__)('Horizontal'),
  value: 'horizontal-tb',
  icon: text_horizontal
}, {
  label: (0,external_wp_i18n_namespaceObject.__)('Vertical'),
  value: (0,external_wp_i18n_namespaceObject.isRTL)() ? 'vertical-lr' : 'vertical-rl',
  icon: text_vertical
}];

/**
 * Control to facilitate writing mode selections.
 *
 * @param {Object}   props           Component props.
 * @param {string}   props.className Class name to add to the control.
 * @param {string}   props.value     Currently selected writing mode.
 * @param {Function} props.onChange  Handles change in the writing mode selection.
 *
 * @return {Element} Writing Mode control.
 */
function WritingModeControl({
  className,
  value,
  onChange
}) {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(SegmentedTextControl, {
    label: (0,external_wp_i18n_namespaceObject.__)('Orientation'),
    options: WRITING_MODES,
    className: dist_clsx('block-editor-writing-mode-control', className),
    value: value,
    onChange: newValue => {
      onChange(newValue === value ? undefined : newValue);
    }
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/global-styles/typography-panel.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */












const MIN_TEXT_COLUMNS = 1;
const MAX_TEXT_COLUMNS = 6;
function useHasTypographyPanel(settings) {
  const hasFontFamily = useHasFontFamilyControl(settings);
  const hasLineHeight = useHasLineHeightControl(settings);
  const hasFontAppearance = useHasAppearanceControl(settings);
  const hasLetterSpacing = useHasLetterSpacingControl(settings);
  const hasTextAlign = useHasTextAlignmentControl(settings);
  const hasTextTransform = useHasTextTransformControl(settings);
  const hasTextDecoration = useHasTextDecorationControl(settings);
  const hasWritingMode = useHasWritingModeControl(settings);
  const hasTextColumns = useHasTextColumnsControl(settings);
  const hasFontSize = useHasFontSizeControl(settings);
  return hasFontFamily || hasLineHeight || hasFontAppearance || hasLetterSpacing || hasTextAlign || hasTextTransform || hasFontSize || hasTextDecoration || hasWritingMode || hasTextColumns;
}
function useHasFontSizeControl(settings) {
  return settings?.typography?.defaultFontSizes !== false && settings?.typography?.fontSizes?.default?.length || settings?.typography?.fontSizes?.theme?.length || settings?.typography?.fontSizes?.custom?.length || settings?.typography?.customFontSize;
}
function useHasFontFamilyControl(settings) {
  return ['default', 'theme', 'custom'].some(key => settings?.typography?.fontFamilies?.[key]?.length);
}
function useHasLineHeightControl(settings) {
  return settings?.typography?.lineHeight;
}
function useHasAppearanceControl(settings) {
  return settings?.typography?.fontStyle || settings?.typography?.fontWeight;
}
function useAppearanceControlLabel(settings) {
  if (!settings?.typography?.fontStyle) {
    return (0,external_wp_i18n_namespaceObject.__)('Font weight');
  }
  if (!settings?.typography?.fontWeight) {
    return (0,external_wp_i18n_namespaceObject.__)('Font style');
  }
  return (0,external_wp_i18n_namespaceObject.__)('Appearance');
}
function useHasLetterSpacingControl(settings) {
  return settings?.typography?.letterSpacing;
}
function useHasTextTransformControl(settings) {
  return settings?.typography?.textTransform;
}
function useHasTextAlignmentControl(settings) {
  return settings?.typography?.textAlign;
}
function useHasTextDecorationControl(settings) {
  return settings?.typography?.textDecoration;
}
function useHasWritingModeControl(settings) {
  return settings?.typography?.writingMode;
}
function useHasTextColumnsControl(settings) {
  return settings?.typography?.textColumns;
}

/**
 * Concatenate all the font sizes into a single list for the font size picker.
 *
 * @param {Object} settings The global styles settings.
 *
 * @return {Array} The merged font sizes.
 */
function getMergedFontSizes(settings) {
  var _fontSizes$custom, _fontSizes$theme, _fontSizes$default;
  const fontSizes = settings?.typography?.fontSizes;
  const defaultFontSizesEnabled = !!settings?.typography?.defaultFontSizes;
  return [...((_fontSizes$custom = fontSizes?.custom) !== null && _fontSizes$custom !== void 0 ? _fontSizes$custom : []), ...((_fontSizes$theme = fontSizes?.theme) !== null && _fontSizes$theme !== void 0 ? _fontSizes$theme : []), ...(defaultFontSizesEnabled ? (_fontSizes$default = fontSizes?.default) !== null && _fontSizes$default !== void 0 ? _fontSizes$default : [] : [])];
}
function TypographyToolsPanel({
  resetAllFilter,
  onChange,
  value,
  panelId,
  children
}) {
  const resetAll = () => {
    const updatedValue = resetAllFilter(value);
    onChange(updatedValue);
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanel, {
    label: (0,external_wp_i18n_namespaceObject.__)('Typography'),
    resetAll: resetAll,
    panelId: panelId,
    dropdownMenuProps: TOOLSPANEL_DROPDOWNMENU_PROPS,
    children: children
  });
}
const typography_panel_DEFAULT_CONTROLS = {
  fontFamily: true,
  fontSize: true,
  fontAppearance: true,
  lineHeight: true,
  letterSpacing: true,
  textAlign: true,
  textTransform: true,
  textDecoration: true,
  writingMode: true,
  textColumns: true
};
function TypographyPanel({
  as: Wrapper = TypographyToolsPanel,
  value,
  onChange,
  inheritedValue = value,
  settings,
  panelId,
  defaultControls = typography_panel_DEFAULT_CONTROLS
}) {
  const decodeValue = rawValue => getValueFromVariable({
    settings
  }, '', rawValue);

  // Font Family
  const hasFontFamilyEnabled = useHasFontFamilyControl(settings);
  const fontFamilies = settings?.typography?.fontFamilies;
  const mergedFontFamilies = (0,external_wp_element_namespaceObject.useMemo)(() => {
    return ['default', 'theme', 'custom'].flatMap(key => {
      var _fontFamilies$key;
      return (_fontFamilies$key = fontFamilies?.[key]) !== null && _fontFamilies$key !== void 0 ? _fontFamilies$key : [];
    });
  }, [fontFamilies]);
  const fontFamily = decodeValue(inheritedValue?.typography?.fontFamily);
  const setFontFamily = newValue => {
    const slug = mergedFontFamilies?.find(({
      fontFamily: f
    }) => f === newValue)?.slug;
    onChange(setImmutably(value, ['typography', 'fontFamily'], slug ? `var:preset|font-family|${slug}` : newValue || undefined));
  };
  const hasFontFamily = () => !!value?.typography?.fontFamily;
  const resetFontFamily = () => setFontFamily(undefined);

  // Font Size
  const hasFontSizeEnabled = useHasFontSizeControl(settings);
  const disableCustomFontSizes = !settings?.typography?.customFontSize;
  const mergedFontSizes = getMergedFontSizes(settings);
  const fontSize = decodeValue(inheritedValue?.typography?.fontSize);
  const setFontSize = (newValue, metadata) => {
    const actualValue = !!metadata?.slug ? `var:preset|font-size|${metadata?.slug}` : newValue;
    onChange(setImmutably(value, ['typography', 'fontSize'], actualValue || undefined));
  };
  const hasFontSize = () => !!value?.typography?.fontSize;
  const resetFontSize = () => setFontSize(undefined);

  // Appearance
  const hasAppearanceControl = useHasAppearanceControl(settings);
  const appearanceControlLabel = useAppearanceControlLabel(settings);
  const hasFontStyles = settings?.typography?.fontStyle;
  const hasFontWeights = settings?.typography?.fontWeight;
  const fontStyle = decodeValue(inheritedValue?.typography?.fontStyle);
  const fontWeight = decodeValue(inheritedValue?.typography?.fontWeight);
  const setFontAppearance = ({
    fontStyle: newFontStyle,
    fontWeight: newFontWeight
  }) => {
    onChange({
      ...value,
      typography: {
        ...value?.typography,
        fontStyle: newFontStyle || undefined,
        fontWeight: newFontWeight || undefined
      }
    });
  };
  const hasFontAppearance = () => !!value?.typography?.fontStyle || !!value?.typography?.fontWeight;
  const resetFontAppearance = () => {
    setFontAppearance({});
  };

  // Line Height
  const hasLineHeightEnabled = useHasLineHeightControl(settings);
  const lineHeight = decodeValue(inheritedValue?.typography?.lineHeight);
  const setLineHeight = newValue => {
    onChange(setImmutably(value, ['typography', 'lineHeight'], newValue || undefined));
  };
  const hasLineHeight = () => value?.typography?.lineHeight !== undefined;
  const resetLineHeight = () => setLineHeight(undefined);

  // Letter Spacing
  const hasLetterSpacingControl = useHasLetterSpacingControl(settings);
  const letterSpacing = decodeValue(inheritedValue?.typography?.letterSpacing);
  const setLetterSpacing = newValue => {
    onChange(setImmutably(value, ['typography', 'letterSpacing'], newValue || undefined));
  };
  const hasLetterSpacing = () => !!value?.typography?.letterSpacing;
  const resetLetterSpacing = () => setLetterSpacing(undefined);

  // Text Columns
  const hasTextColumnsControl = useHasTextColumnsControl(settings);
  const textColumns = decodeValue(inheritedValue?.typography?.textColumns);
  const setTextColumns = newValue => {
    onChange(setImmutably(value, ['typography', 'textColumns'], newValue || undefined));
  };
  const hasTextColumns = () => !!value?.typography?.textColumns;
  const resetTextColumns = () => setTextColumns(undefined);

  // Text Transform
  const hasTextTransformControl = useHasTextTransformControl(settings);
  const textTransform = decodeValue(inheritedValue?.typography?.textTransform);
  const setTextTransform = newValue => {
    onChange(setImmutably(value, ['typography', 'textTransform'], newValue || undefined));
  };
  const hasTextTransform = () => !!value?.typography?.textTransform;
  const resetTextTransform = () => setTextTransform(undefined);

  // Text Decoration
  const hasTextDecorationControl = useHasTextDecorationControl(settings);
  const textDecoration = decodeValue(inheritedValue?.typography?.textDecoration);
  const setTextDecoration = newValue => {
    onChange(setImmutably(value, ['typography', 'textDecoration'], newValue || undefined));
  };
  const hasTextDecoration = () => !!value?.typography?.textDecoration;
  const resetTextDecoration = () => setTextDecoration(undefined);

  // Text Orientation
  const hasWritingModeControl = useHasWritingModeControl(settings);
  const writingMode = decodeValue(inheritedValue?.typography?.writingMode);
  const setWritingMode = newValue => {
    onChange(setImmutably(value, ['typography', 'writingMode'], newValue || undefined));
  };
  const hasWritingMode = () => !!value?.typography?.writingMode;
  const resetWritingMode = () => setWritingMode(undefined);

  // Text Alignment
  const hasTextAlignmentControl = useHasTextAlignmentControl(settings);
  const textAlign = decodeValue(inheritedValue?.typography?.textAlign);
  const setTextAlign = newValue => {
    onChange(setImmutably(value, ['typography', 'textAlign'], newValue || undefined));
  };
  const hasTextAlign = () => !!value?.typography?.textAlign;
  const resetTextAlign = () => setTextAlign(undefined);
  const resetAllFilter = (0,external_wp_element_namespaceObject.useCallback)(previousValue => {
    return {
      ...previousValue,
      typography: {}
    };
  }, []);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(Wrapper, {
    resetAllFilter: resetAllFilter,
    value: value,
    onChange: onChange,
    panelId: panelId,
    children: [hasFontFamilyEnabled && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
      label: (0,external_wp_i18n_namespaceObject.__)('Font'),
      hasValue: hasFontFamily,
      onDeselect: resetFontFamily,
      isShownByDefault: defaultControls.fontFamily,
      panelId: panelId,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(FontFamilyControl, {
        fontFamilies: mergedFontFamilies,
        value: fontFamily,
        onChange: setFontFamily,
        size: "__unstable-large",
        __nextHasNoMarginBottom: true
      })
    }), hasFontSizeEnabled && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
      label: (0,external_wp_i18n_namespaceObject.__)('Size'),
      hasValue: hasFontSize,
      onDeselect: resetFontSize,
      isShownByDefault: defaultControls.fontSize,
      panelId: panelId,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.FontSizePicker, {
        value: fontSize,
        onChange: setFontSize,
        fontSizes: mergedFontSizes,
        disableCustomFontSizes: disableCustomFontSizes,
        withReset: false,
        withSlider: true,
        size: "__unstable-large"
      })
    }), hasAppearanceControl && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
      className: "single-column",
      label: appearanceControlLabel,
      hasValue: hasFontAppearance,
      onDeselect: resetFontAppearance,
      isShownByDefault: defaultControls.fontAppearance,
      panelId: panelId,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(FontAppearanceControl, {
        value: {
          fontStyle,
          fontWeight
        },
        onChange: setFontAppearance,
        hasFontStyles: hasFontStyles,
        hasFontWeights: hasFontWeights,
        size: "__unstable-large",
        __nextHasNoMarginBottom: true
      })
    }), hasLineHeightEnabled && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
      className: "single-column",
      label: (0,external_wp_i18n_namespaceObject.__)('Line height'),
      hasValue: hasLineHeight,
      onDeselect: resetLineHeight,
      isShownByDefault: defaultControls.lineHeight,
      panelId: panelId,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(line_height_control, {
        __nextHasNoMarginBottom: true,
        __unstableInputWidth: "auto",
        value: lineHeight,
        onChange: setLineHeight,
        size: "__unstable-large"
      })
    }), hasLetterSpacingControl && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
      className: "single-column",
      label: (0,external_wp_i18n_namespaceObject.__)('Letter spacing'),
      hasValue: hasLetterSpacing,
      onDeselect: resetLetterSpacing,
      isShownByDefault: defaultControls.letterSpacing,
      panelId: panelId,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(LetterSpacingControl, {
        value: letterSpacing,
        onChange: setLetterSpacing,
        size: "__unstable-large",
        __unstableInputWidth: "auto"
      })
    }), hasTextColumnsControl && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
      className: "single-column",
      label: (0,external_wp_i18n_namespaceObject.__)('Columns'),
      hasValue: hasTextColumns,
      onDeselect: resetTextColumns,
      isShownByDefault: defaultControls.textColumns,
      panelId: panelId,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalNumberControl, {
        label: (0,external_wp_i18n_namespaceObject.__)('Columns'),
        max: MAX_TEXT_COLUMNS,
        min: MIN_TEXT_COLUMNS,
        onChange: setTextColumns,
        size: "__unstable-large",
        spinControls: "custom",
        value: textColumns,
        initialPosition: 1
      })
    }), hasTextDecorationControl && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
      className: "single-column",
      label: (0,external_wp_i18n_namespaceObject.__)('Decoration'),
      hasValue: hasTextDecoration,
      onDeselect: resetTextDecoration,
      isShownByDefault: defaultControls.textDecoration,
      panelId: panelId,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(TextDecorationControl, {
        value: textDecoration,
        onChange: setTextDecoration,
        size: "__unstable-large",
        __unstableInputWidth: "auto"
      })
    }), hasWritingModeControl && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
      className: "single-column",
      label: (0,external_wp_i18n_namespaceObject.__)('Orientation'),
      hasValue: hasWritingMode,
      onDeselect: resetWritingMode,
      isShownByDefault: defaultControls.writingMode,
      panelId: panelId,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(WritingModeControl, {
        value: writingMode,
        onChange: setWritingMode,
        size: "__unstable-large",
        __nextHasNoMarginBottom: true
      })
    }), hasTextTransformControl && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
      label: (0,external_wp_i18n_namespaceObject.__)('Letter case'),
      hasValue: hasTextTransform,
      onDeselect: resetTextTransform,
      isShownByDefault: defaultControls.textTransform,
      panelId: panelId,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(TextTransformControl, {
        value: textTransform,
        onChange: setTextTransform,
        showNone: true,
        isBlock: true,
        size: "__unstable-large",
        __nextHasNoMarginBottom: true
      })
    }), hasTextAlignmentControl && /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_components_namespaceObject.__experimentalToolsPanelItem, {
      label: (0,external_wp_i18n_namespaceObject.__)('Text alignment'),
      hasValue: hasTextAlign,
      onDeselect: resetTextAlign,
      isShownByDefault: defaultControls.textAlign,
      panelId: panelId,
      children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(TextAlignmentControl, {
        value: textAlign,
        onChange: setTextAlign,
        size: "__unstable-large",
        __nextHasNoMarginBottom: true
      })
    })]
  });
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/line-height.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




const LINE_HEIGHT_SUPPORT_KEY = 'typography.lineHeight';

/**
 * Inspector control panel containing the line height related configuration
 *
 * @param {Object} props
 *
 * @return {Element} Line height edit element.
 */
function LineHeightEdit(props) {
  const {
    attributes: {
      style
    },
    setAttributes
  } = props;
  const onChange = newLineHeightValue => {
    const newStyle = {
      ...style,
      typography: {
        ...style?.typography,
        lineHeight: newLineHeightValue
      }
    };
    setAttributes({
      style: cleanEmptyObject(newStyle)
    });
  };
  return /*#__PURE__*/_jsx(LineHeightControl, {
    __unstableInputWidth: "100%",
    __nextHasNoMarginBottom: true,
    value: style?.typography?.lineHeight,
    onChange: onChange,
    size: "__unstable-large"
  });
}

/**
 * Custom hook that checks if line-height settings have been disabled.
 *
 * @param {string} name The name of the block.
 * @return {boolean} Whether setting is disabled.
 */
function useIsLineHeightDisabled({
  name: blockName
} = {}) {
  const [isEnabled] = useSettings('typography.lineHeight');
  return !isEnabled || !hasBlockSupport(blockName, LINE_HEIGHT_SUPPORT_KEY);
}

;// CONCATENATED MODULE: external ["wp","tokenList"]
const external_wp_tokenList_namespaceObject = window["wp"]["tokenList"];
var external_wp_tokenList_default = /*#__PURE__*/__webpack_require__.n(external_wp_tokenList_namespaceObject);
;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/font-family.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



const FONT_FAMILY_SUPPORT_KEY = 'typography.__experimentalFontFamily';
const {
  kebabCase: font_family_kebabCase
} = unlock(external_wp_components_namespaceObject.privateApis);

/**
 * Filters registered block settings, extending attributes to include
 * the `fontFamily` attribute.
 *
 * @param {Object} settings Original block settings
 * @return {Object}         Filtered block settings
 */
function font_family_addAttributes(settings) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, FONT_FAMILY_SUPPORT_KEY)) {
    return settings;
  }

  // Allow blocks to specify a default value if needed.
  if (!settings.attributes.fontFamily) {
    Object.assign(settings.attributes, {
      fontFamily: {
        type: 'string'
      }
    });
  }
  return settings;
}

/**
 * Override props assigned to save component to inject font family.
 *
 * @param {Object} props      Additional props applied to save element
 * @param {Object} blockType  Block type
 * @param {Object} attributes Block attributes
 * @return {Object}           Filtered props applied to save element
 */
function font_family_addSaveProps(props, blockType, attributes) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockType, FONT_FAMILY_SUPPORT_KEY)) {
    return props;
  }
  if (shouldSkipSerialization(blockType, TYPOGRAPHY_SUPPORT_KEY, 'fontFamily')) {
    return props;
  }
  if (!attributes?.fontFamily) {
    return props;
  }

  // Use TokenList to dedupe classes.
  const classes = new (external_wp_tokenList_default())(props.className);
  classes.add(`has-${font_family_kebabCase(attributes?.fontFamily)}-font-family`);
  const newClassName = classes.value;
  props.className = newClassName ? newClassName : undefined;
  return props;
}
function font_family_useBlockProps({
  name,
  fontFamily
}) {
  return font_family_addSaveProps({}, name, {
    fontFamily
  });
}
/* harmony default export */ const font_family = ({
  useBlockProps: font_family_useBlockProps,
  addSaveProps: font_family_addSaveProps,
  attributeKeys: ['fontFamily'],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, FONT_FAMILY_SUPPORT_KEY);
  }
});

/**
 * Resets the font family block support attribute. This can be used when
 * disabling the font family support controls for a block via a progressive
 * discovery panel.
 *
 * @param {Object} props               Block props.
 * @param {Object} props.setAttributes Function to set block's attributes.
 */
function resetFontFamily({
  setAttributes
}) {
  setAttributes({
    fontFamily: undefined
  });
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/fontFamily/addAttribute', font_family_addAttributes);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/font-sizes/utils.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

const {
  kebabCase: utils_kebabCase
} = unlock(external_wp_components_namespaceObject.privateApis);

/**
 *  Returns the font size object based on an array of named font sizes and the namedFontSize and customFontSize values.
 * 	If namedFontSize is undefined or not found in fontSizes an object with just the size value based on customFontSize is returned.
 *
 * @param {Array}   fontSizes               Array of font size objects containing at least the "name" and "size" values as properties.
 * @param {?string} fontSizeAttribute       Content of the font size attribute (slug).
 * @param {?number} customFontSizeAttribute Contents of the custom font size attribute (value).
 *
 * @return {?Object} If fontSizeAttribute is set and an equal slug is found in fontSizes it returns the font size object for that slug.
 * 					 Otherwise, an object with just the size value based on customFontSize is returned.
 */
const utils_getFontSize = (fontSizes, fontSizeAttribute, customFontSizeAttribute) => {
  if (fontSizeAttribute) {
    const fontSizeObject = fontSizes?.find(({
      slug
    }) => slug === fontSizeAttribute);
    if (fontSizeObject) {
      return fontSizeObject;
    }
  }
  return {
    size: customFontSizeAttribute
  };
};

/**
 * Returns the corresponding font size object for a given value.
 *
 * @param {Array}  fontSizes Array of font size objects.
 * @param {number} value     Font size value.
 *
 * @return {Object} Font size object.
 */
function utils_getFontSizeObjectByValue(fontSizes, value) {
  const fontSizeObject = fontSizes?.find(({
    size
  }) => size === value);
  if (fontSizeObject) {
    return fontSizeObject;
  }
  return {
    size: value
  };
}

/**
 * Returns a class based on fontSizeName.
 *
 * @param {string} fontSizeSlug Slug of the fontSize.
 *
 * @return {string | undefined} String with the class corresponding to the fontSize passed.
 *                  The class is generated by appending 'has-' followed by fontSizeSlug in kebabCase and ending with '-font-size'.
 */
function getFontSizeClass(fontSizeSlug) {
  if (!fontSizeSlug) {
    return;
  }
  return `has-${utils_kebabCase(fontSizeSlug)}-font-size`;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/font-size.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */






const FONT_SIZE_SUPPORT_KEY = 'typography.fontSize';

/**
 * Filters registered block settings, extending attributes to include
 * `fontSize` and `fontWeight` attributes.
 *
 * @param {Object} settings Original block settings.
 *
 * @return {Object} Filtered block settings.
 */
function font_size_addAttributes(settings) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(settings, FONT_SIZE_SUPPORT_KEY)) {
    return settings;
  }

  // Allow blocks to specify a default value if needed.
  if (!settings.attributes.fontSize) {
    Object.assign(settings.attributes, {
      fontSize: {
        type: 'string'
      }
    });
  }
  return settings;
}

/**
 * Override props assigned to save component to inject font size.
 *
 * @param {Object} props           Additional props applied to save element.
 * @param {Object} blockNameOrType Block type.
 * @param {Object} attributes      Block attributes.
 *
 * @return {Object} Filtered props applied to save element.
 */
function font_size_addSaveProps(props, blockNameOrType, attributes) {
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(blockNameOrType, FONT_SIZE_SUPPORT_KEY)) {
    return props;
  }
  if (shouldSkipSerialization(blockNameOrType, TYPOGRAPHY_SUPPORT_KEY, 'fontSize')) {
    return props;
  }

  // Use TokenList to dedupe classes.
  const classes = new (external_wp_tokenList_default())(props.className);
  classes.add(getFontSizeClass(attributes.fontSize));
  const newClassName = classes.value;
  props.className = newClassName ? newClassName : undefined;
  return props;
}

/**
 * Inspector control panel containing the font size related configuration
 *
 * @param {Object} props
 *
 * @return {Element} Font size edit element.
 */
function FontSizeEdit(props) {
  const {
    attributes: {
      fontSize,
      style
    },
    setAttributes
  } = props;
  const [fontSizes] = useSettings('typography.fontSizes');
  const onChange = value => {
    const fontSizeSlug = getFontSizeObjectByValue(fontSizes, value).slug;
    setAttributes({
      style: cleanEmptyObject({
        ...style,
        typography: {
          ...style?.typography,
          fontSize: fontSizeSlug ? undefined : value
        }
      }),
      fontSize: fontSizeSlug
    });
  };
  const fontSizeObject = getFontSize(fontSizes, fontSize, style?.typography?.fontSize);
  const fontSizeValue = fontSizeObject?.size || style?.typography?.fontSize || fontSize;
  return /*#__PURE__*/_jsx(FontSizePicker, {
    onChange: onChange,
    value: fontSizeValue,
    withReset: false,
    withSlider: true,
    size: "__unstable-large"
  });
}

/**
 * Custom hook that checks if font-size settings have been disabled.
 *
 * @param {string} name The name of the block.
 * @return {boolean} Whether setting is disabled.
 */
function useIsFontSizeDisabled({
  name: blockName
} = {}) {
  const [fontSizes] = useSettings('typography.fontSizes');
  const hasFontSizes = !!fontSizes?.length;
  return !hasBlockSupport(blockName, FONT_SIZE_SUPPORT_KEY) || !hasFontSizes;
}
function font_size_useBlockProps({
  name,
  fontSize,
  style
}) {
  const [fontSizes, fluidTypographySettings, layoutSettings] = use_settings_useSettings('typography.fontSizes', 'typography.fluid', 'layout');

  /*
   * Only add inline styles if the block supports font sizes,
   * doesn't skip serialization of font sizes,
   * and has either a custom font size or a preset font size.
   */
  if (!(0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, FONT_SIZE_SUPPORT_KEY) || shouldSkipSerialization(name, TYPOGRAPHY_SUPPORT_KEY, 'fontSize') || !fontSize && !style?.typography?.fontSize) {
    return;
  }
  let props;
  if (style?.typography?.fontSize) {
    props = {
      style: {
        fontSize: getTypographyFontSizeValue({
          size: style.typography.fontSize
        }, {
          typography: {
            fluid: fluidTypographySettings
          },
          layout: layoutSettings
        })
      }
    };
  }
  if (fontSize) {
    props = {
      style: {
        fontSize: utils_getFontSize(fontSizes, fontSize, style?.typography?.fontSize).size
      }
    };
  }
  if (!props) {
    return;
  }
  return font_size_addSaveProps(props, name, {
    fontSize
  });
}
/* harmony default export */ const font_size = ({
  useBlockProps: font_size_useBlockProps,
  addSaveProps: font_size_addSaveProps,
  attributeKeys: ['fontSize', 'style'],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, FONT_SIZE_SUPPORT_KEY);
  }
});
const font_size_MIGRATION_PATHS = {
  fontSize: [['fontSize'], ['style', 'typography', 'fontSize']]
};
function font_size_addTransforms(result, source, index, results) {
  const destinationBlockType = result.name;
  const activeSupports = {
    fontSize: (0,external_wp_blocks_namespaceObject.hasBlockSupport)(destinationBlockType, FONT_SIZE_SUPPORT_KEY)
  };
  return transformStyles(activeSupports, font_size_MIGRATION_PATHS, result, source, index, results);
}
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.registerBlockType', 'core/font/addAttribute', font_size_addAttributes);
(0,external_wp_hooks_namespaceObject.addFilter)('blocks.switchToBlockType.transformedBlock', 'core/font-size/addTransforms', font_size_addTransforms);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/alignment-control/ui.js
/**
 * WordPress dependencies
 */




const DEFAULT_ALIGNMENT_CONTROLS = [{
  icon: align_left,
  title: (0,external_wp_i18n_namespaceObject.__)('Align text left'),
  align: 'left'
}, {
  icon: align_center,
  title: (0,external_wp_i18n_namespaceObject.__)('Align text center'),
  align: 'center'
}, {
  icon: align_right,
  title: (0,external_wp_i18n_namespaceObject.__)('Align text right'),
  align: 'right'
}];
const ui_POPOVER_PROPS = {
  placement: 'bottom-start'
};
function AlignmentUI({
  value,
  onChange,
  alignmentControls = DEFAULT_ALIGNMENT_CONTROLS,
  label = (0,external_wp_i18n_namespaceObject.__)('Align text'),
  describedBy = (0,external_wp_i18n_namespaceObject.__)('Change text alignment'),
  isCollapsed = true,
  isToolbar
}) {
  function applyOrUnset(align) {
    return () => onChange(value === align ? undefined : align);
  }
  const activeAlignment = alignmentControls.find(control => control.align === value);
  function setIcon() {
    if (activeAlignment) {
      return activeAlignment.icon;
    }
    return (0,external_wp_i18n_namespaceObject.isRTL)() ? align_right : align_left;
  }
  const UIComponent = isToolbar ? external_wp_components_namespaceObject.ToolbarGroup : external_wp_components_namespaceObject.ToolbarDropdownMenu;
  const extraProps = isToolbar ? {
    isCollapsed
  } : {
    toggleProps: {
      describedBy
    },
    popoverProps: ui_POPOVER_PROPS
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(UIComponent, {
    icon: setIcon(),
    label: label,
    controls: alignmentControls.map(control => {
      const {
        align
      } = control;
      const isActive = value === align;
      return {
        ...control,
        isActive,
        role: isCollapsed ? 'menuitemradio' : undefined,
        onClick: applyOrUnset(align)
      };
    }),
    ...extraProps
  });
}
/* harmony default export */ const alignment_control_ui = (AlignmentUI);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/alignment-control/index.js
/**
 * Internal dependencies
 */


const AlignmentControl = props => {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(alignment_control_ui, {
    ...props,
    isToolbar: false
  });
};
const AlignmentToolbar = props => {
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(alignment_control_ui, {
    ...props,
    isToolbar: true
  });
};

/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/alignment-control/README.md
 */


;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/text-align.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





const TEXT_ALIGN_SUPPORT_KEY = 'typography.textAlign';
const text_align_TEXT_ALIGNMENT_OPTIONS = [{
  icon: align_left,
  title: (0,external_wp_i18n_namespaceObject.__)('Align text left'),
  align: 'left'
}, {
  icon: align_center,
  title: (0,external_wp_i18n_namespaceObject.__)('Align text center'),
  align: 'center'
}, {
  icon: align_right,
  title: (0,external_wp_i18n_namespaceObject.__)('Align text right'),
  align: 'right'
}];
const VALID_TEXT_ALIGNMENTS = ['left', 'center', 'right'];
const NO_TEXT_ALIGNMENTS = [];

/**
 * Returns the valid text alignments.
 * Takes into consideration the text aligns supported by a block.
 * Exported just for testing purposes, not exported outside the module.
 *
 * @param {?boolean|string[]} blockTextAlign Text aligns supported by the block.
 *
 * @return {string[]} Valid text alignments.
 */
function getValidTextAlignments(blockTextAlign) {
  if (Array.isArray(blockTextAlign)) {
    return VALID_TEXT_ALIGNMENTS.filter(textAlign => blockTextAlign.includes(textAlign));
  }
  return blockTextAlign === true ? VALID_TEXT_ALIGNMENTS : NO_TEXT_ALIGNMENTS;
}
function BlockEditTextAlignmentToolbarControlsPure({
  style,
  name: blockName,
  setAttributes
}) {
  const settings = useBlockSettings(blockName);
  const hasTextAlignControl = settings?.typography?.textAlign;
  const blockEditingMode = useBlockEditingMode();
  if (!hasTextAlignControl || blockEditingMode !== 'default') {
    return null;
  }
  const validTextAlignments = getValidTextAlignments((0,external_wp_blocks_namespaceObject.getBlockSupport)(blockName, TEXT_ALIGN_SUPPORT_KEY));
  if (!validTextAlignments.length) {
    return null;
  }
  const textAlignmentControls = text_align_TEXT_ALIGNMENT_OPTIONS.filter(control => validTextAlignments.includes(control.align));
  const onChange = newTextAlignValue => {
    const newStyle = {
      ...style,
      typography: {
        ...style?.typography,
        textAlign: newTextAlignValue
      }
    };
    setAttributes({
      style: utils_cleanEmptyObject(newStyle)
    });
  };
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(block_controls, {
    group: "block",
    children: /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(AlignmentControl, {
      value: style?.typography?.textAlign,
      onChange: onChange,
      alignmentControls: textAlignmentControls
    })
  });
}
/* harmony default export */ const text_align = ({
  edit: BlockEditTextAlignmentToolbarControlsPure,
  useBlockProps: text_align_useBlockProps,
  addSaveProps: addAssignedTextAlign,
  attributeKeys: ['style'],
  hasSupport(name) {
    return (0,external_wp_blocks_namespaceObject.hasBlockSupport)(name, TEXT_ALIGN_SUPPORT_KEY, false);
  }
});
function text_align_useBlockProps({
  name,
  style
}) {
  if (!style?.typography?.textAlign) {
    return null;
  }
  const validTextAlignments = getValidTextAlignments((0,external_wp_blocks_namespaceObject.getBlockSupport)(name, TEXT_ALIGN_SUPPORT_KEY));
  if (!validTextAlignments.length) {
    return null;
  }
  if (shouldSkipSerialization(name, TYPOGRAPHY_SUPPORT_KEY, 'textAlign')) {
    return null;
  }
  const textAlign = style.typography.textAlign;
  const className = dist_clsx({
    [`has-text-align-${textAlign}`]: textAlign
  });
  return {
    className
  };
}

/**
 * Override props assigned to save component to inject text alignment class
 * name if block supports it.
 *
 * @param {Object} props      Additional props applied to save element.
 * @param {Object} blockType  Block type.
 * @param {Object} attributes Block attributes.
 *
 * @return {Object} Filtered props applied to save element.
 */
function addAssignedTextAlign(props, blockType, attributes) {
  if (!attributes?.style?.typography?.textAlign) {
    return props;
  }
  const {
    textAlign
  } = attributes.style.typography;
  const blockTextAlign = (0,external_wp_blocks_namespaceObject.getBlockSupport)(blockType, TEXT_ALIGN_SUPPORT_KEY);
  const isTextAlignValid = getValidTextAlignments(blockTextAlign).includes(textAlign);
  if (isTextAlignValid && !shouldSkipSerialization(blockType, TYPOGRAPHY_SUPPORT_KEY, 'textAlign')) {
    props.className = dist_clsx(`has-text-align-${textAlign}`, props.className);
  }
  return props;
}

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/hooks/typography.js
/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */









function omit(object, keys) {
  return Object.fromEntries(Object.entries(object).filter(([key]) => !keys.includes(key)));
}
const LETTER_SPACING_SUPPORT_KEY = 'typography.__experimentalLetterSpacing';
const TEXT_TRANSFORM_SUPPORT_KEY = 'typography.__experimentalTextTransform';
const TEXT_DECORATION_SUPPORT_KEY = 'typography.__experimentalTextDecoration';
const TEXT_COLUMNS_SUPPORT_KEY = 'typography.textColumns';
const FONT_STYLE_SUPPORT_KEY = 'typography.__experimentalFontStyle';
const FONT_WEIGHT_SUPPORT_KEY = 'typography.__experimentalFontWeight';
const WRITING_MODE_SUPPORT_KEY = 'typography.__experimentalWritingMode';
const TYPOGRAPHY_SUPPORT_KEY = 'typography';
const TYPOGRAPHY_SUPPORT_KEYS = [LINE_HEIGHT_SUPPORT_KEY, FONT_SIZE_SUPPORT_KEY, FONT_STYLE_SUPPORT_KEY, FONT_WEIGHT_SUPPORT_KEY, FONT_FAMILY_SUPPORT_KEY, TEXT_ALIGN_SUPPORT_KEY, TEXT_COLUMNS_SUPPORT_KEY, TEXT_DECORATION_SUPPORT_KEY, WRITING_MODE_SUPPORT_KEY, TEXT_TRANSFORM_SUPPORT_KEY, LETTER_SPACING_SUPPORT_KEY];
function typography_styleToAttributes(style) {
  const updatedStyle = {
    ...omit(style, ['fontFamily'])
  };
  const fontSizeValue = style?.typography?.fontSize;
  const fontFamilyValue = style?.typography?.fontFamily;
  const fontSizeSlug = fontSizeValue?.startsWith('var:preset|font-size|') ? fontSizeValue.substring('var:preset|font-size|'.length) : undefined;
  const fontFamilySlug = fontFamilyValue?.startsWith('var:preset|font-family|') ? fontFamilyValue.substring('var:preset|font-family|'.length) : undefined;
  updatedStyle.typography = {
    ...omit(updatedStyle.typography, ['fontFamily']),
    fontSize: fontSizeSlug ? undefined : fontSizeValue
  };
  return {
    style: utils_cleanEmptyObject(updatedStyle),
    fontFamily: fontFamilySlug,
    fontSize: fontSizeSlug
  };
}
function typography_attributesToStyle(attributes) {
  return {
    ...attributes.style,
    typography: {
      ...attributes.style?.typography,
      fontFamily: attributes.fontFamily ? 'var:preset|font-family|' + attributes.fontFamily : undefined,
      fontSize: attributes.fontSize ? 'var:preset|font-size|' + attributes.fontSize : attributes.style?.typography?.fontSize
    }
  };
}
function TypographyInspectorControl({
  children,
  resetAllFilter
}) {
  const attributesResetAllFilter = (0,external_wp_element_namespaceObject.useCallback)(attributes => {
    const existingStyle = typography_attributesToStyle(attributes);
    const updatedStyle = resetAllFilter(existingStyle);
    return {
      ...attributes,
      ...typography_styleToAttributes(updatedStyle)
    };
  }, [resetAllFilter]);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(inspector_controls, {
    group: "typography",
    resetAllFilter: attributesResetAllFilter,
    children: children
  });
}
function typography_TypographyPanel({
  clientId,
  name,
  setAttributes,
  settings
}) {
  function selector(select) {
    const {
      style,
      fontFamily,
      fontSize
    } = select(store).getBlockAttributes(clientId) || {};
    return {
      style,
      fontFamily,
      fontSize
    };
  }
  const {
    style,
    fontFamily,
    fontSize
  } = (0,external_wp_data_namespaceObject.useSelect)(selector, [clientId]);
  const isEnabled = useHasTypographyPanel(settings);
  const value = (0,external_wp_element_namespaceObject.useMemo)(() => typography_attributesToStyle({
    style,
    fontFamily,
    fontSize
  }), [style, fontSize, fontFamily]);
  const onChange = newStyle => {
    setAttributes(typography_styleToAttributes(newStyle));
  };
  if (!isEnabled) {
    return null;
  }
  const defaultControls = (0,external_wp_blocks_namespaceObject.getBlockSupport)(name, [TYPOGRAPHY_SUPPORT_KEY, '__experimentalDefaultControls']);
  return /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(TypographyPanel, {
    as: TypographyInspectorControl,
    panelId: clientId,
    settings: settings,
    value: value,
    onChange: onChange,
    defaultControls: defaultControls
  });
}
const hasTypographySupport = blockName => {
  return TYPOGRAPHY_SUPPORT_KEYS.some(key => hasBlockSupport(blockName, key));
};

;// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/settings.js
/**
 * WordPress dependencies
 */



const settings_settings = /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsxs)(external_wp_primitives_namespaceObject.SVG, {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24",
  children: [/*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m19 7.5h-7.628c-.3089-.87389-1.1423-1.5-2.122-1.5-.97966 0-1.81309.62611-2.12197 1.5h-2.12803v1.5h2.12803c.30888.87389 1.14231 1.5 2.12197 1.5.9797 0 1.8131-.62611 2.122-1.5h7.628z"
  }), /*#__PURE__*/(0,external_ReactJSXRuntime_namespaceObject.jsx)(external_wp_primitives_namespaceObject.Path, {
    d: "m19 15h-2.128c-.3089-.8739-1.1423-1.5-2.122-1.5s-1.8131.6261-2.122 1.5h-7.628v1.5h7.628c.3089.8739 1.1423 1.5 2.122 1.5s1.8131-.6261 2.122-1.5h2.128z"
  })]
});
/* harmony default export */ const library_settings = (settings_settings);

;// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/spacing-sizes-control/input-controls/spacing-input-control.js
/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */






const CUSTOM_VALUE_SETTINGS = {
  px: {
    max: 300,
    steps: 1
  },
  '%': {
    max: 100,
    steps: 1
  },
  vw: {
    max: 100,
    steps: 1
  },
  vh: {
    max: 100,
    steps: 1
  },
  em: {
    max: 10,
    steps: 0.1
  },
  rm: {
    max: 10,
    steps: 0.1
  },
  svw: {
    max: 100,
    steps: 1
  },
  lvw: {
    max: 100,
    steps: 1
  },
  dvw: {
    max: 100,
    steps: 1
  },
  svh: {
    max: 100,
    steps: 1
  },
  lvh: {
    max: 100,
    steps: 1
  },
  dvh: {
    max: 100,
    steps: 1
  },
  vi: {
    max: 100,
    steps: 1
  },
  svi: {
    max: 100,
    steps: 1
  },
  lvi: {
    max: 100,
    steps: 1
  },
  dvi: {
    max: 100,
    steps: 1
  },
  vb: {
    max: 100,
    steps: 1
  },
  svb: {
    max: 100,
    steps: 1
  },
  lvb: {
    max: 100,
    steps: 1
  },
  dvb: {
    max: 100,
    steps: 1
  },
  vmin: {
    max: 100,
    steps: 1
  },
  svmin: {
    max: 100,
    steps: 1
  },
  lvmin: {
    max: 100,
    steps: 1
  },
  dvmin: {
    max: 100,
    steps: 1
  },
  vmax: {
    max: 100,
    steps: 1
  },
  svmax: {
    max: 100,
    steps: 1
  },
  lvmax: {
    max: 100,
    steps: 1
  },
  dvmax: {
    max: 100,
    steps: 1
  }
};
function SpacingInputControl({
  icon,
  isMixed = false,
  minimumCustomValue,
  onChange,
  onMouseOut,
  onMouseOver,
  showSideInLabel = true,
  side,
  spacingSizes,
  type,
  value
}) {
  var _CUSTOM_VALUE_SETTING, _CUSTOM_VALUE_SETTING2;
  // Treat value as a preset value if the passed in value matches the value of one of the spacingSizes.
  value = getPresetValueFromCustomValue(value, spacingSizes);
  let selectListSizes = spacingSizes;
  const showRangeControl = spacingSizes.length <= RANGE_CONTROL_MAX_SIZE;
  const disableCustomSpacingSizes = (0,external_wp_data_namespaceObject.useSelect)(select => {
    const editorSettings = select(store).getSettings();
    return editorSettings?.disableCustomSpacingSizes;
  });
  const [showCustomValueControl, setShowCustomValueControl] = (0,external_wp_element_namespaceObject.useState)(!disableCustomSpacingSizes && value !== undefined && !isValueSpacingPreset(value));
  const [minValue, setMinValue] = (0,external_wp_element_namespaceObject.useState)(minimumCustomValue);
  const previousValue = (0,external_wp_compose_namespaceObject.usePrevious)(value);
  if (!!value && previousValue !== value && !isValueSpacingPreset(value) && showCustomValueControl !== true) {
    setShowCustomValueControl(true);
  }
  const [availableUnits] = use_settings_useSettings('spacing.units');
  const units = (0,external_wp_components_namespaceObject.__experimentalUseCustomUnits)({
    availableUnits: availableUnits || ['px', 'em', 'rem']
  });
  let currentValue = null;
  const showCustomValueInSelectList = !showRangeControl && !showCustomValueControl && value !== undefined && (!isValueSpacingPreset(value) || isValueSpacingPreset(value) && isMixed);
  if (showCustomValueInSelectList) {
    selectListSizes = [...spacingSizes, {
      name: !isMixed ?
      // translators: A custom measurement, eg. a number followed by a unit like 12px.
      (0,external_wp_i18n_namespaceObject.sprintf)((0,external_wp_i18n_namespaceObject.__)('Custom (%s)'), value) : (0,external_wp_i18n_namespaceObject.__)('Mixed'),
      slug: 'custom',
      size: value
    }];
    currentValue = selectListSizes.length - 1;
  } else if (!isMixed) {
    currentValue = !showCustomValueControl ? getSliderValueFromPreset(value, spacingSizes) : getCustomValueFromPreset(value, spacingSizes);
  }
  const selectedUnit = (0,external_wp_element_namespaceObject.useMemo)(() => (0,external_wp_components_namespaceObject.__experimentalParseQuantityAndUnitFromRawValue)(currentValue), [currentValue])[1] || units[0]?.value;
  const setInitialValue = () => {
    if (value === undefined) {
      onChange('0');
    }
  };
  const customTooltipContent = newValue => value === undefined ? undefined : spacingSizes[newValue]?.name;
  const customRangeValue = parseFloat(currentValue, 10);
  const getNewCustomValue = newSize => {
    const isNumeric = !isNaN(parseFloat(newSize));
    const nextValue = isNumeric ? newSize : undefined;
    return nextValue;
  };
  const getNewPresetValue = (newSize, controlType) => {
    const size = parseInt(newSize, 10);
    if (controlType === 'selectList') {
      if (size === 0) {
        return undefined;
      }
      if (size === 1) {
        return '0';
      }
    } else if (size === 0) {
      return '0';
    }
    return `var:preset|spacing|${spacingSizes[newSize]?.slug}`;
  };
  const handleCustomValueSliderChange = next => {
    onChange([next, selectedUnit].join(''));
  };
  const allPlaceholder = isMixed ? (0,external_wp_i18n_namespaceObject.__)('Mixed') : null;
  const options = selectListSizes.map((size, index) => ({
    key: index,
    name: size.name
  }));
  const marks = spacingSizes.map((_newValue, index) => ({
    value: index,
