" Vim syntax file
" Language:	Vim 5.2e script
" Maintainer:	Dr. Charles E. Campbell, Jr. <Charles.Campbell@gsfc.nasa.gov>
" Last change:	June 23, 1998

" Remove old syntax
syn clear

syn keyword vimTodo contained	TODO

" regular vim commands
syn keyword vimCommand contained	I	d[elete]	mk[exrc]	sbp[revious]	wn[ext]
syn keyword vimCommand contained	N[ext]	di[splay]	mks[ession]	sbr[ewind]	wp[revous]
syn keyword vimCommand contained	a[ppend]	dig[raphs]	mkv[imrc]	se[t]	wq
syn keyword vimCommand contained	ab[breviate]	display	mod[e]	set	wqa[ll]
syn keyword vimCommand contained	abc[lear]	dj[ump]	n[ext]	sh[ell]	wqall
syn keyword vimCommand contained	al[l]	dl[ist]	new	si[malt]	wv[iminfo]
syn keyword vimCommand contained	ar[gs]	do[autocmd]	nm[ap]	sl[eep]	x[it]
syn keyword vimCommand contained	argu[ment]	doautoa[ll]	nmap	sla[st]	xa[ll]
syn keyword vimCommand contained	as[cii]	ds[earch]	nmapc[lear]	sm[agic]...	xall
syn keyword vimCommand contained	au[tocmd]	dsp[lit]	nn[oremap]	sn[ext]	y[ank]
syn keyword vimCommand contained	aug[roup]	e[dit]	no[remap]	sno[magic]...	am
syn keyword vimCommand contained	autocmd	ec[ho]	norea[bbrev]	so[urce]	amenu
syn keyword vimCommand contained	bN[ext]	echoh[l]	norm[al]	sp[lit]	an
syn keyword vimCommand contained	b[uffer]	echon	normal	spr[evious]	anoremenu
syn keyword vimCommand contained	ba[ll]	else	nu[mber]	sr[ewind]	aun
syn keyword vimCommand contained	bad[d]	elsei[f]	nun[map]	st[op]	aunmenu
syn keyword vimCommand contained	bd[elete]	en[dif]	o[pen]	sta[g]	be
syn keyword vimCommand contained	bdelete	endw[hile]	om[ap]	stj[ump]	behave
syn keyword vimCommand contained	be[have]	ex	omap	sts[elect]	cme
syn keyword vimCommand contained	bl[ast]	exe[cute]	omapc[lear]	sun[hide]	cmenu
syn keyword vimCommand contained	bm[odified]	exi[t]	on[ly]	sus[pend]	cnoreme
syn keyword vimCommand contained	bn[ext]	f[ile]	ono[remap]	sv[iew]	cnoremenu
syn keyword vimCommand contained	bp[revious]	files	ou[nmap]	syntax	cunme
syn keyword vimCommand contained	br[ewind]	fix[del]	p[rint]	t	cunmenu
syn keyword vimCommand contained	brea[k]	g[lobal]	pe[rl]	tN[ext]	ime
syn keyword vimCommand contained	bro[wse]	global	perld[o]	ta[g]	imenu
syn keyword vimCommand contained	buffers	gr[ep]	po[p]	tags	inoreme
syn keyword vimCommand contained	bun[load]	h[elp]	pre[serve]	tc[l]	inoremenu
syn keyword vimCommand contained	bunload	hid[e]	prev[ious]	tcld[o]	iunme
syn keyword vimCommand contained	cN[ext]	highlight	promptf[ind]	tclf[ile]	iunmenu
syn keyword vimCommand contained	c[hange]	i[nsert]	promptr[epl]	te[aroff]	me
syn keyword vimCommand contained	ca[bbrev]	ia[bbrev]	pw[d]	the	menu
syn keyword vimCommand contained	cabc[lear]	iabc[lear]	py[thon]	tj[ump]	nme
syn keyword vimCommand contained	cc	if	pyf[ile]	tl[ast]	nmenu
syn keyword vimCommand contained	cd	ij[ump]	q[uit]	tm[enu]	nnoreme
syn keyword vimCommand contained	ce[nter]	il[ist]	qa[ll]	tn[ext]	nnoremenu
syn keyword vimCommand contained	cf[ile]	im[ap]	qall	tp[revious]	noreme
syn keyword vimCommand contained	chd[ir]	imap	quit	tr[ewind]	noremenu
syn keyword vimCommand contained	che[ckpath]	imapc[lear]	r[ead]	ts[elect]	nunme
syn keyword vimCommand contained	cl[ist]	ino[remap]	rec[over]	tu[nmenu]	nunmenu
syn keyword vimCommand contained	cla[st]	inorea[bbrev]	red[o]	tunmenu	ome
syn keyword vimCommand contained	clo[se]	is[earch]	redi[r]	u[ndo]	omenu
syn keyword vimCommand contained	cm[ap]	isp[lit]	reg[isters]	una[bbreviate]	onoreme
syn keyword vimCommand contained	cmap	iu[nmap]	res[ize]	unh[ide]	onoremenu
syn keyword vimCommand contained	cmapc[lear]	iuna[bbrev]	resize	unl[et]	ounme
syn keyword vimCommand contained	cn[ext]	j[oin]	ret[ab]	unm[ap]	ounmenu
syn keyword vimCommand contained	cnew[er]	ju[mps]	rew[ind]	v[global]	tm
syn keyword vimCommand contained	cno[remap]	k	ri[ght]	ve[rsion]	tmenu
syn keyword vimCommand contained	cnorea[bbrev]	l[ist]	rv[iminfo]	vi[sual]	tu
syn keyword vimCommand contained	co[py]	la[st]	sN[ext]	vie[w]	tunmenu
syn keyword vimCommand contained	col[der]	le[ft]	s[ubstitute]	vm[ap]	unme
syn keyword vimCommand contained	con[tinue]	let	sa[rgument]	vmap	unmenu
syn keyword vimCommand contained	conf[irm]	ls	sal[l]	vmapc[lear]	vme
syn keyword vimCommand contained	cp[revious]	m[ove]	sbN[ext]	vn[oremap]	vmenu
syn keyword vimCommand contained	cq	ma[rk]	sb[uffer]	vu[nmap]	vnoreme
syn keyword vimCommand contained	cq[uit]	mak[e]	sba[ll]	wN[ext]	vnoremenu
syn keyword vimCommand contained	cr[ewind]	map	sbl[ast]	w[rite]	vunme
syn keyword vimCommand contained	cu[nmap]	mapc[lear]	sbm[odified]	wa[ll]	vunmenu
syn keyword vimCommand contained	cuna[bbrev]	marks	sbn[ext]	wh[ile]

" All vimCommands are contained by vimIsCommands.
syn match vimIsCommand	"^\s*[a-zA-Z]\+"		transparent contains=vimCommand
syn match vimIsCommand	"[:|]\s*[a-zA-Z]\+"	transparent contains=vimCommand

" vimOptions are caught only when contained in a vimSet
syn keyword vimOption contained	ai	endofline	isp	ro	taglength
syn keyword vimOption contained	akm	eol	isprint	rs	tagrelative
syn keyword vimOption contained	al	ep	joinspaces	ru	tags
syn keyword vimOption contained	aleph	equalalways	js	ruler	tbi
syn keyword vimOption contained	allowrevins	equalprg	keymodel	sb	tbs
syn keyword vimOption contained	altkeymap	errorbells	keywordprg	sbr	term
syn keyword vimOption contained	ari	errorfile	km	sc	terse
syn keyword vimOption contained	autoindent	errorformat	kp	scr	textauto
syn keyword vimOption contained	autowrite	esckeys	langmap	scroll	textmode
syn keyword vimOption contained	aw	et	laststatus	scrolljump	textwidth
syn keyword vimOption contained	background	eventignore	lazyredraw	scrolloff	tf
syn keyword vimOption contained	backspace	ex	lbr	scs	tildeop
syn keyword vimOption contained	backup	expandtab	lcs	sect	timeout
syn keyword vimOption contained	backupdir	exrc	linebreak	sections	timeoutlen
syn keyword vimOption contained	backupext	ff	lines	secure	title
syn keyword vimOption contained	bdir	ffs	lisp	sel	titlelen
syn keyword vimOption contained	bex	fileformat	list	selectmode	titlestring
syn keyword vimOption contained	bg	fileformats	listchars	sessionoptions	tl
syn keyword vimOption contained	bin	fk	lmap	sft	tm
syn keyword vimOption contained	binary	fkmap	ls	sh	to
syn keyword vimOption contained	biosk	fo	lz	shcf	top
syn keyword vimOption contained	bioskey	formatoptions	magic	shell	tr
syn keyword vimOption contained	bk	formatprg	makeef	shellcmdflag	ts
syn keyword vimOption contained	breakat	fp	makeprg	shellpipe	tsl
syn keyword vimOption contained	brk	gcr	mat	shellquote	ttimeout
syn keyword vimOption contained	bs	gd	matchpairs	shellredir	ttimeoutlen
syn keyword vimOption contained	cf	gdefault	matchtime	shelltype	ttm
syn keyword vimOption contained	ch	gfm	maxmapdepth	shellxquote	ttybuiltin
syn keyword vimOption contained	cin	gfn	maxmem	shiftround	ttyfast
syn keyword vimOption contained	cindent	go	maxmemtot	shiftwidth	ttym
syn keyword vimOption contained	cink	gp	mef	shm	ttymouse
syn keyword vimOption contained	cinkeys	grepformat	mh	shortmess	ttyscroll
syn keyword vimOption contained	cino	grepprg	ml	shortname	ttytype
syn keyword vimOption contained	cinoptions	guicursor	mls	showbreak	tw
syn keyword vimOption contained	cinw	guifont	mm	showcmd	tx
syn keyword vimOption contained	cinwords	guioptions	mmd	showfulltag	uc
syn keyword vimOption contained	cmdheight	guipty	mmt	showmatch	ul
syn keyword vimOption contained	co	helpfile	mod	showmode	undolevels
syn keyword vimOption contained	columns	helpheight	modeline	shq	updatecount
syn keyword vimOption contained	com	hf	modelines	si	updatetime
syn keyword vimOption contained	comments	hh	modified	sidescroll	ut
syn keyword vimOption contained	compatible	hi	more	sj	vb
syn keyword vimOption contained	complete	hid	mouse	sm	vbs
syn keyword vimOption contained	confirm	hidden	mousef	smartcase	verbose
syn keyword vimOption contained	cp	highlight	mousefocus	smartindent	vi
syn keyword vimOption contained	cpo	history	mousehide	smarttab	viminfo
syn keyword vimOption contained	cpoptions	hk	mousem	smd	visualbell
syn keyword vimOption contained	cpt	hkmap	mousemodel	sn	wa
syn keyword vimOption contained	cscopetagorder	hkmapp	mouset	so	wak
syn keyword vimOption contained	cscopeverbose	hkp	mousetime	softtabstop	warn
syn keyword vimOption contained	cscopexec	hl	mp	sol	wb
syn keyword vimOption contained	csexec	hls	mps	sp	wc
syn keyword vimOption contained	csta	hlsearch	nf	splitbelow	wd
syn keyword vimOption contained	cstagalways	ic	nrformats	sr	weirdinvert
syn keyword vimOption contained	csto	icon	nu	srr	wh
syn keyword vimOption contained	csverb	iconstring	number	ss	whichwrap
syn keyword vimOption contained	def	ignorecase	pa	ssop	wildchar
syn keyword vimOption contained	define	im	para	st	wildmode
syn keyword vimOption contained	dg	inc	paragraphs	sta	wim
syn keyword vimOption contained	dict	include	paste	startofline	winaltkeys
syn keyword vimOption contained	dictionary	incsearch	patchmode	sts	winheight
syn keyword vimOption contained	digraph	inf	path	su	wiv
syn keyword vimOption contained	dir	infercase	pm	suffixes	wm
syn keyword vimOption contained	directory	insertmode	readonly	sw	wrap
syn keyword vimOption contained	ea	is	remap	swapsync	wrapmargin
syn keyword vimOption contained	eb	isf	report	sws	wrapscan
syn keyword vimOption contained	ed	isfname	restorescreen	sxq	writeany
syn keyword vimOption contained	edcompatible	isi	revins	ta	writebackup
syn keyword vimOption contained	ef	isident	ri	tabstop	writedelay
syn keyword vimOption contained	efm	isk	rightleft	tag	ws
syn keyword vimOption contained	ei	iskeyword	rl	tagbsearch	ww
syn keyword vimOption contained	ek

" These are the turn-off setting variants
syn keyword vimOption contained	noai	noeol	noinsertmode	noro	notbi
syn keyword vimOption contained	noakm	noequalalways	nois	nors	notbs
syn keyword vimOption contained	noalkeymap	noerrorbells	nojoinspaces	noru	noterse
syn keyword vimOption contained	noallowrevins	noesckeys	nojs	noruler	notextauto
syn keyword vimOption contained	noari	noet	nolbr	nosb	notextmode
syn keyword vimOption contained	noautoindent	noex	nolinebreak	nosc	notf
syn keyword vimOption contained	noautowrite	noexpandtab	nolisp	noscs	notildeop
syn keyword vimOption contained	noaw	noexrc	nolist	nosecure	notimeout
syn keyword vimOption contained	nobackup	nofk	nomagic	noshiftround	notitle
syn keyword vimOption contained	nobin	nofkmap	nomh	noshortname	noto
syn keyword vimOption contained	nobinary	nogd	noml	noshowcmd	notop
syn keyword vimOption contained	nobiosk	nogdefault	nomod	noshowmatch	notr
syn keyword vimOption contained	nobioskey	noguipty	nomodeline	noshowmode	nottimeout
syn keyword vimOption contained	nobk	nohid	nomodified	nosi	nottybuiltin
syn keyword vimOption contained	nocf	nohidden	nomore	nosm	nottyfast
syn keyword vimOption contained	nocin	nohk	nomousef	nosmartcase	notx
syn keyword vimOption contained	nocindent	nohkmap	nomousefocus	nosmartindent	novb
syn keyword vimOption contained	nocompatible	nohkmapp	nomousehide	nosmarttab	novisualbell
syn keyword vimOption contained	noconfirm	nohkp	nonu	nosmd	nowa
syn keyword vimOption contained	nocp	nohls	nonumber	nosn	nowarn
syn keyword vimOption contained	nodg	nohlsearch	nopaste	nosol	nowb
syn keyword vimOption contained	nodigraph	noic	noreadonly	nosplitbelow	noweirdinvert
syn keyword vimOption contained	noea	noicon	noremap	nosr	nowiv
syn keyword vimOption contained	noeb	noignorecase	norestorescreen	nosta	nowrap
syn keyword vimOption contained	noed	noim	norevins	nostartofline	nowrapscan
syn keyword vimOption contained	noedcompatible	noincsearch	nori	nota	nowriteany
syn keyword vimOption contained	noek	noinf	norightleft	notagbsearch	nowritebackup
syn keyword vimOption contained	noendofline	noinfercase	norl	notagrelative	nows

" termcap codes (which can also be set)
syn keyword vimOption contained	t_AB	t_RI	t_da	t_k9	t_ks	t_so
syn keyword vimOption contained	t_AF	t_Sb	t_db	t_kD	t_ku	t_sr
syn keyword vimOption contained	t_AL	t_Sf	t_dl	t_kI	t_le	t_te
syn keyword vimOption contained	t_CS	t_ZH	t_k1	t_kN	t_mb	t_ti
syn keyword vimOption contained	t_Co	t_ZR	t_k2	t_kP	t_md	t_ue
syn keyword vimOption contained	t_DL	t_al	t_k3	t_kb	t_me	t_us
syn keyword vimOption contained	t_F1	t_bc	t_k4	t_kd	t_mr	t_vb
syn keyword vimOption contained	t_F2	t_cd	t_k5	t_ke	t_ms	t_ve
syn keyword vimOption contained	t_K1	t_ce	t_k6	t_kh	t_nd	t_vi
syn keyword vimOption contained	t_K3	t_cl	t_k7	t_kl	t_op	t_vs
syn keyword vimOption contained	t_K4	t_cm	t_k8	t_kr	t_se	t_xs
syn keyword vimOption contained	t_K5	t_cs
syn match   vimOption contained	"t_#4"
syn match   vimOption contained	"t_%1"
syn match   vimOption contained	"t_%i"
syn match   vimOption contained	"t_&8"
syn match   vimOption contained	"t_@7"
syn match   vimOption contained	"t_k;"

" these settings don't actually cause errors in vim, but were supported by vi and don't do anything in vim
syn keyword vimErrSetting contained	hardtabs	w1200	w9600	wi	window
syn keyword vimErrSetting contained	ht	w300

" AutoBuf Events
syn keyword vimAutoEvent contained	BufDelete	BufReadPre	FileAppendPre	FilterReadPost	TermChanged
syn keyword vimAutoEvent contained	BufEnter	BufUnload	FileChangedShell	FilterReadPre	User
syn keyword vimAutoEvent contained	BufLeave	BufWrite	FileReadPost	FilterWritePost	VimEnter
syn keyword vimAutoEvent contained	BufNewFile	BufWritePost	FileReadPre	FilterWritePre	VimLeave
syn keyword vimAutoEvent contained	BufRead	BufWritePre	FileWritePost	StdinReadPost	WinEnter
syn keyword vimAutoEvent contained	BufReadPost	FileAppendPost	FileWritePre	StdinReadPre	WinLeave

" Highlight commonly used Groupnames
syn keyword vimGroup	Comment	Identifier	Keyword	Type	Tag
syn keyword vimGroup	Constant	Function	Exception	StorageClass	Delimiter
syn keyword vimGroup	String	Statement	PreProc	Structure	SpecialComment
syn keyword vimGroup	Character	Conditional	Include	Typedef	Debug
syn keyword vimGroup	Number	Repeat	Define	Special	Error
syn keyword vimGroup	Boolean	Label	Macro	SpecialChar	Todo
syn keyword vimGroup	Float	Operator	PreCondit

" Default highlighting groups
syn keyword vimHLGroup	Cursor	LineNr	NonText	Search	Title
syn keyword vimHLGroup	Directory	Menu	Normal	SpecialKey	Visual
syn keyword vimHLGroup	ErrorMsg	ModeMsg	Question	StatusLine	WarningMsg
syn keyword vimHLGroup	IncSearch	MoreMsg	Scrollbar	StatusLineNC

" Function Names
syn keyword vimFuncName contained	argc	confirm	getline	line	substitute
syn keyword vimFuncName contained	argv	delete	has	match	synID
syn keyword vimFuncName contained	browse	escape	hlID	matchend	synIDattr
syn keyword vimFuncName contained	bufexists	exists	hlexists	nr2char	synIDtran
syn keyword vimFuncName contained	bufname	expand	hostname	strftime	tempname
syn keyword vimFuncName contained	bufnr	filereadable	input	strlen	virtcol
syn keyword vimFuncName contained	char2nr	fnamemodify	isdirectory	strpart	winheight
syn keyword vimFuncName contained	col	getcwd
syn match vimFunc "\I\i*\s*("	contains=vimFuncName

"--- syntax above generated by mkvimvim ---
" Highlight syntax stuff

syn keyword vimPattern contained	start	skip	end

syn keyword vimSpecial	ALL	ccomment	matchgroup	skipempty	sync
syn keyword vimSpecial	NONE	lines	minlines	skipnl	transparent

" Highlight syntax stuff -- the following vimSpecials aren't keywords because Vim's syntax checking
" disapproves
syn match vimSpecial	contained	"\<ALLBUT\>"
syn match vimSpecial	contained	"\<clear\>"
syn match vimSpecial	contained	"\<contained\>"
syn match vimSpecial	contained	"\<oneline\>"
syn match vimSpecial	contained	"\<contains\>"
syn match vimSpecial	contained	"\<grouphere\>"
syn match vimSpecial	contained	"\<groupthere\>"
syn match vimSpecial	contained	"\<keepend\>"
syn match vimSpecial	contained	"\<maxlines\>"
syn match vimSpecial	contained	"\<nextgroup\>"
syn match vimSpecial	contained	"\<skipempty\>"
syn match vimSpecial	contained	"\<skipnl\>"
syn match vimSpecial	contained	"\<skipwhite\>"
syn match vimSpecial	contained	"\<transparent\>"

" Highlight Terminal Stuff
syn keyword vimTermSet  contained	background	cterm	ctermfg	font	gui	guifg
syn keyword vimTermSet  contained	bg	ctermbg	fg	foreground	guibg	term	start
syn match   vimTermSet  contained	"stop"

" Special Filenames and Modifiers
syn match vimSpecFile	"<\(cword\|cWORD\|[cas]file\)>"	nextgroup=vimSpecFileMod
syn match vimSpecFile	"#\d\|[#%]"		nextgroup=vimSpecFileMod
syn match vimSpecFileMod	"\(:[phtre]\)\+"		contained

" Conditionals
syn match vimConditional	"^\s*\(continue\|con\)\>"
syn match vimConditional	"^\s*\(endif\|en\)\>"
syn match vimConditional	"^\s*\(endwhile\|endw\)\>"
syn match vimConditional	"^\s*\(while\|wh\)\>"
syn match vimConditional	"^\s*break\=\>"
syn match vimConditional	"^\s*else\>"
syn match vimConditional	"^\s*elseif\=\>"
syn match vimConditional	"^\s*if\>"

" Operators
syn match vimOper	"||\|&&\|!=\|>=\|<=\|=\~\|!\~\|>\|<\|+\|-\|=\|\." skipwhite nextgroup=vimString

" Numbers
syn match vimNumber	"\<\d\+.\d\+"
syn match vimNumber	"\<\d\+L\="
syn match vimNumber	"-\d\+.\d\+"
syn match vimNumber	"-\d\+L\="
syn match vimNumber	"[[;:]\d\+"lc=1
syn match vimNumber	"0[xX][0-9a-fA-F]\+"
syn match vimNumber	"#[0-9a-fA-F]\+"

" Lower Priority Comments: after some vim commands...
syn match vimComment	+\s"[^\-:.%#=*].*$+lc=1	contains=vimTodo
syn match vimComment	+\<endif\s\+".*$+lc=5	contains=vimTodo
syn match vimComment	+\<else\s\+".*$+lc=4	contains=vimTodo
syn match vimComment	+^\s*".*$+		contains=vimTodo

" Try to catch strings, if nothing else matches (therefore it must precede the others!)
"  vmEscapeBrace handles ["]  []"] (ie. stays as string)
syn region	vimEscapeBrace	start="[^\\]\(\\\\\)*\[\^\=\]\=" skip="\\\\\|\\\]" end="\]"me=e-1	oneline contained transparent
syn match	vimPatSep	"\\[|()]"hs=e-1	contained
syn match	vimNotPatSep	"\\\\"	contained
syn region	vimString	start=+[^:a-zA-Z>!\\]"+lc=1 skip=+\\\\\|\\"+ end=+"+ oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	start=+[^:a-zA-Z>!\\]'+lc=1 skip=+\\\\\|\\'+ end=+'+ oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	start=+=!+lc=1	skip=+\\\\\|\\!+ end=+!+	oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	start="=+"lc=1	skip="\\\\\|\\+" end="+"	oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	start="[^\\]+\s*[^a-zA-Z0-9.]"lc=1 skip="\\\\\|\\+" end="+"	oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	start="\s/\s*[^a-zA-Z]"lc=1 skip="\\\\\|\\+" end="/"	oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep

" Substitutions
syn region	vimSubst	start=":\=s/.\{-}" skip="\(\\\\\)*\\/" end="/"	oneline contains=vimPatSep,vimSubstTwoBS,vimSubstRange,vimNotation nextgroup=vimSubstEnd
syn region	vimSubstEnd	start="."lc=1	skip="\(\\\\\)*\\/"   end="/"	oneline contained contains=vimSubstPat,vimSubstTwoBS,vimNotation
syn region	vimSubstRange	start="\["	skip="\(\\\\\)*\\]"   end="]"	oneline contained
syn match	vimSubstPat	"\\\d"			contained
syn match	vimSubstTwoBS	"\\\\"			contained

" Marks, Registers, Addresses, Filters
syn match	vimMark	"[!,:]'[a-zA-Z0-9]"lc=1
syn match	vimMark	"'[a-zA-Z0-9][,!]"me=e-1
syn match	vimMark	"[^a-zA-Z]norm\s'[a-zA-Z0-9]"lc=6
syn match	vimMark	"[^a-zA-Z]normal\s'[a-zA-Z0-9]"lc=8
syn match	vimPlainMark	"'[a-zA-Z0-9]"		contained

syn match	vimRegister	'[^(,;]"[a-zA-Z0-9\-:.%#*=][^a-zA-Z_"]'lc=1
syn match	vimRegister	'[^a-zA-Z]norm\s"[a-zA-Z0-9]'lc=6
syn match	vimRegister	'[^a-zA-Z]normal\s"[a-zA-Z0-9]'lc=8
syn match	vimPlainRegister	'"[a-zA-Z0-9\-:.%#*=]'	contained

syn match	vimAddress	",\."lc=1
syn match   	vimAddress	"[:|][%.]"lc=1
syn match   	vimAddress	"<Bar>%"lc=5

syn match	vimFilter	":\s*!"ms=e
syn match	vimFilter	"[^a-zA-Z]!"lc=1

" Complex repeats (:h complex-repeat)
syn match vimCmplxRepeat	'[^a-zA-Z_/\\]q[0-9a-zA-Z"]'lc=1
syn match vimCmplxRepeat	'@[0-9a-z".=@:]'

" High Priority Comments: beginning of line with optional spaces then "
syn match vimComment	+^\s*".*$+	contains=vimTodo

" Set command and associated set-options (vimOptions) with comment
syn region vimSet matchgroup=vimCommand start="\s*set\>" end="|\|$"	keepend contains=vimSetEqual,vimOption,vimErrSetting,vimComment,vimSetString
syn region vimSetEqual  contained	start="="	skip="\(\\\\\)*\\\s" end="[| \t]\|$"me=e-1 contains=vimCtrlChar
syn region vimSetString contained	start=+="+hs=s+1	skip=+\(\\\\\)\\"+   end=+"+	contains=vimCtrlChar

" Highlight modifiers
syn keyword VimHLMod contained NONE bold inverse italic reverse standout underline

" Autocmd
syn match  vimIsCommand2 "[ \t<Bar>][a-zA-Z_]\+"lc=1 transparent contained contains=vimCommand
syn region vimAutoCmd matchgroup=vimAutoSet start=+^\s*\(autocmd\|au\)\>+	end="$" keepend contains=vimAutoEvent,vimSet,vimIsCommand,vimIsCommand2,vimString,vimComment,vimSpecFile,vimNotation,vimFilter,vimAuSynLine,vimAuRegion
syn region vimAutoCmd matchgroup=vimAutoSet start=+^\s*\(doautoa\|doautoall\)\>+	end="$" keepend contains=vimAutoEvent,vimSet,vimIsCommand,vimIsCommand2,vimString,vimComment,vimSpecFile,vimNotation,vimFilter,vimAuSynLine,vimAuRegion

" Syntax regions (all oneliners)
syn keyword vimKeyword link match		contained
syn keyword vimCase    ignore match	contained
syn keyword vimSynGroup add remove	contained
syn match   vimSynGroup "contains"	contained
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(highlight\|hi\)\s"	end="$"	keepend contains=vimKeyword,vimSpecial,vimGroup,vimTermSet,vimComment,vimCtrlChar,VimRegion,vimNotation,vimNumber,vimHLMod,vimOption,vimHLGroup
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+case"	end="$"	keepend contains=vimCase,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+clear"rs=e-5 end="$"	keepend contains=vimSpecial,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+cluster"	end="$"	keepend contains=vimSynGroup,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+group"	end="$"	keepend contains=vimSynGroup,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+include"	end="$"	keepend contains=vimComment,vimNotation
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+match"	end="$"	keepend contains=vimKeyword,vimSpecial,vimString,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+region"	end="$"	keepend contains=vimKeyword,vimSpecial,vimString,vimPattern,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+sync"	end="$"	keepend contains=vimKeyword,vimSpecial,vimString,vimComment
syn region vimSynLine matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+keyword"	end="$"	keepend contains=vimKeyword,vimSpecial,vimComment

syn region vimAuSynLine matchgroup=vimKeyword start="\s\(syntax\|syn\)\s\+keyword"lc=1 end="$"	keepend contains=vimKeyword,vimSpecial,vimComment contained
syn region vimAuRegion  matchgroup=vimKeyword start="\s\(syntax\|syn\)\s\+region"lc=1  end="$"	keepend contains=vimKeyword,vimSpecial,vimString,vimPattern,vimComment contained
syn region vimAuRegion  matchgroup=vimKeyword start="\s\(syntax\|syn\)\s\+match"lc=1	end="$"	keepend contains=vimKeyword,vimSpecial,vimString,vimComment contained
syn region vimAuRegion  matchgroup=vimKeyword start="\s\(syntax\|syn\)\s\+clear"rs=e-5 end="$"	keepend contains=vimSpecial,vimComment contained
syn region vimAuRegion  matchgroup=vimKeyword start="\s\(syntax\|syn\)\s\+case"lc=1 end="$"	keepend contains=vimCase,vimComment contained
syn region vimAuRegion  matchgroup=vimKeyword start="\s\(syntax\|syn\)\s\+sync"lc=1 end="$"	keepend contains=vimKeyword,vimSpecial,vimString,vimComment contained
syn region vimAuRegion  matchgroup=vimKeyword start="\s\(highlight\|hi\)\s"lc=1 end="$"	keepend contains=vimKeyword,vimSpecial,vimGroup,vimTermSet,vimComment,vimCtrlChar,VimRegion,vimNotation,vimNumber,vimHLMod,vimOption,vimHLGroup contained

" Angle-Bracket Notation
syn match vimNotation	"<[a-zA-Z][a-zA-Z0-9]\+>"		contains=vimBracket
syn match vimNotation	"<C-[A-Z]>"			contains=vimBracket
syn match vimNotation	"<[AM]-.>"			contains=vimBracket
syn match vimNotation	"<[SCAM]-\(Right\|Left\|Down\|Up\)>"	contains=vimBracket
syn match vimNotation	"<S-F\d>"			contains=vimBracket
syn match vimNotation	'<C-R>[0-9a-z"%#:.\-=]'he=e-1		contains=vimBracket
syn match vimNotation	"<CR>"			contains=vimBracket nextgroup=vimPlainMark,vimPlainRegister,vimAddress
syn match vimNotation	"<Esc>"			contains=vimBracket nextgroup=vimPlainMark,vimPlainRegister,vimAddress
syn match vimBracket contained	"[<>]"

" Additional IsCommand stuff, here by reasons of precedence
syn match vimIsCommand	"<Bar>\s*[a-zA-Z]\+"	transparent contains=vimCommand,vimNotation

" Control Characters
syn match vimCtrlChar	"[--]"

if !exists("did_vim_syntax_inits")
  let did_vim_syntax_inits = 1
  " The default methods for highlighting.  Can be overridden later
  hi link vimAddress	vimMark
  hi link vimAutoSet	vimCommand
  hi link vimConditional	vimStatement
  hi link vimFilter	vimOper
  hi link vimHLGroup	vimGroup
  hi link vimNotPatSep	vimString
  hi link vimPlainMark	vimMark
  hi link vimPlainRegister	vimRegister
  hi link vimSetString	vimString
  hi link vimSpecFileMod	vimSpecFile
  hi link vimSynGroup	vimSpecial
  hi link vimTerminal	vimGroup

  hi link vimAutoEvent	Type
  hi link vimBracket	Delimiter
  hi link vimCmplxRepeat	SpecialChar
  hi link vimCommand	Statement
  hi link vimComment	Comment
  hi link vimCtrlChar	SpecialChar
  hi link vimErrSetting	Error
  hi link vimFuncName	Function
  hi link vimGroup	Type
  hi link vimHLMod	PreProc
  hi link vimKeyword	Statement
  hi link vimMark	Number
  hi link vimNotation	Special
  hi link vimNumber	Number
  hi link vimOper	Operator
  hi link vimOption	PreProc
  hi link vimPatSep	SpecialChar
  hi link vimPattern	Type
  hi link vimRegister	SpecialChar
  hi link vimSpecFile	Identifier
  hi link vimSpecial	Type
  hi link vimStatement	Statement
  hi link vimString	String
  hi link vimSubstPat	SpecialChar
  hi link vimTermSet	StorageClass
  hi link vimTodo	Todo
endif

let b:current_syntax = "vim"

" vim: ts=17
