" Set options and add mapping such that Vim behaves a lot like MS-Windows

" make 'cpoptions' empty
let save_cpo = &cpo
set cpo=

" set 'selection', 'selectmode', 'mousemodel' and 'keymodel' for MS-Windows
behave mswin

" CTRL-X is Cut
vmap <C-X> "*x

" CTRL-C is Copy
vmap <C-C> "*ygV

" CTRL-V is Paste
map <C-V> "*P
vmap <C-V> ""x"*P
map! <C-V> <Esc>"*P']a

" CTRL-Z is undo
map <C-Z> u
map! <C-Z> <C-O>u

" CTRL-Y is redo (although not repeat)
map <C-Y> <C-R>
map! <C-Y> <C-O><C-R>

" Alt-Space is system menu
map <M-Space> :simalt ~<CR>
map! <M-Space> <C-O>:simalt ~<CR>

" restore 'cpoptions'
let &cpo = save_cpo
unlet save_cpo
