" These menu commands create the default Vim menus.

" You can use this as a start for your own set of menus.

" Make sure the '<' flag is not included in 'cpoptions', otherwise <CR> would
" not be recognized.  See ":help 'cpoptions'".
let cpo_save = &cpo
let &cpo = ""

" Help menu
" Note that "amenu" is used to make it work in all modes
9999amenu &Help.&Overview\ \ <F1>		:help<CR>
amenu &Help.&How\ to\.\.\.			:help how-to<CR>
amenu &Help.&GUI				:help gui<CR>
amenu &Help.&Version				:version<CR>
amenu &Help.&Credits				:help credits<CR>
amenu &Help.Co&pying				:help uganda<CR>
amenu &Help.&About				:intro<CR>

" File menu
amenu 10.310 &File.&Open\.\.\.<Tab>:e		:browse confirm e<CR>
amenu 10.320 &File.Sp&lit-Open\.\.\.<Tab>:sp	:browse sp<CR>
amenu 10.330 &File.&Save<Tab>:w			:confirm w<CR>
amenu 10.340 &File.Save\ &As\.\.\.<Tab>:w	:browse w<CR>
amenu 10.350 &File.&Close<Tab>:q		:confirm q<CR>
if has("win32")
" Use Notepad for printing.
  amenu 10.360 &File.&Print :let smod=&mod<Bar>:let ttt=tempname()<Bar>exec ":w! ".ttt<Bar>let &mod=smod<Bar>exec "!notepad /p ".ttt<Bar>exec "!del ".ttt<CR>
  vmenu &File.&Print <Esc>:let smod=&mod<Bar>:let ttt=tempname()<Bar>exec ":'<,'>w! ".ttt<Bar>let &mod=smod<Bar>exec "!notepad /p ".ttt<Bar>exec "!del ".ttt<CR>
elseif has("unix")
  amenu 10.360 &File.&Print			:w !lpr<CR>
  vmenu &File.&Print				:w !lpr<CR>
endif
amenu 10.370 &File.Sa&ve-Exit<Tab>:wqa		:confirm wqa<CR>
amenu 10.380 &File.E&xit<Tab>:qa		:confirm qa<CR>


" Edit menu
amenu 20.310 &Edit.&Undo<Tab>u			u
amenu 20.320 &Edit.&Redo<Tab>Ctrl+R		<C-R>
vmenu 20.330 &Edit.Cu&t<Tab>"*x			"*x
vmenu 20.340 &Edit.&Copy<Tab>"*y		"*y
nmenu 20.350 &Edit.Put\ &Before<Tab>[p		[p
imenu	     &Edit.Put\ &Before<Tab>[p		<C-O>[p
nmenu 20.360 &Edit.Put\ &After<Tab>]p		]p
imenu	     &Edit.Put\ &After<Tab>]p		<C-O>]p
nmenu 20.370 &Edit.&Paste<Tab>"*p		i<C-R>*<Esc>
vmenu	     &Edit.&Paste<Tab>"*p		""xi<C-R>*<Esc>
menu!	     &Edit.&Paste<Tab>"*p		<C-R>*
if has("win32")
  vmenu 20.380 &Edit.&Delete<Tab>x		x
endif
amenu 20.390 &Edit.&Select\ all<Tab>ggvG	:if &sel != ""<Bar>exe ":norm gggT<C-O>G"<Bar>else<Bar>exe ":norm ggVG"<Bar>endif<CR>
if has("win32")
  amenu 20.400 &Edit.&Find\.\.\.		:promptfind<CR>
  amenu 20.410 &Edit.Find\ and\ R&eplace\.\.\.	:promptrepl<CR>
  vmenu 20.410 &Edit.Find\ and\ R&eplace\.\.\.	y:promptrepl <C-R>"<CR>
else
  amenu 20.400 &Edit.&Find<Tab>/			/
  amenu 20.410 &Edit.Find\ and\ R&eplace<Tab>:%s	:%s/
  vmenu	       &Edit.Find\ and\ R&eplace<Tab>:s		:s/
endif

" Window menu
amenu 30.300 &Window.&New		<C-W>n
amenu 30.310 &Window.S&plit		<C-W>s
amenu 30.320 &Window.Sp&lit\ To\ #	<C-W><C-^>
amenu 30.330 &Window.&Close		<C-W>c
amenu 30.340 &Window.Close\ &Other(s)	<C-W>o
amenu 30.350 &Window.Ne&xt		<C-W>w
amenu 30.360 &Window.P&revious		<C-W>W
amenu 30.370 &Window.&Equal\ Height	<C-W>=
amenu 30.380 &Window.Rotate\ &Up	<C-W>R
amenu 30.390 &Window.Rotate\ &Down	<C-W>r
if has("gui_win32")
  amenu 30.400 &Window.Select\ &Font	:set guifont=*<CR>
endif

" Programming menu
amenu 40.300 &IDE.&Make			:make<CR>
amenu 40.310 &IDE.&List\ Errors		:cl<CR>
amenu 40.320 &IDE.L&ist\ Messages	:cl!<CR>
amenu 40.330 &IDE.&Next\ Error		:cn<CR>
amenu 40.340 &IDE.&Previous\ Error	:cp<CR>
amenu 40.350 &IDE.&Older\ List		:colder<CR>
amenu 40.360 &IDE.N&ewer\ List		:cnewer<CR>

" The Win32 GUI toolbar
if has("win32")
  amenu ToolBar.Open		:browse e<CR>
  tmenu ToolBar.Open		Open file
  amenu ToolBar.Save		:w<CR>
  tmenu ToolBar.Save		Save current file
  amenu ToolBar.SaveAll		:wa<CR>
  tmenu ToolBar.SaveAll		Save all files

  amenu ToolBar.Print		:let ttt=tempname()<Bar>exec ":w! ".ttt<Bar>exec "!start notepad /p ".ttt<Bar>exec "!del ".ttt<CR>
  vmenu ToolBar.Print		<Esc>:let ttt=tempname()<Bar>exec ":'<,'>w! ".ttt<Bar>exec "!start notepad /p ".ttt<Bar>exec "!del ".ttt<CR>
  tmenu ToolBar.Print		Print

  amenu ToolBar.Undo		u
  tmenu ToolBar.Undo 		Undo
  amenu ToolBar.Redo		<C-R>
  tmenu ToolBar.Redo 		Redo
  vmenu ToolBar.Cut		"*x
  tmenu ToolBar.Cut		Cut to clipboard
  vmenu ToolBar.Copy		"*y
  tmenu ToolBar.Copy		Copy to clipboard
  nmenu ToolBar.Paste		i<C-R>*<Esc>
  vmenu ToolBar.Paste		""xi<C-R>*<Esc>
  menu! ToolBar.Paste		<C-R>*
  tmenu ToolBar.Paste		Paste from Clipboard

  amenu ToolBar.Find		/
  tmenu ToolBar.Find		Find
  amenu ToolBar.FindNext	n
  tmenu ToolBar.FindNext	Find Next
  amenu ToolBar.FindPrev	N
  tmenu ToolBar.FindPrev	Find Previous
  amenu ToolBar.Replace		:%s/
  vmenu ToolBar.Replace		:s/
  tmenu ToolBar.Replace		Find && Replace

  amenu ToolBar.New		<C-W>n
  tmenu ToolBar.New		New Window
  amenu ToolBar.WinSplit	<C-W>s
  tmenu ToolBar.WinSplit	Split Window
  amenu ToolBar.WinZoom		:resize 100<CR>
  tmenu ToolBar.WinZoom		Maximise Window
  amenu ToolBar.WinMin		:resize 1<CR>
  tmenu ToolBar.WinMin		Minimise Window
  amenu ToolBar.WinClose	:close<CR>
  tmenu ToolBar.WinClose	Close Window

  amenu ToolBar.LoadSession	:browse so $vim\\session<CR>
  tmenu ToolBar.LoadSession	Load session
  amenu ToolBar.SaveSession	:execute ("mksession " . this_session)
  tmenu ToolBar.SaveSession	Save current session
  amenu ToolBar.RunMacro	:browse so<CR>
  tmenu ToolBar.RunMacro	Run a Macro

  amenu ToolBar.Make		:make<CR>
  tmenu ToolBar.Make		Make current project
  amenu ToolBar.Shell		:sh<CR>
  tmenu ToolBar.Shell		Open a command shell
  amenu ToolBar.TagsBuild	:!ctags *.c *.h *.i<CR>
  tmenu ToolBar.TagsBuild	Build tags in current directory
  amenu ToolBar.TagsJump	g]
  tmenu ToolBar.TagsJump	Jump to tag under cursor

  amenu ToolBar.Help		:help<CR>
  tmenu ToolBar.Help		Vim Help
  amenu ToolBar.FindHelp	:help
  tmenu ToolBar.FindHelp 	Search Vim Help
endif

" Restore the previous value of 'cpoptions'.
let &cpo = cpo_save
unlet cpo_save
