" Vim syntax file
" Language:	Vim script
" Maintainer:	Dr. Charles E. Campbell, Jr. <cec@gryphon.gsfc.nasa.gov>
" Last change:	April 22, 1998 (a)

" Remove old syntax
syn clear

syn keyword vimTodo contained	TODO

" regular vim commands
syn keyword vimCommand contained	I	d[elete]	map	sb[uffer]	w[rite]
syn keyword vimCommand contained	N[ext]	di[splay]	mapc[lear]	sba[ll]	wa[ll]
syn keyword vimCommand contained	a[ppend]	dig[raphs]	marks	sbl[ast]	wh[ile]
syn keyword vimCommand contained	ab[breviate]	display	mk[exrc]	sbm[odified]	wn[ext]
syn keyword vimCommand contained	abc[lear]	dj[ump]	mks[ession]	sbn[ext]	wp[revous]
syn keyword vimCommand contained	al[l]	dl[ist]	mkv[imrc]	sbp[revious]	wq
syn keyword vimCommand contained	ar[gs]	do[autocmd]	mod[e]	sbr[ewind]	wqa[ll]
syn keyword vimCommand contained	argu[ment]	doautoa[ll]	n[ext]	se[t]	wqall
syn keyword vimCommand contained	as[cii]	ds[earch]	new	set	wv[iminfo]
syn keyword vimCommand contained	au[tocmd]	dsp[lit]	nm[ap]	sh[ell]	x[it]
syn keyword vimCommand contained	aug[roup]	e[dit]	nmap	sl[eep]	xa[ll]
syn keyword vimCommand contained	autocmd	ec[ho]	nmapc[lear]	sla[st]	xall
syn keyword vimCommand contained	bN[ext]	echoh[l]	nn[oremap]	sn[ext]	y[ank]
syn keyword vimCommand contained	b[uffer]	echon	no[remap]	so[urce]	am
syn keyword vimCommand contained	ba[ll]	else	norea[bbrev]	sp[lit]	amenu
syn keyword vimCommand contained	bd[elete]	elsei[f]	norm[al]	spr[evious]	an
syn keyword vimCommand contained	bdelete	en[dif]	normal	sr[ewind]	anoremenu
syn keyword vimCommand contained	bl[ast]	endw[hile]	nu[mber]	st[op]	aun
syn keyword vimCommand contained	bm[odified]	ex	nun[map]	sta[g]	aunmenu
syn keyword vimCommand contained	bn[ext]	exe[cute]	o[pen]	stj[ump]	cme
syn keyword vimCommand contained	bp[revious]	exi[t]	om[ap]	sts[elect]	cmenu
syn keyword vimCommand contained	br[ewind]	f[ile]	omap	sun[hide]	cnoreme
syn keyword vimCommand contained	brea[k]	files	omapc[lear]	sus[pend]	cnoremenu
syn keyword vimCommand contained	bro[wse]	fix[del]	on[ly]	sv[iew]	cunme
syn keyword vimCommand contained	buffers	g[lobal]	ono[remap]	syntax	cunmenu
syn keyword vimCommand contained	bun[load]	global	ou[nmap]	t	ime
syn keyword vimCommand contained	bunload	h[elp]	p[rint]	tN[ext]	imenu
syn keyword vimCommand contained	cN[ext]	hid[e]	pe[rl]	ta[g]	inoreme
syn keyword vimCommand contained	c[hange]	highlight	perld[o]	tags	inoremenu
syn keyword vimCommand contained	ca[bbrev]	i[nsert]	po[p]	tc[l]	iunme
syn keyword vimCommand contained	cabc[lear]	ia[bbrev]	pre[serve]	tcld[o]	iunmenu
syn keyword vimCommand contained	cc	iabc[lear]	prev[ious]	tclf[ile]	me
syn keyword vimCommand contained	cd	if	pw[d]	te[aroff]	menu
syn keyword vimCommand contained	ce[nter]	ij[ump]	py[thon]	the	nme
syn keyword vimCommand contained	cf[ile]	il[ist]	pyf[ile]	tj[ump]	nmenu
syn keyword vimCommand contained	chd[ir]	im[ap]	q[uit]	tl[ast]	nnoreme
syn keyword vimCommand contained	che[ckpath]	imap	qa[ll]	tn[ext]	nnoremenu
syn keyword vimCommand contained	cl[ist]	imapc[lear]	qall	tp[revious]	noreme
syn keyword vimCommand contained	clast	ino[remap]	quit	tr[ewind]	noremenu
syn keyword vimCommand contained	clo[se]	inorea[bbrev]	r[ead]	ts[elect]	nunme
syn keyword vimCommand contained	cm[ap]	is[earch]	rec[over]	u[ndo]	nunmenu
syn keyword vimCommand contained	cmap	isp[lit]	red[o]	una[bbreviate]	ome
syn keyword vimCommand contained	cmapc[lear]	iu[nmap]	redi[r]	unh[ide]	omenu
syn keyword vimCommand contained	cn[ext]	iuna[bbrev]	reg[isters]	unl[et]	onoreme
syn keyword vimCommand contained	cno[remap]	j[oin]	res[ize]	unm[ap]	onoremenu
syn keyword vimCommand contained	cnorea[bbrev]	ju[mps]	resize	v[global]	ounme
syn keyword vimCommand contained	co[py]	k	ret[ab]	ve[rsion]	ounmenu
syn keyword vimCommand contained	con[tinue]	l[ist]	rew[ind]	vi[sual]	unme
syn keyword vimCommand contained	conf[irm]	la[st]	ri[ght]	vie[w]	unmenu
syn keyword vimCommand contained	cp[revious]	le[ft]	rv[iminfo]	vm[ap]	vme
syn keyword vimCommand contained	cq	let	sN[ext]	vmap	vmenu
syn keyword vimCommand contained	cq[uit]	ls	s[ubstitute]	vmapc[lear]	vnoreme
syn keyword vimCommand contained	crewind	m[ove]	sa[rgument]	vn[oremap]	vnoremenu
syn keyword vimCommand contained	cu[nmap]	ma[rk]	sal[l]	vu[nmap]	vunme
syn keyword vimCommand contained	cuna[bbrev]	mak[e]	sbN[ext]	wN[ext]	vunmenu

" All vimCommands are contained by vimIsCommands.
syn match vimIsCommand	"^\s*[a-zA-Z]\+"		transparent contains=vimCommand
syn match vimIsCommand	"[:|]\s*[a-zA-Z]\+"	transparent contains=vimCommand

" vimOptions are caught only when contained in a vimSet
syn keyword vimOption contained	ai	equalalways	isprint	sb	tagrelative
syn keyword vimOption contained	akm	equalprg	joinspaces	sbr	tags
syn keyword vimOption contained	al	errorbells	js	sc	tbi
syn keyword vimOption contained	aleph	errorfile	keywordprg	scr	tbs
syn keyword vimOption contained	altkeymap	errorformat	kp	scroll	term
syn keyword vimOption contained	autoindent	esckeys	langmap	scrolljump	terse
syn keyword vimOption contained	autowrite	et	laststatus	scrolloff	textauto
syn keyword vimOption contained	aw	eventignore	lazyredraw	scs	textmode
syn keyword vimOption contained	background	ex	lbr	sect	textwidth
syn keyword vimOption contained	backspace	expandtab	linebreak	sections	tf
syn keyword vimOption contained	backup	exrc	lines	secure	tildeop
syn keyword vimOption contained	backupdir	ff	lisp	sft	timeout
syn keyword vimOption contained	backupext	ffs	list	sh	timeoutlen
syn keyword vimOption contained	bdir	fileformat	lmap	shcf	title
syn keyword vimOption contained	bex	fileformats	ls	shell	titlelen
syn keyword vimOption contained	bg	fk	lz	shellcmdflag	titlestring
syn keyword vimOption contained	bin	fkmap	magic	shellpipe	tl
syn keyword vimOption contained	binary	fo	makeef	shellquote	tm
syn keyword vimOption contained	biosk	formatoptions	makeprg	shellredir	to
syn keyword vimOption contained	bioskey	formatprg	mat	shelltype	top
syn keyword vimOption contained	bk	fp	matchtime	shellxquote	tr
syn keyword vimOption contained	breakat	gcr	maxmapdepth	shiftround	ts
syn keyword vimOption contained	brk	gd	maxmem	shiftwidth	tsl
syn keyword vimOption contained	bs	gdefault	maxmemtot	shm	ttimeout
syn keyword vimOption contained	cf	gfn	mef	shortmess	ttimeoutlen
syn keyword vimOption contained	ch	go	mh	shortname	ttm
syn keyword vimOption contained	cin	guicursor	ml	showbreak	ttybuiltin
syn keyword vimOption contained	cindent	guifont	mls	showcmd	ttyfast
syn keyword vimOption contained	cink	guioptions	mm	showfulltag	ttyscroll
syn keyword vimOption contained	cinkeys	guipty	mmd	showmatch	ttytype
syn keyword vimOption contained	cino	helpfile	mmt	showmode	tw
syn keyword vimOption contained	cinoptions	helpheight	mod	shq	tx
syn keyword vimOption contained	cinw	hf	modeline	si	uc
syn keyword vimOption contained	cinwords	hh	modelines	sidescroll	ul
syn keyword vimOption contained	cmdheight	hi	modified	sj	undolevels
syn keyword vimOption contained	co	hid	more	sm	updatecount
syn keyword vimOption contained	columns	hidden	mouse	smartcase	updatetime
syn keyword vimOption contained	com	highlight	mousehide	smartindent	ut
syn keyword vimOption contained	comments	history	mouset	smarttab	vb
syn keyword vimOption contained	compatible	hk	mousetime	smd	vbs
syn keyword vimOption contained	complete	hkmap	mp	sn	verbose
syn keyword vimOption contained	confirm	hkmapp	nf	so	vi
syn keyword vimOption contained	cp	hkp	nrformats	softtabstop	viminfo
syn keyword vimOption contained	cpo	hl	nu	sol	visualbell
syn keyword vimOption contained	cpoptions	hls	number	sp	wa
syn keyword vimOption contained	cpt	hlsearch	pa	splitbelow	warn
syn keyword vimOption contained	def	ic	para	sr	wb
syn keyword vimOption contained	define	icon	paragraphs	srr	wc
syn keyword vimOption contained	dg	iconstring	paste	ss	wd
syn keyword vimOption contained	dict	ignorecase	patchmode	st	weirdinvert
syn keyword vimOption contained	dictionary	im	path	sta	wh
syn keyword vimOption contained	digraph	inc	pm	startofline	whichwrap
syn keyword vimOption contained	dir	include	readonly	sts	wildchar
syn keyword vimOption contained	directory	incsearch	remap	su	winheight
syn keyword vimOption contained	ea	inf	report	suffixes	wiv
syn keyword vimOption contained	eb	infercase	restorescreen	sw	wm
syn keyword vimOption contained	ed	insertmode	revins	swapsync	wrap
syn keyword vimOption contained	edcompatible	is	ri	sws	wrapmargin
syn keyword vimOption contained	ef	isf	rightleft	sxq	wrapscan
syn keyword vimOption contained	efm	isfname	rl	ta	writeany
syn keyword vimOption contained	ei	isi	ro	tabstop	writebackup
syn keyword vimOption contained	ek	isident	rs	tag	writedelay
syn keyword vimOption contained	endofline	isk	ru	tagbsearch	ws
syn keyword vimOption contained	eol	iskeyword	ruler	taglength	ww
syn keyword vimOption contained	ep	isp

" These are the turn-off setting variants
syn keyword vimOption contained	noai	noesckeys	nojoinspaces	noruler	noterse
syn keyword vimOption contained	noakm	noet	nojs	nosb	notextauto
syn keyword vimOption contained	noalkeymap	noex	nolbr	nosc	notextmode
syn keyword vimOption contained	noautoindent	noexpandtab	nolinebreak	noscs	notf
syn keyword vimOption contained	noautowrite	noexrc	nolisp	nosecure	notildeop
syn keyword vimOption contained	noaw	nofk	nolist	noshiftround	notimeout
syn keyword vimOption contained	nobackup	nofkmap	nomagic	noshortname	notitle
syn keyword vimOption contained	nobin	nogd	nomh	noshowcmd	noto
syn keyword vimOption contained	nobinary	nogdefault	noml	noshowmatch	notop
syn keyword vimOption contained	nobiosk	noguipty	nomod	noshowmode	notr
syn keyword vimOption contained	nobioskey	nohid	nomodeline	nosi	nottimeout
syn keyword vimOption contained	nobk	nohidden	nomodified	nosm	nottybuiltin
syn keyword vimOption contained	nocin	nohk	nomore	nosmartcase	nottyfast
syn keyword vimOption contained	nocindent	nohkmap	nomousehide	nosmartindent	notx
syn keyword vimOption contained	nocompatible	nohkmapp	nonu	nosmarttab	novb
syn keyword vimOption contained	nocp	nohkp	nonumber	nosmd	novisualbell
syn keyword vimOption contained	nodg	nohls	nopaste	nosn	nowa
syn keyword vimOption contained	nodigraph	nohlsearch	noreadonly	nosol	nowarn
syn keyword vimOption contained	noea	noic	noremap	nosplitbelow	nowb
syn keyword vimOption contained	noeb	noicon	norestorescreen	nosr	noweirdinvert
syn keyword vimOption contained	noed	noignorecase	norevins	nosta	nowiv
syn keyword vimOption contained	noedcompatible	noim	nori	nostartofline	nowrap
syn keyword vimOption contained	noek	noincsearch	norightleft	nota	nowrapscan
syn keyword vimOption contained	noendofline	noinf	norl	notagbsearch	nowriteany
syn keyword vimOption contained	noeol	noinfercase	noro	notagrelative	nowritebackup
syn keyword vimOption contained	noequalalways	noinsertmode	nors	notbi	nows
syn keyword vimOption contained	noerrorbells	nois	noru	notbs

" termcap codes (which can also be set)
syn keyword vimOption contained	t_AB	t_RI	t_da	t_k9	t_ks	t_so
syn keyword vimOption contained	t_AF	t_Sb	t_db	t_kD	t_ku	t_sr
syn keyword vimOption contained	t_AL	t_Sf	t_dl	t_kI	t_le	t_te
syn keyword vimOption contained	t_CS	t_ZH	t_k1	t_kN	t_mb	t_ti
syn keyword vimOption contained	t_Co	t_ZR	t_k2	t_kP	t_md	t_ue
syn keyword vimOption contained	t_DL	t_al	t_k3	t_kb	t_me	t_us
syn keyword vimOption contained	t_F1	t_bc	t_k4	t_kd	t_mr	t_vb
syn keyword vimOption contained	t_F2	t_cd	t_k5	t_ke	t_ms	t_ve
syn keyword vimOption contained	t_K1	t_ce	t_k6	t_kh	t_nd	t_vi
syn keyword vimOption contained	t_K3	t_cl	t_k7	t_kl	t_op	t_vs
syn keyword vimOption contained	t_K4	t_cm	t_k8	t_kr	t_se	t_xs
syn keyword vimOption contained	t_K5	t_cs
syn match   vimOption contained	"t_#4"
syn match   vimOption contained	"t_%1"
syn match   vimOption contained	"t_%i"
syn match   vimOption contained	"t_&8"
syn match   vimOption contained	"t_@7"
syn match   vimOption contained	"t_k;"

" these settings don't actually cause errors in vim, but were supported by vi and don't do anything in vim
syn keyword vimErrSetting contained	ap	gr	op	slow	w1200
syn keyword vimErrSetting contained	autoprint	graphic	open	slowopen	w300
syn keyword vimErrSetting contained	beautify	hardtabs	optimize	sourceany	w9600
syn keyword vimErrSetting contained	bf	ht	prompt	tagstack	wi
syn keyword vimErrSetting contained	fl	mesg	redraw	tgst	window
syn keyword vimErrSetting contained	flash	novice

" AutoBuf Events
syn keyword vimAutoEvent contained	BufDelete	BufReadPre	FileAppendPre	FilterReadPost	TermChanged
syn keyword vimAutoEvent contained	BufEnter	BufUnload	FileChangedShell	FilterReadPre	User
syn keyword vimAutoEvent contained	BufLeave	BufWrite	FileReadPost	FilterWritePost	VimEnter
syn keyword vimAutoEvent contained	BufNewFile	BufWritePost	FileReadPre	FilterWritePre	VimLeave
syn keyword vimAutoEvent contained	BufRead	BufWritePre	FileWritePost	StdinReadPost	WinEnter
syn keyword vimAutoEvent contained	BufReadPost	FileAppendPost	FileWritePre	StdinReadPre	WinLeave

" Highlight commonly used Groupnames
syn keyword vimGroup	Comment	Identifier	Keyword	Type	Tag
syn keyword vimGroup	Constant	Function	Exception	StorageClass	Delimiter
syn keyword vimGroup	String	Statement	PreProc	Structure	SpecialComment
syn keyword vimGroup	Character	Conditional	Include	Typedef	Debug
syn keyword vimGroup	Number	Repeat	Define	Special	Error
syn keyword vimGroup	Boolean	Label	Macro	SpecialChar	Todo
syn keyword vimGroup	Float	Operator	PreCondit

" Default highlighting groups
syn keyword vimHLGroup	Cursor	LineNr	MoreMsg	Question	SpecialKey	Title
syn keyword vimHLGroup	Directory	Menu	NonText	Scrollbar	StatusLine	Visual
syn keyword vimHLGroup	ErrorMsg	ModeMsg	Normal	Search	StatusLineNC	WarningMsg
syn keyword vimHLGroup	IncSearch

"--- syntax above generated by mkvimvim ---
" Highlight syntax stuff

syn keyword vimPattern contained	start	skip	end

syn keyword vimSpecial	ALL	ccomment	matchgroup	skipempty	sync
syn keyword vimSpecial	NONE	lines	minlines	skipnl	transparent

" Highlight syntax stuff -- the following vimSpecials aren't keywords because Vim's syntax checking
" disapproves
syn match vimSpecial	contained	"\<ALLBUT\>"
syn match vimSpecial	contained	"\<clear\>"
syn match vimSpecial	contained	"\<contained\>"
syn match vimSpecial	contained	"\<oneline\>"
syn match vimSpecial	contained	"\<contains\>"
syn match vimSpecial	contained	"\<grouphere\>"
syn match vimSpecial	contained	"\<groupthere\>"
syn match vimSpecial	contained	"\<keepend\>"
syn match vimSpecial	contained	"\<maxlines\>"
syn match vimSpecial	contained	"\<nextgroup\>"
syn match vimSpecial	contained	"\<skipempty\>"
syn match vimSpecial	contained	"\<skipnl\>"
syn match vimSpecial	contained	"\<skipwhite\>"
syn match vimSpecial	contained	"\<transparent\>"

" Highlight Terminal Stuff
syn keyword vimTermSet  contained	background	cterm	ctermfg	font	gui	guifg
syn keyword vimTermSet  contained	bg	ctermbg	fg	foreground	guibg	term	start
syn match   vimTermSet  contained	"stop"

" Special Filenames and Modifiers
syn match vimSpecFile	"<\(cword\|cWORD\|[cas]file\)>"	nextgroup=vimSpecFileMod
syn match vimSpecFile	"#[0-9]\|[#%]"		nextgroup=vimSpecFileMod
syn match vimSpecFileMod	"\(:[phtre]\)\+"		contained

" Commands, function, and conditionals
syn keyword vimFunction	buffer_exists exists expand file_readable getline has highlight_exists last_buffer_nr ret strftime strlen substr

syn match vimConditional	"^\s*\(continue\|con\)\>"
syn match vimConditional	"^\s*\(endif\|en\)\>"
syn match vimConditional	"^\s*\(endwhile\|endw\)\>"
syn match vimConditional	"^\s*\(while\|wh\)\>"
syn match vimConditional	"^\s*break\=\>"
syn match vimConditional	"^\s*else\>"
syn match vimConditional	"^\s*elseif\=\>"
syn match vimConditional	"^\s*if\>"

" Operators
syn match vimOper	"||\|&&\|!=\|>=\|<=\|=\~\|!\~\|>\|<\|+\|-\|=\|\." skipwhite nextgroup=vimString

" Numbers
syn match vimNumber	"\<[0-9]\+.[0-9]\+"
syn match vimNumber	"\<[0-9]\+L\="
syn match vimNumber	"-[0-9]\+.[0-9]\+"
syn match vimNumber	"-[0-9]\+L\="
syn match vimNumber	"[[;:][0-9]\+"lc=1
syn match vimNumber	"0[xX][0-9a-fA-F]\+"
syn match vimNumber	"#[0-9a-fA-F]\+"

" Lower Priority Comments: after some vim commands...
syn match vimComment	+\s"[^\-:.%#=*].*$+lc=1	contains=vimTodo
syn match vimComment	+\<endif\s\+".*$+lc=5	contains=vimTodo
syn match vimComment	+\<else\s\+".*$+lc=4	contains=vimTodo
syn match vimComment	+^\s*".*$+		contains=vimTodo

" Try to catch strings, if nothing else matches (therefore it must precede the others!)
"  vmEscapeBrace handles ["]  []"] (ie. stays as string)
syn region	vimEscapeBrace	start="[^\\]\(\\\\\)*\[\^\=\]\=" skip="\\\\\|\\\]" end="\]"me=e-1	oneline contained transparent
syn match	vimPatSep	"\\[|()]"hs=e-1	contained
syn match	vimNotPatSep	"\\\\"	contained
syn region	vimString	start=+[^:a-zA-Z>!\\]"+lc=1 skip=+\\\\\|\\"+ end=+"+ oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	start=+[^:a-zA-Z>!\\]'+lc=1 skip=+\\\\\|\\'+ end=+'+ oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	start=+=!+lc=1	skip=+\\\\\|\\!+ end=+!+	oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	start="=+"lc=1	skip="\\\\\|\\+" end="+"	oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	start="[^\\]+\s*[^a-zA-Z0-9.]"lc=1 skip="\\\\\|\\+" end="+"	oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	start="\s/\s*[^a-zA-Z]"lc=1 skip="\\\\\|\\+" end="/"	oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep

" Substitutions
syn region	vimSubst	start=":\=s/.\{-}" skip="\(\\\\\)*\\/" end="/"	oneline contains=vimPatSep,vimSubstTwoBS,vimSubstRange,vimNotation nextgroup=vimSubstEnd
syn region	vimSubstEnd	start="."lc=1	skip="\(\\\\\)*\\/"   end="/"	oneline contained contains=vimSubstPat,vimSubstTwoBS,vimNotation
syn region	vimSubstRange	start="\["	skip="\(\\\\\)*\\]"   end="]"	oneline contained
syn match	vimSubstPat	"\\[0-9]"			contained
syn match	vimSubstTwoBS	"\\\\"			contained

" Marks, Registers, Addresses, Filters
syn match	vimMark	"[!,:]'[a-zA-Z0-9]"lc=1
syn match	vimMark	"'[a-zA-Z0-9][,!]"me=e-1
syn match	vimMark	"[^a-zA-Z]norm\s'[a-zA-Z0-9]"lc=6
syn match	vimMark	"[^a-zA-Z]normal\s'[a-zA-Z0-9]"lc=8
syn match	vimPlainMark	"'[a-zA-Z0-9]"		contained

syn match	vimRegister	'[^(,;]"[a-zA-Z0-9\-:.%#*=][^a-zA-Z_"]'lc=1
syn match	vimRegister	'[^a-zA-Z]norm\s"[a-zA-Z0-9]'lc=6
syn match	vimRegister	'[^a-zA-Z]normal\s"[a-zA-Z0-9]'lc=8
syn match	vimPlainRegister	'"[a-zA-Z0-9\-:.%#*=]'	contained

syn match	vimAddress	",\."lc=1
syn match   	vimAddress	"[:|][%.]"lc=1
syn match   	vimAddress	"<Bar>%"lc=5

syn match	vimFilter	":\s*!"ms=e
syn match	vimFilter	"[^a-zA-Z]!"lc=1

" Complex repeats
syn match vimCmplxRepeat	'[^a-zA-Z_]q[0-9a-zA-Z"]'lc=1
syn match vimCmplxRepeat	'@[0-9a-z".=@:]'

" High Priority Comments: beginning of line with optional spaces then "
syn match vimComment	+^\s*".*$+	contains=vimTodo

" Set command and associated set-options (vimOptions) with comment
syn region vimSet matchgroup=vimCommand start="\s*set\>" end="|\|$"	keepend contains=vimSetEqual,vimOption,vimErrSetting,vimComment,vimSetString
syn region vimSetEqual  contained	start="="	skip="\(\\\\\)*\\\s" end="[| \t]\|$"me=e-1 contains=vimCtrlChar
syn region vimSetString contained	start=+="+hs=s+1	skip=+\(\\\\\)\\"+   end=+"+	contains=vimCtrlChar

" Highlight modifiers
syn keyword VimHLMod contained NONE bold inverse italic reverse standout underline

" Autocmd
syn match  vimIsCommand2 "[ \t<Bar>][a-zA-Z_]\+"lc=1 transparent contained contains=vimCommand
syn region vimAutoCmd matchgroup=vimAutoSet start=+^\s*\(autocmd\|au\)\>+	end="$" keepend contains=vimAutoEvent,vimSet,vimIsCommand,vimIsCommand2,vimString,vimComment,vimSpecFile,vimNotation,vimFilter,vimAuSynLine,vimAuRegion
syn region vimAutoCmd matchgroup=vimAutoSet start=+^\s*\(doautoa\|doautoall\)\>+	end="$" keepend contains=vimAutoEvent,vimSet,vimIsCommand,vimIsCommand2,vimString,vimComment,vimSpecFile,vimNotation,vimFilter,vimAuSynLine,vimAuRegion

" Syntax regions (all oneliners)
syn keyword vimKeyword link match		contained
syn keyword vimCase    ignore match	contained
syn keyword vimSynGroup add remove	contained
syn match   vimSynGroup "contains"	contained
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(highlight\|hi\)\s"	end="$"	keepend contains=vimKeyword,vimSpecial,vimGroup,vimTermSet,vimComment,vimCtrlChar,VimRegion,vimNotation,vimNumber,vimHLMod,vimOption,vimHLGroup
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+case"	end="$"	keepend contains=vimCase,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+clear"rs=e-5 end="$"	keepend contains=vimSpecial,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+cluster"	end="$"	keepend contains=vimSynGroup,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+group"	end="$"	keepend contains=vimSynGroup,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+match"	end="$"	keepend contains=vimKeyword,vimSpecial,vimString,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+region"	end="$"	keepend contains=vimKeyword,vimSpecial,vimString,vimPattern,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+sync"	end="$"	keepend contains=vimKeyword,vimSpecial,vimString,vimComment
syn region vimSynLine matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+keyword"	end="$"	keepend contains=vimKeyword,vimSpecial,vimComment

syn region vimAuSynLine matchgroup=vimKeyword start="\s\(syntax\|syn\)\s\+keyword"lc=1 end="$"	keepend contains=vimKeyword,vimSpecial,vimComment contained
syn region vimAuRegion  matchgroup=vimKeyword start="\s\(syntax\|syn\)\s\+region"lc=1  end="$"	keepend contains=vimKeyword,vimSpecial,vimString,vimPattern,vimComment contained
syn region vimAuRegion  matchgroup=vimKeyword start="\s\(syntax\|syn\)\s\+match"lc=1	end="$"	keepend contains=vimKeyword,vimSpecial,vimString,vimComment contained
syn region vimAuRegion  matchgroup=vimKeyword start="\s\(syntax\|syn\)\s\+clear"rs=e-5 end="$"	keepend contains=vimSpecial,vimComment contained
syn region vimAuRegion  matchgroup=vimKeyword start="\s\(syntax\|syn\)\s\+case"lc=1 end="$"	keepend contains=vimCase,vimComment contained
syn region vimAuRegion  matchgroup=vimKeyword start="\s\(syntax\|syn\)\s\+sync"lc=1 end="$"	keepend contains=vimKeyword,vimSpecial,vimString,vimComment contained
syn region vimAuRegion  matchgroup=vimKeyword start="\s\(highlight\|hi\)\s"lc=1 end="$"	keepend contains=vimKeyword,vimSpecial,vimGroup,vimTermSet,vimComment,vimCtrlChar,VimRegion,vimNotation,vimNumber,vimHLMod,vimOption,vimHLGroup contained

" Angle-Bracket Notation
syn match vimNotation	"<[a-zA-Z][a-zA-Z0-9]\+>"		contains=vimBracket
syn match vimNotation	"<C-[A-Z]>"			contains=vimBracket
syn match vimNotation	"<[AM]-.>"			contains=vimBracket
syn match vimNotation	"<[SCAM]-\(Right\|Left\|Down\|Up\)>"	contains=vimBracket
syn match vimNotation	"<S-F[0-9]>"			contains=vimBracket
syn match vimNotation	'<C-R>[0-9a-z"%#:.\-=]'he=e-1		contains=vimBracket
syn match vimNotation	"<CR>"			contains=vimBracket nextgroup=vimPlainMark,vimPlainRegister,vimAddress
syn match vimNotation	"<Esc>"			contains=vimBracket nextgroup=vimPlainMark,vimPlainRegister,vimAddress
syn match vimBracket contained	"[<>]"

" Control Characters
syn match vimCtrlChar	"[--]"

if !exists("did_vim_syntax_inits")
  let did_vim_syntax_inits = 1
  " The default methods for highlighting.  Can be overridden later
  hi link vimAddress	vimMark
  hi link vimAutoSet	vimCommand
  hi link vimConditional	vimStatement
  hi link vimFilter	vimOper
  hi link vimHLGroup	vimGroup
  hi link vimNotPatSep	vimString
  hi link vimPlainMark	vimMark
  hi link vimPlainRegister	vimRegister
  hi link vimSetString	vimString
  hi link vimSpecFileMod	vimSpecFile
  hi link vimSynGroup	vimSpecial
  hi link vimTerminal	vimGroup

  hi link vimAutoEvent	Type
  hi link vimBracket	Delimiter
  hi link vimCmplxRepeat	SpecialChar
  hi link vimCommand	Statement
  hi link vimComment	Comment
  hi link vimCtrlChar	SpecialChar
  hi link vimErrSetting	Error
  hi link vimFunction	Function
  hi link vimGroup	Type
  hi link vimHLMod	PreProc
  hi link vimKeyword	Statement
  hi link vimMark	Number
  hi link vimNotation	Special
  hi link vimNumber	Number
  hi link vimOper	Operator
  hi link vimOption	PreProc
  hi link vimPatSep	SpecialChar
  hi link vimPattern	Type
  hi link vimRegister	SpecialChar
  hi link vimSpecFile	Identifier
  hi link vimSpecial	Type
  hi link vimStatement	Statement
  hi link vimString	String
  hi link vimSubstPat	SpecialChar
  hi link vimTermSet	StorageClass
  hi link vimTodo	Todo
endif

let b:current_syntax = "vim"

" vim: ts=17
