


CTAGS(1)                                                 CTAGS(1)


NAME
       ctags - Generate C and C++ language tag files for use with
       vi(1)



SYNOPSIS
       ctags [-aBeFnNRux] [-f tagfile] [-h list] [-i  types]  [-I
             ignorelist]  [-L  listfile]  [-p  path] [-o tagfile]
             [--append] [--excmd=m|n|p] [--format=level] [--help]
             [--if0]    [--lang=c|c++|java]    [--langmap=map(s)]
             [--recurse]    [--sort]    [--totals]    [--version]
             [file(s)]


       etags [-aRx]   [-f  tagfile]  [-h  list]  [-i  types]  [-I
             ignorelist] [-L listfile]  [-p  path]  [-o  tagfile]
             [--append]   [--help]   [--if0]  [--lang=c|c++|java]
             [--langmap=map(s)]  [--recurse]  [--totals]  [--ver-
             sion] [file(s)]



DESCRIPTION
       The  ctags  and  etags  programs (hereinafter collectively
       referred to as ctags, except where distinguished) generate
       an  index  (or  "tag")  file  for C, C++ and Java language
       objects found in file(s) that allows  these  items  to  be
       quickly and easily located by a text editor or other util-
       ity. A "tag" signifies a C language object  for  which  an
       index  entry  is  available  (or, alternatively, the index
       entry created for that object).

       Alternatively, ctags can generate a cross  reference  file
       which lists, in human readable form, information about the
       various objects found in a set of C or C++ language files.

       Tag  index files are supported by the vi(1) editor and its
       derivatives (such as vim, elvis, stevie, and xvi), and  by
       the  emacs  editor  (see  the  HOW  TO  USE WITH sections,
       below), all of which allow the user to locate  the  object
       associated with a name appearing in a source file and jump
       to the file and line which defines the name.

       The following types of tags are supported by  ctags  (some
       are optional):

           macro definitions (names created by #define)
           enumerators (values inside an enumeration)
           function (method) definitions
           class, enum, struct, and union names
           interface names (Java)
           namespace names (C++)
           typedefs



Darren Hiebert            Version 2.2.6                         1





CTAGS(1)                                                 CTAGS(1)


           variables (definitions and extern declarations)
           function prototypes and declarations
           data members

       Ctags  only  generates  tags for objects which have global
       scoping (file-wide visibility). This means that, with  the
       exception  of macro definitions, only objects defined out-
       side of brace enclosed function blocks are candidates  for
       a tag.



SOURCE FILES
       Unless  the  --lang  option  is specified, the language of
       each source file is automatically selected based upon  its
       file  extension,  according  to the following default map-
       ping.

           C       *.c
           C++     *.C, *.c++, *.cc, *.cpp, *.cxx  and  any  file
                   considered  a  header file according to the -h
                   option.
           Java    *.java

       All other files extensions are ignored. This permits  run-
       ning ctags on all files in either a single directory (e.g.
       "ctags *"), or all files in  an  entire  source  directory
       tree  (e.g.  "ctags  -R"),  since  only  those files whose
       extensions are  known  to  ctags  will  be  scanned.  This
       default  mapping of file extensions to source language may
       be changed by using the --langmap option. Automatic selec-
       tion  of  the source language may be disabled by using the
       --lang option.



OPTIONS
       Despite the wealth of available options, defaults are  set
       so  that  ctags  is  most  commonly  executed  without any
       options (e.g. "ctags *"), which will create a tag file  in
       the current directory for the specified files. The options
       described below are provided merely to allow  custom  tai-
       loring to meet special needs.

       Note that spaces separating the single-letter options from
       their parameters are optional.

       Note also that the boolean parameters  to  the  long  form
       options  (those  beginning  with  "--"  and  that  take  a
       "=yes|no" parameter) may be omitted, in which case  "=yes"
       is implied. (e.g. --sort is equivalent to --sort=yes).


       -a   Append  the  tags to an existing tag file. Equivalent



Darren Hiebert            Version 2.2.6                         2





CTAGS(1)                                                 CTAGS(1)


            to --append.


       -B   Use backward searching patterns (e.g. ?regexp?).


       -e   Output tag file for use with Emacs. If  this  program
            is  executed by the name etags, this option is set by
            default. Selecting this option causes  the  following
            options  to be ignored: -BFnNsuwW, --excmd, --format,
            --sort.


       -f tagfile
            Use the name specified by tagfile for  the  tag  file
            (default  is  "tags",  or  "TAGS"  when  using the -e
            option). If tagfile is specified as "-", then the tag
            file  is  written  to  standard output instead. Ctags
            will stubbornly refuse  to  take  orders  if  tagfile
            exists  and  its  first line contains something other
            than a valid tags line. This will save your  neck  if
            you  mistakenly type "ctags -f *.c", which would oth-
            erwise overwrite your first C file with the tags gen-
            erated by the rest!


       -F   Use   forward   searching  patterns  (e.g.  /regexp/)
            (default).


       -h list
            Specifies a list of file extensions used for headers,
            separated  by  periods.   This option affects how the
            scoping of tag types is interpreted (i.e. whether  or
            not  they  are  considered  as static). All tag types
            other than functions (methods) and variables are con-
            sidered  static when they appear in a non-header file
            (since they cannot be seen outside of that file)  and
            non-static  when  they appear in a header file (since
            they can be seen in other files wherever that  header
            file is included). See also the S modifier of the  -i
            option. The default list is ".h.H.hh.hpp.hxx.h++".


       -i types
            Specifies the list of tag types  to  include  in  the
            output  file.   Types  is a group of one-letter flags
            designating the types of tags affected.  Each  letter
            or  group  of letters may be preceded by either a '+'
            sign (default, if omitted) to add it to those already
            included,  a  '-'  sign  to  exclude it from the list
            (e.g. to exclude a default tag type), or an '='  sign
            to  include  its corresponding tag type at the exclu-
            sion of those not  listed.  Tags  for  the  following



Darren Hiebert            Version 2.2.6                         3





CTAGS(1)                                                 CTAGS(1)


            language  contructs  are  supported (default settings
            are on except as noted):

               c   class names
               d   macro definitions
               e   enumerators
               f   function (or method) definitions
               g   enumeration names
               i   interface names (Java only)
               m   data members [off]
               i   namespace names (C++ only)
               p   function prototypes and declarations [off]
               s   structure names
               t   typedefs
               u   union names
               v   variable definitions
               x   extern variable declarations [off]

            In addition to the above flags,  the  following  one-
            letter modifiers are accepted:

               C   For  C++  and  Java,  include an extra, class-
                   qualified tag  entry  for  each  class  member
                   (function/method   and   data)   in  the  form
                   "class::member"   (C++)   or    "class.member"
                   (Java).  This  allows locating class-qualified
                   tags (e.g.  ":tag  class::member"  in  vi(1)).
                   This is disabled by default because this could
                   potentially more than double the size  of  the
                   tag file.
               F   Include  tags  for the basename of each source
                   file. This permits jumping to a  file  by  its
                   name  (e.g.  ":tag  file.c" in vi(1)). This is
                   disabled by default.
               S   Include static tags (those not visible outside
                   of  a single source file).  Function and vari-
                   able definitions are  considered  static  only
                   when  their  definitions are preceded with the
                   "static" keyword. All other types of tags  are
                   considered  static  when they appear in a non-
                   header file, and non-static when  they  appear
                   in a header file. See also the -h option. This
                   is enabled by default.


            The default value for types is "=cdefgintuvCS".


       -I ignorelist
            Reads a list of names which are to be  ignored  while
            generating tags for the source files. The list may be
            supplied directly on the command line or found  in  a
            separate  file. Normally, the parameter ignorelist is
            a list of names to be ignored, each separated with  a



Darren Hiebert            Version 2.2.6                         4





CTAGS(1)                                                 CTAGS(1)


            comma, a semicolon, or white space (in which case the
            list should be quoted to keep the entire list as  one
            command line argument). The parameter ignorelist will
            be interpreted as a filename if its  first  character
            is given as either a '.' or a pathname separator ('/'
            or '\'). In order to specify a file found in the cur-
            rent directory, use "./filename".

            This  feature  is useful when preprocessor macros are
            used in such a way that they cause  syntactic  confu-
            sion due to their presence. Some examples will illus-
            trate this point.

              /* creates a global version  string  in  module  */
              MODULE_VERSION("$Revision: 6.9 $")

            In  this  example, the macro invocation looks to much
            like a function definition because it is not followed
            by  a semicolon (indeed, it could even be followed by
            a global variable definition that would look  exactly
            like  a K&R style function parameter declaration). In
            fact, this seeming function definition  would  likely
            cause  the  rest of the file to be skipped over while
            trying to complete  the  definition.  Ignoring  "MOD-
            ULE_ID" would avoid such a problem.

              int foo ARGDECL2(void *, ptr, long int, nbytes)

            In  this  example, the macro "ARGDECL2" would be mis-
            takenly interpreted to be the name  of  the  function
            instead  of  the  correct name of "foo". Ignoring the
            name "ARGDECL2" results in the correct behavior.


       -L listfile
            Read from listfile a list of  file  names  for  which
            tags should be generated. If listfile is specified as
            "-", then file names are read from standard input.


       -n   Equivalent to --excmd=number.


       -N   Equivalent to --excmd=pattern.


       -o tagfile
            Alternative for -f.


       -p path
            Use path as the default directory for  each  supplied
            source  file (whether supplied on the command line or
            in a file specified with the -L option),  unless  the



Darren Hiebert            Version 2.2.6                         5





CTAGS(1)                                                 CTAGS(1)


            source file is already specified as an absolute path.
            The supplied path is merely  prepended  to  the  each
            non-absolute  source  file name, adding any necessary
            path separator.


       -R   Equivalent to --recurse=yes.


       -u   Equivalent to --sort=no.


       -x   Print  a  tabular,  human-readable  cross   reference
            (xref)  file to standard output instead of generating
            a tag file. The information contained in  the  output
            includes:  the  tag  name;  the kind of tag; the line
            number, file name, and source line (with extra  white
            space  condensed)  of the file which defines the tag.
            No tag file is written and the following options will
            be  ignored: -aBefFno, and -i+P. Example applications
            for this feature are  generating  a  listing  of  all
            functions  (including  statics)  located  in a source
            file (e.g. ctags -xi=fS file), or generating  a  list
            of all externally visible global variables located in
            a source file (e.g. ctags -xi=v file).


       --append=yes|no
            Indicates whether tags generated from  the  specified
            files  should be appended to those already present in
            the tag file or should replace them. If the parameter
            is  omitted,  =yes  is implied. This option is off by
            default.


       --excmd=type
            Determines the type of EX command used to locate tags
            in  the  source  file.  The valid values for type are
            (either the  entire  word  or  the  first  letter  is
            accepted):

            number   Places into the tag file line numbers in the
                     source file where tags  are  located  rather
                     than  patterns  to be searched for. This has
                     three advantages:
                     1.  Significantly reduces the  size  of  the
                         resulting tag file.
                     2.  Eliminates failures to find tags because
                         the line defining the tag  has  changed,
                         causing  the pattern match to fail (note
                         that some editors, such as vim, are able
                         to recover in many such instances).
                     3.  Eliminates  finding  identical matching,
                         but incorrect, source lines  (see  BUGS,



Darren Hiebert            Version 2.2.6                         6





CTAGS(1)                                                 CTAGS(1)


                         below).
                     However,  this  option  has  one significant
                     drawback: changes to the  source  files  can
                     cause  the  line numbers recorded in the tag
                     file to no longer correspond to the lines in
                     the  source file, causing jumps to some tags
                     to miss the target definition by one or more
                     lines.  Basically,  this option is best used
                     when the source code to which it is  applied
                     is  not  subject  to  change. Selecting this
                     option type causes the following options  to
                     be ignored: -BF.

            pattern  Uses EX search patterns for all tags, rather
                     than the line numbers usually used for macro
                     definitions.  This  has the advantage of not
                     referencing obsolete line numbers when lines
                     have  been  added  or  removed since the tag
                     file was generated.

            mixed    Uses line numbers for macro definition  tags
                     and EX patterns for everything else. This is
                     the default format generated by the original
                     ctags  and  is,  therefore,  retained as the
                     default for this option.


       --format=level
            Change the format of the output tag  file.  Currently
            the  only  valid values for level are 1 or 2. Level 1
            specifies the original tag file format  and  level  2
            specifies  a new extended format containing extension
            flags (but in a manner which retains backward compat-
            ibility  with  original  vi(1)  implementations). The
            default level is 2.


       --help
            Prints to standard output a detailed  usage  descrip-
            tion.


       --if0=yes|no
            Indicates  a  preference as to whether code within an
            "#if 0" branch of a preprocessor  conditional  should
            be examined for non-macro tags (macro tags are always
            included). Because the intent of this construct is to
            disable  code,  the  default value of this options is
            no. Note that this indicates a  preference  only  and
            does  not  guarantee  skipping code within an "#if 0"
            branch, since the fall-back algorithm used to  gener-
            ate  tags when preprocessor conditionals are too com-
            plex follows all branches of a  conditional.  If  the
            parameter is omitted, =yes is implied. This option is



Darren Hiebert            Version 2.2.6                         7





CTAGS(1)                                                 CTAGS(1)


            off by default.


       --lang=c|c++|java
            By default, ctags automatically selects the  language
            of  a  source  file according to its file name exten-
            sion,  ignoring  those  files  whose  extensions  are
            unknown  to  ctags.  This option forces the specified
            language to be used for every supplied file,  instead
            of keying off of their extensions.


       --langmap=map(s)
            Overrides the default mapping between source language
            and file extension. Each comma-separated map consists
            of  the  source language name, a colon, and a list of
            extensions separated  by  periods.  For  example,  to
            specify  that  files  with extensions of .c, .ec, and
            .xs are to  be  treated  as  C  language  files,  use
            "--langmap=c:.c.ec.xs".  To  also  specify that files
            with extensions of .j are to be treated as Java  lan-
            guage files, use "--langmap=c:.c.ec.xs,java:.java.j".


       --recurse=yes|no
            Recurse into directories encountered in the  list  of
            supplied  files.  If  the  list  of supplied files is
            empty and no file  list  is  specified  with  the  -L
            option,  then  the  current  directory  (i.e. ".") is
            assumed.  On  Unix,  directories  named  "SCCS"   are
            skipped,  because  files in these directories are not
            source code, even though they have the same names  as
            the source code they relate to.  Note: This option is
            not supported on all platforms at present.


       --sort=yes|no
            Indicates whether the tag file should  be  sorted  on
            the tag name (default is yes). Note that the original
            vi(1) requires sorted tags. If the parameter is omit-
            ted,  =yes  is  implied. This option is on by default
            for ctags, and ignored for etags.


       --totals=yes|no
            Prints statistics about the source files read and the
            tag  file  written  during  the current invocation of
            ctags. If the parameter is omitted, =yes is  implied.
            This option is off by default.


       --version
            Prints  a  version  identifier  for ctags to standard
            output. This is  guaranteed  to  always  contain  the



Darren Hiebert            Version 2.2.6                         8





CTAGS(1)                                                 CTAGS(1)


            string "Exuberant Ctags".



OPERATIONAL DETAILS
       For  every  one of the qualified objects which are discov-
       ered in the source files supplied  to  ctags,  a  separate
       line  is  added to the tag file, each looking like this in
       the most general case:

           tag_name    file_name    ex_cmd;"    xflags

       The fields and separators of these lines are specified  as
       follows:

           1.  tag name (a C language identifier)
           2.  a single tab character
           3.  the  name  of the file in which the object associ-
               ated with the tag is located
           4.  a single tab character
           5.  an EX command to locate the tag within  the  file;
               generally  a  search  pattern (either /pattern/ or
               ?pattern?) or line number (see --excmd). Tag  file
               format  2  (see  --format) extends this EX command
               under certain circumstances to include  a  set  of
               extension   flags  (see  EXTENSION  FLAGS,  below)
               embedded in an EX comment immediately appended  to
               the EX command, which leaves it backwards compati-
               ble with original vi(1) implemenations.

       A few special tags are  written  into  the  tag  file  for
       internal  purposes.  These tags are composed in such a way
       that they always sort to the top of the file.   Therefore,
       the  first  two  characters of these tags are used a magic
       number to detect a tag file for  purposes  of  determining
       whether  a valid tag file is being overwritten rather than
       a source file.

       When this program is invoked by the name  etags,  or  with
       the  -e  option,  the output file is in a different format
       that is used by emacs(1).

       Note that the name of each source file will be recorded in
       the  tag  file  exactly as it appears on the command line.
       Therefore, if the path you specified on the  command  line
       was  relative  to some directory, then it will be recorded
       in that same manner in the tag file.

       This version of ctags imposes no formatting  requirements.
       Other  versions  of ctags tended to rely upon certain for-
       matting assumptions in order to  help  it  resolve  coding
       dilemmas caused by preprocessor conditionals.

       In  general,  ctags  tries  to  be smart about conditional



Darren Hiebert            Version 2.2.6                         9





CTAGS(1)                                                 CTAGS(1)


       preprocessor directives. If a preprocessor conditional  is
       encountered  within a statement which defines a tag, ctags
       follows only the first branch of that conditional  (except
       in  the  special case of "#if 0", in which case it follows
       only the last branch). The reason for this is that failing
       to  pursue only one branch can result in ambiguous syntax,
       as in the following example:

              #ifdef TWO_ALTERNATIVES
              struct {
              #else
              union {
              #endif
                  short a;
                  long b;
              }

       Both branches cannot be followed, or braces become  unbal-
       anced  and ctags would be unable to make sense of the syn-
       tax.

       If the application of this  heuristic  fails  to  properly
       parse  a  file, generally due to complicated and inconsis-
       tent pairing within the conditionals, ctags will retry the
       file  using  a  different  heuristic which does not selec-
       tively  follow  conditional  preprocessor  branches,   but
       instead  falls  back to relying upon a closing brace ("}")
       in column 1 as indicating the end  of  a  block  once  any
       brace  imbalance  results from following a #if conditional
       branch.

       Ctags will also try to specially  handle  arguments  lists
       enclosed  in double sets of parentheses in order to accept
       the following conditional construct:

              extern void foo __ARGS((int one, char two));

       Any name immediately preceding the "((" will be  automati-
       cally ignored and the previous name will be used.

       C++  operator  definitions  are  specially handled. In the
       case of operators beginning with a non-identifer character
       (e.g.  "operator ="), the name of the tag added to the tag
       file will be the operator prefixed by "operator", with  no
       intervening white space (e.g. "operator="). In the case of
       operators beginning with identifer characters (e.g. "oper-
       ator new"), the name of the tag added to the tag file will
       be simply the name of the operator, without a prefix (e.g.
       "new").

       After  creating or appending to the tag file, it is sorted
       by the tag name, removing identical tag lines.

       Note that the path recorded for filenames in the tag  file



Darren Hiebert            Version 2.2.6                        10





CTAGS(1)                                                 CTAGS(1)


       and  utilized by the editor to search for tags are identi-
       cal to the paths specified  for  file(s)  on  the  command
       line. This means the if you want the paths for files to be
       relative to some directory, you must invoke ctags with the
       same  pathnames  for  file(s) (this can be overridden with
       -p).


EXTENSION FLAGS
       Extension flags are tab-separated key-value pairs appended
       to  the  end  of the EX command as a comment, as described
       above in  OPERATIONAL  DETAILS.   These  key  value  pairs
       appear in the general form "key:value".  The possible keys
       and the meaning of their values are as follows:



       class       Indicates that this tag is  a  member  of  the
                   class whose name is given by value.



       enum        Indicates  that  this  tag  is a member of the
                   enumeration whose name is given by value.



       file        Indicates that  the  tag  has  a  file-limited
                   scope  (i.e. is static to the file).  This key
                   has no corresponding value.



       kind        Indicates the type of the tag.  Its  value  is
                   one  of  the  corresponding  one-letter  flags
                   described under the -i option, above. Alterna-
                   tively, this key may be omitted, with only the
                   value present (i.e. a field without a



       interface   Indicates that this tag is  a  member  of  the
                   interface whose name is given by value.



       namespace   Indicates  that  this  tag  is a member of the
                   namespace whose name is given by value.



       private     Indicates the visibility of this class  member
                   is  private.   This  key  has no corresponding
                   value.



Darren Hiebert            Version 2.2.6                        11





CTAGS(1)                                                 CTAGS(1)


       protected   Indicates the visibility of this class  member
                   is  protected.   This key has no corresponding
                   value.


       public      Indicates the visibility of this class  member
                   is  public.   This  key  has  no corresponding
                   value.


       struct      Indicates that this tag is  a  member  of  the
                   structure whose name is given by value.



       union       Indicates  that  this  tag  is a member of the
                   union whose name is given by value.




ENVIRONMENT VARIABLES
       CTAGS   This variable, if found, will be assumed  to  con-
               tain  a  set  of  custom default options which are
               read when ctags starts,  but  before  any  command
               line  options  are  read. Options in this variable
               should be in the same form as those on the command
               line.  Command  line options will override options
               specified in this variable. Only  options  may  be
               specified with this variable; no source file names
               are read from its value.


       ETAGS   Similar to the CTAGS variable  above,  this  vari-
               able, if found, will be read when etags starts. If
               this variable is not found, etags will try to  use
               CTAGS instead.


HOW TO USE WITH VI
       Vi  will, by default, expect a tag file by the name "tags"
       in the current directory. Once the tag file is built,  the
       following commands exercise the tag indexing feature:

       vi -t tag   Start  vi  and position the cursor at the file
                   and line where "tag" is defined.

       Control-]   Find the tag under the cursor.

       :ta tag     Find a tag.

       Control-T   Return to previous location before jump to tag
                   (not widely implemented).




Darren Hiebert            Version 2.2.6                        12





CTAGS(1)                                                 CTAGS(1)


HOW TO USE WITH GNU EMACS
       Emacs  will,  by  default,  expect  a tag file by the name
       "TAGS" in the current directory.  Once  the  tag  file  is
       built,  the  following  commands exercise the tag indexing
       feature:

       Meta-x visit-tags-table
                   Visit a TAGS file.

       Meta-.      Find a definition for a tag.  The default  tag
                   is  the identifier under the cursor.  There is
                   name completion in the minibuffer; typing "foo
                   TAB"  completes  the  identifier starting with
                   `foo' (`foobar', for  example)  or  lists  the
                   alternatives.

       Meta-,      Find  the  next definition for the tag.  Exact
                   matches are found first, followed  by  fuzzier
                   matches.

       For  more  commands,  see the Tags topic in the Emacs info
       tree.



BUGS
       Because ctags does not look inside brace-enclosed function
       blocks,  local  definitions  of  objects within a function
       will not have tags generated for them.

       Legacy C source code which uses C++ reserved  keywords  as
       variable  or  parameter  names  (e.g.  "class", etc.) in a
       header file may fail to have correct  tags  generated  for
       the  objects  using them. In order to properly handle such
       code, use the --lang option.

       Note that when ctags generates uses patterns for  locating
       tags  (see  the  --excmd  option), it is entirely possible
       that the wrong line may be found by your editor  if  there
       exists  another source line which is identical to the line
       containing the tag.  The  following  example  demonstrates
       this condition:

              int variable;

              /* ... */
              void foo(variable)
              int variable;
              {
                  /* ... */
              }

       Depending  upon which editor you use and where in the code
       you happen to be, it is possible that the  search  pattern



Darren Hiebert            Version 2.2.6                        13





CTAGS(1)                                                 CTAGS(1)


       may locate the local parameter declaration in foo() before
       it finds the actual global variable definition, since  the
       lines (and therefore their search patterns are identical).
       This can be avoided by use of the --excmd=n option.

       Because ctags is neither a preprocessor  nor  a  compiler,
       some  complex  or  obscure  constructs can fool ctags into
       either missing a tag or improperly generating an  inappro-
       priate  tag.  In  particular, the use of preprocessor con-
       structs which alter the  textual  syntax  of  C  can  fool
       ctags, as demonstrated by the following example:

              #ifdef GLOBAL
              #define EXTERN
              #define INIT(assign)  assign
              #else
              #define EXTERN extern
              #define INIT(assign)
              #endif

              EXTERN BUF *firstbuf INIT(= NULL);

       This  looks  too  much  like  a declaration for a function
       called "INIT",  which  returns  a  pointer  to  a  typedef
       "firstbuf",  rather  than  the  actual variable definition
       that it is, since this distinction can only be resolved by
       the preprocessor. The moral of the story: don't do this if
       you want a tag generated for it, or use the -I  option  to
       specify "INIT" as a keyword to be ignored.



FILES
       tags      The default tag file created by ctags.

       TAGS      The default tag file created by etags.


SEE ALSO
       The official Exuberant Ctags web site at:

           http://darren.hiebert.com/ctags/index.html

       Also  ex(1),  vi(1), elvis, or, better yet, vim, the offi-
       cial editor of ctags. For more information on vim, see the
       VIM Pages web site at:

           http://www.vim.org/



AUTHOR
       Darren Hiebert <darren@hiebert.com>, <darren@hiwaay.net>
       http://darren.hiebert.com/



Darren Hiebert            Version 2.2.6                        14





CTAGS(1)                                                 CTAGS(1)


MOTIVATION
       "Think  ye at all times of rendering some service to every
       member of the human race."

       "All effort and exertion put forth by man from  the  full-
       ness  of  his  heart  is worship, if it is prompted by the
       highest motives and the will to do service to humanity."

                 -- From the Baha'i Writings



CREDITS
       This version of ctags  was  originally  derived  from  and
       inspired  by  the ctags program by Steve Kirkendall <kirk-
       enda@cs.pdx.edu>  that  comes  with  the  Elvis  vi  clone
       (though virtually none of the original code remains).

       Credit  is  also  due  Bram  Moolenaar  <mool@oce.nl>, the
       author of vim, who has devoted so much  of  his  time  and
       energy  both to developing the editor as a service to oth-
       ers, and to helping the orphans of Uganda.

       The section entitled "HOW  TO  USE  WITH  GNU  EMACS"  was
       shamelessly stolen from the man page for GNU etags.
































Darren Hiebert            Version 2.2.6                        15


