" Vim syntax file
" Language:	lace
" Maintainer:	Jocelyn Fiat <utilities@eiffel.com>
" Last change:	1998 Feb 5 
"
" Copyright Interactive Software Engineering, 1998
" You are free to use this file as you please, but
" if you make a change or improvement you must send
" it to the maintainer at <utilities@eiffel.com>

"
" Remove any old syntax stuff hanging around
syn clear

" Eiffel is entirely case-insensitive.
syn case ignore

" A bunch of useful Eiffel keywords
syn keyword laceAssertion	require ensure invariant loop check no all
syn keyword laceAdapt		adapt ignore rename as export creation visible
syn keyword laceSourceFile	use include exclude
syn keyword laceKeyword		end 

syn keyword laceStructure	system root default cluster external 
syn keyword laceStructure	generate option end

syn keyword laceValue		yes no all
syn keyword laceOption		assertion collect debug optimize trace 
syn keyword	laceOption		profile inline precompiled multithreaded 
syn keyword	laceExternal	include_path object makefile

syn match 	laceName		"\<\([a-z]\|\_\|[0-9]\)*\>\:" 
syn region laceString		start=+"+ skip=+%"+ end=+"+ 
syn match  laceComment		"--.*" contains=laceTodo
syn keyword laceTodo 		contained	TODO FIXME XXX

if !exists("did_lace_syntax_inits")
  let did_lace_syntax_inits = 1
  " The default methods for highlighting.  Can be overridden later
  hi link laceKeyword	Keyword
  hi link laceAssertion	Constant
  hi link laceAdapt		Label
  hi link laceStructure	Lace1
  hi link laceSourceFile Label
  hi link laceExternal  Lace2
  hi link laceValue		Constant
  hi link laceString	String
  hi link laceOption	Lace2
  hi link laceComment	Comment
  hi link laceName		Lace2
  hi link laceTodo		Todo
  hi link laceError		Error
endif

  hi Error	term=reverse ctermbg=Red guibg=Orange
  hi Comment term=bold ctermfg=grey	guifg=#888888
  hi Lace1	term=italic gui=bold guibg=NONE guifg=blue
  hi Lace2	term=bold gui=bold guibg=NONE guifg=black
  hi Lace3	term=bold gui=bold guibg=NONE guifg=black

let b:current_syntax = "lace"

"vim: ts=4
