


CTAGS(1)                                                 CTAGS(1)


NAME
       ctags - Generate C language tag files for use with vi(1)


SYNOPSIS
       ctags [ -aBdeFnNtTuwWx ] [ -f tagfile ] [ -h list ]
             [ -i types ] [ -I ignorelist ] [ -L listfile ]
             [ -p path ] [ -o tagfile ] [ --append ]
             [ --excmd=m|n|p ] [ --format=level ] [ --help ]
             [ --if0 ] [ --sort ] [ --totals ] [ --version ]
             [ file(s) ]


       etags [ -adtTx ] [ -f tagfile ] [ -h list ] [ -i types ]
             [ -I ignorelist ] [ -L listfile ] [ -p path ]
             [ -o tagfile ] [ --append ] [ --help ] [ --if0 ]
             [ --totals ] [ --version ] [ file(s) ]


DESCRIPTION
       The  ctags  and  etags  programs (hereinafter collectively
       referred to as ctags, except where distinguished) generate
       an  index  (or  "tag")  file of C and C++ language objects
       found in file(s) that allows these items to be quickly and
       easily  located by a text editor or other utility. A "tag"
       signifies a C language object for which an index entry  is
       available  (or, alternatively, the index entry created for
       that object).

       Alternatively, ctags can generate a cross  reference  file
       which lists, in human readable form, information about the
       various objects found in a set of C or C++ language files.

       Tag  index files are supported by the vi(1) editor and its
       derivatives (such as vim, elvis, stevie, and xvi), and  by
       the  emacs  editor  (see  the  HOW  TO  USE WITH sections,
       below), all of which allow the user to locate  the  object
       associated with a name appearing in a source file and jump
       to the file and line which defines the name.

       The following types of tags are supported by ctags:

           class names
           macro definitions (names created by #define)
           enum names
           enumerators (values inside an enumeration)
           function (method) definitions
           function (method) prototypes/declarations
           class, structure, and union data members
           struct names
           typedefs
           union names
           variables




Darren Hiebert             Version 1.7                          1





CTAGS(1)                                                 CTAGS(1)


       Ctags only generates tags for objects  which  have  global
       scoping  (file-wide visibility). This means that, with the
       exception of macro definitions, only objects defined  out-
       side  of brace enclosed function blocks are candidates for
       a tag.


OPTIONS
       Despite the wealth of available options, defaults are  set
       so  that  ctags  is  most  commonly  executed  without any
       options (e.g. "ctags *.[ch]"), which  will  create  a  tag
       file in the current directory for the specified files. The
       options described below are provided merely to allow  cus-
       tom tailoring to meet special needs.

       Note that spaces separating the single-letter options from
       their parameters are optional.

       Note also that the boolean parameters  to  the  long  form
       options  (those  beginning  with  "--"  and  that  take  a
       "=yes|no" parameter) may be omitted, in which case  "=yes"
       is implied. (e.g. --sort is equivalent to --sort=yes).


       -a   Append  the  tags to an existing tag file. Equivalent
            to --append.


       -B   Use backward searching patterns (?...?).


       -d   Include macro definitions in the output file. This is
            equivalent  to  -i+d  and is supported only for back-
            wards compatibility with other versions of ctags. Use
            of -i is preferred.


       -e   Output  tag  file for use with Emacs. If this program
            is executed by the name etags, this option is set  by
            default.  Selecting  this option causes the following
            options to be ignored: -BFnNsuwW, --excmd,  --format,
            --sort.


       -f tagfile
            Use  the  name  specified by tagfile for the tag file
            (default is "tags",  or  "TAGS"  when  using  the  -e
            option). If tagfile is specified as "-", then the tag
            file is written to  standard  output  instead.  Ctags
            will  stubbornly  refuse  to  take  orders if tagfile
            exists and its first line  contains  something  other
            than  a  valid tags line. This will save your neck if
            you mistakenly type "ctags -f *.c", which would  oth-
            erwise  overwrite  your  first  C  file with the tags



Darren Hiebert             Version 1.7                          2





CTAGS(1)                                                 CTAGS(1)


            generated by the rest!


       -F   Use forward searching patterns (/.../) (default).


       -h list
            Specifies a list of file extensions used for headers,
            separated  by  either  periods or commas. The default
            list is ".h.H.hh.hpp.hxx.h++".


       -i types
            Specifies the list of tag types  to  include  in  the
            output file.  Types is a group of letters designating
            the types of tags affected. Each letter or  group  of
            letters   may  be  preceded  by  either  a  '+'  sign
            (default, if omitted) to  add  it  to  those  already
            included,  a  '-'  sign  to  exclude it from the list
            (e.g.  to exclude a default tag type), or an '=' sign
            to  include  its corresponding tag type at the exclu-
            sion of those not listed. Tags for the following lan-
            guage  contructs  are supported (default settings are
            shown in brackets):
               c   class names
               d   macro definitions
               e   enumerators (values inside an enumeration)
               f   function (or method) definitions
               g   enumeration names (tags)
               m   class, structure, and union data members
               p   external function prototypes
               t   typedefs
               u   union names
               v   variable definitions
            In addition, the following modifiers are accepted:
               F   Include tags for the basename of  each  source
                   file.  This  permits  jumping to a file by its
                   name (e.g. ":tag file.c" in vi(1)).
               S   Include static tags (those not visible outside
                   of  a single source file).  Function and vari-
                   able definitions are  considered  static  only
                   when  their  definitions are preceded with the
                   "static" keyword. All other types of tags  are
                   considered  static  when they appear in a non-
                   header file (see the -h option).
            The default value for types is "=cdefgtuvS" (i.e  all
            tag  types  except  for  structure/class  members and
            function prototypes; include static tags).


       -I ignorelist
            Reads a list of names which are to be  ignored  while
            generating tags for the source files. The list may be
            supplied directly on the command line or found  in  a



Darren Hiebert             Version 1.7                          3





CTAGS(1)                                                 CTAGS(1)


            separate  file. Normally, the parameter ignorelist is
            a list of names to be ignored, each separated with  a
            comma, a semicolon, or white space (in which case the
            list should be quoted to keep the entire list as  one
            command line argument). The parameter ignorelist will
            be interpreted as a filename if its  first  character
            is given as either a '.' or a pathname separator ('/'
            or '\'). In order to specify a file found in the cur-
            rent directory, use "./filename".

            This  feature  is useful when preprocessor macros are
            used in such a way that they cause  syntactic  confu-
            sion due to their presence. Some examples will illus-
            trate this point.

              /* creates a global version  string  in  module  */
              MODULE_VERSION("$Revision: 4.7 $")

            In  this  example, the macro invocation looks to much
            like a function definition because it is not followed
            by  a semicolon (indeed, it could even be followed by
            a global variable definition that would look  exactly
            like  a K&R style function parameter declaration). In
            fact, this seeming function definition  would  likely
            cause  the  rest of the file to be skipped over while
            trying to complete  the  definition.  Ignoring  "MOD-
            ULE_ID" would avoid such a problem.

              int foo ARGDECL2(void *, ptr, long int, nbytes)

            In  this  example, the macro "ARGDECL2" would be mis-
            takenly interpreted to be the name  of  the  function
            instead  of  the  correct name of "foo". Ignoring the
            name "ARGDECL2" results in the correct behavior.


       -L listfile
            Read from listfile a list of  file  names  for  which
            tags should be generated. If listfile is specified as
            "-", then file names are read from standard input.


       -n   Equivalent to --excmd=number.


       -N   Equivalent to --excmd=pattern.


       -o tagfile
            Alternative for -f.


       -p path
            Use path as the default directory  for  all  supplied



Darren Hiebert             Version 1.7                          4





CTAGS(1)                                                 CTAGS(1)


            source files (whether supplied on the command line or
            in a file specified with the -L option),  unless  the
            source file is already specified as an absolute path.
            Note that this will not work together with  wildcards
            in  the  filenames,  since  they  are expanded by the
            shell.


       -t   Include typedefs in the output file. This is  equiva-
            lent to -i+t and is supported only for backwards com-
            patibility with other versions of ctags. Use of -i is
            preferred.


       -T   Include  typedefs and class/enum/struct/union tags in
            the output file.  This is equivalent to -i+tg and  is
            supported only for backwards compatibility with other
            versions of ctags. Use of -i is preferred.


       -u   Equivalent to --sort=no.


       -w   Exclude warnings about duplicate tags (default).


       -W   Generate warnings about duplicate tags.


       -x   Print  a  tabular,  human-readable  cross   reference
            (xref)  file to standard output. The information con-
            tained in the output includes: the tag name; the  tag
            type;  the  line  number,  file name, and source line
            (with extra white space condensed) of the file  which
            defines  the tag. No tag file is written and the fol-
            lowing options will be ignored:  -aBfFno,  and  -i+P.
            Example  applications for this feature are generating
            a  listing  of  all  functions  (including   statics)
            located in a source file (e.g. ctags -xi=fS file), or
            generating a list of all  externally  visible  global
            variables  located in a source file (e.g. ctags -xi=v
            file).


       --append=yes|no
            Indicates whether tags generated from  the  specified
            files  should be appended to those already present in
            the tag file or should replace them. If the parameter
            is  omitted,  =yes  is implied. This option is off by
            default.


       --excmd=type
            Determines the type of EX command used to locate tags



Darren Hiebert             Version 1.7                          5





CTAGS(1)                                                 CTAGS(1)


            in  the  source  file.  The valid values for type are
            (either the  entire  word  or  the  first  letter  is
            accepted):

            number    Places  into  the  tag file line numbers in
                      the source  file  where  tags  are  located
                      rather  than  patterns  to be searched for.
                      This has three advantages:
                      1.  Significantly reduces the size  of  the
                          resulting tag file.
                      2.  Eliminates   failures   to   find  tags
                          because the line defining the  tag  has
                          changed,  causing  the pattern match to
                          fail (note that some editors,  such  as
                          vim,  are  able to recover in many such
                          instances).
                      3.  Eliminates finding identical  matching,
                          but  incorrect, source lines (see BUGS,
                          below).
                      However, this option  has  one  significant
                      drawback:  changes  to the source files can
                      cause the line numbers recorded in the  tag
                      file  to  no longer correspond to the lines
                      in the source file, causing jumps  to  some
                      tags  to  miss the target definition by one
                      or more lines. Basically,  this  option  is
                      best  used when the source code to which it
                      is  applied  is  not  subject  to   change.
                      Selecting  this option type causes the fol-
                      lowing options to be ignored: -BF.

            pattern   Uses  EX  search  patterns  for  all  tags,
                      rather  than  the line numbers usually used
                      for macro definitions. This has the  advan-
                      tage  of not referencing obsolete line num-
                      bers when lines have been added or  removed
                      since the tag file was generated.

            mixed     Uses line numbers for macro definition tags
                      and EX patterns for everything  else.  This
                      is  the  default  format  generated  by the
                      original ctags and is, therefore,  retained
                      as the default for this option.


       --format=level
            Change  the  format of the output tag file. Currently
            the only valid values for level are 1 or 2.  Level  1
            is  the  original format and level 2 includes support
            for extension flags (but retains  compatibility  with
            original vi(1) implementations).






Darren Hiebert             Version 1.7                          6





CTAGS(1)                                                 CTAGS(1)


       --help
            Prints  to  standard output a detailed usage descrip-
            tion.


       --if0=yes|no
            Indicates a preference as to whether code  within  an
            "#if  0"  branch of a preprocessor conditional should
            be examined for non-macro tags (macro tags are always
            included). Because the intent of this construct is to
            disable code, the default value of  this  options  is
            no.  Note  that  this indicates a preference only and
            does not guarantee skipping code within  an  "#if  0"
            branch,  since the fall-back algorithm used to gener-
            ate tags when preprocessor conditionals are too  com-
            plex  follows  all  branches of a conditional. If the
            parameter is omitted, =yes is implied. This option is
            off by default.


       --sort=yes|no
            Indicates  whether  the  tag file should be sorted on
            the tag name (default is yes).  Note  that  disabling
            sorting  also  disables the warning messages normally
            enabled by -W, because sorted tags are used to detect
            duplicate  tags.  Also  note  that the original vi(1)
            requires sorted tags. If the  parameter  is  omitted,
            =yes  is  implied.  This  option is on by default for
            ctags, and ignored for etags.


       --totals=yes|no
            Prints statistics about the source files read and the
            tag  file  written  during  the current invocation of
            ctags. If the parameter is omitted, =yes is  implied.
            This option is off by default.


       --version
            Prints  a  version  identifier  for ctags to standard
            output.


OPERATIONAL DETAILS
       For every one of the qualified objects which  are  discov-
       ered  in  the  source  files supplied to ctags, a separate
       line is added to the tag file, each looking like  this  in
       the most general case:

           tag_name    file_name    ex_cmd;"    xflags

       The  fields and separators of these lines are specified as
       follows:




Darren Hiebert             Version 1.7                          7





CTAGS(1)                                                 CTAGS(1)


           1.  tag name (a C language identifier)
           2.  a single tab character
           3.  the name of the file in which the  object  associ-
               ated with the tag is located
           4.  a single tab character
           5.  an  EX  command to locate the tag within the file;
               generally a search pattern  (either  /pattern/  or
               ?pattern?)  or line number (see --excmd). Tag file
               format 2 (see --format) extends  this  EX  command
               under  certain  circumstances  to include a set of
               extension flags embedded in an EX comment  immedi-
               ately  appended  to  the  EX command, which should
               make it backwards compatible with original  vi(1).

       A  few  special  tags  are  written  into the tag file for
       internal purposes. These tags are composed in such  a  way
       that  they always sort to the top of the file.  Therefore,
       the first two characters of these tags are  used  a  magic
       number  to  detect  a tag file for purposes of determining
       whether a valid tag file is being overwritten rather  than
       a source file.

       When  this  program  is invoked by the name etags, or with
       the -e option, the output file is in  a  different  format
       that is used by emacs(1).

       Note that the name of each source file will be recorded in
       the tag file exactly as it appears on  the  command  line.
       Therefore,  if  the path you specified on the command line
       was relative to some directory, then it will  be  recorded
       in that same manner in the tag file.

       This  version of ctags imposes no formatting requirements.
       Other versions of ctags tended to rely upon  certain  for-
       matting  assumptions  in  order  to help it resolve coding
       dilemmas caused by preprocessor conditionals.

       In general, ctags tries to be smart about conditional pre-
       processor  directives.  If  a  preprocessor conditional is
       encountered within a statement which defines a tag,  ctags
       follows  only the first branch of that conditional (except
       in the special case of "#if 0", in which case  it  follows
       only the last branch). The reason for this is that failing
       to pursue only one branch can result in ambiguous  syntax,
       as in the following example:

              #ifdef TWO_ALTERNATIVES
              struct {
              #else
              union {
              #endif
                  short a;
                  long b;
              }



Darren Hiebert             Version 1.7                          8





CTAGS(1)                                                 CTAGS(1)


       Both  branches cannot be followed, or braces become unbal-
       anced and ctags would be unable to make sense of the  syn-
       tax.

       If  the  application  of  this heuristic fails to properly
       parse a file, generally due to complicated  and  inconsis-
       tent pairing within the conditionals, ctags will retry the
       file using a different heuristic  which  does  not  selec-
       tively   follow  conditional  preprocessor  branches,  but
       instead falls back to relying upon a closing  brace  ("}")
       in  column  1  as  indicating  the end of a block once any
       brace imbalance results from following a  #if  conditional
       branch.

       Ctags  will  also  try to specially handle arguments lists
       enclosed in double sets of parentheses in order to  accept
       the following conditional construct:

              extern void foo __ARGS((int one, char two));

       Any  name immediately preceding the "((" will be automati-
       cally ignored and the previous name will be used.

       After creating or appending to the tag file, it is  sorted
       by the tag name, removing identical tag lines.

       Note  that the path recorded for filenames in the tag file
       and utilized by the editor to search for tags are  identi-
       cal  to  the  paths  specified  for file(s) on the command
       line. This means the if you want the paths for files to be
       relative to some directory, you must invoke ctags with the
       same pathnames for file(s) (this can  be  overridden  with
       -p).


ENVIRONMENT VARIABLES
       CTAGS   This  variable,  if found, will be assumed to con-
               tain a set of custom  default  options  which  are
               read  when  ctags  starts,  but before any command
               line options are read. Options  in  this  variable
               should be in the same form as those on the command
               line. Command line options will  override  options
               specified  in  this  variable. Only options may be
               specified with this variable; no source file names
               are read from its value.


       ETAGS   Similar  to  the  CTAGS variable above, this vari-
               able, if found, will be read when etags starts. If
               this  variable is not found, etags will try to use
               CTAGS instead.






Darren Hiebert             Version 1.7                          9





CTAGS(1)                                                 CTAGS(1)


HOW TO USE WITH VI
       Vi will, by default, expect a tag file by the name  "tags"
       in  the current directory. Once the tag file is built, the
       following commands exercise the tag indexing feature:

       vi -t tag   Start vi and position the cursor at  the  file
                   and line where "tag" is defined.

       Control-]   Find the tag under the cursor.

       :ta tag     Find a tag.

       Control-T   Return to previous location before jump to tag
                   (not widely implemented).


HOW TO USE WITH GNU EMACS
       Emacs will, by default, expect a  tag  file  by  the  name
       "TAGS"  in  the  current  directory.  Once the tag file is
       built, the following commands exercise  the  tag  indexing
       feature:

       Meta-x visit-tags-table
                   Visit a TAGS file.

       Meta-.      Find  a definition for a tag.  The default tag
                   is the identifier under the cursor.  There  is
                   name completion in the minibuffer; typing "foo
                   TAB" completes the  identifier  starting  with
                   `foo'  (`foobar',  for  example)  or lists the
                   alternatives.

       Meta-,      Find the next definition for the  tag.   Exact
                   matches  are  found first, followed by fuzzier
                   matches.

       For more commands, see the Tags topic in  the  Emacs  info
       tree.


BUGS
       Because ctags does not look inside brace enclosed function
       blocks, local declarations of  classes,  enum/struct/union
       tags,  enumeration  values and variables within a function
       will not have tags generated for them.

       Note that when ctags generates uses patterns for  locating
       tags  (see  the  --excmd  option), it is entirely possible
       that the wrong line may be found by your editor  if  there
       exists another, identical, line (whose context prevents it
       from generating a tag) which is identical to the line con-
       taining  the  tag. The following example demonstrates this
       condition:




Darren Hiebert             Version 1.7                         10





CTAGS(1)                                                 CTAGS(1)


              int variable;

              /* ... */
              void foo(variable)
              int variable;
              {
                  /* ... */
              }

       Depending upon which editor you use and where in the  code
       you  happen  to be, it is possible that the search pattern
       may locate the local parameter declaration in foo() before
       it  finds the actual global variable definition, since the
       lines (and therefore their search patterns are identical).
       This can be avoided by use of the -n option.

       Because  ctags  is  neither a preprocessor nor a compiler,
       some complex or obscure constructs  can  fool  ctags  into
       either  missing a tag or improperly generating an inappro-
       priate tag. In particular, the use  of  preprocessor  con-
       structs  which  alter  the  textual  syntax  of C can fool
       ctags, as demonstrated by the following example:

              #ifdef GLOBAL
              #define EXTERN
              #define INIT(assign)  assign
              #else
              #define EXTERN extern
              #define INIT(assign)
              #endif

              EXTERN BUF *firstbuf INIT(= NULL);

       This looks too much like  a  declaration  for  a  function
       called  "INIT",  which  returns  a  pointer  to  a typedef
       "firstbuf", rather than  the  actual  variable  definition
       that it is, since this distinction can only be resolved by
       the preprocessor. The moral of the story: don't do this if
       you  want  a tag generated for it, or use the -I option to
       specify "INIT" as a keyword to be ignored.


FILES
       tags      The default tag file created by ctags.

       TAGS      The default tag file created by etags.


SEE ALSO
       The official Exuberant Ctags web site at:

           http://fly.hiwaay.net/~darren/ctags/

       Also  ex(1),  vi(1),  elvis,  or,  better  yet,  vim,  the



Darren Hiebert             Version 1.7                         11





CTAGS(1)                                                 CTAGS(1)


       official editor of ctags. For more information on vim, see
       the VIM Pages web site at:

           http://www.vim.org/


AUTHOR
       Darren Hiebert <darren@hiebert.com>
       http://fly.hiwaay.net/~darren


MOTIVATION
       "Think ye at all times of rendering some service to  every
       member of the human race."

       "All  effort  and exertion put forth by man from the full-
       ness of his heart is worship, if it  is  prompted  by  the
       highest motives and the will to do service to humanity."

                 -- From the Baha'i Writings


CREDITS
       This  version  of  ctags  was  originally derived from and
       inspired by the ctags program by Steve  Kirkendall  (kirk-
       enda@cs.pdx.edu)  that  comes  with  the  Elvis  vi  clone
       (though virtually none of the original code remains).

       Credit is also due Bram Moolenaar, the author of vim,  who
       has  devoted so much of his time and energy both to devel-
       oping the editor as a service to others,  and  to  helping
       the orphans of Uganda.

       The  section  entitled  "HOW  TO  USE  WITH GNU EMACS" was
       shamelessly stolen from the man page for GNU etags.






















Darren Hiebert             Version 1.7                         12


