" Vim syntax file
" Language:	Vim script
" Maintainer:	Dr. Charles E. Campbell, Jr. <cec@gryphon.gsfc.nasa.gov>
" Last change:	January 5, 1998

" Remove old syntax
syn clear

syn keyword vimTodo contained	TODO

" regular vim commands
syn keyword vimCommand contained	I	d[elete]	mak[e]	sal[l]	wn[ext]
syn keyword vimCommand contained	N[ext]	di[splay]	map	sbN[ext]	wp[revous]
syn keyword vimCommand contained	a[ppend]	dig[raphs]	mapc[lear]	sb[uffer]	wq
syn keyword vimCommand contained	ab[breviate]	display	marks	sba[ll]	wqa[ll]
syn keyword vimCommand contained	abc[lear]	dj[ump]	mk[exrc]	sbl[ast]	wqall
syn keyword vimCommand contained	al[l]	dl[ist]	mkv[imrc]	sbm[odified]	wv[iminfo]
syn keyword vimCommand contained	ar[gs]	do[autocmd]	mod[e]	sbn[ext]	x[it]
syn keyword vimCommand contained	argu[ment]	doautoa[ll]	n[ext]	sbp[revious]	xa[ll]
syn keyword vimCommand contained	as[cii]	ds[earch]	new	sbr[ewind]	xall
syn keyword vimCommand contained	au[tocmd]	dsp[lit]	nm[ap]	se[t]	y[ank]
syn keyword vimCommand contained	aug[roup]	e[dit]	nmap	set	am
syn keyword vimCommand contained	autocmd	ec[ho]	nmapc[lear]	sh[ell]	amenu
syn keyword vimCommand contained	bN[ext]	echon	nn[oremap]	sl[eep]	an
syn keyword vimCommand contained	b[uffer]	else	no[remap]	sla[st]	anoremenu
syn keyword vimCommand contained	ba[ll]	elsei[f]	norea[bbrev]	sn[ext]	aun
syn keyword vimCommand contained	bd[elete]	en[dif]	norm[al]	so[urce]	aunmenu
syn keyword vimCommand contained	bdelete	endw[hile]	nu[mber]	sp[lit]	cme
syn keyword vimCommand contained	bl[ast]	ex	nun[map]	spr[evious]	cmenu
syn keyword vimCommand contained	bm[odified]	exe[cute]	o[pen]	sr[ewind]	cnoreme
syn keyword vimCommand contained	bn[ext]	exi[t]	om[ap]	st[op]	cnoremenu
syn keyword vimCommand contained	bp[revious]	f[ile]	omap	sta[g]	cunme
syn keyword vimCommand contained	br[ewind]	files	omapc[lear]	sun[hide]	cunmenu
syn keyword vimCommand contained	brea[k]	fix[del]	on[ly]	sus[pend]	ime
syn keyword vimCommand contained	buffers	g[lobal]	ono[remap]	sv[iew]	imenu
syn keyword vimCommand contained	bun[load]	global	ou[nmap]	sy[ntax]	inoreme
syn keyword vimCommand contained	bunload	h[elp]	p[rint]	t	inoremenu
syn keyword vimCommand contained	cN[ext]	hid[e]	pe[rl]	tN[ext]	iunme
syn keyword vimCommand contained	c[hange]	highlight	perld[o]	ta[g]	iunmenu
syn keyword vimCommand contained	ca[bbrev]	i[nsert]	po[p]	tags	me
syn keyword vimCommand contained	cabc[lear]	ia[bbrev]	pre[serve]	the	menu
syn keyword vimCommand contained	cc	iabc[lear]	prev[ious]	tl[ast]	nme
syn keyword vimCommand contained	cd	if	pw[d]	tn[ext]	nmenu
syn keyword vimCommand contained	ce[nter]	ij[ump]	py[thon]	tp[revious]	nnoreme
syn keyword vimCommand contained	cf[ile]	il[ist]	pyf[ile]	tr[ewind]	nnoremenu
syn keyword vimCommand contained	chd[ir]	im[ap]	q[uit]	u[ndo]	noreme
syn keyword vimCommand contained	che[ckpath]	imap	qa[ll]	una[bbreviate]	noremenu
syn keyword vimCommand contained	cl[ist]	imapc[lear]	qall	unh[ide]	nunme
syn keyword vimCommand contained	clast	ino[remap]	quit	unl[et]	nunmenu
syn keyword vimCommand contained	clo[se]	inorea[bbrev]	r[ead]	unm[ap]	ome
syn keyword vimCommand contained	cm[ap]	is[earch]	rec[over]	v[global]	omenu
syn keyword vimCommand contained	cmap	isp[lit]	red[o]	ve[rsion]	onoreme
syn keyword vimCommand contained	cmapc[lear]	iu[nmap]	redi[r]	vi[sual]	onoremenu
syn keyword vimCommand contained	cn[ext]	iuna[bbrev]	reg[isters]	vie[w]	ounme
syn keyword vimCommand contained	cno[remap]	j[oin]	res[ize]	vm[ap]	ounmenu
syn keyword vimCommand contained	cnorea[bbrev]	ju[mps]	resize	vmap	unme
syn keyword vimCommand contained	co[py]	k	ret[ab]	vmapc[lear]	unmenu
syn keyword vimCommand contained	con[tinue]	l[ist]	rew[ind]	vn[oremap]	vme
syn keyword vimCommand contained	cp[revious]	la[st]	ri[ght]	vu[nmap]	vmenu
syn keyword vimCommand contained	cq	le[ft]	rv[iminfo]	wN[ext]	vnoreme
syn keyword vimCommand contained	cq[uit]	let	sN[ext]	w[rite]	vnoremenu
syn keyword vimCommand contained	crewind	ls	s[ubstitute]	wa[ll]	vunme
syn keyword vimCommand contained	cu[nmap]	m[ove]	sa[rgument]	wh[ile]	vunmenu
syn keyword vimCommand contained	cuna[bbrev]	ma[rk]

" All vimCommands are contained by vimIsCommands.
syn match vimIsCommand	"^\s*[a-zA-Z_]\+"	transparent contains=vimCommand
syn match vimIsCommand	"[:|]\s*[a-zA-Z_]\+"	transparent contains=vimCommand
syn match vimIsCommand2	"\s[a-zA-Z_]\+\s"	contained transparent contains=vimCommand,vimAutoEvent

" vimOptions are caught only when contained in a vimSet
syn keyword vimOption contained	ai	equalprg	isp	ru	tagrelative
syn keyword vimOption contained	akm	errorbells	isprint	ruler	tags
syn keyword vimOption contained	al	errorfile	joinspaces	sb	tbi
syn keyword vimOption contained	aleph	errorformat	js	sbr	term
syn keyword vimOption contained	altkeymap	esckeys	keywordprg	sc	terse
syn keyword vimOption contained	autoindent	et	kp	scr	textauto
syn keyword vimOption contained	autowrite	eventignore	langmap	scroll	textmode
syn keyword vimOption contained	aw	ex	laststatus	scrolljump	textwidth
syn keyword vimOption contained	background	expandtab	lazyredraw	scrolloff	tf
syn keyword vimOption contained	backspace	exrc	lbr	scs	tildeop
syn keyword vimOption contained	backup	ff	linebreak	sect	timeout
syn keyword vimOption contained	backupdir	ffs	lines	sections	timeoutlen
syn keyword vimOption contained	backupext	fileformat	lisp	secure	title
syn keyword vimOption contained	bdir	fileformats	list	sh	titlelen
syn keyword vimOption contained	bex	fk	lmap	shcf	titlestring
syn keyword vimOption contained	bg	fkmap	ls	shell	tl
syn keyword vimOption contained	bin	fo	lz	shellcmdflag	tm
syn keyword vimOption contained	binary	formatoptions	magic	shellpipe	to
syn keyword vimOption contained	biosk	formatprg	makeef	shellquote	top
syn keyword vimOption contained	bioskey	fp	makeprg	shellredir	tr
syn keyword vimOption contained	bk	gcr	mat	shelltype	ts
syn keyword vimOption contained	breakat	gd	matchtime	shellxquote	tsl
syn keyword vimOption contained	brk	gdefault	maxmapdepth	shiftround	ttimeout
syn keyword vimOption contained	bs	gfn	maxmem	shiftwidth	ttimeoutlen
syn keyword vimOption contained	ch	go	maxmemtot	shm	ttm
syn keyword vimOption contained	cin	guicursor	mef	shortmess	ttybuiltin
syn keyword vimOption contained	cindent	guifont	mh	shortname	ttyfast
syn keyword vimOption contained	cink	guioptions	ml	showbreak	ttyscroll
syn keyword vimOption contained	cinkeys	guipty	mls	showcmd	ttytype
syn keyword vimOption contained	cino	helpfile	mm	showmatch	tw
syn keyword vimOption contained	cinoptions	helpheight	mmd	showmode	tx
syn keyword vimOption contained	cinw	hf	mmt	shq	uc
syn keyword vimOption contained	cinwords	hh	mod	si	ul
syn keyword vimOption contained	cmdheight	hi	modeline	sidescroll	undolevels
syn keyword vimOption contained	co	hid	modelines	sj	updatecount
syn keyword vimOption contained	columns	hidden	modified	sm	updatetime
syn keyword vimOption contained	com	highlight	more	smartcase	ut
syn keyword vimOption contained	comments	history	mouse	smartindent	vb
syn keyword vimOption contained	compatible	hk	mousehide	smarttab	vbs
syn keyword vimOption contained	complete	hkmap	mouset	smd	verbose
syn keyword vimOption contained	cp	hkmapp	mousetime	sn	vi
syn keyword vimOption contained	cpo	hkp	mp	so	viminfo
syn keyword vimOption contained	cpoptions	hl	nf	softtabstop	visualbell
syn keyword vimOption contained	cpt	hls	nrformats	sol	wa
syn keyword vimOption contained	def	hlsearch	nu	sp	warn
syn keyword vimOption contained	define	ic	number	splitbelow	wb
syn keyword vimOption contained	dg	icon	pa	sr	wc
syn keyword vimOption contained	dict	iconstring	para	srr	wd
syn keyword vimOption contained	dictionary	ignorecase	paragraphs	ss	weirdinvert
syn keyword vimOption contained	digraph	im	paste	st	wh
syn keyword vimOption contained	dir	inc	patchmode	sta	whichwrap
syn keyword vimOption contained	directory	include	path	startofline	wildchar
syn keyword vimOption contained	ea	incsearch	pm	sts	winheight
syn keyword vimOption contained	eb	inf	readonly	su	wiv
syn keyword vimOption contained	ed	infercase	remap	suffixes	wm
syn keyword vimOption contained	edcompatible	insertmode	report	sw	wrap
syn keyword vimOption contained	ef	is	restorescreen	swapsync	wrapmargin
syn keyword vimOption contained	efm	isf	revins	sws	wrapscan
syn keyword vimOption contained	ei	isfname	ri	sxq	writeany
syn keyword vimOption contained	ek	isi	rightleft	ta	writebackup
syn keyword vimOption contained	endofline	isident	rl	tabstop	writedelay
syn keyword vimOption contained	eol	isk	ro	tag	ws
syn keyword vimOption contained	ep	iskeyword	rs	taglength	ww
syn keyword vimOption contained	equalalways

" These are the turn-off setting variants
syn keyword vimOption contained	noai	noesckeys	nojoinspaces	noru	noterse
syn keyword vimOption contained	noakm	noet	nojs	noruler	notextauto
syn keyword vimOption contained	noalkeymap	noex	nolbr	nosb	notextmode
syn keyword vimOption contained	noautoindent	noexpandtab	nolinebreak	nosc	notf
syn keyword vimOption contained	noautowrite	noexrc	nolisp	noscs	notildeop
syn keyword vimOption contained	noaw	nofk	nolist	nosecure	notimeout
syn keyword vimOption contained	nobackup	nofkmap	nomagic	noshiftround	notitle
syn keyword vimOption contained	nobin	nogd	nomh	noshortname	noto
syn keyword vimOption contained	nobinary	nogdefault	noml	noshowcmd	notop
syn keyword vimOption contained	nobiosk	noguipty	nomod	noshowmatch	notr
syn keyword vimOption contained	nobioskey	nohid	nomodeline	noshowmode	nottimeout
syn keyword vimOption contained	nobk	nohidden	nomodified	nosi	nottybuiltin
syn keyword vimOption contained	nocin	nohk	nomore	nosm	nottyfast
syn keyword vimOption contained	nocindent	nohkmap	nomousehide	nosmartcase	notx
syn keyword vimOption contained	nocompatible	nohkmapp	nonu	nosmartindent	novb
syn keyword vimOption contained	nocp	nohkp	nonumber	nosmarttab	novisualbell
syn keyword vimOption contained	nodg	nohls	nopaste	nosmd	nowa
syn keyword vimOption contained	nodigraph	nohlsearch	noreadonly	nosn	nowarn
syn keyword vimOption contained	noea	noic	noremap	nosol	nowb
syn keyword vimOption contained	noeb	noicon	norestorescreen	nosplitbelow	noweirdinvert
syn keyword vimOption contained	noed	noignorecase	norevins	nosr	nowiv
syn keyword vimOption contained	noedcompatible	noim	nori	nosta	nowrap
syn keyword vimOption contained	noek	noincsearch	norightleft	nostartofline	nowrapscan
syn keyword vimOption contained	noendofline	noinf	norl	nota	nowriteany
syn keyword vimOption contained	noeol	noinfercase	noro	notagrelative	nowritebackup
syn keyword vimOption contained	noequalalways	noinsertmode	nors	notbi	nows
syn keyword vimOption contained	noerrorbells	nois

" termcap codes (which can also be set)
syn keyword vimOption contained	t_AB	t_RI	t_cs	t_k8	t_kr	t_so
syn keyword vimOption contained	t_AF	t_Sb	t_da	t_k9	t_ks	t_sr
syn keyword vimOption contained	t_AL	t_Sf	t_db	t_kD	t_ku	t_te
syn keyword vimOption contained	t_CS	t_ZH	t_dl	t_kI	t_le	t_ti
syn keyword vimOption contained	t_Co	t_ZR	t_k1	t_kN	t_mb	t_ue
syn keyword vimOption contained	t_DL	t_al	t_k2	t_kP	t_md	t_us
syn keyword vimOption contained	t_F1	t_bc	t_k3	t_kb	t_me	t_vb
syn keyword vimOption contained	t_F2	t_cd	t_k4	t_kd	t_mr	t_ve
syn keyword vimOption contained	t_K1	t_ce	t_k5	t_ke	t_ms	t_vi
syn keyword vimOption contained	t_K3	t_cl	t_k6	t_kh	t_nd	t_vs
syn keyword vimOption contained	t_K4	t_cm	t_k7	t_kl	t_se	t_xs
syn keyword vimOption contained	t_K5
syn match   vimOption contained	"t_#4"
syn match   vimOption contained	"t_%1"
syn match   vimOption contained	"t_%i"
syn match   vimOption contained	"t_&8"
syn match   vimOption contained	"t_@7"
syn match   vimOption contained	"t_k;"

" these settings don't actually cause errors in vim, but were supported by vi and don't do anything in vim
syn keyword vimErrSetting contained	ap	gr	op	slow	w1200
syn keyword vimErrSetting contained	autoprint	graphic	open	slowopen	w300
syn keyword vimErrSetting contained	beautify	hardtabs	optimize	sourceany	w9600
syn keyword vimErrSetting contained	bf	ht	prompt	tagstack	wi
syn keyword vimErrSetting contained	fl	mesg	redraw	tgst	window
syn keyword vimErrSetting contained	flash	novice

" AutoBuf Events
syn keyword vimAutoEvent contained	BufDelete	BufReadPre	FileAppendPre	FilterReadPost	StdinReadPre
syn keyword vimAutoEvent contained	BufEnter	BufUnload	FileChangedShell	FilterReadPre	TermChanged
syn keyword vimAutoEvent contained	BufLeave	BufWrite	FileReadPost	FilterWritePost	VimLeave
syn keyword vimAutoEvent contained	BufNewFile	BufWritePost	FileReadPre	FilterWritePre	WinEnter
syn keyword vimAutoEvent contained	BufRead	BufWritePre	FileWritePost	StdinReadPost	WinLeave
syn keyword vimAutoEvent contained	BufReadPost	FileAppendPost	FileWritePre

" Highlight commonly used Groupnames
syn keyword vimGroup	Comment	Identifier	Keyword	Type	Tag
syn keyword vimGroup	Constant	Function	Exception	StorageClass	Delimiter
syn keyword vimGroup	String	Statement	PreProc	Structure	SpecialComment
syn keyword vimGroup	Character	Conditional	Include	Typedef	Debug
syn keyword vimGroup	Number	Repeat	Define	Special	Error
syn keyword vimGroup	Boolean	Label	Macro	SpecialChar	Todo
syn keyword vimGroup	Float	Operator	PreCondit

" Default highlighting groups
syn keyword vimHLGroup	Cursor	ErrorMsg	ModeMsg	Normal	Search	Title
syn keyword vimHLGroup	Debug,	LineNr	MoreMsg	Question	SpecialKey	Visual
syn keyword vimHLGroup	Directory	Menu	NonText	Scrollbar	StatusLine	WarningMsg

"--- syntax above generated by mkvimvim ---
" Highlight syntax stuff

syn match   vimMark	"'[a-zA-Z0-9]"
syn match   vimRegister	'"[a-zA-Z0-9\-:.%#*=]'

syn keyword vimPattern contained	start	skip	end

syn keyword vimSpecial	ALL	ccomment	matchgroup	skipempty	sync
syn keyword vimSpecial	NONE	lines	minlines	skipnl	transparent

" Highlight syntax stuff -- the following vimSpecials aren't keywords because Vim's syntax checking
" disapproves
syn match vimSpecial	contained	"\<ALLBUT\>"
syn match vimSpecial	contained	"\<clear\>"
syn match vimSpecial	contained	"\<contained\>"
syn match vimSpecial	contained	"\<oneline\>"
syn match vimSpecial	contained	"\<contains\>"
syn match vimSpecial	contained	"\<grouphere\>"
syn match vimSpecial	contained	"\<groupthere\>"
syn match vimSpecial	contained	"\<keepend\>"
syn match vimSpecial	contained	"\<maxlines\>"
syn match vimSpecial	contained	"\<nextgroup\>"
syn match vimSpecial	contained	"\<skipempty\>"
syn match vimSpecial	contained	"\<skipnl\>"
syn match vimSpecial	contained	"\<skipwhite\>"
syn match vimSpecial	contained	"\<transparent\>"

" Highlight Terminal Stuff
syn keyword vimTermSet  contained	background	cterm	ctermfg	font	gui	guifg
syn keyword vimTermSet  contained	bg	ctermbg	fg	foreground	guibg	term	start
syn match   vimTermSet  contained	"stop"

" Special Filenames and Modifiers
syn match vimSpecFile	"<\(cword\|cWORD\|[cas]file\)>"	nextgroup=vimSpecFileMod
syn match vimSpecFile	"#[0-9]\|[#%]"		nextgroup=vimSpecFileMod
syn match vimSpecFileMod	"\(:[phtre]\)\+"		contained

" commands, function, and conditionals
syn keyword vimFunction	buffer_exists exists expand file_readable getline has highlight_exists last_buffer_nr ret strftime strlen substr

syn match vimConditional	"^\s*\(continue\|con\)\>"
syn match vimConditional	"^\s*\(endif\|en\)\>"
syn match vimConditional	"^\s*\(endwhile\|endw\)\>"
syn match vimConditional	"^\s*\(while\|wh\)\>"
syn match vimConditional	"^\s*break\=\>"
syn match vimConditional	"^\s*else\>"
syn match vimConditional	"^\s*elseif\=\>"
syn match vimConditional	"^\s*if\>"

" Operators
syn match vimOper	"||\|&&\|!=\|>=\|<=\|=\~\|!\~\|>\|<\|+\|-\|=\|\."

" Numbers
syn match vimNumber	"\<[0-9]\+.[0-9]\+"
syn match vimNumber	"\<[0-9]\+L\="
syn match vimNumber	"-[0-9]\+.[0-9]\+"
syn match vimNumber	"-[0-9]\+L\="
syn match vimNumber	"[[;:][0-9]\+"lc=1
syn match vimNumber	"0[xX][0-9a-fA-F]\+"
syn match vimNumber	"#[0-9a-fA-F]\+"

" A comment after a command starts with a ".  Note that the second
" rule allows "..." to be a comment, but the first rule will
" only highlight comments "... with no " in the comment.
syn match vimComment	+\s"[^\-:.%#=*].*$+lc=1	contains=vimTodo
syn match vimComment	+^\s*".*$+		contains=vimTodo

" A comment line starts with a " at the start of the line
syn match vimComment	+^\s*".*$+	contains=vimTodo

" Try to catch strings, if nothing else matches (therefore it must precede the others!)
"  vmEscapeBrace handles ["]  []"] (ie. stays as string)
syn region	vimEscapeBrace	start="[^\\]\(\\\\\)*\[\^\=\]\=" skip="\\\\\|\\\]" end="\]"me=e-1	oneline contained transparent 
syn match	vimPatSep	"\\[|()]"hs=e-1	contained
syn match	vimNotPatSep	"\\\\"	contained
syn region	vimString	start=+[^:,a-zA-Z>!]"+lc=1 skip=+\\\\\|\\"+ end=+"+ oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	start=+[^:,a-zA-Z>!]'+lc=1 skip=+\\\\\|\\'+ end=+'+ oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	start=+=!+lc=1	skip=+\\\\\|\\!+ end=+!+	oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	start="=+"lc=1	skip="\\\\\|\\+" end="+"	oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	start="\s+"lc=1	skip="\\\\\|\\+" end="+\s"me=e-1	oneline contains=vimEscapeBrace,vimPatSep,vimNotPatSep

" set command and associated set-options (vimOptions) with comment
syn region vimSet matchgroup=vimCommand start="\s*set\>" end="|\|$"	keepend contains=vimSetEqual,vimOption,vimErrSetting,vimComment,vimSetString
syn region vimSetEqual  contained	start="="	skip="\(\\\\\)*\\\s" end="[| \t]\|$"me=e-1 contains=vimCtrlChar
syn region vimSetString contained	start=+="+hs=s+1	skip=+\(\\\\\)\\"+   end=+"+	contains=vimCtrlChar

" highlight modifiers
syn keyword VimHLMod contained NONE bold inverse italic reverse standout underline

" autocmd
syn region vimAutoCmd matchgroup=vimAutoSet start=+^\s*\(autocmd\|au\)\>+	end="$" keepend contains=vimAutoEvent,vimSet,vimIsCommand,vimIsCommand2,vimString,vimComment,vimSpecFile
syn region vimAutoCmd matchgroup=vimAutoSet start=+^\s*\(doautoa\|doautoall\)\>+	end="$" keepend contains=vimAutoEvent,vimSet,vimIsCommand,vimIsCommand2,vimString,vimComment,vimSpecFile

" Syntax regions (all oneliners)
syn keyword vimKeyword contained link match
syn keyword vimCase    contained ignore match
syn region vimSynLine matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+keyword" end="$"	keepend contains=vimKeyword,vimSpecial,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+region" end="$"	keepend contains=vimKeyword,vimSpecial,vimString,vimPattern,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+match" end="$"	keepend contains=vimKeyword,vimSpecial,vimString,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+clear"rs=e-5 end="$"	keepend contains=vimSpecial,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+case" end="$"	keepend contains=vimCase,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(syntax\|syn\)\s\+sync" end="$"	keepend contains=vimKeyword,vimSpecial,vimString,vimComment
syn region vimRegion  matchgroup=vimKeyword start="^\s*\(highlight\|hi\)\s" end="$"		keepend contains=vimKeyword,vimSpecial,vimGroup,vimTermSet,vimComment,vimCtrlChar,VimRegion,vimNotation,vimNumber,vimHLMod

" Angle-Bracket Notation
syn match vimNotation	"<[a-zA-Z][a-zA-Z0-9]\+>"		contains=vimBracket
syn match vimNotation	"<[a-zA-Z0-9]\+>"		contains=vimBracket
syn match vimNotation	"<C-[A-Z]>"			contains=vimBracket
syn match vimNotation	"<[AM]-.>"			contains=vimBracket
syn match vimNotation	"<[SCAM]-\(Right\|Left\|Down\|Up\)>"	contains=vimBracket
syn match vimNotation	"<S-F[0-9]>"			contains=vimBracket
syn match vimBracket contained	"[<>]"

" Control Characters
syn match vimCtrlChar	"[--]"

if !exists("did_vim_syntax_inits")
  let did_vim_syntax_inits = 1
  " The default methods for highlighting.  Can be overridden later
  hi link vimAutoSet	vimCommand
  hi link vimConditional	vimStatement
  hi link vimHLGroup	vimGroup
  hi link vimNotPatSep	vimString
  hi link vimSetString	vimString
  hi link vimSpecFileMod	vimSpecFile
  hi link vimTerminal	vimGroup

  hi link vimAutoEvent	Type
  hi link vimBracket	Delimiter
  hi link vimCommand	Statement
  hi link vimComment	Comment
  hi link vimCtrlChar	SpecialChar
  hi link vimErrSetting	Error
  hi link vimFunction	Function
  hi link vimGroup	Type
  hi link vimHLMod	PreProc
  hi link vimKeyword	Statement
  hi link vimMark	Number
  hi link vimNotation	Special
  hi link vimNumber	Number
  hi link vimOper	Operator
  hi link vimOption	PreProc
  hi link vimPatSep	SpecialChar
  hi link vimPattern	Type
  hi link vimRegister	SpecialChar
  hi link vimSpecFile	Identifier
  hi link vimSpecial	Type
  hi link vimStatement	Statement
  hi link vimString	String
  hi link vimTermSet	StorageClass
  hi link vimTodo	Todo
endif

let b:current_syntax = "vim"

" vim: ts=17
