" Vim syntax file
" Language:	Fortran
" Maintainer:	Mario Eusebio <bio@dq.fct.unl.pt>
" Last change:	1997 April 28

" Remove any old syntax stuff hanging around
syn clear

syn case ignore

syn keyword fortranStatement		return continue
syn keyword fortranLabel		go to goto
syn keyword fortranConditional	if else elseif
syn keyword fortranConditional	endif then
syn keyword fortranRepeat		do

syn keyword fortranTodo contained	TODO

" This is valid with Gnu Fortran
"syn match   fortranSpecial contained "\\[0-9][0-9][0-9]\|\\."
"syn region  fortranString	start=+"+  skip=+\\\\\|\\"+  end=+"+  contains=fortranSpecial
"syn region  fortranString	start=+'+  skip=+\\\\\|\\"+  end=+'+  contains=fortranSpecial

syn region  fortranString		start=+"+  end=+"+
syn region  fortranString		start=+'+  end=+'+
syn region  fortranFormatString	start=+'(+  end=+)'+

"syn match  fortranIdentifier	"\<[a-zA-Z_][a-zA-Z0-9_]*\>"

"syn match  fortranDelimiter	"[()]"

" Standard Fortran 77 accepts any character other than blank
" in the 6th column to mark a continuation line.
"syn match  fortranContinueError	"^\ \ \ \ \ [`~@#%^&()\-_=[{\]};:'",<.>/?].*$"

syn match  fortranNoLabelNumber	"^[0-9][0-9][0-9][0-9][0-9][^ \t].*$"
syn match  fortranNoLabelNumber	"^\ [0-9][0-9][0-9][0-9][^ \t].*$"
syn match  fortranNoLabelNumber	"^\ \ [0-9][0-9][0-9][^ \t].*$"
syn match  fortranNoLabelNumber	"^\ \ \ [0-9][0-9][^ \t].*$"
syn match  fortranNoLabelNumber	"^\ \ \ \ [0-9][^ \t].*$"

syn match  fortranLabelNumber	"^[0-9]\=[0-9]\=[0-9]\=[0-9]\=[0-9]\>"
syn match  fortranLabelNumber	"^\ [0-9]\=[0-9]\=[0-9]\=[0-9]\>"
syn match  fortranLabelNumber	"^\ \ [0-9]\=[0-9]\=[0-9]\>"
syn match  fortranLabelNumber	"^\ \ \ [0-9]\=[0-9]\>"
syn match  fortranLabelNumber	"^\ \ \ \ [0-9]\>"

" I don't like fortranPoint* form of numbers
syn match  fortranDoubleNumber	"-\=\<[0-9]\+\.[0-9]\+[Dd]-\=[0-9]\+\>"
"syn match  fortranPointDoubleNumber	"-\=\<[0-9]\+\.[Dd]-\=[0-9]\+\>"
"syn match  fortranPointDoubleNumber	"-\=\.[0-9]\+[Dd]-\=[0-9]\+\>"
syn match  fortranRealNumber		"-\=\<[0-9]\+\.[0-9]\+[eE]-\=[0-9]\+\>"
"syn match  fortranPointRealNumber	"-\=\<[0-9]\+\.[eE]-\=[0-9]\+\>"
"syn match  fortranPointRealNumber	"-\=\.[0-9]\+[eE]-\=[0-9]\+\>"
syn match  fortranRealNumber		"-\=\<[0-9]\+\.[0-9]\+\>"
"syn match  fortranPointRealNumber	"-\=\<[0-9]\+\."
"syn match  fortranPointRealNumber	"-\=\.[0-9]\+\>"
syn match  fortranNumber		"-\=\<[0-9]\+\>"

syn match  fortranComment		"^[cC*].*$" contains=fortranTodo
syn match  fortranComment		"!.*$" contains=fortranTodo

"syn match fortranppPreCondit	"^#define\>"
"syn match fortranppPreCondit	"^#include\>"

" any character other than a c in the first column
" would be an error
" does not work with keywords
syn match  fortranCommentError	"^[^\ ^0-9^\t].*$"
syn match  fortranCommentError	"^\ [^\ ^0-9^\t].*$"
syn match  fortranCommentError	"^\ \ [^\ ^0-9^\t].*$"
syn match  fortranCommentError	"^\ \ \ [^\ ^0-9^\t].*$"
syn match  fortranCommentError	"^\ \ \ \ [^\ ^0-9^\t].*$"

"syn match  fortranCommentError	"^[^!]\{73\}.*$"

syn match  fortranContinueLine	"^\ \ \ \ \ [^\t^\ ]"

" If you don't like initial tabs in fortran
"syn match fortranShowIniTab "^\t.*$"
" If you don't like tabs at all
"syn match fortranShowTab "\t"

syn match fortranOperator		"\.and\."
syn match fortranOperator		"\.eq\."
syn match fortranOperator		"\.eqv\."
syn match fortranOperator		"\.ge\."
syn match fortranOperator		"\.gt\."
syn match fortranOperator		"\.le\."
syn match fortranOperator		"\.lt\."
syn match fortranOperator		"\.ne\."
syn match fortranOperator		"\.neqv\."
syn match fortranOperator		"\.not\."
syn match fortranOperator		"\.or\."

syn match fortranLogicalConstant	"\.true\."
syn match fortranLogicalConstant	"\.false\."

syn keyword fortranType		implicit
syn keyword fortranType		integer real real*8
syn keyword fortranType		double precision complex
syn keyword fortranType		character logical

syn keyword fortranStructure		parameter
syn keyword fortranStructure		common equivalence dimension
syn keyword fortranStructure		external intrinsic save


syn keyword fortranUnitHeader	program subroutine function
syn keyword fortranUnitHeader	data end call

syn keyword fortranReadWrite		read write print inquire
syn keyword fortranReadWrite		open close rewind backspace

syn keyword fortranFormat		format unit fmt status file
syn keyword fortranFormat		err form access iostat rec
syn keyword fortranFormat		recl blank

syn keyword fortranStopPause		stop pause
syn keyword fortranImplicit		abs acos aint atan asin cos
syn keyword fortranImplicit		cosh aimag anint atan2
syn keyword fortranImplicit		char cmplx conjg dble
syn keyword fortranImplicit		dim dprod exp ichar index
syn keyword fortranImplicit		int len lge lgt lle llt
syn keyword fortranImplicit		log log10 max min mod nint
syn keyword fortranImplicit		sin sinh sign sqrt tan tanh

syn keyword fortranSpecific		iabs dabs cabs dacos dint
syn keyword fortranSpecific		dnint dasin datan datan2
syn keyword fortranSpecific		dcos ccos dcosh idim ddim dexp
syn keyword fortranSpecific		cexp dlog clog dlog10 dmod
syn keyword fortranSpecific		idnint isign dsign dsin csin
syn keyword fortranSpecific		dsinh dsqrt csqrt dtan dtanh

" This syntax highlighting file support Fortran 77 by default
"syn keyword fortranExtended  allocate assign block case contains
"syn keyword fortranExtended  cycle deallocate default elsewhere
"syn keyword fortranExtended  enddo endfile endwhile entry
"syn keyword fortranExtended  equivalence exit interface module
"syn keyword fortranExtended  nullify only operator procedure
"syn keyword fortranExtended  recursive select use where while
"syn keyword fortranExtended  allocatable in include inout intent
"syn keyword fortranExtended  kind namelist none optional out
"syn keyword fortranExtended  pointer private public result
"syn keyword fortranExtended  sequence target type achar adjustl
"syn keyword fortranExtended  adjustr all allocated any bit_size
"syn keyword fortranExtended  break btest carg ceiling conjg
"syn keyword fortranExtended  count cshift date_and_time digits
"syn keyword fortranExtended  dim dot_product dvchk eoshift
"syn keyword fortranExtended  epsilon error exponent floor
"syn keyword fortranExtended  flush fraction getcl huge iachar
"syn keyword fortranExtended  iand ibclr ibits ibset ichar ieor
"syn keyword fortranExtended  intrup invalop ior iostat_msg ishft
"syn keyword fortranExtended  ishftc lbound len_trim matmul
"syn keyword fortranExtended  maxexponent maxloc maxval merge
"syn keyword fortranExtended  minexponent minloc minval modulo
"syn keyword fortranExtended  mvbits nbreak ndperr ndpexc nearest
"syn keyword fortranExtended  nint not offset ovefl pack precfill
"syn keyword fortranExtended  present product prompt radix
"syn keyword fortranExtended  random_number random_seed range
"syn keyword fortranExtended  repeat reshape rrspacing scale
"syn keyword fortranExtended  scan segment selected_int_kind
"syn keyword fortranExtended  selected_real_kind set_exponent
"syn keyword fortranExtended  shape signsize spacing spread sum
"syn keyword fortranExtended  system system_clock timer tiny
"syn keyword fortranExtended  transfer transpose trim ubound
"syn keyword fortranExtended  undfl unpack val verify action
"syn keyword fortranExtended  blank blocksize carriagecontrol
"syn keyword fortranExtended  direct exist form formatted from
"syn keyword fortranExtended  location name named nextrec number
"syn keyword fortranExtended  opened recl recordtype sequential
"syn keyword fortranExtended  stat unformatted

if !exists("did_fortran_syntax_inits")
  let did_fortran_syntax_inits = 1
  " The default methods for highlighting.  Can be overridden later

  hi link fortranConditional	Conditional
  hi link fortranRepeat		Repeat
  hi link fortranStatement	Statement
  hi link fortranStructure	fortranType
  hi link fortranType		Type
  hi link fortranContinueLine	Todo
  hi link fortranLabel		Special
  hi link fortranLabelNumber	Special
  hi link fortranDoubleNumber	fortranNumber
  hi link fortranRealNumber	Float
  hi link fortranNumber		Number
  hi link fortranNoLabelNumber	Error
  hi link fortranCommentError	Error
  hi link fortranFormatString	fortranString
  hi link fortranString		String
  hi link fortranOperator	Operator
  hi link fortranLogicalConstant	Constant
  hi link fortranComment		Comment
  hi link fortranTodo		Todo
  hi link fortranSpecific	fortranImplicit
  hi link fortranStopPause	fortranImplicit
  hi link fortranFormat		fortranImplicit
  hi link fortranReadWrite	fortranImplicit
  hi link fortranImplicit	Identifier
  hi link fortranUnitHeader	preCondit

  " optional highlighting
  "hi link fortranExtended		fortranImplicit
  "hi link fortranppPreCondit		PreCondit
  "hi link fortranContinueError		Error
  "hi link fortranSpecial		Special
  "hi link fortranPointRealNumber	fortranNumber
  "hi link fortranPointDoubleNumber	fortranNumber
  "hi link fortranShowIniTab		Error
  "hi link fortranShowTab		Error
  "hi link fortranDelimiter		Identifier

  "hi link fortranIdentifier	Identifier
endif

let b:current_syntax = "fortran"

" vim: ts=8
