/* vi:set ts=8 sts=4 sw=4:
 * vi:set comments=sbl\:*\ -,mb\:*,el\:*\ -,sr\:/\*,mb\:*,el\:*\/,fb\:- :
 *
 * VIM - Vi IMproved		by Bram Moolenaar
 *
 * Do ":help uganda"  in Vim to read copying and usage conditions.
 * Do ":help credits" in Vim to see a list of people who contributed.
 */

#include "vim.h"

/*
 * Vim originated from Stevie version 3.6 (Fish disk 217) by GRWalter (Fred)
 * It has been changed beyond recognition since then.
 *
 * Differences between version 4.x and 5.0 can be found with ":help version5".
 * Differences between version 3.0 and 4.x can be found with ":help version4".
 * All the remarks about older versions have been removed, they are not very
 * interesting.
 *
 * Changes between version 5.0t and 5.0u:
 * - Fixed: col() returned 1 instead of 0 for a mark that isn't set.
 * - Fixed: Pasting text with the middle mouse butten, while Visual selection
 *   and Insert mode pending, moved the cursor one character further after the
 *   pasted text.
 * - Fixed: ":ta" as the first command crashed Vim.
 * - Fixed: count for ":trewind" didn't work.
 * - Added: ":tselect" command; select a tag from a list of matches.  Also
 *   "g^]": like "^]" but use ":tselect" instead of ":tag".
 * - Added: Allow a tag name with wildcards for ":ta" and "tselect".
 * - Changed: ":ta" at top of the tag stack no longer does ":tnext".
 * - Fixed: Compilation problems on Digital UNIX V3.2G (Campbell).
 * - Fixed: ":let &option = val" didn't redraw the screen when required.  Made
 *   a more generic solution to redrawing when an option value is changed.
 *   Should also speed up handling the ":set" command.
 * - Fixed: Removed TIOCLSET/TIOCLGET code from os_unix.c.  Was changing some
 *   of the terminal settings, and looked like it wasn't doing anything good.
 *   (suggested by Weigert).
 * - Fixed: When switching xterm pages, "ls | vim -" wrote a message to the
 *   wrong page.  Now switch back to the Vim page before writing the message.
 *   Also, clear the screen for when "cat | vim -" messed it up.
 * - Fixed: "expand("`echo`")" returned "`echo`".  Now it's an empty string.
 * - For Dos16 version, don't include mouse code (saves a bit of memory).
 * - Fixed: Ruler overwrote "is a directory" message.  When starting up, and
 *   'cmdheight' set to > 1, first message could still be in the last line.
 * - Fixed in Win32 GUI: A font name containing '_' didn't work.  Now first
 *   try the unmodified font name, then with '_' replaced by ' '.
 * - Fixed: In the GUI, when the cursor is just after a bold or italic
 *   character, it removed one row of pixels from it.
 * - Removed "proto/" from paths in proto.h.  Needed for the Mac port.
 * - Added "<Bslash>" special character.  Helps for avoiding multiple
 *   backslashes in mappings and menus.
 * - Fixed: "File/Print" menu wasn't working properly for Win32.  Now use
 *   Notepad.
 * - Added: synID(), highlightID(), synIDattr() and synIDtrans() functions to
 *   expression evaluation.  Allows for using syntax recognition in scripts.
 * - Added "syntax/2html.vim": convert file to HTML, using the current syntax
 *   highlighting.  Now you can convert all your colored files to HTML!  And
 *   from there you can print them.
 * - Added "\<xxx>" special key codes to expression evaluation.
 * - Improved performace of Ex commands by using a lookup table for the first
 *   character.
 * - Removed msg_pos(), setting msg_col and msg_row is simpler.
 * - Replace csdpmi3 by csdpmi4.
 * - Fixes for VMS.  Added proto/os_vms.pro.  (Campbell)
 * - Removed prototype for putenv() from proto.h, it's already in osdef2.h.in.
 * - Fixed: syntax syncing with "grouphere" didn't work.
 * - Fixed: In replace mode, when moving the cursor and then backspacing,
 *   wrong characters were inserted.
 * - Fixed: Win32 GUI was checking for a CTRL-C too often, making it slow.
 * - Removed mappings for MS-DOS that were already covered by commands.
 * - Changed <C-Left> and <C-Right> to skip a WORD intead of a word.
 * - Added 'A' flag to 'shortmess': don't give ATTENTION message.
 * - Included the MIDL files, for compiling OLE with Borland C++.
 * - Included version 1.8 of xxd. (Juergen Weigert)
 * - Included version 1.7.5 of ctags (Darren Hiebert)
 * - Fixed: "vas" and "vis" didn't select the current sentence.
 * - Fixed: When visually selecting all lines in a file, cursor at last line,
 *   then "J".  Gave ml_get errors.  Was a problem with scrolling down during
 *   redrawing.
 * - Fixed: When doing a linewise operator, and then an operator with a mouse
 *   click, it was also linewise, instead of characterwise.
 * - Fixed: Warning for changed modified time when overwriting a file only
 *   worked on Unix.
 * - Changed the defaults for configure to be the same as the defaults for
 *   Makefile: include GUI, Perl and Python.
 * - Fixed: After ":set isprint&" needed to redraw the screen.
 * - Fixed: When 'list' is set, the column of the ruler was wrong.  Also,
 *   textwidth formatting was wrong.  And expanding Tabs (sometimes).
 *   Added 'L' flag in 'cpoptions' to do it the Vi way (which is not
 *   intuitive, so it's default off).
 * - Fixed: Only read 16 characters at a time, instead of 50.  Caused trouble
 *   for resizing the window on the Amiga.
 * - Fixed: didn't get callback when losing focus in Athena GUI.  Obscure
 *   problem, fixed by moving "-lXaw" to before "-lXext" for linking.
 * - Fixed: Spurious error message for "/\(b\+\)*".
 * - Renamed "W32GUIvc4.mak" to "Gvim_vc.mak".
 * - Fixed: When visually selected many lines, message from ":w file"
 *   disappeared when redrawing the screen.
 * - Fixed: ":set <M-b>=^[b", then insert "^[b", waited for another character.
 *   And then inserted "<M-b>" instead of the real <M-b> character.
 *   Was trying to insert K_SPECIAL x NUL.
 * - Fixed: "nmake -f if_ole_vc.mak" didn't work with the DOS source archive,
 *   because files were missing.
 */

#include "version.h"

char	*Version = VIM_VERSION_SHORT;
char	*mediumVersion = VIM_VERSION_MEDIUM;
#ifdef HAVE_DATE_TIME
char	*longVersion = VIM_VERSION_LONG_DATE __DATE__ " " __TIME__ ")";
#else
char	*longVersion = VIM_VERSION_LONG;
#endif

static void version_msg __ARGS((char *s));

    int
get_version()
{
    return (VIM_VERSION_MAJOR * 100 + VIM_VERSION_MINOR);
}

    void
do_version(arg)
    char_u  *arg;
{
    /*
     * Ignore a ":version 9.99" command.
     */
    if (*arg == NUL)
    {
	/*
	 * When adding features here, don't forget to update the list of
	 * internal variables in eval.c!
	 */
	msg_putchar('\n');
	MSG(longVersion);
#ifdef WIN32
	MSG_PUTS("\nWindows NT / Windows 95 version");
#endif
#ifdef MSDOS
# ifdef DJGPP
	MSG_PUTS("\n32 bit MS-DOS version");
# else
	MSG_PUTS("\n16 bit MS-DOS version");
# endif
#endif
	MSG_PUTS("\nCompiled with (+) or without (-):\n");
#ifdef AMIGA		/* only for Amiga systems */
# ifdef NO_ARP
	version_msg("-ARP ");
# else
	version_msg("+ARP ");
# endif
#endif
#ifdef AUTOCMD
	version_msg("+autocmd ");
#else
	version_msg("-autocmd ");
#endif
#ifdef NO_BUILTIN_TCAPS
	version_msg("-builtin_terms ");
#endif
#ifdef SOME_BUILTIN_TCAPS
	version_msg("+builtin_terms ");
#endif
#ifdef ALL_BUILTIN_TCAPS
	version_msg("++builtin_terms ");
#endif
#ifdef CINDENT
	version_msg("+cindent ");
#else
	version_msg("-cindent ");
#endif
#ifdef DIGRAPHS
	version_msg("+digraphs ");
#else
	version_msg("-digraphs ");
#endif
#ifdef EMACS_TAGS
	version_msg("+emacs_tags ");
#else
	version_msg("-emacs_tags ");
#endif
#ifdef FKMAP
	version_msg("+farsi ");
#else
	version_msg("-farsi ");
#endif
	    /* only interesting on Unix systems */
#if !defined(USE_SYSTEM) && defined(UNIX)
	version_msg("+fork() ");
#endif
#ifdef UNIX
# ifdef USE_GUI_MOTIF
	version_msg("+GUI_Motif ");
# else
#  ifdef USE_GUI_ATHENA
	version_msg("+GUI_Athena ");
#  else
#   ifdef USE_GUI_BEOS
	version_msg("+GUI_BeOS ");
#    else
	version_msg("-GUI ");
#   endif
#  endif
# endif
#endif
#ifdef INSERT_EXPAND
	version_msg("+insert_expand ");
#else
	version_msg("-insert_expand ");
#endif
#ifdef HAVE_LANGMAP
	version_msg("+langmap ");
#else
	version_msg("-langmap ");
#endif
#ifdef LISPINDENT
	version_msg("+lispindent ");
#else
	version_msg("-lispindent ");
#endif
#ifdef HAVE_OLE
	version_msg("+ole ");
#else
	version_msg("-ole ");
#endif
#ifdef HAVE_PERL_INTERP
	version_msg("+perl ");
#else
	version_msg("-perl ");
#endif
#ifdef HAVE_PYTHON
	version_msg("+python ");
#else
	version_msg("-python ");
#endif
#ifdef RIGHTLEFT
	version_msg("+rightleft ");
#else
	version_msg("-rightleft ");
#endif
#ifdef SMARTINDENT
	version_msg("+smartindent ");
#else
	version_msg("-smartindent ");
#endif
	    /* only interesting on Unix systems */
#if defined(USE_SYSTEM) && (defined(UNIX) || defined(__EMX__))
	version_msg("+system() ");
#endif
#if defined(UNIX) || defined(__EMX__)
/* only unix (or OS/2 with EMX!) can have terminfo instead of termcap */
# ifdef TERMINFO
	version_msg("+terminfo ");
# else
	version_msg("-terminfo ");
# endif
#else		    /* unix always includes termcap support */
# ifdef HAVE_TGETENT
	version_msg("+tgetent ");
# else
	version_msg("-tgetent ");
# endif
#endif
#ifdef VIMINFO
	version_msg("+viminfo ");
#else
	version_msg("-viminfo ");
#endif
#ifdef WRITEBACKUP
	version_msg("+writebackup ");
#else
	version_msg("-writebackup ");
#endif
#ifdef UNIX
# if defined(WANT_X11) && defined(HAVE_X11)
	version_msg("+X11 ");
# else
	version_msg("-X11 ");
# endif
#endif
	msg_putchar('\n');
#ifdef USR_VIMRC_FILE
	version_msg("   user vimrc file: \"");
	version_msg(USR_VIMRC_FILE);
	version_msg("\" ");
#endif
#ifdef USR_VIMRC_FILE2
	version_msg("2nd user vimrc file: \"");
	version_msg(USR_VIMRC_FILE2);
	version_msg("\" ");
#endif
#ifdef USR_EXRC_FILE
	version_msg("    user exrc file: \"");
	version_msg(USR_EXRC_FILE);
	version_msg("\" ");
#endif
#ifdef USR_EXRC_FILE2
	version_msg("2nd user exrc file: \"");
	version_msg(USR_EXRC_FILE2);
	version_msg("\" ");
#endif
#ifdef USE_GUI
	version_msg("  user gvimrc file: \"");
	version_msg(USR_GVIMRC_FILE);
	version_msg("\" ");
# ifdef USR_GVIMRC_FILE2
	version_msg("2nd user gvimrc file: \"");
	version_msg(USR_GVIMRC_FILE2);
	version_msg("\" ");
# endif
#endif
#ifdef SYS_VIMRC_FILE
	msg_putchar('\n');
	version_msg(" system vimrc file: \"");
	version_msg(SYS_VIMRC_FILE);
	version_msg("\"");
#endif
#ifdef USE_GUI
# ifdef SYS_GVIMRC_FILE
	msg_putchar('\n');
	version_msg("system gvimrc file: \"");
	version_msg(SYS_GVIMRC_FILE);
	MSG_PUTS("\"");
# endif
# ifdef SYS_MENU_FILE
	msg_putchar('\n');
	version_msg("  system menu file: \"");
	version_msg(SYS_MENU_FILE);
	MSG_PUTS("\"");
# endif
#endif
#ifdef HAVE_PATHDEF
	msg_putchar('\n');
	version_msg("  default for $VIM: \"");
	version_msg((char *)default_vim_dir);
	MSG_PUTS("\"\n");
	version_msg("Compilation: ");
	version_msg((char *)all_cflags);
	msg_putchar('\n');
	version_msg("Linking: ");
	version_msg((char *)all_lflags);
#endif
#ifdef DEBUG
	msg_putchar('\n');
	version_msg("  DEBUG BUILD");
#endif
    }
}

/*
 * Output a string for the version message.  If it's going to wrap, output a
 * newline, unless the message is too long to fit on the screen anyway.
 */
    static void
version_msg(s)
    char	*s;
{
    int		len = strlen(s);

    if (len < (int)Columns && msg_col + len >= (int)Columns)
	msg_putchar('\n');
    MSG_PUTS(s);
}
