" Vim syntax file
" Language:	Matlab
" Maintainer:	Mario Eusebio <bio@dq.fct.unl.pt>
" Last change:	1997 April 25

" Remove any old syntax stuff hanging around
syn clear

syn case match

syn keyword matlabStatement		continue return
syn keyword matlabLabel		case switch
syn keyword matlabConditional	else elseif end if
syn keyword matlabRepeat		do for while

syn keyword matlabTodo contained	TODO

" String
syn region  matlabString	  start=+'+  end=+'+

" Doesn't handle a'' but of course a''=a
syn match  matlabTransposeOperator	"[a-zA-Z0-9).]'"hs=s+1
syn match  matlabTransposeMatrix	"]'"

" If you choose matlabDelimiter then uncomment next commands
"syn match  matlabTransposeOperator	"[a-zA-Z0-9.]'"s+1
"syn match  matlabTransposeMatrix	")'"
"syn match  matlabTransposeMatrix	"]'"

"syn match  matlabIdentifier	"\<[a-zA-Z_][a-zA-Z0-9_]*\>"

"syn match  matlabDelimiter	"[()]"
syn match  matlabMatrixDelimiter	"[][]"

" I don't like MatlabPoint* form of numbers
syn match  matlabNumber		"-\=\<[0-9]\+\.[0-9]\+[dD]-\=[0-9]\+\>"
"syn match  matlabPointNumber	"-\=\<[0-9]\+\.[dD]-\=[0-9]\+\>"
"syn match  matlabPointNumber	"-\=\.[0-9]\+[dD]-\=[0-9]\+\>"
"syn match  matlabPointNumber	"-\=[0-9]\+[dD]-\=[0-9]\+\>"
syn match  matlabNumber		"-\=\<[0-9]\+\.[0-9]\+[eE]-\=[0-9]\+\>"
"syn match  matlabPointNumber	"-\=\<[0-9]\+\.[eE]-\=[0-9]\+\>"
"syn match  matlabPointNumber	"-\=\.[0-9]\+[eE]-\=[0-9]\+\>"
"syn match  matlabPointNumber	"-\=[0-9]\+[eE]-\=[0-9]\+\>"
syn match  matlabNumber		"-\=\<[0-9]\+\.[0-9]\+\>"
"syn match  matlabPointNumber	"-\=\<[0-9]\+\."
"syn match  matlabPointNumber	"-\=\.[0-9]\+\>"
syn match  matlabNumber		"-\=\<[0-9]\+\>"

" If you don't like tabs
"syn match matlabShowTab "\t"
"syn match matlabShowTabc "\t"

"syn match  matlabComment		"%.*$" contains=matlabTodo,matlabShowTabc
syn match  matlabComment		"%.*$" contains=matlabTodo

syn keyword matlabOperator		break zeros default margin round
syn keyword matlabOperator		ceil floor size clear

syn keyword matlabFunction		eval function

syn keyword matlabError		error

syn keyword matlabImplicit		abs acos atan asin cos cosh
syn keyword matlabImplicit		exp log log10 max min
syn keyword matlabImplicit		sign sqrt tan

if !exists("did_matlab_syntax_inits")
  let did_matlab_syntax_inits = 1
  " The default methods for highlighting.  Can be overridden later
  hi link matlabLabel			Label
  hi link matlabConditional		Conditional
  hi link matlabRepeat			Repeat
  hi link matlabTodo			Todo
  hi link matlabString			String
  hi link matlabTransposeOperator	Operator
  hi link matlabMatrixDelimiter		Identifier
  hi link matlabTransposeMatrix		Identifier
  hi link matlabNumber			Number
  hi link matlabOperator			Operator
  hi link matlabFunction			Function
  hi link matlabError			Error
  hi link matlabImplicit			matlabStatement
  hi link matlabComment			Comment
  hi link matlabStatement		Statement

"optional highlighting
  "hi link matlabDelimiter		Identifier
  "hi link matlabPointNumber		Number

  "hi link matlabShowTab			Error
  "hi link matlabShowTabc		Error

  "hi link matlabIdentifier		Identifier
endif

let b:current_syntax = "matlab"

" vim: ts=8
