" Vim syntax file
" Language:	Slrn setup file
" Maintainer:	Preben "Peppe" Guldberg (c928400@student.dtu.dk)
" Last change:	Thu Mar 12 00:25:04 1998

" Remove any old syntax stuff hanging around
syn clear

syn keyword slrnTodo		contained Todo

syn match slrnNumber		contained "-\=\<[0-9]\+\>"

syn match slrnSpecKey		contained +\(\\[e"']\|\^[a-zA-Z]\)+

syn match slrnKey		contained "\S\+"	contains=slrnSpecKey
syn region slrnKey		contained start=+"+ skip=+\\"+ end=+\($\|"\)+ contains=slrnSpecKey
syn region slrnKey		contained start=+'+ skip=+\\"+ end=+\($\|'\)+ contains=slrnSpecKey

syn match slrnSpecChar	contained +'+
syn match slrnSpecChar	contained +\\[n"]+	
syn match slrnSpecChar	contained "%[dfmnrs%]"

syn match slrnString		contained '[^ \t%"']\+'	contains=slrnSpecChar
syn region slrnString		contained start=+"+ skip=+\\"+ end=+"+ contains=slrnSpecChar

syn match slrnComment		"%.*$"	contains=slrnTodo

syn keyword slrnIdentNum	author_display beep cc_followup confirm_actions
syn keyword slrnIdentNum	display_author_realname display_score group_dsc_start_column
syn keyword slrnIdentNum	kill_score lines_per_update max_low_score min_high_score
syn keyword slrnIdentNum	mouse new_subject_breaks_threads no_backups
syn keyword slrnIdentNum	prompt_next_group query_next_article query_next_group
syn keyword slrnIdentNum	query_read_group_cutoff query_reconnect read_active
syn keyword slrnIdentNum	reject_long_lines scroll_by_page show_article
syn keyword slrnIdentNum	show_descriptions show_thread_subject sorting_method
syn keyword slrnIdentNum	spoiler_display_mode spool_check_up_on_nov
syn keyword slrnIdentNum	uncollapse_threads unsubscribe_new_groups use_header_numbers
syn keyword slrnIdentNum	use_metamail use_mime use_tilde use_tmpdir use_xgtitle
syn keyword slrnIdentNum	wrap_flags write_newsrc_flags

syn keyword slrnIdentStr	Xbrowser art_help_line cc_followup_string charset
syn keyword slrnIdentStr	custom_headers decode_directory editor_command
syn keyword slrnIdentStr	followup_custom_headers followup_string group_help_line
syn keyword slrnIdentStr	grouplens_host grouplens_port grouplens_pseudoname
syn keyword slrnIdentStr	header_help_line mail_editor_command metamail_command
syn keyword slrnIdentStr	mime_charset non_Xbrowser post_editor_command
syn keyword slrnIdentStr	postpone_directory quote_string realname
syn keyword slrnIdentStr	reply_custom_headers reply_string replyto save_directory
syn keyword slrnIdentStr	save_posts save_replies score_editor_command
syn keyword slrnIdentStr	sendmail_command signature spoiler_char spool_active_file
syn keyword slrnIdentStr	spool_activetimes_file spool_inn_root spool_newsgroups_file
syn keyword slrnIdentStr	spool_nov_file spool_nov_root spool_root use_grouplens
syn keyword slrnIdentStr	username

" setting variables
syn keyword slrnSet		contained set
syn match   slrnSetStrInit	contained "^\s*set\s\+\S\+" nextgroup=slrnString contains=slrn\(Set\|IdentStr\)
syn match   slrnSetStr	contained "^\s*set\s\+\S\+\s\+\S" contains=slrn\(SetStrInit\|String\)
syn match   slrnSetNum	contained "^\s*set\s\+\S\+\s\+\-\=[0-9]\+\>" contains=slrn\(Set\|IdentNum\|Number\)
syn match   slrnSetLine	"^\s*set\s\+\S\+\s\+\S.*$" contains=slrnSet\(Str\|Num\),slrnComment

" various command like settings
syn region slrnCmdLine	matchgroup=slrnCmd start="^\s*\(server\|nnrpaccess\|hostname\|ignore_quotes\|scorefile\|interpret\|grouplens_add\)\>" matchgroup=NONE end="$" contains=slrn\(String\|Comment\) transparent oneline

" color definitions
syn keyword slrnColorObj	contained article author cursor description error group
syn keyword slrnColorObj	contained grouplens_display header_name header_number headers
syn keyword slrnColorObj	contained high_score menu menu_press normal quotes response_char
syn keyword slrnColorObj	contained signature status subject thread_number tilde tree 
syn match   slrnColorVal	contained +\<\(bright\)\=\(black\|blue\|brown\|cyan\|green\|magenta\|red\|white\|yellow\)+
syn match   slrnColorVal	contained +"\(bright\)\=\(black\|blue\|brown\|cyan\|green\|magenta\|red\|white\|yellow\)"+
" mathcing a function with three arguments
syn keyword slrnColor		contained color	nextgroup=slrnColorObj
syn match   slrnColorInit	contained "^\s*color\s\+\S\+" contains=slrnColor\(Obj\)\=
syn match   slrnColorLine	"^\s*color\s\+\S\+\s\+\S\+\s\+\S\+" contains=slrnColor\(Init\|Val\)

" mono settings
syn keyword slrnMonoVal	contained blink bold none reverse underline
syn match   slrnMonoVal	contained +"\<\(blink\|bold\|none\|reverse\|underline\)"+
" color object is inherited
" mono takes at least one arguments
syn keyword slrnMono		contained mono nextgroup=slrnColorObj
syn match   slrnMonoInit	contained "^\s*mono\s\+\S\+" contains=slrnMono,slrnColorObj
syn match   slrnMonoLine	"^\s*mono\s\+\S\+\s\+\S.*" contains=slrnMono\(Init\|Val\),slrnComment

" key bindings
syn keyword slrnSetkeyObj	contained article group readline
syn keyword slrnSetkey	contained setkey nextgroup=slrnSetkeyObj
syn match   slrnSetkeyInit	contained "^\s*setkey\s\+\S\+" contains=slrnSetkey\(Obj\)\=
syn match   slrnSetkeyLine	"^\s*setkey\s\+\S\+\s\+\S\+" skipwhite nextgroup=slrnKey contains=slrnSetkeyInit

if !exists("did_slrn_syntax_inits")
  let did_slrn_syntax_inits = 1
  " The default methods for highlighting.  Can be overridden later
  hi link slrnTodo		Todo
  hi link slrnComment		Comment
  hi link slrnNumber		Number
  hi link slrnEmail		Special
  hi link slrnHost		Special
  hi link slrnSpecKey		SpecialChar
  hi link slrnKey		String
  hi link slrnSpecChar	SpecialChar
  hi link slrnString		String
  hi link slrnIdentNum	Identifier
  hi link slrnIdentStr	Identifier
  hi link slrnSet		Operator
  hi link slrnCmd		slrnSet
  hi link slrnColor		Keyword
  hi link slrnColorObj	Identifier
  hi link slrnColorVal	String
  hi link slrnMono		Keyword
  hi link slrnMonoObj		Identifier
  hi link slrnMonoVal		String
  hi link slrnSetkey		Keyword
  hi link slrnSetkeyObj	Identifier
endif

let b:current_syntax = "slrn"

"EOF	vim: ts=8 noet tw=120 sw=8 sts=0
