" Vim syntax file
" Language:	Mutt setup files (for v0.88)
" Maintainer:	Preben "Peppe" Guldberg (c928400@student.dtu.dk)
" Last change:	Sun Jan 18 02:01:44 1998

" Remove any old syntax stuff hanging around
syn clear

" String variables
syn keyword muttrcIdentString	alias_file  alternates  attach_sep  attribution  charset
syn keyword muttrcIdentString	date_format  decode_format  dsn_notify  dsn_return  editor
syn keyword muttrcIdentString	escape  forw_format  hdr_format  hostname  in_reply_to
syn keyword muttrcIdentString	indent_str  ispell  local_sig  local_site  locale
syn keyword muttrcIdentString	mailcap_path  mask  mbox_type  msg_format  pager  pager_format
syn keyword muttrcIdentString	pipe_sep  pop_host  pop_pass  pop_user  post_indent_str
syn keyword muttrcIdentString	postponed  print_cmd  quote_regexp  realname  record
syn keyword muttrcIdentString	remote_sig  reply_regexp  sendmail  sendmail_bounce  shell
syn keyword muttrcIdentString	signature  simple_search  sort  sort_aux  sort_browser
syn keyword muttrcIdentString	spoolfile  status_chars  status_format  tmpdir  to_chars
syn keyword muttrcIdentString	url_regexp  visual  web_browser
syn match   muttrcIdentString	"\<folder\>"
syn match   muttrcIdentString	"\<mbox\>"

" Number variables
syn keyword muttrcIdentNumber	history  pager_context  pager_index_lines  pop_port
syn keyword muttrcIdentNumber	read_inc  references  timeout  write_inc

" Boolean variables (noBoolean is not supported here - eg set nohelp)
syn keyword muttrcIdentBoolean	allow_8bit  arrow_cursor  ascii_chars  askbcc  askcc
syn keyword muttrcIdentBoolean	attach_split  autoedit  auto_tag  beep  check_new
syn keyword muttrcIdentBoolean	confirmappend  confirmcreate  edit_hdrs  fast_reply  fcc_attach
syn keyword muttrcIdentBoolean	force_name  forw_decode  hdrs  header  help  hold
syn keyword muttrcIdentBoolean	ignore_list_reply_to  mark_old  markers  metoo  mime_fwd
syn keyword muttrcIdentBoolean	pager_stop  pipe_decode  pipe_split  point_new  pop_delete
syn keyword muttrcIdentBoolean	prompt_after  read_only  resolve  reverse_alias  save_empty
syn keyword muttrcIdentBoolean	save_name  sig_dashes  smart_wrap  sort_re  status_on_top
syn keyword muttrcIdentBoolean	strict_threads  suspend  thorough_search  tilde  use_8bitmime
syn keyword muttrcIdentBoolean	use_domain  use_from  wait_key

" Quadoption variables (noQuadoption is not supported here - eg set nocopy)
syn keyword muttrcIdentQuadopt	abort_nosubject  abort_unmodified  copy  delete  include  move
syn keyword muttrcIdentQuadopt	postpone  print  recall  reply_to  use_mailcap  verify_sig

" The variables takes the following arguments
syn match   muttrcVarString	"=\s*[^ #\t"']\+"lc=1 contains=muttrcEscape
syn region  muttrcVarString	start=+=\=\s*"+ms=e skip=+\\"+ end=+"+ oneline contains=muttrcEscape
syn region  muttrcVarString	start=+=\=\s*'+ms=e skip=+\\'+ end=+'+ oneline contains=muttrcEscape
" Numbers and Quadoptions may be surrounded by " or '
syn match  muttrcVarNumber	/=\s*[0-9]\+/lc=1
syn match  muttrcVarNumber	/"=\s*[0-9]\+"/lc=1
syn match  muttrcVarNumber	/'=\s*[0-9]\+'/lc=1
syn match  muttrcVarQuadopt	+=\s*\(ask-\)\=\(yes\|no\)+lc=1
syn match  muttrcVarQuadopt	+"=\s*\(ask-\)\=\(yes\|no\)"+lc=1
syn match  muttrcVarQuadopt	+'=\s*\(ask-\)\=\(yes\|no\)'+lc=1

" Escape sequences (back-tick,`, shell-quote goes here too)
syn match  muttrcEscape		+\\[#tnr"']+
syn match  muttrcEscape		+`+

" Now catch some email addresses and headers (purified version from mail.vim)
syn match  muttrcEmail		"[a-zA-Z0-9._-]\+@[a-zA-Z0-9./-]\+"
syn match  muttrcHeader		"\(From:\|To:\|Cc:\|Bcc:\|Reply-To:\|Subject:\|Return-Path:\|Received:\|Date:\|Replied:\)"
" For those that prefer to specify without the colon
"syn match    muttrcHeader	"\(From\|To\|Cc\|Bcc\|Reply-To\|Subject\|Return-Path\|Received\|Date\|Replied\)"

" Some statements (a few have function like highlighting just below)
syn keyword  muttrcKeyword	set  unset
syn keyword  muttrcKeyword	auto_view  hdr_order  ignore  unignore  lists  unlists
syn keyword  muttrcKeyword	mailboxes  my_hdr  unmy_hdr  push  source  toggle  unalias

" Various hooks
syn match  muttrcHook		"\<\(fcc\|folder\|mbox\|save\|send\)-hook\>"

" Aliases contain a key word: let's show it
syn match   muttrcAliasLine	"alias\s\+\S\+" contains=muttrcAliasFill
syn region  muttrcAliasFill	contained transparent matchgroup=muttrcFunc start="\<alias\>" matchgroup=muttrcFuncKey end="\S\+"

" These are convinient to have defined for bind and macro
syn keyword  muttrcMap		contained index pager alias attach browser editor compose pgp url

" Bindings have map, key and function.
syn match   muttrcBindLine	"\s*bind\s\+\S\+\s\+\S\+" contains=muttrcBindFill
syn region  muttrcBindFill	contained transparent matchgroup=muttrcFunc start="\<bind\>"  skip="\<\(index\|pager\|alias\|attach\|browser\|editor\|compose\|pgp\|url\)\>" matchgroup=muttrcFuncKey end="\S\+" contains=muttrcMap

" Macros are more or less the same
syn match   muttrcMacroLine	"\s*macro\s\+\S\+\s\+\S\+" contains=muttrcMacroFill
syn region  muttrcMacroFill	contained transparent matchgroup=muttrcFunc start="\<macro\>" skip="\<\(index\|pager\|alias\|attach\|browser\|editor\|compose\|pgp\|url\)\>" matchgroup=muttrcFuncKey end="\S\+" contains=muttrcMap

" Colour definitions takes object, foreground and background arguments (regexps excluded).
syn keyword  muttrcColorObj	contained attachment  body  bold  error  header  hdrdefault
syn keyword  muttrcColorObj	contained indicator  markers  message  search  signature
syn keyword  muttrcColorObj	contained status  tilde  tree  underline
syn match    muttrcColorObj	"\<quoted[1-9]\=\>"
syn match    muttrcColorFG	contained "\<\(bright\)\=\(white\|black\|green\|magenta\|blue\|cyan\|yellow\|red\|default\)\>"
syn match    muttrcColorFG	contained "\<\(bright\)\=color[0-9]\{1,2}\>"
syn match    muttrcColorBG	contained "\<\(white\|black\|green\|magenta\|blue\|cyan\|yellow\|red\|default\)\>"
syn match    muttrcColorBG	contained "\<color[0-9]\{1,2}\>"
" Now for the total match
syn match    muttrcColorLine	"\s*color\s\+\S\+\s\+\(bright\)\=\S\+\s\+\S\+" contains=muttrcColor\(Fill\|FG\|BG\)
syn region   muttrcColorFill	contained matchgroup=muttrcColor start="\<color\>" matchgroup=muttrcColorObj end="\<\(attachment\|body\|bold\|error\|header\|hdrdefault\|indicator\|markers\|message\|normal\|quoted[0-9]\=\|search\|signature\|status\|tilde\|tree\|underline\)\>"

" Mono are almst like color (ojects ingherited from color)
syn keyword  muttrcMonoAttrib	contained none  bold  underline  reverse  standout
syn match    muttrcMonoLine	"\s*mono\s\+\S\+\s\+\S\+" contains=muttrcMono\(Fill\|Attrib\)
syn region   muttrcMonoFill	contained matchgroup=muttrcMono start="\<mono\>" matchgroup=muttrcMonoObj end="\<\(attachment\|body\|bold\|error\|header\|hdrdefault\|indicator\|markers\|message\|normal\|quoted[0-9]\=\|search\|signature\|status\|tilde\|tree\|underline\)\>"

" comments are quite easy here: a # that is not preceded by a \
syn match  muttrcComment	"^#.*$"
syn match  muttrcComment	"[^\\]#.*$"lc=1

if !exists("did_muttrc_syntax_inits")
  let did_muttrc_syntax_inits = 1
  " The default methods for highlighting.  Can be overridden later
  hi link muttrcKeyword		Keyword
  hi link muttrcHook		Keyword
  hi link muttrcIdentString	Identifier
  hi link muttrcIdentNumber	Identifier
  hi link muttrcIdentBoolean	Identifier
  hi link muttrcIdentQuadopt	Identifier
  hi link muttrcVarString	String
  hi link muttrcVarNumber	Number
  hi link muttrcVarQuadopt	Boolean
  hi link muttrcComment		Comment
  hi link muttrcEscape		SpecialChar
  hi link muttrcEmail		String
  hi link muttrcHeader		Type
  hi link muttrcMap		Identifier
  hi link muttrcFunc		Keyword
  hi link muttrcFuncKey		Type
  hi link muttrcColor		Keyword
  hi link muttrcColorObj	Identifier
  hi link muttrcColorFG		String
  hi link muttrcColorBG		String
  hi link muttrcMono		Keyword
  hi link muttrcMonoObj		Identifier
  hi link muttrcMonoAttrib	String
  hi link muttrcStrError	Error
endif

"EOF	vim: ts=8 noet tw=100 sw=8 sts=0
