" Vim syntax file
" Language:   PROLOG
" Maintainers:   Ralph Becket <rwab1@cam.sri.co.uk>,
"                Thomas Koehler <jean-luc@picard.franken.de>
" Last change:   1997 December 28

" There are two sets of highlighting in here:
" If the "prolog_highlighting_clean" variable exists, it is rather sparse.
" Otherwise you get more highlighting.

" Remove any old syntax stuff hanging around.
syn clear

" Prolog is case sensitive.
syn case match

" Very simple highlighting for comments, clause heads and
" character codes.  It respects prolog strings and atoms.

syn region   prologCComment     start=+/\*+ end=+\*/+
syn match    prologComment      +%.*+

syn keyword  prologKeyword      module meta_predicate multifile dynamic
syn match    prologCharCode     +0'\\\=.+
syn region   prologString       start=+"+ skip=+\\"+ end=+"+
syn region   prologAtom         start=+'+ skip=+\\'+ end=+'+
syn region   prologClauseHead   start=+^[a-z][^(]*(+ end=+:-\|\.\|-->+

if !exists("prolog_highlighting_clean")

  " some keywords
  " some common predicates are also highlighted as keywords
  " is there a better solution?
  syn keyword prologKeyword var atom integer float atomic compound
  syn keyword prologKeyword nonvar number functor arg copy_term
  syn keyword prologKeyword is unify_with_occurs_check clause
  syn keyword prologKeyword current_predicate asserta assertz
  syn keyword prologKeyword retract abolish findall bagof setof
  syn keyword prologKeyword current_input current_output set_input
  syn keyword prologKeyword set_output open close flush_output
  syn keyword prologKeyword stream_property at_end_of_stream
  syn keyword prologKeyword set_stream_position get_char get_code
  syn keyword prologKeyword peek_char peek_code put_char put_code nl
  syn keyword prologKeyword get_byte peek_byte put_byte read_term read
  syn keyword prologKeyword write_term write writeq write_canonical
  syn keyword prologKeyword op current_op char_conversion
  syn keyword prologKeyword current_char_conversion once repeat
  syn keyword prologKeyword atom_length atom_concat sub_atom
  syn keyword prologKeyword atom_chars atom_codes char_code number_chars
  syn keyword prologKeyword number_codes set_prolog_flag current_prolog_flag
  syn keyword prologKeyword halt true fail call throw catch append

  syn match   prologOperator "=\\=\|=:=\|\\==\|=<\|==\|>=\|\\=\|\\+\|<\|>\|="
  syn match   prologAsIs     "===\|\\===\|<=\|=>"

  syn match   prologNumber            "\<[0123456789]*\>"
  syn match   prologCommentError      "\*/"
  syn match   prologSpecialCharacter  ";"
  syn match   prologSpecialCharacter  "!"
  syn match   prologQuestion          "?-.*\."  contains=prologNumber


endif

syn sync ccomment maxlines=50

if !exists("did_prolog_syntax_inits")

  let did_prolog_syntax_inits = 1

  " The default methods for highlighting.  Can be overridden later

  hi link prologComment    Comment
  hi link prologCComment   Comment
  hi link prologCharCode   Special

  if exists ("prolog_highlighting_clean")

    hi link prologKeyword      Statement
    hi link prologClauseHead   Statement

  else

    hi link prologKeyword          Keyword
    hi link prologClauseHead       Constant
    hi link prologQuestion         PreProc
    hi link prologSpecialCharacter Special
    hi link prologNumber           Number
    hi link prologAsIs             Normal
    hi link prologCommentError     Error
    hi link prologAtom             String
    hi link prologString           String
    hi link prologOperator         Operator

  endif

endif

let b:current_syntax = "prolog"

" vim: ts=8
