" Vim syntax file
" Language:	Mutt setup files
" Created by:   Preben "Peppe" Guldberg (c928400@student.dtu.dk)
" Last change:  Tue Jan  6 23:04:59 1998
"
" This file is made according to the manual (html format) that came 
" with the distribution of Mutt 0.88
"
" Latest version available at:
"		http://www.student.dtu.dk/~c928400/vim/syntax/muttrc.vim
" -------------------------------------------------------------------------

" History:
"
" Created:	971226
" Version:	Mutt v0.88e
"
" - Entered all the variables, RHS's such as strings, numbers and quadoptions
" - Escaped characters as \#, \", \', \n (newline), \r (return) and \t (tab)
"   within strings aswell as `)
" - Added various keywords as set, unset, push etc.
" - Function like high lighting of alias, bind, macro, color and mono
" - Detection of correct color objects and colour/mono attributes
" - detection of correct menus in bind and macro
" - Comments are treated too
" [971227]
"
" - Corrected error when comments started where a value was expected
"   Eg. "set reply_regexp = # NONE"
" - Cleaned the internal groups a bit. Made the function like matches start in 
"   muttrcFunc and a end in muttrcKey. Removed an unnescessary contain for color/mono
" [980106]
"
" TODO:	Correct mistreated mbox and folder-hooks
"	Introduce "no" and "inv" prefixes to booleans and quadoptions
"	- Can this be done any other way than setting the kwywords?
"	Add high lighting for regexps

" Remove any old syntax stuff hanging around
syn clear

" Case is matched
syn case match

" There are plenty of variables: strings, numbers, boolean and quadoptions
" String variables:
syn keyword muttrcIdentString	alias_file  alternates  attach_sep  attribution
syn keyword muttrcIdentString	charset
syn keyword muttrcIdentString	date_format  decode_format  dsn_notify  dsn_return
syn keyword muttrcIdentString	editor  escape
syn keyword muttrcIdentString	folder  forw_format
syn keyword muttrcIdentString	hdr_format  hostname
syn keyword muttrcIdentString	in_reply_to  indent_str  ispell
syn keyword muttrcIdentString	local_sig  local_site  locale
syn keyword muttrcIdentString	mailcap_path  mask  mbox  mbox_type  msg_format
syn keyword muttrcIdentString	pager  pager_format  pipe_sep  pop_host  pop_pass
syn keyword muttrcIdentString	pop_user  post_indent_str  postponed  print_cmd
syn keyword muttrcIdentString	quote_regexp
syn keyword muttrcIdentString	realname  record  remote_sig  reply_regexp
syn keyword muttrcIdentString	sendmail  sendmail_bounce  shell  signature
syn keyword muttrcIdentString	simple_search  sort  sort_aux  sort_browser
syn keyword muttrcIdentString	spoolfile  status_chars  status_format
syn keyword muttrcIdentString	tmpdir  to_chars
syn keyword muttrcIdentString	url_regexp
syn keyword muttrcIdentString	visual
syn keyword muttrcIdentString	web_browser

" Number variables
syn keyword muttrcIdentNumber	history
syn keyword muttrcIdentNumber	pager_context  pager_index_lines  pop_port
syn keyword muttrcIdentNumber	read_inc  references
syn keyword muttrcIdentNumber	timeout
syn keyword muttrcIdentNumber	write_inc

" Boolean variables (noBoolean is not supported here - eg set nohelp)
syn keyword muttrcIdentBoolean	allow_8bit  arrow_cursor  ascii_chars
syn keyword muttrcIdentBoolean	askbcc  askcc  attach_split  autoedit  auto_tag
syn keyword muttrcIdentBoolean	beep
syn keyword muttrcIdentBoolean	check_new  confirmappend  confirmcreate
syn keyword muttrcIdentBoolean	edit_hdrs
syn keyword muttrcIdentBoolean	fast_reply  fcc_attach  force_name  forw_decode
syn keyword muttrcIdentBoolean	hdrs  header  help  hold
syn keyword muttrcIdentBoolean	ignore_list_reply_to
syn keyword muttrcIdentBoolean	mark_old  markers  metoo  mime_fwd
syn keyword muttrcIdentBoolean	pager_stop  pipe_decode  pipe_split
syn keyword muttrcIdentBoolean	point_new  pop_delete  prompt_after
syn keyword muttrcIdentBoolean	read_only  resolve  reverse_alias
syn keyword muttrcIdentBoolean	save_empty  save_name  sig_dashes  smart_wrap
syn keyword muttrcIdentBoolean	sort_re  status_on_top  strict_threads  suspend
syn keyword muttrcIdentBoolean	thorough_search  tilde
syn keyword muttrcIdentBoolean	use_8bitmime  use_domain  use_from
syn keyword muttrcIdentBoolean	wait_key

" Quadoption variables (noQuadoption is not supported here - eg set nocopy)
syn keyword muttrcIdentQuadopt	abort_nosubject  abort_unmodified
syn keyword muttrcIdentQuadopt	copy
syn keyword muttrcIdentQuadopt	delete
syn keyword muttrcIdentQuadopt	include
syn keyword muttrcIdentQuadopt	move
syn keyword muttrcIdentQuadopt	postpone  print
syn keyword muttrcIdentQuadopt	recall  reply_to
syn keyword muttrcIdentQuadopt	use_mailcap
syn keyword muttrcIdentQuadopt	verify_sig

" The variables takes the following arguments
" Strings may 	- be one WORD, without spaces, with or without quotes
"		- be quoted with either " or '
"		- Qouted with or without = (eg set vs macro)
"		- contain the Escape sequences created below (incl \")
syn match  muttrcVarString	"=\s*[^ #\t"']\+"ms=s+1 contains=muttrcEscape
syn region muttrcVarString	start=+=\=\s*"+ms=e skip=+\\"+ end=+"+ oneline contains=muttrcEscape
syn region muttrcVarString	start=+=\=\s*'+ms=e skip=+\\'+ end=+'+ oneline contains=muttrcEscape
" Numbers and Quadoptions may be surrounded by " or '
syn match  muttrcVarNumber	/=\s*[0-9]\+/ms=s+1
syn match  muttrcVarNumber	/"=\s*[0-9]\+"/ms=s+1
syn match  muttrcVarNumber	/'=\s*[0-9]\+'/ms=s+1
syn match  muttrcVarQuadopt	+=\s*\(ask-\)\=\(yes\|no\)+ms=s+1
syn match  muttrcVarQuadopt	+"=\s*\(ask-\)\=\(yes\|no\)"+ms=s+1
syn match  muttrcVarQuadopt	+'=\s*\(ask-\)\=\(yes\|no\)'+ms=s+1

" Lets try and high light those escape sequences (back-tick,`, shell-quote goes here too)
syn match muttrcEscape		+\\[#tnr"']+
syn match muttrcEscape		+`+

" Now catch some email addresses and headers (purified version from mail.vim)
syn match muttrcEmail 		"[a-zA-Z0-9._-]\+@[a-zA-Z0-9./-]\+"
syn match muttrcHeader		"\(From:\|To:\|Cc:\|Bcc:\|Reply-To:\|Subject:\|Return-Path:\|Received:\|Date:\|Replied:\)"
" For those that prefer to specify without the colon
"syn match    muttrcHeader	"\(From\|To\|Cc\|Bcc\|Reply-To\|Subject\|Return-Path\|Received\|Date\|Replied\)"

" Some statements (a few have function like highlighting just below)
syn keyword muttrcKeyword	set  unset
syn keyword muttrcKeyword	unalias  auto_view  lists  unlists  mailboxes
syn keyword muttrcKeyword	push  toggle  source
" These might get function like higlighting too (all header based)
syn keyword muttrcKeyword	ignore  unignore  hdr_order  my_hdr  unmy_hdr

" These are convinient to have defined for bind and macro
syn keyword muttrcMap		contained index  pager  alias  attach  browser
syn keyword muttrcMap		contained editor  compose  pgp  url

" folder and mbox hooks are not correct as mbox and folder above are Keywords
syn match muttrcHook 	"\(fcc\|folder\|mbox\|save\|send\)-hook"

" Aliases contain a key word: let's show it
syn match  muttrcAliasLine	"alias\s\+\S\+" contains=muttrcAliasFill
syn region muttrcAliasFill	contained transparent matchgroup=muttrcFunc start="\<alias\>" matchgroup=muttrcFuncKey end="\S\+"

" Bindings have map, key and function. I only made the index and pager maps -
" the others are seldom mapped, I think. Functions are omitted - too many.
" Functions, however, are quite easily included:
" 	- add an extra "\s\+\S\+" group in muttrcBindLine
"	- add contains=muttrcFunGeneral (and others) to muttrcBindLine
" 	- make the muttrcFunGeneral (and other) group as a contained group
" 	- possibly split muttrcBindLine in to parts from pager/index/...
syn match  muttrcBindLine	"\s*bind\s\+\S\+\s\+\S\+" contains=muttrcBindFill
syn region muttrcBindFill	contained transparent matchgroup=muttrcFunc start="\<bind\>"  skip="\<\(index\|pager\|alias\|attach\|browser\|editor\|compose\|pgp\|url\)\>" matchgroup=muttrcFuncKey end="\S\+" contains=muttrcMap

" Macros are more or less the same - split up for easier rewrite if needed
syn match  muttrcMacroLine	"\s*macro\s\+\S\+\s\+\S\+" contains=muttrcMacroFill
syn region muttrcMacroFill	contained transparent matchgroup=muttrcFunc start="\<macro\>" skip="\<\(index\|pager\|alias\|attach\|browser\|editor\|compose\|pgp\|url\)\>" matchgroup=muttrcFuncKey end="\S\+" contains=muttrcMap

" Colour definitions takes object, foreground and background
" arguments (as " well as a possible regexp arg).
" Objects first
syn keyword muttrcColorObj	contained attachment body bold error header
syn keyword muttrcColorObj	contained hdrdefault indicator markers
syn keyword muttrcColorObj	contained message normal search signature
syn keyword muttrcColorObj	contained status tilde tree underline
" Ten quoting levels ought to be enough :-)
syn match   muttrcColorObj	"\<quoted[1-9]\=\>"
" Now the colours (color00-99 should do it)
syn match   muttrcColorFG	contained "\<\(bright\)\=\(white\|black\|green\|magenta\|blue\|cyan\|yellow\|red\|default\)\>"
syn match   muttrcColorFG	contained "\<\(bright\)\=color[0-9]\{1,2}\>"
syn match   muttrcColorBG	contained "\<\(white\|black\|green\|magenta\|blue\|cyan\|yellow\|red\|default\)\>"
syn match   muttrcColorBG	contained "\<color[0-9]\{1,2}\>"
" Now for the total match
syn match   muttrcColorLine 	"\s*color\s\+\S\+\s\+\(bright\)\=\S\+\s\+\S\+" contains=muttrcColor\(Fill\|FG\|BG\)
syn region  muttrcColorFill	contained matchgroup=muttrcColor start="\<color\>" matchgroup=muttrcColorObj end="\<\(attachment\|body\|bold\|error\|header\|hdrdefault\|indicator\|markers\|message\|normal\|quoted[0-9]\=\|search\|signature\|status\|tilde\|tree\|underline\)\>" 

" Mono settings are quite the same as colours. Let's hit it.
" The objects are inherited from colour settings.
syn keyword muttrcMonoAttrib	contained none bold underline reverse standout
syn match   muttrcMonoLine 	"\s*mono\s\+\S\+\s\+\S\+" contains=muttrcMono\(Fill\|Attrib\)
syn region  muttrcMonoFill	contained matchgroup=muttrcMono start="\<mono\>" matchgroup=muttrcMonoObj end="\<\(attachment\|body\|bold\|error\|header\|hdrdefault\|indicator\|markers\|message\|normal\|quoted[0-9]\=\|search\|signature\|status\|tilde\|tree\|underline\)\>"

" comments are quite easy here: a # that is not preceded by a \
syn match muttrcComment		"^#.*$"
syn match muttrcComment		"[^\\]#.*$"lc=1

if !exists("did_muttrc_syntax_inits")
  let did_muttrc_syntax_inits = 1
  " The default methods for highlighting.  Can be overridden later
  hi link muttrcKeyword		Keyword
  hi link muttrcHook   		Keyword
  hi link muttrcIdentString	Identifier
  hi link muttrcIdentNumber	Identifier
  hi link muttrcIdentBoolean	Identifier
  hi link muttrcIdentQuadopt	Identifier
  hi link muttrcVarString	String
  hi link muttrcVarNumber	Number
  hi link muttrcVarQuadopt	Boolean
  hi link muttrcComment		Comment
  hi link muttrcEscape		SpecialChar
  hi link muttrcEmail		String
  hi link muttrcHeader		Type
  hi link muttrcMap 		Identifier
  hi link muttrcFunc		Keyword
  hi link muttrcFuncKey		Type
  hi link muttrcColor		Keyword
  hi link muttrcColorObj	Identifier
  hi link muttrcColorFG		String
  hi link muttrcColorBG		String
  hi link muttrcMono		Keyword
  hi link muttrcMonoObj		Identifier
  hi link muttrcMonoAttrib	String
  hi link muttrcStrError	Error
endif

" vim: ts=8 noet sts=0 tw=120
