unit ch_tex;

interface

uses
  crt, dos, ch_chess, ch_files, ch_parse;



procedure print_tex_moves(VAR f1: text; VAR game: gametype);

procedure print_tex(VAR f1: text; VAR game: gametype);

procedure short_print_tex_moves(VAR f1: text; VAR game: gametype);

procedure short_print_tex(VAR f1: text; VAR game: gametype);

implementation


procedure print_tex_moves(VAR f1: text; VAR game: gametype);
const
  max_line_len = 60;
var
  i : integer;
  linestr, tempstr, one_move : string;

begin
  linestr:=''; tempstr:='';
  writeln(f1);
  for i:=1 to game.numb_of_moves do
  begin
    tempstr:='';

    if (i mod 2)=1 then
    begin
      tempstr:=tempstr+'\move ';
    end;

    if (pos(game.move[i][length(game.move[i])],'QRBN')>0) then
    begin
      one_move:=game.move[i];
      insert('=',one_move,length(one_move));
      tempstr:=tempstr+one_move+' ';
    end
    else
    if (i mod 2)=1 then
      if game.move[i]='O-O' THEN
        tempstr := tempstr+'e1g1 '
      else if game.move[i]='O-O-O' THEN
        tempstr := tempstr+'e1c1 '
      else
        tempstr:=tempstr+game.move[i]+' '
    else
      if game.move[i]='O-O' THEN
        tempstr := tempstr+'e8g8 '
      else if game.move[i]='O-O-O' THEN
        tempstr := tempstr+'e8c8 '
      else
        tempstr:=tempstr+game.move[i]+' ';

    delete(tempstr,pos('-',tempstr),1);
    delete(tempstr,pos('x',tempstr),1);
    delete(tempstr,pos('R',tempstr),1);
    delete(tempstr,pos('N',tempstr),1);
    delete(tempstr,pos('B',tempstr),1);
    delete(tempstr,pos('K',tempstr),1);
    delete(tempstr,pos('Q',tempstr),1);
    delete(tempstr,pos('P',tempstr),1);
    if (i mod 2)=0 then
    begin
      linestr:=linestr+tempstr;
      writeln(f1,linestr);
      linestr := '';
      if (i mod 15) = 0 then begin
        writeln(f1);
        writeln(f1,'$$\showboard$$');
        writeln(f1);
      end;
    end
    else
      linestr:=linestr+tempstr;

  end;
  if (length(linestr)>0) and (length(linestr)<=11) then begin
    delete(linestr,1,5);
    linestr := '\ply'+linestr;
  end;
  writeln(f1,linestr);

  writeln(f1,'\begin{center}');
  if (game.result<>'') and (pos('L',game.result)=0) then
  begin
    if pos('1/2',game.result)=0 then
      writeln(f1,'':29,game.result)
    else
      writeln(f1,'':29,'1/2-1/2');
  end
  else
    writeln(f1,'H"angepartie');
  writeln(f1,'\end{center}');
  writeln(f1,'\vspace{3em}');
end;

procedure print_tex(VAR f1: text; VAR game: gametype);

begin
  writeln(f1);
  writeln(f1,'\begin{tabular}{l@{ : }l}');
  writeln(f1,'{\bf Event}  & {\em ?}\\');
  if game.place<>'' then begin
    if pos('\',game.place)>0 then game.place[pos('\',game.place)]:='-';
    writeln(f1,'{\bf Site}   & {\em ',game.place,'}\\');
  end;
  if game.year>0 then
    writeln(f1,'{\bf Date}   & {\em ',game.year,'.??.??}\\')
  else
    writeln(f1,'{\bf Date}   & {\em ????.??.??}\\');

  if game.round>0 then
    writeln(f1,'{\bf Round}  & {\em ',game.round,'}\\')
  else
    writeln(f1,'{\bf Round}  & {\em ??}\\');

  if game.w_name<>'' then begin
    if pos('\',game.w_name)>0 then game.w_name[pos('\',game.w_name)]:='-';
    writeln(f1,'{\bf White}  & {\em ',game.w_name,'}\\')
    end
  else
    writeln(f1,'{\bf White}  & {\em ????????????????}\\');

  if game.b_name<>'' then begin
    if pos('\',game.b_name)>0 then game.b_name[pos('\',game.b_name)]:='-';

    writeln(f1,'{\bf Black}  & {\em ',game.b_name,'}\\')
    end
  else
    writeln(f1,'{\bf Black}  & {\em ????????????????}\\');

  if game.result<>'' then
  begin
    write(f1,  '{\bf Result} & {\em ');
    if pos('1/2',game.result)>0 then
      writeln(f1,'1/2-1/2}\\')
    else
    if pos('1-0',game.result)>0 then
      writeln(f1,'1-0}\\')
    else
    if pos('0-1',game.result)>0 then
      writeln(f1,'0-1}\\')
    else
      writeln(f1,'*}\\');
  end
  else
    writeln(f1,'{\bf Result}  & {\em ???} \\');

  if game.nic_opening<>'' then
    writeln(f1,'{\bf NIC}    & {\em ',game.nic_opening,'}\\');

  writeln(f1,'\end{tabular}');
  writeln(f1);
  writeln(f1,'\begin{chess}');
  writeln(f1,'\newgame');
  print_tex_moves(f1, game);
  writeln(f1,'\end{chess}');
end;


procedure short_print_tex_moves(VAR f1: text; VAR game: gametype);
const
  max_line_len = 60;
var
  i : integer;
  linestr, tempstr, one_move : string;

begin
  linestr:=''; tempstr:='';
  writeln(f1);
  write(f1,'{\bf |');
  for i:=1 to game.numb_of_moves do
  begin
    tempstr:='';

    if (i mod 2)=1 then
    begin
      str(i div 2 +1, tempstr);
      tempstr:=tempstr+'. ';
    end;

    if (pos(game.move[i][length(game.move[i])],'QRBN')>0) then
    begin
      one_move:=game.move[i];
      insert('=',one_move,length(one_move));
      tempstr:=tempstr+one_move+' ';
    end
    else
      if (i mod 2)=1 then
        if game.move[i]='O-O' THEN
          tempstr := tempstr+'0-0, '
        else if game.move[i]='O-O-O' THEN
          tempstr := tempstr+'0-0-0, '
        else begin
          tempstr:=tempstr+game.move[i]+', ';
          delete(tempstr,pos('-',tempstr),1);
          end
      else
        if game.move[i]='O-O' THEN
          tempstr := tempstr+'0-0 '
        else if game.move[i]='O-O-O' THEN
          tempstr := tempstr+'0-0-0 '
        else begin
          tempstr:=tempstr+game.move[i]+' ';
          delete(tempstr,pos('-',tempstr),1);
        end;


    IF (pos('x',tempstr)>0) then
      tempstr[pos('x',tempstr)] := '*';

    delete(tempstr,pos('P',tempstr),1);
    if (i mod 2)=0 then
    begin
      linestr:=linestr+tempstr;
      write(f1,linestr);
      linestr := '';
      if (i mod 15) = 0 then begin
        writeln(f1);
      end;
    end
    else
      linestr:=linestr+tempstr;

  end;
  write(f1,linestr);
  write(f1,'|}');

  write(f1,'\hfill ');
  if (game.result<>'') and (pos('L',game.result)=0) then
  begin
    if pos('1/2',game.result)=0 then
      write(f1,game.result)
    else
      write(f1,'1/2-1/2');
  end
  else
    write(f1,'Unknown');
  writeln(f1,'\par');
  writeln(f1,'\vspace{3em}');
end;

procedure short_print_tex(VAR f1: text; VAR game: gametype);

begin
  writeln(f1);
  writeln(f1,'\begin{tabular}{l@{ : }l}');
(*  writeln(f1,'{\bf Event}  & {\em ?}\\');
  if game.place<>'' then begin
    if pos('\',game.place)>0 then game.place[pos('\',game.place)]:='-';
    writeln(f1,'{\bf Site}   & {\em ',game.place,'}\\');
  end;
  if game.year>0 then
    writeln(f1,'{\bf Date}   & {\em ',game.year,'.??.??}\\')
  else
    writeln(f1,'{\bf Date}   & {\em ????.??.??}\\');

  if game.round>0 then
    writeln(f1,'{\bf Round}  & {\em ',game.round,'}\\')
  else
    writeln(f1,'{\bf Round}  & {\em ??}\\');
*)
  if game.w_name<>'' then begin
    if pos('\',game.w_name)>0 then game.w_name[pos('\',game.w_name)]:='-';
    writeln(f1,'{\bf White}  & {\em ',game.w_name,'}\\')
    end
  else
    writeln(f1,'{\bf White}  & {\em ????????????????}\\');

  if game.b_name<>'' then begin
    if pos('\',game.b_name)>0 then game.b_name[pos('\',game.b_name)]:='-';

    writeln(f1,'{\bf Black}  & {\em ',game.b_name,'}\\')
    end
  else
    writeln(f1,'{\bf Black}  & {\em ????????????????}\\');

  if game.result<>'' then
  begin
    write(f1,  '{\bf Result} & {\em ');
    if pos('1/2',game.result)>0 then
      writeln(f1,'1/2-1/2}\\')
    else
    if pos('1-0',game.result)>0 then
      writeln(f1,'1-0}\\')
    else
    if pos('0-1',game.result)>0 then
      writeln(f1,'0-1}\\')
    else
      writeln(f1,'*}\\');
  end
  else
    writeln(f1,'{\bf Result}  & {\em ???} \\');

  if game.nic_opening<>'' then
    writeln(f1,'{\bf NIC}    & {\em ',game.nic_opening,'}\\');

  writeln(f1,'\end{tabular}');
  writeln(f1);
  writeln(f1,'\begin{chess}');
  writeln(f1,'\newgame');
  short_print_tex_moves(f1, game);
  writeln(f1,'\end{chess}');
end;

begin
end.

