'\"
'\" Copyright (c) 2006 ActiveState Software
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: platform.n,v 1.1 2006/12/05 18:46:59 andreas_kupries Exp $
'\" 
.so man.macros
.TH "platform" n 1.0.2 platform "Tcl Bundled Packages"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
platform \- System identification support code and utilities
.SH SYNOPSIS
.nf
\fBpackage require platform ?1.0.2?\fR
.sp
\fBplatform::generic\fR
\fBplatform::identify\fR
\fBplatform::patterns \fIidentifier\fR
.fi
.BE
.SH DESCRIPTION
.PP
The \fBplatform\fR package provides several utility commands useful
for the identification of the architecture of a machine running Tcl.
.PP
Whilst Tcl provides the \fBtcl_platform\fR array for identifying the
current architecture (in particular, the platform and machine
elements) this is not always sufficient. This is because (on Unix
machines) \fBtcl_platform\fR reflects the values returned by the
\fBuname\fR command and these aren't standardized across platforms and
architectures. In addition, on at least one platform (AIX) the
\fBtcl_platform(machine)\fR contains the CPU serial number.
.PP
Consequently, individual applications need to manipulate the values in
\fBtcl_platform\fR (along with the output of system specific
utilities) - which is both inconvenient for developers, and introduces
the potential for inconsistencies in identifying architectures and in
naming conventions.
.PP
The \fBplatform\fR package prevents such fragmentation - i.e., it
establishes a standard naming convention for architectures running Tcl
and makes it more convenient for developers to identify the current
architecture a Tcl program is running on.
.SH COMMANDS
.TP
\fBplatform::identify\fR
This command returns an identifier describing the platform the Tcl
core is running on. The returned identifier has the general format
\fIOS\fR-\fICPU\fR. The \fIOS\fR part of the identifier may contain
details like kernel version, libc version, etc., and this information
may contain dashes as well.  The \fICPU\fR part will not contain
dashes, making the preceding dash the last dash in the result.
.TP
\fBplatform::generic\fR
This command returns a simplified identifier describing the platform
the Tcl core is running on. In contrast to \fBplatform::identify\fR it
leaves out details like kernel version, libc version, etc. The
returned identifier has the general format \fIOS\fR-\fICPU\fR.
.TP
\fBplatform::patterns 	\fIidentifier\fR
This command takes an identifier as returned by
\fBplatform::identify\fR and returns a list of identifiers describing
compatible architectures.
.SH KEYWORDS
operating system, cpu architecture, platform, architecture
