/*
 * File:	string.h
 *
 * Author:	Ulli Horlacher (framstag@rus.uni-stuttgart.de)
 *
 * History:	
 * 
 *   12 Aug 95   Framstag	initial version
 *   29 Feb 96   Framstag	added streq and strneq macros
 *    5 May 96   Framstag	merged streq and strneq
 *   16 Jan 97   GNUish		added strerror
 *   11 Feb 97   GNUish		include_next replaced
 *   23 Feb 97   Framstag	renamed str* functions to str_*
 * 				added str_beq_nocase and str_neq_nocase
 *
 * Header-file of the extended string functions for the sendfile package,
 * which are not found in the standard C library.
 *
 * Copyright  1995-1997 Ulli Horlacher
 * This file is covered by the GNU General Public License
 */

#include <string.h>
#include "config.h"

/* Try to emulate GNUs include_next here */
/*
#if defined(HAVE_STRING_H)
  #include "/usr/include/string.h"
#else
  int strncasecmp(const char *, const char *, int);
#endif
*/

/* This seems to be true on SunOS 4.1.4 */
#ifndef NULL
  #define NULL (void *) 0
#endif
#if !defined(HAVE_STRERROR)
  char *strerror(int);
#endif

/* trim white spaces */
char *str_trim(char *);

/* transform string to upper case */
char *str_toupper(char *);

/* transform string to lower case */
char *str_tolower(char *);

/* match a simple pattern */
int simplematch(char *, char *, int);

/* string begin equal test */
int str_beq(const char *, const char *);

/* string equal test until length n, ignoring case */
int str_neq_nocase(const char *, const char *, int);

/* string begin equal test, ignoring case */
int str_beq_nocase(const char *, const char *);

/* string equal test */
#define str_eq(s1,s2) (strcmp((s1),(s2)) == 0)
/* #define streq(s1,s2) (strncmp((s1),(s2),(strlen(s1)<strlen(s2))?strlen(s1):strlen(s2))==0) */

/* This is a GNU extention to the libc */
#if !defined(HAVE_SNPRINTF) && defined(HAVE_STDARG_H)
  #include <stdarg.h>
  int snprintf(char *buf, size_t len, const char *format,...);
  int vsnprintf(char *buf, size_t len, const char *format, va_list ap);
#endif

#define MAXS(s) s,sizeof(s)-1
