#ifndef EC_INCL_EMSG_H
#define EC_INCL_EMSG_H
/* beginning of emsg.h */


	/* ecashlib public headers */
#include "emsg.fh"
#include "ecoinage.fh"
#include "emintid.fh"
#include "eamount.fh"
#include "epocket.fh"
#include "eaccid.fh"
#include "eaddr.fh"
#include "eerrno.fh"


	/* debug info headers */

#ifdef DC_DEBUG_INFO
#include "emsg.ih"
#endif





	/* EC_Msg Functions */


/*
 * Create a new EC_Msg.
 * parameters:
 *	msg_size: the size of the msg_contents data.
 *	msg_contents: a pointer to a block of a data of size msg_size
 *		containing the message contents.  EC_msg_new will make a
 *		copy of msg_contents, so you may free msg_contents after
 *		calling EC_msg_new().
 */
EC_EXPORT EC_Msg *EC_msg_new(UInt32 msg_size, const Byte *msg_contents_ptr);

/* Free an EC_Msg. */
EC_EXPORT EC_Errno EC_msg_free(EC_Msg *this_msg_ptr);

/*
 * Make a copy of a message.
 *
 * return values:
 *	pointer to the new EC_Msg on success, NULL pointer on failure.
 */
EC_EXPORT EC_Msg *EC_msg_dup(const EC_Msg *this_msg_lnk);

/*
 * Get the information about an EC_Msg that you need to know
 * in order to transmit the EC_Msg to another ecash
 * application.
 */
EC_EXPORT UInt32 EC_msg_get_size(const EC_Msg *this_msg_lnk);

EC_EXPORT Byte *EC_msg_get_contents(const EC_Msg *this_msg_lnk);

/* Get information about the type of message. */
EC_EXPORT EC_MsgType EC_msg_get_type(const EC_Msg *this_msg_lnk);



	/* EC_Msg Functions for asynchronous messages */

/*
 * "Asynchronous messages" are those messages which arrive as the 
 * start of a new conversation rather than as the continuation of
 * an existing conversation.  Currently all and only asynchronous 
 * messages are payments and payment requests.
 */


/*
 * Get the payment info from a payment EC_Msg.
 *
 * parameters:
 *	coinage_ptr_out: returns the coinage of the payment
 *	amount_out: returns the amount of the payment
 *	desc_str_out: returns the description string of the payment
 *	accID_out: returns the account ID that the payment is made to
 *
 * return values:
 *	standard EC_Errno
 *
 * notes:
 *	EC_msg_get_pay_info returns an error if called on an EC_Msg which 
 *	is not a payment.
 */
EC_EXPORT EC_Errno EC_msg_get_pay_info(const EC_Msg *this_msg_lnk, 
	EC_Coinage **coinage_ptr_out, EC_Amount *amount_out,
	char **desc_str_out, EC_AccountID *accID_out);

/*
 * Get the payment-request info from a payment-request EC_Msg.
 * Returns an error if called on an EC_Msg which is not a payment 
 * request.
 *
 * parameters:
 *	pocket_lnk: This is a pointer to a pocket which you are considering 
 *		using to pay.  Thus if the payment request includes requests 
 *		for multiple coinages EC_msg_get_payreq_info will return info 
 *		about the request which this pocket is capable of satisfying.
 *	accID_ptr_out: This is the accountID that the payment should be 
 *		made to.
 *	addr_ptr_out: This is the address the the payment should be made to.
 *		If there is no address (the EC_Address * is a NULL pointer),
 *		you are supposed to use the address from which the payment
 *		request originated.
 *	amount_out: the amount of the payment
 *	description_str_out: the description of the payment
 *		*!note it is not clear right now whether your payment must
 *		have a description string identical to this one, or whether
 *		you may put whatever description string you want in your
 *		payment.
 *
 * return values:
 *	standard EC_Errno
 */
EC_EXPORT EC_Errno EC_msg_get_payreq_info(const EC_Msg *this_msg_lnk, 
	EC_Pocket *pocket_lnk, EC_AccountID **accID_ptr_out,
	EC_Address **addr_ptr_out, EC_Amount *amount_out,
	char **desc_str_out);



/* end of emsg.h */
#endif

