"""
Author:            Arpad Kiss, sekter@mail.matav.hu
Modified:          1999.06.21.
Platform:          -
Description:       Tabs version 0.76
                   You can query the init parameters, but you cannot set them(except index,cancel,nexttab)
                   You can get the current tabindex with one of these ways: Tabs['index'] or Tabs.cget(index)
                   To activate another tab: Tabs['index']=newindex or Tabs.configure(index=newindex)
                   To reference the ith tab: Tabs[i] 
		   You can add tabs by the AppendTab method.
		   del Tabs[i]  or Tabs.RemoveTab(i)
		   All variables/functions begining with an underscore are considered as local. Don't set them from
                   outside of the class.
		   Tabstrip position can be TOP and BOTTOM.
		   <<TabClick-1>>, <<TabClick-3>> custom events
Todos:             tabsperrow is not used at the moment. 
                   Enabled/disabled/visible tab
                   The selected tab should be wider & higher than the others
                   Not selected tabcolor
"""



#Imports
#************************************************************************************************************
from Tkinter import *
from Tkinter import _cnfmerge
#************************************************************************************************************



#Constants
#************************************************************************************************************
ROUNDED = 'rounded'
SQUARE  = 'square'
#************************************************************************************************************



#
#************************************************************************************************************
class Tabs(Canvas):

    def __init__(self,
                 root=None,
		 captions=('first','second','third'),
		 tabsperrow=3,
		 tabstrip_positiom=TOP,
		 font='helvetica 10',
		 textcolor='black',
		 background='gray80',
		 borderwidth=2,
		 relief=RAISED,
		 tabgap=0,
		 index=0,
		 tabstyle=SQUARE,
		 **kw):
	Canvas.__init__(self,root,kw)
	#
	self._tabsperrow=tabsperrow
	self._tabstrip_positiom=tabstrip_positiom
	self._borderwidth=borderwidth
	self._relief=relief
	self._textcolor=textcolor
	self._font=font
	self.background=background
	self._tabgap=tabgap
	self._tabstyle=tabstyle
	self._tabs=[]
	self._len=0
	#
	self._top,self._left=1,1
	self._right=self.winfo_reqwidth()-2
	self._bottom=self.winfo_reqheight()-2
	self['borderwidth']=0
	#creating the border of the frames
	self._DrawFrameBorder()
	#
	for icap in captions:
	     self.AppendTab(icap)
	#raising the current tab
	self._index=min(max(0,index),len(captions)-1)
	#
	self.bind('<Configure>',self._Configure)
	self.bind('<ButtonPress-1>',self._TabClick1)
	self.bind('<ButtonPress-3>',self._TabClick3)
		       
    def __getitem__(self,i):
	if type(i)==type(1):
	    # it is an index of a frame
	    return self._tabs[i]['frame']
	else:
	    # it is a Tk property
	    return self.cget(i)
		       
    def __len__(self):
	return len(self._tabs)
	
    def configure(self,cnf={},**kw):
	if kw:
		kw = _cnfmerge((cnf,kw))
	else:
		kw=_cnfmerge(cnf)
	self._PreConfig(kw)
	Canvas.configure(self,kw)
	
    def cget(self,parKey):
	try:
	    return eval('self._'+parKey)
	except:
	    # this is not mine, call the parent
	    return Canvas.cget(self,parKey)
    
    #some properties have to been processed and  deleted, then the others are sent to Canvas
    def _PreConfig(self,kw):
	if kw.has_key('captions'):
	    del kw['captions']
	if kw.has_key('tabsperrow'):
	    del kw['tabsperrow']
	if kw.has_key('font'):
	    del kw['font']
	if kw.has_key('textcolor'):
	    del kw['textcolor']
	if kw.has_key('background'):
	    del kw['background']
	if kw.has_key('borderwidth'):
	    del kw['borderwidth']
	if kw.has_key('relief'):
	    del kw['relief']
	if kw.has_key('tabgap'):
	    del kw['tabgap']
	if kw.has_key('index'):
	    self._RaiseTab(kw['index'])
	    del kw['index']
	if kw.has_key('tabstyle'):
	    del kw['tabstyle']
	#next can be used in <<TabClick-1>> and  <<TabClick-3>> events
	if kw.has_key('cancel'):
	    self._cancel=kw['cancel']
	    del kw['cancel']
	if kw.has_key('clickedtab'):
	    self._clickedtab=kw['clickedtab']
	    del kw['clickedtab']

    def _Configure(self,event):
	newh=self.winfo_height()
	dy=newh-2-self._bottom
	self._right=self.winfo_width()-2
	self._bottom=newh-2
	tabstripheight=self._GetTabStripHeight()
	for ifrm in self._tabs:
	    self._ResizeFrame(ifrm['frame'])
	if self._tabstrip_positiom==BOTTOM:
	    #in this case we have to move it
	    if self._tabs:
		for itab in self._tabs:
		    self._tabs[0]['y2']=self._tabs[0]['y2']+dy
		    self._tabs[0]['y1']=self._tabs[0]['y1']+dy
		self.move('tabstrip',0,dy)
	self._DrawFrameBorder()
	self._RaiseTab(self._index)
	
    def _TabClick1(self,event):
	self.focus_set()
	ids=self.find_withtag(CURRENT)
	if len(ids)>0:
	    ItemID=ids[0]
	    tags=self.gettags(ItemID)
	    if tags[0][:3]=='tab':
		self._cancel=FALSE
		self._clickedtab=int(tags[0][3:])
		self.event_generate('<<TabClick-1>>')
		if not self._cancel:
		    self._RaiseTab(self._clickedtab)
	
    def _TabClick3(self,event):
	self.focus_set()
	ids=self.find_withtag(CURRENT)
	if len(ids)>0:
	    ItemID=ids[0]
	    tags=self.gettags(ItemID)
	    if tags[0][:3]=='tab':
		self._clickedtab=int(tags[0][3:])
		self.event_generate('<<TabClick-3>>')
	
    def _RaiseTab(self,ind=None):
	if ind==None: return
	if self._index!=None:
	    self.lower('tab'+str(self._index),ALL)
	    self._tabs[self._index]['frame'].lower()
	    self.itemconfigure('text'+str(self._index),font=self._font)
	self._index=ind
	self._tabs[self._index]['frame'].tkraise()
	self.tkraise('tab'+str(self._index),ALL)
	self.itemconfigure('text'+str(self._index),font=self._font+' bold')

    def AppendTab(self,caption=''):
	if self._tabs:
	    ileft=self._tabs[len(self._tabs)-1]['x2']+self._tabgap+self._borderwidth-1
	    itab=len(self._tabs)
	else:
	    ileft=self._left+1
	    itab=0
	    
	if self._tabstrip_positiom==TOP:
	    itopbottom=self._top
	    myanchor=NW
	    s=1
	else:
	    itopbottom=self._bottom
	    myanchor=SW
	    s=-1
	textID=self.create_text(ileft+self._borderwidth,itopbottom+s*self._borderwidth,text='   '+caption+'   ',font=self._font,fill=self._textcolor,anchor=myanchor,tags=('tab'+str(itab),'text'+str(itab),'tabstrip'))
	x1,y1,x2,y2=self.bbox(textID)
	#some correction
	if self._tabstrip_positiom==BOTTOM: 
	    y1=y1-self._borderwidth
	polID=self.create_polygon(x1+1,y1+1,x2-1,y1+1,x2-1,y2+self._borderwidth-1,x1+1,y2+self._borderwidth-1,tags=('tab'+str(itab),'tabstrip'),fill=self.background,outline=self.background)
	self.tkraise(textID,polID)
	for i in range(self._borderwidth):
	    tlc,brc=self._GetColors(i)
	    if self._tabstyle==ROUNDED:
		if self._tabstrip_positiom==TOP:
		    self.create_line(x1+1+i,y1-self._borderwidth+1+i,x2-1-i,y1-self._borderwidth+1+i,fill=tlc,tags=('tab'+str(itab),'tabstrip'))
		    self.create_line(x1-self._borderwidth+1+i,y1+1+i,x1-self._borderwidth+1+i,y2+i,fill=tlc,tags=('tab'+str(itab),'tabstrip'))
		    self.create_line(x2+self._borderwidth-1-i,y1+1+i,x2+self._borderwidth-1-i,y2+i,fill=brc,tags=('tab'+str(itab),'tabstrip'))
		    self.create_line(x1+1+i,y1-self._borderwidth+1+i,x1-self._borderwidth+1+i,y1+1+i,fill=tlc,tags=('tab'+str(itab),'tabstrip'))
		    self.create_line(x2-1-i,y1-self._borderwidth+1+i,x2+self._borderwidth-1-i,y1+1+i,fill=brc,tags=('tab'+str(itab),'tabstrip'))
		else:
		    self.create_line(x1+1+i,y2+self._borderwidth-1-i,x2-1-i,y2+self._borderwidth-1-i,fill=tlc,tags=('tab'+str(itab),'tabstrip'))
		    self.create_line(x1-self._borderwidth+1+i,y2-1-i,x1-self._borderwidth+1+i,y1+self._borderwidth-i,fill=tlc,tags=('tab'+str(itab),'tabstrip'))
		    self.create_line(x2+self._borderwidth-1-i,y2-1-i,x2+self._borderwidth-1-i,y1+self._borderwidth-i,fill=brc,tags=('tab'+str(itab),'tabstrip'))
		    self.create_line(x1+1+i,y2+self._borderwidth-1-i,x1-self._borderwidth+1+i,y2-1-i,fill=tlc,tags=('tab'+str(itab),'tabstrip'))
		    self.create_line(x2-1-i,y2+self._borderwidth-1-i,x2+self._borderwidth-1-i,y2-1-i,fill=brc,tags=('tab'+str(itab),'tabstrip'))		    
	    else:
		# SQUARE otherwise
		if self._tabstrip_positiom==TOP:
		    self.create_line(x1-self._borderwidth+1+i,y1-self._borderwidth+1+i,x2+self._borderwidth-1-i,y1-self._borderwidth+1+i,fill=tlc,tags=('tab'+str(itab),'tabstrip'))
		    self.create_line(x1-self._borderwidth+1+i,y1-self._borderwidth+1+i,x1-self._borderwidth+1+i,y2+i,fill=tlc,tags=('tab'+str(itab),'tabstrip'))
		    self.create_line(x2+self._borderwidth-1-i,y1-self._borderwidth+1+i,x2+self._borderwidth-1-i,y2+i,fill=brc,tags=('tab'+str(itab),'tabstrip'))
		else:
		    self.create_line(x1-self._borderwidth+1+i,y2+self._borderwidth-1-i,x2+self._borderwidth-1-i,y2+self._borderwidth-1-i,fill=brc,tags=('tab'+str(itab),'tabstrip'))
		    self.create_line(x1-self._borderwidth+1+i,y2+self._borderwidth-1-i,x1-self._borderwidth+1+i,y1+self._borderwidth-i,fill=tlc,tags=('tab'+str(itab),'tabstrip'))
		    self.create_line(x2+self._borderwidth-1-i,y2+self._borderwidth-1-i,x2+self._borderwidth-1-i,y1+self._borderwidth-i,fill=brc,tags=('tab'+str(itab),'tabstrip'))
	frm=Frame(self,bg=self.background,borderwidth=0)
	self._tabs.append({'x1' : x1, 'x2' : x2,'y1' : y1,'y2' : y2,'frame' : frm,'caption' : caption})
	self._len=self._len+1
	self.lower('tab%i' % (len(self._tabs,)-1),ALL)
	frm.lower()
	self.itemconfigure('text%i' % (len(self._tabs)-1,),font=self._font)
	self._ResizeFrame(frm)
	
    def __delitem__(self,index):
	if len(self._tabs)>0:
	    if index==len(self._tabs)-1:
		self._tabs[index]['frame'].destroy()
		del self._tabs[index]
		self.delete('tab%i' % index)
		if self._index==index:
		    if index>0:
			self._RaiseTab(index-1)
		    else:
			self._RaiseTab()			
	    else:
		dx=self._tabs[index+1]['x1']-self._tabs[index]['x1']
		self.delete('tab%i' % index) #I have to delete them before modify the others
		for i in range(index+1, len(self._tabs)):
		    self._tabs[i]['x1']=self._tabs[i]['x1']-dx
		    self._tabs[i]['x2']=self._tabs[i]['x2']-dx
		    self.move('tab%i' % i,-dx,0)
		    #order is important!
		    self.itemconfigure('text%i' % i,tags=('tab'+str(i-1),'text'+str(i-1),'tabstrip'))
		    self.itemconfigure('tab%i' % i,tags=('tab'+str(i-1),'tabstrip'))
		self._tabs[index]['frame'].destroy()
		del self._tabs[index]
		if self._index==index:
		    self._RaiseTab(index)

    RemoveTab=__delitem__
			
    def _DrawFrameBorder(self):
	self.delete('frameborder')
	tabstripheight=self._GetTabStripHeight()
	if self._tabstrip_positiom==TOP:
	    ftop=self._top+tabstripheight-self._borderwidth+1
	    fbottom=self._bottom
	else:
	    ftop=self._top
	    fbottom=self._bottom-tabstripheight+2*self._borderwidth-1
	for i in range(self._borderwidth):
	    tlc,brc=self._GetColors(i)
	    self.create_line(self._left+1+i,ftop+i,self._right-1-i,ftop+i,fill=tlc,tags=('frameborder',))
	    self.create_line(self._left+1+i,ftop+i,self._left+1+i,fbottom-1-i,fill=tlc,tags=('frameborder',))
	    self.create_line(self._right-1-i,ftop+i,self._right-1-i,fbottom-1-i,fill=brc,tags=('frameborder',))
	    self.create_line(self._right-1-i,fbottom-1-i,self._left+1+i,fbottom-1-i,fill=brc,tags=('frameborder',))

    # it returns (top-left color,bottom-right color) for ith line
    def _GetColors(self,i):
	if self._relief==FLAT:
	    if i==0:
		return ('gray90','gray35')
	    elif i==self._borderwidth-1:
		return ('gray35','gray90')
	    else:
		return ('gray55','gray55')
	elif self._relief==SOLID:
	    return ('gray55','gray55')
	elif self._relief==RAISED:
	    return ('gray90','gray55')
	elif self._relief==SUNKEN:
	    return ('gray55','gray90')
	elif self._relief==RIDGE:
	    if i+1<=float(self._borderwidth)/2:
		return ('gray90','gray55')
	    else:
		return ('gray55','gray90')
	elif self._relief==GROOVE:
	    if i+1<=float(self._borderwidth)/2:
		return ('gray55','gray90')
	    else:
		return ('gray90','gray55')
	else:
	    return ('gray90','gray55')

    def _ResizeFrame(self,frm):
	tabstripheight=self._GetTabStripHeight()
	if self._tabstrip_positiom==TOP:
	    frm.place(x=self._left+self._borderwidth+1,
	              y=self._top+tabstripheight+1,
		      width=self._right-self._left-2*self._borderwidth-1,
		      height=self._bottom-self._top-self._borderwidth-tabstripheight-1,
		      anchor=NW)
	else:
	    frm.place(x=self._left+self._borderwidth+1,
		      y=self._bottom-tabstripheight+self._borderwidth-1,
		      width=self._right-self._left-2*self._borderwidth-1,
		      height=self._bottom-self._top-tabstripheight-1,
		      anchor=SW)
		
    def _GetTabStripHeight(self):
	if self._tabs:
	    tabstripheight=self._tabs[0]['y2']-self._tabs[0]['y1']+self._borderwidth+1
	else:
	    tabstripheight=2*self._borderwidth+1
	return tabstripheight
    
    def Captions(self,i):
	return self._tabs[i]['caption']
#************************************************************************************************************



#Test
#************************************************************************************************************
def test():
    #<<TabClick-1>> event handler
    def Click1(event=None):
	from tkMessageBox import showinfo,showerror
	if event.widget['clickedtab']==1:
	    event.widget['cancel']=TRUE
	    showerror(title="'<<TabClick-1>>' event",message="'%s' is locked" %  event.widget.Captions(1))
	elif event.widget['clickedtab']>2:
	    showinfo(title="'<<TabClick-1>>' event",message="Instead of '%s' please use the '%s' tab" %  (event.widget.Captions(event.widget['clickedtab']),event.widget.Captions(2)))
	    event.widget['clickedtab']=2
	else:
	    showinfo(title="'<<TabClick-1>>' event",message="Active tab: '%s'\nNext tab: '%s'" %  (event.widget.Captions(event.widget['index']),event.widget.Captions(event.widget['clickedtab'])))
    #<<TabClick-3>> event handler
    def Click3(event=None):
	from tkMessageBox import showinfo,showerror
	showinfo(title="'<<TabClick-3>>' event",message="Right click on '%s'" %  event.widget.Captions( event.widget['clickedtab']))

    root=Tk()
    
    tbs=Tabs(root,captions=('FIRST','SECOND'),tabstrip_positiom=BOTTOM,relief=FLAT,borderwidth=4,tabgap=1,background='lightblue',textcolor='indianred',font='times 12',tabstyle=ROUNDED)
    e=Entry(tbs[0])
    e.insert(0,'caption of the new tab')
    e.pack(side=LEFT)
    #with this button you can append new tabs
    b=Button(tbs[0],text='AppendTab',command=lambda x=(tbs,e): x[0].AppendTab(x[1].get()))
    b.pack(side=LEFT)
    #with this button you can remove the 4. tab
    b=Button(tbs[0],text='Remove the 4. tab',command=lambda x=tbs: x.RemoveTab(3))
    b.pack(side=LEFT)
    #puts labels on the existing tabs
    for i in range(len(tbs)):
	Label(tbs[i],text=str(i+1)+'. tab').pack(side=LEFT)
    tbs.pack(fill=BOTH,expand=YES)
    tbs.bind('<<TabClick-1>>',Click1)
    tbs.bind('<<TabClick-3>>',Click3)
    tbs['index']=0
    
    root.mainloop()
    
    print tbs.cget('index'),tbs['index']
    
if __name__=='__main__':
    test()
