"""List Of Values Widget"""
#************************************************************************************************************
# Author:            rpd Kiss, arpadk@geometria.hu
# Modified:          1998.10.27
# Platform:          -
# Description:       List of Values widget, version 0.55
#                    With cget you can get the values of value,mandatory,value_error,value_error_details,
#                    itemkey and others coming from Entry widget.
#                    With configure you can set value, mandatory, validate_function and the properties of Entry( except
#                    'state', with it you set the 'state' of the Entry and the Button)
#                    Validation occurs automaticly when you leave the field, but it doesn't occur when you set
#                    the value(if you use it for browsing a database table it doesn't find the itemkey and validate it 
#                    when you move to another record; this provides better performance). So you have to call the Validate
#                    method after value setting if you want to refresh the value_error, value_erro_details and set 
#                    the state_args. At the end of the __init__ method Validate is called automaticly.
#                    All variables/functions begining with an underscore are considered as local. Don't set them from
#                    outside of the class.
#
# Todos:             Upper case and lower case conversion for accented characters doesn't work. 
#                    Setting the window size of the LOVListbox is missing.
#************************************************************************************************************



#Imports
#************************************************************************************************************
from Tkinter     import *
import string

#from lang        import *
#from tools       import *
#************************************************************************************************************



#Constants
#************************************************************************************************************
#************************************************************************************************************


	    
#
# List of values control
# value returns the value of the StringEntry(it must be string)
# itemkey returns any value associated to the value(usually it is a key)
# this class is the entry part of the LOV
#************************************************************************************************************
class LOVEntry(Frame):

    def __init__(self,parent,state_args,lov_values,lov_kw={},**kw):
	self._value=StringVar()     #value in the entry
	self._mandatory=NO
	self._ValidateFunction=lambda x: TRUE
	self._error_messages=((0,0,'This field is mandatory!'),
	                      (0,1,"This text doesn't exist in the list!")) #((0,error number,error text),..); the first number is 1 if this message come from self._ValidateFunction
	self._value_error_details=None
	self._itemkey=None         #value associated to self._value
	self._parent=parent
	self._enabled_args,self._disabled_args,self._error_args=state_args
	self._lov_values=lov_values   #this class instance must have a GetTupleList(Filtervalue) method that returns [(key,text),...]
	self._lov_kw=lov_kw       #attributes of LOVListbox
	Frame.__init__(self,parent,borderwidth=0)
	self._ent=Entry(self)
	self._bmp=BitmapImage(data='#define bmp_width 16'+chr(10)+
	                           '#define bmp_height 16'+chr(10)+
				   'static char bmp_bits[] = {'+chr(10)+
				   '0x0, 0x0, 0xc0, 0x3, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x40, 0x2, 0x7c, 0x3e, 0x8, 0x10, 0x10, 0x8, 0x20, 0x4, 0x40, 0x2, 0x80, 0x1, 0xfc, 0x3f, 0x0, 0x0};',
			      background='')
	tmpheight=self.winfo_reqheight()
	self._btn=Button(self,text='V',command=self._LookUp,takefocus=NO,relief=GROOVE,image=self._bmp,height=tmpheight)
	self._ent['textvariable']=self._value
	self._btn['cursor']='arrow'
	self._ent.pack(side=LEFT,expand=YES,fill=BOTH)
	self._btn.pack(side=LEFT,fill=BOTH)
	self.configure(kw)
	self.Validate()
	#binds
	self._ent.bind("<Return>", self._LookUp)
        self._ent.bind("<Double-1>", self._LookUp)
        self.bind("<FocusOut>", self._FocusOut)
	
    def configure(self,p={},**kw):
	#preprocessing the class specific properties
	self._PreConfig(p,kw)
	for k,v in p.items():
	    kw[k]=v
	# if we come from self._SetState then we have to delete the 'From_SetState' key
	# and after configuring the self._ent we have to call the self._SetState if 'state' is a key in kw/p, this occurs
	# when you set the 'state' property outside of this class(and we have to aply the state_args)
	From_SetState=FALSE
	if kw.has_key('From_SetState'):
	    del kw['From_SetState']
	    From_SetState=TRUE
	if p.has_key('From_SetState'):
	    del p['From_SetState']
	    From_SetState=TRUE
	self._ent.configure(kw)
	if not From_SetState and (kw.has_key('state') or p.has_key('state')): self._SetState()

    #preprocessing the class specific properties
    def _PreConfig(self,p,kw):
	if kw.has_key('value'):
	    self._value.set(str(kw['value']))
	    self._itemkey=None
	    self._value_error_details=None
	    del kw['value']
	if p.has_key('value'):
	    self._value.set(str(p['value']))
	    self._itemkey=None
	    self._value_error_details=None
	    del p['value']	
	if kw.has_key('mandatory'):
	    self._mandatory=kw['mandatory']
	    del kw['mandatory']
	if p.has_key('mandatory'):
	    self._mandatory=p['mandatory']
	    del p['mandatory']
	if kw.has_key('validate_function'):
	    self._ValidateFunction=kw['validate_function']
	    del kw['validate_function']
	if p.has_key('validate_function'):
	    self._ValidateFunction=p['validate_function']
	    del p['validate_function']
	if kw.has_key('error_messages'):
	    self._error_messages=kw['error_messages']
	    del kw['error_messages']
	if p.has_key('error_messages'):
	    self._error_messages=p['error_messages']
	    del p['error_messages']
	#we have to set the 'state' of the button too
	if kw.has_key('state'):
	    self._btn['state']=kw['state']
	if p.has_key('state'):
	    self._btn['state']=kw['state']
	    
    def cget(self,parName):
	if parName=='value':
	    if len(string.strip(self._value.get()))==0:
		return None
	    else:
		return self._value.get()
	elif parName=='mandatory':
	    return self._mandatory
	elif parName=='value_error':
	    return self._value_error_details!=None
	elif parName=='value_error_details':
	    return self._value_error_details
	elif parName=='itemkey':
	    return self._GetItemKey()
	else:
	    return self._ent.cget(parName)

    __getitem__=cget

    # this shows the LOVListbox 
    def _LookUp(self, event=None):
	if not self["state"]==DISABLED:
	    tmpLOV=LOVListbox(self)
	    if not tmpLOV._cancel:
		self._PreConfig({},{'value':tmpLOV._value})
		self._SetState()

    # we have to validate the value when leave this widget
    def _FocusOut(self, event=None):
	self.Validate()

    # aply the right state_args depend on the value of self['state']
    def _SetState(self):
	if self['state'] == NORMAL:
	    if self._value_error_details!=None:
		kw=self._error_args
	    else:
		kw=self._enabled_args
	else:
	    kw=self._disabled_args
	#in self.configure we check the existence of 'From_SetState' key
	# without it the self.configure(kw) may cause an infinitive recursion
	kw['From_SetState']=TRUE
	self.configure(kw)

    # getting the itemkey
    # it is useful when the list and the entry value come from database tables
    def _GetItemKey(self):
	try:
	    tmpTupleList=self._lov_values.GetTupleList(self._value.get())
	    if len(tmpTupleList) == 1:
		ikey,itext=tmpTupleList[0]
		self._value.set(itext)
		self._itemkey=ikey
		return ikey
	    for ikey,itext in tmpTupleList:
		if itext==self._value.get():
		    self._itemkey=ikey
		    return ikey
	    else:
		return None
	except:
	    return None
	    
    # it validates the value of the self._ent
    def Validate(self):
	try:
	    if self._mandatory and len(string.strip(self._ent.get()))==0:
		raise ValueError,self._error_messages[0]
	    if len(string.strip(self._ent.get()))>0 and self._GetItemKey() == None:
		raise ValueError,self._error_messages[1]
	    self._ValidateFunction(self)
	    self._value_error_details=None
	    self._SetState()
	    return TRUE
	except ValueError,instance:
	    self._value_error_details=instance
	    self._SetState()
	    return FALSE

#************************************************************************************************************



# it is the 'list' part of the LOV control
#************************************************************************************************************
class LOVListbox(Toplevel):
    
    def __init__(self,par_lov_parent):
	self._cancel=TRUE
	self._value=None
	self._lov_parent=par_lov_parent
	Toplevel.__init__(self, self._lov_parent._parent)
        self.transient(self._lov_parent._parent)
	self.overrideredirect(1) #no title
        self.geometry("%dx%d+%d+%d" % (self._lov_parent.winfo_width()-self._lov_parent._btn.winfo_width(),self._lov_parent.winfo_height()*5,self._lov_parent.winfo_rootx(),
                                       self._lov_parent.winfo_rooty()+self._lov_parent.winfo_height()))
	self._lst = Listbox(self,self._lov_parent._lov_kw)
	self._lst.pack(side=LEFT,expand=YES,fill=BOTH,padx=1,pady=1)
	#this fills the listbox
	i=0
	isel=0
	found=FALSE
	self['cursor']='watch'
	try:
	    tmpTupleList=self._lov_parent._lov_values.GetTupleList(self._lov_parent._value.get())
	    for ikey,itext in tmpTupleList:
	    	self._lst.insert(i,itext)
	    	if  self._lov_parent._value.get()<>'' and not found and string.lower(self._lov_parent._value.get())==string.lower(itext[:len(self._lov_parent._value.get())]):
		    isel=i
		    found=TRUE
	    	i=i+1
	finally:
	    self['cursor']='arrow'
	self._lst.select_set(isel) 
	self._lst.activate(isel)
	self._lst.yview(isel)
	if len(tmpTupleList)>int(self._lst['height']):
	    #the listbox has fewer lines than it has to show
	    #it needs scrollbar
	    self._vbar=Scrollbar(self,relief=GROOVE)
	    self._vbar.pack(side=LEFT,fill=Y,padx=1,pady=1)
	    self._lst['yscrollcommand']=self._vbar.set
	    self._vbar['command']=self._lst.yview
	    self.geometry("%dx%d" % (self._lov_parent.winfo_width()-self._lov_parent._btn.winfo_width()+self._vbar.winfo_reqwidth(),self.winfo_reqheight()))
	#binds
	self.bind("<Return>", self._Select)
        self.bind("<Escape>", self._Cancel)
        self.bind("<KeyPress>", self._KeyPress)
        self.bind("<FocusOut>", self._Cancel)
	self._lst.bind('<Double-1>', self._Select)
        self.protocol("WM_DELETE_WINDOW", self._Cancel)
	self._lst.focus_set()
	self.grab_set()
        self.wait_window(self)

    def _Select(self, event=None):
	self.withdraw()
        self.update_idletasks()
        self._value=self._lst.get(self._lst.index(ACTIVE))
	self._cancel=FALSE
        self._Cancel()

    def _Cancel(self, event=None):
	# put focus back to the parent window
        self._lov_parent._ent.focus_set()
        self.destroy()

    # if you press a key then this rutin select the first item begins with it
    def _KeyPress(self, event=None):
	if event.char in tuple(string.lowercase) or event.char in tuple(string.uppercase):
	    tmpup=string.upper(event.char)
	    tmplo=string.lower(tmpup)
	    for i in range(self._lst.index(END)):
	    	if  tmplo==self._lst.get(i)[:1] or tmpup==self._lst.get(i)[:1]:
		    self._lst.select_clear(self._lst.curselection())
		    self._lst.select_set(i) 
		    self._lst.activate(i)
		    self._lst.yview(i)
		    break
#************************************************************************************************************



#Test
#************************************************************************************************************
if __name__=='__main__':
    root=Tk()

    #it is a class that provide the list items
    #it is a simple one, but it could be based on a database
    class clsLOVvalues:
	def __init__(self):
	    self._values=[(1,'first'),(2,'second'),(3,'third')]
	def GetTupleList(self,parvalue):
	    return self._values
    # it is a sample validation function
    def ValidateFunc(self):
	k=self._GetItemKey()
	if k!=None and k<2: raise ValueError,(1,0,'The itemkey has to be greater than 1!')
    lovv=clsLOVvalues()
    lov=LOVEntry(root,({'bg':'green'},{'bg':'gray'},{'bg':'red'}),lovv)
    lov.pack(fill=BOTH,expand=YES)
    lov2=LOVEntry(root,({'bg':'green'},{'bg':'gray'},{'bg':'red'}),lovv,{'bg':'lightblue','fg':'maroon'},validate_function=ValidateFunc,mandatory=YES)
    lov2.pack(fill=BOTH,expand=YES)
    # if you want localized messages then you can replace the default messages
    # in this case don't forget the validation function
    messages=((0,0,'*** This  is a mandatory field! ***'),
              (0,1,"*** There is a wrong value in the field! ***"))
    lov3=LOVEntry(root,({'bg':'green'},{'bg':'gray'},{'bg':'red'}),lovv,error_messages=messages)
    lov3.pack(fill=BOTH,expand=YES)
    lov.configure(state=DISABLED)
    root.mainloop()
    print 'lov value,itemkey,value_error,value_error_details:',lov['value'],',',lov['itemkey'],lov['value_error'],lov['value_error_details']
    print 'lov2 value,itemkey,value_error,value_error_details:',lov2['value'],',',lov2['itemkey'],lov2['value_error'],lov2['value_error_details']
    print 'lov3 value,itemkey,value_error,value_error_details:',lov3['value'],',',lov3['itemkey'],lov3['value_error'],lov3['value_error_details']
