/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.vfs.entry;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.openantivirus.engine.ScanConfiguration;
import org.openantivirus.engine.vfs.entry.TemporaryVfsEntry;

public class TemporaryIsVfsEntry
extends TemporaryVfsEntry {
    private static final int BUFFER_SIZE = 32768;
    private final byte[] start;
    private final InputStream is;
    private boolean fileComplete;

    public TemporaryIsVfsEntry(String name, ScanConfiguration scanConf, InputStream is) throws IOException {
        super(name, scanConf);
        int read;
        this.is = is;
        int pos = 0;
        byte[] buffer = new byte[4096];
        while ((read = is.read(buffer, pos, 4096 - pos)) != -1) {
            this.osTempFile.write(buffer, pos, read);
            if ((pos += read) != 4096) continue;
        }
        boolean bl = this.fileComplete = read == -1;
        if (pos < 4096) {
            this.start = new byte[pos];
            System.arraycopy(buffer, 0, this.start, 0, pos);
        } else {
            this.start = buffer;
        }
    }

    public byte[] getStart() throws IOException {
        return this.start;
    }

    public void dispose() throws IOException {
        super.dispose();
        this.is.close();
    }

    public File getFile() throws IOException {
        if (!this.fileComplete) {
            int read;
            byte[] buffer = new byte[4096];
            while ((read = this.is.read(buffer)) != -1) {
                this.osTempFile.write(buffer, 0, read);
            }
            this.is.close();
            this.osTempFile.close();
            this.fileComplete = true;
        }
        return super.getFile();
    }
}

