/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.vfs.entry;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.openantivirus.engine.vfs.VfsEntry;

public class FileVfsEntry
extends VfsEntry {
    private byte[] start = null;
    private final File file;
    private final String name;

    public FileVfsEntry(File file) throws IOException {
        this.file = file;
        this.name = FileVfsEntry.getRelativeName(file);
    }

    public FileVfsEntry(File file, String name) throws IOException {
        this.file = file;
        this.name = name;
    }

    public void dispose() throws IOException {
        this.start = null;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public byte[] getStart() throws IOException {
        if (this.start == null) {
            RandomAccessFile raf = new RandomAccessFile(this.file, "r");
            this.start = new byte[Math.min(4096, (int)this.file.length())];
            raf.readFully(this.start);
            raf.close();
        }
        return this.start;
    }

    public static String getRelativeName(File file) {
        String parent = file.getParent();
        if (parent != null) {
            return parent + File.separatorChar + file.getName();
        }
        return file.getName();
    }
}

