/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.vfs.container.ucl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.openantivirus.engine.vfs.container.ucl.CStructure;
import org.openantivirus.engine.vfs.container.ucl.EXEHeader;
import org.openantivirus.engine.vfs.container.ucl.PEHeader;
import org.openantivirus.engine.vfs.container.ucl.PESection;
import org.openantivirus.engine.vfs.container.ucl.PackHeader;

public class UPXDecompress {
    private final RandomAccessFile raf;
    private final long file_size;
    private static final int MAX_IC = 20;
    private static final String UPX_SECTION_NAME = "UPX";
    private static final int MAX_VERSION = 12;
    private static final int M_NRV2B_LE32 = 2;
    private static final int M_NRV2B_8 = 3;
    private static final int M_NRV2B_LE16 = 4;
    private static final int M_NRV2D_LE32 = 5;
    private static final int M_NRV2D_8 = 6;
    private static final int M_NRV2D_LE16 = 7;
    private boolean isRTM;
    private long pe_offset;
    private PEHeader ih;
    private PESection[] isection;
    private final PackHeader ph = new PackHeader();
    private int ilen;
    private byte[] src;
    private byte[] dst;
    private long bitBuffer;
    private int bitCount;

    public UPXDecompress(RandomAccessFile raf, long file_size) {
        this.raf = raf;
        this.file_size = file_size;
    }

    public boolean canUnpack() throws IOException {
        if (!this.readFileHeader()) {
            return false;
        }
        int objects = this.ih.getObjects();
        if (objects != 3) {
            return false;
        }
        this.isection = new PESection[objects];
        this.raf.seek(this.pe_offset + 248L);
        for (int i = 0; i < this.isection.length; ++i) {
            byte[] data = new byte[40];
            this.raf.readFully(data);
            this.isection[i] = new PESection(data);
        }
        if (this.ih.getDDirsSize(15) == 0L && this.ih.getEntry() <= this.isection[1].getVAddress()) {
            return false;
        }
        if (this.isection[0].getName().startsWith(UPX_SECTION_NAME)) {
            return this.readPackHeader(1024, this.isection[1].getRawDataPointer() - 64L) || this.readPackHeader(1024, this.isection[2].getRawDataPointer());
        }
        return false;
    }

    protected boolean readPackHeader(int len, long seek_offset) throws IOException {
        if (len <= 0 || seek_offset < 0L) {
            return false;
        }
        byte[] buf = new byte[len];
        this.raf.seek(seek_offset);
        this.raf.readFully(buf);
        if (!this.ph.fillPackHeader(buf)) {
            return false;
        }
        if (!this.ph.checkPackHeader(buf)) {
            return false;
        }
        if (this.ph.getVersion() > 12) {
            throw new IOException("need a newer version of UPX");
        }
        if (this.ph.getCLength() >= this.ph.getULength() || (long)this.ph.getCLength() >= this.file_size) {
            throw new IOException("header corrupted");
        }
        if (this.ph.getMethod() < 2 || this.ph.getMethod() > 7) {
            throw new IOException("unknown compression method");
        }
        return true;
    }

    protected boolean readFileHeader() throws IOException {
        byte[] data;
        int ic;
        this.pe_offset = 0L;
        for (ic = 0; ic < 20; ++ic) {
            this.raf.seek(this.pe_offset);
            data = new byte[64];
            this.raf.readFully(data);
            EXEHeader h = new EXEHeader(data);
            if (h.getMZ() == 23117) {
                if (h.getRelocationOffset() >= 64) {
                    this.pe_offset += h.getNextEPos();
                    continue;
                }
                this.pe_offset += (long)((h.getP512() << 9) + h.getM512() - (h.getM512() != 0 ? 512 : 0));
                continue;
            }
            if (h.getLE32(0) == 17744L) break;
            return false;
        }
        if (ic == 20) {
            return false;
        }
        data = new byte[248];
        this.raf.seek(this.pe_offset);
        this.raf.readFully(data);
        this.ih = new PEHeader(data);
        String sStub = "32STUB";
        byte[] aStub = new byte["32STUB".length()];
        this.raf.seek(512L);
        this.raf.readFully(aStub);
        this.isRTM = "32STUB".equals(new String(aStub));
        return true;
    }

    public void decompress(OutputStream os) throws IOException {
        if (this.ih == null) {
            throw new IllegalStateException("Need to call 'canUnpack()' first");
        }
        this.raf.seek(this.isection[1].getRawDataPointer() - 64L + (long)this.ph.getBufferOffset() + (long)this.ph.getPackHeaderSize());
        this.src = new byte[this.ph.getCLength()];
        this.raf.readFully(this.src);
        this.dst = new byte[this.ph.getULength()];
        this.bitBuffer = 0L;
        this.bitCount = 0;
        this.ilen = 0;
        int olen = 0;
        int last_m_off = 1;
        while (true) {
            if (this.getbit() != 0) {
                this.dst[olen++] = this.src[this.ilen++];
                continue;
            }
            long m_off = 1L;
            do {
                m_off = (m_off << 1) + (long)this.getbit();
            } while (this.getbit() == 0);
            if (m_off == 2L) {
                m_off = last_m_off;
            } else {
                if ((m_off = (m_off - 3L << 8) + (long)CStructure.getByte(this.src, this.ilen++)) == 0xFFFFFFFFL) break;
                last_m_off = (int)(++m_off);
            }
            int m_len = this.getbit();
            m_len = (m_len << 1) + this.getbit();
            if (m_len == 0) {
                ++m_len;
                do {
                    m_len = (m_len << 1) + this.getbit();
                } while (this.getbit() == 0);
                m_len += 2;
            }
            m_len += m_off > 3328L ? 1 : 0;
            int m_pos = (int)((long)olen - m_off);
            this.dst[olen++] = this.dst[m_pos++];
            do {
                this.dst[olen++] = this.dst[m_pos++];
            } while (--m_len > 0);
        }
        if (os != null) {
            os.write(this.dst);
        }
        if (this.ilen < this.src.length) {
            throw new IOException("UPX input not consumed");
        }
    }

    protected int getbit() throws IOException {
        if (this.bitCount > 0) {
            --this.bitCount;
            return (int)(this.bitBuffer >> this.bitCount & 1L);
        }
        this.bitCount = 31;
        this.bitBuffer = CStructure.getByte(this.src, this.ilen++) + (CStructure.getByte(this.src, this.ilen++) << 8) + (CStructure.getByte(this.src, this.ilen++) << 16) + (CStructure.getByte(this.src, this.ilen++) << 24);
        return (int)(this.bitBuffer >> 31 & 1L);
    }

    public void close() throws IOException {
        this.raf.close();
    }
}

