/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.vfs.container.ucl;

import org.openantivirus.engine.vfs.container.ucl.CStructure;

public class PackHeader {
    public static final String VERSION = "$Id: PackHeader.java,v 1.1 2003/12/14 11:08:26 kurti Exp $";
    private static final byte[] UPX_MAGIC_LE32 = new byte[]{85, 80, 88, 33};
    private static final int UPX_F_DOS_COM = 1;
    private static final int UPX_F_DOS_SYS = 2;
    private static final int UPX_F_DOS_EXE = 3;
    private static final int UPX_F_DOS_EXEH = 7;
    private int version;
    private int format;
    private int method;
    private int level;
    private int filter;
    private int filter_cto;
    private long u_adler;
    private long c_adler;
    private int u_len;
    private int c_len;
    private int u_file_size;
    private int buf_offset;

    public boolean fillPackHeader(byte[] data) {
        int l = this.find(data, UPX_MAGIC_LE32);
        if (l == -1) {
            return false;
        }
        this.buf_offset = l;
        this.version = CStructure.getByte(data, l + 4);
        this.format = CStructure.getByte(data, l + 5);
        this.method = CStructure.getByte(data, l + 6);
        this.level = CStructure.getByte(data, l + 7);
        this.filter_cto = 0;
        int off_filter = 0;
        if (this.format < 128) {
            this.u_adler = CStructure.getLE32(data, l + 8);
            this.c_adler = CStructure.getLE32(data, l + 12);
            if (this.format == 1 || this.format == 2) {
                this.u_len = CStructure.getLE16(data, l + 16);
                this.c_len = CStructure.getLE16(data, l + 18);
                this.u_file_size = this.u_len;
                off_filter = 20;
            } else if (this.format == 3 || this.format == 7) {
                this.u_len = CStructure.getLE24(data, l + 16);
                this.c_len = CStructure.getLE24(data, l + 19);
                this.u_file_size = CStructure.getLE24(data, l + 22);
                off_filter = 25;
            } else {
                this.u_len = (int)CStructure.getLE32(data, l + 16);
                this.c_len = (int)CStructure.getLE32(data, l + 20);
                this.u_file_size = (int)CStructure.getLE32(data, l + 24);
                off_filter = 28;
                this.filter_cto = CStructure.getByte(data, l + 29);
            }
        } else {
            this.u_len = (int)CStructure.getBE32(data, l + 8);
            this.c_len = (int)CStructure.getBE32(data, l + 12);
            this.u_adler = CStructure.getBE32(data, l + 16);
            this.c_adler = CStructure.getBE32(data, l + 20);
            this.u_file_size = (int)CStructure.getBE32(data, l + 24);
            off_filter = 28;
            this.filter_cto = CStructure.getByte(data, l + 29);
        }
        if (this.version >= 10) {
            this.filter = CStructure.getByte(data, l + off_filter);
        } else if ((this.level & 0x80) == 0) {
            this.filter = 0;
        } else {
            this.level &= 0x7F;
            this.filter = this.format == 1 || this.format == 2 ? 6 : 38;
        }
        this.level &= 0xF;
        return true;
    }

    public boolean checkPackHeader(byte[] data) {
        if (this.version == 255) {
            System.out.println("cannot unpack UPX ;-)");
            return false;
        }
        int hs = this.getPackHeaderSize();
        int hlen = data.length - this.buf_offset;
        if (hlen <= 0 || hs > hlen) {
            System.err.println("header corrupted");
            return false;
        }
        if (this.version > 9 && data[this.buf_offset + hs - 1] != this.getPackHeaderChecksum(data, hs - 1)) {
            System.err.println("header corrupted");
            return false;
        }
        return true;
    }

    public int getVersion() {
        return this.version;
    }

    public int getCLength() {
        return this.c_len;
    }

    public int getULength() {
        return this.u_len;
    }

    public int getMethod() {
        return this.method;
    }

    public int getBufferOffset() {
        return this.buf_offset;
    }

    protected byte getPackHeaderChecksum(byte[] data, int len) {
        int buf = this.buf_offset;
        buf += 4;
        len -= 4;
        int c = 0;
        while (len-- > 0) {
            c += CStructure.getByte(data, buf++);
        }
        return (byte)(c %= 251);
    }

    protected int getPackHeaderSize() {
        int n = 0;
        n = this.version <= 3 ? 24 : (this.version <= 9 ? (this.format == 1 || this.format == 2 ? 20 : (this.format == 3 || this.format == 7 ? 25 : 28)) : (this.format == 1 || this.format == 2 ? 22 : (this.format == 3 || this.format == 7 ? 27 : 32)));
        if (n == 0) {
            System.err.println("unknown header version");
        }
        return n;
    }

    protected int find(byte[] data, byte[] pattern) {
        block0: for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < pattern.length; ++j) {
                if (data[i + j] != pattern[j]) continue block0;
            }
            return i;
        }
        return -1;
    }
}

