/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.vfs.container.ucl;

public class CStructure {
    public static final String VERSION = "$Id: CStructure.java,v 1.3 2004/05/18 09:03:28 kurti Exp $";
    private final byte[] data;

    public CStructure(byte[] data, int size) {
        this.data = data;
        if (data.length != size) {
            throw new IllegalArgumentException("Datasize must be " + size);
        }
    }

    public int getByte(int index) {
        return CStructure.getByte(this.data, index);
    }

    public int getLE16(int index) {
        return CStructure.getLE16(this.data, index);
    }

    public long getLE32(int index) {
        return CStructure.getLE32(this.data, index);
    }

    public static int getByte(byte[] data, int index) {
        return data[index] & 0xFF;
    }

    public static int getLE16(byte[] data, int index) {
        return CStructure.getByte(data, index) | CStructure.getByte(data, index + 1) << 8;
    }

    public static int getBE16(byte[] data, int index) {
        return CStructure.getByte(data, index + 1) | CStructure.getByte(data, index) << 8;
    }

    public static int getLE24(byte[] data, int index) {
        return CStructure.getLE16(data, index) + (CStructure.getByte(data, index + 2) << 16);
    }

    public static long getLE32(byte[] data, int index) {
        return (long)CStructure.getLE16(data, index) + ((long)CStructure.getLE16(data, index + 2) << 16);
    }

    public static long getBE32(byte[] data, int index) {
        return (long)CStructure.getBE16(data, index + 2) + ((long)CStructure.getBE16(data, index) << 16);
    }
}

