/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.vfs.container;

import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openantivirus.engine.ScanConfiguration;
import org.openantivirus.engine.vfs.VfsContainer;
import org.openantivirus.engine.vfs.VfsEntry;
import org.openantivirus.engine.vfs.entry.TemporaryIsVfsEntry;

public class ZipContainer
implements VfsContainer {
    private final ScanConfiguration configuration;
    private final VfsEntry entry;
    private final ZipFile zipFile;
    private final Enumeration entries;
    private ZipEntry nextEntry;

    public ZipContainer(VfsEntry entry, ScanConfiguration configuration) throws IOException {
        this.configuration = configuration;
        this.entry = entry;
        this.zipFile = new ZipFile(entry.getFile());
        this.entries = this.zipFile.entries();
        this.determineNext();
    }

    public boolean hasNext() {
        return this.nextEntry != null;
    }

    public VfsEntry next() throws IOException {
        TemporaryIsVfsEntry result = new TemporaryIsVfsEntry(this.entry.getName() + " >> zip:" + this.nextEntry.getName(), this.configuration, this.zipFile.getInputStream(this.nextEntry));
        this.determineNext();
        return result;
    }

    protected void determineNext() {
        do {
            if (!this.entries.hasMoreElements()) {
                this.nextEntry = null;
                break;
            }
            this.nextEntry = (ZipEntry)this.entries.nextElement();
        } while (this.nextEntry.isDirectory());
    }

    public void dispose() throws IOException {
        this.zipFile.close();
        this.nextEntry = null;
    }
}

