/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.vfs.container;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.openantivirus.engine.ScanConfiguration;
import org.openantivirus.engine.vfs.VfsEntry;
import org.openantivirus.engine.vfs.container.SingleFileContainer;
import org.openantivirus.engine.vfs.container.ucl.UPXDecompress;

public class UpxContainer
extends SingleFileContainer {
    private final UPXDecompress upxDecompress;

    public UpxContainer(VfsEntry entry, UPXDecompress upxDecompress, ScanConfiguration scanConf) throws IOException {
        super(entry, "upx", scanConf);
        this.upxDecompress = upxDecompress;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractFile(VfsEntry entry, File tempFile) throws IOException {
        try {
            FileOutputStream os = new FileOutputStream(tempFile);
            try {
                this.upxDecompress.decompress(os);
            }
            finally {
                ((OutputStream)os).close();
                this.upxDecompress.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            tempFile.delete();
            try {
                if (Runtime.getRuntime().exec(new String[]{"upx", "-dq", "-o" + tempFile.getCanonicalPath(), entry.getFile().getCanonicalPath()}).waitFor() != 0) {
                    throw new IOException("Broken UPX file");
                }
            }
            catch (InterruptedException io) {
                throw new IOException("UPX decompress interrupted");
            }
        }
    }
}

