/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.vfs.container;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openantivirus.engine.ScanConfiguration;
import org.openantivirus.engine.vfs.TemporaryFile;
import org.openantivirus.engine.vfs.VfsContainer;
import org.openantivirus.engine.vfs.VfsEntry;
import org.openantivirus.engine.vfs.entry.FileVfsEntry;

public abstract class SingleFileContainer
extends VfsEntry
implements VfsContainer {
    private final VfsEntry fileEntry;
    private final TemporaryFile tempFile;
    private final VfsEntry entry;
    private final String type;
    private boolean read = false;
    private boolean initialized = false;

    protected SingleFileContainer(VfsEntry entry, String type, ScanConfiguration scanConf) throws IOException {
        this.entry = entry;
        this.type = type;
        this.tempFile = new TemporaryFile(scanConf);
        this.fileEntry = new FileVfsEntry(this.tempFile.getFile());
    }

    protected void init() throws IOException {
        try {
            this.extractFile(this.entry, this.tempFile.getFile());
        }
        catch (Exception e) {
            this.tempFile.delete();
            throw new IOException("error while extracting: " + e.getMessage());
        }
        this.initialized = true;
    }

    public abstract void extractFile(VfsEntry var1, File var2) throws IOException;

    public void dispose() throws IOException {
        this.tempFile.delete();
    }

    public File getFile() throws IOException {
        return this.tempFile.getFile();
    }

    public byte[] getStart() throws IOException {
        return this.fileEntry.getStart();
    }

    public boolean hasNext() throws IOException {
        if (!this.initialized) {
            this.init();
        }
        return !this.read;
    }

    public VfsEntry next() throws IOException {
        this.read = true;
        return this;
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        int length;
        byte[] buffer = new byte[32768];
        while ((length = is.read(buffer)) != -1) {
            os.write(buffer, 0, length);
        }
        is.close();
        os.close();
    }

    public String getName() {
        return this.entry.getName() + " >> " + this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runCommand(String[] command, File tempFile) throws IOException, FileNotFoundException {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(command);
            SingleFileContainer.copyStream(process.getInputStream(), new FileOutputStream(tempFile));
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }
}

