/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.vfs.container;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.openantivirus.engine.ScanConfiguration;
import org.openantivirus.engine.vfs.VfsContainer;
import org.openantivirus.engine.vfs.VfsEntry;
import org.openantivirus.engine.vfs.entry.FileVfsEntry;

public class DirectoryContainer
implements VfsContainer {
    private final LinkedList directories = new LinkedList();
    private final VfsEntry entry;
    private final ScanConfiguration scanConf;
    private final int removeLength;
    private File[] currentFiles;
    private int currentIndex;
    private File nextFile;

    public DirectoryContainer(VfsEntry entry, ScanConfiguration scanConf) throws IOException {
        this(entry, scanConf, null);
    }

    public DirectoryContainer(VfsEntry entry, ScanConfiguration scanConf, String pathRemove) throws IOException {
        this.entry = entry;
        this.scanConf = scanConf;
        this.removeLength = pathRemove != null ? pathRemove.length() : 0;
        File directory = entry.getFile();
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("not a directory: " + directory.getAbsolutePath());
        }
        this.handleDirectory(directory);
        this.determineNext();
    }

    public boolean hasNext() {
        return this.nextFile != null;
    }

    public VfsEntry next() throws IOException {
        FileVfsEntry result = this.removeLength == 0 ? new FileVfsEntry(this.nextFile) : new FileVfsEntry(this.nextFile, this.entry.getName() + FileVfsEntry.getRelativeName(this.nextFile).substring(this.removeLength));
        this.determineNext();
        return result;
    }

    protected void determineNext() throws IOException {
        File next;
        while ((next = this.getNext()) != null) {
            if (!this.scanConf.getBoolean("vfs.follow-symlinks") && !next.getAbsolutePath().equals(next.getCanonicalPath())) {
                return;
            }
            if (next.isFile()) break;
            if (!next.isDirectory()) continue;
            this.directories.add(next);
        }
        this.nextFile = next;
    }

    protected File getNext() {
        if (this.currentIndex < this.currentFiles.length) {
            return this.currentFiles[this.currentIndex++];
        }
        if (this.directories.isEmpty()) {
            return null;
        }
        this.handleDirectory((File)this.directories.removeFirst());
        return this.getNext();
    }

    protected void handleDirectory(File directory) {
        this.currentFiles = directory.listFiles();
        this.currentIndex = 0;
    }

    public void dispose() {
        this.currentFiles = null;
        this.nextFile = null;
    }
}

