/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.vfs.container;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.GZIPInputStream;
import org.openantivirus.engine.ScanConfiguration;
import org.openantivirus.engine.vfs.VfsContainer;
import org.openantivirus.engine.vfs.VfsContainerFactory;
import org.openantivirus.engine.vfs.VfsEntry;
import org.openantivirus.engine.vfs.container.ArchiveContainer;
import org.openantivirus.engine.vfs.container.SingleFileContainer;
import org.openantivirus.engine.vfs.container.UpxContainer;
import org.openantivirus.engine.vfs.container.ZipContainer;
import org.openantivirus.engine.vfs.container.ucl.UPXDecompress;

public class CompressedContainerFactory
implements VfsContainerFactory {
    private final byte[] ACE_MAGIC = "**ACE**".getBytes();
    private final byte[] AR_MAGIC = "!<arch>".getBytes();
    private final byte[] ARC2_MAGIC = new byte[]{26, 2};
    private final byte[] ARC3_MAGIC = new byte[]{26, 3};
    private final byte[] ARC4_MAGIC = new byte[]{26, 4};
    private final byte[] ARC6_MAGIC = new byte[]{26, 6};
    private final byte[] ARC8_MAGIC = new byte[]{26, 8};
    private final byte[] ARC9_MAGIC = new byte[]{26, 9};
    private final byte[] ARJ_MAGIC = new byte[]{96, -22};
    private final byte[] CAB_MAGIC = new byte[]{77, 83, 67, 70, 0, 0, 0, 0};
    private final byte[] CPIO_MAGIC = new byte[]{-57, 113};
    private final byte[] CPIOS_MAGIC = new byte[]{113, -57};
    private final byte[] CPIO1_MAGIC = "070701".getBytes();
    private final byte[] CPIO2_MAGIC = "070702".getBytes();
    private final byte[] CPIO7_MAGIC = "070707".getBytes();
    private final byte[] COMPR_MAGIC = new byte[]{31, -99};
    private final byte[] DACT_MAGIC = new byte[]{68, 67, 84, -61};
    private final byte[] DAR_MAGIC = new byte[]{0, 0, 0, 123};
    private final byte[] EXE_MAGIC = "MZ".getBytes();
    private final byte[] BZIP2_MAGIC = "BZh".getBytes();
    private final byte[] GZIP_MAGIC = new byte[]{31, -117};
    private final byte[] LHA__MAGIC = "-lh -".getBytes();
    private final byte[] LHA0_MAGIC = "-lh0-".getBytes();
    private final byte[] LHA1_MAGIC = "-lh1-".getBytes();
    private final byte[] LHA2_MAGIC = "-lh2-".getBytes();
    private final byte[] LHA3_MAGIC = "-lh3-".getBytes();
    private final byte[] LHA4_MAGIC = "-lh4-".getBytes();
    private final byte[] LHA5_MAGIC = "-lh5-".getBytes();
    private final byte[] LHA6_MAGIC = "-lh6-".getBytes();
    private final byte[] LHA7_MAGIC = "-lh7-".getBytes();
    private final byte[] LHAD_MAGIC = "-lhd-".getBytes();
    private final byte[] LHAZ4_MAGIC = "-lz4-".getBytes();
    private final byte[] LHAZ5_MAGIC = "-lz5-".getBytes();
    private final byte[] LZO_MAGIC = new byte[]{-119, 76, 90, 79, 0, 13, 10, 26};
    private final byte[] PPMD_MAGIC = new byte[]{-113, -81, -84, -124};
    private final byte[] RAR_MAGIC = "Rar!".getBytes();
    private final byte[] RPM_MAGIC = new byte[]{-19, -85, -18, -37};
    private final byte[] SHAR_MAGIC = "# This is a shell archive".getBytes();
    private final byte[] TAR_MAGIC = "ustar".getBytes();
    private final byte[] TNEF_MAGIC = new byte[]{120, -97, 62, 34};
    private final byte[] UUENC_MAGIC = "begin ".getBytes();
    private final byte[] ZIP_MAGIC = new byte[]{80, 75, 3, 4};
    private final byte[] ZOO_MAGIC = new byte[]{-36, -89, -60, -3};

    public VfsContainer getContainer(VfsEntry entry, ScanConfiguration scanConf) throws IOException {
        if (!scanConf.getBoolean("vfs.archive.enable")) {
            return null;
        }
        byte[] start = entry.getStart();
        if (scanConf.getBoolean("vfs.archive.zip") && this.startsWithMagic(start, this.ZIP_MAGIC)) {
            return new ZipContainer(entry, scanConf);
        }
        if (scanConf.getBoolean("vfs.archive.bzip2") && this.startsWithMagic(start, this.BZIP2_MAGIC)) {
            return new SingleFileContainer(entry, "bzip2", scanConf){

                public void extractFile(VfsEntry entry, File tempFile) throws IOException {
                    this.runCommand(new String[]{"bunzip2", "-c", entry.getFile().getCanonicalPath()}, tempFile);
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.gzip") && this.startsWithMagic(start, this.GZIP_MAGIC)) {
            return new SingleFileContainer(entry, "gzip", scanConf){

                public void extractFile(VfsEntry entry, File tempFile) throws IOException {
                    2.copyStream(new GZIPInputStream(new FileInputStream(entry.getFile())), new FileOutputStream(tempFile));
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.tar") && this.containsMagic(start, this.TAR_MAGIC, 257)) {
            return new ArchiveContainer(entry, " >> tar:", scanConf){

                public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                    this.runCommand(new String[]{"tar", "xfC", entry.getFile().getCanonicalPath(), tempDir.getCanonicalPath()});
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.cab") && this.startsWithMagic(start, this.CAB_MAGIC)) {
            return new ArchiveContainer(entry, " >> cab:", scanConf){

                public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                    this.runCommand(new String[]{"cabextract", "-d", tempDir.getCanonicalPath(), entry.getFile().getCanonicalPath()});
                }
            };
        }
        if (this.startsWithMagic(start, this.EXE_MAGIC)) {
            if (scanConf.getBoolean("vfs.archive.rar") && this.containsMagic(start, this.RAR_MAGIC, 7195)) {
                return new ArchiveContainer(entry, " >> rar-exe:", scanConf){

                    public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                        this.runCommand(new String[]{"unrar", "x", entry.getFile().getCanonicalPath()}, tempDir);
                    }
                };
            }
            if (scanConf.getBoolean("vfs.archive.upx")) {
                boolean canUnpack;
                File file = entry.getFile();
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                UPXDecompress upxDecompress = new UPXDecompress(raf, file.length());
                try {
                    canUnpack = upxDecompress.canUnpack();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    canUnpack = false;
                }
                if (canUnpack) {
                    return new UpxContainer(entry, upxDecompress, scanConf);
                }
                raf.close();
            }
        }
        if (scanConf.getBoolean("vfs.archive.ace") && this.containsMagic(start, this.ACE_MAGIC, 7)) {
            return new ArchiveContainer(entry, " >> ace:", scanConf){

                public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                    this.runCommand(new String[]{"unace", "e", entry.getFile().getCanonicalPath()}, tempDir);
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.ar") && this.startsWithMagic(start, this.AR_MAGIC)) {
            return new ArchiveContainer(entry, " >> ar:", scanConf){

                public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                    this.runCommand(new String[]{"ar", "x", entry.getFile().getCanonicalPath()}, tempDir);
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.rar") && this.startsWithMagic(start, this.RAR_MAGIC)) {
            return new ArchiveContainer(entry, " >> rar:", scanConf){

                public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                    this.runCommand(new String[]{"unrar", "x", entry.getFile().getCanonicalPath()}, tempDir);
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.lha") && (this.containsMagic(start, this.LHA__MAGIC, 2) || this.containsMagic(start, this.LHA0_MAGIC, 2) || this.containsMagic(start, this.LHA1_MAGIC, 2) || this.containsMagic(start, this.LHA2_MAGIC, 2) || this.containsMagic(start, this.LHA3_MAGIC, 2) || this.containsMagic(start, this.LHA4_MAGIC, 2) || this.containsMagic(start, this.LHA5_MAGIC, 2) || this.containsMagic(start, this.LHA6_MAGIC, 2) || this.containsMagic(start, this.LHA7_MAGIC, 2) || this.containsMagic(start, this.LHA7_MAGIC, 2) || this.containsMagic(start, this.LHAD_MAGIC, 2) || this.containsMagic(start, this.LHAZ4_MAGIC, 2) || this.containsMagic(start, this.LHAZ5_MAGIC, 2))) {
            return new ArchiveContainer(entry, " >> lha:", scanConf){

                public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                    this.runCommand(new String[]{"lha", "xw=" + tempDir.getCanonicalPath(), entry.getFile().getCanonicalPath()});
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.arj") && this.startsWithMagic(start, this.ARJ_MAGIC)) {
            return new ArchiveContainer(entry, " >> arj:", scanConf){

                public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                    this.runCommand(new String[]{"unarj", "x", entry.getFile().getCanonicalPath()}, tempDir);
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.zoo") && this.containsMagic(start, this.ZOO_MAGIC, 20)) {
            return new ArchiveContainer(entry, " >> zoo:", scanConf){

                public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                    this.runCommand(new String[]{"unzoo", "-x", "-j", tempDir.getCanonicalPath() + File.separator, entry.getFile().getCanonicalPath()});
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.cpio") && (this.startsWithMagic(start, this.CPIO_MAGIC) || this.startsWithMagic(start, this.CPIOS_MAGIC) || this.startsWithMagic(start, this.CPIO1_MAGIC) || this.startsWithMagic(start, this.CPIO2_MAGIC) || this.startsWithMagic(start, this.CPIO7_MAGIC))) {
            return new ArchiveContainer(entry, " >> cpio:", scanConf){

                public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                    this.runCommand(new String[]{"cpio", "-i", "-F", entry.getFile().getCanonicalPath()}, tempDir);
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.tnef") && this.startsWithMagic(start, this.TNEF_MAGIC)) {
            return new ArchiveContainer(entry, " >> tnef:", scanConf){

                public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                    this.runCommand(new String[]{"tnef", "-f", entry.getFile().getCanonicalPath(), "-C", tempDir.getCanonicalPath()});
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.shar") && this.containsMagic(start, this.SHAR_MAGIC, 10)) {
            return new ArchiveContainer(entry, " >> shar:", scanConf){

                public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                    this.runCommand(new String[]{"unshar", "-d", tempDir.getCanonicalPath(), entry.getFile().getCanonicalPath()});
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.uuencode") && this.startsWithMagic(start, this.UUENC_MAGIC)) {
            return new SingleFileContainer(entry, "uuencode", scanConf){

                public void extractFile(VfsEntry entry, File tempFile) throws IOException {
                    this.runCommand(new String[]{"uudecode", "-o", "/dev/stdout", entry.getFile().getCanonicalPath()}, tempFile);
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.compress") && this.startsWithMagic(start, this.COMPR_MAGIC)) {
            return new SingleFileContainer(entry, "compress", scanConf){

                public void extractFile(VfsEntry entry, File tempFile) throws IOException {
                    this.runCommand(new String[]{"uncompress", "-d", "-c", entry.getFile().getCanonicalPath()}, tempFile);
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.rpm") && this.startsWithMagic(start, this.RPM_MAGIC)) {
            return new ArchiveContainer(entry, " >> rpm:", scanConf){

                public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                    this.runCommand(new String[]{"rpm2cpio", entry.getFile().getCanonicalPath()}, tempDir, new FileOutputStream(tempDir.getCanonicalPath() + File.separator + "rpm.cpio"));
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.arc") && (this.startsWithMagic(start, this.ARC2_MAGIC) || this.startsWithMagic(start, this.ARC3_MAGIC) || this.startsWithMagic(start, this.ARC4_MAGIC) || this.startsWithMagic(start, this.ARC6_MAGIC) || this.startsWithMagic(start, this.ARC8_MAGIC) || this.startsWithMagic(start, this.ARC9_MAGIC))) {
            return new ArchiveContainer(entry, " >> arc:", scanConf){

                public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                    this.runCommand(new String[]{"arc", "x", entry.getFile().getCanonicalPath()}, tempDir);
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.lzo") && this.startsWithMagic(start, this.LZO_MAGIC)) {
            return new SingleFileContainer(entry, "lzop", scanConf){

                public void extractFile(VfsEntry entry, File tempFile) throws IOException {
                    this.runCommand(new String[]{"lzop", "-d", "-c", entry.getFile().getCanonicalPath()}, tempFile);
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.ppmd") && this.startsWithMagic(start, this.PPMD_MAGIC)) {
            return new ArchiveContainer(entry, " >> ppmd:", scanConf){

                public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                    String tempFilename = tempDir.getCanonicalPath() + File.separator + "file.pmd";
                    SingleFileContainer.copyStream(new FileInputStream(entry.getFile()), new FileOutputStream(new File(tempFilename)));
                    this.runCommand(new String[]{"PPMd", "d", "-d", tempFilename}, tempDir);
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.dact") && this.startsWithMagic(start, this.DACT_MAGIC)) {
            return new SingleFileContainer(entry, "dact", scanConf){

                public void extractFile(VfsEntry entry, File tempFile) throws IOException {
                    this.runCommand(new String[]{"dact", "-d", "-c", entry.getFile().getCanonicalPath()}, tempFile);
                }
            };
        }
        if (scanConf.getBoolean("vfs.archive.dar") && this.startsWithMagic(start, this.DAR_MAGIC)) {
            return new ArchiveContainer(entry, " >> dar:", scanConf){

                public void extractArchive(VfsEntry entry, File tempDir) throws IOException {
                    String filename = entry.getFile().getCanonicalPath();
                    this.runCommand(new String[]{"dar", "-x", filename.substring(0, filename.lastIndexOf(46, filename.lastIndexOf(46) - 1)), "-O", "-N"}, tempDir);
                }
            };
        }
        return null;
    }

    protected boolean startsWithMagic(byte[] start, byte[] magic) {
        return this.containsMagic(start, magic, 0);
    }

    protected boolean containsMagic(byte[] start, byte[] magic, int offset) {
        if (start.length < magic.length + offset) {
            return false;
        }
        for (int i = 0; i < magic.length; ++i) {
            if (start[i + offset] == magic[i]) continue;
            return false;
        }
        return true;
    }
}

