/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.vfs.container;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.openantivirus.engine.ScanConfiguration;
import org.openantivirus.engine.vfs.TemporaryDirectory;
import org.openantivirus.engine.vfs.VfsContainer;
import org.openantivirus.engine.vfs.VfsEntry;
import org.openantivirus.engine.vfs.container.DirectoryContainer;
import org.openantivirus.engine.vfs.container.SingleFileContainer;
import org.openantivirus.engine.vfs.entry.FileVfsEntry;

public abstract class ArchiveContainer
implements VfsContainer {
    private final VfsEntry entry;
    private final String type;
    private final TemporaryDirectory tempDir;
    private DirectoryContainer directory;
    private final ScanConfiguration scanConf;
    private boolean initialized = false;

    protected ArchiveContainer(VfsEntry entry, String type, ScanConfiguration scanConf) throws IOException {
        this.entry = entry;
        this.type = type;
        this.scanConf = scanConf;
        this.tempDir = new TemporaryDirectory(scanConf);
    }

    protected void init() throws IOException {
        try {
            this.extractArchive(this.entry, this.tempDir.getDirectory());
            this.directory = new DirectoryContainer(new FileVfsEntry(this.tempDir.getDirectory(), this.entry.getName() + this.type), this.scanConf, FileVfsEntry.getRelativeName(this.tempDir.getDirectory()) + File.separatorChar);
        }
        catch (Exception e) {
            this.tempDir.delete();
            throw new IOException("error while extracting: " + e.getMessage());
        }
        this.initialized = true;
    }

    public abstract void extractArchive(VfsEntry var1, File var2) throws IOException;

    public boolean hasNext() throws IOException {
        if (!this.initialized) {
            this.init();
        }
        return this.directory.hasNext();
    }

    public VfsEntry next() throws IOException {
        return this.directory.next();
    }

    public void dispose() throws IOException {
        this.directory.dispose();
        this.tempDir.delete();
    }

    protected void runCommand(String[] command) throws IOException {
        this.runCommand(command, null);
    }

    protected void runCommand(String[] command, File directory) throws IOException {
        this.runCommand(command, directory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runCommand(String[] command, File directory, OutputStream os) throws IOException {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(command, null, directory);
            process.getOutputStream().close();
            if (os != null) {
                SingleFileContainer.copyStream(process.getInputStream(), os);
            }
            process.waitFor();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }
}

