/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.vfs;

import java.io.File;
import java.io.IOException;
import org.openantivirus.engine.ScanConfiguration;

public class TemporaryDirectory {
    private final File tempDir;

    public TemporaryDirectory(ScanConfiguration scanConfiguration) {
        File dir;
        File baseDir = new File(scanConfiguration.getString("engine.tempdirectory"));
        long id = System.currentTimeMillis();
        while (!(dir = new File(baseDir, Long.toString(id++))).mkdir()) {
        }
        this.tempDir = dir;
    }

    public File getDirectory() {
        return this.tempDir;
    }

    public void delete() throws IOException {
        this.delete(this.tempDir);
    }

    protected void delete(File directory) throws IOException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    this.delete(file);
                }
                file.delete();
            }
        }
        directory.delete();
    }
}

