/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.credo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.openantivirus.engine.censor.MalwareFoundException;
import org.openantivirus.engine.censor.PositionFoundEvent;
import org.openantivirus.engine.censor.PositionFoundListener;
import org.openantivirus.engine.censor.StringFinder;
import org.openantivirus.engine.credo.WildcardPattern;

public class StringsParser {
    private final StringFinder stringFinder;

    public StringsParser(StringFinder stringFinder) {
        this.stringFinder = stringFinder;
    }

    public void parse(Reader patternReader) throws IOException {
        String sLine;
        BufferedReader br = new BufferedReader(patternReader);
        while ((sLine = br.readLine()) != null) {
            this.parseLine(sLine);
        }
    }

    private void parseLine(String line) {
        int equalsPos = line.indexOf(61);
        if (equalsPos == -1) {
            System.err.println("Malformed pattern line: " + line);
            return;
        }
        int offsetStart = line.lastIndexOf(91);
        String sPattern = line.substring(equalsPos + 1);
        StringFoundListener pfl = new StringFoundListener(new String(line.substring(0, offsetStart)));
        try {
            if (sPattern.indexOf(42) != -1) {
                this.stringFinder.addMultipartString(sPattern, line.substring(offsetStart + 1, equalsPos - 1), pfl);
            } else {
                int offset = Integer.parseInt(line.substring(offsetStart + 1, equalsPos - 1));
                if (sPattern.indexOf(63) != -1) {
                    this.stringFinder.addWildcardString(new WildcardPattern(sPattern), offset, pfl);
                } else {
                    this.stringFinder.addString(sPattern, offset, pfl);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Malformed pattern line: " + line);
            e.printStackTrace();
        }
    }

    private static class StringFoundListener
    implements PositionFoundListener {
        private final String virusName;

        public StringFoundListener(String virusName) {
            this.virusName = virusName;
        }

        public void positionFound(PositionFoundEvent pfe) throws MalwareFoundException {
            throw new MalwareFoundException(this.virusName, pfe.entry);
        }
    }
}

