/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.credo;

import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.openantivirus.engine.credo.CredoEntry;
import org.openantivirus.engine.credo.CredoException;

public class CredoVerifier {
    public static final String VERSION = "$Id: CredoVerifier.java,v 1.1 2003/12/14 11:08:26 kurti Exp $";
    public static final int SIGNATURE_LEVELS = 4;
    private static final String CERTIFICATE_PATH = "/oav.cer";
    private static final String CERTIFICATE_TYPE = "X.509";
    private static final Certificate[] oavCertificate = new Certificate[4];
    private static final PublicKey[] oavPublicKey = new PublicKey[4];
    static /* synthetic */ Class class$org$openantivirus$engine$credo$CredoEntry;

    public static int verify(CredoEntry credoEntry) throws CredoException {
        Certificate[] certificates = credoEntry.getJarEntry().getCertificates();
        if (certificates == null) {
            throw new CredoException("No signature found or entry not fully read");
        }
        int verifiedLevel = -1;
        block2: for (int i = 0; i < certificates.length; ++i) {
            int level;
            for (level = 0; level < 4; ++level) {
                if (certificates[i].equals(oavCertificate[level])) continue block2;
            }
            for (level = 0; level < 4; ++level) {
                try {
                    certificates[i].verify(oavPublicKey[level]);
                    System.out.println("  signed by '" + ((X509Certificate)certificates[i]).getSubjectDN() + "'");
                    verifiedLevel = level;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (verifiedLevel == -1) {
            throw new CredoException("No valid signing certificate found");
        }
        return verifiedLevel + 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        for (int level = 0; level < 4; ++level) {
            try {
                InputStream is = (class$org$openantivirus$engine$credo$CredoEntry == null ? CredoVerifier.class$("org.openantivirus.engine.credo.CredoEntry") : class$org$openantivirus$engine$credo$CredoEntry).getResourceAsStream("/oav.cer.level" + (level + 1));
                CertificateFactory cf = CertificateFactory.getInstance(CERTIFICATE_TYPE);
                CredoVerifier.oavCertificate[level] = cf.generateCertificate(is);
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                CredoVerifier.oavPublicKey[level] = oavCertificate[level].getPublicKey();
                continue;
            }
            catch (CertificateException ce) {
                ce.printStackTrace();
            }
        }
    }
}

