/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.credo;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.openantivirus.engine.ScanConfiguration;
import org.openantivirus.engine.censor.StringFinder;
import org.openantivirus.engine.censor.StringSearch;
import org.openantivirus.engine.credo.CredoEntry;
import org.openantivirus.engine.credo.CredoException;
import org.openantivirus.engine.credo.CredoFile;
import org.openantivirus.engine.credo.CredoVerifier;
import org.openantivirus.engine.credo.StringsParser;

public class CredoParser {
    public static final String VERSION = "$Id: CredoParser.java,v 1.2 2004/05/19 07:33:40 kurti Exp $";
    public static final int NO_VERIFY = -1;
    public static final int DEFAULT_LEVEL = 3;
    private final ScanConfiguration scanConfiguration;
    private final StringsParser stringsParser;

    public CredoParser(ScanConfiguration scannerConfiguration, StringSearch stringSearch) {
        this.scanConfiguration = scannerConfiguration;
        this.stringsParser = new StringsParser(new StringFinder(stringSearch));
    }

    public void parse(File file) throws CredoException, IOException {
        if (file.isDirectory()) {
            File[] afFiles = file.listFiles(new FilenameFilter(){

                public boolean accept(File directory, String name) {
                    return name.endsWith(".credo");
                }
            });
            for (int i = 0; i < afFiles.length; ++i) {
                this.parse(afFiles[i]);
            }
        } else {
            this.doParse(new CredoFile(file));
        }
    }

    public void parse(InputStream is) throws CredoException, IOException {
        this.doParse(new CredoFile(is));
    }

    protected void doParse(CredoFile credoFile) throws CredoException, IOException {
        Iterator it = credoFile.entries();
        while (it.hasNext()) {
            CredoEntry credoEntry = (CredoEntry)it.next();
            System.out.println("Reading '" + credoEntry.getJarEntry().getName() + "'...");
            switch (credoEntry.getType()) {
                case 1: {
                    this.stringsParser.parse(new InputStreamReader(credoEntry.getInputStream()));
                    break;
                }
                default: {
                    throw new CredoException("Unknown CredoEntry-type: " + credoEntry.getType());
                }
            }
            int verifyLevel = this.scanConfiguration.getInt("credo.level");
            if (verifyLevel == -1) continue;
            int credoLevel = CredoVerifier.verify(credoEntry);
            if (credoLevel < verifyLevel) {
                throw new CredoException("Minimum Credo-level " + verifyLevel + " > actual Credo-level " + credoLevel);
            }
            System.out.println("  verified Credo-level " + credoLevel);
        }
    }
}

