/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.credo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.jar.JarInputStream;
import org.openantivirus.engine.credo.CredoEntryIterator;
import org.openantivirus.engine.credo.CredoException;

public class CredoFile {
    public static final String VERSION = "$Id: CredoFile.java,v 1.1 2003/12/14 11:08:26 kurti Exp $";
    public static final String EXTENSION = ".credo";
    private final JarInputStream jarInputStream;

    public CredoFile(File file) throws CredoException {
        if (!file.exists()) {
            this.jarInputStream = null;
            throw new CredoException("Credo-File does not exist");
        }
        if (!file.isFile()) {
            this.jarInputStream = null;
            throw new CredoException("Credo-File is not a file");
        }
        try {
            this.jarInputStream = new JarInputStream(new FileInputStream(file));
        }
        catch (IOException ioe) {
            throw new CredoException(ioe.getMessage());
        }
    }

    public CredoFile(InputStream is) throws CredoException {
        if (is == null) {
            throw new CredoException("Credo-File not found");
        }
        try {
            this.jarInputStream = new JarInputStream(is);
        }
        catch (IOException ioe) {
            throw new CredoException(ioe.getMessage());
        }
    }

    public Iterator entries() {
        return new CredoEntryIterator(this.jarInputStream);
    }
}

